grammar Delphi;

options {
    backtrack=true;
    memoize=true;
    output=AST;
}

@header
{
/*
 * Sonar Delphi Plugin
 * Copyright (C) 2010 SonarSource
 * dev@sonar.codehaus.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */

package org.sonar.plugins.delphi.antlr;

/**
* Delphi Parser class generated by Antlr. Provides tokens and tree parsing methods.
**/
}

@lexer::header
{
/*
 * Sonar Delphi Plugin
 * Copyright (C) 2010 SonarSource
 * dev@sonar.codehaus.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */

package org.sonar.plugins.delphi.antlr;

/**
* Delphi Lexer class generated by Antlr. Provides tokens.
**/
}

@lexer::members {
  private boolean isControlchar() {
    // TODO 
    //  - check if there are actually 2 chars ahead and not an EOF
    //  - perhaps something else than a regex match here
    return ((char)input.LA(1) + "" + (char)input.LA(2)).matches("\\w\\W");
  }
}

//****************************
//section start
//****************************
file                         : program | library | unit | packageE
                             ;
//****************************
//section fileDefinition
//****************************

program                      : (programHead)? (usesFileClause)? block '.'
                             ;
programHead                  : 'program' namespaceName (programParmSeq)? ';'
                             ;
programParmSeq               : '(' (ident (',' ident)* )? ')'
                             ;
library                      : libraryHead (usesFileClause)? block '.'
                             ;
libraryHead                  : 'library' namespaceName (hintingDirective)* ';' -> ^('library' namespaceName)
                             ;
packageE                     : packageHead requiresClause (containsClause)? 'end' '.'
                             ;
packageHead                  : 'package' namespaceName ';'
                             ;
unit                         : unitHead unitInterface unitImplementation unitBlock '.'
                             ;
unitHead                     : 'unit' namespaceName (hintingDirective)* ';' -> ^('unit' namespaceName (hintingDirective)*)
                             ;
unitInterface                : 'interface' (usesClause)? (interfaceDecl)* -> ^('interface' (usesClause)? (interfaceDecl)*)
                             ;
unitImplementation           : 'implementation' (usesClause)? (declSection)* -> ^('implementation' (usesClause)? (declSection)*)
                             ;
unitBlock                    : unitInitialization 'end'
                             | compoundStatement
                             | 'end'
                             ;
unitInitialization           : 'initialization' statementList (unitFinalization)?
                             ;
unitFinalization             : 'finalization' statementList
                             ;
//****************************
//section fileUsage
//****************************
containsClause               : 'contains' namespaceFileNameList
                             ;
requiresClause               : 'requires' namespaceNameList
                             ;
usesClause                   : 'uses' namespaceNameList -> ^('uses' namespaceNameList)
                             ;
usesFileClause               : 'uses' namespaceFileNameList -> ^('uses' namespaceFileNameList)
                             ;
namespaceFileNameList        : namespaceFileName (',' namespaceFileName)* ';' -> namespaceFileName (namespaceFileName)*
                             ;
namespaceFileName            : namespaceName ('in' QuotedString)? -> ^(namespaceName (QuotedString)?)
                             ;
namespaceNameList            : namespaceName (',' namespaceName)* ';' -> namespaceName (namespaceName)*
                             ;
//****************************
//section declaration
//****************************
block                        : (declSection)* (blockBody)?
                             ;
blockBody                    : compoundStatement
                             | assemblerStatement
                             ;
declSection                  : labelDeclSection
                             | constSection
                             | typeSection
                             | varSection
                             | methodDecl
                             | procDecl
                             | exportsSection
                             ;
interfaceDecl                : constSection
                             | typeSection
                             | varSection
                             | exportedProcHeading
                             | exportsSection
                             | procDecl
                             | methodDecl
                             ;
labelDeclSection             : 'label' label (',' label)* ';'
                             ;
constSection                 : constKey (constDeclaration)* -> ^(constKey (constDeclaration)*)  //CHANGED, erased one constDeclaration, for: "const {$include versioninfo.inc }"
                             ;
constKey                     : 'const'
                             | 'resourcestring'
                             ;
constDeclaration             : (customAttribute)? ident (':' typeDecl)? '=' constExpression (hintingDirective)* ';' -> ident (typeDecl)? '=' constExpression
                             ;
typeSection                  : 'type' typeDeclaration (typeDeclaration)* -> ^('type' typeDeclaration (typeDeclaration)*)
                             ;
typeDeclaration              : (customAttribute)? genericTypeIdent '=' typeDecl (hintingDirective)* ';' -> ^(TkNewType (customAttribute)? ^(genericTypeIdent typeDecl (hintingDirective)*))
                             ;
varSection                   : varKey varDeclaration (varDeclaration)* -> ^(varKey varDeclaration (varDeclaration)*)
                             ;
varKey                       : 'var'
                             | 'threadvar'
                             ;
// threadvar geen initializations alleen globaal
varDeclaration               : (customAttribute)? identListFlat ':' typeDecl (varValueSpec)? (hintingDirective)* ';' -> (customAttribute)? ^(TkVariableIdents identListFlat) ^(TkVariableType typeDecl)
                             ;
inlineVarDeclaration         : 'var' ident (':' typeDecl)? ':=' expression
                             | 'var' ident ':' typeDecl 
                             ; 
varValueSpec                 : 'absolute' qualifiedIdent
                             | 'absolute' constExpression
                             | '=' constExpression
                             ;
exportsSection               : 'exports' ident exportItem (',' ident exportItem)* ';'
                             ;
exportItem                   : ('(' (formalParameterList)? ')')? (INDEX expression)? (NAME expression)? ('resident')?
                             ;
//****************************
//section type
//****************************
typeDecl                     : strucType
                             | pointerType
                             | stringType
                             | procedureType
                             | variantType
                             | subRangeType
                             | ('type')? typeId (genericPostfix)? ('.' typeDecl)* (paranthesePostfix)?
                             | simpleType                             
                             ;
strucType                    : ('packed')? strucTypePart -> strucTypePart
                             ;
strucTypePart                : arrayType
                             | setType
                             | fileType
                             | classDecl
                             ;

arrayType                    :  'array' ('[' (arrayIndex)? (',' (arrayIndex)?)* ']')? 'of' arraySubType
                             -> ^(arraySubType 'array' ('[' (arrayIndex)? (',' (arrayIndex)?)* ']')? )          //CHANGED we only need type info
                             ;

arrayIndex                   : typeId
                             | expression '..' expression
                             ;

arraySubType                 : 'const'
                             | typeDecl
                             ;
setType                      : 'set' 'of' typeDecl -> 'set' typeDecl          //CHANGED we only need type info
                             ;
// set type alleen ordinal of subrange type
fileType                     : 'file' ('of' typeDecl)?
                             ;
pointerType                  : '^' typeDecl
                             | 'pointer'
                             ;
stringType                   : 'string' ('[' expression ']')? -> 'string'
                             | ('type')? ANSISTRING (codePageNumber)?
                             ;
codePageNumber               : '(' intNum ')'
                             ;
procedureType                : methodType
                             | simpleProcedureType
                             | procedureReference
                             ;
methodType                   : procedureTypeHeading 'of' 'object'
                             ;
simpleProcedureType          : procedureTypeHeading ( (';')? callConventionNoSemi)?
                             ;
procedureReference           : 'reference' 'to' procedureTypeHeading
                             ;
procedureTypeHeading         : 'function' (formalParameterSection)? ':' (customAttribute)? typeDecl -> 'function' (formalParameterSection)? ^(TkFunctionReturn typeDecl)
                             | 'procedure' (formalParameterSection)?
                             ;
variantType                  : 'variant' // SzJ TODO TEMP
                             ;
simpleType                   : ident
                             | enumType
                             ;
subRangeType                 : constExpression '..' constExpression
                             ;
enumType                     : '(' ident ('=' expression)? (',' ident ('=' expression)? )* ')'
                             ;
typeId                       : qualifiedIdent
                             ;
//****************************
//section generics
//****************************
genericTypeIdent             : qualifiedIdent (genericDefinition)? -> qualifiedIdent    //CHANGED we don't need <Type> data, it produced empty nodes
                             ;
genericDefinition           : '<' innerGeneric (';' innerGeneric)* '>'
                             ;
innerGeneric                 : genericTypeIdent (',' genericTypeIdent)* (':' genericConstraint (',' genericConstraint)*)?
                             ;
genericConstraint            : genericTypeIdent
                             | 'record'
                             | 'class'
                             | 'constructor'
                             ;
genericPostfix               : '<' typeDecl (',' typeDecl)* '>'
                             ;
paranthesePostfix            :	'(' intRealNum ')'	//Only used for "type AnsiString(1252)"
                             ;
//****************************
//section class
//****************************
classDecl                    : classTypeTypeDecl
                             | classHelperDecl -> ^(TkClass classHelperDecl)
                             | classTypeDecl -> ^(TkClass classTypeDecl)
                             | interfaceTypeDecl -> ^(TkInterface interfaceTypeDecl)
                             | objectDecl -> ^(TkObject objectDecl)
                             | recordDecl -> ^(TkRecord recordDecl)
                             | recordHelperDecl -> ^(TkRecordHelper recordHelperDecl)
                             ;
classTypeTypeDecl            : 'class' 'of' typeId -> ^(TkClassOfType typeId)
                             ;
classTypeDecl                : 'class' (classState)? (classParent)? (classItem)* 'end' -> 'class' ^(TkClassParents (classParent)?) (classItem)*
                             | 'class' (classState)? (classParent)? -> 'class' ^(TkClassParents (classParent)?) //added optional class state
                             ;
classState                   : 'sealed'
                             | 'abstract'
                             ;
classParent                  : '(' genericTypeIdent (',' genericTypeIdent)* ')' -> genericTypeIdent (genericTypeIdent)*   //CHANGEd from typeId to classParentId
                             ;
classItem                    : visibility
                             | classMethod
                             | classField
                             | classProperty
                             | constSection
                             | typeSection
                             | ('class')? varSection
                             ;
classHelperDecl              : 'class' 'helper' (classParent)? 'for' typeId (classHelperItem)* 'end' -> ^('class' typeId ) (classHelperItem)* //CHANGED, we only need "for" class name
                             ;
classHelperItem              : visibility
                             | classMethod
                             | classProperty
                             | constSection
                             | typeSection
                             | ('class')? varSection
                             ;
interfaceTypeDecl            : interfaceKey (classParent)? (interfaceGuid)? (interfaceItem)* 'end'
                              -> interfaceKey ^(TkClassParents (classParent)? ) ^(TkGuid (interfaceGuid)?) (interfaceItem)*
                             | interfaceKey (classParent)?
                              -> interfaceKey ^(TkClassParents (classParent)?)
                             ;
interfaceKey                 : 'interface'
                             | 'dispinterface'
                             ;
interfaceGuid                : '[' QuotedString ']' -> QuotedString
                             ;
interfaceItem                : classMethod
                             | ('class')? classProperty
                             ;
objectDecl                   : 'object' (classParent)? (objectItem)* 'end' -> 'object' (classParent)? (objectItem)*
                             ;
objectItem                   : visibility
                             | classMethod
                             | classField
                             ;
recordDecl                   : simpleRecord
                             | variantRecord
                             ;
simpleRecord                 : 'record' (recordField)* (recordItem)* 'end' -> 'record' (recordField)* (recordItem)*
                             ;
variantRecord                : 'record' (recordField)* (recordItem)* recordVariantSection 'end' -> 'record' (recordField)* (recordItem)* recordVariantSection
                             ;
recordItem                   : visibility     //ADDED
                             | classMethod
                             | classProperty
                             | constSection
                             | typeSection
                             | recordField
                             | ('class')? varSection
                             ;
recordField                  : identList ':' typeDecl (hintingDirective)* (';')?  //CHANGED not needed ; at the end
                             -> identList ^(TkVariableType typeDecl)
                             ;
recordVariantField           : identList ':' typeDecl (hintingDirective)* (';') ?
                             -> identList ^(TkVariableType typeDecl)
                             ;
recordVariantSection         : 'case' (ident ':')? typeDecl 'of' (recordVariant | ';') (recordVariant | ';')*
                             ;
recordVariant                : constExpression (',' constExpression)* ':' '(' (recordVariantField)* ')'   //CHANGED to recordVariantField from recordField
                             ;
recordHelperDecl             : 'record' 'helper' 'for' typeId (recordHelperItem)* 'end'
                             ;
recordHelperItem             : visibility
                             | constSection
                             | classMethod
                             | classProperty
                             | ('class')? varSection
                             ;
classMethod                  : (customAttribute)? ('class')? methodKey ident (genericDefinition)? (formalParameterSection)? ';' (methodDirective)* 
                             ->  (customAttribute)? ('class')? ^(methodKey ^(TkFunctionName ident) (genericDefinition)? ^(TkFunctionArgs (formalParameterSection)?) (methodDirective)*)
                             | (customAttribute)? ('class')? 'function' ident (genericDefinition)? (formalParameterSection)? ':' (customAttribute)? typeDecl ';' (methodDirective)*
                             -> (customAttribute)? ('class')? ^('function' ^(TkFunctionName ident) (genericDefinition)? ^(TkFunctionArgs (formalParameterSection)?) (customAttribute)? ^(TkFunctionReturn typeDecl) (methodDirective)*)
                             | (customAttribute)? ('class')? 'operator' ident (genericDefinition)? (formalParameterSection)? ':' (customAttribute)? typeDecl ';' (methodDirective)* 
                             -> (customAttribute)? ('class')? ^('operator' ^(TkFunctionName ident) (genericDefinition)? ^(TkFunctionArgs (formalParameterSection)?) (customAttribute)? typeDecl (methodDirective)*)
                             | (customAttribute)? ('class')? 'function' ident (genericDefinition)? '.' ident '=' ident ';'
                             | (customAttribute)? ('class')? 'procedure' ident (genericDefinition)? '.' ident '=' ident ';'
                             ;
classField                   : (customAttribute)? identList ':' typeDecl (hintingDirective)*  ';'
                             -> (customAttribute)? ^(TkClassField ^(TkVariableIdents identList) ^(TkVariableType typeDecl))
                             ;
classProperty                : (customAttribute)? ('class')? 'property' ident (classPropertyArray)? (':' genericTypeIdent)? (classPropertyIndex)? (classPropertySpecifier)* ';' (classPropertyEndSpecifier)*
                              -> ^('property' ^(TkVariableIdents ident) ^(TkVariableType genericTypeIdent?) (classPropertySpecifier)* )
                              // CHANGED added (classPropertySpecifier)* at end for "default;"
                              // CHANGEDD to genericTypeIdent for "property QueryBuilder : IQueryBuilder<GenericRecord>"
                             ;
classPropertyArray           : '[' formalParameterList ']'
                             ;
classPropertyIndex           : 'index' expression (';')?  //CHANGED to (';')?
                             ;
classPropertySpecifier       : classPropertyReadWrite   //CHANGED removed ';'
                             | classPropertyDispInterface
                             | STORED expression
                             | 'default' expression
                             | 'default'                // for array properties only (1 per class)
                             | 'nodefault'
                             | IMPLEMENTS genericTypeIdent
                             ;
classPropertyEndSpecifier    : STORED expression ';'    //ADDED used in classProperty at end
                             | 'default' expression ';'
                             | 'default' ';'
                             | 'nodefault' ';'
                             ;

classPropertyReadWrite       : 'read' qualifiedIdent ('[' expression ']')?  // Waarom qualified ident???  //ADDED []
                             -> ^('read' qualifiedIdent)
                             | 'write' qualifiedIdent ('[' expression ']')? //ADDED []
                             -> ^('write' qualifiedIdent)
                             ;
classPropertyDispInterface   : 'readonly' ';'
                             | 'writeonly' ';'
                             | dispIDDirective
                             ;
visibility                   : (STRICT)? 'protected'
                             | (STRICT)? 'private'
                             | 'public'
                             | 'published'
                             | 'automated'     // win32 deprecated
                             ;
//****************************
//section procedure
//****************************
exportedProcHeading          : 'procedure' ident (formalParameterSection)? ':' (customAttribute)? typeDecl ';' (functionDirective)*
                             | 'function' ident (formalParameterSection)? ';' (functionDirective)*
                             ;
methodDecl                   : methodDeclHeading ';' (methodDirective)* (methodBody)? -> methodDeclHeading (methodBody)?
                             ;
methodDeclHeading            : (customAttribute)? ('class')?  methodKey methodName (formalParameterSection)?
                             -> (customAttribute)? ('class')?  ^(methodKey ^(TkFunctionName methodName) ^(TkFunctionArgs (formalParameterSection)?) )
                             | (customAttribute)? ('class')? 'function' methodName (formalParameterSection)? (':' (customAttribute)? typeDecl)?
                             -> (customAttribute)? ('class')? ^('function' ^(TkFunctionName methodName) ^(TkFunctionArgs (formalParameterSection)?) ^(TkFunctionReturn (customAttribute)? typeDecl?) )
                             | (customAttribute)? 'class' 'operator' methodName (formalParameterSection)? (':' (customAttribute)? typeDecl)?
                             -> (customAttribute)? 'class' ^('operator' ^(TkFunctionName methodName) ^(TkFunctionArgs (formalParameterSection)?) ^(TkFunctionReturn (customAttribute)? typeDecl?) )
                             ;
methodKey                    : 'procedure'
                             | 'constructor'
                             | 'destructor'
                             ;
methodName                   : ident (genericDefinition)? ('.' ident (genericDefinition)?)*
                             ;
procDecl                     : procDeclHeading ';' (functionDirective)* (procBody)? -> procDeclHeading (procBody)?    //CHANGED
                             ;
procDeclHeading              : (customAttribute)? 'procedure' ident (formalParameterSection)?             //CHANGED
                             -> ^('procedure' ^(TkFunctionName ident) ^(TkFunctionArgs (formalParameterSection)?) )
                             | (customAttribute)? 'function' ident (formalParameterSection)? ':' typeDecl
                             -> ^('function' ^(TkFunctionName ident) ^(TkFunctionArgs (formalParameterSection)?) ^(TkFunctionReturn typeDecl) )
                             ;
formalParameterSection       : '(' (formalParameterList)? ')' -> (formalParameterList)?
                             ;
formalParameterList          : formalParameter (';' formalParameter)* -> formalParameter (formalParameter)*
                             ;
formalParameter              : (customAttribute)? (parmType)? identListFlat (':' typeDecl)? ('=' expression)? -> (customAttribute)? ^(TkVariableIdents identListFlat) ^(TkVariableType typeDecl?) ^(TkVariableParam parmType)?
               //expressions was cut out, beacause we dont have to know default variable values; they were causing troubles with DelphiCodeAnalyser
                             ;
parmType                     : 'const'
                             | 'var'
                             | 'out'
                             ;
methodBody                   : block ';' -> block
                             ;
procBody                     : 'forward' ';' (functionDirective)*   // CHECKEN ; en directive plaats!
                             | 'external' ('name' expression | 'index' expression)* (functionDirective)* // CHECKEN directive plaats
                             | block ';'
                             ;
//****************************
//section customAttributes
//****************************
customAttribute              : customAttributeList
                             ;
customAttributeList          : (customAttributeDecl)*
                             ;
customAttributeDecl          : '[' customAttributeIdent ('(' (expressionList)? ')')? ']'  -> ^(TkCustomAttribute '[' customAttributeIdent ('(' (expressionList)? ')')? ']')
                             ;
customAttributeIdent         : qualifiedIdent (':' qualifiedIdent)?
                             ;
//****************************
//section expression
//****************************
expression                   : anonymousExpression -> ^(TkAnonymousExpression anonymousExpression)
                             | simpleExpression (relOp simpleExpression)? ('=' expression)?   //CHANGED, added expression for: "if( functionCall(x, 7+66) = true ) then" syntax
                             ;
anonymousExpression          : 'procedure' (formalParameterSection)? block
                             | 'function' (formalParameterSection)? ':' typeDecl block
                             ;
simpleExpression             : factor (operator factor)*
                             ;
factor                       : '@' factor
                             | '@@' factor       // used to get address of proc var
                             | 'not' factor
                             | '+' factor
                             | '-' factor
                             | '^' ident           // geeft volgnummer van letter
                             | intRealNum
                             | 'true'
                             | 'false'
                             | 'nil'
                             | 'nil^'                                             // Used to pass nil as var paramter value
                             | '(' expression ')' designator
                             | '(' expression ')' ('^')? ('.' expression)?        //CHANGED, added  ('^')? ('.' qualifiedIdent)?
                             | stringFactor ('.' simpleExpression)?
                             | setSection
                             | designator
                             | typeId '(' expression ')'
                             ;
stringFactor                 : (controlString) (QuotedString (controlString))* (QuotedString)?
                             | QuotedString ((controlString) QuotedString)* (controlString)?
                             ;
controlString                : ControlChar (ControlChar)*
                             ;
setSection                   : '[' (expression ((',' | '..') expression)*)? ']'
                             ;

designator                   : ('Inherited')? ('inherited')? ( (qualifiedIdent | typeId) )? (designatorItem)*
                             ;
designatorItem               : '^'
                             | '^^'
                             | ('.' | '@') ident              //CHANGED added '@'
                             | ('<' genericTypeIdent (',' genericTypeIdent)* '>')       //ADDED for proc<sth, sth>.foo;
                             | '[' expressionList ']'
                             | '(' (expression (colonConstruct)? (',' expression (colonConstruct)?)*)? ')' -> '(' (expression (colonConstruct)? (expression (colonConstruct)?)*)? ')'
                             ;
expressionList               : expression (',' expression)*
                             ;
colonConstruct               : ':' expression (':' expression)?
                             ;
// Alleen voor Write/WriteLn.
operator                     : '+'
                             | '-'
                             | 'or'
                             | 'OR'
                             | 'xor'
                             | 'XOR'
                             | '*'
                             | '/'
                             | 'div'
                             | 'DIV'
                             | 'mod'
                             | 'MOD'
                             | 'and'
                             | 'AND'
                             | 'shl'
                             | 'SHL'
                             | 'shr'
                             | 'SHR'
                             | 'as'
                             | 'AS'
                             ;
relOp                        : '<'
                             | '>'
                             | '<='
                             | '>='
                             | '<>'
                             | '='
                             | 'in'
                             | 'is'
                             ;
//****************************
//section statement
//****************************

statement                    : ifStatement
                             | caseStatement
                             | repeatStatement
                             | whileStatement
                             | forStatement
                             | withStatement
                             | tryStatement
                             | raiseStatement
                             | assemblerStatement
                             | compoundStatement
                             | label ':' statement
                             | simpleStatement
                             ;
ifStatement                  : 'if' expression 'then' statement ('else' statement)?
                             ;
caseStatement                : 'case' expression 'of' (caseItem)* ('else' statementList (';')?)? 'end'
                             ;
caseItem                     : caseLabel (',' caseLabel)* ':' statement (';')? // checken of ; sep of scheider is
                             ;
caseLabel                    : expression ('..' expression)?
                             ;
repeatStatement              : 'repeat' (statementList)? 'until' expression
                             ;
whileStatement               : 'while' expression 'do' statement
                             ;
forStatement                 : 'for' ('var')? designator (':' typeDecl)? ':=' expression 'to' expression 'do' statement
                             | 'for' ('var')? designator (':' typeDecl)? ':=' expression 'downto' expression 'do' statement
                             | 'for' ('var')? designator (':' typeDecl)? 'in' expression 'do' statement
                             ;
withStatement                : 'with' withItemList 'do' statement
                             ;
withItemList                 : withItem (',' withItem)*
                             ;
withItem                     : designator ('as' designator)?
                             ;
compoundStatement            : 'begin' (statementList)? 'end' -> ^('begin' (statementList)? 'end')
                             ;
statementList                : (statement)? (';' (statement)?)*
                             ;
simpleStatement              : designator ':=' expression
                             | designator // call
                             | gotoStatement
                             | inlineVarDeclaration
                             ;
gotoStatement                : 'goto' label
                             | 'exit' ('(' expression ')')?
                             | 'break'
                             | 'continue'
                             ;
//****************************
//section constExpression
//****************************
constExpression              : '(' recordConstExpression (';' recordConstExpression)* ')' //CHANGED reversed order
                             | '(' constExpression (',' constExpression)* ')' (constExpression)? //matches array inititialization and expressions such as (1 + 2); last constExpression matches (1 * 2) + 3
                             | expression
                             ;
recordConstExpression        : ident ':' constExpression (';')?
                             ;
//****************************
//section exceptionStatement
//****************************
tryStatement                 : 'try' (statementList)? 'except' handlerList 'end'
                             | 'try' (statementList)? 'finally' (statementList)? 'end'
                             ;
handlerList                  : (handler)* ('else' statementList)?
                             | statementList
                             ;
handler                      : 'on' (handlerIdent)? typeId 'do' handlerStatement  //CHANGED - ; is not required ; handlerIdent not required, example:  "on einvalidoperation do;"
                             ;
handlerIdent                 : ident ':'
                             ;
handlerStatement             : statement (';')?
                             | ';'
                             ;
raiseStatement               : 'raise' (designator)? (AT designator)? // CHECKEN!
                             ;
//****************************
//section AssemblerStatement
//****************************
assemblerStatement           : 'asm' ~('end')* 'end'    //ADDED we don't realy care about assembler statements, since they don't contribute to
                             ;                //any measure, just skip, allow all
//****************************
//section directive
//****************************
methodDirective              : reintroduceDirective         // 1
                             | overloadDirective            // 2
                             | bindingDirective             // 3
                             | abstractDirective            // 3 virtual;
                             | inlineDirective              // 4 niet virtual or dynamic
                             | callConvention               // 4
                             | hintingDirective ';'         // 4 (niet abstract)
                             | oldCallConventionDirective   // 1
                             | dispIDDirective
                             | externalDirective
                             ;
functionDirective            : overloadDirective          // 1
                             | inlineDirective            // 1
                             | callConvention             // 1
                             | oldCallConventionDirective // 1
                             | hintingDirective ';'       // 1
                             | (callConventionNoSemi)? externalDirective          // 1
                             | externalDirective
                             | 'unsafe' ';'               // 1 .net?
                             ;
reintroduceDirective         : 'reintroduce' (';')?
                             ;
overloadDirective            : 'overload' (';')?    //CHANGE ; not needed
                             ;
bindingDirective             : 'message' expression ';'
                             | 'static' ';'
                             | 'dynamic' ';'
                             | 'override' ';'
                             | 'virtual' ';'
                             ;
abstractDirective            : 'abstract' ';'
                             | 'final' ';'
                             ;
inlineDirective              : 'inline' ';'
                             | 'assembler' ';' // deprecated
                             ;
callConvention               : 'cdecl' ';'    //
                             | 'pascal' ';'   //
                             | 'register' ';' //
                             | 'safecall' ';' //
                             | 'stdcall' ';'  //
                             | 'export' ';'   // deprecated
                             ;
callConventionNoSemi         : 'cdecl'    //    //ADDED for procedureType error fixing, without ';' at the end
                             | 'pascal'   //
                             | 'register' //
                             | 'safecall' //
                             | 'stdcall'  //
                             | 'export'   // deprecated
                             ;
oldCallConventionDirective   : 'far' ';'      // deprecated
                             | 'local' ';'    // niet in windows maakt functie niet exporteerbaar
                             | 'near' ';'     // deprecated
                             ;
hintingDirective             : 'deprecated' (stringFactor)?
                             | 'experimental'  // added 2006
                             | 'platform'
                             | 'library'
                             ;
externalDirective            : 'varargs' ';'   // alleen bij external cdecl
                             | 'external' ';'
                             | 'external' constExpression (externalSpecifier)* ('delayed')? ';' // expression : dll name
                             ;
externalSpecifier            : 'name' constExpression
                             | 'index' constExpression   // specific to a platform
                             ;
dispIDDirective              : 'dispid' expression ';'
                             ;
//****************************
////section general
//****************************
ident                        : TkIdentifier
                             | '&' TkIdentifier -> TkIdentifier
                             | '&' keywordsAsIdentifier -> keywordsAsIdentifier
                             | usedKeywordsAsNames
                             ;
usedKeywordsAsNames          : (ABSOLUTE | ADD | ANSISTRING | AT | BREAK | CONTAINS | CONTINUE | DEFAULT | DQ | DW | DISPID | EXIT | EXPORT)
                             | (FALSE | FINAL | HELPER | IMPLEMENTS | IN | INDEX | LOCAL | MESSAGE | NAME)
                             | (OBJECT | OUT | OPERATOR | POINTER | PUBLIC | PRIVATE | READ | READONLY | REFERENCE | REGISTER | REMOVE | STORED )
                             | (STRICT | STRING | STATIC | TRUE | UNSAFE | VARARGS | VARIANT | VIRTUAL | WRITE | WRITEONLY)
                             ;
keywordsAsIdentifier         : (ABSOLUTE | ABSTRACT | ADD | AND | ANSISTRING | ARRAY | AS | ASM | ASSEMBLER | ASSEMBLY)
                             | (AT | AUTOMATED | BEGIN | BREAK | CASE | CDECL | CLASS | CONST | CONSTRUCTOR | CONTAINS)
                             | (CONTINUE | DEFAULT | DEPRECATED | DESTRUCTOR | DISPID | DISPINTERFACE | DIV | DO | DOWNTO)
                             | (DQ | DW | DYNAMIC | ELSE | END | EXCEPT | EXIT | EXPERIMENTAL | EXPORT | EXPORTS | EXTERNAL)
                             | (FAR | FILE | FINAL | FINALIZATION | FINALLY | FOR | FORWARD | FUNCTION | GOTO | HELPER | IF)
                             | (IMPLEMENTATION | IMPLEMENTS | IN | INDEX | INHERITED | INITIALIZATION | INLINE | INTERFACE)
                             | (IS | LABEL | LIBRARY | LOCAL | MESSAGE | MOD | NAME | NEAR | NIL | NODEFAULT | NOT | OBJECT)
                             | (OF | ON | OPERATOR | OR | OUT | OVERLOAD | OVERRIDE | PACKAGE | PACKED | PASCAL | PLATFORM)
                             | (POINTER | PRIVATE | PROCEDURE | PROGRAM | PROPERTY | PROTECTED | PUBLIC | PUBLISHED | RAISE)
                             | (READ | READONLY | RECORD | REFERENCE | REGISTER | REINTRODUCE | REMOVE | REPEAT | REQUIRES)
                             | (RESIDENT | RESOURCESTRING | SAFECALL | SEALED | SET | SHL | SHR | STATIC | STDCALL | STORED)
                             | (STRICT | STRING | THEN | THREADVAR | TO | TRY | TYPE | UNIT | UNSAFE | UNTIL | USES | VAR)
                             | (VARARGS | VARIANT | VIRTUAL | WHILE | WITH | WRITE | WRITEONLY | XOR | FALSE | TRUE)
                             ;
identList                    : ident (',' ident)* -> ^(ident (ident)*)
                             ;
identListFlat                : ident (',' ident)* -> ident (ident)*   //ADDED used in formalParemeter
                             ;
label                        : TkIdentifier
                             | TkIntNum
                             | TkHexNum
                             | usedKeywordsAsNames
                             ;
intRealNum                   : TkRealNum
                             | intNum
                             ;
intNum                       : TkIntNum
                             | TkHexNum
                             ;
namespaceName                : ident ('.' ident)*
                             ;
qualifiedIdent               :  (ident '.')*  ident   //must stay the way it is, with '.' for proper class method identyfication
                             ;

// KEYWORDS
ABSOLUTE          : 'absolute'       ;
ABSTRACT          : 'abstract'       ;
ADD               : 'add'            ;
AND               : 'and'            ;
ANSISTRING        : 'ansistring'     ;
ARRAY             : 'array'          ;
AS                : 'as'             ;
ASM               : 'asm'            ;
ASSEMBLER         : 'assembler'      ;
ASSEMBLY          : 'assembly'       ;
AT                : 'at'             ;
AUTOMATED         : 'automated'      ;
BEGIN             : 'begin'          ;
BREAK             : 'break'          ;
CASE              : 'case'           ;
CDECL             : 'cdecl'          ;
CLASS             : 'class'          ;
CONST             : 'const'          ;
CONSTRUCTOR       : 'constructor'    ;
CONTAINS          : 'contains'       ;
CONTINUE          : 'continue'       ;
DEFAULT           : 'default'        ;
DELAYED           : 'delayed'        ;		 
DEPRECATED        : 'deprecated'     ;
DESTRUCTOR        : 'destructor'     ;
DISPID            : 'dispid'         ;
DISPINTERFACE     : 'dispinterface'  ;
DIV               : 'div'            ;
DO                : 'do'             ;
DOWNTO            : 'downto'         ;
DQ                : 'dq'             ;
DW                : 'dw'             ;
DYNAMIC           : 'dynamic'        ;
ELSE              : 'else'           ;
END               : 'end'            ;
EXCEPT            : 'except'         ;
EXIT              : 'exit'           ;
EXPERIMENTAL      : 'experimental'   ;
EXPORT            : 'export'         ;
EXPORTS           : 'exports'        ;
EXTERNAL          : 'external'       ;
FAR               : 'far'            ;
FILE              : 'file'           ;
FINAL             : 'final'          ;
FINALIZATION      : 'finalization'   ;
FINALLY           : 'finally'        ;
FOR               : 'for'            ;
FORWARD           : 'forward'        ;
FUNCTION          : 'function'       ;
GOTO              : 'goto'           ;
HELPER            : 'helper'         ;
IF                : 'if'             ;
IMPLEMENTATION    : 'implementation' ;
IMPLEMENTS        : 'implements'     ;
IN                : 'in'             ;
INDEX             : 'index'          ;
INHERITED         : 'inherited'      ;
INITIALIZATION    : 'initialization' ;
INLINE            : 'inline'         ;
INTERFACE         : 'interface'      ;
IS                : 'is'             ;
LABEL             : 'label'          ;
LIBRARY           : 'library'        ;
LOCAL             : 'local'          ;
MESSAGE           : 'message'        ;
MOD               : 'mod'            ;
NAME              : 'name'           ;
NEAR              : 'near'           ;
NIL               : 'nil'            ;
NODEFAULT         : 'nodefault'      ;
NOT               : 'not'            ;
OBJECT            : 'object'         ;
OF                : 'of'             ;
ON                : 'on'             ;
OPERATOR          : 'operator'       ;
OR                : 'or'             ;
OUT               : 'out'            ;
OVERLOAD          : 'overload'       ;
OVERRIDE          : 'override'       ;
PACKAGE           : 'package'        ;
PACKED            : 'packed'         ;
PASCAL            : 'pascal'         ;
PLATFORM          : 'platform'       ;
POINTER           : 'pointer'        ;
PRIVATE           : 'private'        ;
PROCEDURE         : 'procedure'      ;
PROGRAM           : 'program'        ;
PROPERTY          : 'property'       ;
PROTECTED         : 'protected'      ;
PUBLIC            : 'public'         ;
PUBLISHED         : 'published'      ;
RAISE             : 'raise'          ;
READ              : 'read'           ;
READONLY          : 'readonly'       ;
RECORD            : 'record'         ;
REFERENCE         : 'reference'      ;
REGISTER          : 'register'       ;
REINTRODUCE       : 'reintroduce'    ;
REMOVE            : 'remove'         ;
REPEAT            : 'repeat'         ;
REQUIRES          : 'requires'       ;
RESIDENT          : 'resident'       ;
RESOURCESTRING    : 'resourcestring' ;
SAFECALL          : 'safecall'       ;
SEALED            : 'sealed'         ;
SET               : 'set'            ;
SHL               : 'shl'            ;
SHR               : 'shr'            ;
STATIC            : 'static'         ;
STDCALL           : 'stdcall'        ;
STORED            : 'stored'         ;
STRICT            : 'strict'         ;
STRING            : 'string'         ;
THEN              : 'then'           ;
THREADVAR         : 'threadvar'      ;
TO                : 'to'             ;
TRY               : 'try'            ;
TYPE              : 'type'           ;
UNIT              : 'unit'           ;
UNSAFE            : 'unsafe'         ;
UNTIL             : 'until'          ;
USES              : 'uses'           ;
VAR               : 'var'            ;
VARARGS           : 'varargs'        ;
VARIANT           : 'variant'        ;
VIRTUAL           : 'virtual'        ;
WHILE             : 'while'          ;
WITH              : 'with'           ;
WRITE             : 'write'          ;
WRITEONLY         : 'writeonly'      ;
XOR               : 'xor'            ;
FALSE             : 'false'          ;
TRUE              : 'true'           ;

//----------------------------------------------------------------------------
// OPERATORS
//----------------------------------------------------------------------------
PLUS              : '+'   ;
MINUS             : '-'   ;
STAR              : '*'   ;
SLASH             : '/'   ;
ASSIGN            : ':='  ;
COMMA             : ','   ;
SEMI              : ';'   ;
COLON             : ':'   ;
EQUAL             : '='   ;
NOT_EQUAL         : '<>'  ;
LT                : '<'   ;
LE                : '<='  ;
GE                : '>='  ;
GT                : '>'   ;
LPAREN            : '('   ;
RPAREN            : ')'   ;
LBRACK            : '['   ; // line_tab[line]
LBRACK2           : '(.'  ; // line_tab(.line.)
RBRACK            : ']'   ;
RBRACK2           : '.)'  ;
POINTER2          : '^'   ;
AT2               : '@'   ;
DOT               : '.'   ;// ('.' {$setType(DOTDOT);})?  ;
DOTDOT            : '..'  ;
LCURLY            : '{'   ;
RCURLY            : '}'   ;

//****************************
//section token
//****************************
TkGlobalFunction        : 'FUNCTION_GLOBAL'
                        ;
TkFunctionName          : 'FUNCTION_NAME'
                        ;
TkFunctionArgs          : 'FUNCTION_ARGS'
                        ;
TkFunctionBody          : 'FUNCTION_BODY'
                        ;
TkFunctionReturn        : 'FUNCTION_RETURN'
                        ;
TkCustomAttribute       : 'CUSTOM_ATTRIBUTE'
                        ;
TkCustomAttributeArgs   : 'CUSTOM_ATTRIBUTE_ARGS'
                        ;
TkNewType               : 'NEW_TYPE'
                        ;
TkClass                 : 'CLASS'
                        ;
TkRecord                : 'RECORD_TYPE'
                        ;
TkRecordHelper          : 'RECORD_HELPER'
                        ;
TkInterface             : 'INTERFACE_TYPE'
                        ;
TkObject                : 'OBJECT_TYPE'
                        ;
TkClassOfType           : 'CLASS_OF_TYPE'
                        ;
TkVariableType          : 'VARIABLE_TYPE'
                        ;
TkVariableIdents        : 'VARIABLE_IDENTS'
                        ;
TkVariableParam         : 'VARIABLE_PARAM'
                        ;
TkGuid                  : 'INTERFACE_GUID'
                        ;
TkClassParents          : 'CLASS_PARENTS'
                        ;
TkClassField            : 'CLASS_FIELD'
                        ;
TkAnonymousExpression   : 'ANONYMOUS_EXPRESSION'
                        ;
TkIdentifier            : (Alpha | '_') (Alpha | Digit | '_')*
                        ;
TkIntNum                : Digitseq
                        ;
TkRealNum               : Digitseq ( ((DOT Digitseq)? (('e'|'E') ('+'|'-')? Digitseq)?) => (DOT Digitseq)? (('e'|'E') ('+'|'-')? Digitseq)? | () { $type = TkIntNum; } )
                        ;
TkHexNum                : '$' Hexdigitseq
                        ;
ControlChar             : '^' ( {isControlchar()}?=> Alpha
                            | {$type=POINTER2;}
                            )
                        | '#' Digitseq
                        | '#' '$' Hexdigitseq
                        ;
QuotedString            : '\'' ('\'\'' | ~('\''))* '\''   //taken from PASCAL grammar
                        ;
fragment
Alpha                   : 'a'..'z'
                        | 'A'..'Z'
                        | '\u0080'..'\uFFFE' ~('\uFEFF') //ADDED unicode support
                        ;
fragment
Digit                   : '0'..'9'
                        ;
fragment
Digitseq                : Digit (Digit)*
                        ;
fragment
Hexdigit                : Digit | 'a'..'f' | 'A'..'F'
                        ;
Hexdigitseq             : Hexdigit (Hexdigit)*
                        ;
COMMENT                 :  '//' ~('\n'|'\r')* '\r'? '\n'           {$channel=HIDDEN;}
                        |  '(*' ( options {greedy=false;} : . )* '*)'  {$channel=HIDDEN;}
                        |  '{' ( options {greedy=false;} : . )* '}'    {$channel=HIDDEN;}
                        ;
WS                      : (' '|'\t'|'\r'|'\n'|'\f')+ {$channel=HIDDEN;}
                        ;
UnicodeBOM              : '\uFEFF' {$channel=HIDDEN;}
                        ;

