// If sox is available on the host system we use it to adjust pitch and rate
// Otherwise, we pass the output unmodified to either paplay or aplay depending
// on what is available on the system.
const String modelTemplate = """
GenericExecuteSynth "if command -v sox > /dev/null; then\\
        PROCESS=\\'sox -r SAMPLE_RATE -c 1 -b 16 -e signed-integer -t raw - -t wav - tempo \$RATE pitch \$PITCH norm\\';\\
        if command -v paplay > /dev/null; then\\
            OUTPUT=\\'\$PLAY_COMMAND\\';\\
        else\\
            OUTPUT=\\'aplay\\';\\
        fi;\\
    elif command -v paplay > /dev/null; then\\
        PROCESS=\\'cat\\'; OUTPUT=\\'\$PLAY_COMMAND --raw --channels 1 --rate SAMPLE_RATE\\';\\
    else\\
        PROCESS=\\'cat\\'; OUTPUT=\\'aplay -t raw -c 1 -r SAMPLE_RATE -f S16_LE\\';\\
    fi;\\
    echo \\'\$DATA\\' | PIPER_PATH --model MODEL_PATH -s SUBVOICE --output_raw | \$PROCESS | \$OUTPUT;"
GenericRateAdd 1
GenericPitchAdd 1
GenericVolumeAdd 1
GenericRateMultiply 1
GenericPitchMultiply 1000
AddVoice "LANGUAGE" "MALE1" "Piper"
""";

const String sdConfigTemplate = """
###
### THIS CONFIG WAS GENERATED BY PIED
###

SymbolsPreproc "char"
SymbolsPreprocFile "gender-neutral.dic"
SymbolsPreprocFile "font-variants.dic"
SymbolsPreprocFile "symbols.dic"
SymbolsPreprocFile "emojis.dic"
SymbolsPreprocFile "orca.dic"
SymbolsPreprocFile "orca-chars.dic"
AddModule "piper" "sd_generic" "piper.conf"
DefaultModule "piper"
Include "clients/*.conf"
""";
