---
title: Rootstock
description: Smart Contracts on a Bitcoin Sidechain
source: https://github.com/ElementsProject/elementsproject.github.io/blob/master/source/sidechains/rootstock/index.md
edit: https://github.com/ElementsProject/elementsproject.github.io/edit/master/source/sidechains/rootstock/index.md
---
Rootstock is an open-source smart-contract platform that extends Bitcoin. The smart-contracts capability of rootstock enable numerous applications, such as micropayment channels, escrow services, crowdfunding, crypto-asset creation, decentralized remittances, IP protection, asset registry, voting systems, micro-lending, supply chain traceability, online reputation, digital identity, in-game currency, prediction markets and fair-playing.

To create a smart-contract platform, Rootstock implements a Turing-complete deterministic replicated virtual machine.  Also Rootstock provides an improved payment experience with near instant payment confirmation: it achieves currently 300 tps and confirms most payments in less than 20 seconds. The security of Rootstock is provided by the Bitcoin miners using the merged-mining technique. To be able to interact with Bitcoin, Rootstock implements a Bitcoin 2-Way peg (2WP).

The 2WP allows bitcoins to be transferred to and from Rootstock at a fixed conversion rate. Rootstock 2WP design is a hybrid drivechain+federation/sidechain. The sidechain functionality is provided by a state-full SPV node (including multisig-wallet) running in a smart-contract. Rootstock is also backwards-compatible with Ethereum, so Ethereum distributed applications (DApps) can be easily ported to Rootstock and achieve greater security, faster execution and greater interoperability with Bitcoin. Rootstock is being actively developed by RSK Labs Ltd., which was founded in 2015 and which has received private funding from key players in the FinTech industry and Bitcoin ecosystem.  The platform will be launched in Q3 2016. More information, including founder’s team, and white papers can be downloaded from http://www.rootstock.io/.
