﻿#region License
/* Copyright 2011, 2013 James F. Bellinger <http://www.zer7.com/software/hidsharp>

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing,
   software distributed under the License is distributed on an
   "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
   KIND, either express or implied.  See the License for the
   specific language governing permissions and limitations
   under the License. */
#endregion

namespace HidSharp.Reports.Units
{
    /// <summary>
    /// Defines the possible units of mass.
    /// </summary>
    public enum MassUnit
    {
        /// <summary>
        /// The unit system has no unit of mass.
        /// </summary>
        None,

        /// <summary>
        /// The unit of mass is the gram (occurs in the SI Linear and Rotation unit systems).
        /// </summary>
        Gram,

        /// <summary>
        /// The unit of mass is the slug (occurs in the English Linear and Rotation unit systems).
        /// </summary>
        Slug
    }
}
