import { Registry } from "@/registry/schema";

const componentsUi: Registry = {
  //Components (base)
  buttons: {
    name: "buttons",
    type: "components:ui",
    files: ["registry/components/edil-ozi/buttons.tsx"],
  },

  "base-inputs": {
    name: "base-inputs",
    type: "components:ui",
    files: ["registry/components/edil-ozi/base-inputs.tsx"],
  },

  checkboxes: {
    name: "checkboxes",
    type: "components:ui",
    files: ["registry/components/edil-ozi/checkboxes.tsx"],
  },

  "toggle-inputs": {
    name: "toggle-inputs",
    type: "components:ui",
    files: ["registry/components/edil-ozi/toggle-inputs.tsx"],
  },

  //Clean Components
  accordion: {
    name: "accordion",
    type: "components:ui",
    files: ["registry/components/edil-ozi/accordion.tsx"],
  },

  drawer: {
    name: "drawer",
    type: "components:ui",
    files: ["registry/components/edil-ozi/drawer.tsx"],
  },

  dropdown: {
    name: "dropdown",
    type: "components:ui",
    files: ["registry/components/edil-ozi/dropdown.tsx"],
  },

  "login-form": {
    name: "login-form",
    type: "components:ui",
    files: ["registry/components/edil-ozi/login-form.tsx"],
  },

  "pricing-card": {
    name: "pricing-card",
    type: "components:ui",
    files: ["registry/components/edil-ozi/pricing-card.tsx"],
  },

  tabs: {
    name: "tabs",
    type: "components:ui",
    files: ["registry/components/edil-ozi/tabs.tsx"],
  },

  "logo-carousel": {
    name: "logo-carousel",
    type: "components:ui",
    files: ["registry/components/edil-ozi/logo-carousel.tsx"],
  },

  //Fancy
  "card-hover-effect": {
    name: "card-hover-effect",
    type: "components:ui",
    files: ["registry/components/edil-ozi/card-hover-effect.tsx"],
  },
  "canvas-cursor": {
    name: "canvas-cursor",
    type: "components:ui",
    files: ["registry/components/edil-ozi/canvas-cursor.tsx"],
  },
  "fluid-cursor": {
    name: "fluid-cursor",
    type: "components:ui",
    files: ["registry/components/edil-ozi/fluid-cursor.tsx"],
  },
  "fancy-click-effect": {
    name: "fancy-click-effect",
    type: "components:ui",
    files: ["registry/components/edil-ozi/fancy-click-effect.tsx"],
  },

  //Text animations
  "infinite-text": {
    name: "infinite-text",
    type: "components:ui",
    files: ["registry/components/edil-ozi/infinite-text.tsx"],
  },

  "text-reveal": {
    name: "text-reveal",
    type: "components:ui",
    files: ["registry/components/edil-ozi/text-reveal.tsx"],
  },

  "rotate-between": {
    name: "rotate-between",
    type: "components:ui",
    files: ["registry/components/edil-ozi/rotate-between.tsx"],
  },

  "text-glitch": {
    name: "text-glitch",
    type: "components:ui",
    files: ["registry/components/edil-ozi/text-glitch.tsx"],
  },

  //On scroll animations
  "swipe-grid": {
    name: "swipe-grid",
    type: "components:ui",
    files: ["registry/components/edil-ozi/swipe-grid.tsx"],
  },

  "in-view": {
    name: "in-view",
    type: "components:ui",
    files: ["registry/components/edil-ozi/in-view.tsx"],
  },

  "perspective-grid": {
    name: "perspective-grid",
    type: "components:ui",
    files: ["registry/components/edil-ozi/perspective-grid.tsx"],
  },

  "zoom-parallax": {
    name: "zoom-parallax",
    type: "components:ui",
    files: ["registry/components/edil-ozi/zoom-parallax.tsx"],
  },

  "horizontal-scroll": {
    name: "horizontal-scroll",
    type: "components:ui",
    files: ["registry/components/edil-ozi/horizontal-scroll.tsx"],
  },

  "infinite-scroll": {
    name: "infinite-scroll",
    type: "components:ui",
    files: ["registry/components/edil-ozi/infinite-scroll.tsx"],
  },

  "scroll-velocity": {
    name: "scroll-velocity",
    type: "components:ui",
    files: ["registry/components/edil-ozi/scroll-velocity.tsx"],
  },

  "two-way-parallax": {
    name: "two-way-parallax",
    type: "components:ui",
    files: ["registry/components/edil-ozi/two-way-parallax.tsx"],
  },
};

export default componentsUi;
