# Generated by Django 4.2.3 on 2023-07-11 21:28

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('telegram_bot', '0014_alter_telegrambotuser_options_and_more'),
        ('user', '0007_remove_user_password'),
    ]

    operations = [
        migrations.CreateModel(
            name='UserPlugin',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Название')),
                ('code', models.TextField(verbose_name='Код')),
                ('is_checked', models.BooleanField(verbose_name='Проверен')),
                ('date_added', models.DateTimeField(auto_now_add=True, verbose_name='Дата добавления')),
                ('telegram_bot', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='telegram_bot.telegrambot', verbose_name='Telegram бот')),
            ],
            options={
                'verbose_name': 'Плагин пользователя',
                'verbose_name_plural': 'Плагины пользователей',
                'db_table': 'user_plugin',
            },
        ),
        migrations.AddField(
            model_name='user',
            name='telegram_id',
            field=models.BigIntegerField(null=True, unique=True, verbose_name='Telegram ID'),
        ),
        migrations.CreateModel(
            name='UserPluginLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('message', models.TextField(verbose_name='Сообщение')),
                ('level', models.CharField(choices=[('info', 'Info'), ('success', 'Success'), ('danger', 'Danger')], default='info', max_length=7, verbose_name='Уровень')),
                ('date_added', models.DateTimeField(auto_now_add=True, verbose_name='Дата добавления')),
                ('plugin', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='user.userplugin', verbose_name='Плагин')),
                ('telegram_bot', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='telegram_bot.telegrambot', verbose_name='Telegram бот')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Пользователь')),
            ],
            options={
                'verbose_name': 'Журнал плагина пользователя',
                'verbose_name_plural': 'Журналы плагинов пользователей',
                'db_table': 'user_plugin_log',
            },
        ),
        migrations.AddField(
            model_name='userplugin',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Пользователь'),
        ),
    ]
