# Generated by Django 4.2.3 on 2023-09-11 04:47

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('telegram_bot', '0015_alter_telegrambotcommandkeyboardbutton_options'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='telegrambotcommand',
            options={'verbose_name': 'Команда', 'verbose_name_plural': 'Команды'},
        ),
        migrations.AlterModelOptions(
            name='telegrambotuser',
            options={'verbose_name': 'Пользователя', 'verbose_name_plural': 'Пользователи'},
        ),
        migrations.RenameField(
            model_name='telegrambot',
            old_name='date_added',
            new_name='added_date',
        ),
        migrations.RenameField(
            model_name='telegrambotuser',
            old_name='date_activated',
            new_name='activated_date',
        ),
        migrations.RemoveField(
            model_name='telegrambotcommand',
            name='api_request',
        ),
        migrations.RemoveField(
            model_name='telegrambotcommand',
            name='command',
        ),
        migrations.RemoveField(
            model_name='telegrambotcommand',
            name='message_text',
        ),
        migrations.RemoveField(
            model_name='telegrambotcommandkeyboard',
            name='type',
        ),
        migrations.AddField(
            model_name='telegrambotcommandkeyboard',
            name='mode',
            field=models.CharField(choices=[('default', 'Обычный'), ('inline', 'Встроенный'), ('payment', 'Платёжный')], default='default', max_length=7, verbose_name='Режим'),
        ),
        migrations.AlterField(
            model_name='telegrambot',
            name='api_token',
            field=models.CharField(max_length=50, unique=True, verbose_name='API-токен'),
        ),
        migrations.AlterField(
            model_name='telegrambotcommand',
            name='database_record',
            field=models.JSONField(blank=True, null=True, verbose_name='Запись в базу данных'),
        ),
        migrations.AlterField(
            model_name='telegrambotcommand',
            name='image',
            field=models.ImageField(blank=True, null=True, upload_to='static/images/commands/', verbose_name='Изображение'),
        ),
        migrations.AlterField(
            model_name='telegrambotcommandkeyboardbutton',
            name='end_diagram_connector',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='telegrambotcommandkeyboardbutton',
            name='row',
            field=models.IntegerField(blank=True, null=True, verbose_name='Ряд'),
        ),
        migrations.AlterField(
            model_name='telegrambotcommandkeyboardbutton',
            name='start_diagram_connector',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='telegrambotcommandkeyboardbutton',
            name='telegram_bot_command',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='telegram_bot.telegrambotcommand'),
        ),
        migrations.AlterField(
            model_name='telegrambotcommandkeyboardbutton',
            name='text',
            field=models.TextField(max_length=4096, verbose_name='Текст'),
        ),
        migrations.AlterField(
            model_name='telegrambotcommandkeyboardbutton',
            name='url',
            field=models.TextField(blank=True, max_length=2048, null=True, verbose_name='URL-адрес'),
        ),
        migrations.AlterField(
            model_name='telegrambotuser',
            name='full_name',
            field=models.CharField(max_length=129, null=True, verbose_name='Полное имя'),
        ),
        migrations.AlterField(
            model_name='telegrambotuser',
            name='user_id',
            field=models.BigIntegerField(verbose_name='Telegram ID'),
        ),
        migrations.CreateModel(
            name='TelegramBotCommandMessageText',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mode', models.CharField(choices=[('default', 'Обычный'), ('markdown', 'Markdown'), ('html', 'HTML')], default='default', max_length=8, verbose_name='Режим')),
                ('text', models.TextField(max_length=4096, verbose_name='Текст')),
                ('telegram_bot_command', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='message_text', to='telegram_bot.telegrambotcommand')),
            ],
            options={
                'db_table': 'telegram_bot_command_message_text',
            },
        ),
        migrations.CreateModel(
            name='TelegramBotCommandCommand',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('command', models.CharField(max_length=32, verbose_name='Команда')),
                ('show_in_menu', models.BooleanField(default=False, verbose_name='Отображать в меню')),
                ('telegram_bot_command', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='command', to='telegram_bot.telegrambotcommand')),
            ],
            options={
                'db_table': 'telegram_bot_command_command',
            },
        ),
        migrations.CreateModel(
            name='TelegramBotCommandApiRequest',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(verbose_name='URL-адрес')),
                ('method', models.CharField(choices=[('get', 'GET'), ('post', 'POST'), ('put', 'PUT'), ('patch', 'PATCH'), ('delete', 'DELETE')], default='get', max_length=6, verbose_name='Метод')),
                ('headers', models.JSONField(blank=True, null=True, verbose_name='Заголовки')),
                ('data', models.JSONField(blank=True, null=True, verbose_name='Данные')),
                ('telegram_bot_command', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='api_request', to='telegram_bot.telegrambotcommand')),
            ],
            options={
                'db_table': 'telegram_bot_command_api_request',
            },
        ),
    ]
