# SHEBANQ

[![SWH](https://archive.softwareheritage.org/badge/origin/https://github.com/ETCBC/shebanq/)](https://archive.softwareheritage.org/browse/origin/https://github.com/ETCBC/shebanq/)
[![DOI](https://zenodo.org/badge/14582815.svg)](https://zenodo.org/badge/latestdoi/14582815)
[![Project Status: Active – The project has reached a stable, usable state and is being actively developed.](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
<img src="https://camo.githubusercontent.com/efdbaf92d577bd214ee5f26020d668e470045bd66de29266d8e74f336bd57d05/68747470733a2f2f773369642e6f72672f72657365617263682d746563686e6f6c6f67792d72656164696e6573732d6c6576656c732f4c6576656c3950726f76656e2e737667" alt="Technology Readiness Level 9/9 - Proven - Technology complete and proven in practise by real users" data-canonical-src="https://w3id.org/research-technology-readiness-levels/Level9Proven.svg" style="max-width: 100%;">

![shebanq2](https://raw.github.com/etcbc/shebanq/master/static/images/shebanq_logo.png)
![shebanq](https://raw.github.com/etcbc/shebanq/master/static/images/shebanq.png)

[![etcbc](static/images/etcbc.png)](http://www.etcbc.nl)
[![dans](static/images/dans.png)](https://dans.knaw.nl/en)
[![tf](static/images/tf-small.png)](https://annotation.github.io/text-fabric/tf)

### BHSA Family

* [bhsa](https://github.com/etcbc/bhsa) Core data and feature documentation
* [phono](https://github.com/etcbc/phono) Phonological representation of Hebrew words
* [parallels](https://github.com/etcbc/parallels) Links between similar verses
* [valence](https://github.com/etcbc/valence) Verbal valence for all occurrences
  of some verbs
* [trees](https://github.com/etcbc/trees) Tree structures for all sentences
* [bridging](https://github.com/etcbc/bridging) Open Scriptures morphology
  ported to the BHSA
* [pipeline](https://github.com/etcbc/pipeline) Generate the BHSA and SHEBANQ
  from internal ETCBC data files
* [shebanq](https://github.com/etcbc/shebanq) Engine of the
  [shebanq](https://shebanq.ancient-data.org) website

### Extended family

* [dss](https://github.com/etcbc/dss) Dead Sea Scrolls
* [extrabiblical](https://github.com/etcbc/extrabiblical)
  Extra-biblical writings from ETCBC-encoded texts
* [peshitta](https://github.com/etcbc/peshitta)
  Syriac translation of the Hebrew Bible
* [syrnt](https://github.com/etcbc/syrnt)
  Syriac translation of the New Testament

## About

*System for HEBrew Text: ANnotations for Queries and Markup*

[SHEBANQ](http://shebanq.ancient-data.org) is a website with a search engine for the Hebrew Bible, powered by the
[BHSA](https://github.com/ETCBC/bhsa) linguistic database, also known as ETCBC or WIVU.

Read all about SHEBANQ on the [wiki](https://github.com/ETCBC/shebanq/wiki) of this repository.
There you find information on the data sources as well.
And there are the [techdocs](https://etcbc.github.io/shebanq/) of course.

## Deployment

As of 2023-12-21, SHEBANQ has moved from DANS to KNAW/HuC.
The development of SHEBANQ moves from this repo to
[tt/shebanq](https://gitlab.huc.knaw.nl/tt/shebanq).

**There you'll find ways to fire up your own shebanq on docker!**

This repo is now archived and readonly.

## History

See [Changes](https://github.com/ETCBC/shebanq/wiki/Changes)

# Author

[Dirk Roorda](https://github.com/dirkroorda), working at
[KNAW Humanities Cluster - Digital Infrastructure](https://huc.knaw.nl/di/text/).

See [team](https://github.com/ETCBC/shebanq/wiki/Team) for a list of people
that have all contributed in various ways to the existence of the website SHEBANQ.

# Deployed

SHEBANQ is served by 
[DANS](https://www.dans.knaw.nl), and Dirk Roorda is still managing the site in production.
