# ---------------------
# Set the target CPU:
# X86 for 32-bit, X64 for 64-bit
# ---------------------
ifeq ($(TARGET_CPU),)
TARGET_CPU = X64
endif


# ---------------------
# Comment out the BUILD_FOR_DEVEL line if you
# only wish to build (and use) the amalgamation.
# Otherwise, all individual Emdris libraries
# will be built, as usual.
# (libemdf.lib, libmql.lib, etc.).
#
# If you comment this out, or set it to 0,
# then the individual libraries are not built.
# Instead, the amalgamation is built and used.
# ---------------------
ifeq ($(BUILD_FOR_DEVEL),)
BUILD_FOR_DEVEL = 1
endif



# ---------------------
# Comment any of these out
# in order not to compile that backend
# ---------------------
ifeq ($(SQLITE3),)
SQLITE3=1
endif

ifeq ($TARGET_CPU,X64)
# You may modify this...
ifeq ($(MYSQL),)
MYSQL=1
endif
else
# But not this...
MYSQL=0
endif

# PostgreSQL support is not provided in the official binaries,
# due to library conflicts between PostgreSQL and MySQL,
# and due to licensing restrictions posed on the libraries
# shipped with PostreSQL.
ifeq ($(PGSQL),)
PGSQL=0
endif

#
# The BPT backend is a database backend for Emdros developed
# by Ulrik Sandborg-Petersen, the author of Emdros.
#
# It is much faster than even SQLite, which otherwise is the fastest
# backend for Emdros, and the databases created for the BPT backend
# are much smaller than even the databases of SQLite 3, which already
# compresses data a lot.
#
# The BPT backend is proprietary, and only avilable by licensing from
# Ulrik Sandborg-Petersen.
#
# Please feel free to inquire about the BPT backend: ulrikp@emdros.org
#
# If you have obtained a license, and therefore the source code,
# you can set the following to 1.
#
ifeq ($(BPT),)
BPT=0
endif



# -----------------------
# Choose debug or release
# -----------------------

ifeq ($(DEBUG),)
DEBUG=0
#DEBUG=1
endif

# Don't do anything to this.
DEBUGINFO=1


# -----------------------------------------------
# Choose whether to build stuff other than Emdros
# Set this to 1 if only Emdros is to be built
# (including the programs in src\, but not in
#  src\qrytool).
# -----------------------------------------------

ifeq ($(EMDROS_ONLY),)
EMDROS_ONLY=0
#EMDROS_ONLY=1
endif



# ----------------------------------------------
# Set one of the following paths 
# to wherever you have your PostgreSQL
# or MySQL (and ignore whichever isn't relevant)
# ----------------------------------------------
ifeq ($(PGTOP),)
PGTOP=$(PROGRAMFILES)\PostgreSQL\8.4
endif

ifeq ($(MYSQLTOP),)
MYSQLTOP=C:\Program Files\MySQL\MySQL Connector C 6.1
endif


# ----------------------------------------------
# 
# SQLite variables
# 
# ----------------------------------------------

# If this is set to 1, then syncing is turned off on SQLite. 
# This means that changes are just handed to the operating system
# and then the SQLite library moves on, without calling the appropriate
# OS API to make sure changes are flushed to disk.  This means that 
# changes may be lost if the machine crashes while the SQLite library 
# has a database open. 
#
# On the other hand, things are significantly faster with this set to 1.

ifeq ($(SQLITE3_NO_SYNC),)
SQLITE3_NO_SYNC=1
#SQLITE3_NO_SYNC=0
endif


# ----------------------------------------------
# 
# wxWidgets variables
# 
# ----------------------------------------------

# Uncomment this line if you wish to compile the programs
# which depend on wxWidgets
ifeq ($(WITH_WXWIN),)
WITH_WXWIN=yes
endif


# Set this as appropriate
ifeq ($(WXWIN_HOME),)
WXWIN_HOME=c:\wxWidgets-3.1.2
endif

# ----------------------------------------------
# SWIG C# support
# ----------------------------------------------

# set to "yes" to enable C# SWIG support
ifeq ($(WITH_SWIG_CSHARP),)
WITH_SWIG_CSHARP=no
#WITH_SWIG_CSHARP=yes
endif


# ----------------------------------------------
# SWIG Python support
# ----------------------------------------------

# uncomment to enable Python
ifeq ($(WITH_SWIG_PYTHON),)
WITH_SWIG_PYTHON=no
#WITH_SWIG_PYTHON=yes
endif

#PYTHON_INCLUDE : Set this to the directory that contains python.h
ifeq ($(PYTHON_INCLUDE),)
PYTHON_INCLUDE=c:\python27\include
endif

# PYTHON_LIB : Set this to the python library including path for linking with
ifeq ($(PYTHON_LIB),)
PYTHON_LIB=c:\python27\libs\python27.lib
endif


# ----------------------------------------------
# SWIG Java upport
# ----------------------------------------------

# uncomment to enable Java
ifeq ($(WITH_SWIG_JAVA),)
WITH_SWIG_JAVA=no
#WITH_SWIG_JAVA=yes
endif

#SWIG_JDK_DIR : Set this to the top-level JDK directory
ifeq ($(SWIG_JDK_DIR),)
SWIG_JDK_DIR=c:\Program Files\java\jdk1.8.0_121
endif



# ----------------------------------------------
# 
# NSIS "Nullsoft install-system" support 
# (http://nsis.sourceforge.net)
# 
# ----------------------------------------------
ifeq ($(NSISEXE),)
NSISEXE=C:\Program Files (x86)\NSIS\makensis.exe
endif


# Set VERSION variable
VERSION=3.7.3


# Don't touch this, or Emdros won't compile.
# Useful for re-purposing body.mak to projects outside of Emdros.
COMPILE_EMDROS = 1

#
# This is the basis for recursive nmake.
# In win32/win32.mak, this MAKEARGS macro is used
# whenever doing recursive nmake
#
MAKEARGS =  CC="$(CC)" CXX="$(CXX)" CFLAGS="$(CFLAGS)" CXXFLAGS="$(CXXFLAGS)" \
            CPPFLAGS="$(CPPFLAGS)" LDFLAGS="$(LDFLAGS)" CPP="$(CPP)" \
	    TARGET_CPU="$(TARGET_CPU)" \
	    BUILD_FOR_DEVEL="$(BUILD_FOR_DEVEL)" \
	    SQLITE3="$(SQLITE3)" \
	    MYSQL="$(MYSQL)" PGSQL="$(PGSQL)" \
	    BPT="$(BPT)" \
	    DEBUG="$(DEBUG)" \
	    EMDROS_ONLY="$(EMDROS_ONLY)" \
	    PGTOP="$(PGTOP)" MYSQLTOP="$(MYSQLTOP)" \
	    SQLITE3_NO_SYNC="$(SQLITE3_NO_SYNC)" \
	    WITH_WXWIN="$(WITH_WXWIN)" \
	    WXWIN_HOME="$(WXWIN_HOME)" \
	    WITH_SWIG_CSHARP="$(WITH_SWIG_CSHARP)" \
	    WITH_SWIG_PYTHON="$(WITH_SWIG_PYTHON)" \
	    PYTHON_INCLUDE="$(PYTHON_INCLUDE)" \
	    PYTHON_LIB="$(PYTHON_LIB)" \
	    WITH_SWIG_JAVA="$(WITH_SWIG_JAVA)" \
	    SWIG_JDK_DIR="$(SWIG_JDK_DIR)" \
	    NSISEXE="$(NSISEXE)" 
