char emdfxml_dtd[] = 
"<!-- This DTD describes and documents the 'emdfxml' data format.  The\n"
"     documentation is in the comments above each element declaration.\n"
"\n"
"     The format has been designed with two goals in mind:\n"
"\n"
"     1) Easy human readability in the 'monad_sets' and 'schema' sections.\n"
"\n"
"     2) Compactness of expression in the 'data' section.\n"
"\n"
"\n"
"     The 'emdfxml' format is useful for:\n"
"\n"
"     a) Dumping Emdros database to XML (rather than MQL).  This makes\n"
"     for greater interoperability with other tools which do not read\n"
"     MQL.\n"
"\n"
"     b) Importing Emdros databases from XML (rather than MQL).  This\n"
"     might make it easier to write an importer for a given kind of\n"
"     data, since XML can be emitted by the importer, rather than MQL.\n"
"\n"
"     c) Importing an Emdros database directly into the BPT engine\n"
"     without first importing it into a writable backend, such as\n"
"     PostgreSQL, MySQL, or SQLite 3.\n"
"\n"
"-->\n"
"\n"
"<!-- emdfxml is the root element.  It contains one or more 'db' elements.\n"
"-->\n"
"<!ELEMENT emdfxml\n"
"	  (db)+ >\n"
"\n"
"<!-- db is the element that contains an entire database.\n"
"\n"
"     The attribute, 'name', may be given in order to name the\n"
"     database.  If not given, the tool using the emdfxml XML file is\n"
"     expected to provide a name.\n"
"\n"
"     Whether this name, if given, is overridden by the tooling is up\n"
"     to the tool.\n"
"-->\n"
"<!ELEMENT db\n"
"	  ((schema)?,(data)?)\n"
"	  >\n"
"<!ATTLIST db\n"
"	  name CDATA #IMPLIED\n"
"	  >\n"
"\n"
"<!ELEMENT schema\n"
"	  ((monad_sets)?,(enumerations)?,object_type_declarations)\n"
"	  >\n"
"\n"
"<!ELEMENT monad_sets\n"
"	  (monad_set)*\n"
"	  >\n"
"\n"
"<!--\n"
"    The element, 'monad_set', declares a stored monad set.\n"
"\n"
"    The 'name' attribute must follow the general rules of MQL monad\n"
"    set names.  Currently, this means that the name must be a C\n"
"    identifier, following the regular expression\n"
"    \"[A-Za-z_][A-Za-z0-9_]*\"\n"
"\n"
"    The format of the 'monads' attribute is the same as in MQL.  The\n"
"    precise rules are given below under the 'm' attribute of the 'o'\n"
"    element.\n"
"\n"
"-->\n"
"<!ELEMENT monad_set\n"
"	  EMPTY\n"
"	  >\n"
"<!ATTLIST monad_set\n"
"	  name CDATA #REQUIRED\n"
"	  monads CDATA #REQUIRED\n"
"	  >\n"
"\n"
"\n"
"<!ELEMENT enumerations\n"
"	  (enumeration)*\n"
"	  >\n"
"\n"
"<!-- The 'enumeration' element declares one enumeration.  It contains\n"
"    one or more enum_const elements.\n"
"\n"
"    The 'name' attribute is required, and must be a C identifier,\n"
"    following the regular expression \"[A-Za-z_][A-Za-z0-9_]*\".\n"
"\n"
"-->\n"
"<!ELEMENT enumeration\n"
"	  (enum_const)+\n"
"	  >\n"
"<!ATTLIST enumeration\n"
"	  name CDATA #REQUIRED\n"
"	  >\n"
"\n"
"<!-- The 'enum_const' element declares one enumeration constant within\n"
"     the containing 'enumeration' element.  It is a single-tag\n"
"     element.\n"
"\n"
"     The 'name' attribute is required, and must be a C identifier,\n"
"     following the regular expression \"[A-Za-z_][A-Za-z0-9_]*\". It is\n"
"     case-sensitive, meaning the enum const names 'ADD' and 'Add' are\n"
"     considered two different enum const names.\n"
"\n"
"     The 'value' attribute, if present, must be an integer in base-10.\n"
"     If not present, the value of this enum const is the value of the\n"
"     previous declared enum const, plus 1.  If this is the first enum\n"
"     const being declared without a value, its assigned value is 0.\n"
"\n"
"     The 'default' attribute, if present, can be either \"true\" or\n"
"     \"false\".  If absent, \"false\" is assumed.  It is an error to\n"
"     declare an enumeration with more than one 'default=\"true\"'\n"
"     attribute.  If none of the enum_const elements has\n"
"     'default=\"true\"', then the first enum_const is declared to be the\n"
"     default.\n"
"\n"
"-->\n"
"<!ELEMENT enum_const\n"
"	  EMPTY\n"
"	  >\n"
"<!ATTLIST enum_const\n"
"	  name    CDATA #REQUIRED\n"
"	  value   CDATA #IMPLIED\n"
"	  default CDATA #IMPLIED\n"
"	  >\n"
"\n"
"<!-- The 'object_type_declarations' element declares zero or more\n"
"     object types inside.\n"
"-->\n"
"<!ELEMENT object_type_declarations\n"
"	  (object_type_declaration)*\n"
"	  >\n"
"\n"
"<!-- Element 'object_type_declaration' declares an object type.\n"
"     Inside it may have zero or more feature_declaration elements.\n"
"\n"
"     The 'id_d' and 'monads' features are automatically created. It is\n"
"     an error to declare them.\n"
"\n"
"     The attribute, 'name', is required, and must follow the rules of\n"
"     MQL object type names.  Currently, this means that the name must\n"
"     be a C identifier, conforming to the regular expression,\n"
"     \"[A-Za-z_][A-Za-z0-9_]*\"\n"
"\n"
"     The attribute, 'range_type', declares the kinds of monad sets of\n"
"     the 'monads' feature of all objects in this object type.  If\n"
"     present, it must be one of the following strings:\n"
"\n"
"     a) \"WITH SINGLE MONAD OBJECTS\"\n"
"     b) \"WITH SINGLE RANGE OBJECTS\"\n"
"     c) \"WITH MULTIPLE RANGE OBJECTS\"\n"
"\n"
"     These values are case-insensitive, but must be case-insensitively\n"
"     equivalent to one of the above.  It is an error to declare a\n"
"     value which is not one of the above.\n"
"\n"
"     If absent, this value defaults to \"WITH MULTIPLE RANGE OBJECTS\".\n"
"\n"
"     The attribute, 'monad_uniqueness_type', declares some\n"
"     restrictions on the uniqueness of the first and last monads.  If\n"
"     present, it must be one of the following strings:\n"
"\n"
"     a) \"HAVING UNIQUE FIRST MONADS\"\n"
"     b) \"HAVING UNIQUE FIRST AND LAST MONADS\"\n"
"     c) \"WITHOUT UNIQUE MONADS\"\n"
"     \n"
"     These values are case-insensitive, but must be case-insensitively\n"
"     equivalent to one of the above.  It is an error to declare a\n"
"     value which is not one of the above.\n"
"\n"
"     If absent, this defaults to \"WITHOUT UNIQUE MONADS\".\n"
"\n"
"-->\n"
"<!ELEMENT object_type_declaration\n"
"	  (feature_declaration)*\n"
"	  >\n"
"<!ATTLIST object_type_declaration\n"
"	  name                  CDATA #REQUIRED\n"
"	  range_type            CDATA #IMPLIED\n"
"	  monad_uniqueness_type CDATA #IMPLIED\n"
"	  >\n"
"\n"
"<!-- The element, \"feature_declaration\", is a single-tag element with\n"
"     two required attributes, and two optional attributes.  It\n"
"     declares a single feature on the surrounding object type.\n"
"\n"
"     The required attribute, 'name', is the name of the feature as it\n"
"     would be declared in an MQL \"CREATE OBJECT TYPE\" statement.\n"
"\n"
"     The required attribute, \"feature_type\", must be\n"
"     case-insensitively equivalent to one of the following:\n"
"\n"
"     a) \"INTEGER\"\n"
"     b) \"ID_D\"\n"
"     c) <enum-name>\n"
"     d) \"LIST OF INTEGER\"\n"
"     e) \"LIST OF ID_D\"\n"
"     f) \"LIST OF <enum-name>\"\n"
"     g) \"STRING\"\n"
"     h) \"ASCII\"\n"
"     i) \"SINGLE MONAD SET OF MONADS\"\n"
"     j) \"SINGLE RANGE SET OF MONADS\"\n"
"     k) \"MULTIPLE RANGE SET OF MONADS\"\n"
"     l) \"SET OF MONADS\"  (same as (k)).\n"
"\n"
"     The optional attribute, 'from_set', if present, must be one of\n"
"     the following:\n"
"\n"
"     a) \"true\"\n"
"     b) \"false\"\n"
"\n"
"     It defaults to \"false\".  If 'true' is given, the feature type is\n"
"     declared to be 'from set'.  This currently only works if the\n"
"     feature_type is either \"string\" or \"ascii\".\n"
"\n"
"     The optional attribute, 'with_index', if present, must be one of\n"
"     the following:\n"
"\n"
"     a) \"true\"\n"
"     b) \"false\"\n"
"\n"
"     It defaults to \"false\".  If 'true' is given, an index is declared\n"
"     on the feature in the underlying database backend.\n"
"\n"
"     The optional attribute, 'default_value', if present, must be an\n"
"     expression giving the default value of the feature.\n"
"-->\n"
"<!ELEMENT feature_declaration\n"
"	  EMPTY\n"
"	  >\n"
"<!ATTLIST feature_declaration\n"
"	  name             CDATA #REQUIRED\n"
"	  feature_type     CDATA #REQUIRED\n"
"	  from_set         CDATA #IMPLIED\n"
"	  with_index       CDATA #IMPLIED\n"
"	  default_value    CDATA #IMPLIED\n"
"	  >\n"
"  \n"
"<!-- The 'data' element contains zero or more object_type_data\n"
"     elements.\n"
"-->\n"
"<!ELEMENT data\n"
"	  (object_type_data)*\n"
"	  >\n"
"\n"
"<!-- The 'object_type_data' element encompasses zero or more objects\n"
"     for the object type with the given name.\n"
"\n"
"     The 'name' attribute must obey the restrictions on object types,\n"
"     and the object type must already be declared.  The declaration\n"
"     can happen in MQL, if dumping to a database, or inside the XML\n"
"     'schema' element.\n"
"\n"
"     When dumping to BPT, it is an error to have more than one\n"
"     object_type_data declaration with the same object type name in\n"
"     the same XML file.\n"
"\n"
"     When dumping to an SQL database, this is not an error.\n"
"-->\n"
"<!ELEMENT object_type_data\n"
"	  (o)*\n"
"	  >\n"
"<!ATTLIST object_type_data\n"
"	  name CDATA #REQUIRED\n"
"	  >\n"
"	  \n"
"<!-- Element 'o' contains the data for an individual object of the\n"
"     encompassing object type.\n"
"\n"
"     The attribute, 'id_d', if given, will become the id_d of the\n"
"     object.\n"
"\n"
"     If the attribute 'id_d' is not given, an id_d will be\n"
"     auto-assigned in a way similar to the way id_ds are uniquely\n"
"     assigned while creating a database through MQL.\n"
"\n"
"     The attribute, 'm', must contain a valid monad set.  Here,\n"
"     \"valid\" means:\n"
"\n"
"     a) Its first non-space character is '{'.\n"
"     b) Its last non-space character is '}'.\n"
"\n"
"     c) Between the { and } must be a non-empty, comma-separated list\n"
"        of \"monad set elements\".  Spaces are ignored around the\n"
"        integers and dashes, and around commas.\n"
"     d) A \"monad set element\" is of one of the following two forms:\n"
"     \n"
"        i) \\d+   (base-10 integer)\n"
"	ii) \\d+-\\d+ (range of two base-10 integers, in which the\n"
"            second integer must be greater than or equal to the\n"
"            first).\n"
"\n"
"     In other words, the monad set must follow the syntax of the monad\n"
"     sets in MQL.\n"
"-->\n"
"<!ELEMENT o\n"
"	  (f)*\n"
"	  >\n"
"<!ATTLIST o\n"
"	  id_d CDATA #IMPLIED\n"
"	  m CDATA #REQUIRED\n"
"	  >\n"
"\n"
"<!ELEMENT f\n"
"	  EMPTY >\n"
"<!ATTLIST f\n"
"	  n CDATA #REQUIRED\n"
"	  v CDATA #REQUIRED\n"
"	  >\n"
;

