
/*
 * Copyright (C) 2001-2018     Ulrik Sandborg-Petersen
 * Copyright (C) 2018-present  Sandborg-Petersen Holding ApS, Denmark
 *
 * Licensed under the MIT License.
 *
 * Please see the file COPYING in the root of the sources for more details.
 *
 */


char simple_bible_schema[] = 
"//\n"
"// simplebibleschema.mql - Simple bible schema\n"
"// Last update: March 11, 2006\n"
"//\n"
"CREATE ENUM \n"
"book_name_t = {\n"
"  Genesis,\n"
"  Exodus,\n"
"  Leviticus,\n"
"  Numbers,\n"
"  Deuteronomy,\n"
"  Joshua,\n"
"  Judges,\n"
"  Ruth,\n"
"  I_Samuel,\n"
"  II_Samuel,\n"
"  I_Kings,\n"
"  II_Kings,\n"
"  I_Chronicles,\n"
"  II_Chronicles,\n"
"  Ezra,\n"
"  Nehemiah,\n"
"  Esther,\n"
"  Job,\n"
"  Psalms,\n"
"  Proverbs,\n"
"  Ecclesiastes,\n"
"  Canticles,\n"
"  Isaiah,\n"
"  Jeremiah,\n"
"  Lamentations,\n"
"  Ezekiel,\n"
"  Daniel,\n"
"  Hosea,\n"
"  Joel,\n"
"  Amos,\n"
"  Obadiah,\n"
"  Jonah,\n"
"  Micah,\n"
"  Nahum,\n"
"  Habakkuk,\n"
"  Zephaniah,\n"
"  Haggai,\n"
"  Zechariah,\n"
"  Malachi,\n"
"  Matthew,\n"
"  Mark,\n"
"  Luke,\n"
"  John,\n"
"  Acts,\n"
"  Romans,\n"
"  I_Corinthians,\n"
"  II_Corinthians,\n"
"  Galatians,\n"
"  Ephesians,\n"
"  Philippians,\n"
"  Colossians,\n"
"  I_Thessalonians,\n"
"  II_Thessalonians,\n"
"  I_Timothy,\n"
"  II_Timothy,\n"
"  Titus,\n"
"  Philemon,\n"
"  Hebrews,\n"
"  James,\n"
"  I_Peter,\n"
"  II_Peter,\n"
"  I_John,\n"
"  II_John,\n"
"  III_John,\n"
"  Jude,\n"
"  Revelation,\n"
"  Baruch,\n"
"  Sirach,\n"
"  I_Esdras,\n"
"  II_Esdras,\n"
"  Judith,\n"
"  Epistle_to_the_Laodicaeans,\n"
"  I_Maccabees,\n"
"  II_Maccabees,\n"
"  III_Maccabees,\n"
"  IV_Maccabees,\n"
"  Prayer_of_Manasseh,\n"
"  Psalm_151,\n"
"  Tobit,\n"
"  Wisdom_of_Solomon,\n"
"  Susanna,\n"
"  Bel_and_the_Dragon,\n"
"  Prayer_of_Azariah, // Also Song of the three young men\n"
"  Psalms_of_Solomon,\n"
"  Odes,\n"
"  Additions_to_Esther,\n"
"  Psalms_Vulgata,\n"
"  Letter_of_Jeremiah\n"
"}\n"
"GO\n"
"\n"
"\n"
"\n"
"\n"
"CREATE OBJECT TYPE\n"
"WITH SINGLE RANGE OBJECTS\n"
"HAVING UNIQUE FIRST MONADS\n"
"[Book\n"
"  book : book_name_t;\n"
"]\n"
"GO\n"
"\n"
"\n"
"\n"
"CREATE OBJECT TYPE\n"
"WITH SINGLE RANGE OBJECTS\n"
"HAVING UNIQUE FIRST MONADS\n"
"[Chapter\n"
"  chapter : integer;\n"
"  book : book_name_t;\n"
"]\n"
"GO\n"
"\n"
"\n"
"\n"
"CREATE OBJECT TYPE\n"
"WITH SINGLE RANGE OBJECTS\n"
"HAVING UNIQUE FIRST MONADS\n"
"[Verse\n"
"  chapter : integer;\n"
"  verse : integer;\n"
"  book : book_name_t;\n"
"]\n"
"GO\n"
"\n"
"\n"
"CREATE OBJECT TYPE\n"
"WITH SINGLE MONAD OBJECTS\n"
"HAVING UNIQUE FIRST MONADS\n"
"[Word\n"
"  surface : STRING FROM SET WITH INDEX;\n"
"  stripped_surface : STRING FROM SET WITH INDEX;\n"
"]\n"
"GO\n"
"\n"
"\n"
;
