
/*
 * Copyright (C) 2001-2018     Ulrik Sandborg-Petersen
 * Copyright (C) 2018-present  Sandborg-Petersen Holding ApS, Denmark
 *
 * Licensed under the MIT License.
 *
 * Please see the file COPYING in the root of the sources for more details.
 *
 */


char penn_treebank_schema[] = 
"//\n"
"// Penn Treebank Schema for Emdros 1.2.0.pre199 or later\n"
"// Author: Ulrik Sandborg-Petersen\n"
"// Last update: 4/27-2013\n"
"//\n"
"\n"
"CREATE OBJECT TYPE\n"
"WITH SINGLE RANGE OBJECTS\n"
"HAVING UNIQUE FIRST MONADS\n"
"[Document\n"
"   docid : INTEGER;\n"
"]\n"
"GO\n"
"\n"
"\n"
"CREATE OBJECT TYPE\n"
"WITH SINGLE RANGE OBJECTS\n"
"HAVING UNIQUE FIRST MONADS\n"
"[DocumentRoot\n"
"   docid : INTEGER;\n"
"   parent : INTEGER; // Points to the document of which it is a part\n"
"]\n"
"GO\n"
"\n"
"\n"
"CREATE OBJECT TYPE\n"
"WITH SINGLE RANGE OBJECTS\n"
"[Nonterminal\n"
"   docid : INTEGER;\n"
"   parent : INTEGER; \n"
"   coref : LIST OF INTEGER; // Coreference links\n"
"   nttype : STRING FROM SET WITH INDEX; // First part of nonterminal name\n"
"   function : STRING FROM SET WITH INDEX; // The rest of the nonterminal name (except for coreference pointer)\n"
"]\n"
"GO\n"
"\n"
"CREATE OBJECT TYPE\n"
"WITH SINGLE MONAD OBJECTS\n"
"HAVING UNIQUE FIRST MONADS\n"
"[Token\n"
"   docid : INTEGER;\n"
"   parent : INTEGER;\n"
"   coref : LIST OF INTEGER;\n"
"   surface : STRING WITH INDEX; // Do not use FROM SET here, as it will likely slow things down, due to the high cardinality of \"surface\".\n"
"   mytype : STRING FROM SET WITH INDEX; // First part of terminal name\n"
"   function : STRING FROM SET WITH INDEX; // The rest of the terminal name (except for coreference pointer)\n"
"]\n"
"GO\n"
"\n"
"// Drop all indexes, so that importing takes a shorter amount of\n"
"// time.  \n"
"DROP INDEXES ON OBJECT TYPES [All] GO\n"
"\n"
;

char penn_treebank_id_d_schema[] = 
"//\n"
"// Penn Treebank Schema for Emdros 1.2.0.pre199 or later\n"
"// Author: Ulrik Sandborg-Petersen\n"
"// Last update: 7/11-2013\n"
"//\n"
"\n"
"CREATE OBJECT TYPE\n"
"WITH SINGLE RANGE OBJECTS\n"
"HAVING UNIQUE FIRST MONADS\n"
"[Document\n"
"]\n"
"GO\n"
"\n"
"\n"
"CREATE OBJECT TYPE\n"
"WITH SINGLE RANGE OBJECTS\n"
"HAVING UNIQUE FIRST MONADS\n"
"[DocumentRoot\n"
"   parent : ID_D; // Points to the document of which it is a part\n"
"]\n"
"GO\n"
"\n"
"\n"
"CREATE OBJECT TYPE\n"
"WITH SINGLE RANGE OBJECTS\n"
"[Nonterminal\n"
"   parent : ID_D;\n"
"   coref : LIST OF ID_D; // Coreference links\n"
"   nttype : STRING FROM SET WITH INDEX; // First part of nonterminal name\n"
"   function : STRING FROM SET WITH INDEX; // The rest of the nonterminal name (except for coreference pointer)\n"
"]\n"
"GO\n"
"\n"
"CREATE OBJECT TYPE\n"
"WITH SINGLE MONAD OBJECTS\n"
"HAVING UNIQUE FIRST MONADS\n"
"[Token\n"
"   parent : ID_D;\n"
"   coref : LIST OF ID_D;\n"
"   surface : STRING WITH INDEX; // Do not use FROM SET here, as it will likely slow things down, due to the high cardinality of \"surface\".\n"
"   mytype : STRING FROM SET WITH INDEX; // First part of terminal name\n"
"   function : STRING FROM SET WITH INDEX; // The rest of the terminal name (except for coreference pointer)\n"
"]\n"
"GO\n"
"\n"
"// Drop all indexes, so that importing takes a shorter amount of\n"
"// time.  \n"
"DROP INDEXES ON OBJECT TYPES [All] GO\n"
"\n"
;
