/* Generated by re2c 2.0.3 on Tue Dec  8 12:13:25 2020 */
#line 1 "./templatelang.re"
/*
 * templatelang.re
 *
 * Template language lexer based on re2c
 *
 * Ulrik Sandborg-Petersen
 * Created: 7/28-2008
 * Last update: 4/10-2019
 *
 */

/*
 * Copyright (C) 2001-2018     Ulrik Sandborg-Petersen
 * Copyright (C) 2018-present  Sandborg-Petersen Holding ApS, Denmark
 *
 * Licensed under the MIT License.
 *
 * Please see the file COPYING in the root of the sources for more details.
 *
 */

#include <templatelang_lexer.h>
#include "templatelangpars.h"
#include <iostream>
#include <string_func.h>

#define YYCTYPE         unsigned char
#define YYCURSOR        cur
#define YYLIMIT         lim
#define YYMARKER        ptr
#line 34 "./templatelang.re"



#line 69 "./templatelang.re"



TemplateLanguageScanner::TemplateLanguageScanner(const std::string& strIn)
{
	sz = strIn.c_str();
	lim = sz + strIn.length();
	bot = tok = ptr = pos = top = eof = 0;
	cur = sz;
}

TemplateLanguageScanner::~TemplateLanguageScanner()
{
	if (bot) {
		delete[] bot;
	}
}

/*
char *TemplateLanguageScanner::fill(char *cursor)
{
        if(!eof)
        {
                unsigned int cnt = tok - bot;
                if(cnt)
                {
                        memcpy(bot, tok, lim - tok);
                        tok = bot;
                        ptr -= cnt;
                        cursor -= cnt;
                        pos -= cnt;
                        lim -= cnt;
                }
                if((top - lim) < BSIZE)
                {
                        char *buf = new char[(lim - bot) + BSIZE];
                        memcpy(buf, tok, lim - tok);
                        tok = buf;
                        ptr = &buf[ptr - bot];
                        cursor = &buf[cursor - bot];
                        pos = &buf[pos - bot];
                        lim = &buf[lim - bot];
                        top = &lim[BSIZE];
                        delete [] bot;
                        bot = buf;
                }
                pIn->read(lim, BSIZE);
                if ((cnt = pIn->gcount()) != BSIZE )
                {
                        eof = &lim[cnt]; *eof++ = '\0';
                }
                lim += cnt;
        }
        return cursor;
}
*/

#define TEMPLATELANG_TOKEN_RETURN(X,Y) { yylval->setName(X); return Y; }

int TemplateLanguageScanner::scan(Token *pYYLVAL)
{
	yylval = pYYLVAL;

/* scan: */
	tok = cur;


#line 106 "./templatelang_lexer.cpp"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	yych = *YYCURSOR;
	if (yych <= '[') {
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto tt2;
				if (yych <= 0x08) goto tt4;
				if (yych <= '\t') goto tt6;
				goto tt8;
			} else {
				if (yych == '\r') goto tt10;
				if (yych <= 0x1F) goto tt4;
				goto tt12;
			}
		} else {
			if (yych <= '-') {
				if (yych == '\'') goto tt14;
				if (yych <= ',') goto tt4;
				goto tt16;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto tt4;
					goto tt18;
				} else {
					if (yych <= '@') goto tt4;
					if (yych <= 'Z') goto tt21;
					goto tt4;
				}
			}
		}
	} else {
		if (yych <= 'f') {
			if (yych <= '`') {
				if (yych <= '\\') goto tt24;
				if (yych == '_') goto tt21;
				goto tt4;
			} else {
				if (yych <= 'b') {
					if (yych <= 'a') goto tt25;
					goto tt21;
				} else {
					if (yych <= 'c') goto tt26;
					if (yych <= 'e') goto tt21;
					goto tt27;
				}
			}
		} else {
			if (yych <= 's') {
				if (yych == 'm') goto tt28;
				if (yych <= 'r') goto tt21;
				goto tt29;
			} else {
				if (yych <= 'v') {
					if (yych <= 'u') goto tt21;
					goto tt30;
				} else {
					if (yych <= 'z') goto tt21;
					if (yych <= '{') goto tt31;
					goto tt4;
				}
			}
		}
	}
tt2:
	++YYCURSOR;
#line 199 "./templatelang.re"
	{ if (cur >= lim) { goto end; } }
#line 176 "./templatelang_lexer.cpp"
tt4:
	++YYCURSOR;
tt5:
#line 202 "./templatelang.re"
	{ yylval->setChar(*tok); TEMPLATELANG_TOKEN_RETURN(CHAR_MAGIC, T_TEMPLATELANG_CHAR);}
#line 182 "./templatelang_lexer.cpp"
tt6:
	++YYCURSOR;
#line 195 "./templatelang.re"
	{ yylval->setChar('\t'); TEMPLATELANG_TOKEN_RETURN(CHAR_MAGIC, T_TEMPLATELANG_CHAR); }
#line 187 "./templatelang_lexer.cpp"
tt8:
	++YYCURSOR;
#line 197 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("\\n", T_TEMPLATELANG_KEY_NEWLINE); }
#line 192 "./templatelang_lexer.cpp"
tt10:
	++YYCURSOR;
#line 196 "./templatelang.re"
	{ yylval->setChar('\r'); TEMPLATELANG_TOKEN_RETURN(CHAR_MAGIC, T_TEMPLATELANG_CHAR); }
#line 197 "./templatelang_lexer.cpp"
tt12:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '}') goto tt32;
tt13:
#line 194 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN(" ", T_TEMPLATELANG_KEY_SPACE); }
#line 205 "./templatelang_lexer.cpp"
tt14:
	++YYCURSOR;
#line 191 "./templatelang.re"
	{ yylval->setString(new std::string);
		         goto stringsq; 
                       }
#line 212 "./templatelang_lexer.cpp"
tt16:
	++YYCURSOR;
#line 198 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("-", T_TEMPLATELANG_KEY_DASH); }
#line 217 "./templatelang_lexer.cpp"
tt18:
	yych = *++YYCURSOR;
	if (yych <= '/') goto tt20;
	if (yych <= '9') goto tt18;
tt20:
#line 189 "./templatelang.re"
	{ addInteger();
                         TEMPLATELANG_TOKEN_RETURN(INTEGER_MAGIC, T_TEMPLATELANG_INTEGER); }
#line 226 "./templatelang_lexer.cpp"
tt21:
	yych = *++YYCURSOR;
tt22:
	if (yych <= 'Z') {
		if (yych <= '/') goto tt23;
		if (yych <= '9') goto tt21;
		if (yych >= 'A') goto tt21;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt21;
		} else {
			if (yych <= '`') goto tt23;
			if (yych <= 'z') goto tt21;
		}
	}
tt23:
#line 188 "./templatelang.re"
	{ addToken(); TEMPLATELANG_TOKEN_RETURN("identifier", T_TEMPLATELANG_IDENTIFIER);}
#line 245 "./templatelang_lexer.cpp"
tt24:
	yych = *++YYCURSOR;
	if (yych == '\'') goto tt34;
	if (yych == '\\') goto tt36;
	goto tt5;
tt25:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt38;
	goto tt22;
tt26:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt39;
	goto tt22;
tt27:
	yych = *++YYCURSOR;
	if (yych <= 'n') {
		if (yych == 'e') goto tt40;
		goto tt22;
	} else {
		if (yych <= 'o') goto tt41;
		if (yych == 'r') goto tt42;
		goto tt22;
	}
tt28:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt43;
	goto tt22;
tt29:
	yych = *++YYCURSOR;
	if (yych == 'u') goto tt44;
	goto tt22;
tt30:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt45;
	goto tt22;
tt31:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '{') goto tt46;
	goto tt5;
tt32:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt47;
tt33:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 3) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto tt13;
			} else {
				goto tt5;
			}
		} else {
			if (yyaccept == 2) {
				goto tt203;
			} else {
				goto tt230;
			}
		}
	} else {
		if (yyaccept <= 5) {
			if (yyaccept == 4) {
				goto tt248;
			} else {
				goto tt379;
			}
		} else {
			goto tt447;
		}
	}
tt34:
	++YYCURSOR;
#line 201 "./templatelang.re"
	{ yylval->setChar('\''); TEMPLATELANG_TOKEN_RETURN(CHAR_MAGIC, T_TEMPLATELANG_CHAR); }
#line 320 "./templatelang_lexer.cpp"
tt36:
	++YYCURSOR;
#line 200 "./templatelang.re"
	{ yylval->setChar('\\'); TEMPLATELANG_TOKEN_RETURN(CHAR_MAGIC, T_TEMPLATELANG_CHAR); }
#line 325 "./templatelang_lexer.cpp"
tt38:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt49;
	goto tt22;
tt39:
	yych = *++YYCURSOR;
	if (yych == 'u') goto tt50;
	goto tt22;
tt40:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt51;
	goto tt22;
tt41:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt52;
	goto tt22;
tt42:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt53;
	goto tt22;
tt43:
	yych = *++YYCURSOR;
	if (yych == 'x') goto tt54;
	goto tt22;
tt44:
	yych = *++YYCURSOR;
	if (yych == 'b') goto tt55;
	goto tt22;
tt45:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt56;
	goto tt22;
tt46:
	yych = *++YYCURSOR;
	if (yych == ' ') goto tt58;
	goto tt33;
tt47:
	++YYCURSOR;
#line 136 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("}}", T_TEMPLATELANG_KEY_BB_CLOSE); }
#line 366 "./templatelang_lexer.cpp"
tt49:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt59;
	goto tt22;
tt50:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt60;
	goto tt22;
tt51:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt61;
	goto tt22;
tt52:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt62;
	goto tt22;
tt53:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt63;
	goto tt22;
tt54:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt65;
	goto tt22;
tt55:
	yych = *++YYCURSOR;
	if (yych == 's') goto tt66;
	goto tt22;
tt56:
	yych = *++YYCURSOR;
	if (yych <= '^') {
		if (yych <= '9') {
			if (yych >= '0') goto tt21;
		} else {
			if (yych <= '@') goto tt57;
			if (yych <= 'Z') goto tt21;
		}
	} else {
		if (yych <= 'm') {
			if (yych != '`') goto tt21;
		} else {
			if (yych <= 'n') goto tt67;
			if (yych <= 'z') goto tt21;
		}
	}
tt57:
#line 173 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("bare-var", T_TEMPLATELANG_KEY_BARE_VAR); }
#line 415 "./templatelang_lexer.cpp"
tt58:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'a':	goto tt68;
	case 'c':	goto tt69;
	case 'd':	goto tt70;
	case 'e':	goto tt71;
	case 'f':	goto tt72;
	case 'i':	goto tt73;
	case 'l':	goto tt74;
	case 'n':	goto tt75;
	case 's':	goto tt76;
	default:	goto tt33;
	}
tt59:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt77;
	goto tt22;
tt60:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt78;
	goto tt22;
tt61:
	yych = *++YYCURSOR;
	if (yych == 'u') goto tt79;
	goto tt22;
tt62:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt80;
	goto tt22;
tt63:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt64;
		if (yych <= '9') goto tt21;
		if (yych >= 'A') goto tt21;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt21;
		} else {
			if (yych <= '`') goto tt64;
			if (yych <= 'z') goto tt21;
		}
	}
tt64:
#line 170 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("bare-from", T_TEMPLATELANG_KEY_BARE_FROM); }
#line 463 "./templatelang_lexer.cpp"
tt65:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt81;
	goto tt22;
tt66:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt82;
	goto tt22;
tt67:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt83;
	goto tt22;
tt68:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt84;
	goto tt33;
tt69:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt85;
	goto tt33;
tt70:
	yych = *++YYCURSOR;
	if (yych <= 'd') {
		if (yych == 'b') goto tt86;
		goto tt33;
	} else {
		if (yych <= 'e') goto tt87;
		if (yych == 'i') goto tt88;
		goto tt33;
	}
tt71:
	yych = *++YYCURSOR;
	if (yych <= 'k') goto tt33;
	if (yych <= 'l') goto tt89;
	if (yych <= 'm') goto tt90;
	if (yych <= 'n') goto tt91;
	goto tt33;
tt72:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt92;
	if (yych == 'i') goto tt93;
	goto tt33;
tt73:
	yych = *++YYCURSOR;
	if (yych <= 'e') {
		if (yych == 'd') goto tt94;
		goto tt33;
	} else {
		if (yych <= 'f') goto tt95;
		if (yych == 'n') goto tt96;
		goto tt33;
	}
tt74:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt97;
	if (yych == 'i') goto tt98;
	goto tt33;
tt75:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt99;
	goto tt33;
tt76:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt100;
	goto tt33;
tt77:
	yych = *++YYCURSOR;
	if (yych == 'b') goto tt101;
	goto tt22;
tt78:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt103;
	goto tt22;
tt79:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt104;
	goto tt22;
tt80:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt105;
	goto tt22;
tt81:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt107;
	goto tt22;
tt82:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt108;
	goto tt22;
tt83:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt109;
	goto tt22;
tt84:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt110;
	goto tt33;
tt85:
	yych = *++YYCURSOR;
	if (yych == 'p') goto tt111;
	if (yych == 'u') goto tt112;
	goto tt33;
tt86:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt113;
	goto tt33;
tt87:
	yych = *++YYCURSOR;
	if (yych == 'c') goto tt114;
	goto tt33;
tt88:
	yych = *++YYCURSOR;
	if (yych == 'c') goto tt115;
	goto tt33;
tt89:
	yych = *++YYCURSOR;
	if (yych == 's') goto tt116;
	goto tt33;
tt90:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt117;
	goto tt33;
tt91:
	yych = *++YYCURSOR;
	if (yych == 'd') goto tt118;
	goto tt33;
tt92:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt119;
	goto tt33;
tt93:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt120;
	goto tt33;
tt94:
	yych = *++YYCURSOR;
	if (yych == '_') goto tt121;
	goto tt33;
tt95:
	yych = *++YYCURSOR;
	if (yych == ' ') goto tt122;
	goto tt33;
tt96:
	yych = *++YYCURSOR;
	if (yych == 'c') goto tt123;
	goto tt33;
tt97:
	yych = *++YYCURSOR;
	if (yych == 's') goto tt124;
	goto tt33;
tt98:
	yych = *++YYCURSOR;
	if (yych == 's') goto tt125;
	goto tt33;
tt99:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt126;
	goto tt33;
tt100:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt127;
	goto tt33;
tt101:
	yych = *++YYCURSOR;
	if (yych <= '^') {
		if (yych <= '9') {
			if (yych >= '0') goto tt21;
		} else {
			if (yych <= '@') goto tt102;
			if (yych <= 'Z') goto tt21;
		}
	} else {
		if (yych <= 'm') {
			if (yych != '`') goto tt21;
		} else {
			if (yych <= 'n') goto tt128;
			if (yych <= 'z') goto tt21;
		}
	}
tt102:
#line 165 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("bare-attrib", T_TEMPLATELANG_KEY_BARE_ATTRIB); }
#line 646 "./templatelang_lexer.cpp"
tt103:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt129;
	goto tt22;
tt104:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt131;
	goto tt22;
tt105:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt106;
		if (yych <= '9') goto tt21;
		if (yych >= 'A') goto tt21;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt21;
		} else {
			if (yych <= '`') goto tt106;
			if (yych <= 'z') goto tt21;
		}
	}
tt106:
#line 169 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("bare-format", T_TEMPLATELANG_KEY_BARE_FORMAT); }
#line 672 "./templatelang_lexer.cpp"
tt107:
	yych = *++YYCURSOR;
	if (yych == 'g') goto tt133;
	goto tt22;
tt108:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt134;
	goto tt22;
tt109:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt135;
	goto tt22;
tt110:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt136;
	goto tt33;
tt111:
	yych = *++YYCURSOR;
	if (yych == 'y') goto tt137;
	goto tt33;
tt112:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt138;
	goto tt33;
tt113:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt139;
	goto tt33;
tt114:
	yych = *++YYCURSOR;
	if (yych == 'c') goto tt140;
	goto tt33;
tt115:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt141;
	goto tt33;
tt116:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt142;
	goto tt33;
tt117:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt143;
	goto tt33;
tt118:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt144;
	goto tt33;
tt119:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt145;
	goto tt33;
tt120:
	yych = *++YYCURSOR;
	if (yych == 's') goto tt146;
	goto tt33;
tt121:
	yych = *++YYCURSOR;
	if (yych == 'd') goto tt147;
	goto tt33;
tt122:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'a':	goto tt148;
	case 'f':	goto tt149;
	case 'h':	goto tt150;
	case 'l':	goto tt151;
	case 'n':	goto tt152;
	case 'v':	goto tt153;
	default:	goto tt33;
	}
tt123:
	yych = *++YYCURSOR;
	if (yych == 'c') goto tt154;
	goto tt33;
tt124:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt155;
	goto tt33;
tt125:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt156;
	goto tt33;
tt126:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt157;
	goto tt33;
tt127:
	yych = *++YYCURSOR;
	if (yych <= 'm') {
		if (yych == 'c') goto tt158;
		goto tt33;
	} else {
		if (yych <= 'n') goto tt159;
		if (yych == 'v') goto tt160;
		goto tt33;
	}
tt128:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt161;
	goto tt22;
tt129:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt130;
		if (yych <= '9') goto tt21;
		if (yych >= 'A') goto tt21;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt21;
		} else {
			if (yych <= '`') goto tt130;
			if (yych <= 'z') goto tt21;
		}
	}
tt130:
#line 167 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("bare-counter", T_TEMPLATELANG_KEY_BARE_COUNTER); }
#line 791 "./templatelang_lexer.cpp"
tt131:
	yych = *++YYCURSOR;
	if (yych <= '_') {
		if (yych <= '@') {
			if (yych <= '/') goto tt132;
			if (yych <= '9') goto tt21;
		} else {
			if (yych <= 'Z') goto tt21;
			if (yych >= '_') goto tt21;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= '`') goto tt132;
			if (yych <= 'i') goto tt21;
			goto tt162;
		} else {
			if (yych == 'n') goto tt163;
			if (yych <= 'z') goto tt21;
		}
	}
tt132:
#line 168 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("bare-feature", T_TEMPLATELANG_KEY_BARE_FEATURE); }
#line 815 "./templatelang_lexer.cpp"
tt133:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt164;
	goto tt22;
tt134:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt165;
	goto tt22;
tt135:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt166;
	goto tt22;
tt136:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt167;
	goto tt33;
tt137:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt168;
	goto tt33;
tt138:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt169;
	goto tt33;
tt139:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt170;
	goto tt33;
tt140:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt171;
	goto tt33;
tt141:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt172;
	goto tt33;
tt142:
	yych = *++YYCURSOR;
	if (yych == ' ') goto tt173;
	goto tt33;
tt143:
	yych = *++YYCURSOR;
	if (yych == 'v') goto tt174;
	goto tt33;
tt144:
	yych = *++YYCURSOR;
	if (yych == 'f') goto tt175;
	goto tt33;
tt145:
	yych = *++YYCURSOR;
	if (yych == 'u') goto tt176;
	goto tt33;
tt146:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt177;
	goto tt33;
tt147:
	yych = *++YYCURSOR;
	if (yych == ' ') goto tt178;
	goto tt33;
tt148:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt179;
	goto tt33;
tt149:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt180;
	goto tt33;
tt150:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt181;
	goto tt33;
tt151:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt182;
	goto tt33;
tt152:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt183;
	goto tt33;
tt153:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt184;
	goto tt33;
tt154:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt185;
	goto tt33;
tt155:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt186;
	goto tt33;
tt156:
	yych = *++YYCURSOR;
	if (yych <= 'b') {
		if (yych == 'a') goto tt187;
		goto tt33;
	} else {
		if (yych <= 'c') goto tt188;
		if (yych == 'e') goto tt189;
		goto tt33;
	}
tt157:
	yych = *++YYCURSOR;
	if (yych == 'd') goto tt190;
	goto tt33;
tt158:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt191;
	goto tt33;
tt159:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt192;
	goto tt33;
tt160:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt193;
	goto tt33;
tt161:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt194;
	goto tt22;
tt162:
	yych = *++YYCURSOR;
	if (yych == 's') goto tt195;
	goto tt22;
tt163:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt196;
	goto tt22;
tt164:
	yych = *++YYCURSOR;
	if (yych == 'h') goto tt197;
	goto tt22;
tt165:
	yych = *++YYCURSOR;
	if (yych == 'g') goto tt199;
	goto tt22;
tt166:
	yych = *++YYCURSOR;
	if (yych == 'g') goto tt201;
	goto tt22;
tt167:
	yych = *++YYCURSOR;
	if (yych == 'b') goto tt202;
	goto tt33;
tt168:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt204;
	goto tt33;
tt169:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt205;
	goto tt33;
tt170:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt206;
	goto tt33;
tt171:
	yych = *++YYCURSOR;
	if (yych == 'u') goto tt207;
	goto tt33;
tt172:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt208;
	goto tt33;
tt173:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt209;
	goto tt33;
tt174:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt210;
	goto tt33;
tt175:
	yych = *++YYCURSOR;
	if (yych == ' ') goto tt211;
	goto tt33;
tt176:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt212;
	goto tt33;
tt177:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt213;
	goto tt33;
tt178:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt214;
	goto tt33;
tt179:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt215;
	goto tt33;
tt180:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt216;
	goto tt33;
tt181:
	yych = *++YYCURSOR;
	if (yych == 's') goto tt217;
	goto tt33;
tt182:
	yych = *++YYCURSOR;
	if (yych == 's') goto tt218;
	goto tt33;
tt183:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt219;
	goto tt33;
tt184:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt220;
	goto tt33;
tt185:
	yych = *++YYCURSOR;
	if (yych == 'u') goto tt221;
	goto tt33;
tt186:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt222;
	goto tt33;
tt187:
	yych = *++YYCURSOR;
	if (yych == 'p') goto tt223;
	goto tt33;
tt188:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt224;
	goto tt33;
tt189:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt225;
	goto tt33;
tt190:
	yych = *++YYCURSOR;
	if (yych == 's') goto tt226;
	goto tt33;
tt191:
	yych = *++YYCURSOR;
	if (yych == 'u') goto tt227;
	goto tt33;
tt192:
	yych = *++YYCURSOR;
	if (yych == 'x') goto tt228;
	goto tt33;
tt193:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt229;
	goto tt33;
tt194:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt231;
	goto tt22;
tt195:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt232;
	goto tt22;
tt196:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt233;
	goto tt22;
tt197:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt198;
		if (yych <= '9') goto tt21;
		if (yych >= 'A') goto tt21;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt21;
		} else {
			if (yych <= '`') goto tt198;
			if (yych <= 'z') goto tt21;
		}
	}
tt198:
#line 171 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("bare-maxlength", T_TEMPLATELANG_KEY_BARE_MAXLENGTH); }
#line 1095 "./templatelang_lexer.cpp"
tt199:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt200;
		if (yych <= '9') goto tt21;
		if (yych >= 'A') goto tt21;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt21;
		} else {
			if (yych <= '`') goto tt200;
			if (yych <= 'z') goto tt21;
		}
	}
tt200:
#line 172 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("bare-substring", T_TEMPLATELANG_KEY_BARE_SUBSTRING); }
#line 1113 "./templatelang_lexer.cpp"
tt201:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt234;
	goto tt22;
tt202:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'n') goto tt235;
tt203:
#line 179 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("attrib", T_TEMPLATELANG_KEY_ATTRIB); }
#line 1125 "./templatelang_lexer.cpp"
tt204:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt236;
	goto tt33;
tt205:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt237;
	goto tt33;
tt206:
	yych = *++YYCURSOR;
	if (yych == ' ') goto tt239;
	goto tt33;
tt207:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt240;
	goto tt33;
tt208:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt241;
	goto tt33;
tt209:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt242;
	goto tt33;
tt210:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt244;
	goto tt33;
tt211:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt246;
	goto tt33;
tt212:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt247;
	goto tt33;
tt213:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt249;
	goto tt33;
tt214:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt250;
	goto tt33;
tt215:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt252;
	goto tt33;
tt216:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt253;
	goto tt33;
tt217:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt254;
	goto tt33;
tt218:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt255;
	goto tt33;
tt219:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt256;
	goto tt33;
tt220:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt257;
	goto tt33;
tt221:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt258;
	goto tt33;
tt222:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt259;
	goto tt33;
tt223:
	yych = *++YYCURSOR;
	if (yych == 'p') goto tt260;
	goto tt33;
tt224:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt261;
	goto tt33;
tt225:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt262;
	goto tt33;
tt226:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt263;
	goto tt33;
tt227:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt264;
	goto tt33;
tt228:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt265;
	goto tt33;
tt229:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'e') goto tt266;
tt230:
#line 156 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("setvar", T_TEMPLATELANG_KEY_SETVAR); }
#line 1233 "./templatelang_lexer.cpp"
tt231:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt267;
	goto tt22;
tt232:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt268;
	goto tt22;
tt233:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt269;
	goto tt22;
tt234:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt270;
	goto tt22;
tt235:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt272;
	goto tt33;
tt236:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt273;
	goto tt33;
tt237:
	++YYCURSOR;
#line 144 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("counter", T_TEMPLATELANG_KEY_COUNTER); }
#line 1262 "./templatelang_lexer.cpp"
tt239:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt274;
	goto tt33;
tt240:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt275;
	goto tt33;
tt241:
	yych = *++YYCURSOR;
	if (yych == 'k') goto tt276;
	goto tt33;
tt242:
	++YYCURSOR;
#line 137 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("else", T_TEMPLATELANG_KEY_ELSE); }
#line 1279 "./templatelang_lexer.cpp"
tt244:
	++YYCURSOR;
#line 160 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("emitvar", T_TEMPLATELANG_KEY_EMITVAR); }
#line 1284 "./templatelang_lexer.cpp"
tt246:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt277;
	goto tt33;
tt247:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'j') goto tt279;
	if (yych == 'n') goto tt280;
tt248:
#line 164 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("feature", T_TEMPLATELANG_KEY_FEATURE); }
#line 1297 "./templatelang_lexer.cpp"
tt249:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt281;
	goto tt33;
tt250:
	++YYCURSOR;
#line 139 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("id_d", T_TEMPLATELANG_KEY_ID_D); }
#line 1306 "./templatelang_lexer.cpp"
tt252:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt282;
	goto tt33;
tt253:
	yych = *++YYCURSOR;
	if (yych == 'u') goto tt283;
	goto tt33;
tt254:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt284;
	goto tt33;
tt255:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt285;
	goto tt33;
tt256:
	yych = *++YYCURSOR;
	if (yych == 'd') goto tt286;
	goto tt33;
tt257:
	yych = *++YYCURSOR;
	if (yych == 'q') goto tt287;
	goto tt33;
tt258:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt288;
	goto tt33;
tt259:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt289;
	goto tt33;
tt260:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt290;
	goto tt33;
tt261:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt291;
	goto tt33;
tt262:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt292;
	goto tt33;
tt263:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt294;
	goto tt33;
tt264:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt295;
	goto tt33;
tt265:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt296;
	goto tt33;
tt266:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt297;
	goto tt33;
tt267:
	yych = *++YYCURSOR;
	if (yych == 'g') goto tt298;
	goto tt22;
tt268:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt299;
	goto tt22;
tt269:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt300;
	goto tt22;
tt270:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt271;
		if (yych <= '9') goto tt21;
		if (yych >= 'A') goto tt21;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt21;
		} else {
			if (yych <= '`') goto tt271;
			if (yych <= 'z') goto tt21;
		}
	}
tt271:
#line 174 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("bare-varnomangle", T_TEMPLATELANG_KEY_BARE_VARNOMANGLE); }
#line 1396 "./templatelang_lexer.cpp"
tt272:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt301;
	goto tt33;
tt273:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt302;
	goto tt33;
tt274:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt303;
	goto tt33;
tt275:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt305;
	goto tt33;
tt276:
	yych = *++YYCURSOR;
	if (yych == 'u') goto tt306;
	goto tt33;
tt277:
	++YYCURSOR;
#line 138 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("endif", T_TEMPLATELANG_KEY_ENDIF); }
#line 1421 "./templatelang_lexer.cpp"
tt279:
	yych = *++YYCURSOR;
	if (yych == 's') goto tt307;
	goto tt33;
tt280:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt308;
	goto tt33;
tt281:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt309;
	goto tt33;
tt282:
	yych = *++YYCURSOR;
	if (yych == 'b') goto tt310;
	goto tt33;
tt283:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt311;
	goto tt33;
tt284:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt312;
	goto tt33;
tt285:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt313;
	goto tt33;
tt286:
	yych = *++YYCURSOR;
	if (yych == 's') goto tt314;
	goto tt33;
tt287:
	yych = *++YYCURSOR;
	if (yych == 'u') goto tt315;
	goto tt33;
tt288:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt316;
	goto tt33;
tt289:
	yych = *++YYCURSOR;
	if (yych == 'd') goto tt317;
	goto tt33;
tt290:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt318;
	goto tt33;
tt291:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt319;
	goto tt33;
tt292:
	++YYCURSOR;
#line 147 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("listemit", T_TEMPLATELANG_KEY_LISTEMIT); }
#line 1478 "./templatelang_lexer.cpp"
tt294:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'a':	goto tt321;
	case 'c':	goto tt322;
	case 'e':	goto tt323;
	case 'r':	goto tt324;
	default:	goto tt33;
	}
tt295:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt325;
	goto tt33;
tt296:
	yych = *++YYCURSOR;
	if (yych == 'g') goto tt326;
	goto tt33;
tt297:
	yych = *++YYCURSOR;
	if (yych == 'd') goto tt327;
	goto tt33;
tt298:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt328;
	goto tt22;
tt299:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt329;
	goto tt22;
tt300:
	yych = *++YYCURSOR;
	if (yych == 'g') goto tt330;
	goto tt22;
tt301:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt331;
	goto tt33;
tt302:
	yych = *++YYCURSOR;
	if (yych == 'b') goto tt332;
	goto tt33;
tt303:
	++YYCURSOR;
#line 142 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("dbname", T_TEMPLATELANG_KEY_DBNAME); }
#line 1524 "./templatelang_lexer.cpp"
tt305:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt333;
	goto tt33;
tt306:
	yych = *++YYCURSOR;
	if (yych == 'p') goto tt335;
	goto tt33;
tt307:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt337;
	goto tt33;
tt308:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt338;
	goto tt33;
tt309:
	yych = *++YYCURSOR;
	if (yych == 'd') goto tt339;
	goto tt33;
tt310:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt340;
	goto tt33;
tt311:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt341;
	goto tt33;
tt312:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt342;
	goto tt33;
tt313:
	yych = *++YYCURSOR;
	if (yych == 'p') goto tt343;
	goto tt33;
tt314:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt344;
	goto tt33;
tt315:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt345;
	goto tt33;
tt316:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt346;
	goto tt33;
tt317:
	yych = *++YYCURSOR;
	if (yych == ' ') goto tt348;
	goto tt33;
tt318:
	yych = *++YYCURSOR;
	if (yych == 'd') goto tt349;
	goto tt33;
tt319:
	++YYCURSOR;
#line 148 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("listclear", T_TEMPLATELANG_KEY_LISTCLEAR); }
#line 1585 "./templatelang_lexer.cpp"
tt321:
	yych = *++YYCURSOR;
	if (yych == 'd') goto tt350;
	goto tt33;
tt322:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt351;
	goto tt33;
tt323:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt352;
	goto tt33;
tt324:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt353;
	goto tt33;
tt325:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt354;
	goto tt33;
tt326:
	yych = *++YYCURSOR;
	if (yych == ' ') goto tt356;
	goto tt33;
tt327:
	yych = *++YYCURSOR;
	if (yych == ' ') goto tt357;
	goto tt33;
tt328:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt358;
	goto tt22;
tt329:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt360;
	goto tt22;
tt330:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt361;
	goto tt22;
tt331:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt362;
	goto tt33;
tt332:
	yych = *++YYCURSOR;
	if (yych == 's') goto tt363;
	goto tt33;
tt333:
	++YYCURSOR;
#line 163 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("deccounter", T_TEMPLATELANG_KEY_DECCOUNTER); }
#line 1638 "./templatelang_lexer.cpp"
tt335:
	++YYCURSOR;
#line 143 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("dictlookup", T_TEMPLATELANG_KEY_DICTLOOKUP); }
#line 1643 "./templatelang_lexer.cpp"
tt337:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt365;
	goto tt33;
tt338:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt366;
	goto tt33;
tt339:
	yych = *++YYCURSOR;
	if (yych == ' ') goto tt367;
	goto tt33;
tt340:
	yych = *++YYCURSOR;
	if (yych == 'q') goto tt368;
	goto tt33;
tt341:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt369;
	goto tt33;
tt342:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt370;
	goto tt33;
tt343:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt371;
	goto tt33;
tt344:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt372;
	goto tt33;
tt345:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt373;
	goto tt33;
tt346:
	++YYCURSOR;
#line 162 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("inccounter", T_TEMPLATELANG_KEY_INCCOUNTER); }
#line 1684 "./templatelang_lexer.cpp"
tt348:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt375;
	goto tt33;
tt349:
	yych = *++YYCURSOR;
	if (yych == 'b') goto tt376;
	if (yych == 'e') goto tt377;
	goto tt33;
tt350:
	yych = *++YYCURSOR;
	if (yych == 'd') goto tt378;
	goto tt33;
tt351:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt380;
	goto tt33;
tt352:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt381;
	goto tt33;
tt353:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt382;
	goto tt33;
tt354:
	++YYCURSOR;
#line 161 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("setcounter", T_TEMPLATELANG_KEY_SETCOUNTER); }
#line 1714 "./templatelang_lexer.cpp"
tt356:
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'a') goto tt383;
		goto tt33;
	} else {
		if (yych <= 'd') goto tt384;
		if (yych == 'o') goto tt385;
		goto tt33;
	}
tt357:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt386;
	goto tt33;
tt358:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt359;
		if (yych <= '9') goto tt21;
		if (yych >= 'A') goto tt21;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt21;
		} else {
			if (yych <= '`') goto tt359;
			if (yych <= 'z') goto tt21;
		}
	}
tt359:
#line 166 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("bare-attribnomangle", T_TEMPLATELANG_KEY_BARE_ATTRIBNOMANGLE); }
#line 1746 "./templatelang_lexer.cpp"
tt360:
	yych = *++YYCURSOR;
	if (yych == 'g') goto tt387;
	goto tt22;
tt361:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt388;
	goto tt22;
tt362:
	yych = *++YYCURSOR;
	if (yych == 'g') goto tt390;
	goto tt33;
tt363:
	++YYCURSOR;
#line 180 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("copyattribs", T_TEMPLATELANG_KEY_COPYATTRIBS); }
#line 1763 "./templatelang_lexer.cpp"
tt365:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt391;
	goto tt33;
tt366:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt392;
	goto tt33;
tt367:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt393;
	goto tt33;
tt368:
	yych = *++YYCURSOR;
	if (yych == 'u') goto tt394;
	goto tt33;
tt369:
	yych = *++YYCURSOR;
	if (yych == 'q') goto tt395;
	goto tt33;
tt370:
	yych = *++YYCURSOR;
	if (yych == 'b') goto tt396;
	goto tt33;
tt371:
	yych = *++YYCURSOR;
	if (yych == 'y') goto tt398;
	goto tt33;
tt372:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt400;
	goto tt33;
tt373:
	++YYCURSOR;
#line 183 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("varequal", T_TEMPLATELANG_KEY_IF_VAREQUAL); }
#line 1800 "./templatelang_lexer.cpp"
tt375:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt401;
	goto tt33;
tt376:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt403;
	goto tt33;
tt377:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt404;
	goto tt33;
tt378:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'e') goto tt405;
tt379:
#line 149 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("namedsetadd", T_TEMPLATELANG_KEY_NAMEDSETADD); }
#line 1820 "./templatelang_lexer.cpp"
tt380:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt406;
	goto tt33;
tt381:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt407;
	goto tt33;
tt382:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt409;
	goto tt33;
tt383:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt410;
	goto tt33;
tt384:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt411;
	goto tt33;
tt385:
	yych = *++YYCURSOR;
	if (yych == 'f') goto tt412;
	goto tt33;
tt386:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt413;
	goto tt33;
tt387:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt415;
	goto tt22;
tt388:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt389;
		if (yych <= '9') goto tt21;
		if (yych >= 'A') goto tt21;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt21;
		} else {
			if (yych <= '`') goto tt389;
			if (yych <= 'z') goto tt21;
		}
	}
tt389:
#line 177 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("bare-featurenomangle", T_TEMPLATELANG_KEY_BARE_FEATURENOMANGLE); }
#line 1870 "./templatelang_lexer.cpp"
tt390:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt416;
	goto tt33;
tt391:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt417;
	goto tt33;
tt392:
	yych = *++YYCURSOR;
	if (yych == 'g') goto tt418;
	goto tt33;
tt393:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt419;
	goto tt33;
tt394:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt421;
	goto tt33;
tt395:
	yych = *++YYCURSOR;
	if (yych == 'u') goto tt422;
	goto tt33;
tt396:
	++YYCURSOR;
#line 186 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("hasattrib", T_TEMPLATELANG_KEY_IF_HASATTRIB); }
#line 1899 "./templatelang_lexer.cpp"
tt398:
	++YYCURSOR;
#line 184 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("listempty", T_TEMPLATELANG_KEY_IF_LISTEMPTY); }
#line 1904 "./templatelang_lexer.cpp"
tt400:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt423;
	goto tt33;
tt401:
	++YYCURSOR;
#line 141 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("lastmonad", T_TEMPLATELANG_KEY_LASTMONAD); }
#line 1913 "./templatelang_lexer.cpp"
tt403:
	yych = *++YYCURSOR;
	if (yych == 'g') goto tt424;
	goto tt33;
tt404:
	yych = *++YYCURSOR;
	if (yych == 'd') goto tt425;
	goto tt33;
tt405:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt426;
	goto tt33;
tt406:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt427;
	goto tt33;
tt407:
	++YYCURSOR;
#line 153 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("namedsetemit", T_TEMPLATELANG_KEY_NAMEDSETEMIT); }
#line 1934 "./templatelang_lexer.cpp"
tt409:
	yych = *++YYCURSOR;
	if (yych == 'v') goto tt429;
	goto tt33;
tt410:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt430;
	goto tt33;
tt411:
	yych = *++YYCURSOR;
	if (yych == 'c') goto tt431;
	goto tt33;
tt412:
	yych = *++YYCURSOR;
	if (yych == 'f') goto tt432;
	goto tt33;
tt413:
	++YYCURSOR;
#line 155 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("setvarend", T_TEMPLATELANG_KEY_SETVAREND); }
#line 1955 "./templatelang_lexer.cpp"
tt415:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt433;
	goto tt22;
tt416:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt435;
	goto tt33;
tt417:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt437;
	goto tt33;
tt418:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt438;
	goto tt33;
tt419:
	++YYCURSOR;
#line 140 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("firstmonad", T_TEMPLATELANG_KEY_FIRSTMONAD); }
#line 1976 "./templatelang_lexer.cpp"
tt421:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt439;
	goto tt33;
tt422:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt441;
	goto tt33;
tt423:
	yych = *++YYCURSOR;
	if (yych == 'p') goto tt442;
	goto tt33;
tt424:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt443;
	goto tt33;
tt425:
	yych = *++YYCURSOR;
	if (yych == ' ') goto tt444;
	goto tt33;
tt426:
	yych = *++YYCURSOR;
	if (yych == 'd') goto tt445;
	goto tt33;
tt427:
	++YYCURSOR;
#line 154 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("namedsetclear", T_TEMPLATELANG_KEY_NAMEDSETCLEAR); }
#line 2005 "./templatelang_lexer.cpp"
tt429:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt446;
	goto tt33;
tt430:
	yych = *++YYCURSOR;
	if (yych == ' ') goto tt448;
	goto tt33;
tt431:
	yych = *++YYCURSOR;
	if (yych == ' ') goto tt449;
	goto tt33;
tt432:
	yych = *++YYCURSOR;
	if (yych == ' ') goto tt450;
	goto tt33;
tt433:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt434;
		if (yych <= '9') goto tt21;
		if (yych >= 'A') goto tt21;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt21;
		} else {
			if (yych <= '`') goto tt434;
			if (yych <= 'z') goto tt21;
		}
	}
tt434:
#line 178 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("bare-featurejsonmangle", T_TEMPLATELANG_KEY_BARE_FEATUREJSONMANGLE); }
#line 2039 "./templatelang_lexer.cpp"
tt435:
	++YYCURSOR;
#line 181 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("attribnomangle", T_TEMPLATELANG_KEY_ATTRIB_NOMANGLE); }
#line 2044 "./templatelang_lexer.cpp"
tt437:
	yych = *++YYCURSOR;
	if (yych == 'g') goto tt451;
	goto tt33;
tt438:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt452;
	goto tt33;
tt439:
	++YYCURSOR;
#line 187 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("attribequal", T_TEMPLATELANG_KEY_IF_ATTRIBEQUAL); }
#line 2057 "./templatelang_lexer.cpp"
tt441:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt454;
	goto tt33;
tt442:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt456;
	goto tt33;
tt443:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt457;
	goto tt33;
tt444:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt459;
	goto tt33;
tt445:
	yych = *++YYCURSOR;
	if (yych == ' ') goto tt460;
	goto tt33;
tt446:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'e') goto tt461;
tt447:
#line 151 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("namedsetremove", T_TEMPLATELANG_KEY_NAMEDSETREMOVE); }
#line 2085 "./templatelang_lexer.cpp"
tt448:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt462;
	goto tt33;
tt449:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt463;
	goto tt33;
tt450:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt464;
	goto tt33;
tt451:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt465;
	goto tt33;
tt452:
	++YYCURSOR;
#line 175 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("featurenomangle", T_TEMPLATELANG_KEY_FEATURENOMANGLE); }
#line 2106 "./templatelang_lexer.cpp"
tt454:
	++YYCURSOR;
#line 182 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("featureequal", T_TEMPLATELANG_KEY_IF_FEATUREEQUAL); }
#line 2111 "./templatelang_lexer.cpp"
tt456:
	yych = *++YYCURSOR;
	if (yych == 'y') goto tt466;
	goto tt33;
tt457:
	++YYCURSOR;
#line 145 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("listappendbegin", T_TEMPLATELANG_KEY_LISTAPPENDBEGIN); }
#line 2120 "./templatelang_lexer.cpp"
tt459:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt468;
	goto tt33;
tt460:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt470;
	goto tt33;
tt461:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt471;
	goto tt33;
tt462:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt472;
	goto tt33;
tt463:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt474;
	goto tt33;
tt464:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt476;
	goto tt33;
tt465:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt478;
	goto tt33;
tt466:
	++YYCURSOR;
#line 185 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("namedsetempty", T_TEMPLATELANG_KEY_IF_NAMEDSETEMPTY); }
#line 2153 "./templatelang_lexer.cpp"
tt468:
	++YYCURSOR;
#line 146 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("listappendend", T_TEMPLATELANG_KEY_LISTAPPENDEND); }
#line 2158 "./templatelang_lexer.cpp"
tt470:
	yych = *++YYCURSOR;
	if (yych == '}') goto tt480;
	goto tt33;
tt471:
	yych = *++YYCURSOR;
	if (yych == 'd') goto tt482;
	goto tt33;
tt472:
	++YYCURSOR;
#line 157 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("setnixing all", T_TEMPLATELANG_KEY_SETNIXING_ALL); }
#line 2171 "./templatelang_lexer.cpp"
tt474:
	++YYCURSOR;
#line 158 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("setnixing doc", T_TEMPLATELANG_KEY_SETNIXING_DOC); }
#line 2176 "./templatelang_lexer.cpp"
tt476:
	++YYCURSOR;
#line 159 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("setnixing off", T_TEMPLATELANG_KEY_SETNIXING_OFF); }
#line 2181 "./templatelang_lexer.cpp"
tt478:
	++YYCURSOR;
#line 176 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("featurejsonmangle", T_TEMPLATELANG_KEY_FEATUREJSONMANGLE); }
#line 2186 "./templatelang_lexer.cpp"
tt480:
	++YYCURSOR;
#line 150 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("namedsetaddend", T_TEMPLATELANG_KEY_NAMEDSETADDEND); }
#line 2191 "./templatelang_lexer.cpp"
tt482:
	yych = *++YYCURSOR;
	if (yych != ' ') goto tt33;
	yych = *++YYCURSOR;
	if (yych != '}') goto tt33;
	yych = *++YYCURSOR;
	if (yych != '}') goto tt33;
	++YYCURSOR;
#line 152 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN("namedsetremoveend", T_TEMPLATELANG_KEY_NAMEDSETREMOVEEND); }
#line 2202 "./templatelang_lexer.cpp"
}
#line 203 "./templatelang.re"



stringsq:
	tok = cur;

#line 2211 "./templatelang_lexer.cpp"
{
	YYCTYPE yych;
	yych = *YYCURSOR;
	if (yych <= '&') {
		if (yych <= 0x00) goto tt489;
		if (yych == '\n') goto tt493;
		goto tt491;
	} else {
		if (yych <= '\'') goto tt495;
		if (yych == '\\') goto tt497;
		goto tt491;
	}
tt489:
	++YYCURSOR;
#line 232 "./templatelang.re"
	{ if (cur >= lim) { goto end; } }
#line 2228 "./templatelang_lexer.cpp"
tt491:
	++YYCURSOR;
tt492:
#line 233 "./templatelang.re"
	{ yylval->pString->push_back(*tok);
			       goto stringsq; }
#line 2235 "./templatelang_lexer.cpp"
tt493:
	++YYCURSOR;
#line 235 "./templatelang.re"
	{ yylval->pString->push_back('\n');
			       goto stringsq; }
#line 2241 "./templatelang_lexer.cpp"
tt495:
	++YYCURSOR;
#line 209 "./templatelang.re"
	{ TEMPLATELANG_TOKEN_RETURN(STRING_MAGIC, T_TEMPLATELANG_STRING); }
#line 2246 "./templatelang_lexer.cpp"
tt497:
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'b') {
		if (yych <= '3') {
			if (yych <= '&') {
				if (yych != '"') goto tt492;
			} else {
				if (yych <= '\'') goto tt500;
				if (yych <= '/') goto tt492;
				goto tt502;
			}
		} else {
			if (yych <= '[') {
				if (yych == '?') goto tt504;
				goto tt492;
			} else {
				if (yych <= '\\') goto tt506;
				if (yych <= '`') goto tt492;
				if (yych <= 'a') goto tt508;
				goto tt510;
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'm') {
				if (yych == 'f') goto tt512;
				goto tt492;
			} else {
				if (yych <= 'n') goto tt514;
				if (yych <= 'q') goto tt492;
				goto tt516;
			}
		} else {
			if (yych <= 'u') {
				if (yych == 't') goto tt518;
				goto tt492;
			} else {
				if (yych <= 'v') goto tt520;
				if (yych == 'x') goto tt522;
				goto tt492;
			}
		}
	}
	++YYCURSOR;
#line 220 "./templatelang.re"
	{ yylval->pString->push_back('\"'); goto stringsq; }
#line 2293 "./templatelang_lexer.cpp"
tt500:
	++YYCURSOR;
#line 219 "./templatelang.re"
	{ yylval->pString->push_back('\''); goto stringsq; }
#line 2298 "./templatelang_lexer.cpp"
tt502:
	yych = *++YYCURSOR;
	if (yych <= '/') goto tt503;
	if (yych <= '7') goto tt523;
tt503:
	YYCURSOR = YYMARKER;
	goto tt492;
tt504:
	++YYCURSOR;
#line 218 "./templatelang.re"
	{ yylval->pString->push_back('\?'); goto stringsq; }
#line 2310 "./templatelang_lexer.cpp"
tt506:
	++YYCURSOR;
#line 217 "./templatelang.re"
	{ yylval->pString->push_back('\\'); goto stringsq; }
#line 2315 "./templatelang_lexer.cpp"
tt508:
	++YYCURSOR;
#line 214 "./templatelang.re"
	{ yylval->pString->push_back('\a'); goto stringsq; }
#line 2320 "./templatelang_lexer.cpp"
tt510:
	++YYCURSOR;
#line 213 "./templatelang.re"
	{ yylval->pString->push_back('\b'); goto stringsq; }
#line 2325 "./templatelang_lexer.cpp"
tt512:
	++YYCURSOR;
#line 216 "./templatelang.re"
	{ yylval->pString->push_back('\f'); goto stringsq; }
#line 2330 "./templatelang_lexer.cpp"
tt514:
	++YYCURSOR;
#line 210 "./templatelang.re"
	{ yylval->pString->push_back('\n'); goto stringsq; }
#line 2335 "./templatelang_lexer.cpp"
tt516:
	++YYCURSOR;
#line 215 "./templatelang.re"
	{ yylval->pString->push_back('\r'); goto stringsq; }
#line 2340 "./templatelang_lexer.cpp"
tt518:
	++YYCURSOR;
#line 211 "./templatelang.re"
	{ yylval->pString->push_back('\t'); goto stringsq; }
#line 2345 "./templatelang_lexer.cpp"
tt520:
	++YYCURSOR;
#line 212 "./templatelang.re"
	{ yylval->pString->push_back('\v'); goto stringsq; }
#line 2350 "./templatelang_lexer.cpp"
tt522:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt503;
		if (yych <= '9') goto tt524;
		goto tt503;
	} else {
		if (yych <= 'F') goto tt524;
		if (yych <= '`') goto tt503;
		if (yych <= 'f') goto tt524;
		goto tt503;
	}
tt523:
	yych = *++YYCURSOR;
	if (yych <= '/') goto tt503;
	if (yych <= '7') goto tt525;
	goto tt503;
tt524:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt503;
		if (yych <= '9') goto tt527;
		goto tt503;
	} else {
		if (yych <= 'F') goto tt527;
		if (yych <= '`') goto tt503;
		if (yych <= 'f') goto tt527;
		goto tt503;
	}
tt525:
	++YYCURSOR;
#line 221 "./templatelang.re"
	{ tok += 1; // Go past SLASH 
		    std::string mystr;
		    getString(mystr);
		    yylval->pString->push_back(octal2char(mystr.c_str())); 
		    goto stringsq; }
#line 2388 "./templatelang_lexer.cpp"
tt527:
	++YYCURSOR;
#line 226 "./templatelang.re"
	{ tok += 2; // Go past SLASH x
			       std::string mystr;
			       getString(mystr);
			       yylval->pString->push_back(hex2char(mystr.c_str()));
			       goto stringsq; 			     
                             }
#line 2398 "./templatelang_lexer.cpp"
}
#line 237 "./templatelang.re"



 end:
	return 0;
}


void TemplateLanguageScanner::addToken(void)
{
	yylval->setString(new std::string);
	const char *p;
	for (p = tok;
	     p != cur;
	     ++p) {
	     yylval->pString->push_back(*p);
	}
}

void TemplateLanguageScanner::addInteger(void)
{
	const size_t MAX_INTEGER_CHARS = 12;
	size_t cnt = cur - tok;
	if (cnt > MAX_INTEGER_CHARS) {
	   	std::string mystring;
		const char *p;
		for (p = tok;
		     p != cur;
	     	     ++p) {
		     mystring.push_back(*p);
		}
		yylval->setInteger(sz2longlong(mystring.c_str()));
		yylval->setString(new std::string(mystring));
        } else {
		char szInt[MAX_INTEGER_CHARS+1];

		const char *p;
		char *q = szInt;
		for (p = tok;
		     p != cur;
	     	     ++p) {
		     *q++ = *p;
		}
		*q = '\0';
		yylval->setInteger(sz2longlong(szInt));
		yylval->setString(new std::string(szInt));
	}
}

void TemplateLanguageScanner::getString(std::string& str)
{
	const char *p;
	for (p = tok;
	     p != cur;
	     ++p) {
	     str.push_back(*p);
	}
}

