/* Generated by re2c 2.0.3 on Tue Dec  8 12:13:26 2020 */
#line 1 "./emdroslang.re"
/*
 * emdroslang.re
 *
 * Emdros language lexer based on re2c
 *
 * Ulrik Sandborg-Petersen
 * Created: 11/11-2016
 * Last update: 5/22-2017
 *
 */

/*
 * Copyright (C) 2001-2018     Ulrik Sandborg-Petersen
 * Copyright (C) 2018-present  Sandborg-Petersen Holding ApS, Denmark
 *
 * Licensed under the MIT License.
 *
 * Please see the file COPYING in the root of the sources for more details.
 *
 */

#include <emdroslang_lexer.h>
#include "emdroslangpars.h"
#include <iostream>
#include <string_func.h>

#define YYCTYPE         unsigned char
#define YYCURSOR        cur
#define YYLIMIT         lim
#define YYMARKER        ptr
#line 34 "./emdroslang.re"



#line 69 "./emdroslang.re"



EmdroslangScanner::EmdroslangScanner(const std::string& strIn)
{
	sz = strIn.c_str();
	lim = sz + strIn.length();
	bot = tok = ptr = pos = top = eof = 0;
	cur = sz;
}

EmdroslangScanner::~EmdroslangScanner()
{
	if (bot) {
		delete[] bot;
	}
}

/*
char *EmdroslangScanner::fill(char *cursor)
{
        if(!eof)
        {
                unsigned int cnt = tok - bot;
                if(cnt)
                {
                        memcpy(bot, tok, lim - tok);
                        tok = bot;
                        ptr -= cnt;
                        cursor -= cnt;
                        pos -= cnt;
                        lim -= cnt;
                }
                if((top - lim) < BSIZE)
                {
                        char *buf = new char[(lim - bot) + BSIZE];
                        memcpy(buf, tok, lim - tok);
                        tok = buf;
                        ptr = &buf[ptr - bot];
                        cursor = &buf[cursor - bot];
                        pos = &buf[pos - bot];
                        lim = &buf[lim - bot];
                        top = &lim[BSIZE];
                        delete [] bot;
                        bot = buf;
                }
                pIn->read(lim, BSIZE);
                if ((cnt = pIn->gcount()) != BSIZE )
                {
                        eof = &lim[cnt]; *eof++ = '\0';
                }
                lim += cnt;
        }
        return cursor;
}
*/

#define EMDROSLANG_TOKEN_RETURN(X,Y) { yylval->setName(X); return Y; }

int EmdroslangScanner::scan(Token *pYYLVAL)
{
	yylval = pYYLVAL;

scan:
	tok = cur;


#line 106 "./emdroslang_lexer.cpp"
{
	YYCTYPE yych;
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:	goto tt3;
	case '!':	goto tt5;
	case '"':	goto tt7;
	case '%':	goto tt9;
	case '&':	goto tt11;
	case '\'':	goto tt12;
	case '(':	goto tt14;
	case ')':	goto tt16;
	case '*':	goto tt18;
	case '+':	goto tt20;
	case ',':	goto tt22;
	case '-':	goto tt24;
	case '/':	goto tt26;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto tt28;
	case ':':	goto tt31;
	case ';':	goto tt33;
	case '<':	goto tt35;
	case '=':	goto tt37;
	case '>':	goto tt39;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'y':
	case 'z':	goto tt41;
	case '[':	goto tt44;
	case ']':	goto tt46;
	case 'd':	goto tt48;
	case 'e':	goto tt49;
	case 'f':	goto tt50;
	case 'i':	goto tt51;
	case 'n':	goto tt52;
	case 's':	goto tt53;
	case 't':	goto tt54;
	case 'v':	goto tt55;
	case 'w':	goto tt56;
	case 'x':	goto tt57;
	case '{':	goto tt58;
	case '|':	goto tt60;
	case '}':	goto tt61;
	default:	goto tt2;
	}
tt2:
tt3:
	++YYCURSOR;
#line 202 "./emdroslang.re"
	{ if (cur >= lim) { goto end; } }
#line 204 "./emdroslang_lexer.cpp"
tt5:
	yych = *++YYCURSOR;
	if (yych == '=') goto tt63;
#line 164 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("!", T_EMDROSLANG_KEY_NOT); }
#line 210 "./emdroslang_lexer.cpp"
tt7:
	++YYCURSOR;
#line 199 "./emdroslang.re"
	{ yylval->setString(new std::string);
		         goto stringdq; 
                       }
#line 217 "./emdroslang_lexer.cpp"
tt9:
	++YYCURSOR;
#line 163 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("%", T_EMDROSLANG_KEY_PERCENT); }
#line 222 "./emdroslang_lexer.cpp"
tt11:
	yych = *++YYCURSOR;
	if (yych == '&') goto tt65;
	goto tt2;
tt12:
	++YYCURSOR;
#line 194 "./emdroslang.re"
	{ yylval->setString(new std::string);
		         goto stringsq; 
                       }
#line 233 "./emdroslang_lexer.cpp"
tt14:
	++YYCURSOR;
#line 139 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("(", T_EMDROSLANG_KEY_LPAREN); }
#line 238 "./emdroslang_lexer.cpp"
tt16:
	++YYCURSOR;
#line 140 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN(")", T_EMDROSLANG_KEY_RPAREN); }
#line 243 "./emdroslang_lexer.cpp"
tt18:
	++YYCURSOR;
#line 161 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("*", T_EMDROSLANG_KEY_STAR); }
#line 248 "./emdroslang_lexer.cpp"
tt20:
	++YYCURSOR;
#line 159 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("+", T_EMDROSLANG_KEY_PLUS); }
#line 253 "./emdroslang_lexer.cpp"
tt22:
	++YYCURSOR;
#line 145 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN(",", T_EMDROSLANG_KEY_COMMA); }
#line 258 "./emdroslang_lexer.cpp"
tt24:
	++YYCURSOR;
#line 160 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("-", T_EMDROSLANG_KEY_MINUS); }
#line 263 "./emdroslang_lexer.cpp"
tt26:
	yych = *++YYCURSOR;
	if (yych == '*') goto tt67;
	if (yych == '/') goto tt69;
#line 162 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("/", T_EMDROSLANG_KEY_SLASH); }
#line 270 "./emdroslang_lexer.cpp"
tt28:
	yych = *++YYCURSOR;
	if (yych <= '/') goto tt30;
	if (yych <= '9') goto tt28;
tt30:
#line 192 "./emdroslang.re"
	{ addInteger();
                         EMDROSLANG_TOKEN_RETURN(INTEGER_MAGIC, T_EMDROSLANG_INTEGER); }
#line 279 "./emdroslang_lexer.cpp"
tt31:
	yych = *++YYCURSOR;
	if (yych == ':') goto tt71;
#line 157 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN(":", T_EMDROSLANG_KEY_COLON); }
#line 285 "./emdroslang_lexer.cpp"
tt33:
	++YYCURSOR;
#line 146 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN(",", T_EMDROSLANG_KEY_SEMICOLON); }
#line 290 "./emdroslang_lexer.cpp"
tt35:
	yych = *++YYCURSOR;
	if (yych == '=') goto tt73;
#line 151 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("<", T_EMDROSLANG_KEY_LT); }
#line 296 "./emdroslang_lexer.cpp"
tt37:
	yych = *++YYCURSOR;
	if (yych == '=') goto tt75;
#line 147 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("=", T_EMDROSLANG_KEY_ASSIGN); }
#line 302 "./emdroslang_lexer.cpp"
tt39:
	yych = *++YYCURSOR;
	if (yych == '=') goto tt77;
#line 153 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN(">", T_EMDROSLANG_KEY_GT); }
#line 308 "./emdroslang_lexer.cpp"
tt41:
	yych = *++YYCURSOR;
tt42:
	if (yych <= 'Z') {
		if (yych <= '/') goto tt43;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt43;
			if (yych <= 'z') goto tt41;
		}
	}
tt43:
#line 191 "./emdroslang.re"
	{ addToken(); EMDROSLANG_TOKEN_RETURN("identifier", T_EMDROSLANG_IDENTIFIER);}
#line 327 "./emdroslang_lexer.cpp"
tt44:
	++YYCURSOR;
#line 142 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("[", T_EMDROSLANG_KEY_LSQUARE_BRACKET); }
#line 332 "./emdroslang_lexer.cpp"
tt46:
	++YYCURSOR;
#line 143 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("]", T_EMDROSLANG_KEY_RSQUARE_BRACKET); }
#line 337 "./emdroslang_lexer.cpp"
tt48:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt79;
	goto tt42;
tt49:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt81;
	goto tt42;
tt50:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'a':	goto tt82;
	case 'e':	goto tt83;
	case 'o':	goto tt84;
	case 'u':	goto tt85;
	default:	goto tt42;
	}
tt51:
	yych = *++YYCURSOR;
	if (yych == 'f') goto tt86;
	if (yych == 'n') goto tt88;
	goto tt42;
tt52:
	yych = *++YYCURSOR;
	if (yych == 'u') goto tt90;
	goto tt42;
tt53:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt91;
	goto tt42;
tt54:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt92;
	goto tt42;
tt55:
	yych = *++YYCURSOR;
	if (yych == 'a') goto tt93;
	goto tt42;
tt56:
	yych = *++YYCURSOR;
	if (yych == 'h') goto tt94;
	goto tt42;
tt57:
	yych = *++YYCURSOR;
	if (yych == 'm') goto tt95;
	goto tt42;
tt58:
	++YYCURSOR;
#line 136 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("{", T_EMDROSLANG_KEY_LBRACE); }
#line 388 "./emdroslang_lexer.cpp"
tt60:
	yych = *++YYCURSOR;
	if (yych == '|') goto tt96;
	goto tt2;
tt61:
	++YYCURSOR;
#line 137 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("}", T_EMDROSLANG_KEY_RBRACE); }
#line 397 "./emdroslang_lexer.cpp"
tt63:
	++YYCURSOR;
#line 150 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("!=", T_EMDROSLANG_KEY_NEQ); }
#line 402 "./emdroslang_lexer.cpp"
tt65:
	++YYCURSOR;
#line 166 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("&&", T_EMDROSLANG_KEY_AND_AND); }
#line 407 "./emdroslang_lexer.cpp"
tt67:
	++YYCURSOR;
#line 197 "./emdroslang.re"
	{ goto comment_slash_star; }
#line 412 "./emdroslang_lexer.cpp"
tt69:
	++YYCURSOR;
#line 198 "./emdroslang.re"
	{ goto comment_slash_slash; }
#line 417 "./emdroslang_lexer.cpp"
tt71:
	++YYCURSOR;
#line 156 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("::", T_EMDROSLANG_KEY_COLON_COLON); }
#line 422 "./emdroslang_lexer.cpp"
tt73:
	++YYCURSOR;
#line 152 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("<=", T_EMDROSLANG_KEY_LEQ); }
#line 427 "./emdroslang_lexer.cpp"
tt75:
	++YYCURSOR;
#line 149 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("==", T_EMDROSLANG_KEY_EQEQ); }
#line 432 "./emdroslang_lexer.cpp"
tt77:
	++YYCURSOR;
#line 154 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN(">=", T_EMDROSLANG_KEY_GEQ); }
#line 437 "./emdroslang_lexer.cpp"
tt79:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt80;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt80;
			if (yych <= 'z') goto tt41;
		}
	}
tt80:
#line 179 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("do", T_EMDROSLANG_KEY_DO); }
#line 455 "./emdroslang_lexer.cpp"
tt81:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt98;
	if (yych == 's') goto tt99;
	goto tt42;
tt82:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt100;
	goto tt42;
tt83:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt101;
	goto tt42;
tt84:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt102;
	goto tt42;
tt85:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt104;
	goto tt42;
tt86:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt87;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt87;
			if (yych <= 'z') goto tt41;
		}
	}
tt87:
#line 182 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("if", T_EMDROSLANG_KEY_IF); }
#line 494 "./emdroslang_lexer.cpp"
tt88:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt89;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt89;
			if (yych <= 'z') goto tt41;
		}
	}
tt89:
#line 181 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("in", T_EMDROSLANG_KEY_IN); }
#line 512 "./emdroslang_lexer.cpp"
tt90:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt105;
	goto tt42;
tt91:
	yych = *++YYCURSOR;
	if (yych == 'y') goto tt106;
	goto tt42;
tt92:
	yych = *++YYCURSOR;
	if (yych == 'u') goto tt107;
	goto tt42;
tt93:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt108;
	goto tt42;
tt94:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt110;
	goto tt42;
tt95:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt111;
	goto tt42;
tt96:
	++YYCURSOR;
#line 167 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("&&", T_EMDROSLANG_KEY_PIPE_PIPE); }
#line 541 "./emdroslang_lexer.cpp"
tt98:
	yych = *++YYCURSOR;
	if (yych == 'f') goto tt112;
	goto tt42;
tt99:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt114;
	goto tt42;
tt100:
	yych = *++YYCURSOR;
	if (yych == 's') goto tt116;
	goto tt42;
tt101:
	yych = *++YYCURSOR;
	if (yych == 'c') goto tt117;
	goto tt42;
tt102:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt103;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt103;
			if (yych <= 'z') goto tt41;
		}
	}
tt103:
#line 180 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("for", T_EMDROSLANG_KEY_FOR); }
#line 575 "./emdroslang_lexer.cpp"
tt104:
	yych = *++YYCURSOR;
	if (yych == 'c') goto tt118;
	goto tt42;
tt105:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt119;
	goto tt42;
tt106:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt121;
	goto tt42;
tt107:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt122;
	goto tt42;
tt108:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt109;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt109;
			if (yych <= 'z') goto tt41;
		}
	}
tt109:
#line 173 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("var", T_EMDROSLANG_KEY_VAR); }
#line 609 "./emdroslang_lexer.cpp"
tt110:
	yych = *++YYCURSOR;
	if (yych == 'l') goto tt124;
	goto tt42;
tt111:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt125;
	goto tt42;
tt112:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt113;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt113;
			if (yych <= 'z') goto tt41;
		}
	}
tt113:
#line 183 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("elif", T_EMDROSLANG_KEY_ELIF); }
#line 635 "./emdroslang_lexer.cpp"
tt114:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt115;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt115;
			if (yych <= 'z') goto tt41;
		}
	}
tt115:
#line 184 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("else", T_EMDROSLANG_KEY_ELSE); }
#line 653 "./emdroslang_lexer.cpp"
tt116:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt126;
	goto tt42;
tt117:
	yych = *++YYCURSOR;
	if (yych == 'h') goto tt128;
	goto tt42;
tt118:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt129;
	goto tt42;
tt119:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt120;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt120;
			if (yych <= 'z') goto tt41;
		}
	}
tt120:
#line 176 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("null", T_EMDROSLANG_KEY_NULL); }
#line 683 "./emdroslang_lexer.cpp"
tt121:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt130;
	goto tt42;
tt122:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt123;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt123;
			if (yych <= 'z') goto tt41;
		}
	}
tt123:
#line 175 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("true", T_EMDROSLANG_KEY_TRUE); }
#line 705 "./emdroslang_lexer.cpp"
tt124:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt131;
	goto tt42;
tt125:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt133;
	goto tt42;
tt126:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt127;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt127;
			if (yych <= 'z') goto tt41;
		}
	}
tt127:
#line 174 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("false", T_EMDROSLANG_KEY_FALSE); }
#line 731 "./emdroslang_lexer.cpp"
tt128:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt134;
	goto tt42;
tt129:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt135;
	goto tt42;
tt130:
	yych = *++YYCURSOR;
	if (yych == 's') goto tt136;
	goto tt42;
tt131:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt132;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt132;
			if (yych <= 'z') goto tt41;
		}
	}
tt132:
#line 178 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("while", T_EMDROSLANG_KEY_WHILE); }
#line 761 "./emdroslang_lexer.cpp"
tt133:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt137;
	goto tt42;
tt134:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt138;
	goto tt42;
tt135:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt139;
	goto tt42;
tt136:
	yych = *++YYCURSOR;
	if (yych == 'h') goto tt140;
	goto tt42;
tt137:
	yych = *++YYCURSOR;
	if (yych == 'd') goto tt141;
	goto tt42;
tt138:
	yych = *++YYCURSOR;
	if (yych == 'f') goto tt142;
	goto tt42;
tt139:
	yych = *++YYCURSOR;
	if (yych == 'n') goto tt143;
	goto tt42;
tt140:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt145;
	goto tt42;
tt141:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt146;
	goto tt42;
tt142:
	yych = *++YYCURSOR;
	if (yych == 'o') goto tt147;
	goto tt42;
tt143:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt144;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt144;
			if (yych <= 'z') goto tt41;
		}
	}
tt144:
#line 186 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("function", T_EMDROSLANG_KEY_FUNCTION); }
#line 819 "./emdroslang_lexer.cpp"
tt145:
	yych = *++YYCURSOR;
	if (yych == 'e') goto tt149;
	goto tt42;
tt146:
	yych = *++YYCURSOR;
	if (yych == 'r') goto tt150;
	goto tt42;
tt147:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt148;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt148;
			if (yych <= 'z') goto tt41;
		}
	}
tt148:
#line 169 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("fetchinfo", T_EMDROSLANG_KEY_FETCHINFO); }
#line 845 "./emdroslang_lexer.cpp"
tt149:
	yych = *++YYCURSOR;
	if (yych == 't') goto tt151;
	goto tt42;
tt150:
	yych = *++YYCURSOR;
	if (yych == 'i') goto tt153;
	goto tt42;
tt151:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt152;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt152;
			if (yych <= 'z') goto tt41;
		}
	}
tt152:
#line 171 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("stylesheet", T_EMDROSLANG_KEY_STYLESHEET); }
#line 871 "./emdroslang_lexer.cpp"
tt153:
	yych = *++YYCURSOR;
	if (yych != 'n') goto tt42;
	yych = *++YYCURSOR;
	if (yych != 'f') goto tt42;
	yych = *++YYCURSOR;
	if (yych != 'o') goto tt42;
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto tt157;
		if (yych <= '9') goto tt41;
		if (yych >= 'A') goto tt41;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto tt41;
		} else {
			if (yych <= '`') goto tt157;
			if (yych <= 'z') goto tt41;
		}
	}
tt157:
#line 188 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN("xmlrenderinfo", T_EMDROSLANG_KEY_XMLRENDERINFO); }
#line 895 "./emdroslang_lexer.cpp"
}
#line 203 "./emdroslang.re"



stringsq:
	tok = cur;

#line 904 "./emdroslang_lexer.cpp"
{
	YYCTYPE yych;
	yych = *YYCURSOR;
	if (yych <= '&') {
		if (yych <= 0x00) goto tt160;
		if (yych == '\n') goto tt164;
		goto tt162;
	} else {
		if (yych <= '\'') goto tt166;
		if (yych == '\\') goto tt168;
		goto tt162;
	}
tt160:
	++YYCURSOR;
#line 234 "./emdroslang.re"
	{ if (cur >= lim) { goto end; } }
#line 921 "./emdroslang_lexer.cpp"
tt162:
	++YYCURSOR;
tt163:
#line 235 "./emdroslang.re"
	{ yylval->pString->push_back(*tok);
			       goto stringsq; }
#line 928 "./emdroslang_lexer.cpp"
tt164:
	++YYCURSOR;
#line 237 "./emdroslang.re"
	{ yylval->pString->push_back('\n');
			       goto stringsq; }
#line 934 "./emdroslang_lexer.cpp"
tt166:
	++YYCURSOR;
#line 209 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN(STRING_MAGIC, T_EMDROSLANG_STRING); }
#line 939 "./emdroslang_lexer.cpp"
tt168:
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= '9') {
			if (yych <= '&') {
				if (yych != '"') goto tt163;
			} else {
				if (yych <= '\'') goto tt171;
				if (yych <= '/') goto tt163;
				goto tt173;
			}
		} else {
			if (yych <= '[') {
				if (yych == '?') goto tt175;
				goto tt163;
			} else {
				if (yych <= '\\') goto tt177;
				if (yych <= '`') goto tt163;
				goto tt179;
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'f') {
				if (yych <= 'b') goto tt181;
				if (yych <= 'e') goto tt163;
				goto tt183;
			} else {
				if (yych == 'n') goto tt185;
				goto tt163;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'r') goto tt187;
				if (yych <= 's') goto tt163;
				goto tt189;
			} else {
				if (yych <= 'u') goto tt191;
				if (yych <= 'v') goto tt193;
				goto tt163;
			}
		}
	}
	++YYCURSOR;
#line 220 "./emdroslang.re"
	{ yylval->pString->push_back('"'); goto stringsq; }
#line 986 "./emdroslang_lexer.cpp"
tt171:
	++YYCURSOR;
#line 219 "./emdroslang.re"
	{ yylval->pString->push_back('\''); goto stringsq; }
#line 991 "./emdroslang_lexer.cpp"
tt173:
	yych = *++YYCURSOR;
	if (yych <= '/') goto tt174;
	if (yych <= '9') goto tt195;
tt174:
#line 221 "./emdroslang.re"
	{ std::string mystr;
			getString(mystr);
			yylval->pString->append(mystr);
		      }
#line 1002 "./emdroslang_lexer.cpp"
tt175:
	++YYCURSOR;
#line 218 "./emdroslang.re"
	{ yylval->pString->push_back('?'); goto stringsq; }
#line 1007 "./emdroslang_lexer.cpp"
tt177:
	++YYCURSOR;
#line 217 "./emdroslang.re"
	{ yylval->pString->push_back('\\'); goto stringsq; }
#line 1012 "./emdroslang_lexer.cpp"
tt179:
	++YYCURSOR;
#line 214 "./emdroslang.re"
	{ yylval->pString->push_back('\a'); goto stringsq; }
#line 1017 "./emdroslang_lexer.cpp"
tt181:
	++YYCURSOR;
#line 213 "./emdroslang.re"
	{ yylval->pString->push_back('\b'); goto stringsq; }
#line 1022 "./emdroslang_lexer.cpp"
tt183:
	++YYCURSOR;
#line 216 "./emdroslang.re"
	{ yylval->pString->push_back('\f'); goto stringsq; }
#line 1027 "./emdroslang_lexer.cpp"
tt185:
	++YYCURSOR;
#line 210 "./emdroslang.re"
	{ yylval->pString->push_back('\n'); goto stringsq; }
#line 1032 "./emdroslang_lexer.cpp"
tt187:
	++YYCURSOR;
#line 215 "./emdroslang.re"
	{ yylval->pString->push_back('\r'); goto stringsq; }
#line 1037 "./emdroslang_lexer.cpp"
tt189:
	++YYCURSOR;
#line 211 "./emdroslang.re"
	{ yylval->pString->push_back('\t'); goto stringsq; }
#line 1042 "./emdroslang_lexer.cpp"
tt191:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '/') goto tt192;
		if (yych == '1') goto tt197;
		goto tt196;
	} else {
		if (yych <= 'F') {
			if (yych >= 'A') goto tt196;
		} else {
			if (yych <= '`') goto tt192;
			if (yych <= 'f') goto tt196;
		}
	}
tt192:
	YYCURSOR = YYMARKER;
	goto tt163;
tt193:
	++YYCURSOR;
#line 212 "./emdroslang.re"
	{ yylval->pString->push_back('\v'); goto stringsq; }
#line 1064 "./emdroslang_lexer.cpp"
tt195:
	++YYCURSOR;
	goto tt174;
tt196:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt192;
		if (yych <= '9') goto tt198;
		goto tt192;
	} else {
		if (yych <= 'F') goto tt198;
		if (yych <= '`') goto tt192;
		if (yych <= 'f') goto tt198;
		goto tt192;
	}
tt197:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt192;
		if (yych <= '9') goto tt199;
		goto tt192;
	} else {
		if (yych <= 'F') goto tt199;
		if (yych <= '`') goto tt192;
		if (yych <= 'f') goto tt199;
		goto tt192;
	}
tt198:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt192;
		if (yych <= '9') goto tt200;
		goto tt192;
	} else {
		if (yych <= 'F') goto tt200;
		if (yych <= '`') goto tt192;
		if (yych <= 'f') goto tt200;
		goto tt192;
	}
tt199:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt192;
		if (yych <= '9') goto tt201;
		goto tt192;
	} else {
		if (yych <= 'F') goto tt201;
		if (yych <= '`') goto tt192;
		if (yych <= 'f') goto tt201;
		goto tt192;
	}
tt200:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt192;
		if (yych <= '9') goto tt202;
		goto tt192;
	} else {
		if (yych <= 'F') goto tt202;
		if (yych <= '`') goto tt192;
		if (yych <= 'f') goto tt202;
		goto tt192;
	}
tt201:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt192;
		if (yych <= '9') goto tt204;
		goto tt192;
	} else {
		if (yych <= 'F') goto tt204;
		if (yych <= '`') goto tt192;
		if (yych <= 'f') goto tt204;
		goto tt192;
	}
tt202:
	++YYCURSOR;
tt203:
#line 225 "./emdroslang.re"
	{ tok += 2; // Go past SLASH u
			       std::string mystr;
			       getString(mystr);
			       long utf8 = hex2long(mystr);
			       std::string mystr2;
			       long2utf8(utf8, mystr2);
			       yylval->pString->append(mystr2);
			       goto stringsq; 			     
                             }
#line 1153 "./emdroslang_lexer.cpp"
tt204:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt203;
		if (yych <= '9') goto tt202;
		goto tt203;
	} else {
		if (yych <= 'F') goto tt202;
		if (yych <= '`') goto tt203;
		if (yych <= 'f') goto tt202;
		goto tt203;
	}
}
#line 239 "./emdroslang.re"


comment_slash_star:
	tok = cur;

#line 1173 "./emdroslang_lexer.cpp"
{
	YYCTYPE yych;
	yych = *YYCURSOR;
	if (yych <= '\n') {
		if (yych <= 0x00) goto tt207;
		if (yych <= '\t') goto tt209;
		goto tt211;
	} else {
		if (yych == '*') goto tt213;
		goto tt209;
	}
tt207:
	++YYCURSOR;
#line 245 "./emdroslang.re"
	{ if (cur >= lim) { goto end; } }
#line 1189 "./emdroslang_lexer.cpp"
tt209:
	++YYCURSOR;
tt210:
#line 246 "./emdroslang.re"
	{ goto comment_slash_star; }
#line 1195 "./emdroslang_lexer.cpp"
tt211:
	++YYCURSOR;
#line 247 "./emdroslang.re"
	{ goto comment_slash_star; }
#line 1200 "./emdroslang_lexer.cpp"
tt213:
	yych = *++YYCURSOR;
	if (yych != '/') goto tt210;
	++YYCURSOR;
#line 244 "./emdroslang.re"
	{ goto scan; }
#line 1207 "./emdroslang_lexer.cpp"
}
#line 248 "./emdroslang.re"


comment_slash_slash:
	tok = cur;

#line 1215 "./emdroslang_lexer.cpp"
{
	YYCTYPE yych;
	yych = *YYCURSOR;
	if (yych <= 0x00) goto tt218;
	if (yych == '\n') goto tt222;
	goto tt220;
tt218:
	++YYCURSOR;
#line 253 "./emdroslang.re"
	{ if (cur >= lim) { goto end; } }
#line 1226 "./emdroslang_lexer.cpp"
tt220:
	++YYCURSOR;
#line 254 "./emdroslang.re"
	{ goto comment_slash_slash; }
#line 1231 "./emdroslang_lexer.cpp"
tt222:
	++YYCURSOR;
#line 255 "./emdroslang.re"
	{ goto scan; }
#line 1236 "./emdroslang_lexer.cpp"
}
#line 256 "./emdroslang.re"


stringdq:
	tok = cur;

#line 1244 "./emdroslang_lexer.cpp"
{
	YYCTYPE yych;
	yych = *YYCURSOR;
	if (yych <= '!') {
		if (yych <= 0x00) goto tt226;
		if (yych == '\n') goto tt230;
		goto tt228;
	} else {
		if (yych <= '"') goto tt232;
		if (yych == '\\') goto tt234;
		goto tt228;
	}
tt226:
	++YYCURSOR;
#line 284 "./emdroslang.re"
	{ if (cur >= lim) { goto end; } }
#line 1261 "./emdroslang_lexer.cpp"
tt228:
	++YYCURSOR;
tt229:
#line 285 "./emdroslang.re"
	{ yylval->pString->append(*tok, 1);
			       goto stringsq; }
#line 1268 "./emdroslang_lexer.cpp"
tt230:
	++YYCURSOR;
#line 287 "./emdroslang.re"
	{ yylval->pString->append('\n', 1);
			       goto stringsq; }
#line 1274 "./emdroslang_lexer.cpp"
tt232:
	++YYCURSOR;
#line 261 "./emdroslang.re"
	{ EMDROSLANG_TOKEN_RETURN(STRING_MAGIC, T_EMDROSLANG_STRING); }
#line 1279 "./emdroslang_lexer.cpp"
tt234:
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= '9') {
			if (yych <= '&') {
				if (yych != '"') goto tt229;
			} else {
				if (yych <= '\'') goto tt237;
				if (yych <= '/') goto tt229;
				goto tt239;
			}
		} else {
			if (yych <= '[') {
				if (yych == '?') goto tt241;
				goto tt229;
			} else {
				if (yych <= '\\') goto tt243;
				if (yych <= '`') goto tt229;
				goto tt245;
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'f') {
				if (yych <= 'b') goto tt247;
				if (yych <= 'e') goto tt229;
				goto tt249;
			} else {
				if (yych == 'n') goto tt251;
				goto tt229;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'r') goto tt253;
				if (yych <= 's') goto tt229;
				goto tt255;
			} else {
				if (yych <= 'u') goto tt257;
				if (yych <= 'v') goto tt259;
				goto tt229;
			}
		}
	}
	++YYCURSOR;
#line 272 "./emdroslang.re"
	{ yylval->pString->push_back('\"'); goto stringsq; }
#line 1326 "./emdroslang_lexer.cpp"
tt237:
	++YYCURSOR;
#line 271 "./emdroslang.re"
	{ yylval->pString->push_back('\''); goto stringsq; }
#line 1331 "./emdroslang_lexer.cpp"
tt239:
	yych = *++YYCURSOR;
	if (yych <= '/') goto tt240;
	if (yych <= '9') goto tt261;
tt240:
#line 274 "./emdroslang.re"
	{ yylval->pString->push_back(*tok); goto stringsq; }
#line 1339 "./emdroslang_lexer.cpp"
tt241:
	++YYCURSOR;
#line 270 "./emdroslang.re"
	{ yylval->pString->push_back('\?'); goto stringsq; }
#line 1344 "./emdroslang_lexer.cpp"
tt243:
	++YYCURSOR;
#line 269 "./emdroslang.re"
	{ yylval->pString->push_back('\\'); goto stringsq; }
#line 1349 "./emdroslang_lexer.cpp"
tt245:
	++YYCURSOR;
#line 266 "./emdroslang.re"
	{ yylval->pString->push_back('\a'); goto stringsq; }
#line 1354 "./emdroslang_lexer.cpp"
tt247:
	++YYCURSOR;
#line 265 "./emdroslang.re"
	{ yylval->pString->push_back('\b'); goto stringsq; }
#line 1359 "./emdroslang_lexer.cpp"
tt249:
	++YYCURSOR;
#line 268 "./emdroslang.re"
	{ yylval->pString->push_back('\f'); goto stringsq; }
#line 1364 "./emdroslang_lexer.cpp"
tt251:
	++YYCURSOR;
#line 262 "./emdroslang.re"
	{ yylval->pString->push_back('\n'); goto stringsq; }
#line 1369 "./emdroslang_lexer.cpp"
tt253:
	++YYCURSOR;
#line 267 "./emdroslang.re"
	{ yylval->pString->push_back('\r'); goto stringsq; }
#line 1374 "./emdroslang_lexer.cpp"
tt255:
	++YYCURSOR;
#line 263 "./emdroslang.re"
	{ yylval->pString->push_back('\t'); goto stringsq; }
#line 1379 "./emdroslang_lexer.cpp"
tt257:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '/') goto tt258;
		if (yych == '1') goto tt264;
		goto tt263;
	} else {
		if (yych <= 'F') {
			if (yych >= 'A') goto tt263;
		} else {
			if (yych <= '`') goto tt258;
			if (yych <= 'f') goto tt263;
		}
	}
tt258:
	YYCURSOR = YYMARKER;
	goto tt229;
tt259:
	++YYCURSOR;
#line 264 "./emdroslang.re"
	{ yylval->pString->push_back('\v'); goto stringsq; }
#line 1401 "./emdroslang_lexer.cpp"
tt261:
	++YYCURSOR;
#line 273 "./emdroslang.re"
	{ yylval->pString->push_back(*tok); goto stringsq; }
#line 1406 "./emdroslang_lexer.cpp"
tt263:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt258;
		if (yych <= '9') goto tt265;
		goto tt258;
	} else {
		if (yych <= 'F') goto tt265;
		if (yych <= '`') goto tt258;
		if (yych <= 'f') goto tt265;
		goto tt258;
	}
tt264:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt258;
		if (yych <= '9') goto tt266;
		goto tt258;
	} else {
		if (yych <= 'F') goto tt266;
		if (yych <= '`') goto tt258;
		if (yych <= 'f') goto tt266;
		goto tt258;
	}
tt265:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt258;
		if (yych <= '9') goto tt267;
		goto tt258;
	} else {
		if (yych <= 'F') goto tt267;
		if (yych <= '`') goto tt258;
		if (yych <= 'f') goto tt267;
		goto tt258;
	}
tt266:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt258;
		if (yych <= '9') goto tt268;
		goto tt258;
	} else {
		if (yych <= 'F') goto tt268;
		if (yych <= '`') goto tt258;
		if (yych <= 'f') goto tt268;
		goto tt258;
	}
tt267:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt258;
		if (yych <= '9') goto tt269;
		goto tt258;
	} else {
		if (yych <= 'F') goto tt269;
		if (yych <= '`') goto tt258;
		if (yych <= 'f') goto tt269;
		goto tt258;
	}
tt268:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt258;
		if (yych <= '9') goto tt271;
		goto tt258;
	} else {
		if (yych <= 'F') goto tt271;
		if (yych <= '`') goto tt258;
		if (yych <= 'f') goto tt271;
		goto tt258;
	}
tt269:
	++YYCURSOR;
tt270:
#line 275 "./emdroslang.re"
	{ tok += 2; // Go past SLASH u
			       std::string mystr;
			       getString(mystr);
			       long utf8 = hex2long(mystr);
			       std::string mystr2;
			       long2utf8(utf8, mystr2);
			       yylval->pString->append(mystr2);
			       goto stringsq; 			     
                             }
#line 1492 "./emdroslang_lexer.cpp"
tt271:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto tt270;
		if (yych <= '9') goto tt269;
		goto tt270;
	} else {
		if (yych <= 'F') goto tt269;
		if (yych <= '`') goto tt270;
		if (yych <= 'f') goto tt269;
		goto tt270;
	}
}
#line 289 "./emdroslang.re"



 end:
	return 0;
}


void EmdroslangScanner::addToken(void)
{
	yylval->setString(new std::string);
	const char *p;
	for (p = tok;
	     p != cur;
	     ++p) {
	     yylval->pString->push_back(*p);
	}
}

void EmdroslangScanner::addInteger(void)
{
	const unsigned int MAX_INTEGER_CHARS = 12;
	unsigned int cnt = cur - tok;
	if (cnt > MAX_INTEGER_CHARS) {
	   	std::string mystring;
		const char *p;
		for (p = tok;
		     p != cur;
	     	     ++p) {
		     mystring.push_back(*p);
		}
		yylval->setInteger(sz2longlong(mystring.c_str()));
		yylval->setString(new std::string(mystring));
        } else {
		char szInt[MAX_INTEGER_CHARS+1];

		const char *p;
		char *q = szInt;
		for (p = tok;
		     p != cur;
	     	     ++p) {
		     *q++ = *p;
		}
		*q = '\0';
		yylval->setInteger(sz2longlong(szInt));
		yylval->setString(new std::string(szInt));
	}
}

void EmdroslangScanner::getString(std::string& str)
{
	const char *p;
	for (p = tok;
	     p != cur;
	     ++p) {
	     str.push_back(*p);
	}
}

