#
# emdros.spec made from emdros.spec.in 
# via the configure script
#
%define ver          3.7.3
%define rel          1%{?dist}
%define prefix       /usr
%define home_page    http://emdros.org/

######################################################################
# Usually, nothing needs to be changed below here between releases
######################################################################
Summary: The database engine for analyzed or annotated text
Name: emdros
Version: %{ver}
Release: %{rel}
URL: %{home_page}
Source0: emdros-3.7.3.tar.gz
License: MIT
Group: Applications/Databases
Prefix: %{prefix}
BuildRequires: desktop-file-utils xdg-utils gcc-c++
#BuildRequires: gcc-c++
Requires(post): desktop-file-utils xdg-utils
Requires(preun): desktop-file-utils xdg-utils

%description 

Emdros is a text database engine for storage and retrieval of
annotated or analyzed text. Application domains include linguistics,
publishing, and text processing, with corpus linguistics being the
main target domain. Emdros has a powerful query-language for
query/create/update/delete operations.


%prep

%autosetup 

#%setup -q -n emdros-%{version}

%build

CFLAGS="$RPM_OPT_FLAGS $CFLAGS"
CXXFLAGS="$RPM_OPT_FLAGS $CXXFLAGS"
export CFLAGS CXXFLAGS
./configure  --with-swig-language-csharp=maybe  --with-swig-language-java=maybe  --with-swig-language-php7=maybe  --with-swig-language-python2=maybe  --with-swig-language-python3=maybe --disable-static --disable-dependency-tracking --enable-debug  --with-wx=maybe  --with-sqlite3=yes  --with-postgresql=maybe  --with-mysql=maybe   --with-bpt=maybe   --prefix=%{prefix}
%make_build


%check

make test

%install

make install DESTDIR=%{buildroot}

%post
/sbin/ldconfig


XDG_ICON_RESOURCE=`which xdg-icon-resource  2>/dev/null`
DESKTOP_FILE_INSTALL=`which desktop-file-install  2>/dev/null`

if test "x$XDG_ICON_RESOURCE" != "x" -a "x$DESKTOP_FILE_INSTALL" != "x"; then
   if test -x "$XDG_ICON_RESOURCE" -a -x "$DESKTOP_FILE_INSTALL" -a -x ${prefix}/bin/eqtu; then
      $XDG_ICON_RESOURCE install --size 16 %{prefix}/share/emdros/blue-E-16x16.png scripturesys-blue-E || true
      $XDG_ICON_RESOURCE install --size 22 %{prefix}/share/emdros/blue-E-22x22.png scripturesys-blue-E || true
      $XDG_ICON_RESOURCE install --size 32 %{prefix}/share/emdros/blue-E-32x32.png scripturesys-blue-E || true
      $XDG_ICON_RESOURCE install --size 48 %{prefix}/share/emdros/blue-E-48x48.png scripturesys-blue-E || true
      $XDG_ICON_RESOURCE install --size 64 %{prefix}/share/emdros/blue-E-64x64.png scripturesys-blue-E || true
      $XDG_ICON_RESOURCE install --size 128 %{prefix}/share/emdros/blue-E-128x128.png scripturesys-blue-E || true

#      $DESKTOP_FILE_INSTALL --dir %{_datadir}/applications  %{prefix}/share/emdros/scripturesys-eqtu.desktop || true
#      $DESKTOP_FILE_INSTALL --dir %{_datadir}/applications  %{prefix}/share/emdros/scripturesys-importtool.desktop || true

      desktop-file-validate %{_datadir}/applications/scripturesys-eqtu.desktop
      desktop-file-validate %{_datadir}/applications/scripturesys-importtool.desktop
   fi
fi

#
# This is preun rather than postun because we need to be able 
# to refer to the .desktop file, which would have been erased
# at postun.
#
%preun

#
# We need to check the argument to the script, which shows the
# number of packages of emdros installed.  Only when we reach 0
# can we erase emdros from the menu.
#
if test "x$1" == "x0"; then
   
   XDG_ICON_RESOURCE=`which xdg-icon-resource  2>/dev/null`
   XDG_DESKTOP_MENU=`which xdg-desktop-menu  2>/dev/null`

   if test "x$XDG_ICON_RESOURCE" != "x" -a "x$XDG_DESKTOP_MENU" != "x"; then
      if test -x $XDG_ICON_RESOURCE -a -x $XDG_DESKTOP_MENU -a -x ${prefix}/bin/eqtu; then
#         $XDG_DESKTOP_MENU uninstall %{prefix}/share/emdros/scripturesys-eqtu.desktop
#         $XDG_DESKTOP_MENU uninstall %{prefix}/share/emdros/scripturesys-importtool.desktop || true

      	 $XDG_ICON_RESOURCE uninstall --size 16 scripturesys-blue-E || true
         $XDG_ICON_RESOURCE uninstall --size 22 scripturesys-blue-E || true
         $XDG_ICON_RESOURCE uninstall --size 32 scripturesys-blue-E || true
         $XDG_ICON_RESOURCE uninstall --size 48 scripturesys-blue-E || true
         $XDG_ICON_RESOURCE uninstall --size 64 scripturesys-blue-E || true
         $XDG_ICON_RESOURCE uninstall --size 128 scripturesys-blue-E || true
      fi
   fi
fi



%postun
/sbin/ldconfig


%clean
rm -rf %{buildroot}


%package devel
Requires: emdros = 3.7.3

Summary: Development files for Emdros - The database engine for analyzed or annotated text 

%description devel

Emdros is a text database engine for storage and retrieval of
annotated or analyzed text. Application domains include linguistics,
publishing, and text processing, with corpus linguistics being the
main target domain. Emdros has a powerful query-language for
query/create/update/delete operations.

This package contains development files.




%files devel -f %{_builddir}/emdros-%{ver}/extrafiles-emdros-devel.txt
%{prefix}/lib/*.so
%{prefix}/lib/*.la
%{_datadir}/pkgconfig/emdros.pc
%{_includedir}/emdros/

%files  -f %{_builddir}/emdros-%{ver}/extrafiles-emdros.txt
%{_bindir}/*
%{prefix}/share/applications/
%{prefix}/share/emdros/
%{prefix}/share/doc/emdros/
%{prefix}/lib/*.so.*
%doc SWIG/csharp/README-csharp
%doc SWIG/csharp/TestEmdros.cs
%doc SWIG/java/README-Java
%doc SWIG/java/TestEmdros.java
%doc SWIG/python/README-Python
%doc SWIG/python/test.py
%doc SWIG/python3/README-Python3
%doc SWIG/python3/test3.py
%doc SWIG/php7/README-PHP7
%doc SWIG/php7/test7.php
%doc %{_mandir}/man1/*.1*
%doc %{_mandir}/man5/*.5*
%doc README NEWS ChangeLog COPYING AUTHORS INSTALL
%doc src/qrytool/doc/EQTUsersGuide.pdf



#%defattr(-,root,root)

%changelog

* Fri Feb 15 2019 Ulrik Sandborg-Petersen <ulrikp@emdros.org>
  Remove @WITH_BPT2@.  

* Sun Feb 3 2019 Ulrik Sandborg-Petersen <ulrikp@emdros.org>
  Add gcc-c++ to BuildRequires. Add a version of BuildRequires for
  WX_DO_UNICODE_FALSE.

* Wed Jan 16 2019 Ulrik Sandborg-Petersen <ulrikp@users.sf.net>
  Enable rpm-build of version 3.7.0

* Fri Jun 1 2018 Ulrik Sandborg-Petersen <ulrikp@users.sf.net>

  Better %post and %preun, with better handling of GUI icons.  Better
  BuildRequires and Requires entries.

* Mon May 28 2018 Ulrik Sandborg-Petersen <ulrikp@users.sf.net>
  Enable rpm-build of version 4.0.0.

* Tue May 8 2018 Ulrik Sandborg-Petersen <ulrikp@users.sf.net> Remove
  SQLite2 support in 3.6.0.

* Wed Jul 19 2017 Ulrik Sandborg-Petersen <ulrikp@users.sf.net> Update
  doc section to work with the newly distributed PDF and HTML files from
  version 3.5.15.

* Thu Jun 22 2017 Ulrik Sandborg-Petersen <ulrikp@users.sf.net> Update
  to work with CentOS 7.  Put SWIG files previously in emdros-devel
  into the emdros package.  Make rpmlint more happy.

* Wed Nov 23 2016 Ulrik Sandborg-Petersen <ulrikp@users.sf.net>
  3.4.1.pre37-1.fc25 In files section, do glob %{prefix}/lib/* instead
  of .../lib/*.*, and don't do %{prefix}/lib/emdros/*, so as to be
  able to compile without any SWIG backends.

* Sat Dec 20 2014 Ulrik Sandborg-Petersen <ulrikp@users.sf.net> 3.4.1.pre07-1.fc21
  In files section, do glob %{prefix}/lib/*.* instead of .../lib/*.so
  and .../lib/*.a, so as to be able to rpmbuild on Fedora 21, where .a
  files are no longer generated.

* Sat Sep 27 2014 Ulrik Sandborg-Petersen <ulrikp@users.sf.net> 3.4.1.pre05-1.fc20
  Added --with-sqlite3=yes, --with-bpt=maybe, and @WITH_BPT2@ to the call to configure.

* Sun Sep 28 2008 Ulrik Sandborg-Petersen <ulrikp@users.sf.net> 3.0.2-1.fc9
  Updated to 3.0.2.

* Sat Jan 20 2007 Ulrik Petersen <ulrikp@users.sf.net> 1.2.0.pre234-1.fc6
  Added changelog for the first time. This spec file has sat around
  for a number of years without a changelong entry.
