/* Generated by re2c 2.0.3 on Tue Dec  8 12:13:25 2020 */
#line 1 "./mql.re"
/*
 * mql.re
 *
 * MQL Lexer based on re2c
 *
 * Ulrik Petersen
 * Created: 6/23-2007
 * Last update: 11/30-2018
 *
 */

/*
 * Copyright (C) 2001-2018     Ulrik Sandborg-Petersen
 * Copyright (C) 2018-present  Sandborg-Petersen Holding ApS, Denmark
 *
 * Licensed under the MIT License.
 *
 * Please see the file COPYING in the root of the sources for more details.
 *
 */


/**@file mql_lexer.re
 *@brief Implementation file for MQL Lexer (MQL layer)
 */

#include <mql_lexer.h>
#include <mqlpars.h>
#include <iostream>
#include <string_func.h>

#undef YYCTYPE
#undef YYCURSOR
#undef YYLIMIT
#undef YYMARKER

#define YYCTYPE         unsigned char
#define YYCURSOR        cur
#define YYLIMIT         lim
#define YYMARKER        ptr
#line 44 "./mql.re"



#line 79 "./mql.re"



MQLScanner::MQLScanner(const std::string& strIn)
{
	sz = strIn.c_str();
	lim = sz + strIn.length();
	bot = tok = ptr = pos = top = eof = 0;
	cur = sz;
}

MQLScanner::~MQLScanner()
{
	if (bot) {
		delete[] bot;
	}
}


#define MQL_TOKEN_RETURN(X,Y) { yylval->setName(X); return Y; }

int MQLScanner::scan(Token *pYYLVAL)
{
	yylval = pYYLVAL;

 scan:	
	tok = cur;


#line 78 "./mql_lexer.cpp"
{
	YYCTYPE yych;
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:	goto xx2;
	case '\t':	goto xx6;
	case '\n':	goto xx8;
	case '\r':	goto xx10;
	case ' ':	goto xx12;
	case '!':	goto xx14;
	case '"':	goto xx16;
	case '\'':	goto xx18;
	case '(':	goto xx20;
	case ')':	goto xx22;
	case '*':	goto xx24;
	case ',':	goto xx26;
	case '-':	goto xx28;
	case '.':	goto xx30;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto xx32;
	case ':':	goto xx34;
	case ';':	goto xx36;
	case '<':	goto xx38;
	case '=':	goto xx40;
	case '>':	goto xx42;
	case 'A':
	case 'a':	goto xx44;
	case 'B':
	case 'b':	goto xx46;
	case 'C':
	case 'c':	goto xx47;
	case 'D':
	case 'd':	goto xx48;
	case 'E':
	case 'e':	goto xx49;
	case 'F':
	case 'f':	goto xx50;
	case 'G':
	case 'g':	goto xx51;
	case 'H':
	case 'h':	goto xx52;
	case 'I':
	case 'i':	goto xx53;
	case 'J':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'j':
	case 'x':
	case 'y':
	case 'z':	goto xx54;
	case 'K':
	case 'k':	goto xx56;
	case 'L':
	case 'l':	goto xx57;
	case 'M':
	case 'm':	goto xx58;
	case 'N':
	case 'n':	goto xx59;
	case 'O':
	case 'o':	goto xx60;
	case 'P':
	case 'p':	goto xx61;
	case 'Q':
	case 'q':	goto xx62;
	case 'R':
	case 'r':	goto xx63;
	case 'S':
	case 's':	goto xx64;
	case 'T':
	case 't':	goto xx65;
	case 'U':
	case 'u':	goto xx66;
	case 'V':
	case 'v':	goto xx67;
	case 'W':
	case 'w':	goto xx68;
	case '[':	goto xx69;
	case ']':	goto xx71;
	case '`':	goto xx73;
	case '{':	goto xx74;
	case '}':	goto xx76;
	case '~':	goto xx78;
	default:	goto xx4;
	}
xx2:
	++YYCURSOR;
#line 255 "./mql.re"
	{ if (cur >= lim) { goto end; } }
#line 177 "./mql_lexer.cpp"
xx4:
	++YYCURSOR;
xx5:
#line 256 "./mql.re"
	{ yylval->setChar(*tok);
	    MQL_TOKEN_RETURN(CHAR_MAGIC, *tok); }
#line 184 "./mql_lexer.cpp"
xx6:
	++YYCURSOR;
#line 252 "./mql.re"
	{ goto scan; }
#line 189 "./mql_lexer.cpp"
xx8:
	++YYCURSOR;
#line 254 "./mql.re"
	{ goto scan; }
#line 194 "./mql_lexer.cpp"
xx10:
	++YYCURSOR;
#line 253 "./mql.re"
	{ goto scan; }
#line 199 "./mql_lexer.cpp"
xx12:
	++YYCURSOR;
#line 251 "./mql.re"
	{ goto scan; }
#line 204 "./mql_lexer.cpp"
xx14:
	yych = *++YYCURSOR;
	if (yych == '~') goto xx80;
#line 235 "./mql.re"
	{ MQL_TOKEN_RETURN("!", T_KEY_EXCLAMATION); }
#line 210 "./mql_lexer.cpp"
xx16:
	++YYCURSOR;
#line 243 "./mql.re"
	{ yylval->setString(new std::string);
			      yylval->pString->reserve(32);
			      goto stringdq; 
                            }
#line 218 "./mql_lexer.cpp"
xx18:
	++YYCURSOR;
#line 247 "./mql.re"
	{ yylval->setString(new std::string);
			      yylval->pString->reserve(32);
			      goto stringsq; 
			    }
#line 226 "./mql_lexer.cpp"
xx20:
	++YYCURSOR;
#line 226 "./mql.re"
	{ MQL_TOKEN_RETURN("(", T_KEY_OPEN_BRACKET); }
#line 231 "./mql_lexer.cpp"
xx22:
	++YYCURSOR;
#line 227 "./mql.re"
	{ MQL_TOKEN_RETURN(")", T_KEY_CLOSE_BRACKET); }
#line 236 "./mql_lexer.cpp"
xx24:
	++YYCURSOR;
#line 233 "./mql.re"
	{ MQL_TOKEN_RETURN("*", T_KEY_STAR); }
#line 241 "./mql_lexer.cpp"
xx26:
	++YYCURSOR;
#line 231 "./mql.re"
	{ MQL_TOKEN_RETURN(",", T_KEY_COMMA); }
#line 246 "./mql_lexer.cpp"
xx28:
	++YYCURSOR;
#line 234 "./mql.re"
	{ MQL_TOKEN_RETURN("-", T_KEY_DASH); }
#line 251 "./mql_lexer.cpp"
xx30:
	yych = *++YYCURSOR;
	if (yych == '.') goto xx82;
#line 232 "./mql.re"
	{ MQL_TOKEN_RETURN(".", T_KEY_DOT); }
#line 257 "./mql_lexer.cpp"
xx32:
	yych = *++YYCURSOR;
	if (yych <= '/') goto xx33;
	if (yych <= '9') goto xx84;
xx33:
#line 241 "./mql.re"
	{ addInteger();
                              MQL_TOKEN_RETURN(INTEGER_MAGIC, T_INTEGER); }
#line 266 "./mql_lexer.cpp"
xx34:
	yych = *++YYCURSOR;
	if (yych == '=') goto xx85;
#line 229 "./mql.re"
	{ MQL_TOKEN_RETURN(":", T_KEY_COLON); }
#line 272 "./mql_lexer.cpp"
xx36:
	++YYCURSOR;
#line 230 "./mql.re"
	{ MQL_TOKEN_RETURN(";", T_KEY_SEMICOLON); }
#line 277 "./mql_lexer.cpp"
xx38:
	yych = *++YYCURSOR;
	if (yych <= '<') goto xx39;
	if (yych <= '=') goto xx87;
	if (yych <= '>') goto xx89;
xx39:
#line 213 "./mql.re"
	{ MQL_TOKEN_RETURN("<", T_KEY_LESS_THAN);  }
#line 286 "./mql_lexer.cpp"
xx40:
	yych = *++YYCURSOR;
	if (yych == '<') goto xx91;
	if (yych == '>') goto xx93;
#line 212 "./mql.re"
	{ MQL_TOKEN_RETURN("=", T_KEY_EQUALS);  }
#line 293 "./mql_lexer.cpp"
xx42:
	yych = *++YYCURSOR;
	if (yych == '=') goto xx95;
#line 214 "./mql.re"
	{ MQL_TOKEN_RETURN(">", T_KEY_GREATER_THAN);  }
#line 299 "./mql_lexer.cpp"
xx44:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto xx97;
	case 'D':
	case 'd':	goto xx98;
	case 'G':
	case 'g':	goto xx99;
	case 'L':
	case 'l':	goto xx100;
	case 'N':
	case 'n':	goto xx101;
	case 'S':
	case 's':	goto xx102;
	case 'T':
	case 't':	goto xx104;
	default:	goto xx55;
	}
xx45:
#line 236 "./mql.re"
	{ addToken();
			      MQL_TOKEN_RETURN(STRING_MAGIC, T_IDENTIFIER);
			    }
#line 324 "./mql_lexer.cpp"
xx46:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'E') goto xx106;
		if (yych <= 'X') goto xx55;
		goto xx107;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto xx55;
			goto xx106;
		} else {
			if (yych == 'y') goto xx107;
			goto xx55;
		}
	}
xx47:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'A') goto xx109;
			goto xx55;
		} else {
			if (yych <= 'O') goto xx110;
			if (yych <= 'Q') goto xx55;
			goto xx111;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'a') goto xx109;
			goto xx55;
		} else {
			if (yych <= 'o') goto xx110;
			if (yych == 'r') goto xx111;
			goto xx55;
		}
	}
xx48:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych == 'A') goto xx112;
			if (yych <= 'D') goto xx55;
			goto xx113;
		} else {
			if (yych == 'I') goto xx114;
			if (yych <= 'Q') goto xx55;
			goto xx115;
		}
	} else {
		if (yych <= 'e') {
			if (yych == 'a') goto xx112;
			if (yych <= 'd') goto xx55;
			goto xx113;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto xx55;
				goto xx114;
			} else {
				if (yych == 'r') goto xx115;
				goto xx55;
			}
		}
	}
xx49:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == 'N') goto xx116;
		if (yych <= 'W') goto xx55;
		goto xx117;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto xx55;
			goto xx116;
		} else {
			if (yych == 'x') goto xx117;
			goto xx55;
		}
	}
xx50:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto xx118;
	case 'I':
	case 'i':	goto xx119;
	case 'L':
	case 'l':	goto xx120;
	case 'O':
	case 'o':	goto xx121;
	case 'R':
	case 'r':	goto xx122;
	case 'U':
	case 'u':	goto xx123;
	default:	goto xx55;
	}
xx51:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == 'A') goto xx124;
			goto xx55;
		} else {
			if (yych <= 'E') goto xx125;
			if (yych <= 'N') goto xx55;
			goto xx126;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto xx124;
			goto xx55;
		} else {
			if (yych <= 'e') goto xx125;
			if (yych == 'o') goto xx126;
			goto xx55;
		}
	}
xx52:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx128;
	if (yych == 'a') goto xx128;
	goto xx55;
xx53:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'E') {
			if (yych == 'D') goto xx129;
			goto xx55;
		} else {
			if (yych <= 'F') goto xx130;
			if (yych <= 'M') goto xx55;
			goto xx132;
		}
	} else {
		if (yych <= 'e') {
			if (yych == 'd') goto xx129;
			goto xx55;
		} else {
			if (yych <= 'f') goto xx130;
			if (yych == 'n') goto xx132;
			goto xx55;
		}
	}
xx54:
	yych = *++YYCURSOR;
xx55:
	if (yych <= 'Z') {
		if (yych <= '/') goto xx45;
		if (yych <= '9') goto xx54;
		if (yych <= '@') goto xx45;
		goto xx54;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto xx45;
			goto xx54;
		} else {
			if (yych <= '`') goto xx45;
			if (yych <= 'z') goto xx54;
			goto xx45;
		}
	}
xx56:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx134;
	if (yych == 'e') goto xx134;
	goto xx55;
xx57:
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych == 'A') goto xx135;
		if (yych <= 'H') goto xx55;
		goto xx136;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto xx55;
			goto xx135;
		} else {
			if (yych == 'i') goto xx136;
			goto xx55;
		}
	}
xx58:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'I') {
			if (yych == 'A') goto xx137;
			if (yych <= 'H') goto xx55;
			goto xx138;
		} else {
			if (yych == 'O') goto xx139;
			if (yych <= 'T') goto xx55;
			goto xx140;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto xx137;
			if (yych <= 'h') goto xx55;
			goto xx138;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto xx55;
				goto xx139;
			} else {
				if (yych == 'u') goto xx140;
				goto xx55;
			}
		}
	}
xx59:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto xx141;
		if (yych <= 'N') goto xx55;
		goto xx142;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto xx55;
			goto xx141;
		} else {
			if (yych == 'o') goto xx142;
			goto xx55;
		}
	}
xx60:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto xx143;
	case 'F':
	case 'f':	goto xx144;
	case 'N':
	case 'n':	goto xx146;
	case 'R':
	case 'r':	goto xx148;
	case 'V':
	case 'v':	goto xx150;
	default:	goto xx55;
	}
xx61:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx151;
	if (yych == 'a') goto xx151;
	goto xx55;
xx62:
	yych = *++YYCURSOR;
	if (yych == 'U') goto xx152;
	if (yych == 'u') goto xx152;
	goto xx55;
xx63:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto xx153;
		if (yych <= 'D') goto xx55;
		goto xx154;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto xx55;
			goto xx153;
		} else {
			if (yych == 'e') goto xx154;
			goto xx55;
		}
	}
xx64:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'H') {
			if (yych == 'E') goto xx155;
			if (yych <= 'G') goto xx55;
			goto xx156;
		} else {
			if (yych <= 'I') goto xx157;
			if (yych <= 'S') goto xx55;
			if (yych <= 'T') goto xx158;
			goto xx159;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'e') goto xx155;
			if (yych <= 'g') goto xx55;
			goto xx156;
		} else {
			if (yych <= 's') {
				if (yych <= 'i') goto xx157;
				goto xx55;
			} else {
				if (yych <= 't') goto xx158;
				if (yych <= 'u') goto xx159;
				goto xx55;
			}
		}
	}
xx65:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto xx160;
		if (yych <= 'X') goto xx55;
		goto xx161;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto xx55;
			goto xx160;
		} else {
			if (yych == 'y') goto xx161;
			goto xx55;
		}
	}
xx66:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'O') {
			if (yych == 'N') goto xx162;
			goto xx55;
		} else {
			if (yych <= 'P') goto xx163;
			if (yych <= 'R') goto xx55;
			goto xx164;
		}
	} else {
		if (yych <= 'o') {
			if (yych == 'n') goto xx162;
			goto xx55;
		} else {
			if (yych <= 'p') goto xx163;
			if (yych == 's') goto xx164;
			goto xx55;
		}
	}
xx67:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx165;
	if (yych == 'a') goto xx165;
	goto xx55;
xx68:
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= 'G') goto xx55;
		if (yych <= 'H') goto xx166;
		goto xx167;
	} else {
		if (yych <= 'g') goto xx55;
		if (yych <= 'h') goto xx166;
		if (yych <= 'i') goto xx167;
		goto xx55;
	}
xx69:
	++YYCURSOR;
#line 222 "./mql.re"
	{ MQL_TOKEN_RETURN("[", T_KEY_OPEN_SQUARE_BRACKET); }
#line 673 "./mql_lexer.cpp"
xx71:
	++YYCURSOR;
#line 223 "./mql.re"
	{ MQL_TOKEN_RETURN("]", T_KEY_CLOSE_SQUARE_BRACKET); }
#line 678 "./mql_lexer.cpp"
xx73:
	yych = *++YYCURSOR;
	if (yych <= '^') {
		if (yych <= '@') goto xx5;
		if (yych <= 'Z') goto xx168;
		goto xx5;
	} else {
		if (yych == '`') goto xx5;
		if (yych <= 'z') goto xx168;
		goto xx5;
	}
xx74:
	++YYCURSOR;
#line 224 "./mql.re"
	{ MQL_TOKEN_RETURN("{", T_KEY_OPEN_BRACE);  }
#line 694 "./mql_lexer.cpp"
xx76:
	++YYCURSOR;
#line 225 "./mql.re"
	{ MQL_TOKEN_RETURN("}", T_KEY_CLOSE_BRACE);  }
#line 699 "./mql_lexer.cpp"
xx78:
	++YYCURSOR;
#line 220 "./mql.re"
	{ MQL_TOKEN_RETURN("~", T_KEY_TILDE); }
#line 704 "./mql_lexer.cpp"
xx80:
	++YYCURSOR;
#line 221 "./mql.re"
	{ MQL_TOKEN_RETURN("!~", T_KEY_NOT_TILDE); }
#line 709 "./mql_lexer.cpp"
xx82:
	++YYCURSOR;
#line 183 "./mql.re"
	{ MQL_TOKEN_RETURN("..", T_KEY_POWER);  }
#line 714 "./mql_lexer.cpp"
xx84:
	yych = *++YYCURSOR;
	if (yych <= '/') goto xx33;
	if (yych <= '9') goto xx171;
	goto xx33;
xx85:
	++YYCURSOR;
#line 228 "./mql.re"
	{ MQL_TOKEN_RETURN(":=", T_KEY_ASSIGN);  }
#line 724 "./mql_lexer.cpp"
xx87:
	++YYCURSOR;
#line 216 "./mql.re"
	{ MQL_TOKEN_RETURN("<=", T_KEY_LESS_THAN_OR_EQUAL);  }
#line 729 "./mql_lexer.cpp"
xx89:
	++YYCURSOR;
#line 215 "./mql.re"
	{ MQL_TOKEN_RETURN("<>", T_KEY_NOT_EQUAL);  }
#line 734 "./mql_lexer.cpp"
xx91:
	++YYCURSOR;
#line 217 "./mql.re"
	{ MQL_TOKEN_RETURN("=<", T_KEY_LESS_THAN_OR_EQUAL);  }
#line 739 "./mql_lexer.cpp"
xx93:
	++YYCURSOR;
#line 219 "./mql.re"
	{ MQL_TOKEN_RETURN("=>", T_KEY_GREATER_THAN_OR_EQUAL);  }
#line 744 "./mql_lexer.cpp"
xx95:
	++YYCURSOR;
#line 218 "./mql.re"
	{ MQL_TOKEN_RETURN(">=", T_KEY_GREATER_THAN_OR_EQUAL);  }
#line 749 "./mql_lexer.cpp"
xx97:
	yych = *++YYCURSOR;
	if (yych == 'O') goto xx172;
	if (yych == 'o') goto xx172;
	goto xx55;
xx98:
	yych = *++YYCURSOR;
	if (yych == 'D') goto xx173;
	if (yych == 'd') goto xx173;
	goto xx55;
xx99:
	yych = *++YYCURSOR;
	if (yych == 'G') goto xx175;
	if (yych == 'g') goto xx175;
	goto xx55;
xx100:
	yych = *++YYCURSOR;
	if (yych == 'L') goto xx176;
	if (yych == 'l') goto xx176;
	goto xx55;
xx101:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych == 'A') goto xx178;
		if (yych <= 'C') goto xx55;
		goto xx179;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto xx55;
			goto xx178;
		} else {
			if (yych == 'd') goto xx179;
			goto xx55;
		}
	}
xx102:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '@') {
			if (yych <= '/') goto xx103;
			if (yych <= '9') goto xx54;
		} else {
			if (yych == 'C') goto xx181;
			goto xx54;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto xx54;
		} else {
			if (yych == 'c') goto xx181;
			if (yych <= 'z') goto xx54;
		}
	}
xx103:
#line 185 "./mql.re"
	{ MQL_TOKEN_RETURN("as", T_KEY_AS);  }
#line 806 "./mql_lexer.cpp"
xx104:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx105;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx105;
			if (yych <= 'z') goto xx54;
		}
	}
xx105:
#line 200 "./mql.re"
	{ MQL_TOKEN_RETURN("at", T_KEY_AT); }
#line 824 "./mql_lexer.cpp"
xx106:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych == 'G') goto xx182;
		if (yych <= 'S') goto xx55;
		goto xx183;
	} else {
		if (yych <= 'g') {
			if (yych <= 'f') goto xx55;
			goto xx182;
		} else {
			if (yych == 't') goto xx183;
			goto xx55;
		}
	}
xx107:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx108;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx108;
			if (yych <= 'z') goto xx54;
		}
	}
xx108:
#line 144 "./mql.re"
	{ MQL_TOKEN_RETURN("by", T_KEY_BY);  }
#line 857 "./mql_lexer.cpp"
xx109:
	yych = *++YYCURSOR;
	if (yych == 'L') goto xx184;
	if (yych == 'l') goto xx184;
	goto xx55;
xx110:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'M') {
			if (yych <= 'L') goto xx55;
			goto xx185;
		} else {
			if (yych <= 'N') goto xx186;
			if (yych <= 'T') goto xx55;
			goto xx187;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'l') goto xx55;
			if (yych <= 'm') goto xx185;
			goto xx186;
		} else {
			if (yych == 'u') goto xx187;
			goto xx55;
		}
	}
xx111:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx188;
	if (yych == 'e') goto xx188;
	goto xx55;
xx112:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx189;
	if (yych == 't') goto xx189;
	goto xx55;
xx113:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == 'F') goto xx190;
		if (yych <= 'K') goto xx55;
		goto xx191;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto xx55;
			goto xx190;
		} else {
			if (yych == 'l') goto xx191;
			goto xx55;
		}
	}
xx114:
	yych = *++YYCURSOR;
	if (yych == 'F') goto xx192;
	if (yych == 'f') goto xx192;
	goto xx55;
xx115:
	yych = *++YYCURSOR;
	if (yych == 'O') goto xx193;
	if (yych == 'o') goto xx193;
	goto xx55;
xx116:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'C') goto xx194;
		if (yych <= 'T') goto xx55;
		goto xx195;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto xx55;
			goto xx194;
		} else {
			if (yych == 'u') goto xx195;
			goto xx55;
		}
	}
xx117:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx196;
	if (yych == 'i') goto xx196;
	goto xx55;
xx118:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx197;
	if (yych == 'a') goto xx197;
	goto xx55;
xx119:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx198;
	if (yych == 'r') goto xx198;
	goto xx55;
xx120:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx199;
	if (yych == 'a') goto xx199;
	goto xx55;
xx121:
	yych = *++YYCURSOR;
	if (yych == 'C') goto xx200;
	if (yych == 'c') goto xx200;
	goto xx55;
xx122:
	yych = *++YYCURSOR;
	if (yych == 'O') goto xx201;
	if (yych == 'o') goto xx201;
	goto xx55;
xx123:
	yych = *++YYCURSOR;
	if (yych == 'L') goto xx202;
	if (yych == 'l') goto xx202;
	goto xx55;
xx124:
	yych = *++YYCURSOR;
	if (yych == 'P') goto xx203;
	if (yych == 'p') goto xx203;
	goto xx55;
xx125:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx205;
	if (yych == 't') goto xx205;
	goto xx55;
xx126:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx127;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx127;
			if (yych <= 'z') goto xx54;
		}
	}
xx127:
#line 187 "./mql.re"
	{ MQL_TOKEN_RETURN("go", T_KEY_GO); }
#line 996 "./mql_lexer.cpp"
xx128:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych == 'S') goto xx207;
		if (yych <= 'U') goto xx55;
		goto xx209;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto xx55;
			goto xx207;
		} else {
			if (yych == 'v') goto xx209;
			goto xx55;
		}
	}
xx129:
	yych = *++YYCURSOR;
	if (yych == '_') goto xx210;
	goto xx55;
xx130:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx131;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx131;
			if (yych <= 'z') goto xx54;
		}
	}
xx131:
#line 178 "./mql.re"
	{ MQL_TOKEN_RETURN("if", T_KEY_IF);  }
#line 1033 "./mql_lexer.cpp"
xx132:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= 'D') {
			if (yych <= '9') {
				if (yych >= '0') goto xx54;
			} else {
				if (yych <= '@') goto xx133;
				if (yych <= 'C') goto xx54;
				goto xx211;
			}
		} else {
			if (yych <= 'R') {
				if (yych == 'I') goto xx212;
				goto xx54;
			} else {
				if (yych <= 'S') goto xx213;
				if (yych <= 'T') goto xx214;
				goto xx54;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych == '_') goto xx54;
			} else {
				if (yych == 'd') goto xx211;
				goto xx54;
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'i') goto xx212;
				if (yych <= 'r') goto xx54;
				goto xx213;
			} else {
				if (yych <= 't') goto xx214;
				if (yych <= 'z') goto xx54;
			}
		}
	}
xx133:
#line 131 "./mql.re"
	{ MQL_TOKEN_RETURN("in", T_KEY_IN);  }
#line 1077 "./mql_lexer.cpp"
xx134:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto xx215;
	if (yych == 'y') goto xx215;
	goto xx55;
xx135:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx217;
	if (yych == 's') goto xx217;
	goto xx55;
xx136:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx218;
	if (yych == 's') goto xx218;
	goto xx55;
xx137:
	yych = *++YYCURSOR;
	if (yych == 'X') goto xx219;
	if (yych == 'x') goto xx219;
	goto xx55;
xx138:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx221;
	if (yych == 'n') goto xx221;
	goto xx55;
xx139:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx223;
	if (yych == 'n') goto xx223;
	goto xx55;
xx140:
	yych = *++YYCURSOR;
	if (yych == 'L') goto xx224;
	if (yych == 'l') goto xx224;
	goto xx55;
xx141:
	yych = *++YYCURSOR;
	if (yych == 'L') goto xx225;
	if (yych == 'l') goto xx225;
	goto xx55;
xx142:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych == 'R') goto xx227;
		if (yych <= 'S') goto xx55;
		goto xx228;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto xx55;
			goto xx227;
		} else {
			if (yych == 't') goto xx228;
			goto xx55;
		}
	}
xx143:
	yych = *++YYCURSOR;
	if (yych == 'J') goto xx230;
	if (yych == 'j') goto xx230;
	goto xx55;
xx144:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx145;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx145;
			if (yych <= 'z') goto xx54;
		}
	}
xx145:
#line 130 "./mql.re"
	{ MQL_TOKEN_RETURN("of", T_KEY_OF); }
#line 1155 "./mql_lexer.cpp"
xx146:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx147;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx147;
			if (yych <= 'z') goto xx54;
		}
	}
xx147:
#line 198 "./mql.re"
	{ MQL_TOKEN_RETURN("on", T_KEY_ON); }
#line 1173 "./mql_lexer.cpp"
xx148:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx149;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx149;
			if (yych <= 'z') goto xx54;
		}
	}
xx149:
#line 174 "./mql.re"
	{ MQL_TOKEN_RETURN("or", T_KEY_OR);  }
#line 1191 "./mql_lexer.cpp"
xx150:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx231;
	if (yych == 'e') goto xx231;
	goto xx55;
xx151:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx232;
	if (yych == 'r') goto xx232;
	goto xx55;
xx152:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx233;
	if (yych == 'i') goto xx233;
	goto xx55;
xx153:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx234;
	if (yych == 'n') goto xx234;
	goto xx55;
xx154:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'O') {
			if (yych == 'M') goto xx235;
			goto xx55;
		} else {
			if (yych <= 'P') goto xx236;
			if (yych <= 'S') goto xx55;
			goto xx237;
		}
	} else {
		if (yych <= 'o') {
			if (yych == 'm') goto xx235;
			goto xx55;
		} else {
			if (yych <= 'p') goto xx236;
			if (yych == 't') goto xx237;
			goto xx55;
		}
	}
xx155:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'K') {
			if (yych == 'G') goto xx238;
			goto xx55;
		} else {
			if (yych <= 'L') goto xx239;
			if (yych <= 'S') goto xx55;
			goto xx240;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'g') goto xx238;
			goto xx55;
		} else {
			if (yych <= 'l') goto xx239;
			if (yych == 't') goto xx240;
			goto xx55;
		}
	}
xx156:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx242;
	if (yych == 'e') goto xx242;
	goto xx55;
xx157:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx243;
	if (yych == 'n') goto xx243;
	goto xx55;
xx158:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'A') goto xx244;
		if (yych <= 'Q') goto xx55;
		goto xx245;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto xx55;
			goto xx244;
		} else {
			if (yych == 'r') goto xx245;
			goto xx55;
		}
	}
xx159:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych == 'B') goto xx246;
		if (yych <= 'L') goto xx55;
		goto xx247;
	} else {
		if (yych <= 'b') {
			if (yych <= 'a') goto xx55;
			goto xx246;
		} else {
			if (yych == 'm') goto xx247;
			goto xx55;
		}
	}
xx160:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx249;
	if (yych == 'a') goto xx249;
	goto xx55;
xx161:
	yych = *++YYCURSOR;
	if (yych == 'P') goto xx250;
	if (yych == 'p') goto xx250;
	goto xx55;
xx162:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto xx251;
		if (yych <= 'N') goto xx55;
		goto xx252;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto xx55;
			goto xx251;
		} else {
			if (yych == 'o') goto xx252;
			goto xx55;
		}
	}
xx163:
	yych = *++YYCURSOR;
	if (yych == 'D') goto xx253;
	if (yych == 'd') goto xx253;
	goto xx55;
xx164:
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych == 'E') goto xx254;
		if (yych <= 'H') goto xx55;
		goto xx256;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto xx55;
			goto xx254;
		} else {
			if (yych == 'i') goto xx256;
			goto xx55;
		}
	}
xx165:
	yych = *++YYCURSOR;
	if (yych == 'C') goto xx257;
	if (yych == 'c') goto xx257;
	goto xx55;
xx166:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx258;
	if (yych == 'e') goto xx258;
	goto xx55;
xx167:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx259;
	if (yych == 't') goto xx259;
	goto xx55;
xx168:
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Z') {
		if (yych <= '/') goto xx170;
		if (yych <= '9') goto xx168;
		if (yych >= 'A') goto xx168;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx168;
		} else {
			if (yych <= '`') goto xx260;
			if (yych <= 'z') goto xx168;
		}
	}
xx170:
#line 239 "./mql.re"
	{ addToken();
                                           MQL_TOKEN_RETURN("mark", T_MARK); }
#line 1372 "./mql_lexer.cpp"
xx171:
	yych = *++YYCURSOR;
	if (yych <= '/') goto xx33;
	if (yych <= '9') goto xx262;
	goto xx33;
xx172:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx263;
	if (yych == 'r') goto xx263;
	goto xx55;
xx173:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx174;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx174;
			if (yych <= 'z') goto xx54;
		}
	}
xx174:
#line 141 "./mql.re"
	{ MQL_TOKEN_RETURN("add", T_KEY_ADD);  }
#line 1400 "./mql_lexer.cpp"
xx175:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx264;
	if (yych == 'r') goto xx264;
	goto xx55;
xx176:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx177;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx177;
			if (yych <= 'z') goto xx54;
		}
	}
xx177:
#line 154 "./mql.re"
	{ MQL_TOKEN_RETURN("all", T_KEY_ALL);  }
#line 1423 "./mql_lexer.cpp"
xx178:
	yych = *++YYCURSOR;
	if (yych == 'L') goto xx265;
	if (yych == 'l') goto xx265;
	goto xx55;
xx179:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx180;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx180;
			if (yych <= 'z') goto xx54;
		}
	}
xx180:
#line 175 "./mql.re"
	{ MQL_TOKEN_RETURN("and", T_KEY_AND);  }
#line 1446 "./mql_lexer.cpp"
xx181:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx266;
	if (yych == 'i') goto xx266;
	goto xx55;
xx182:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx267;
	if (yych == 'i') goto xx267;
	goto xx55;
xx183:
	yych = *++YYCURSOR;
	if (yych == 'W') goto xx268;
	if (yych == 'w') goto xx268;
	goto xx55;
xx184:
	yych = *++YYCURSOR;
	if (yych == 'C') goto xx269;
	if (yych == 'c') goto xx269;
	goto xx55;
xx185:
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'M') goto xx270;
		if (yych <= 'O') goto xx55;
		goto xx271;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto xx55;
			goto xx270;
		} else {
			if (yych == 'p') goto xx271;
			goto xx55;
		}
	}
xx186:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx272;
	if (yych == 's') goto xx272;
	goto xx55;
xx187:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx273;
	if (yych == 'n') goto xx273;
	goto xx55;
xx188:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx274;
	if (yych == 'a') goto xx274;
	goto xx55;
xx189:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx275;
	if (yych == 'a') goto xx275;
	goto xx55;
xx190:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx276;
	if (yych == 'a') goto xx276;
	goto xx55;
xx191:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx277;
	if (yych == 'e') goto xx277;
	goto xx55;
xx192:
	yych = *++YYCURSOR;
	if (yych == 'F') goto xx278;
	if (yych == 'f') goto xx278;
	goto xx55;
xx193:
	yych = *++YYCURSOR;
	if (yych == 'P') goto xx279;
	if (yych == 'p') goto xx279;
	goto xx55;
xx194:
	yych = *++YYCURSOR;
	if (yych == 'O') goto xx281;
	if (yych == 'o') goto xx281;
	goto xx55;
xx195:
	yych = *++YYCURSOR;
	if (yych == 'M') goto xx282;
	if (yych == 'm') goto xx282;
	goto xx55;
xx196:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx284;
	if (yych == 's') goto xx284;
	goto xx55;
xx197:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx285;
	if (yych == 't') goto xx285;
	goto xx55;
xx198:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx286;
	if (yych == 's') goto xx286;
	goto xx55;
xx199:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx287;
	if (yych == 't') goto xx287;
	goto xx55;
xx200:
	yych = *++YYCURSOR;
	if (yych == 'U') goto xx289;
	if (yych == 'u') goto xx289;
	goto xx55;
xx201:
	yych = *++YYCURSOR;
	if (yych == 'M') goto xx290;
	if (yych == 'm') goto xx290;
	goto xx55;
xx202:
	yych = *++YYCURSOR;
	if (yych == 'L') goto xx292;
	if (yych == 'l') goto xx292;
	goto xx55;
xx203:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '9') {
			if (yych >= '0') goto xx54;
		} else {
			if (yych == '?') goto xx294;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto xx54;
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx204;
			if (yych <= 'z') goto xx54;
		}
	}
xx204:
#line 181 "./mql.re"
	{ MQL_TOKEN_RETURN("gap", T_KEY_GAP);  }
#line 1587 "./mql_lexer.cpp"
xx205:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx206;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx206;
			if (yych <= 'z') goto xx54;
		}
	}
xx206:
#line 113 "./mql.re"
	{ MQL_TOKEN_RETURN("get", T_KEY_GET);  }
#line 1605 "./mql_lexer.cpp"
xx207:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx208;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx208;
			if (yych <= 'z') goto xx54;
		}
	}
xx208:
#line 155 "./mql.re"
	{ MQL_TOKEN_RETURN("has", T_KEY_HAS);  }
#line 1623 "./mql_lexer.cpp"
xx209:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx296;
	if (yych == 'i') goto xx296;
	goto xx55;
xx210:
	yych = *++YYCURSOR;
	if (yych == 'D') goto xx297;
	if (yych == 'd') goto xx297;
	goto xx55;
xx211:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx299;
	if (yych == 'e') goto xx299;
	goto xx55;
xx212:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx300;
	if (yych == 't') goto xx300;
	goto xx55;
xx213:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx301;
	if (yych == 'e') goto xx301;
	goto xx55;
xx214:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx302;
	if (yych == 'e') goto xx302;
	goto xx55;
xx215:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx216;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx216;
			if (yych <= 'z') goto xx54;
		}
	}
xx216:
#line 169 "./mql.re"
	{ MQL_TOKEN_RETURN("key", T_KEY_KEY); }
#line 1671 "./mql_lexer.cpp"
xx217:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx303;
	if (yych == 't') goto xx303;
	goto xx55;
xx218:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx305;
	if (yych == 't') goto xx305;
	goto xx55;
xx219:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx220;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx307;
		} else {
			if (yych <= '`') goto xx220;
			if (yych <= 'z') goto xx54;
		}
	}
xx220:
#line 193 "./mql.re"
	{ MQL_TOKEN_RETURN("max", T_KEY_MAX); }
#line 1699 "./mql_lexer.cpp"
xx221:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx222;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx308;
		} else {
			if (yych <= '`') goto xx222;
			if (yych <= 'z') goto xx54;
		}
	}
xx222:
#line 192 "./mql.re"
	{ MQL_TOKEN_RETURN("min", T_KEY_MIN); }
#line 1717 "./mql_lexer.cpp"
xx223:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx309;
	if (yych == 'a') goto xx309;
	goto xx55;
xx224:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx310;
	if (yych == 't') goto xx310;
	goto xx55;
xx225:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx226;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx226;
			if (yych <= 'z') goto xx54;
		}
	}
xx226:
#line 186 "./mql.re"
	{ MQL_TOKEN_RETURN("nil", T_KEY_NIL);  }
#line 1745 "./mql_lexer.cpp"
xx227:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx311;
	if (yych == 'e') goto xx311;
	goto xx55;
xx228:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '@') {
			if (yych <= '/') goto xx229;
			if (yych <= '9') goto xx54;
		} else {
			if (yych == 'E') goto xx312;
			goto xx54;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto xx54;
		} else {
			if (yych == 'e') goto xx312;
			if (yych <= 'z') goto xx54;
		}
	}
xx229:
#line 176 "./mql.re"
	{ MQL_TOKEN_RETURN("not", T_KEY_NOT);  }
#line 1772 "./mql_lexer.cpp"
xx230:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx313;
	if (yych == 'e') goto xx313;
	goto xx55;
xx231:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx314;
	if (yych == 'r') goto xx314;
	goto xx55;
xx232:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx315;
	if (yych == 't') goto xx315;
	goto xx55;
xx233:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx316;
	if (yych == 't') goto xx316;
	goto xx55;
xx234:
	yych = *++YYCURSOR;
	if (yych == 'G') goto xx318;
	if (yych == 'g') goto xx318;
	goto xx55;
xx235:
	yych = *++YYCURSOR;
	if (yych == 'O') goto xx319;
	if (yych == 'o') goto xx319;
	goto xx55;
xx236:
	yych = *++YYCURSOR;
	if (yych == 'L') goto xx320;
	if (yych == 'l') goto xx320;
	goto xx55;
xx237:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'R') goto xx321;
		if (yych <= 'T') goto xx55;
		goto xx322;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto xx55;
			goto xx321;
		} else {
			if (yych == 'u') goto xx322;
			goto xx55;
		}
	}
xx238:
	yych = *++YYCURSOR;
	if (yych == 'M') goto xx323;
	if (yych == 'm') goto xx323;
	goto xx55;
xx239:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx324;
	if (yych == 'e') goto xx324;
	goto xx55;
xx240:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '@') {
			if (yych <= '/') goto xx241;
			if (yych <= '9') goto xx54;
		} else {
			if (yych == 'S') goto xx325;
			goto xx54;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto xx54;
		} else {
			if (yych == 's') goto xx325;
			if (yych <= 'z') goto xx54;
		}
	}
xx241:
#line 202 "./mql.re"
	{ MQL_TOKEN_RETURN("set", T_KEY_SET); }
#line 1854 "./mql_lexer.cpp"
xx242:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx327;
	if (yych == 'a') goto xx327;
	goto xx55;
xx243:
	yych = *++YYCURSOR;
	if (yych == 'G') goto xx328;
	if (yych == 'g') goto xx328;
	goto xx55;
xx244:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx329;
	if (yych == 'r') goto xx329;
	goto xx55;
xx245:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx330;
	if (yych == 'i') goto xx330;
	goto xx55;
xx246:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx331;
	if (yych == 's') goto xx331;
	goto xx55;
xx247:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx248;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx248;
			if (yych <= 'z') goto xx54;
		}
	}
xx248:
#line 194 "./mql.re"
	{ MQL_TOKEN_RETURN("sum", T_KEY_SUM); }
#line 1897 "./mql_lexer.cpp"
xx249:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx332;
	if (yych == 'n') goto xx332;
	goto xx55;
xx250:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx333;
	if (yych == 'e') goto xx333;
	goto xx55;
xx251:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'P') {
			if (yych == 'O') goto xx335;
			goto xx55;
		} else {
			if (yych <= 'Q') goto xx336;
			if (yych <= 'U') goto xx55;
			goto xx337;
		}
	} else {
		if (yych <= 'p') {
			if (yych == 'o') goto xx335;
			goto xx55;
		} else {
			if (yych <= 'q') goto xx336;
			if (yych == 'v') goto xx337;
			goto xx55;
		}
	}
xx252:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx338;
	if (yych == 'r') goto xx338;
	goto xx55;
xx253:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx339;
	if (yych == 'a') goto xx339;
	goto xx55;
xx254:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx255;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx255;
			if (yych <= 'z') goto xx54;
		}
	}
xx255:
#line 117 "./mql.re"
	{ MQL_TOKEN_RETURN("use", T_KEY_USE);  }
#line 1956 "./mql_lexer.cpp"
xx256:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx340;
	if (yych == 'n') goto xx340;
	goto xx55;
xx257:
	yych = *++YYCURSOR;
	if (yych == 'U') goto xx341;
	if (yych == 'u') goto xx341;
	goto xx55;
xx258:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx342;
	if (yych == 'r') goto xx342;
	goto xx55;
xx259:
	yych = *++YYCURSOR;
	if (yych == 'H') goto xx343;
	if (yych == 'h') goto xx343;
	goto xx55;
xx260:
	yych = *++YYCURSOR;
	if (yych <= '^') {
		if (yych <= '@') goto xx261;
		if (yych <= 'Z') goto xx168;
	} else {
		if (yych == '`') goto xx261;
		if (yych <= 'z') goto xx168;
	}
xx261:
	YYCURSOR = YYMARKER;
	goto xx170;
xx262:
	yych = *++YYCURSOR;
	if (yych <= '/') goto xx33;
	if (yych <= '9') goto xx345;
	goto xx33;
xx263:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx346;
	if (yych == 't') goto xx346;
	goto xx55;
xx264:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx348;
	if (yych == 'e') goto xx348;
	goto xx55;
xx265:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto xx349;
	if (yych == 'y') goto xx349;
	goto xx55;
xx266:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx350;
	if (yych == 'i') goto xx350;
	goto xx55;
xx267:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx352;
	if (yych == 'n') goto xx352;
	goto xx55;
xx268:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx354;
	if (yych == 'e') goto xx354;
	goto xx55;
xx269:
	yych = *++YYCURSOR;
	if (yych == 'U') goto xx355;
	if (yych == 'u') goto xx355;
	goto xx55;
xx270:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx356;
	if (yych == 'i') goto xx356;
	goto xx55;
xx271:
	yych = *++YYCURSOR;
	if (yych == 'U') goto xx357;
	if (yych == 'u') goto xx357;
	goto xx55;
xx272:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx358;
	if (yych == 't') goto xx358;
	goto xx55;
xx273:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx359;
	if (yych == 't') goto xx359;
	goto xx55;
xx274:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx361;
	if (yych == 't') goto xx361;
	goto xx55;
xx275:
	yych = *++YYCURSOR;
	if (yych == 'B') goto xx362;
	if (yych == 'b') goto xx362;
	goto xx55;
xx276:
	yych = *++YYCURSOR;
	if (yych == 'U') goto xx363;
	if (yych == 'u') goto xx363;
	goto xx55;
xx277:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx364;
	if (yych == 't') goto xx364;
	goto xx55;
xx278:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx365;
	if (yych == 'e') goto xx365;
	goto xx55;
xx279:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx280;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx280;
			if (yych <= 'z') goto xx54;
		}
	}
xx280:
#line 112 "./mql.re"
	{ MQL_TOKEN_RETURN("drop", T_KEY_DROP);  }
#line 2091 "./mql_lexer.cpp"
xx281:
	yych = *++YYCURSOR;
	if (yych == 'D') goto xx366;
	if (yych == 'd') goto xx366;
	goto xx55;
xx282:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '@') {
			if (yych <= '/') goto xx283;
			if (yych <= '9') goto xx54;
		} else {
			if (yych == 'E') goto xx367;
			goto xx54;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto xx54;
		} else {
			if (yych == 'e') goto xx367;
			if (yych <= 'z') goto xx54;
		}
	}
xx283:
#line 145 "./mql.re"
	{ MQL_TOKEN_RETURN("enum", T_KEY_ENUM);  }
#line 2118 "./mql_lexer.cpp"
xx284:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx368;
	if (yych == 't') goto xx368;
	goto xx55;
xx285:
	yych = *++YYCURSOR;
	if (yych == 'U') goto xx369;
	if (yych == 'u') goto xx369;
	goto xx55;
xx286:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx370;
	if (yych == 't') goto xx370;
	goto xx55;
xx287:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx288;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx288;
			if (yych <= 'z') goto xx54;
		}
	}
xx288:
#line 196 "./mql.re"
	{ MQL_TOKEN_RETURN("flat", T_KEY_FLAT); }
#line 2151 "./mql_lexer.cpp"
xx289:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx372;
	if (yych == 's') goto xx372;
	goto xx55;
xx290:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx291;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx291;
			if (yych <= 'z') goto xx54;
		}
	}
xx291:
#line 143 "./mql.re"
	{ MQL_TOKEN_RETURN("from", T_KEY_FROM);  }
#line 2174 "./mql_lexer.cpp"
xx292:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx293;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx293;
			if (yych <= 'z') goto xx54;
		}
	}
xx293:
#line 197 "./mql.re"
	{ MQL_TOKEN_RETURN("full", T_KEY_FULL); }
#line 2192 "./mql_lexer.cpp"
xx294:
	++YYCURSOR;
#line 182 "./mql.re"
	{ MQL_TOKEN_RETURN("gap?", T_KEY_OPT_GAP);  }
#line 2197 "./mql_lexer.cpp"
xx296:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx374;
	if (yych == 'n') goto xx374;
	goto xx55;
xx297:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '@') {
			if (yych <= '/') goto xx298;
			if (yych <= '9') goto xx54;
		} else {
			if (yych == 'S') goto xx375;
			goto xx54;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto xx54;
		} else {
			if (yych == 's') goto xx375;
			if (yych <= 'z') goto xx54;
		}
	}
xx298:
#line 137 "./mql.re"
	{ MQL_TOKEN_RETURN("id_d", T_KEY_ID_D);  }
#line 2224 "./mql_lexer.cpp"
xx299:
	yych = *++YYCURSOR;
	if (yych == 'X') goto xx377;
	if (yych == 'x') goto xx377;
	goto xx55;
xx300:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx379;
	if (yych == 'i') goto xx379;
	goto xx55;
xx301:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx380;
	if (yych == 'r') goto xx380;
	goto xx55;
xx302:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'G') goto xx381;
		if (yych <= 'Q') goto xx55;
		goto xx382;
	} else {
		if (yych <= 'g') {
			if (yych <= 'f') goto xx55;
			goto xx381;
		} else {
			if (yych == 'r') goto xx382;
			goto xx55;
		}
	}
xx303:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx304;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx304;
			if (yych <= 'z') goto xx54;
		}
	}
xx304:
#line 173 "./mql.re"
	{ MQL_TOKEN_RETURN("last", T_KEY_LAST);  }
#line 2272 "./mql_lexer.cpp"
xx305:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx306;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx306;
			if (yych <= 'z') goto xx54;
		}
	}
xx306:
#line 129 "./mql.re"
	{ MQL_TOKEN_RETURN("list", T_KEY_LIST); }
#line 2290 "./mql_lexer.cpp"
xx307:
	yych = *++YYCURSOR;
	if (yych == 'M') goto xx383;
	if (yych == 'm') goto xx383;
	goto xx55;
xx308:
	yych = *++YYCURSOR;
	if (yych == 'M') goto xx385;
	if (yych == 'm') goto xx385;
	goto xx55;
xx309:
	yych = *++YYCURSOR;
	if (yych == 'D') goto xx387;
	if (yych == 'd') goto xx387;
	goto xx55;
xx310:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx389;
	if (yych == 'i') goto xx389;
	goto xx55;
xx311:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx390;
	if (yych == 't') goto xx390;
	goto xx55;
xx312:
	yych = *++YYCURSOR;
	if (yych == 'X') goto xx391;
	if (yych == 'x') goto xx391;
	goto xx55;
xx313:
	yych = *++YYCURSOR;
	if (yych == 'C') goto xx392;
	if (yych == 'c') goto xx392;
	goto xx55;
xx314:
	yych = *++YYCURSOR;
	if (yych == 'L') goto xx393;
	if (yych == 'l') goto xx393;
	goto xx55;
xx315:
	yych = *++YYCURSOR;
	if (yych == '_') goto xx394;
	goto xx55;
xx316:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx317;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx317;
			if (yych <= 'z') goto xx54;
		}
	}
xx317:
#line 201 "./mql.re"
	{ MQL_TOKEN_RETURN("quit", T_KEY_QUIT); }
#line 2352 "./mql_lexer.cpp"
xx318:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx395;
	if (yych == 'e') goto xx395;
	goto xx55;
xx319:
	yych = *++YYCURSOR;
	if (yych == 'V') goto xx397;
	if (yych == 'v') goto xx397;
	goto xx55;
xx320:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx398;
	if (yych == 'a') goto xx398;
	goto xx55;
xx321:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx399;
	if (yych == 'i') goto xx399;
	goto xx55;
xx322:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx400;
	if (yych == 'r') goto xx400;
	goto xx55;
xx323:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx401;
	if (yych == 'e') goto xx401;
	goto xx55;
xx324:
	yych = *++YYCURSOR;
	if (yych == 'C') goto xx402;
	if (yych == 'c') goto xx402;
	goto xx55;
xx325:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx326;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx326;
			if (yych <= 'z') goto xx54;
		}
	}
xx326:
#line 203 "./mql.re"
	{ MQL_TOKEN_RETURN("sets", T_KEY_SETS); }
#line 2405 "./mql_lexer.cpp"
xx327:
	yych = *++YYCURSOR;
	if (yych == 'F') goto xx403;
	if (yych == 'f') goto xx403;
	goto xx55;
xx328:
	yych = *++YYCURSOR;
	if (yych == 'L') goto xx405;
	if (yych == 'l') goto xx405;
	goto xx55;
xx329:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx406;
	if (yych == 't') goto xx406;
	goto xx55;
xx330:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx407;
	if (yych == 'n') goto xx407;
	goto xx55;
xx331:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx408;
	if (yych == 't') goto xx408;
	goto xx55;
xx332:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx409;
	if (yych == 's') goto xx409;
	goto xx55;
xx333:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '@') {
			if (yych <= '/') goto xx334;
			if (yych <= '9') goto xx54;
		} else {
			if (yych == 'S') goto xx410;
			goto xx54;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto xx54;
		} else {
			if (yych == 's') goto xx410;
			if (yych <= 'z') goto xx54;
		}
	}
xx334:
#line 125 "./mql.re"
	{ MQL_TOKEN_RETURN("type", T_KEY_TYPE);  }
#line 2457 "./mql_lexer.cpp"
xx335:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx412;
	if (yych == 'n') goto xx412;
	goto xx55;
xx336:
	yych = *++YYCURSOR;
	if (yych == 'U') goto xx414;
	if (yych == 'u') goto xx414;
	goto xx55;
xx337:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx415;
	if (yych == 'e') goto xx415;
	goto xx55;
xx338:
	yych = *++YYCURSOR;
	if (yych == 'D') goto xx416;
	if (yych == 'd') goto xx416;
	goto xx55;
xx339:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx417;
	if (yych == 't') goto xx417;
	goto xx55;
xx340:
	yych = *++YYCURSOR;
	if (yych == 'G') goto xx418;
	if (yych == 'g') goto xx418;
	goto xx55;
xx341:
	yych = *++YYCURSOR;
	if (yych == 'U') goto xx420;
	if (yych == 'u') goto xx420;
	goto xx55;
xx342:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx421;
	if (yych == 'e') goto xx421;
	goto xx55;
xx343:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '@') {
			if (yych <= '/') goto xx344;
			if (yych <= '9') goto xx54;
		} else {
			if (yych == 'O') goto xx423;
			goto xx54;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto xx54;
		} else {
			if (yych == 'o') goto xx423;
			if (yych <= 'z') goto xx54;
		}
	}
xx344:
#line 167 "./mql.re"
	{ MQL_TOKEN_RETURN("with", T_KEY_WITH);  }
#line 2519 "./mql_lexer.cpp"
xx345:
	yych = *++YYCURSOR;
	if (yych <= '/') goto xx33;
	if (yych <= '9') goto xx424;
	goto xx33;
xx346:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx347;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx347;
			if (yych <= 'z') goto xx54;
		}
	}
xx347:
#line 123 "./mql.re"
	{ MQL_TOKEN_RETURN("abort", T_KEY_ABORT); }
#line 2542 "./mql_lexer.cpp"
xx348:
	yych = *++YYCURSOR;
	if (yych == 'G') goto xx425;
	if (yych == 'g') goto xx425;
	goto xx55;
xx349:
	yych = *++YYCURSOR;
	if (yych == 'Z') goto xx426;
	if (yych == 'z') goto xx426;
	goto xx55;
xx350:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx351;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx351;
			if (yych <= 'z') goto xx54;
		}
	}
xx351:
#line 136 "./mql.re"
	{ MQL_TOKEN_RETURN("ascii", T_KEY_ASCII); }
#line 2570 "./mql_lexer.cpp"
xx352:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx353;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx353;
			if (yych <= 'z') goto xx54;
		}
	}
xx353:
#line 121 "./mql.re"
	{ MQL_TOKEN_RETURN("begin", T_KEY_BEGIN); }
#line 2588 "./mql_lexer.cpp"
xx354:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx427;
	if (yych == 'e') goto xx427;
	goto xx55;
xx355:
	yych = *++YYCURSOR;
	if (yych == 'L') goto xx428;
	if (yych == 'l') goto xx428;
	goto xx55;
xx356:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx429;
	if (yych == 't') goto xx429;
	goto xx55;
xx357:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx431;
	if (yych == 't') goto xx431;
	goto xx55;
xx358:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx432;
	if (yych == 'a') goto xx432;
	goto xx55;
xx359:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx360;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx360;
			if (yych <= 'z') goto xx54;
		}
	}
xx360:
#line 195 "./mql.re"
	{ MQL_TOKEN_RETURN("count", T_KEY_COUNT); }
#line 2631 "./mql_lexer.cpp"
xx361:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx433;
	if (yych == 'e') goto xx433;
	goto xx55;
xx362:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx435;
	if (yych == 'a') goto xx435;
	goto xx55;
xx363:
	yych = *++YYCURSOR;
	if (yych == 'L') goto xx436;
	if (yych == 'l') goto xx436;
	goto xx55;
xx364:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx437;
	if (yych == 'e') goto xx437;
	goto xx55;
xx365:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx439;
	if (yych == 'r') goto xx439;
	goto xx55;
xx366:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx440;
	if (yych == 'i') goto xx440;
	goto xx55;
xx367:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx441;
	if (yych == 'r') goto xx441;
	goto xx55;
xx368:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx442;
	if (yych == 's') goto xx442;
	goto xx55;
xx369:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx444;
	if (yych == 'r') goto xx444;
	goto xx55;
xx370:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx371;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx371;
			if (yych <= 'z') goto xx54;
		}
	}
xx371:
#line 172 "./mql.re"
	{ MQL_TOKEN_RETURN("first", T_KEY_FIRST);  }
#line 2694 "./mql_lexer.cpp"
xx372:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx373;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx373;
			if (yych <= 'z') goto xx54;
		}
	}
xx373:
#line 153 "./mql.re"
	{ MQL_TOKEN_RETURN("focus", T_KEY_FOCUS);  }
#line 2712 "./mql_lexer.cpp"
xx374:
	yych = *++YYCURSOR;
	if (yych == 'G') goto xx445;
	if (yych == 'g') goto xx445;
	goto xx55;
xx375:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx376;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx376;
			if (yych <= 'z') goto xx54;
		}
	}
xx376:
#line 138 "./mql.re"
	{ MQL_TOKEN_RETURN("id_ds", T_KEY_ID_DS);  }
#line 2735 "./mql_lexer.cpp"
xx377:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '@') {
			if (yych <= '/') goto xx378;
			if (yych <= '9') goto xx54;
		} else {
			if (yych == 'E') goto xx447;
			goto xx54;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto xx54;
		} else {
			if (yych == 'e') goto xx447;
			if (yych <= 'z') goto xx54;
		}
	}
xx378:
#line 133 "./mql.re"
	{ MQL_TOKEN_RETURN("index", T_KEY_INDEX); }
#line 2757 "./mql_lexer.cpp"
xx379:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx448;
	if (yych == 'a') goto xx448;
	goto xx55;
xx380:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx449;
	if (yych == 't') goto xx449;
	goto xx55;
xx381:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx451;
	if (yych == 'e') goto xx451;
	goto xx55;
xx382:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx452;
	if (yych == 's') goto xx452;
	goto xx55;
xx383:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx384;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx384;
			if (yych <= 'z') goto xx54;
		}
	}
xx384:
#line 191 "./mql.re"
	{ MQL_TOKEN_RETURN("max_m", T_KEY_MAX_M); }
#line 2795 "./mql_lexer.cpp"
xx385:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx386;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx386;
			if (yych <= 'z') goto xx54;
		}
	}
xx386:
#line 190 "./mql.re"
	{ MQL_TOKEN_RETURN("min_m", T_KEY_MIN_M); }
#line 2813 "./mql_lexer.cpp"
xx387:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '@') {
			if (yych <= '/') goto xx388;
			if (yych <= '9') goto xx54;
		} else {
			if (yych == 'S') goto xx453;
			goto xx54;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto xx54;
		} else {
			if (yych == 's') goto xx453;
			if (yych <= 'z') goto xx54;
		}
	}
xx388:
#line 164 "./mql.re"
	{ MQL_TOKEN_RETURN("monad", T_KEY_MONAD);  }
#line 2835 "./mql_lexer.cpp"
xx389:
	yych = *++YYCURSOR;
	if (yych == 'P') goto xx455;
	if (yych == 'p') goto xx455;
	goto xx55;
xx390:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx456;
	if (yych == 'r') goto xx456;
	goto xx55;
xx391:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx457;
	if (yych == 'i') goto xx457;
	goto xx55;
xx392:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx458;
	if (yych == 't') goto xx458;
	goto xx55;
xx393:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx460;
	if (yych == 'a') goto xx460;
	goto xx55;
xx394:
	yych = *++YYCURSOR;
	if (yych == 'O') goto xx461;
	if (yych == 'o') goto xx461;
	goto xx55;
xx395:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx396;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx396;
			if (yych <= 'z') goto xx54;
		}
	}
xx396:
#line 150 "./mql.re"
	{ MQL_TOKEN_RETURN("range", T_KEY_RANGE);  }
#line 2883 "./mql_lexer.cpp"
xx397:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx462;
	if (yych == 'e') goto xx462;
	goto xx55;
xx398:
	yych = *++YYCURSOR;
	if (yych == 'C') goto xx464;
	if (yych == 'c') goto xx464;
	goto xx55;
xx399:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx465;
	if (yych == 'e') goto xx465;
	goto xx55;
xx400:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx466;
	if (yych == 'n') goto xx466;
	goto xx55;
xx401:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx467;
	if (yych == 'n') goto xx467;
	goto xx55;
xx402:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx468;
	if (yych == 't') goto xx468;
	goto xx55;
xx403:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx404;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx404;
			if (yych <= 'z') goto xx54;
		}
	}
xx404:
#line 199 "./mql.re"
	{ MQL_TOKEN_RETURN("sheaf", T_KEY_SHEAF); }
#line 2931 "./mql_lexer.cpp"
xx405:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx470;
	if (yych == 'e') goto xx470;
	goto xx55;
xx406:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx472;
	if (yych == 's') goto xx472;
	goto xx55;
xx407:
	yych = *++YYCURSOR;
	if (yych == 'G') goto xx473;
	if (yych == 'g') goto xx473;
	goto xx55;
xx408:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx475;
	if (yych == 'r') goto xx475;
	goto xx55;
xx409:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx476;
	if (yych == 'a') goto xx476;
	goto xx55;
xx410:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx411;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx411;
			if (yych <= 'z') goto xx54;
		}
	}
xx411:
#line 126 "./mql.re"
	{ MQL_TOKEN_RETURN("types", T_KEY_TYPES);  }
#line 2974 "./mql_lexer.cpp"
xx412:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx413;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx413;
			if (yych <= 'z') goto xx54;
		}
	}
xx413:
#line 204 "./mql.re"
	{ MQL_TOKEN_RETURN("union", T_KEY_UNION); }
#line 2992 "./mql_lexer.cpp"
xx414:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx477;
	if (yych == 'e') goto xx477;
	goto xx55;
xx415:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx479;
	if (yych == 'r') goto xx479;
	goto xx55;
xx416:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx480;
	if (yych == 'e') goto xx480;
	goto xx55;
xx417:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx481;
	if (yych == 'e') goto xx481;
	goto xx55;
xx418:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx419;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx419;
			if (yych <= 'z') goto xx54;
		}
	}
xx419:
#line 166 "./mql.re"
	{ MQL_TOKEN_RETURN("using", T_KEY_USING);  }
#line 3030 "./mql_lexer.cpp"
xx420:
	yych = *++YYCURSOR;
	if (yych == 'M') goto xx483;
	if (yych == 'm') goto xx483;
	goto xx55;
xx421:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx422;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx422;
			if (yych <= 'z') goto xx54;
		}
	}
xx422:
#line 156 "./mql.re"
	{ MQL_TOKEN_RETURN("where", T_KEY_WHERE);  }
#line 3053 "./mql_lexer.cpp"
xx423:
	yych = *++YYCURSOR;
	if (yych == 'U') goto xx485;
	if (yych == 'u') goto xx485;
	goto xx55;
xx424:
	yych = *++YYCURSOR;
	if (yych <= '/') goto xx33;
	if (yych <= '9') goto xx486;
	goto xx33;
xx425:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx487;
	if (yych == 'a') goto xx487;
	goto xx55;
xx426:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx488;
	if (yych == 'e') goto xx488;
	goto xx55;
xx427:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx490;
	if (yych == 'n') goto xx490;
	goto xx55;
xx428:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx492;
	if (yych == 'a') goto xx492;
	goto xx55;
xx429:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx430;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx430;
			if (yych <= 'z') goto xx54;
		}
	}
xx430:
#line 122 "./mql.re"
	{ MQL_TOKEN_RETURN("commit", T_KEY_COMMIT); }
#line 3101 "./mql_lexer.cpp"
xx431:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx493;
	if (yych == 'e') goto xx493;
	goto xx55;
xx432:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx494;
	if (yych == 'n') goto xx494;
	goto xx55;
xx433:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx434;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx434;
			if (yych <= 'z') goto xx54;
		}
	}
xx434:
#line 108 "./mql.re"
	{ MQL_TOKEN_RETURN("create", T_KEY_CREATE); }
#line 3129 "./mql_lexer.cpp"
xx435:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx495;
	if (yych == 's') goto xx495;
	goto xx55;
xx436:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx496;
	if (yych == 't') goto xx496;
	goto xx55;
xx437:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx438;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx438;
			if (yych <= 'z') goto xx54;
		}
	}
xx438:
#line 115 "./mql.re"
	{ MQL_TOKEN_RETURN("delete", T_KEY_DELETE);  }
#line 3157 "./mql_lexer.cpp"
xx439:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx498;
	if (yych == 'e') goto xx498;
	goto xx55;
xx440:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx499;
	if (yych == 'n') goto xx499;
	goto xx55;
xx441:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx500;
	if (yych == 'a') goto xx500;
	goto xx55;
xx442:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx443;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx443;
			if (yych <= 'z') goto xx54;
		}
	}
xx443:
#line 177 "./mql.re"
	{ MQL_TOKEN_RETURN("exists", T_KEY_EXISTS);  }
#line 3190 "./mql_lexer.cpp"
xx444:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx501;
	if (yych == 'e') goto xx501;
	goto xx55;
xx445:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx446;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx446;
			if (yych <= 'z') goto xx54;
		}
	}
xx446:
#line 157 "./mql.re"
	{ MQL_TOKEN_RETURN("having", T_KEY_HAVING); }
#line 3213 "./mql_lexer.cpp"
xx447:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx503;
	if (yych == 's') goto xx503;
	goto xx55;
xx448:
	yych = *++YYCURSOR;
	if (yych == 'L') goto xx505;
	if (yych == 'l') goto xx505;
	goto xx55;
xx449:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx450;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx450;
			if (yych <= 'z') goto xx54;
		}
	}
xx450:
#line 114 "./mql.re"
	{ MQL_TOKEN_RETURN("insert", T_KEY_INSERT);  }
#line 3241 "./mql_lexer.cpp"
xx451:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx506;
	if (yych == 'r') goto xx506;
	goto xx55;
xx452:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx508;
	if (yych == 'e') goto xx508;
	goto xx55;
xx453:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx454;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx454;
			if (yych <= 'z') goto xx54;
		}
	}
xx454:
#line 163 "./mql.re"
	{ MQL_TOKEN_RETURN("monads", T_KEY_MONADS);  }
#line 3269 "./mql_lexer.cpp"
xx455:
	yych = *++YYCURSOR;
	if (yych == 'L') goto xx509;
	if (yych == 'l') goto xx509;
	goto xx55;
xx456:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx510;
	if (yych == 'i') goto xx510;
	goto xx55;
xx457:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx511;
	if (yych == 's') goto xx511;
	goto xx55;
xx458:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '@') {
			if (yych <= '/') goto xx459;
			if (yych <= '9') goto xx54;
		} else {
			if (yych == 'S') goto xx512;
			goto xx54;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto xx54;
		} else {
			if (yych == 's') goto xx512;
			if (yych <= 'z') goto xx54;
		}
	}
xx459:
#line 127 "./mql.re"
	{ MQL_TOKEN_RETURN("object", T_KEY_OBJECT);  }
#line 3306 "./mql_lexer.cpp"
xx460:
	yych = *++YYCURSOR;
	if (yych == 'P') goto xx514;
	if (yych == 'p') goto xx514;
	goto xx55;
xx461:
	yych = *++YYCURSOR;
	if (yych == 'F') goto xx516;
	if (yych == 'f') goto xx516;
	goto xx55;
xx462:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx463;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx463;
			if (yych <= 'z') goto xx54;
		}
	}
xx463:
#line 142 "./mql.re"
	{ MQL_TOKEN_RETURN("remove", T_KEY_REMOVE);  }
#line 3334 "./mql_lexer.cpp"
xx464:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx518;
	if (yych == 'e') goto xx518;
	goto xx55;
xx465:
	yych = *++YYCURSOR;
	if (yych == 'V') goto xx520;
	if (yych == 'v') goto xx520;
	goto xx55;
xx466:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx521;
	if (yych == 'i') goto xx521;
	goto xx55;
xx467:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx522;
	if (yych == 't') goto xx522;
	goto xx55;
xx468:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx469;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx469;
			if (yych <= 'z') goto xx54;
		}
	}
xx469:
#line 111 "./mql.re"
	{ MQL_TOKEN_RETURN("select", T_KEY_SELECT);  }
#line 3372 "./mql_lexer.cpp"
xx470:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx471;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx471;
			if (yych <= 'z') goto xx54;
		}
	}
xx471:
#line 151 "./mql.re"
	{ MQL_TOKEN_RETURN("single", T_KEY_SINGLE); }
#line 3390 "./mql_lexer.cpp"
xx472:
	yych = *++YYCURSOR;
	if (yych == '_') goto xx524;
	goto xx55;
xx473:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx474;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx474;
			if (yych <= 'z') goto xx54;
		}
	}
xx474:
#line 135 "./mql.re"
	{ MQL_TOKEN_RETURN("string", T_KEY_STRING);  }
#line 3412 "./mql_lexer.cpp"
xx475:
	yych = *++YYCURSOR;
	if (yych == 'A') goto xx525;
	if (yych == 'a') goto xx525;
	goto xx55;
xx476:
	yych = *++YYCURSOR;
	if (yych == 'C') goto xx526;
	if (yych == 'c') goto xx526;
	goto xx55;
xx477:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx478;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx478;
			if (yych <= 'z') goto xx54;
		}
	}
xx478:
#line 165 "./mql.re"
	{ MQL_TOKEN_RETURN("unique", T_KEY_UNIQUE);  }
#line 3440 "./mql_lexer.cpp"
xx479:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx527;
	if (yych == 's') goto xx527;
	goto xx55;
xx480:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx528;
	if (yych == 'r') goto xx528;
	goto xx55;
xx481:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx482;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx482;
			if (yych <= 'z') goto xx54;
		}
	}
xx482:
#line 109 "./mql.re"
	{ MQL_TOKEN_RETURN("update", T_KEY_UPDATE); }
#line 3468 "./mql_lexer.cpp"
xx483:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx484;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx484;
			if (yych <= 'z') goto xx54;
		}
	}
xx484:
#line 119 "./mql.re"
	{ MQL_TOKEN_RETURN("vacuum", T_KEY_VACUUM); }
#line 3486 "./mql_lexer.cpp"
xx485:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx529;
	if (yych == 't') goto xx529;
	goto xx55;
xx486:
	yych = *++YYCURSOR;
	if (yych <= '/') goto xx33;
	if (yych <= '9') goto xx531;
	goto xx33;
xx487:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx532;
	if (yych == 't') goto xx532;
	goto xx55;
xx488:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx489;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx489;
			if (yych <= 'z') goto xx54;
		}
	}
xx489:
#line 120 "./mql.re"
	{ MQL_TOKEN_RETURN("analyze", T_KEY_ANALYZE); }
#line 3519 "./mql_lexer.cpp"
xx490:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx491;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx491;
			if (yych <= 'z') goto xx54;
		}
	}
xx491:
#line 184 "./mql.re"
	{ MQL_TOKEN_RETURN("between", T_KEY_BETWEEN); }
#line 3537 "./mql_lexer.cpp"
xx492:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx533;
	if (yych == 't') goto xx533;
	goto xx55;
xx493:
	yych = *++YYCURSOR;
	if (yych == 'D') goto xx534;
	if (yych == 'd') goto xx534;
	goto xx55;
xx494:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx536;
	if (yych == 't') goto xx536;
	goto xx55;
xx495:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx537;
	if (yych == 'e') goto xx537;
	goto xx55;
xx496:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx497;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx497;
			if (yych <= 'z') goto xx54;
		}
	}
xx497:
#line 139 "./mql.re"
	{ MQL_TOKEN_RETURN("default", T_KEY_DEFAULT);  }
#line 3575 "./mql_lexer.cpp"
xx498:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx539;
	if (yych == 'n') goto xx539;
	goto xx55;
xx499:
	yych = *++YYCURSOR;
	if (yych == 'G') goto xx540;
	if (yych == 'g') goto xx540;
	goto xx55;
xx500:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx542;
	if (yych == 't') goto xx542;
	goto xx55;
xx501:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '@') {
			if (yych <= '/') goto xx502;
			if (yych <= '9') goto xx54;
		} else {
			if (yych == 'S') goto xx543;
			goto xx54;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto xx54;
		} else {
			if (yych == 's') goto xx543;
			if (yych <= 'z') goto xx54;
		}
	}
xx502:
#line 158 "./mql.re"
	{ MQL_TOKEN_RETURN("feature", T_KEY_FEATURE);  }
#line 3612 "./mql_lexer.cpp"
xx503:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx504;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx504;
			if (yych <= 'z') goto xx54;
		}
	}
xx504:
#line 132 "./mql.re"
	{ MQL_TOKEN_RETURN("indexes", T_KEY_INDEXES); }
#line 3630 "./mql_lexer.cpp"
xx505:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx545;
	if (yych == 'i') goto xx545;
	goto xx55;
xx506:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx507;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx507;
			if (yych <= 'z') goto xx54;
		}
	}
xx507:
#line 134 "./mql.re"
	{ MQL_TOKEN_RETURN("integer", T_KEY_INTEGER);  }
#line 3653 "./mql_lexer.cpp"
xx508:
	yych = *++YYCURSOR;
	if (yych == 'C') goto xx546;
	if (yych == 'c') goto xx546;
	goto xx55;
xx509:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx547;
	if (yych == 'e') goto xx547;
	goto xx55;
xx510:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx549;
	if (yych == 'e') goto xx549;
	goto xx55;
xx511:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx550;
	if (yych == 't') goto xx550;
	goto xx55;
xx512:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx513;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx513;
			if (yych <= 'z') goto xx54;
		}
	}
xx513:
#line 128 "./mql.re"
	{ MQL_TOKEN_RETURN("objects", T_KEY_OBJECTS);  }
#line 3691 "./mql_lexer.cpp"
xx514:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx515;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx515;
			if (yych <= 'z') goto xx54;
		}
	}
xx515:
#line 205 "./mql.re"
	{ MQL_TOKEN_RETURN("overlap", T_KEY_OVERLAP); }
#line 3709 "./mql_lexer.cpp"
xx516:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx517;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx517;
			if (yych <= 'z') goto xx54;
		}
	}
xx517:
#line 206 "./mql.re"
	{ MQL_TOKEN_RETURN("part_of", T_KEY_PART_OF); }
#line 3727 "./mql_lexer.cpp"
xx518:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx519;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx519;
			if (yych <= 'z') goto xx54;
		}
	}
xx519:
#line 210 "./mql.re"
	{ MQL_TOKEN_RETURN("replace", T_KEY_REPLACE); }
#line 3745 "./mql_lexer.cpp"
xx520:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx552;
	if (yych == 'e') goto xx552;
	goto xx55;
xx521:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx554;
	if (yych == 'n') goto xx554;
	goto xx55;
xx522:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx523;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx523;
			if (yych <= 'z') goto xx54;
		}
	}
xx523:
#line 149 "./mql.re"
	{ MQL_TOKEN_RETURN("segment", T_KEY_SEGMENT);  }
#line 3773 "./mql_lexer.cpp"
xx524:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx555;
	if (yych == 'i') goto xx555;
	goto xx55;
xx525:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx556;
	if (yych == 't') goto xx556;
	goto xx55;
xx526:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx557;
	if (yych == 't') goto xx557;
	goto xx55;
xx527:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx558;
	if (yych == 'e') goto xx558;
	goto xx55;
xx528:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx560;
	if (yych == 'e') goto xx560;
	goto xx55;
xx529:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx530;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx530;
			if (yych <= 'z') goto xx54;
		}
	}
xx530:
#line 168 "./mql.re"
	{ MQL_TOKEN_RETURN("without", T_KEY_WITHOUT);  }
#line 3816 "./mql_lexer.cpp"
xx531:
	yych = *++YYCURSOR;
	if (yych <= '/') goto xx33;
	if (yych <= '9') goto xx561;
	goto xx33;
xx532:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx562;
	if (yych == 'e') goto xx562;
	goto xx55;
xx533:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx564;
	if (yych == 'i') goto xx564;
	goto xx55;
xx534:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx535;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx535;
			if (yych <= 'z') goto xx54;
		}
	}
xx535:
#line 140 "./mql.re"
	{ MQL_TOKEN_RETURN("computed", T_KEY_COMPUTED);  }
#line 3849 "./mql_lexer.cpp"
xx536:
	yych = *++YYCURSOR;
	if (yych == 'S') goto xx565;
	if (yych == 's') goto xx565;
	goto xx55;
xx537:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx538;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx538;
			if (yych <= 'z') goto xx54;
		}
	}
xx538:
#line 116 "./mql.re"
	{ MQL_TOKEN_RETURN("database", T_KEY_DATABASE);  }
#line 3872 "./mql_lexer.cpp"
xx539:
	yych = *++YYCURSOR;
	if (yych == 'C') goto xx567;
	if (yych == 'c') goto xx567;
	goto xx55;
xx540:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx541;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx541;
			if (yych <= 'z') goto xx54;
		}
	}
xx541:
#line 211 "./mql.re"
	{ MQL_TOKEN_RETURN("encoding", T_KEY_ENCODING); }
#line 3895 "./mql_lexer.cpp"
xx542:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx568;
	if (yych == 'i') goto xx568;
	goto xx55;
xx543:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx544;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx544;
			if (yych <= 'z') goto xx54;
		}
	}
xx544:
#line 159 "./mql.re"
	{ MQL_TOKEN_RETURN("features", T_KEY_FEATURES);  }
#line 3918 "./mql_lexer.cpp"
xx545:
	yych = *++YYCURSOR;
	if (yych == 'Z') goto xx569;
	if (yych == 'z') goto xx569;
	goto xx55;
xx546:
	yych = *++YYCURSOR;
	if (yych == 'T') goto xx570;
	if (yych == 't') goto xx570;
	goto xx55;
xx547:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx548;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx548;
			if (yych <= 'z') goto xx54;
		}
	}
xx548:
#line 152 "./mql.re"
	{ MQL_TOKEN_RETURN("multiple", T_KEY_MULTIPLE); }
#line 3946 "./mql_lexer.cpp"
xx549:
	yych = *++YYCURSOR;
	if (yych == 'V') goto xx572;
	if (yych == 'v') goto xx572;
	goto xx55;
xx550:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '@') {
			if (yych <= '/') goto xx551;
			if (yych <= '9') goto xx54;
		} else {
			if (yych == 'S') goto xx573;
			goto xx54;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto xx54;
		} else {
			if (yych == 's') goto xx573;
			if (yych <= 'z') goto xx54;
		}
	}
xx551:
#line 179 "./mql.re"
	{ MQL_TOKEN_RETURN("notexist", T_KEY_NOTEXIST);  }
#line 3973 "./mql_lexer.cpp"
xx552:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx553;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx553;
			if (yych <= 'z') goto xx54;
		}
	}
xx553:
#line 171 "./mql.re"
	{ MQL_TOKEN_RETURN("retrieve", T_KEY_RETRIEVE);  }
#line 3991 "./mql_lexer.cpp"
xx554:
	yych = *++YYCURSOR;
	if (yych == 'G') goto xx575;
	if (yych == 'g') goto xx575;
	goto xx55;
xx555:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx577;
	if (yych == 'n') goto xx577;
	goto xx55;
xx556:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx579;
	if (yych == 'e') goto xx579;
	goto xx55;
xx557:
	yych = *++YYCURSOR;
	if (yych == 'I') goto xx581;
	if (yych == 'i') goto xx581;
	goto xx55;
xx558:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx559;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx559;
			if (yych <= 'z') goto xx54;
		}
	}
xx559:
#line 161 "./mql.re"
	{ MQL_TOKEN_RETURN("universe", T_KEY_UNIVERSE);  }
#line 4029 "./mql_lexer.cpp"
xx560:
	yych = *++YYCURSOR;
	if (yych == 'D') goto xx582;
	if (yych == 'd') goto xx582;
	goto xx55;
xx561:
	yych = *++YYCURSOR;
	if (yych <= '/') goto xx33;
	if (yych <= '9') goto xx583;
	goto xx33;
xx562:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx563;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx563;
			if (yych <= 'z') goto xx54;
		}
	}
xx563:
#line 160 "./mql.re"
	{ MQL_TOKEN_RETURN("aggregate", T_KEY_AGGREGATE);  }
#line 4057 "./mql_lexer.cpp"
xx564:
	yych = *++YYCURSOR;
	if (yych == 'O') goto xx584;
	if (yych == 'o') goto xx584;
	goto xx55;
xx565:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx566;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx566;
			if (yych <= 'z') goto xx54;
		}
	}
xx566:
#line 148 "./mql.re"
	{ MQL_TOKEN_RETURN("constants", T_KEY_CONSTANTS);  }
#line 4080 "./mql_lexer.cpp"
xx567:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx585;
	if (yych == 'e') goto xx585;
	goto xx55;
xx568:
	yych = *++YYCURSOR;
	if (yych == 'O') goto xx587;
	if (yych == 'o') goto xx587;
	goto xx55;
xx569:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx588;
	if (yych == 'e') goto xx588;
	goto xx55;
xx570:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx571;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx571;
			if (yych <= 'z') goto xx54;
		}
	}
xx571:
#line 208 "./mql.re"
	{ MQL_TOKEN_RETURN("intersect", T_KEY_INTERSECT); }
#line 4113 "./mql_lexer.cpp"
xx572:
	yych = *++YYCURSOR;
	if (yych == 'E') goto xx590;
	if (yych == 'e') goto xx590;
	goto xx55;
xx573:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx574;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx574;
			if (yych <= 'z') goto xx54;
		}
	}
xx574:
#line 180 "./mql.re"
	{ MQL_TOKEN_RETURN("notexists", T_KEY_NOTEXISTS);  }
#line 4136 "./mql_lexer.cpp"
xx575:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx576;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx576;
			if (yych <= 'z') goto xx54;
		}
	}
xx576:
#line 188 "./mql.re"
	{ MQL_TOKEN_RETURN("returning", T_KEY_RETURNING); }
#line 4154 "./mql_lexer.cpp"
xx577:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx578;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx578;
			if (yych <= 'z') goto xx54;
		}
	}
xx578:
#line 207 "./mql.re"
	{ MQL_TOKEN_RETURN("starts_in", T_KEY_STARTS_IN); }
#line 4172 "./mql_lexer.cpp"
xx579:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx580;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx580;
			if (yych <= 'z') goto xx54;
		}
	}
xx580:
#line 162 "./mql.re"
	{ MQL_TOKEN_RETURN("substrate", T_KEY_SUBSTRATE);  }
#line 4190 "./mql_lexer.cpp"
xx581:
	yych = *++YYCURSOR;
	if (yych == 'O') goto xx592;
	if (yych == 'o') goto xx592;
	goto xx55;
xx582:
	yych = *++YYCURSOR;
	if (yych == 'G') goto xx593;
	if (yych == 'g') goto xx593;
	goto xx55;
xx583:
	++YYCURSOR;
	goto xx33;
xx584:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx594;
	if (yych == 'n') goto xx594;
	goto xx55;
xx585:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx586;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx586;
			if (yych <= 'z') goto xx54;
		}
	}
xx586:
#line 209 "./mql.re"
	{ MQL_TOKEN_RETURN("difference", T_KEY_DIFFERENCE); }
#line 4226 "./mql_lexer.cpp"
xx587:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx596;
	if (yych == 'n') goto xx596;
	goto xx55;
xx588:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx589;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx589;
			if (yych <= 'z') goto xx54;
		}
	}
xx589:
#line 118 "./mql.re"
	{ MQL_TOKEN_RETURN("initialize", T_KEY_INITIALIZE);  }
#line 4249 "./mql_lexer.cpp"
xx590:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx591;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx591;
			if (yych <= 'z') goto xx54;
		}
	}
xx591:
#line 170 "./mql.re"
	{ MQL_TOKEN_RETURN("noretrieve", T_KEY_NORETRIEVE);  }
#line 4267 "./mql_lexer.cpp"
xx592:
	yych = *++YYCURSOR;
	if (yych == 'N') goto xx598;
	if (yych == 'n') goto xx598;
	goto xx55;
xx593:
	yych = *++YYCURSOR;
	if (yych == 'R') goto xx600;
	if (yych == 'r') goto xx600;
	goto xx55;
xx594:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx595;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx595;
			if (yych <= 'z') goto xx54;
		}
	}
xx595:
#line 189 "./mql.re"
	{ MQL_TOKEN_RETURN("calculation", T_KEY_CALCULATION); }
#line 4295 "./mql_lexer.cpp"
xx596:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '@') {
			if (yych <= '/') goto xx597;
			if (yych <= '9') goto xx54;
		} else {
			if (yych == 'S') goto xx601;
			goto xx54;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto xx54;
		} else {
			if (yych == 's') goto xx601;
			if (yych <= 'z') goto xx54;
		}
	}
xx597:
#line 146 "./mql.re"
	{ MQL_TOKEN_RETURN("enumeration", T_KEY_ENUMERATION);  }
#line 4317 "./mql_lexer.cpp"
xx598:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx599;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx599;
			if (yych <= 'z') goto xx54;
		}
	}
xx599:
#line 124 "./mql.re"
	{ MQL_TOKEN_RETURN("transaction", T_KEY_TRANSACTION); }
#line 4335 "./mql_lexer.cpp"
xx600:
	yych = *++YYCURSOR;
	if (yych == 'O') goto xx603;
	if (yych == 'o') goto xx603;
	goto xx55;
xx601:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx602;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx602;
			if (yych <= 'z') goto xx54;
		}
	}
xx602:
#line 147 "./mql.re"
	{ MQL_TOKEN_RETURN("enumerations", T_KEY_ENUMERATIONS);  }
#line 4358 "./mql_lexer.cpp"
xx603:
	yych = *++YYCURSOR;
	if (yych == 'U') goto xx604;
	if (yych != 'u') goto xx55;
xx604:
	yych = *++YYCURSOR;
	if (yych == 'P') goto xx605;
	if (yych != 'p') goto xx55;
xx605:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto xx606;
		if (yych <= '9') goto xx54;
		if (yych >= 'A') goto xx54;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto xx54;
		} else {
			if (yych <= '`') goto xx606;
			if (yych <= 'z') goto xx54;
		}
	}
xx606:
#line 110 "./mql.re"
	{ MQL_TOKEN_RETURN("unorderedgroup", T_KEY_UNORDERED_GROUP); }
#line 4384 "./mql_lexer.cpp"
}
#line 258 "./mql.re"


stringdq:
	tok = cur;

#line 4392 "./mql_lexer.cpp"
{
	YYCTYPE yych;
	yych = *YYCURSOR;
	if (yych <= '!') {
		if (yych <= 0x00) goto xx609;
		if (yych == '\n') goto xx613;
		goto xx611;
	} else {
		if (yych <= '"') goto xx615;
		if (yych == '\\') goto xx617;
		goto xx611;
	}
xx609:
	++YYCURSOR;
#line 289 "./mql.re"
	{ if (cur >= lim) { goto end; } }
#line 4409 "./mql_lexer.cpp"
xx611:
	++YYCURSOR;
xx612:
#line 290 "./mql.re"
	{ yylval->pString->push_back(*tok);
			       goto stringdq; }
#line 4416 "./mql_lexer.cpp"
xx613:
	++YYCURSOR;
#line 292 "./mql.re"
	{ yylval->pString->push_back('\n');
			       goto stringdq; }
#line 4422 "./mql_lexer.cpp"
xx615:
	++YYCURSOR;
#line 263 "./mql.re"
	{ MQL_TOKEN_RETURN(STRING_MAGIC, T_STRING); }
#line 4427 "./mql_lexer.cpp"
xx617:
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'b') {
		if (yych <= '3') {
			if (yych <= '&') {
				if (yych != '"') goto xx612;
			} else {
				if (yych <= '\'') goto xx620;
				if (yych <= '/') goto xx612;
				goto xx622;
			}
		} else {
			if (yych <= '[') {
				if (yych == '?') goto xx624;
				goto xx612;
			} else {
				if (yych <= '\\') goto xx626;
				if (yych <= '`') goto xx612;
				if (yych <= 'a') goto xx628;
				goto xx630;
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'm') {
				if (yych == 'f') goto xx632;
				goto xx612;
			} else {
				if (yych <= 'n') goto xx634;
				if (yych <= 'q') goto xx612;
				goto xx636;
			}
		} else {
			if (yych <= 'u') {
				if (yych == 't') goto xx638;
				goto xx612;
			} else {
				if (yych <= 'v') goto xx640;
				if (yych == 'x') goto xx642;
				goto xx612;
			}
		}
	}
	++YYCURSOR;
#line 274 "./mql.re"
	{ yylval->pString->push_back('\"'); goto stringdq; }
#line 4474 "./mql_lexer.cpp"
xx620:
	++YYCURSOR;
#line 273 "./mql.re"
	{ yylval->pString->push_back('\''); goto stringdq; }
#line 4479 "./mql_lexer.cpp"
xx622:
	yych = *++YYCURSOR;
	if (yych <= '/') goto xx623;
	if (yych <= '7') goto xx643;
xx623:
	YYCURSOR = YYMARKER;
	goto xx612;
xx624:
	++YYCURSOR;
#line 272 "./mql.re"
	{ yylval->pString->push_back('\?'); goto stringdq; }
#line 4491 "./mql_lexer.cpp"
xx626:
	++YYCURSOR;
#line 271 "./mql.re"
	{ yylval->pString->push_back('\\'); goto stringdq; }
#line 4496 "./mql_lexer.cpp"
xx628:
	++YYCURSOR;
#line 268 "./mql.re"
	{ yylval->pString->push_back('\a'); goto stringdq; }
#line 4501 "./mql_lexer.cpp"
xx630:
	++YYCURSOR;
#line 267 "./mql.re"
	{ yylval->pString->push_back('\b'); goto stringdq; }
#line 4506 "./mql_lexer.cpp"
xx632:
	++YYCURSOR;
#line 270 "./mql.re"
	{ yylval->pString->push_back('\f'); goto stringdq; }
#line 4511 "./mql_lexer.cpp"
xx634:
	++YYCURSOR;
#line 264 "./mql.re"
	{ yylval->pString->push_back('\n'); goto stringdq; }
#line 4516 "./mql_lexer.cpp"
xx636:
	++YYCURSOR;
#line 269 "./mql.re"
	{ yylval->pString->push_back('\r'); goto stringdq; }
#line 4521 "./mql_lexer.cpp"
xx638:
	++YYCURSOR;
#line 265 "./mql.re"
	{ yylval->pString->push_back('\t'); goto stringdq; }
#line 4526 "./mql_lexer.cpp"
xx640:
	++YYCURSOR;
#line 266 "./mql.re"
	{ yylval->pString->push_back('\v'); goto stringdq; }
#line 4531 "./mql_lexer.cpp"
xx642:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto xx623;
		if (yych <= '9') goto xx644;
		goto xx623;
	} else {
		if (yych <= 'F') goto xx644;
		if (yych <= '`') goto xx623;
		if (yych <= 'f') goto xx644;
		goto xx623;
	}
xx643:
	yych = *++YYCURSOR;
	if (yych <= '/') goto xx623;
	if (yych <= '7') goto xx645;
	goto xx623;
xx644:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto xx623;
		if (yych <= '9') goto xx647;
		goto xx623;
	} else {
		if (yych <= 'F') goto xx647;
		if (yych <= '`') goto xx623;
		if (yych <= 'f') goto xx647;
		goto xx623;
	}
xx645:
	++YYCURSOR;
#line 275 "./mql.re"
	{ tok += 1; // Go past SLASH 
      		        char szOctal[4];
			const char *p = tok;
			char *q = &(szOctal[0]);
			*q++ = *p++;
			*q++ = *p++;
			*q++ = *p++;
			*q = '\0';
		        yylval->pString->push_back(octal2char(szOctal)); 
		        goto stringdq; }
#line 4574 "./mql_lexer.cpp"
xx647:
	++YYCURSOR;
#line 285 "./mql.re"
	{ 
			       	      yylval->pString->push_back(hex2char(tok[2], tok[3]));
			       	      goto stringdq; 			     
                             }
#line 4582 "./mql_lexer.cpp"
}
#line 294 "./mql.re"


stringsq:
	tok = cur;

#line 4590 "./mql_lexer.cpp"
{
	YYCTYPE yych;
	yych = *YYCURSOR;
	if (yych <= '\n') {
		if (yych <= 0x00) goto xx651;
		if (yych <= '\t') goto xx653;
		goto xx655;
	} else {
		if (yych == '\'') goto xx657;
		goto xx653;
	}
xx651:
	++YYCURSOR;
#line 300 "./mql.re"
	{ if (cur >= lim) { goto end; } }
#line 4606 "./mql_lexer.cpp"
xx653:
	++YYCURSOR;
#line 303 "./mql.re"
	{ yylval->pString->push_back(*tok);
			       goto stringsq; }
#line 4612 "./mql_lexer.cpp"
xx655:
	++YYCURSOR;
#line 301 "./mql.re"
	{ yylval->pString->push_back('\n');
			       goto stringsq; }
#line 4618 "./mql_lexer.cpp"
xx657:
	++YYCURSOR;
#line 299 "./mql.re"
	{ MQL_TOKEN_RETURN(STRING_MAGIC, T_STRING); }
#line 4623 "./mql_lexer.cpp"
}
#line 305 "./mql.re"

	
 end:
	return 0;
}


void MQLScanner::addToken(void)
{
	yylval->setString(new std::string);
	std::string::size_type length = cur - tok;
	yylval->pString->reserve(length);
	yylval->pString->append(tok, length);
/*
	const char *p;
	for (p = tok;
	     p != cur;
	     ++p) {
	     yylval->pString->push_back(*p);
	}
*/
}

void MQLScanner::addInteger(void)
{
	const size_t MAX_INTEGER_CHARS = 12;
	size_t cnt = cur - tok;
	if (cnt > MAX_INTEGER_CHARS) {
	   	std::string mystring;
		const char *p;
		for (p = tok;
		     p != cur;
	     	     ++p) {
		     mystring.push_back(*p);
		}
		yylval->setInteger(sz2longlong(mystring.c_str()));
        } else {
		char szInt[MAX_INTEGER_CHARS+1];

		const char *p;
		char *q = szInt;
		for (p = tok;
		     p != cur;
	     	     ++p) {
		     *q++ = *p;
		}
		*q = '\0';
		yylval->setInteger(sz2longlong(szInt));
	}
}

void MQLScanner::getString(std::string& str)
{
	std::string::size_type length = cur - tok;
	str.reserve(length);
	str.append(tok, length);
	/*
	const char *p;
	for (p = tok;
	     p != cur;
	     ++p) {
	     str.push_back(*p);
	}
*/

}

