/* Generated by re2c 2.0.3 on Tue Dec  8 12:13:25 2020 */
#line 1 "./mql_gq.re"
/*
 * mql_gq.cpp
 *
 * MQL "Get Query from stream" scanner
 *
 * Ulrik Petersen
 * Created: 6/23-2007
 * Last update: 11/30-2018
 *
 */

/*
 * Copyright (C) 2001-2018     Ulrik Sandborg-Petersen
 * Copyright (C) 2018-present  Sandborg-Petersen Holding ApS, Denmark
 *
 * Licensed under the MIT License.
 *
 * Please see the file COPYING in the root of the sources for more details.
 *
 */


/**@file mql_gq.re
 *@brief Implementation of MQLGQScanner (re-based) (MQL layer)
 */


#include <mql_gq.h>

#ifdef BSIZE
#undef BSIZE
#endif

#define BSIZE (1024*16)

#undef YYCTYPE
#undef YYCURSOR
#undef YYLIMIT
#undef YYMARKER


#define YYCTYPE         unsigned char
#define YYCURSOR        cursor
#define YYLIMIT         lim
#define YYMARKER        ptr
#define YYFILL(n)       {cursor = fill(cursor);}

#line 58 "./mql_gq.re"



MQLGQScanner::MQLGQScanner(std::istream *pIstr)
{
	pIn = pIstr;
	pBigstring = 0;
	bot = tok = ptr = cur = pos = lim = top = eof = 0;
	bufbase1 = new char[BSIZE*2];
	bufbase2 = new char[BSIZE*2];
	bCurIsBufbase1 = false;
}

MQLGQScanner::~MQLGQScanner()
{
	delete pBigstring;
	delete [] bufbase1;
	delete [] bufbase2;
}

void MQLGQScanner::addToken(void)
{
        /* Don't add "+ 1" because cur points 
           one beyond the end of the token. */
	pBigstring->addChars((const char*) tok, cur - tok);
/*
	char *p;
	for (p = tok;
	     p != cur;
	     ++p) {
		pBigstring->addChar(*p);
	}
*/
}

char *MQLGQScanner::fill(char *cursor)
{
        if(!eof)
        {
                std::streamsize cnt = tok - bot;
	        if(cnt)
                {
                        memcpy(bot, tok, lim - tok);
                        tok = bot;
                        ptr -= cnt;
                        cursor -= cnt;
                        pos -= cnt;
                        lim -= cnt;
                }
                if((top - lim) < BSIZE)
                {
                        char *buf = (bCurIsBufbase1) ? (bufbase2) : (bufbase1);
			bCurIsBufbase1 = !bCurIsBufbase1;

			if (tok != 0) {
                           	memcpy(buf, tok, lim - tok);
                        }
                        tok = buf;
                        ptr = &buf[ptr - bot];
                        cursor = &buf[cursor - bot];
                        pos = &buf[pos - bot];
                        lim = &buf[lim - bot];
                        top = &lim[BSIZE];
                        bot = buf;
                }
                pIn->read(lim, BSIZE);
                if ((cnt = pIn->gcount()) != BSIZE )
                {
                        eof = &lim[cnt]; *eof++ = '\0';
                }
                lim += cnt;
        }
        return cursor;
}


Bigstring *MQLGQScanner::scan(void)
{
	pBigstring = new Bigstring();
	char *cursor = cur;

 scan:	
	tok = cursor;


#line 137 "./mql_get_query.cpp"
{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'G') {
		if (yych <= '&') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy2;
				if (yych <= '\t') goto yy4;
				goto yy6;
			} else {
				if (yych == '"') goto yy8;
				goto yy4;
			}
		} else {
			if (yych <= '/') {
				if (yych <= '\'') goto yy10;
				if (yych <= '.') goto yy4;
				goto yy12;
			} else {
				if (yych <= '@') goto yy4;
				if (yych <= 'F') goto yy13;
				goto yy16;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych == 'Q') goto yy17;
				goto yy13;
			} else {
				if (yych == '_') goto yy13;
				goto yy4;
			}
		} else {
			if (yych <= 'p') {
				if (yych == 'g') goto yy16;
				goto yy13;
			} else {
				if (yych <= 'q') goto yy17;
				if (yych <= 'z') goto yy13;
				goto yy4;
			}
		}
	}
yy2:
	++YYCURSOR;
#line 156 "./mql_gq.re"
	{ if (cursor == eof) { cur = cursor; goto end; } }
#line 187 "./mql_get_query.cpp"
yy4:
	++YYCURSOR;
yy5:
#line 158 "./mql_gq.re"
	{ pBigstring->addChar(*tok); goto scan; }
#line 193 "./mql_get_query.cpp"
yy6:
	++YYCURSOR;
#line 157 "./mql_gq.re"
	{ pBigstring->addChar('\n'); goto scan; }
#line 198 "./mql_get_query.cpp"
yy8:
	++YYCURSOR;
#line 148 "./mql_gq.re"
	{ pBigstring->addChar('\"');
	    cur = cursor;
	    goto stringdq;
          }
#line 206 "./mql_get_query.cpp"
yy10:
	++YYCURSOR;
#line 152 "./mql_gq.re"
	{ pBigstring->addChar('\'');
	    cur = cursor;
	    goto stringsq;
          }
#line 214 "./mql_get_query.cpp"
yy12:
	yych = *++YYCURSOR;
	if (yych == '*') goto yy18;
	if (yych == '/') goto yy20;
	goto yy5;
yy13:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy14:
	if (yych <= 'Z') {
		if (yych <= '/') goto yy15;
		if (yych <= '9') goto yy13;
		if (yych >= 'A') goto yy13;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto yy13;
		} else {
			if (yych <= '`') goto yy15;
			if (yych <= 'z') goto yy13;
		}
	}
yy15:
#line 145 "./mql_gq.re"
	{ cur = cursor; addToken(); goto scan; }
#line 240 "./mql_get_query.cpp"
yy16:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy22;
	if (yych == 'o') goto yy22;
	goto yy14;
yy17:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy24;
	if (yych == 'u') goto yy24;
	goto yy14;
yy18:
	++YYCURSOR;
#line 146 "./mql_gq.re"
	{ goto comment; }
#line 255 "./mql_get_query.cpp"
yy20:
	++YYCURSOR;
#line 147 "./mql_gq.re"
	{ goto cppcomment; }
#line 260 "./mql_get_query.cpp"
yy22:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy23;
		if (yych <= '9') goto yy13;
		if (yych >= 'A') goto yy13;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto yy13;
		} else {
			if (yych <= '`') goto yy23;
			if (yych <= 'z') goto yy13;
		}
	}
yy23:
#line 144 "./mql_gq.re"
	{ cur = cursor; /* addToken(); */ tok = cur; goto end; }
#line 278 "./mql_get_query.cpp"
yy24:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy25;
	if (yych != 'i') goto yy14;
yy25:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy26;
	if (yych != 't') goto yy14;
yy26:
	yych = *++YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy27;
		if (yych <= '9') goto yy13;
		if (yych >= 'A') goto yy13;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto yy13;
		} else {
			if (yych <= '`') goto yy27;
			if (yych <= 'z') goto yy13;
		}
	}
yy27:
#line 143 "./mql_gq.re"
	{ cur = cursor; addToken(); pBigstring->addChars(" GO", 3); tok = cur; goto end; }
#line 304 "./mql_get_query.cpp"
}
#line 159 "./mql_gq.re"


 comment:
        tok = cursor;

#line 312 "./mql_get_query.cpp"
{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= '\n') {
		if (yych <= 0x00) goto yy30;
		if (yych <= '\t') goto yy32;
		goto yy34;
	} else {
		if (yych == '*') goto yy36;
		goto yy32;
	}
yy30:
	++YYCURSOR;
#line 166 "./mql_gq.re"
	{ if (cursor == eof) { goto end; } }
#line 329 "./mql_get_query.cpp"
yy32:
	++YYCURSOR;
yy33:
#line 167 "./mql_gq.re"
	{ tok = cur; goto comment; }
#line 335 "./mql_get_query.cpp"
yy34:
	++YYCURSOR;
#line 165 "./mql_gq.re"
	{ pBigstring->addChar('\n'); goto comment; }
#line 340 "./mql_get_query.cpp"
yy36:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy33;
	++YYCURSOR;
#line 164 "./mql_gq.re"
	{  goto scan; }
#line 347 "./mql_get_query.cpp"
}
#line 168 "./mql_gq.re"


 cppcomment:
        tok = cursor;

#line 355 "./mql_get_query.cpp"
{
	YYCTYPE yych;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= 0x00) goto yy41;
	if (yych == '\n') goto yy45;
	goto yy43;
yy41:
	++YYCURSOR;
#line 174 "./mql_gq.re"
	{ if (cursor == eof) { goto end; } }
#line 367 "./mql_get_query.cpp"
yy43:
	++YYCURSOR;
#line 175 "./mql_gq.re"
	{ tok = cur; goto cppcomment; }
#line 372 "./mql_get_query.cpp"
yy45:
	++YYCURSOR;
#line 173 "./mql_gq.re"
	{ pBigstring->addChar('\n'); goto scan; }
#line 377 "./mql_get_query.cpp"
}
#line 176 "./mql_gq.re"


stringdq:
	tok = cursor;

#line 385 "./mql_get_query.cpp"
{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	if (yych <= '!') {
		if (yych <= 0x00) goto yy49;
		if (yych == '\n') goto yy53;
		goto yy51;
	} else {
		if (yych <= '"') goto yy55;
		if (yych == '\\') goto yy57;
		goto yy51;
	}
yy49:
	++YYCURSOR;
#line 198 "./mql_gq.re"
	{ if (cursor == eof) { goto end; } }
#line 403 "./mql_get_query.cpp"
yy51:
	++YYCURSOR;
yy52:
#line 199 "./mql_gq.re"
	{ pBigstring->addChar(*tok); cur = cursor; goto stringdq; }
#line 409 "./mql_get_query.cpp"
yy53:
	++YYCURSOR;
#line 197 "./mql_gq.re"
	{ pBigstring->addChar('\n'); cur = cursor; goto stringdq; }
#line 414 "./mql_get_query.cpp"
yy55:
	++YYCURSOR;
#line 181 "./mql_gq.re"
	{ pBigstring->addChar(*tok);
  	        cur = cursor;
	        goto scan;
              }
#line 422 "./mql_get_query.cpp"
yy57:
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'b') {
		if (yych <= '3') {
			if (yych <= '&') {
				if (yych != '"') goto yy52;
			} else {
				if (yych <= '\'') goto yy58;
				if (yych <= '/') goto yy52;
				goto yy60;
			}
		} else {
			if (yych <= '[') {
				if (yych != '?') goto yy52;
			} else {
				if (yych <= '\\') goto yy58;
				if (yych <= '`') goto yy52;
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'm') {
				if (yych != 'f') goto yy52;
			} else {
				if (yych <= 'n') goto yy58;
				if (yych <= 'q') goto yy52;
			}
		} else {
			if (yych <= 'u') {
				if (yych != 't') goto yy52;
			} else {
				if (yych <= 'v') goto yy58;
				if (yych == 'x') goto yy62;
				goto yy52;
			}
		}
	}
yy58:
	++YYCURSOR;
#line 185 "./mql_gq.re"
	{ cur = cursor; 
		        pBigstring->addChars(tok, 2);
		      goto stringdq;
                    }
#line 467 "./mql_get_query.cpp"
yy60:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '7') goto yy63;
yy61:
	YYCURSOR = YYMARKER;
	goto yy52;
yy62:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy64;
		goto yy61;
	} else {
		if (yych <= 'F') goto yy64;
		if (yych <= '`') goto yy61;
		if (yych <= 'f') goto yy64;
		goto yy61;
	}
yy63:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '7') goto yy65;
	goto yy61;
yy64:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy67;
		goto yy61;
	} else {
		if (yych <= 'F') goto yy67;
		if (yych <= '`') goto yy61;
		if (yych <= 'f') goto yy67;
		goto yy61;
	}
yy65:
	++YYCURSOR;
#line 189 "./mql_gq.re"
	{ cur = cursor; 
		      pBigstring->addChars(tok, 4);
		    goto stringdq; 
                  }
#line 511 "./mql_get_query.cpp"
yy67:
	++YYCURSOR;
#line 193 "./mql_gq.re"
	{ cur = cursor;
		      		   pBigstring->addChars(tok, 4);
			       goto stringdq;
                             }
#line 519 "./mql_get_query.cpp"
}
#line 200 "./mql_gq.re"


stringsq:
	tok = cursor;

#line 527 "./mql_get_query.cpp"
{
	YYCTYPE yych;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\n') {
		if (yych <= 0x00) goto yy71;
		if (yych <= '\t') goto yy73;
		goto yy75;
	} else {
		if (yych == '\'') goto yy77;
		goto yy73;
	}
yy71:
	++YYCURSOR;
#line 210 "./mql_gq.re"
	{ if (cursor == eof) { goto end; } }
#line 544 "./mql_get_query.cpp"
yy73:
	++YYCURSOR;
#line 211 "./mql_gq.re"
	{ pBigstring->addChar(*tok); cur = cursor; goto stringsq; }
#line 549 "./mql_get_query.cpp"
yy75:
	++YYCURSOR;
#line 209 "./mql_gq.re"
	{ pBigstring->addChar('\n'); cur = cursor; goto stringsq; }
#line 554 "./mql_get_query.cpp"
yy77:
	++YYCURSOR;
#line 205 "./mql_gq.re"
	{ pBigstring->addChar('\'');
  	        cur = cursor;
	        goto scan;
              }
#line 562 "./mql_get_query.cpp"
}
#line 212 "./mql_gq.re"



	
 end:
        Bigstring *result = pBigstring;
        pBigstring = 0;
	return result;
}



/*
int main(int argc, char *argv[])
{
      MQLGQScanner sc(&std::cin);
      while (!sc.noMoreInput()) {
           Bigstring *pBigstring = sc.scan();
           std::string result;
           pBigstring->toString(result);
           std::cerr << "UP200: '" << result << "'" << std::endl;
           delete pBigstring;
      }
}

*/
