/* Generated by re2c 2.0.3 on Tue Dec  8 12:13:24 2020 */
#line 1 "./json.re"
/*
 * json.re
 *
 * JSON Lexer based on re2c
 *
 * Ulrik Sandborg-Petersen
 * Created: 7/28-2008
 * Last update: 11/30-2018
 *
 */

/*
 * Copyright (C) 2001-2018     Ulrik Sandborg-Petersen
 * Copyright (C) 2018-present  Sandborg-Petersen Holding ApS, Denmark
 *
 * Licensed under the MIT License.
 *
 * Please see the file COPYING in the root of the sources for more details.
 *
 */

#include <json_lexer.h>
#include "jsonpars.h"
#include <iostream>
#include <string_func.h>

#define YYCTYPE         unsigned char
#define YYCURSOR        cur
#define YYLIMIT         lim
#define YYMARKER        ptr
#line 34 "./json.re"



#line 69 "./json.re"



JSONScanner::JSONScanner(const std::string& strIn)
{
	m_szIn = strIn;
	sz = m_szIn.c_str();
	lim = sz + strIn.length();
	bot = tok = ptr = pos = top = eof = 0;
	cur = sz;
	m_pOpenBrace = newToken();
	m_pCloseBrace = newToken();
	m_pOpenBracket = newToken();
	m_pCloseBracket = newToken();
	m_pTrue = newToken();
	m_pFalse = newToken();
	m_pNull = newToken();
	m_pComma = newToken();
	m_pColon = newToken();
	m_pOpenBrace->setName("{");
	m_pCloseBrace->setName("}");
	m_pOpenBracket->setName("[");
	m_pCloseBracket->setName("]");
	m_pTrue->setName("true");
	m_pFalse->setName("false");
	m_pNull->setName("null");
	m_pComma->setName(",");
	m_pColon->setName(":");
}

JSONScanner::~JSONScanner()
{
	if (bot) {
		delete[] bot;
	}
	delete(m_pOpenBrace);
	delete(m_pCloseBrace);
	delete(m_pOpenBracket);
	delete(m_pCloseBracket);
	delete(m_pTrue);
	delete(m_pFalse);
	delete(m_pNull);
	delete(m_pComma);
	delete(m_pColon);

}
bool JSONScanner::isLocallyAllocatedToken(Token *pToken)
{
	return pToken == m_pOpenBrace
	|| pToken == m_pCloseBrace
	|| pToken == m_pOpenBracket
	|| pToken == m_pCloseBracket
	|| pToken == m_pTrue
	|| pToken == m_pFalse
	|| pToken == m_pNull
	|| pToken == m_pComma
	|| pToken == m_pColon;
}


#define TOKEN_RETURN(X,Y) { (*yylval)->setName(X); return Y; }
#define LOCAL_TOKEN_RETURN(L,Y) { *yylval = L; return Y; }
#define NEW_TOKEN() { (*yylval) = newToken(); }
#define NEW_TOKEN_RETURN(X,Y) { NEW_TOKEN() TOKEN_RETURN(X,Y) }



int JSONScanner::scan(Token **ppYYLVAL)
{
	yylval = ppYYLVAL;

 scan:	
	tok = cur;


#line 114 "./json_lexer.cpp"
{
	YYCTYPE yych;
	yych = *YYCURSOR;
	if (yych <= 'F') {
		if (yych <= '!') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto jj2;
				if (yych <= 0x08) goto jj4;
				if (yych <= '\t') goto jj6;
				goto jj8;
			} else {
				if (yych <= '\r') {
					if (yych <= '\f') goto jj4;
					goto jj10;
				} else {
					if (yych == ' ') goto jj12;
					goto jj4;
				}
			}
		} else {
			if (yych <= '-') {
				if (yych <= '"') goto jj14;
				if (yych <= '+') goto jj4;
				if (yych <= ',') goto jj16;
				goto jj18;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto jj4;
					goto jj19;
				} else {
					if (yych <= ':') goto jj21;
					if (yych <= 'E') goto jj4;
					goto jj23;
				}
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'T') {
				if (yych == 'N') goto jj24;
				if (yych <= 'S') goto jj4;
				goto jj25;
			} else {
				if (yych <= '[') {
					if (yych <= 'Z') goto jj4;
					goto jj26;
				} else {
					if (yych == ']') goto jj28;
					goto jj4;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') {
					if (yych <= 'f') goto jj23;
					goto jj4;
				} else {
					if (yych <= 'n') goto jj24;
					if (yych <= 's') goto jj4;
					goto jj25;
				}
			} else {
				if (yych <= '{') {
					if (yych <= 'z') goto jj4;
					goto jj30;
				} else {
					if (yych == '}') goto jj32;
					goto jj4;
				}
			}
		}
	}
jj2:
	++YYCURSOR;
#line 166 "./json.re"
	{ if (cur >= lim) { goto end; } }
#line 191 "./json_lexer.cpp"
jj4:
	++YYCURSOR;
jj5:
#line 167 "./json.re"
	{ goto end; /* anything else is an error, so return EOF. */ }
#line 197 "./json_lexer.cpp"
jj6:
	++YYCURSOR;
#line 163 "./json.re"
	{ goto scan; }
#line 202 "./json_lexer.cpp"
jj8:
	++YYCURSOR;
#line 165 "./json.re"
	{ goto scan; }
#line 207 "./json_lexer.cpp"
jj10:
	++YYCURSOR;
#line 164 "./json.re"
	{ goto scan; }
#line 212 "./json_lexer.cpp"
jj12:
	++YYCURSOR;
#line 162 "./json.re"
	{ goto scan; }
#line 217 "./json_lexer.cpp"
jj14:
	++YYCURSOR;
#line 156 "./json.re"
	{ 
                              NEW_TOKEN(); 
                              (*yylval)->setString(new std::string);
			      (*yylval)->pString->reserve(32);
			      goto stringdq; 
                            }
#line 227 "./json_lexer.cpp"
jj16:
	++YYCURSOR;
#line 152 "./json.re"
	{ LOCAL_TOKEN_RETURN(m_pComma, T_JSON_KEY_COMMA); }
#line 232 "./json_lexer.cpp"
jj18:
	yych = *++YYCURSOR;
	if (yych <= '/') goto jj5;
	if (yych >= ':') goto jj5;
jj19:
	yych = *++YYCURSOR;
	if (yych <= '/') goto jj20;
	if (yych <= '9') goto jj34;
jj20:
#line 153 "./json.re"
	{ NEW_TOKEN(); 
                                  addInteger();
                                  TOKEN_RETURN(INTEGER_MAGIC, T_JSON_INTEGER); }
#line 246 "./json_lexer.cpp"
jj21:
	++YYCURSOR;
#line 151 "./json.re"
	{ LOCAL_TOKEN_RETURN(m_pColon, T_JSON_KEY_COLON);  }
#line 251 "./json_lexer.cpp"
jj23:
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'A') goto jj35;
	if (yych == 'a') goto jj35;
	goto jj5;
jj24:
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto jj37;
	if (yych == 'u') goto jj37;
	goto jj5;
jj25:
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto jj38;
	if (yych == 'r') goto jj38;
	goto jj5;
jj26:
	++YYCURSOR;
#line 149 "./json.re"
	{ LOCAL_TOKEN_RETURN(m_pOpenBracket, T_JSON_KEY_BRACKET_OPEN); }
#line 271 "./json_lexer.cpp"
jj28:
	++YYCURSOR;
#line 150 "./json.re"
	{ LOCAL_TOKEN_RETURN(m_pCloseBracket, T_JSON_KEY_BRACKET_CLOSE); }
#line 276 "./json_lexer.cpp"
jj30:
	++YYCURSOR;
#line 147 "./json.re"
	{ LOCAL_TOKEN_RETURN(m_pOpenBrace, T_JSON_KEY_BRACE_OPEN); }
#line 281 "./json_lexer.cpp"
jj32:
	++YYCURSOR;
#line 148 "./json.re"
	{ LOCAL_TOKEN_RETURN(m_pCloseBrace,T_JSON_KEY_BRACE_CLOSE); }
#line 286 "./json_lexer.cpp"
jj34:
	yych = *++YYCURSOR;
	if (yych <= '/') goto jj20;
	if (yych <= '9') goto jj39;
	goto jj20;
jj35:
	yych = *++YYCURSOR;
	if (yych == 'L') goto jj40;
	if (yych == 'l') goto jj40;
jj36:
	YYCURSOR = YYMARKER;
	goto jj5;
jj37:
	yych = *++YYCURSOR;
	if (yych == 'L') goto jj41;
	if (yych == 'l') goto jj41;
	goto jj36;
jj38:
	yych = *++YYCURSOR;
	if (yych == 'U') goto jj42;
	if (yych == 'u') goto jj42;
	goto jj36;
jj39:
	yych = *++YYCURSOR;
	if (yych <= '/') goto jj20;
	if (yych <= '9') goto jj43;
	goto jj20;
jj40:
	yych = *++YYCURSOR;
	if (yych == 'S') goto jj44;
	if (yych == 's') goto jj44;
	goto jj36;
jj41:
	yych = *++YYCURSOR;
	if (yych == 'L') goto jj45;
	if (yych == 'l') goto jj45;
	goto jj36;
jj42:
	yych = *++YYCURSOR;
	if (yych == 'E') goto jj47;
	if (yych == 'e') goto jj47;
	goto jj36;
jj43:
	yych = *++YYCURSOR;
	if (yych <= '/') goto jj20;
	if (yych <= '9') goto jj49;
	goto jj20;
jj44:
	yych = *++YYCURSOR;
	if (yych == 'E') goto jj50;
	if (yych == 'e') goto jj50;
	goto jj36;
jj45:
	++YYCURSOR;
#line 146 "./json.re"
	{ LOCAL_TOKEN_RETURN(m_pNull, T_JSON_KEY_NULL); }
#line 343 "./json_lexer.cpp"
jj47:
	++YYCURSOR;
#line 145 "./json.re"
	{ LOCAL_TOKEN_RETURN(m_pTrue, T_JSON_KEY_TRUE); }
#line 348 "./json_lexer.cpp"
jj49:
	yych = *++YYCURSOR;
	if (yych <= '/') goto jj20;
	if (yych <= '9') goto jj52;
	goto jj20;
jj50:
	++YYCURSOR;
#line 144 "./json.re"
	{ LOCAL_TOKEN_RETURN(m_pFalse, T_JSON_KEY_FALSE); }
#line 358 "./json_lexer.cpp"
jj52:
	yych = *++YYCURSOR;
	if (yych <= '/') goto jj20;
	if (yych >= ':') goto jj20;
	yych = *++YYCURSOR;
	if (yych <= '/') goto jj20;
	if (yych >= ':') goto jj20;
	yych = *++YYCURSOR;
	if (yych <= '/') goto jj20;
	if (yych >= ':') goto jj20;
	yych = *++YYCURSOR;
	if (yych <= '/') goto jj20;
	if (yych >= ':') goto jj20;
	++YYCURSOR;
	goto jj20;
}
#line 168 "./json.re"


stringdq:
	tok = cur;

#line 381 "./json_lexer.cpp"
{
	YYCTYPE yych;
	yych = *YYCURSOR;
	if (yych <= '!') {
		if (yych <= 0x00) goto jj59;
		if (yych == '\n') goto jj63;
		goto jj61;
	} else {
		if (yych <= '"') goto jj65;
		if (yych == '\\') goto jj67;
		goto jj61;
	}
jj59:
	++YYCURSOR;
#line 203 "./json.re"
	{ if (cur >= lim) { goto end; } /* We might encounter a string which does not end before EOF. */ }
#line 398 "./json_lexer.cpp"
jj61:
	++YYCURSOR;
jj62:
#line 204 "./json.re"
	{ (*yylval)->pString->push_back(*tok);
			       goto stringdq; }
#line 405 "./json_lexer.cpp"
jj63:
	++YYCURSOR;
#line 206 "./json.re"
	{ (*yylval)->pString->push_back('\n');
			       goto stringdq; }
#line 411 "./json_lexer.cpp"
jj65:
	++YYCURSOR;
#line 173 "./json.re"
	{ TOKEN_RETURN(STRING_MAGIC, T_JSON_STRING); }
#line 416 "./json_lexer.cpp"
jj67:
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'b') {
		if (yych <= '&') {
			if (yych <= '\f') {
				if (yych != '\n') goto jj62;
			} else {
				if (yych <= '\r') goto jj70;
				if (yych == '"') goto jj72;
				goto jj62;
			}
		} else {
			if (yych <= '?') {
				if (yych <= '\'') goto jj74;
				if (yych <= '>') goto jj62;
				goto jj76;
			} else {
				if (yych == '\\') goto jj78;
				if (yych <= 'a') goto jj62;
				goto jj80;
			}
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'm') {
				if (yych == 'f') goto jj82;
				goto jj62;
			} else {
				if (yych <= 'n') goto jj84;
				if (yych == 'r') goto jj86;
				goto jj62;
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') goto jj88;
				if (yych <= 'u') goto jj90;
				goto jj62;
			} else {
				if (yych <= 'x') goto jj92;
				if (yych == 0xE2) goto jj93;
				goto jj62;
			}
		}
	}
	++YYCURSOR;
#line 183 "./json.re"
	{ /* eaten; it is a LineContinuation */ goto stringdq; }
#line 464 "./json_lexer.cpp"
jj70:
	yych = *++YYCURSOR;
	if (yych == '\n') goto jj94;
#line 185 "./json.re"
	{ /* eaten; it is a LineContinuation */ goto stringdq; }
#line 470 "./json_lexer.cpp"
jj72:
	++YYCURSOR;
#line 182 "./json.re"
	{ (*yylval)->pString->push_back('\"'); goto stringdq; }
#line 475 "./json_lexer.cpp"
jj74:
	++YYCURSOR;
#line 181 "./json.re"
	{ (*yylval)->pString->push_back('\''); goto stringdq; }
#line 480 "./json_lexer.cpp"
jj76:
	++YYCURSOR;
#line 180 "./json.re"
	{ (*yylval)->pString->push_back('\?'); goto stringdq; }
#line 485 "./json_lexer.cpp"
jj78:
	++YYCURSOR;
#line 179 "./json.re"
	{ (*yylval)->pString->push_back('\\'); goto stringdq; }
#line 490 "./json_lexer.cpp"
jj80:
	++YYCURSOR;
#line 176 "./json.re"
	{ (*yylval)->pString->push_back('\b'); goto stringdq; }
#line 495 "./json_lexer.cpp"
jj82:
	++YYCURSOR;
#line 178 "./json.re"
	{ (*yylval)->pString->push_back('\f'); goto stringdq; }
#line 500 "./json_lexer.cpp"
jj84:
	++YYCURSOR;
#line 174 "./json.re"
	{ (*yylval)->pString->push_back('\n'); goto stringdq; }
#line 505 "./json_lexer.cpp"
jj86:
	++YYCURSOR;
#line 177 "./json.re"
	{ (*yylval)->pString->push_back('\r'); goto stringdq; }
#line 510 "./json_lexer.cpp"
jj88:
	++YYCURSOR;
#line 175 "./json.re"
	{ (*yylval)->pString->push_back('\t'); goto stringdq; }
#line 515 "./json_lexer.cpp"
jj90:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto jj91;
		if (yych <= '9') goto jj96;
	} else {
		if (yych <= 'F') goto jj96;
		if (yych <= '`') goto jj91;
		if (yych <= 'f') goto jj96;
	}
jj91:
	YYCURSOR = YYMARKER;
	goto jj62;
jj92:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto jj91;
		if (yych <= '9') goto jj97;
		goto jj91;
	} else {
		if (yych <= 'F') goto jj97;
		if (yych <= '`') goto jj91;
		if (yych <= 'f') goto jj97;
		goto jj91;
	}
jj93:
	yych = *++YYCURSOR;
	if (yych == 0x80) goto jj98;
	goto jj91;
jj94:
	++YYCURSOR;
#line 184 "./json.re"
	{ /* eaten; it is a LineContinuation */ goto stringdq; }
#line 549 "./json_lexer.cpp"
jj96:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto jj91;
		if (yych <= '9') goto jj99;
		goto jj91;
	} else {
		if (yych <= 'F') goto jj99;
		if (yych <= '`') goto jj91;
		if (yych <= 'f') goto jj99;
		goto jj91;
	}
jj97:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto jj91;
		if (yych <= '9') goto jj100;
		goto jj91;
	} else {
		if (yych <= 'F') goto jj100;
		if (yych <= '`') goto jj91;
		if (yych <= 'f') goto jj100;
		goto jj91;
	}
jj98:
	yych = *++YYCURSOR;
	if (yych <= 0xA7) goto jj91;
	if (yych <= 0xA8) goto jj102;
	if (yych <= 0xA9) goto jj104;
	goto jj91;
jj99:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto jj91;
		if (yych <= '9') goto jj106;
		goto jj91;
	} else {
		if (yych <= 'F') goto jj106;
		if (yych <= '`') goto jj91;
		if (yych <= 'f') goto jj106;
		goto jj91;
	}
jj100:
	++YYCURSOR;
#line 188 "./json.re"
	{ tok += 2; // Go past SLASH x
			       std::string mystr;
			       getString(mystr);
			       (*yylval)->pString->push_back(hex2char(mystr.c_str()));
			       goto stringdq; 			     
                             }
#line 601 "./json_lexer.cpp"
jj102:
	++YYCURSOR;
#line 186 "./json.re"
	{ /* \\ + \u2028 (<LS>) is eaten; it is a LineContinuation */ goto stringdq; }
#line 606 "./json_lexer.cpp"
jj104:
	++YYCURSOR;
#line 187 "./json.re"
	{ /* \\ + \u2029 (<PS>) is eaten; it is a LineContinuation */ goto stringdq; }
#line 611 "./json_lexer.cpp"
jj106:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '/') goto jj91;
		if (yych >= ':') goto jj91;
	} else {
		if (yych <= 'F') goto jj107;
		if (yych <= '`') goto jj91;
		if (yych >= 'g') goto jj91;
	}
jj107:
	++YYCURSOR;
#line 194 "./json.re"
	{ tok += 2; // Go past SLASH x
			       std::string mystr;
			       getString(mystr);
			       long hex_long = hex2long(mystr);
			       std::string utf8_output;
			       long2utf8(hex_long, utf8_output);
			       (*(*yylval)->pString) += utf8_output;
			       goto stringdq; 			     
                             }
#line 634 "./json_lexer.cpp"
}
#line 208 "./json.re"


 end:
	return 0;
}


void JSONScanner::addToken(void)
{
	(*yylval)->setString(new std::string);
	std::string::size_type length = cur - tok;
	(*yylval)->pString->reserve(length);
	(*yylval)->pString->append(tok, length);
/*
	const char *p;
	for (p = tok;
	     p != cur;
	     ++p) {
	     (*yylval)->pString->push_back(*p);
	}
*/
}

void JSONScanner::addInteger(void)
{
	const size_t MAX_INTEGER_CHARS = 12;
	size_t cnt = cur - tok;
	if (cnt > MAX_INTEGER_CHARS) {
	   	std::string mystring;
		const char *p;
		for (p = tok;
		     p != cur;
	     	     ++p) {
		     mystring.append(1, *p);
		}
		(*yylval)->setInteger(sz2longlong(mystring.c_str()));
        } else {
		char szInt[MAX_INTEGER_CHARS+1];

		const char *p;
		char *q = szInt;
		for (p = tok;
		     p != cur;
	     	     ++p) {
		     *q++ = *p;
		}
		*q = '\0';
		(*yylval)->setInteger(sz2longlong(szInt));
	}
}

void JSONScanner::getString(std::string& str)
{
	std::string::size_type length = cur - tok;
	str.reserve(length);
	str.append(tok, length);
/*
	const char *p;
	for (p = tok;
	     p != cur;
	     ++p) {
	     str.append(1, *p);
	}
*/
}

std::string JSONScanner::getInputScannedSoFar()
{
	if (cur == 0 || sz == 0) {
	        return "";
        } else {
	        if (sz > cur) {
	              return "";
            	} else {
	              std::string result;
		      for (const char *p = sz;
		           p != cur;
		           ++p) {
		              result += *p;
		      } 
		      return result;
                }
        }
}
