# Single DBFC Dataset

## Overview

This dataset includes Direct Borohydride Fuel Cell (DBFC) impedance and polarization test in anode with Pd/C, Pt/C and Pd decorated Ni–Co/rGO catalysts. In fact, different concentration of Sodium Borohydride (SBH), applied voltages and various anode catalysts loading with explanation of experimental details of electrochemical analysis are considered in data. Voltage, power density and resistance of DBFC change as a function of weight percent of SBH (%), applied voltage and amount of anode catalyst loading that are evaluated by polarization and impedance curves with using appropriate equivalent circuit of fuel cell. Can be stated that interpretation of electrochemical behavior changes by the data of related cell is inevitable, which can be useful in simulation, power source investigation and depth analysis in DB fuel cell researches.

## Tests


1. [Pd-Decorated-Ni-Co/rGO Catalyst](https://github.com/ECSIM/dbfc-dataset/tree/master/Pd-Decorated-Ni-Co_rGO%20Catalyst)
2. [Pd-C Catalyst](https://github.com/ECSIM/dbfc-dataset/tree/master/Pd-C%20Catalyst)
3. [Pt-C Catalyst](https://github.com/ECSIM/dbfc-dataset/tree/master/Pt-C%20Catalyst)

<a href="https://github.com/ECSIM/dbfc-dataset/archive/v1.0.zip"><img src="images/button.png" width="177px" height="34px"><a/>
<br/>
<a href="https://www.kaggle.com/sepandhaghighi/single-dbfc-dataset"><img src="images/button2.png" width="177px" height="34px"><a/>

## Notebooks

We have provided some **Jupyter Notebooks** to visualize the data, visit [here](https://github.com/ECSIM/dbfc-dataset/tree/master/Notebooks)


## Issues & Bug Reports			

Just fill an issue and describe it. We'll check it ASAP!							
or send an email to [data@ecsim.site](mailto:data@ecsim.site "data@ecsim.site"). 

You can also join our discord server			

<a href="https://discord.gg/NDwgZadaDH">
  <img src="https://img.shields.io/discord/1006472275920425012.svg?style=for-the-badge" alt="Discord Channel">
</a>


## Cite

If you use this dataset in your research, we would appreciate citations to the following paper :

<pre>
S. Hamidi, S. Sabouri, S. Haghighi, K. Askari, Experimental Dataset of Electrochemical Efficiency of a Direct Borohydride Fuel Cell (DBFC) with Pd/C, Pt/C and Pd Decorated Ni–Co/rGO Anode Catalysts, ChemRxiv, (2020). doi: 10.26434/chemrxiv.12174438.
</pre>
<pre>

@article{Hamidi2020,
  doi = {10.26434/chemrxiv.12174438},
  url = {https://doi.org/10.26434/chemrxiv.12174438},
  year = {2020},
  month = apr,
  publisher = {American Chemical Society ({ACS})},
  author = {Sarmin Hamidi and Sadra Sabouri and Sepand Haghighi and Kasra Askari},
  title = {Experimental Dataset of Electrochemical Efficiency of a Direct Borohydride Fuel Cell ({DBFC}) with Pd/C,  Pt/C and Pd Decorated Ni{\textendash}Co/{rGO} Anode Catalysts}
}


</pre>

## License


<a href="https://github.com/ECSIM/dbfc-dataset/blob/master/LICENSE"><img src="images/CC-BY.png"></a>

## Show Your Support

<h3>Star This Repo</h3>					

Give a ⭐️ if this project helped you!  

<h3>Donate to Our Project</h3>	
								
If you do like our project and we hope that you do, can you please support us? Our project is not and is never going to be working for profit. We need the money just so we can continue doing what we do ;-) .

<a href="https://www.ecsim.site/opem/donate.html" target="_blank"><img src="http://www.ecsim.site/images/Donate-Button.png" height="90px" width="270px" alt="ECSIM Donation"></a>
