/* **********************************************************
 * Copyright (c) 2019 Google, Inc.  All rights reserved.
 * **********************************************************/

/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of VMware, Inc. nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL VMWARE, INC. OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#ifndef ASM_CODE_ONLY /* C code */

/* The encodings and some contents of this test suite were obtained from the version 2.32
 * tarball downloaded from https://www.gnu.org/software/binutils/.
 *
 * The .expect files of this suite are generated by DynamoRIO and were manually inspected.
 * This means they are not directly taken from the binutils test suite and are not golden.
 * It is possible that at the time of generating the expected results in this test suite,
 * bugs already existed.
 */

#    include "configure.h"
#    include "dr_api.h"
#    include <stdio.h>
#    include <stdlib.h>

#    define GD GLOBAL_DCONTEXT

void
test_s_asm(void);
void
test_x86_64_s_asm(void);

/* Arbitrary pc for pc-relative operands for consistent output */
#    define ORIG_PC ((app_pc)0x10000000)

static void
test_s(byte *subtest_asm)
{
    instr_t *instr = instr_create(GD);
    /* MAX_INSTR_LENGTH == 17. */
    byte buf[17];
    byte *dec_pc = subtest_asm;
    byte *start = dec_pc;
    disassemble_set_syntax(DR_DISASM_ATT);
    while (*(uint64 *)dec_pc != 0x0102030405060708) {
        instr_reset(GD, instr);
        disassemble_from_copy(GD, dec_pc, ORIG_PC + (dec_pc - start), STDOUT, false,
                              true);
        dec_pc = decode_from_copy(GD, dec_pc, ORIG_PC + (dec_pc - start), instr);
        instr_set_raw_bits_valid(instr, false);
        instr_encode_to_copy(GD, instr, buf, ORIG_PC + (dec_pc - start));
    }
    instr_destroy(GD, instr);
}

int
main()
{
    dr_printf("test_s:\n");
    test_s((byte *)test_s_asm);
    dr_printf("done\n");
    return 0;
}

#else /* asm code *************************************************************/
#    include "asm_defines.asm"
/* clang-format off */
START_FILE

/* Enough nops have been added such that the actual marker 0x0102030405060708 will
 * deterministically start at a real instruction boundary, no matter whether there
 * will be a decoding error or not.
 */
#    define END_OF_FUNCTION_MARKER \
  RAW(90) RAW(90) RAW(90) RAW(90) RAW(90) RAW(90) RAW(90) RAW(90) \
  RAW(90) RAW(90) RAW(90) RAW(90) RAW(90) RAW(90) RAW(90) RAW(90) \
  RAW(08) RAW(07) RAW(06) RAW(05) RAW(04) RAW(03) RAW(02) RAW(01)

#    define END_OF_SUBTEST_MARKER \
  RAW(90) RAW(90) RAW(90) RAW(90) RAW(90) RAW(90) RAW(90) RAW(90) \
  RAW(90) RAW(90) RAW(90) RAW(90) RAW(90) RAW(90) RAW(90) RAW(90)

#    include "test_decenc_x86.asm"

END_FILE
/* clang-format on */
#endif /* ASM_CODE_ONLY */
