/* **********************************************************
 * Copyright (c) 2017 Google, Inc.  All rights reserved.
 * Copyright (c) 2003-2008 VMware, Inc.  All rights reserved.
 * **********************************************************/

/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of VMware, Inc. nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL VMWARE, INC. OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/*
 * test of execve recursively
 */

#include "tools.h"

#include <sys/types.h>
#include <unistd.h>
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#define NULL_ENV 0

const int N = 10;

int
main(int argc, char **argv)
{
    int n, sum = 0;
    int result;
    char *arg[5];
    char **env = NULL;
    char carg[10], csum[10];

    if (find_dynamo_library())
        print("under DynamoRIO\n");
    else
        print("natively\n");

    // print("%d %s %s %s\n", argc, argv[0], argv[1], argv[2]);
    if (1 == argc) { // no args
        n = N;
        sum = 0;
        print("Sum(%d)\n", n);
    } else if (2 == argc) { // execve-rec 10
        n = atoi(argv[1]);
        sum = 0;
        print("Sum(%d)\n", n);
    } else {
        assert(argc == 3); // execve-rec 9 10
        n = atoi(argv[1]);
        sum = atoi(argv[2]);
    }
    if (0 == n) {
        print("  = %d\n", sum);
        exit(0);
    }

    sum += n;
    n--;
    snprintf(carg, 10, "%d", n);
    snprintf(csum, 10, "%d", sum);
    arg[0] = argv[0];
    arg[1] = carg;
    arg[2] = csum;
    arg[3] = NULL;

#if 0
    print("%d,%d\n", n, sum);
    print("execing %d %s %s=%s %s\n",
           3, arg[0], carg, arg[1], arg[2]);
#endif

    fflush(stdout);
    result = execve(arg[0], arg, env);
    if (result < 0)
        perror("ERROR in execve");
}
