/* *******************************************************************************
 * Copyright (c) 2019 Google, Inc.  All rights reserved.
 * *******************************************************************************/

/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of VMware, Inc. nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL VMWARE, INC. OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/*
 * memquery_test_data.h - A collection of table-test data used in unit tests for
 * the unix memquery logic; it is included directly into memquery_test.h.
 * This file was generated using the record_memquery_library_bounds_by_iterator
 * function found in memquery_test.h, see that function for details.
 */

/* We remove much of the whitespace from the fake query results to save space in
 * the repo since they are so heavily indented.
 */
/* clang-format off */
fake_memquery_result results_EE55A55[]={
{
.iter_result={.vm_start=(app_pc)0xf7c78000,
.vm_end=(app_pc)0xf7c7b000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7c7b000,
.vm_end=(app_pc)0xf7c7d000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00002000,
},
{
.iter_result={.vm_start=(app_pc)0xf7c7d000,
.vm_end=(app_pc)0xf7f8b000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/32bit/lib32/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x71000000,
.mod_end=(app_pc)0x71380000,
},
{
.iter_result={.vm_start=(app_pc)0xf7f8c000,
.vm_end=(app_pc)0xf7fc5000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/32bit/lib32/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7fc5000,
.vm_end=(app_pc)0xf7ffd000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xfff94000,
.vm_end=(app_pc)0xfffb6000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
};

fake_memquery_result results_EE55E9A[]={
{
.iter_result={.vm_start=(app_pc)0x4c954000,
.vm_end=(app_pc)0x4c955000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0x4c955000,
.vm_end=(app_pc)0x4c95a000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0x4c95a000,
.vm_end=(app_pc)0x4c95d000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0x4c95d000,
.vm_end=(app_pc)0x4c95e000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0x4c95e000,
.vm_end=(app_pc)0x4c965000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0x4c965000,
.vm_end=(app_pc)0x4c966000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0x4c966000,
.vm_end=(app_pc)0x54954000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf3c6b000,
.vm_end=(app_pc)0xf3c6f000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/32bit/suite/tests/bin/linux.execve32"},
.is_header=true,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x0000c000,
},
{
.iter_result={.vm_start=(app_pc)0xf3c6f000,
.vm_end=(app_pc)0xf3c71000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/32bit/suite/tests/bin/linux.execve32"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf3c71000,
.vm_end=(app_pc)0xf3c77000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf3c77000,
.vm_end=(app_pc)0xf3c78000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf3c78000,
.vm_end=(app_pc)0xf3c79000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7c52000,
.vm_end=(app_pc)0xf7c75000,
.prot=5,
.comment="/lib/i386-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00025000,
},
{
.iter_result={.vm_start=(app_pc)0xf7c75000,
.vm_end=(app_pc)0xf7c77000,
.prot=3,
.comment="/lib/i386-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7c77000,
.vm_end=(app_pc)0xf7c78000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7c78000,
.vm_end=(app_pc)0xf7c7b000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7c7b000,
.vm_end=(app_pc)0xf7c7d000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00002000,
},
{
.iter_result={.vm_start=(app_pc)0xf7c7d000,
.vm_end=(app_pc)0xf7f8b000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/32bit/lib32/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x71000000,
.mod_end=(app_pc)0x71380000,
},
{
.iter_result={.vm_start=(app_pc)0xf7f8b000,
.vm_end=(app_pc)0xf7f8c000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7f8c000,
.vm_end=(app_pc)0xf7fc5000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/32bit/lib32/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7fc5000,
.vm_end=(app_pc)0xf7ffd000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xfff94000,
.vm_end=(app_pc)0xfffb6000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
};

fake_memquery_result results_EED027F[]={
{
.iter_result={.vm_start=(app_pc)0x00007fcb3e604000,
.vm_end=(app_pc)0x00007fcb3e99b000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fcb3eb9b000,
.vm_end=(app_pc)0x00007fcb3ebe0000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fcb3ebe0000,
.vm_end=(app_pc)0x00007fcb3ec25000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffd7a6bf000,
.vm_end=(app_pc)0x00007ffd7a6e0000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffd7a715000,
.vm_end=(app_pc)0x00007ffd7a718000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffd7a718000,
.vm_end=(app_pc)0x00007ffd7a71a000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_EED055B[]={
{
.iter_result={.vm_start=(app_pc)0x00007fcb3a3fe000,
.vm_end=(app_pc)0x00007fcb3a401000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/linux.execve-sub64"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000205000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fcb3a401000,
.vm_end=(app_pc)0x00007fcb3a601000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fcb3a601000,
.vm_end=(app_pc)0x00007fcb3a603000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/linux.execve-sub64"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fcb3a603000,
.vm_end=(app_pc)0x00007fcb3a604000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fcb3a604000,
.vm_end=(app_pc)0x00007fcb3a605000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fcb3e3dd000,
.vm_end=(app_pc)0x00007fcb3e400000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fcb3e400000,
.vm_end=(app_pc)0x00007fcb3e600000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fcb3e600000,
.vm_end=(app_pc)0x00007fcb3e602000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fcb3e602000,
.vm_end=(app_pc)0x00007fcb3e603000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fcb3e603000,
.vm_end=(app_pc)0x00007fcb3e604000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fcb3e604000,
.vm_end=(app_pc)0x00007fcb3e99b000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fcb3e99b000,
.vm_end=(app_pc)0x00007fcb3eb9b000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fcb3eb9b000,
.vm_end=(app_pc)0x00007fcb3ebe0000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fcb3ebe0000,
.vm_end=(app_pc)0x00007fcb3ec25000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffd7a6bf000,
.vm_end=(app_pc)0x00007ffd7a6e0000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffd7a715000,
.vm_end=(app_pc)0x00007ffd7a718000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffd7a718000,
.vm_end=(app_pc)0x00007ffd7a71a000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_EF597C9[]={
{
.iter_result={.vm_start=(app_pc)0x00007fc03541b000,
.vm_end=(app_pc)0x00007fc0357b2000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc0359b2000,
.vm_end=(app_pc)0x00007fc0359f7000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc0359f7000,
.vm_end=(app_pc)0x00007fc035a3c000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc338a2000,
.vm_end=(app_pc)0x00007ffc338c4000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc33965000,
.vm_end=(app_pc)0x00007ffc33968000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc33968000,
.vm_end=(app_pc)0x00007ffc3396a000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_EF59D59[]={
{
.iter_result={.vm_start=(app_pc)0x00007fc031215000,
.vm_end=(app_pc)0x00007fc031219000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/linux.execve64"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000205000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc031219000,
.vm_end=(app_pc)0x00007fc031418000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc031418000,
.vm_end=(app_pc)0x00007fc03141a000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/linux.execve64"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc03141a000,
.vm_end=(app_pc)0x00007fc03141b000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc03141b000,
.vm_end=(app_pc)0x00007fc03141c000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc0351f4000,
.vm_end=(app_pc)0x00007fc035217000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc035217000,
.vm_end=(app_pc)0x00007fc035417000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc035417000,
.vm_end=(app_pc)0x00007fc035419000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc035419000,
.vm_end=(app_pc)0x00007fc03541a000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc03541a000,
.vm_end=(app_pc)0x00007fc03541b000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc03541b000,
.vm_end=(app_pc)0x00007fc0357b2000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc0357b2000,
.vm_end=(app_pc)0x00007fc0359b2000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc0359b2000,
.vm_end=(app_pc)0x00007fc0359f7000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc0359f7000,
.vm_end=(app_pc)0x00007fc035a3c000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc338a2000,
.vm_end=(app_pc)0x00007ffc338c4000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc33965000,
.vm_end=(app_pc)0x00007ffc33968000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc33968000,
.vm_end=(app_pc)0x00007ffc3396a000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_EFCC4D5[]={
{
.iter_result={.vm_start=(app_pc)0xf7bb6000,
.vm_end=(app_pc)0xf7bb9000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7bb9000,
.vm_end=(app_pc)0xf7bbb000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00002000,
},
{
.iter_result={.vm_start=(app_pc)0xf7bbb000,
.vm_end=(app_pc)0xf7ec9000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/32bit/lib32/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x71000000,
.mod_end=(app_pc)0x71380000,
},
{
.iter_result={.vm_start=(app_pc)0xf7eca000,
.vm_end=(app_pc)0xf7f03000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/32bit/lib32/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7f03000,
.vm_end=(app_pc)0xf7f3b000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xff838000,
.vm_end=(app_pc)0xff859000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
};

fake_memquery_result results_EFCCB45[]={
{
.iter_result={.vm_start=(app_pc)0x45e28000,
.vm_end=(app_pc)0x45e29000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0x45e29000,
.vm_end=(app_pc)0x45e2e000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0x45e2e000,
.vm_end=(app_pc)0x45e31000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0x45e31000,
.vm_end=(app_pc)0x45e32000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0x45e32000,
.vm_end=(app_pc)0x45e39000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0x45e39000,
.vm_end=(app_pc)0x45e3a000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0x45e3a000,
.vm_end=(app_pc)0x4de28000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf3baa000,
.vm_end=(app_pc)0xf3bad000,
.prot=5,
.comment=
"/usr/local/google/home/chowski/dynamorio/build/suite/tests/"
"32bit/suite/tests/bin/linux.execve-sub32"},
.is_header=true,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x0000b000,
},
{
.iter_result={.vm_start=(app_pc)0xf3bad000,
.vm_end=(app_pc)0xf3baf000,
.prot=3,
.comment=
"/usr/local/google/home/chowski/dynamorio/build/suite/tests/"
"32bit/suite/tests/bin/linux.execve-sub32"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf3baf000,
.vm_end=(app_pc)0xf3bb5000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf3bb5000,
.vm_end=(app_pc)0xf3bb6000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf3bb6000,
.vm_end=(app_pc)0xf3bb7000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7b90000,
.vm_end=(app_pc)0xf7bb3000,
.prot=5,
.comment="/lib/i386-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00025000,
},
{
.iter_result={.vm_start=(app_pc)0xf7bb3000,
.vm_end=(app_pc)0xf7bb5000,
.prot=3,
.comment="/lib/i386-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7bb5000,
.vm_end=(app_pc)0xf7bb6000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7bb6000,
.vm_end=(app_pc)0xf7bb9000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7bb9000,
.vm_end=(app_pc)0xf7bbb000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00002000,
},
{
.iter_result={.vm_start=(app_pc)0xf7bbb000,
.vm_end=(app_pc)0xf7ec9000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/32bit/lib32/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x71000000,
.mod_end=(app_pc)0x71380000,
},
{
.iter_result={.vm_start=(app_pc)0xf7ec9000,
.vm_end=(app_pc)0xf7eca000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7eca000,
.vm_end=(app_pc)0xf7f03000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/32bit/lib32/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xf7f03000,
.vm_end=(app_pc)0xf7f3b000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
{
.iter_result={.vm_start=(app_pc)0xff838000,
.vm_end=(app_pc)0xff859000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x00000000,
.mod_end=(app_pc)0x00000000,
},
};

fake_memquery_result results_F0531DF[]={
{
.iter_result={.vm_start=(app_pc)0x00007f430c38d000,
.vm_end=(app_pc)0x00007f430c724000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f430c924000,
.vm_end=(app_pc)0x00007f430c969000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f430c969000,
.vm_end=(app_pc)0x00007f430c9ae000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe0cec7000,
.vm_end=(app_pc)0x00007ffe0cee9000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe0cfa3000,
.vm_end=(app_pc)0x00007ffe0cfa6000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe0cfa6000,
.vm_end=(app_pc)0x00007ffe0cfa8000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_F1AC967[]={
{
.iter_result={.vm_start=(app_pc)0x00007fb049480000,
.vm_end=(app_pc)0x00007fb049484000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/common.decode"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x00000000007bd000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb049484000,
.vm_end=(app_pc)0x00007fb049683000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb049683000,
.vm_end=(app_pc)0x00007fb049685000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/common.decode"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb049685000,
.vm_end=(app_pc)0x00007fb049c3d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb049c3d000,
.vm_end=(app_pc)0x00007fb049c3e000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb049c3e000,
.vm_end=(app_pc)0x00007fb049c3f000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb04da17000,
.vm_end=(app_pc)0x00007fb04da3a000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb04da3a000,
.vm_end=(app_pc)0x00007fb04dc3a000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb04dc3a000,
.vm_end=(app_pc)0x00007fb04dc3c000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb04dc3c000,
.vm_end=(app_pc)0x00007fb04dc3d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb04dc3d000,
.vm_end=(app_pc)0x00007fb04dc3e000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb04dc3e000,
.vm_end=(app_pc)0x00007fb04dfd5000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb04dfd5000,
.vm_end=(app_pc)0x00007fb04e1d5000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb04e1d5000,
.vm_end=(app_pc)0x00007fb04e21a000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb04e21a000,
.vm_end=(app_pc)0x00007fb04e25f000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffee3b6e000,
.vm_end=(app_pc)0x00007ffee3b90000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffee3b94000,
.vm_end=(app_pc)0x00007ffee3b97000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffee3b97000,
.vm_end=(app_pc)0x00007ffee3b99000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_1236E907[]={
{
.iter_result={.vm_start=(app_pc)0x0000000071000000,
.vm_end=(app_pc)0x0000000071397000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000071397000,
.vm_end=(app_pc)0x0000000071597000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000071597000,
.vm_end=(app_pc)0x00000000715dc000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000000715dc000,
.vm_end=(app_pc)0x0000000071621000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000071621000,
.vm_end=(app_pc)0x0000000071622000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f7d24605000,
.vm_end=(app_pc)0x00007f7d2499c000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f7d24b97000,
.vm_end=(app_pc)0x00007f7d24b9a000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f7d24b9a000,
.vm_end=(app_pc)0x00007f7d24b9c000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f7d24b9c000,
.vm_end=(app_pc)0x00007f7d24be1000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f7d24be1000,
.vm_end=(app_pc)0x00007f7d24c26000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff83b84000,
.vm_end=(app_pc)0x00007fff83ba6000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
};

fake_memquery_result results_12A51D0A[]={
{
.iter_result={.vm_start=(app_pc)0x0000000107237000,
.vm_end=(app_pc)0x0000000107238000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000107238000,
.vm_end=(app_pc)0x000000010723e000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000000010723e000,
.vm_end=(app_pc)0x0000000107240000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000107240000,
.vm_end=(app_pc)0x0000000107252000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000107252000,
.vm_end=(app_pc)0x0000000107260000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000107260000,
.vm_end=(app_pc)0x0000000107261000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000107261000,
.vm_end=(app_pc)0x0000000107268000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000107268000,
.vm_end=(app_pc)0x0000000107269000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000107269000,
.vm_end=(app_pc)0x0000000127237000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f32da671000,
.vm_end=(app_pc)0x00007f32da675000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/linux.mangle_asynch"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000205000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f32da675000,
.vm_end=(app_pc)0x00007f32da874000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f32da874000,
.vm_end=(app_pc)0x00007f32da876000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/linux.mangle_asynch"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f32da876000,
.vm_end=(app_pc)0x00007f32da877000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f32da877000,
.vm_end=(app_pc)0x00007f32da878000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f32de650000,
.vm_end=(app_pc)0x00007f32de673000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f32de673000,
.vm_end=(app_pc)0x00007f32de873000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f32de873000,
.vm_end=(app_pc)0x00007f32de875000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f32de875000,
.vm_end=(app_pc)0x00007f32de876000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f32de876000,
.vm_end=(app_pc)0x00007f32de877000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f32de877000,
.vm_end=(app_pc)0x00007f32dec0e000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f32dec0e000,
.vm_end=(app_pc)0x00007f32dee0e000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f32dee0e000,
.vm_end=(app_pc)0x00007f32dee53000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f32dee53000,
.vm_end=(app_pc)0x00007f32dee98000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffcf6931000,
.vm_end=(app_pc)0x00007ffcf6953000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffcf69e3000,
.vm_end=(app_pc)0x00007ffcf69e6000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffcf69e6000,
.vm_end=(app_pc)0x00007ffcf69e8000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_12CD8932[]={
{
.iter_result={.vm_start=(app_pc)0x0000000000400000,
.vm_end=(app_pc)0x00000000004b4000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/linux.fib-static"},
.is_header=true,
.mod_base=(app_pc)0x0000000000400000,
.mod_end=(app_pc)0x00000000006b8000,
},
{
.iter_result={.vm_start=(app_pc)0x00000000004b4000,
.vm_end=(app_pc)0x00000000006b3000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000000006b3000,
.vm_end=(app_pc)0x00000000006b6000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/linux.fib-static"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000000006b6000,
.vm_end=(app_pc)0x00000000006b8000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000000006b8000,
.vm_end=(app_pc)0x00000000006b9000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000000006b9000,
.vm_end=(app_pc)0x00000000006ba000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f24325c4000,
.vm_end=(app_pc)0x00007f243295b000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f243295b000,
.vm_end=(app_pc)0x00007f2432b5b000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2432b5b000,
.vm_end=(app_pc)0x00007f2432ba0000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2432ba0000,
.vm_end=(app_pc)0x00007f2432be5000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe9a41f000,
.vm_end=(app_pc)0x00007ffe9a441000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe9a5cf000,
.vm_end=(app_pc)0x00007ffe9a5d2000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe9a5d2000,
.vm_end=(app_pc)0x00007ffe9a5d4000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_136482A6[]={
{
.iter_result={.vm_start=(app_pc)0x000003000548a000,
.vm_end=(app_pc)0x000003000548b000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000003000548b000,
.vm_end=(app_pc)0x0000030005491000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000030005491000,
.vm_end=(app_pc)0x0000030005493000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000030005493000,
.vm_end=(app_pc)0x00000300054a5000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000300054a5000,
.vm_end=(app_pc)0x00000300054b3000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000300054b3000,
.vm_end=(app_pc)0x00000300054b4000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000300054b4000,
.vm_end=(app_pc)0x00000300054bb000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000300054bb000,
.vm_end=(app_pc)0x00000300054bc000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000300054bc000,
.vm_end=(app_pc)0x000003002548a000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb2d24d2000,
.vm_end=(app_pc)0x00007fb2d24da000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/security-common.selfmod"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000209000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb2d24da000,
.vm_end=(app_pc)0x00007fb2d26d9000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb2d26d9000,
.vm_end=(app_pc)0x00007fb2d26db000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/security-common.selfmod"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb2d26db000,
.vm_end=(app_pc)0x00007fb2d26dc000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb2d26dc000,
.vm_end=(app_pc)0x00007fb2d26dd000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb2d64b5000,
.vm_end=(app_pc)0x00007fb2d64d8000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb2d64d8000,
.vm_end=(app_pc)0x00007fb2d66d8000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb2d66d8000,
.vm_end=(app_pc)0x00007fb2d66da000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb2d66da000,
.vm_end=(app_pc)0x00007fb2d66db000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb2d66db000,
.vm_end=(app_pc)0x00007fb2d66dc000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb2d66dc000,
.vm_end=(app_pc)0x00007fb2d6a73000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb2d6a73000,
.vm_end=(app_pc)0x00007fb2d6c73000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb2d6c73000,
.vm_end=(app_pc)0x00007fb2d6cb8000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb2d6cb8000,
.vm_end=(app_pc)0x00007fb2d6cfd000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc2ed52000,
.vm_end=(app_pc)0x00007ffc2ed74000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc2edd4000,
.vm_end=(app_pc)0x00007ffc2edd7000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc2edd7000,
.vm_end=(app_pc)0x00007ffc2edd9000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_14442F83[]={
{
.iter_result={.vm_start=(app_pc)0x0000000071000000,
.vm_end=(app_pc)0x0000000071397000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000071397000,
.vm_end=(app_pc)0x0000000071597000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000071597000,
.vm_end=(app_pc)0x00000000715dc000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000000715dc000,
.vm_end=(app_pc)0x0000000071621000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000071621000,
.vm_end=(app_pc)0x0000000071622000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f9cd0242000,
.vm_end=(app_pc)0x00007f9cd05d9000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f9cd07d4000,
.vm_end=(app_pc)0x00007f9cd07d7000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f9cd07d7000,
.vm_end=(app_pc)0x00007f9cd07d9000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f9cd07d9000,
.vm_end=(app_pc)0x00007f9cd081e000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f9cd081e000,
.vm_end=(app_pc)0x00007f9cd0863000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc37fc5000,
.vm_end=(app_pc)0x00007ffc37fe7000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
};

fake_memquery_result results_16390299[]={
{
.iter_result={.vm_start=(app_pc)0x00000000a3ac0000,
.vm_end=(app_pc)0x00000000a3ac2000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/libclient.mangle_suspend.dll.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000072000000,
.mod_end=(app_pc)0x0000000072203000,
},
{
.iter_result={.vm_start=(app_pc)0x00000000a3ac2000,
.vm_end=(app_pc)0x00000000a3cc1000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000000a3cc1000,
.vm_end=(app_pc)0x00000000a3cc3000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/libclient.mangle_suspend.dll.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000000a3cc3000,
.vm_end=(app_pc)0x00000000a3cc4000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000103ac0000,
.vm_end=(app_pc)0x0000000103ac1000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000103ac1000,
.vm_end=(app_pc)0x0000000103ac7000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000103ac7000,
.vm_end=(app_pc)0x0000000103ac9000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000103ac9000,
.vm_end=(app_pc)0x0000000103adb000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000103adb000,
.vm_end=(app_pc)0x0000000103ae9000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000103ae9000,
.vm_end=(app_pc)0x0000000103aea000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000103aea000,
.vm_end=(app_pc)0x0000000103af1000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000103af1000,
.vm_end=(app_pc)0x0000000103af2000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000103af2000,
.vm_end=(app_pc)0x0000000123ac0000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2a3167f000,
.vm_end=(app_pc)0x00007f2a31683000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/client.mangle_suspend"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000205000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2a31683000,
.vm_end=(app_pc)0x00007f2a31882000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2a31882000,
.vm_end=(app_pc)0x00007f2a31884000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/client.mangle_suspend"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2a31884000,
.vm_end=(app_pc)0x00007f2a31885000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2a31885000,
.vm_end=(app_pc)0x00007f2a31886000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2a3565e000,
.vm_end=(app_pc)0x00007f2a35681000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2a35681000,
.vm_end=(app_pc)0x00007f2a35881000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2a35881000,
.vm_end=(app_pc)0x00007f2a35883000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2a35883000,
.vm_end=(app_pc)0x00007f2a35884000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2a35884000,
.vm_end=(app_pc)0x00007f2a35885000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2a35885000,
.vm_end=(app_pc)0x00007f2a35c1c000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2a35c1c000,
.vm_end=(app_pc)0x00007f2a35e1c000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2a35e1c000,
.vm_end=(app_pc)0x00007f2a35e61000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2a35e61000,
.vm_end=(app_pc)0x00007f2a35ea6000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffdd2ee0000,
.vm_end=(app_pc)0x00007ffdd2f02000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffdd2f07000,
.vm_end=(app_pc)0x00007ffdd2f0a000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffdd2f0a000,
.vm_end=(app_pc)0x00007ffdd2f0c000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_173012FF[]={
{
.iter_result={.vm_start=(app_pc)0x0000000071000000,
.vm_end=(app_pc)0x0000000071397000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000071397000,
.vm_end=(app_pc)0x0000000071597000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000071597000,
.vm_end=(app_pc)0x00000000715dc000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000000715dc000,
.vm_end=(app_pc)0x0000000071621000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000071621000,
.vm_end=(app_pc)0x0000000071622000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a5595000,
.vm_end=(app_pc)0x00007fc8a592c000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a5b27000,
.vm_end=(app_pc)0x00007fc8a5b2a000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a5b2a000,
.vm_end=(app_pc)0x00007fc8a5b2c000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a5b2c000,
.vm_end=(app_pc)0x00007fc8a5b71000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a5b71000,
.vm_end=(app_pc)0x00007fc8a5bb6000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff81f81000,
.vm_end=(app_pc)0x00007fff81fa3000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
};

fake_memquery_result results_1730194B[]={
{
.iter_result={.vm_start=(app_pc)0x0000000071000000,
.vm_end=(app_pc)0x0000000071397000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000071397000,
.vm_end=(app_pc)0x0000000071597000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000071597000,
.vm_end=(app_pc)0x00000000715dc000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000000715dc000,
.vm_end=(app_pc)0x0000000071621000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000071621000,
.vm_end=(app_pc)0x0000000071622000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a1923000,
.vm_end=(app_pc)0x00007fc8a1925000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/client.file_io"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000203000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a1925000,
.vm_end=(app_pc)0x00007fc8a1b24000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a1b24000,
.vm_end=(app_pc)0x00007fc8a1b26000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/client.file_io"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a1b26000,
.vm_end=(app_pc)0x00007fc8a1b27000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a1b27000,
.vm_end=(app_pc)0x00007fc8a1b28000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a5900000,
.vm_end=(app_pc)0x00007fc8a5923000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a5923000,
.vm_end=(app_pc)0x00007fc8a5b23000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a5b23000,
.vm_end=(app_pc)0x00007fc8a5b25000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a5b25000,
.vm_end=(app_pc)0x00007fc8a5b26000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a5b26000,
.vm_end=(app_pc)0x00007fc8a5b27000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a5b27000,
.vm_end=(app_pc)0x00007fc8a5b2a000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc8a5b2a000,
.vm_end=(app_pc)0x00007fc8a5b2c000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff81f81000,
.vm_end=(app_pc)0x00007fff81fa3000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
};

fake_memquery_result results_1DF076EC[]={
{
.iter_result={.vm_start=(app_pc)0x00007f296051d000,
.vm_end=(app_pc)0x00007f2960521000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/tool.multiproc"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000002205000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2960521000,
.vm_end=(app_pc)0x00007f2960720000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2960720000,
.vm_end=(app_pc)0x00007f2960722000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/tool.multiproc"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2960722000,
.vm_end=(app_pc)0x00007f2962722000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2962722000,
.vm_end=(app_pc)0x00007f2962723000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2962723000,
.vm_end=(app_pc)0x00007f2962724000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f29664fc000,
.vm_end=(app_pc)0x00007f296651f000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f296651f000,
.vm_end=(app_pc)0x00007f296671f000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f296671f000,
.vm_end=(app_pc)0x00007f2966721000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2966721000,
.vm_end=(app_pc)0x00007f2966722000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2966722000,
.vm_end=(app_pc)0x00007f2966723000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2966723000,
.vm_end=(app_pc)0x00007f2966aba000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2966aba000,
.vm_end=(app_pc)0x00007f2966cba000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2966cba000,
.vm_end=(app_pc)0x00007f2966cff000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2966cff000,
.vm_end=(app_pc)0x00007f2966d44000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff25c71000,
.vm_end=(app_pc)0x00007fff25c93000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff25d35000,
.vm_end=(app_pc)0x00007fff25d38000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff25d38000,
.vm_end=(app_pc)0x00007fff25d3a000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_1F97E2CC[]={
{
.iter_result={.vm_start=(app_pc)0x00007f2c96e01000,
.vm_end=(app_pc)0x00007f2c97198000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2c97398000,
.vm_end=(app_pc)0x00007f2c973dd000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2c973dd000,
.vm_end=(app_pc)0x00007f2c97422000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc7ff30000,
.vm_end=(app_pc)0x00007ffc7ff52000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc7ff66000,
.vm_end=(app_pc)0x00007ffc7ff69000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc7ff69000,
.vm_end=(app_pc)0x00007ffc7ff6b000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_1FAA5159[]={
{
.iter_result={.vm_start=(app_pc)0x00007fc0639c6000,
.vm_end=(app_pc)0x00007fc063d5d000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc063f5d000,
.vm_end=(app_pc)0x00007fc063fa2000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fc063fa2000,
.vm_end=(app_pc)0x00007fc063fe7000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe113a1000,
.vm_end=(app_pc)0x00007ffe113c3000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe113e1000,
.vm_end=(app_pc)0x00007ffe113e4000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe113e4000,
.vm_end=(app_pc)0x00007ffe113e6000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_1FBF9080[]={
{
.iter_result={.vm_start=(app_pc)0x00007fa3e21c6000,
.vm_end=(app_pc)0x00007fa3e255d000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fa3e275d000,
.vm_end=(app_pc)0x00007fa3e27a2000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fa3e27a2000,
.vm_end=(app_pc)0x00007fa3e27e7000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe171a3000,
.vm_end=(app_pc)0x00007ffe171c5000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe171e3000,
.vm_end=(app_pc)0x00007ffe171e6000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe171e6000,
.vm_end=(app_pc)0x00007ffe171e8000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_1FD9E457[]={
{
.iter_result={.vm_start=(app_pc)0x00007fd8b97c0000,
.vm_end=(app_pc)0x00007fd8b9b57000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd8b9d57000,
.vm_end=(app_pc)0x00007fd8b9d9c000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd8b9d9c000,
.vm_end=(app_pc)0x00007fd8b9de1000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc26d50000,
.vm_end=(app_pc)0x00007ffc26d72000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc26dad000,
.vm_end=(app_pc)0x00007ffc26db0000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc26db0000,
.vm_end=(app_pc)0x00007ffc26db2000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_1FD9E794[]={
{
.iter_result={.vm_start=(app_pc)0x00007fd8b55ba000,
.vm_end=(app_pc)0x00007fd8b55bd000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/simple_app"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000205000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd8b55bd000,
.vm_end=(app_pc)0x00007fd8b57bd000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd8b57bd000,
.vm_end=(app_pc)0x00007fd8b57bf000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/simple_app"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd8b57bf000,
.vm_end=(app_pc)0x00007fd8b57c0000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd8b57c0000,
.vm_end=(app_pc)0x00007fd8b57c1000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd8b9599000,
.vm_end=(app_pc)0x00007fd8b95bc000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd8b95bc000,
.vm_end=(app_pc)0x00007fd8b97bc000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd8b97bc000,
.vm_end=(app_pc)0x00007fd8b97be000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd8b97be000,
.vm_end=(app_pc)0x00007fd8b97bf000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd8b97bf000,
.vm_end=(app_pc)0x00007fd8b97c0000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd8b97c0000,
.vm_end=(app_pc)0x00007fd8b9b57000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd8b9b57000,
.vm_end=(app_pc)0x00007fd8b9d57000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd8b9d57000,
.vm_end=(app_pc)0x00007fd8b9d9c000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd8b9d9c000,
.vm_end=(app_pc)0x00007fd8b9de1000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc26d50000,
.vm_end=(app_pc)0x00007ffc26d72000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc26dad000,
.vm_end=(app_pc)0x00007ffc26db0000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc26db0000,
.vm_end=(app_pc)0x00007ffc26db2000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_1FEE3BD0[]={
{
.iter_result={.vm_start=(app_pc)0x00007f6f020b1000,
.vm_end=(app_pc)0x00007f6f02448000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6f02648000,
.vm_end=(app_pc)0x00007f6f0268d000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6f0268d000,
.vm_end=(app_pc)0x00007f6f026d2000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff116a0000,
.vm_end=(app_pc)0x00007fff116c2000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff117d2000,
.vm_end=(app_pc)0x00007fff117d5000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff117d5000,
.vm_end=(app_pc)0x00007fff117d7000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_1FEE3F24[]={
{
.iter_result={.vm_start=(app_pc)0x00007f6efbeab000,
.vm_end=(app_pc)0x00007f6efbeaf000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/tool.multiproc"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000002205000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6efbeaf000,
.vm_end=(app_pc)0x00007f6efc0ae000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6efc0ae000,
.vm_end=(app_pc)0x00007f6efc0b0000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/tool.multiproc"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6efc0b0000,
.vm_end=(app_pc)0x00007f6efe0b0000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6efe0b0000,
.vm_end=(app_pc)0x00007f6efe0b1000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6efe0b1000,
.vm_end=(app_pc)0x00007f6efe0b2000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6f01e8a000,
.vm_end=(app_pc)0x00007f6f01ead000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6f01ead000,
.vm_end=(app_pc)0x00007f6f020ad000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6f020ad000,
.vm_end=(app_pc)0x00007f6f020af000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6f020af000,
.vm_end=(app_pc)0x00007f6f020b0000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6f020b0000,
.vm_end=(app_pc)0x00007f6f020b1000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6f020b1000,
.vm_end=(app_pc)0x00007f6f02448000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6f02448000,
.vm_end=(app_pc)0x00007f6f02648000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6f02648000,
.vm_end=(app_pc)0x00007f6f0268d000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f6f0268d000,
.vm_end=(app_pc)0x00007f6f026d2000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff116a0000,
.vm_end=(app_pc)0x00007fff116c2000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff117d2000,
.vm_end=(app_pc)0x00007fff117d5000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff117d5000,
.vm_end=(app_pc)0x00007fff117d7000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_2037B1C3[]={
{
.iter_result={.vm_start=(app_pc)0x00007fdf76752000,
.vm_end=(app_pc)0x00007fdf76ae9000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fdf76ce9000,
.vm_end=(app_pc)0x00007fdf76d2e000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fdf76d2e000,
.vm_end=(app_pc)0x00007fdf76d73000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffcbff87000,
.vm_end=(app_pc)0x00007ffcbffa9000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffcbffd2000,
.vm_end=(app_pc)0x00007ffcbffd5000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffcbffd5000,
.vm_end=(app_pc)0x00007ffcbffd7000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_204FBB37[]={
{
.iter_result={.vm_start=(app_pc)0x00007fa8296b4000,
.vm_end=(app_pc)0x00007fa829a4b000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fa829c4b000,
.vm_end=(app_pc)0x00007fa829c90000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fa829c90000,
.vm_end=(app_pc)0x00007fa829cd5000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc127f3000,
.vm_end=(app_pc)0x00007ffc12815000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc1290d000,
.vm_end=(app_pc)0x00007ffc12910000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc12910000,
.vm_end=(app_pc)0x00007ffc12912000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_20651BA2[]={
{
.iter_result={.vm_start=(app_pc)0x00007f856c0ff000,
.vm_end=(app_pc)0x00007f856c496000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f856c696000,
.vm_end=(app_pc)0x00007f856c6db000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f856c6db000,
.vm_end=(app_pc)0x00007f856c720000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff3aa64000,
.vm_end=(app_pc)0x00007fff3aa86000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff3abde000,
.vm_end=(app_pc)0x00007fff3abe1000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff3abe1000,
.vm_end=(app_pc)0x00007fff3abe3000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_207A0F64[]={
{
.iter_result={.vm_start=(app_pc)0x00007ff5ad5e9000,
.vm_end=(app_pc)0x00007ff5ad980000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff5adb80000,
.vm_end=(app_pc)0x00007ff5adbc5000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff5adbc5000,
.vm_end=(app_pc)0x00007ff5adc0a000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc98e6b000,
.vm_end=(app_pc)0x00007ffc98e8d000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc98fc7000,
.vm_end=(app_pc)0x00007ffc98fca000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc98fca000,
.vm_end=(app_pc)0x00007ffc98fcc000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_20DA5497[]={
{
.iter_result={.vm_start=(app_pc)0x0000562d6bf3d000,
.vm_end=(app_pc)0x0000562d6bf3e000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562d6bf3e000,
.vm_end=(app_pc)0x0000562d6bf44000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562d6bf44000,
.vm_end=(app_pc)0x0000562d6bf46000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562d6bf46000,
.vm_end=(app_pc)0x0000562d6bf58000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562d6bf58000,
.vm_end=(app_pc)0x0000562d6bf66000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562d6bf66000,
.vm_end=(app_pc)0x0000562d6bf67000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562d6bf67000,
.vm_end=(app_pc)0x0000562d6bf6e000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562d6bf6e000,
.vm_end=(app_pc)0x0000562d6bf6f000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562d6bf6f000,
.vm_end=(app_pc)0x0000562d8bf3e000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562d8bf3e000,
.vm_end=(app_pc)0x0000562d8c39e000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_replace"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x00000000006fe000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562d8c59d000,
.vm_end=(app_pc)0x0000562d8c5c6000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_replace"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562d8c5c6000,
.vm_end=(app_pc)0x0000562d8c5e5000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_replace"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562d8c5e5000,
.vm_end=(app_pc)0x0000562d8c63c000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562d8d835000,
.vm_end=(app_pc)0x0000562d8d867000,
.prot=3,
.comment="[heap]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd11ed4000,
.vm_end=(app_pc)0x00007fbd12069000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12069000,
.vm_end=(app_pc)0x00007fbd12269000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12269000,
.vm_end=(app_pc)0x00007fbd1226d000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd1226d000,
.vm_end=(app_pc)0x00007fbd1226f000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd1226f000,
.vm_end=(app_pc)0x00007fbd12273000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12273000,
.vm_end=(app_pc)0x00007fbd1228a000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000218000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd1228a000,
.vm_end=(app_pc)0x00007fbd12489000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12489000,
.vm_end=(app_pc)0x00007fbd1248a000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd1248a000,
.vm_end=(app_pc)0x00007fbd1248b000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd1248b000,
.vm_end=(app_pc)0x00007fbd1258e000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000304000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd1258e000,
.vm_end=(app_pc)0x00007fbd1278d000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd1278d000,
.vm_end=(app_pc)0x00007fbd1278e000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd1278e000,
.vm_end=(app_pc)0x00007fbd1278f000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd1278f000,
.vm_end=(app_pc)0x00007fbd12905000,
.prot=5,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000385000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12905000,
.vm_end=(app_pc)0x00007fbd12b05000,
.prot=0,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12b05000,
.vm_end=(app_pc)0x00007fbd12b0f000,
.prot=1,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12b0f000,
.vm_end=(app_pc)0x00007fbd12b11000,
.prot=3,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12b11000,
.vm_end=(app_pc)0x00007fbd12b14000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12b14000,
.vm_end=(app_pc)0x00007fbd12b2d000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libz.so.1.2.8"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000021a000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12b2d000,
.vm_end=(app_pc)0x00007fbd12d2c000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libz.so.1.2.8"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12d2c000,
.vm_end=(app_pc)0x00007fbd12d2d000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libz.so.1.2.8"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12d2d000,
.vm_end=(app_pc)0x00007fbd12d2e000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libz.so.1.2.8"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12d2e000,
.vm_end=(app_pc)0x00007fbd12d46000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000021d000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12d46000,
.vm_end=(app_pc)0x00007fbd12f45000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12f45000,
.vm_end=(app_pc)0x00007fbd12f46000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12f46000,
.vm_end=(app_pc)0x00007fbd12f47000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12f47000,
.vm_end=(app_pc)0x00007fbd12f4b000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12f4b000,
.vm_end=(app_pc)0x00007fbd12f4e000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd12f4e000,
.vm_end=(app_pc)0x00007fbd1314d000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd1314d000,
.vm_end=(app_pc)0x00007fbd1314e000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd1314e000,
.vm_end=(app_pc)0x00007fbd1314f000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd1314f000,
.vm_end=(app_pc)0x00007fbd13172000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd1333f000,
.vm_end=(app_pc)0x00007fbd13345000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd1336f000,
.vm_end=(app_pc)0x00007fbd13372000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd13372000,
.vm_end=(app_pc)0x00007fbd13373000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd13373000,
.vm_end=(app_pc)0x00007fbd13374000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fbd13374000,
.vm_end=(app_pc)0x00007fbd13375000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffd9abe9000,
.vm_end=(app_pc)0x00007ffd9ac0b000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffd9acaa000,
.vm_end=(app_pc)0x00007ffd9acad000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffd9acad000,
.vm_end=(app_pc)0x00007ffd9acaf000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_2173E505[]={
{
.iter_result={.vm_start=(app_pc)0x0000562415a62000,
.vm_end=(app_pc)0x0000562415a63000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562415a63000,
.vm_end=(app_pc)0x0000562415a69000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562415a69000,
.vm_end=(app_pc)0x0000562415a6b000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562415a6b000,
.vm_end=(app_pc)0x0000562415a7d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562415a7d000,
.vm_end=(app_pc)0x0000562415a8b000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562415a8b000,
.vm_end=(app_pc)0x0000562415a8c000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562415a8c000,
.vm_end=(app_pc)0x0000562415a93000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562415a93000,
.vm_end=(app_pc)0x0000562415a94000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562415a94000,
.vm_end=(app_pc)0x0000562435a63000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562435a63000,
.vm_end=(app_pc)0x0000562435a64000,
.prot=5,
.comment=""},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x00000000006cf000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562435a64000,
.vm_end=(app_pc)0x0000562435a67000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_maps"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562435a67000,
.vm_end=(app_pc)0x0000562435a68000,
.prot=5,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562435a68000,
.vm_end=(app_pc)0x0000562435a6b000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_maps"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562435a6b000,
.vm_end=(app_pc)0x0000562435a6c000,
.prot=5,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562435a6c000,
.vm_end=(app_pc)0x0000562435e94000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_maps"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000562436093000,
.vm_end=(app_pc)0x00005624360bc000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_maps"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00005624360bc000,
.vm_end=(app_pc)0x00005624360db000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_maps"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00005624360db000,
.vm_end=(app_pc)0x0000562436132000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000056243729a000,
.vm_end=(app_pc)0x00005624372cc000,
.prot=3,
.comment="[heap]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952b91d000,
.vm_end=(app_pc)0x00007f952bab2000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952bab2000,
.vm_end=(app_pc)0x00007f952bcb2000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952bcb2000,
.vm_end=(app_pc)0x00007f952bcb6000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952bcb6000,
.vm_end=(app_pc)0x00007f952bcb8000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952bcb8000,
.vm_end=(app_pc)0x00007f952bcbc000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952bcbc000,
.vm_end=(app_pc)0x00007f952bcd3000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000218000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952bcd3000,
.vm_end=(app_pc)0x00007f952bed2000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952bed2000,
.vm_end=(app_pc)0x00007f952bed3000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952bed3000,
.vm_end=(app_pc)0x00007f952bed4000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952bed4000,
.vm_end=(app_pc)0x00007f952bfd7000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000304000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952bfd7000,
.vm_end=(app_pc)0x00007f952c1d6000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c1d6000,
.vm_end=(app_pc)0x00007f952c1d7000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c1d7000,
.vm_end=(app_pc)0x00007f952c1d8000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c1d8000,
.vm_end=(app_pc)0x00007f952c34e000,
.prot=5,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000385000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c34e000,
.vm_end=(app_pc)0x00007f952c54e000,
.prot=0,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c54e000,
.vm_end=(app_pc)0x00007f952c558000,
.prot=1,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c558000,
.vm_end=(app_pc)0x00007f952c55a000,
.prot=3,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c55a000,
.vm_end=(app_pc)0x00007f952c55d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c55d000,
.vm_end=(app_pc)0x00007f952c560000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c560000,
.vm_end=(app_pc)0x00007f952c75f000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c75f000,
.vm_end=(app_pc)0x00007f952c760000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c760000,
.vm_end=(app_pc)0x00007f952c761000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c761000,
.vm_end=(app_pc)0x00007f952c784000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c952000,
.vm_end=(app_pc)0x00007f952c957000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c981000,
.vm_end=(app_pc)0x00007f952c984000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c984000,
.vm_end=(app_pc)0x00007f952c985000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c985000,
.vm_end=(app_pc)0x00007f952c986000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f952c986000,
.vm_end=(app_pc)0x00007f952c987000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc169b9000,
.vm_end=(app_pc)0x00007ffc169db000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc169e6000,
.vm_end=(app_pc)0x00007ffc169e9000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc169e9000,
.vm_end=(app_pc)0x00007ffc169eb000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_21B5A396[]={
{
.iter_result={.vm_start=(app_pc)0x000055ae3bba8000,
.vm_end=(app_pc)0x000055ae3bfd9000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threads"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x00000000006cf000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae3c1d8000,
.vm_end=(app_pc)0x000055ae3c201000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threads"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae3c201000,
.vm_end=(app_pc)0x000055ae3c220000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threads"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae3c220000,
.vm_end=(app_pc)0x000055ae3c277000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae3c875000,
.vm_end=(app_pc)0x000055ae3c8a7000,
.prot=3,
.comment="[heap]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e80000000,
.vm_end=(app_pc)0x00007f2e80025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e80025000,
.vm_end=(app_pc)0x00007f2e84000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e88000000,
.vm_end=(app_pc)0x00007f2e88025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e88025000,
.vm_end=(app_pc)0x00007f2e8c000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e90000000,
.vm_end=(app_pc)0x00007f2e90025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e90025000,
.vm_end=(app_pc)0x00007f2e94000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e94000000,
.vm_end=(app_pc)0x00007f2e94025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e94025000,
.vm_end=(app_pc)0x00007f2e98000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e98000000,
.vm_end=(app_pc)0x00007f2e98025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e98025000,
.vm_end=(app_pc)0x00007f2e9c000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e9c000000,
.vm_end=(app_pc)0x00007f2e9c025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e9c025000,
.vm_end=(app_pc)0x00007f2ea0000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea0000000,
.vm_end=(app_pc)0x00007f2ea0025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea0025000,
.vm_end=(app_pc)0x00007f2ea4000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea5ffc000,
.vm_end=(app_pc)0x00007f2ea5ffd000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea5ffd000,
.vm_end=(app_pc)0x00007f2ea67fd000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea67fd000,
.vm_end=(app_pc)0x00007f2ea67fe000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea67fe000,
.vm_end=(app_pc)0x00007f2ea6ffe000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea6ffe000,
.vm_end=(app_pc)0x00007f2ea6fff000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea6fff000,
.vm_end=(app_pc)0x00007f2ea77ff000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea77ff000,
.vm_end=(app_pc)0x00007f2ea7800000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea7800000,
.vm_end=(app_pc)0x00007f2ea8000000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea8000000,
.vm_end=(app_pc)0x00007f2ea8025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea8025000,
.vm_end=(app_pc)0x00007f2eac000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eac6d2000,
.vm_end=(app_pc)0x00007f2eac6d3000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eac6d3000,
.vm_end=(app_pc)0x00007f2eaced3000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaced3000,
.vm_end=(app_pc)0x00007f2eaced4000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaced4000,
.vm_end=(app_pc)0x00007f2ead6d4000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ead6d4000,
.vm_end=(app_pc)0x00007f2ead6d5000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ead6d5000,
.vm_end=(app_pc)0x00007f2eaded5000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaded5000,
.vm_end=(app_pc)0x00007f2eaded6000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaded6000,
.vm_end=(app_pc)0x00007f2eae6d6000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eae6d6000,
.vm_end=(app_pc)0x00007f2eae86b000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eae86b000,
.vm_end=(app_pc)0x00007f2eaea6b000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaea6b000,
.vm_end=(app_pc)0x00007f2eaea6f000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaea6f000,
.vm_end=(app_pc)0x00007f2eaea71000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaea71000,
.vm_end=(app_pc)0x00007f2eaea75000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaea75000,
.vm_end=(app_pc)0x00007f2eaea8c000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000218000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaea8c000,
.vm_end=(app_pc)0x00007f2eaec8b000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaec8b000,
.vm_end=(app_pc)0x00007f2eaec8c000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaec8c000,
.vm_end=(app_pc)0x00007f2eaec8d000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaec8d000,
.vm_end=(app_pc)0x00007f2eaed90000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000304000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaed90000,
.vm_end=(app_pc)0x00007f2eaef8f000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaef8f000,
.vm_end=(app_pc)0x00007f2eaef90000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaef90000,
.vm_end=(app_pc)0x00007f2eaef91000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaef91000,
.vm_end=(app_pc)0x00007f2eaf107000,
.prot=5,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000385000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf107000,
.vm_end=(app_pc)0x00007f2eaf307000,
.prot=0,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf307000,
.vm_end=(app_pc)0x00007f2eaf311000,
.prot=1,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf311000,
.vm_end=(app_pc)0x00007f2eaf313000,
.prot=3,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf313000,
.vm_end=(app_pc)0x00007f2eaf316000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf316000,
.vm_end=(app_pc)0x00007f2eaf319000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf319000,
.vm_end=(app_pc)0x00007f2eaf518000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf518000,
.vm_end=(app_pc)0x00007f2eaf519000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf519000,
.vm_end=(app_pc)0x00007f2eaf51a000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf51a000,
.vm_end=(app_pc)0x00007f2eaf532000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000021d000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf532000,
.vm_end=(app_pc)0x00007f2eaf731000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf731000,
.vm_end=(app_pc)0x00007f2eaf732000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf732000,
.vm_end=(app_pc)0x00007f2eaf733000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf733000,
.vm_end=(app_pc)0x00007f2eaf737000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf737000,
.vm_end=(app_pc)0x00007f2eaf75a000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf928000,
.vm_end=(app_pc)0x00007f2eaf92d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf957000,
.vm_end=(app_pc)0x00007f2eaf95a000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf95a000,
.vm_end=(app_pc)0x00007f2eaf95b000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf95b000,
.vm_end=(app_pc)0x00007f2eaf95c000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf95c000,
.vm_end=(app_pc)0x00007f2eaf95d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffc1640000,
.vm_end=(app_pc)0x00007fffc1662000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffc16c6000,
.vm_end=(app_pc)0x00007fffc16c9000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffc16c9000,
.vm_end=(app_pc)0x00007fffc16cb000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_21B5B600[]={
{
.iter_result={.vm_start=(app_pc)0x000055ae1bba7000,
.vm_end=(app_pc)0x000055ae1bba8000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae1bba8000,
.vm_end=(app_pc)0x000055ae1bbae000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae1bbae000,
.vm_end=(app_pc)0x000055ae1bbb0000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae1bbb0000,
.vm_end=(app_pc)0x000055ae1bbc2000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae1bbc2000,
.vm_end=(app_pc)0x000055ae1bbd0000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae1bbd0000,
.vm_end=(app_pc)0x000055ae1bbd1000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae1bbd1000,
.vm_end=(app_pc)0x000055ae1bbd8000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae1bbd8000,
.vm_end=(app_pc)0x000055ae1bbd9000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae1bbd9000,
.vm_end=(app_pc)0x000055ae3bba8000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae3bba8000,
.vm_end=(app_pc)0x000055ae3bfd9000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threads"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x00000000006cf000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae3c1d8000,
.vm_end=(app_pc)0x000055ae3c201000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threads"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae3c201000,
.vm_end=(app_pc)0x000055ae3c220000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threads"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae3c220000,
.vm_end=(app_pc)0x000055ae3c277000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae3c875000,
.vm_end=(app_pc)0x000055ae3c8a7000,
.prot=3,
.comment="[heap]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e80000000,
.vm_end=(app_pc)0x00007f2e80025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e80025000,
.vm_end=(app_pc)0x00007f2e84000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e88000000,
.vm_end=(app_pc)0x00007f2e88025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e88025000,
.vm_end=(app_pc)0x00007f2e8c000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e90000000,
.vm_end=(app_pc)0x00007f2e90025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e90025000,
.vm_end=(app_pc)0x00007f2e94000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e94000000,
.vm_end=(app_pc)0x00007f2e94025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e94025000,
.vm_end=(app_pc)0x00007f2e98000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e98000000,
.vm_end=(app_pc)0x00007f2e98025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e98025000,
.vm_end=(app_pc)0x00007f2e9c000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e9c000000,
.vm_end=(app_pc)0x00007f2e9c025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e9c025000,
.vm_end=(app_pc)0x00007f2ea0000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea0000000,
.vm_end=(app_pc)0x00007f2ea0025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea0025000,
.vm_end=(app_pc)0x00007f2ea4000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea5ffc000,
.vm_end=(app_pc)0x00007f2ea5ffd000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea5ffd000,
.vm_end=(app_pc)0x00007f2ea67fd000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea67fd000,
.vm_end=(app_pc)0x00007f2ea67fe000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea67fe000,
.vm_end=(app_pc)0x00007f2ea6ffe000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea6ffe000,
.vm_end=(app_pc)0x00007f2ea6fff000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea6fff000,
.vm_end=(app_pc)0x00007f2ea77ff000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea77ff000,
.vm_end=(app_pc)0x00007f2ea7800000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea7800000,
.vm_end=(app_pc)0x00007f2ea8000000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea8000000,
.vm_end=(app_pc)0x00007f2ea8025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea8025000,
.vm_end=(app_pc)0x00007f2eac000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eac6d2000,
.vm_end=(app_pc)0x00007f2eac6d3000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eac6d3000,
.vm_end=(app_pc)0x00007f2eaced3000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaced3000,
.vm_end=(app_pc)0x00007f2eaced4000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaced4000,
.vm_end=(app_pc)0x00007f2ead6d4000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ead6d4000,
.vm_end=(app_pc)0x00007f2ead6d5000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ead6d5000,
.vm_end=(app_pc)0x00007f2eaded5000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaded5000,
.vm_end=(app_pc)0x00007f2eaded6000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaded6000,
.vm_end=(app_pc)0x00007f2eae6d6000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eae6d6000,
.vm_end=(app_pc)0x00007f2eae86b000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eae86b000,
.vm_end=(app_pc)0x00007f2eaea6b000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaea6b000,
.vm_end=(app_pc)0x00007f2eaea6f000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaea6f000,
.vm_end=(app_pc)0x00007f2eaea71000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaea71000,
.vm_end=(app_pc)0x00007f2eaea75000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaea75000,
.vm_end=(app_pc)0x00007f2eaea8c000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000218000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaea8c000,
.vm_end=(app_pc)0x00007f2eaec8b000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaec8b000,
.vm_end=(app_pc)0x00007f2eaec8c000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaec8c000,
.vm_end=(app_pc)0x00007f2eaec8d000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaec8d000,
.vm_end=(app_pc)0x00007f2eaed90000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000304000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaed90000,
.vm_end=(app_pc)0x00007f2eaef8f000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaef8f000,
.vm_end=(app_pc)0x00007f2eaef90000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaef90000,
.vm_end=(app_pc)0x00007f2eaef91000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaef91000,
.vm_end=(app_pc)0x00007f2eaf107000,
.prot=5,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000385000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf107000,
.vm_end=(app_pc)0x00007f2eaf307000,
.prot=0,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf307000,
.vm_end=(app_pc)0x00007f2eaf311000,
.prot=1,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf311000,
.vm_end=(app_pc)0x00007f2eaf313000,
.prot=3,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf313000,
.vm_end=(app_pc)0x00007f2eaf316000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf316000,
.vm_end=(app_pc)0x00007f2eaf319000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf319000,
.vm_end=(app_pc)0x00007f2eaf518000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf518000,
.vm_end=(app_pc)0x00007f2eaf519000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf519000,
.vm_end=(app_pc)0x00007f2eaf51a000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf51a000,
.vm_end=(app_pc)0x00007f2eaf532000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000021d000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf532000,
.vm_end=(app_pc)0x00007f2eaf731000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf731000,
.vm_end=(app_pc)0x00007f2eaf732000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf732000,
.vm_end=(app_pc)0x00007f2eaf733000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf733000,
.vm_end=(app_pc)0x00007f2eaf737000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf737000,
.vm_end=(app_pc)0x00007f2eaf75a000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf928000,
.vm_end=(app_pc)0x00007f2eaf92d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf957000,
.vm_end=(app_pc)0x00007f2eaf95a000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf95a000,
.vm_end=(app_pc)0x00007f2eaf95b000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf95b000,
.vm_end=(app_pc)0x00007f2eaf95c000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf95c000,
.vm_end=(app_pc)0x00007f2eaf95d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffc1640000,
.vm_end=(app_pc)0x00007fffc1662000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffc16c6000,
.vm_end=(app_pc)0x00007fffc16c9000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffc16c9000,
.vm_end=(app_pc)0x00007fffc16cb000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_21DEA8CE[]={
{
.iter_result={.vm_start=(app_pc)0x000055ae1bba4000,
.vm_end=(app_pc)0x000055ae3bba8000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae3bba8000,
.vm_end=(app_pc)0x000055ae3bfd9000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threads"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x00000000006cf000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae3c1d8000,
.vm_end=(app_pc)0x000055ae3c201000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threads"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae3c201000,
.vm_end=(app_pc)0x000055ae3c220000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threads"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae3c220000,
.vm_end=(app_pc)0x000055ae3c277000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055ae3c875000,
.vm_end=(app_pc)0x000055ae3c8a7000,
.prot=3,
.comment="[heap]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e80000000,
.vm_end=(app_pc)0x00007f2e80025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e80025000,
.vm_end=(app_pc)0x00007f2e84000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e88000000,
.vm_end=(app_pc)0x00007f2e88025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e88025000,
.vm_end=(app_pc)0x00007f2e8c000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e90000000,
.vm_end=(app_pc)0x00007f2e90025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e90025000,
.vm_end=(app_pc)0x00007f2e94000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e94000000,
.vm_end=(app_pc)0x00007f2e94025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e94025000,
.vm_end=(app_pc)0x00007f2e98000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e98000000,
.vm_end=(app_pc)0x00007f2e98025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e98025000,
.vm_end=(app_pc)0x00007f2e9c000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e9c000000,
.vm_end=(app_pc)0x00007f2e9c025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2e9c025000,
.vm_end=(app_pc)0x00007f2ea0000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea0000000,
.vm_end=(app_pc)0x00007f2ea0025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea0025000,
.vm_end=(app_pc)0x00007f2ea4000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea5ffc000,
.vm_end=(app_pc)0x00007f2ea5ffd000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea5ffd000,
.vm_end=(app_pc)0x00007f2ea67fd000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea67fd000,
.vm_end=(app_pc)0x00007f2ea67fe000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea67fe000,
.vm_end=(app_pc)0x00007f2ea6ffe000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea6ffe000,
.vm_end=(app_pc)0x00007f2ea6fff000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea6fff000,
.vm_end=(app_pc)0x00007f2ea77ff000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea77ff000,
.vm_end=(app_pc)0x00007f2ea7800000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea7800000,
.vm_end=(app_pc)0x00007f2ea8000000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea8000000,
.vm_end=(app_pc)0x00007f2ea8025000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ea8025000,
.vm_end=(app_pc)0x00007f2eac000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eac6d2000,
.vm_end=(app_pc)0x00007f2eac6d3000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eac6d3000,
.vm_end=(app_pc)0x00007f2eaced3000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaced3000,
.vm_end=(app_pc)0x00007f2eaced4000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaced4000,
.vm_end=(app_pc)0x00007f2ead6d4000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ead6d4000,
.vm_end=(app_pc)0x00007f2ead6d5000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2ead6d5000,
.vm_end=(app_pc)0x00007f2eaded5000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaded5000,
.vm_end=(app_pc)0x00007f2eaded6000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaded6000,
.vm_end=(app_pc)0x00007f2eae6d6000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eae6d6000,
.vm_end=(app_pc)0x00007f2eae86b000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eae86b000,
.vm_end=(app_pc)0x00007f2eaea6b000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaea6b000,
.vm_end=(app_pc)0x00007f2eaea6f000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaea6f000,
.vm_end=(app_pc)0x00007f2eaea71000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaea71000,
.vm_end=(app_pc)0x00007f2eaea75000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaea75000,
.vm_end=(app_pc)0x00007f2eaea8c000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000218000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaea8c000,
.vm_end=(app_pc)0x00007f2eaec8b000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaec8b000,
.vm_end=(app_pc)0x00007f2eaec8c000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaec8c000,
.vm_end=(app_pc)0x00007f2eaec8d000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaec8d000,
.vm_end=(app_pc)0x00007f2eaed90000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000304000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaed90000,
.vm_end=(app_pc)0x00007f2eaef8f000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaef8f000,
.vm_end=(app_pc)0x00007f2eaef90000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaef90000,
.vm_end=(app_pc)0x00007f2eaef91000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaef91000,
.vm_end=(app_pc)0x00007f2eaf107000,
.prot=5,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000385000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf107000,
.vm_end=(app_pc)0x00007f2eaf307000,
.prot=0,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf307000,
.vm_end=(app_pc)0x00007f2eaf311000,
.prot=1,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf311000,
.vm_end=(app_pc)0x00007f2eaf313000,
.prot=3,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf313000,
.vm_end=(app_pc)0x00007f2eaf316000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf316000,
.vm_end=(app_pc)0x00007f2eaf319000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf319000,
.vm_end=(app_pc)0x00007f2eaf518000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf518000,
.vm_end=(app_pc)0x00007f2eaf519000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf519000,
.vm_end=(app_pc)0x00007f2eaf51a000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf51a000,
.vm_end=(app_pc)0x00007f2eaf532000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000021d000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf532000,
.vm_end=(app_pc)0x00007f2eaf731000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf731000,
.vm_end=(app_pc)0x00007f2eaf732000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf732000,
.vm_end=(app_pc)0x00007f2eaf733000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf733000,
.vm_end=(app_pc)0x00007f2eaf737000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf737000,
.vm_end=(app_pc)0x00007f2eaf75a000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf928000,
.vm_end=(app_pc)0x00007f2eaf92d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf957000,
.vm_end=(app_pc)0x00007f2eaf95a000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf95a000,
.vm_end=(app_pc)0x00007f2eaf95b000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf95b000,
.vm_end=(app_pc)0x00007f2eaf95c000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2eaf95c000,
.vm_end=(app_pc)0x00007f2eaf95d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffc1640000,
.vm_end=(app_pc)0x00007fffc1662000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffc16c6000,
.vm_end=(app_pc)0x00007fffc16c9000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffc16c9000,
.vm_end=(app_pc)0x00007fffc16cb000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_221F0148[]={
{
.iter_result={.vm_start=(app_pc)0x000055b3ea80c000,
.vm_end=(app_pc)0x000055b40a80d000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b40a80d000,
.vm_end=(app_pc)0x000055b40ac3e000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threadfilter"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x00000000006cf000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b40ae3d000,
.vm_end=(app_pc)0x000055b40ae66000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threadfilter"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b40ae66000,
.vm_end=(app_pc)0x000055b40ae85000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threadfilter"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b40ae85000,
.vm_end=(app_pc)0x000055b40aedc000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b40b1bb000,
.vm_end=(app_pc)0x000055b40b1ed000,
.prot=3,
.comment="[heap]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8110000000,
.vm_end=(app_pc)0x00007f8110021000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8110021000,
.vm_end=(app_pc)0x00007f8114000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8117015000,
.vm_end=(app_pc)0x00007f8117016000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8117016000,
.vm_end=(app_pc)0x00007f8117816000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8117816000,
.vm_end=(app_pc)0x00007f8117817000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8117817000,
.vm_end=(app_pc)0x00007f8118017000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8118017000,
.vm_end=(app_pc)0x00007f8118018000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8118018000,
.vm_end=(app_pc)0x00007f8118818000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8118818000,
.vm_end=(app_pc)0x00007f8118819000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8118819000,
.vm_end=(app_pc)0x00007f8119019000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8119019000,
.vm_end=(app_pc)0x00007f811901a000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811901a000,
.vm_end=(app_pc)0x00007f811981a000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811981a000,
.vm_end=(app_pc)0x00007f811981b000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811981b000,
.vm_end=(app_pc)0x00007f811a01b000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811a01b000,
.vm_end=(app_pc)0x00007f811a01c000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811a01c000,
.vm_end=(app_pc)0x00007f811a81c000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811a81c000,
.vm_end=(app_pc)0x00007f811a81d000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811a81d000,
.vm_end=(app_pc)0x00007f811b01d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b01d000,
.vm_end=(app_pc)0x00007f811b1b2000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b1b2000,
.vm_end=(app_pc)0x00007f811b3b2000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b3b2000,
.vm_end=(app_pc)0x00007f811b3b6000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b3b6000,
.vm_end=(app_pc)0x00007f811b3b8000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b3b8000,
.vm_end=(app_pc)0x00007f811b3bc000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b3bc000,
.vm_end=(app_pc)0x00007f811b3d3000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000218000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b3d3000,
.vm_end=(app_pc)0x00007f811b5d2000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b5d2000,
.vm_end=(app_pc)0x00007f811b5d3000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b5d3000,
.vm_end=(app_pc)0x00007f811b5d4000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b5d4000,
.vm_end=(app_pc)0x00007f811b6d7000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000304000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b6d7000,
.vm_end=(app_pc)0x00007f811b8d6000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b8d6000,
.vm_end=(app_pc)0x00007f811b8d7000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b8d7000,
.vm_end=(app_pc)0x00007f811b8d8000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b8d8000,
.vm_end=(app_pc)0x00007f811ba4e000,
.prot=5,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000385000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811ba4e000,
.vm_end=(app_pc)0x00007f811bc4e000,
.prot=0,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811bc4e000,
.vm_end=(app_pc)0x00007f811bc58000,
.prot=1,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811bc58000,
.vm_end=(app_pc)0x00007f811bc5a000,
.prot=3,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811bc5a000,
.vm_end=(app_pc)0x00007f811bc5d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811bc5d000,
.vm_end=(app_pc)0x00007f811bc60000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811bc60000,
.vm_end=(app_pc)0x00007f811be5f000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811be5f000,
.vm_end=(app_pc)0x00007f811be60000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811be60000,
.vm_end=(app_pc)0x00007f811be61000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811be61000,
.vm_end=(app_pc)0x00007f811be79000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000021d000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811be79000,
.vm_end=(app_pc)0x00007f811c078000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c078000,
.vm_end=(app_pc)0x00007f811c079000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c079000,
.vm_end=(app_pc)0x00007f811c07a000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c07a000,
.vm_end=(app_pc)0x00007f811c07e000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c07e000,
.vm_end=(app_pc)0x00007f811c0a1000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c26f000,
.vm_end=(app_pc)0x00007f811c274000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c29e000,
.vm_end=(app_pc)0x00007f811c2a1000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c2a1000,
.vm_end=(app_pc)0x00007f811c2a2000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c2a2000,
.vm_end=(app_pc)0x00007f811c2a3000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c2a3000,
.vm_end=(app_pc)0x00007f811c2a4000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe87422000,
.vm_end=(app_pc)0x00007ffe87444000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe875d1000,
.vm_end=(app_pc)0x00007ffe875d4000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe875d4000,
.vm_end=(app_pc)0x00007ffe875d6000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_221F0C7F[]={
{
.iter_result={.vm_start=(app_pc)0x000055b3ea80c000,
.vm_end=(app_pc)0x000055b3ea80d000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b3ea80d000,
.vm_end=(app_pc)0x000055b3ea813000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b3ea813000,
.vm_end=(app_pc)0x000055b3ea815000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b3ea815000,
.vm_end=(app_pc)0x000055b3ea827000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b3ea827000,
.vm_end=(app_pc)0x000055b3ea835000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b3ea835000,
.vm_end=(app_pc)0x000055b3ea836000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b3ea836000,
.vm_end=(app_pc)0x000055b3ea83d000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b3ea83d000,
.vm_end=(app_pc)0x000055b3ea83e000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b3ea83e000,
.vm_end=(app_pc)0x000055b40a80d000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b40a80d000,
.vm_end=(app_pc)0x000055b40ac3e000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threadfilter"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x00000000006cf000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b40ae3d000,
.vm_end=(app_pc)0x000055b40ae66000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threadfilter"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b40ae66000,
.vm_end=(app_pc)0x000055b40ae85000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threadfilter"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b40ae85000,
.vm_end=(app_pc)0x000055b40aedc000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055b40b1bb000,
.vm_end=(app_pc)0x000055b40b1ed000,
.prot=3,
.comment="[heap]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8110000000,
.vm_end=(app_pc)0x00007f8110021000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8110021000,
.vm_end=(app_pc)0x00007f8114000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8117015000,
.vm_end=(app_pc)0x00007f8117016000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8117016000,
.vm_end=(app_pc)0x00007f8117816000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8117816000,
.vm_end=(app_pc)0x00007f8117817000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8117817000,
.vm_end=(app_pc)0x00007f8118017000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8118017000,
.vm_end=(app_pc)0x00007f8118018000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8118018000,
.vm_end=(app_pc)0x00007f8118818000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8118818000,
.vm_end=(app_pc)0x00007f8118819000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8118819000,
.vm_end=(app_pc)0x00007f8119019000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f8119019000,
.vm_end=(app_pc)0x00007f811901a000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811901a000,
.vm_end=(app_pc)0x00007f811981a000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811981a000,
.vm_end=(app_pc)0x00007f811981b000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811981b000,
.vm_end=(app_pc)0x00007f811a01b000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811a01b000,
.vm_end=(app_pc)0x00007f811a01c000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811a01c000,
.vm_end=(app_pc)0x00007f811a81c000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811a81c000,
.vm_end=(app_pc)0x00007f811a81d000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811a81d000,
.vm_end=(app_pc)0x00007f811b01d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b01d000,
.vm_end=(app_pc)0x00007f811b1b2000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b1b2000,
.vm_end=(app_pc)0x00007f811b3b2000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b3b2000,
.vm_end=(app_pc)0x00007f811b3b6000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b3b6000,
.vm_end=(app_pc)0x00007f811b3b8000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b3b8000,
.vm_end=(app_pc)0x00007f811b3bc000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b3bc000,
.vm_end=(app_pc)0x00007f811b3d3000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000218000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b3d3000,
.vm_end=(app_pc)0x00007f811b5d2000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b5d2000,
.vm_end=(app_pc)0x00007f811b5d3000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b5d3000,
.vm_end=(app_pc)0x00007f811b5d4000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b5d4000,
.vm_end=(app_pc)0x00007f811b6d7000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000304000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b6d7000,
.vm_end=(app_pc)0x00007f811b8d6000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b8d6000,
.vm_end=(app_pc)0x00007f811b8d7000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b8d7000,
.vm_end=(app_pc)0x00007f811b8d8000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811b8d8000,
.vm_end=(app_pc)0x00007f811ba4e000,
.prot=5,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000385000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811ba4e000,
.vm_end=(app_pc)0x00007f811bc4e000,
.prot=0,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811bc4e000,
.vm_end=(app_pc)0x00007f811bc58000,
.prot=1,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811bc58000,
.vm_end=(app_pc)0x00007f811bc5a000,
.prot=3,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811bc5a000,
.vm_end=(app_pc)0x00007f811bc5d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811bc5d000,
.vm_end=(app_pc)0x00007f811bc60000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811bc60000,
.vm_end=(app_pc)0x00007f811be5f000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811be5f000,
.vm_end=(app_pc)0x00007f811be60000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811be60000,
.vm_end=(app_pc)0x00007f811be61000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811be61000,
.vm_end=(app_pc)0x00007f811be79000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000021d000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811be79000,
.vm_end=(app_pc)0x00007f811c078000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c078000,
.vm_end=(app_pc)0x00007f811c079000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c079000,
.vm_end=(app_pc)0x00007f811c07a000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c07a000,
.vm_end=(app_pc)0x00007f811c07e000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c07e000,
.vm_end=(app_pc)0x00007f811c0a1000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c26f000,
.vm_end=(app_pc)0x00007f811c274000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c29e000,
.vm_end=(app_pc)0x00007f811c2a1000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c2a1000,
.vm_end=(app_pc)0x00007f811c2a2000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c2a2000,
.vm_end=(app_pc)0x00007f811c2a3000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f811c2a3000,
.vm_end=(app_pc)0x00007f811c2a4000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe87422000,
.vm_end=(app_pc)0x00007ffe87444000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe875d1000,
.vm_end=(app_pc)0x00007ffe875d4000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe875d4000,
.vm_end=(app_pc)0x00007ffe875d6000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_225A9FE2[]={
{
.iter_result={.vm_start=(app_pc)0x000056212c2fd000,
.vm_end=(app_pc)0x000056212c72e000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threadfilter"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x00000000006cf000,
},
{
.iter_result={.vm_start=(app_pc)0x000056212c92d000,
.vm_end=(app_pc)0x000056212c956000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threadfilter"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000056212c956000,
.vm_end=(app_pc)0x000056212c975000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"clients/bin64/tool.drcacheoff.burst_threadfilter"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000056212c975000,
.vm_end=(app_pc)0x000056212c9cc000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000056212cce9000,
.vm_end=(app_pc)0x000056212cd1b000,
.prot=3,
.comment="[heap]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7bc000000,
.vm_end=(app_pc)0x00007fe7bc021000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7bc021000,
.vm_end=(app_pc)0x00007fe7c0000000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c37a6000,
.vm_end=(app_pc)0x00007fe7c37a7000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c37a7000,
.vm_end=(app_pc)0x00007fe7c3fa7000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c3fa7000,
.vm_end=(app_pc)0x00007fe7c3fa8000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c3fa8000,
.vm_end=(app_pc)0x00007fe7c47a8000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c47a8000,
.vm_end=(app_pc)0x00007fe7c47a9000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c47a9000,
.vm_end=(app_pc)0x00007fe7c4fa9000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c4fa9000,
.vm_end=(app_pc)0x00007fe7c4faa000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c4faa000,
.vm_end=(app_pc)0x00007fe7c57aa000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c57aa000,
.vm_end=(app_pc)0x00007fe7c57ab000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c57ab000,
.vm_end=(app_pc)0x00007fe7c5fab000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c5fab000,
.vm_end=(app_pc)0x00007fe7c5fac000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c5fac000,
.vm_end=(app_pc)0x00007fe7c67ac000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c67ac000,
.vm_end=(app_pc)0x00007fe7c67ad000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c67ad000,
.vm_end=(app_pc)0x00007fe7c6fad000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c6fad000,
.vm_end=(app_pc)0x00007fe7c6fae000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c6fae000,
.vm_end=(app_pc)0x00007fe7c77ae000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c77ae000,
.vm_end=(app_pc)0x00007fe7c7943000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c7943000,
.vm_end=(app_pc)0x00007fe7c7b43000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c7b43000,
.vm_end=(app_pc)0x00007fe7c7b47000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c7b47000,
.vm_end=(app_pc)0x00007fe7c7b49000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c7b49000,
.vm_end=(app_pc)0x00007fe7c7b4d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c7b4d000,
.vm_end=(app_pc)0x00007fe7c7b64000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000218000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c7b64000,
.vm_end=(app_pc)0x00007fe7c7d63000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c7d63000,
.vm_end=(app_pc)0x00007fe7c7d64000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c7d64000,
.vm_end=(app_pc)0x00007fe7c7d65000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libgcc_s.so.1"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c7d65000,
.vm_end=(app_pc)0x00007fe7c7e68000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000304000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c7e68000,
.vm_end=(app_pc)0x00007fe7c8067000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c8067000,
.vm_end=(app_pc)0x00007fe7c8068000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c8068000,
.vm_end=(app_pc)0x00007fe7c8069000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c8069000,
.vm_end=(app_pc)0x00007fe7c81df000,
.prot=5,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000385000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c81df000,
.vm_end=(app_pc)0x00007fe7c83df000,
.prot=0,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c83df000,
.vm_end=(app_pc)0x00007fe7c83e9000,
.prot=1,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c83e9000,
.vm_end=(app_pc)0x00007fe7c83eb000,
.prot=3,
.comment="/usr/lib/x86_64-linux-gnu/libstdc++.so.6.0.25"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c83eb000,
.vm_end=(app_pc)0x00007fe7c83ee000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c83ee000,
.vm_end=(app_pc)0x00007fe7c83f1000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c83f1000,
.vm_end=(app_pc)0x00007fe7c85f0000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c85f0000,
.vm_end=(app_pc)0x00007fe7c85f1000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c85f1000,
.vm_end=(app_pc)0x00007fe7c85f2000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c85f2000,
.vm_end=(app_pc)0x00007fe7c860a000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000021d000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c860a000,
.vm_end=(app_pc)0x00007fe7c8809000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c8809000,
.vm_end=(app_pc)0x00007fe7c880a000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c880a000,
.vm_end=(app_pc)0x00007fe7c880b000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c880b000,
.vm_end=(app_pc)0x00007fe7c880f000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c880f000,
.vm_end=(app_pc)0x00007fe7c8832000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c8a00000,
.vm_end=(app_pc)0x00007fe7c8a05000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c8a2f000,
.vm_end=(app_pc)0x00007fe7c8a32000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c8a32000,
.vm_end=(app_pc)0x00007fe7c8a33000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c8a33000,
.vm_end=(app_pc)0x00007fe7c8a34000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe7c8a34000,
.vm_end=(app_pc)0x00007fe7c8a35000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc83c46000,
.vm_end=(app_pc)0x00007ffc83c68000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc83cf4000,
.vm_end=(app_pc)0x00007ffc83cf7000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc83cf7000,
.vm_end=(app_pc)0x00007ffc83cf9000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_2296AA3C[]={
{
.iter_result={.vm_start=(app_pc)0x00007f3e1821e000,
.vm_end=(app_pc)0x00007f3e185b5000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f3e187b5000,
.vm_end=(app_pc)0x00007f3e187fa000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f3e187fa000,
.vm_end=(app_pc)0x00007f3e1883f000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffd3474d000,
.vm_end=(app_pc)0x00007ffd3476f000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffd347cd000,
.vm_end=(app_pc)0x00007ffd347d0000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffd347d0000,
.vm_end=(app_pc)0x00007ffd347d2000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_22EA265E[]={
{
.iter_result={.vm_start=(app_pc)0x00007fb15be16000,
.vm_end=(app_pc)0x00007fb15c1ad000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb15c3ad000,
.vm_end=(app_pc)0x00007fb15c3f2000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb15c3f2000,
.vm_end=(app_pc)0x00007fb15c437000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffddd62b000,
.vm_end=(app_pc)0x00007ffddd64d000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffddd662000,
.vm_end=(app_pc)0x00007ffddd665000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffddd665000,
.vm_end=(app_pc)0x00007ffddd667000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_230B4285[]={
{
.iter_result={.vm_start=(app_pc)0x00007f38aff65000,
.vm_end=(app_pc)0x00007f38b02fc000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f38b04fc000,
.vm_end=(app_pc)0x00007f38b0541000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f38b0541000,
.vm_end=(app_pc)0x00007f38b0586000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff3b038000,
.vm_end=(app_pc)0x00007fff3b05a000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff3b113000,
.vm_end=(app_pc)0x00007fff3b116000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff3b116000,
.vm_end=(app_pc)0x00007fff3b118000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_232C34F3[]={
{
.iter_result={.vm_start=(app_pc)0x00007fed691f0000,
.vm_end=(app_pc)0x00007fed69587000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fed69787000,
.vm_end=(app_pc)0x00007fed697cc000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fed697cc000,
.vm_end=(app_pc)0x00007fed69811000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffd6553e000,
.vm_end=(app_pc)0x00007ffd65560000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffd655fb000,
.vm_end=(app_pc)0x00007ffd655fe000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffd655fe000,
.vm_end=(app_pc)0x00007ffd65600000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_23336114[]={
{
.iter_result={.vm_start=(app_pc)0x00007f7211abf000,
.vm_end=(app_pc)0x00007f7211e56000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f7212056000,
.vm_end=(app_pc)0x00007f721209b000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f721209b000,
.vm_end=(app_pc)0x00007f72120e0000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffcaf66000,
.vm_end=(app_pc)0x00007fffcaf88000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffcafce000,
.vm_end=(app_pc)0x00007fffcafd1000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffcafd1000,
.vm_end=(app_pc)0x00007fffcafd3000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_2333654B[]={
{
.iter_result={.vm_start=(app_pc)0x0000000000400000,
.vm_end=(app_pc)0x0000000000401000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/tool.ssse3"},
.is_header=true,
.mod_base=(app_pc)0x0000000000400000,
.mod_end=(app_pc)0x0000000000401000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000000401000,
.vm_end=(app_pc)0x0000000000402000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000000402000,
.vm_end=(app_pc)0x0000000000403000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f7211abf000,
.vm_end=(app_pc)0x00007f7211e56000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f7211e56000,
.vm_end=(app_pc)0x00007f7212056000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f7212056000,
.vm_end=(app_pc)0x00007f721209b000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f721209b000,
.vm_end=(app_pc)0x00007f72120e0000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffcaf66000,
.vm_end=(app_pc)0x00007fffcaf88000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffcafce000,
.vm_end=(app_pc)0x00007fffcafd1000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffcafd1000,
.vm_end=(app_pc)0x00007fffcafd3000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_2333F1BA[]={
{
.iter_result={.vm_start=(app_pc)0x00007f29f6eee000,
.vm_end=(app_pc)0x00007f29f7285000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f29f7485000,
.vm_end=(app_pc)0x00007f29f74ca000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f29f74ca000,
.vm_end=(app_pc)0x00007f29f750f000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc405a6000,
.vm_end=(app_pc)0x00007ffc405c8000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc405e4000,
.vm_end=(app_pc)0x00007ffc405e7000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc405e7000,
.vm_end=(app_pc)0x00007ffc405e9000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_2333F48B[]={
{
.iter_result={.vm_start=(app_pc)0x0000000000400000,
.vm_end=(app_pc)0x0000000000401000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/tool.sse41"},
.is_header=true,
.mod_base=(app_pc)0x0000000000400000,
.mod_end=(app_pc)0x0000000000401000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000000401000,
.vm_end=(app_pc)0x0000000000402000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000000402000,
.vm_end=(app_pc)0x0000000000403000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f29f6eee000,
.vm_end=(app_pc)0x00007f29f7285000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f29f7285000,
.vm_end=(app_pc)0x00007f29f7485000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f29f7485000,
.vm_end=(app_pc)0x00007f29f74ca000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f29f74ca000,
.vm_end=(app_pc)0x00007f29f750f000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc405a6000,
.vm_end=(app_pc)0x00007ffc405c8000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc405e4000,
.vm_end=(app_pc)0x00007ffc405e7000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc405e7000,
.vm_end=(app_pc)0x00007ffc405e9000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_233470D7[]={
{
.iter_result={.vm_start=(app_pc)0x00007fd486f96000,
.vm_end=(app_pc)0x00007fd48732d000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd48752d000,
.vm_end=(app_pc)0x00007fd487572000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd487572000,
.vm_end=(app_pc)0x00007fd4875b7000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe62431000,
.vm_end=(app_pc)0x00007ffe62453000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe624bb000,
.vm_end=(app_pc)0x00007ffe624be000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe624be000,
.vm_end=(app_pc)0x00007ffe624c0000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_233473A1[]={
{
.iter_result={.vm_start=(app_pc)0x0000000000400000,
.vm_end=(app_pc)0x0000000000401000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/tool.sse42"},
.is_header=true,
.mod_base=(app_pc)0x0000000000400000,
.mod_end=(app_pc)0x0000000000401000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000000401000,
.vm_end=(app_pc)0x0000000000402000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000000000402000,
.vm_end=(app_pc)0x0000000000403000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd486f96000,
.vm_end=(app_pc)0x00007fd48732d000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd48732d000,
.vm_end=(app_pc)0x00007fd48752d000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd48752d000,
.vm_end=(app_pc)0x00007fd487572000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd487572000,
.vm_end=(app_pc)0x00007fd4875b7000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe62431000,
.vm_end=(app_pc)0x00007ffe62453000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe624bb000,
.vm_end=(app_pc)0x00007ffe624be000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe624be000,
.vm_end=(app_pc)0x00007ffe624c0000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_2334EC1F[]={
{
.iter_result={.vm_start=(app_pc)0x00007f3825f29000,
.vm_end=(app_pc)0x00007f38262c0000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f38264c0000,
.vm_end=(app_pc)0x00007f3826505000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f3826505000,
.vm_end=(app_pc)0x00007f382654a000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffdc0f25000,
.vm_end=(app_pc)0x00007ffdc0f47000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffdc0fa6000,
.vm_end=(app_pc)0x00007ffdc0fa9000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffdc0fa9000,
.vm_end=(app_pc)0x00007ffdc0fab000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_233C50CE[]={
{
.iter_result={.vm_start=(app_pc)0x00007fd081727000,
.vm_end=(app_pc)0x00007fd081abe000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd081cbe000,
.vm_end=(app_pc)0x00007fd081d03000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd081d03000,
.vm_end=(app_pc)0x00007fd081d48000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffe1ecb000,
.vm_end=(app_pc)0x00007fffe1eed000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffe1f2b000,
.vm_end=(app_pc)0x00007fffe1f2e000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffe1f2e000,
.vm_end=(app_pc)0x00007fffe1f30000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_2343C616[]={
{
.iter_result={.vm_start=(app_pc)0x00007fe743f8d000,
.vm_end=(app_pc)0x00007fe744324000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe744524000,
.vm_end=(app_pc)0x00007fe744569000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe744569000,
.vm_end=(app_pc)0x00007fe7445ae000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffdcfa5b000,
.vm_end=(app_pc)0x00007ffdcfa7d000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffdcfad5000,
.vm_end=(app_pc)0x00007ffdcfad8000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffdcfad8000,
.vm_end=(app_pc)0x00007ffdcfada000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_234B4E5A[]={
{
.iter_result={.vm_start=(app_pc)0x00007f3c2d613000,
.vm_end=(app_pc)0x00007f3c2d9aa000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f3c2dbaa000,
.vm_end=(app_pc)0x00007f3c2dbef000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f3c2dbef000,
.vm_end=(app_pc)0x00007f3c2dc34000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc02ab9000,
.vm_end=(app_pc)0x00007ffc02adb000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc02ae9000,
.vm_end=(app_pc)0x00007ffc02aec000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc02aec000,
.vm_end=(app_pc)0x00007ffc02aee000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_2352C9E6[]={
{
.iter_result={.vm_start=(app_pc)0x00007f39b4d3e000,
.vm_end=(app_pc)0x00007f39b50d5000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f39b52d5000,
.vm_end=(app_pc)0x00007f39b531a000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f39b531a000,
.vm_end=(app_pc)0x00007f39b535f000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe8fe76000,
.vm_end=(app_pc)0x00007ffe8fe98000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe8ffe9000,
.vm_end=(app_pc)0x00007ffe8ffec000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe8ffec000,
.vm_end=(app_pc)0x00007ffe8ffee000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_2352CEFF[]={
{
.iter_result={.vm_start=(app_pc)0x00007f39b0b38000,
.vm_end=(app_pc)0x00007f39b0b3c000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/tool.cpuid"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000205000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f39b0b3c000,
.vm_end=(app_pc)0x00007f39b0d3b000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f39b0d3b000,
.vm_end=(app_pc)0x00007f39b0d3d000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/tool.cpuid"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f39b0d3d000,
.vm_end=(app_pc)0x00007f39b0d3e000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f39b0d3e000,
.vm_end=(app_pc)0x00007f39b0d3f000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f39b4b17000,
.vm_end=(app_pc)0x00007f39b4b3a000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f39b4b3a000,
.vm_end=(app_pc)0x00007f39b4d3a000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f39b4d3a000,
.vm_end=(app_pc)0x00007f39b4d3c000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f39b4d3c000,
.vm_end=(app_pc)0x00007f39b4d3d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f39b4d3d000,
.vm_end=(app_pc)0x00007f39b4d3e000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f39b4d3e000,
.vm_end=(app_pc)0x00007f39b50d5000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f39b50d5000,
.vm_end=(app_pc)0x00007f39b52d5000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f39b52d5000,
.vm_end=(app_pc)0x00007f39b531a000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f39b531a000,
.vm_end=(app_pc)0x00007f39b535f000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe8fe76000,
.vm_end=(app_pc)0x00007ffe8fe98000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe8ffe9000,
.vm_end=(app_pc)0x00007ffe8ffec000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe8ffec000,
.vm_end=(app_pc)0x00007ffe8ffee000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_235A1B13[]={
{
.iter_result={.vm_start=(app_pc)0x00007f62c8c4b000,
.vm_end=(app_pc)0x00007f62c8fe2000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f62c91e2000,
.vm_end=(app_pc)0x00007f62c9227000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f62c9227000,
.vm_end=(app_pc)0x00007f62c926c000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffca195c000,
.vm_end=(app_pc)0x00007ffca197e000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffca1989000,
.vm_end=(app_pc)0x00007ffca198c000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffca198c000,
.vm_end=(app_pc)0x00007ffca198e000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_236195DE[]={
{
.iter_result={.vm_start=(app_pc)0x00007f09ca653000,
.vm_end=(app_pc)0x00007f09ca9ea000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f09cabea000,
.vm_end=(app_pc)0x00007f09cac2f000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f09cac2f000,
.vm_end=(app_pc)0x00007f09cac74000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffea5273000,
.vm_end=(app_pc)0x00007ffea5295000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffea5344000,
.vm_end=(app_pc)0x00007ffea5347000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffea5347000,
.vm_end=(app_pc)0x00007ffea5349000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_23619B0A[]={
{
.iter_result={.vm_start=(app_pc)0x00007f09c6449000,
.vm_end=(app_pc)0x00007f09c6451000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/security-common.selfmod"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000209000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f09c6451000,
.vm_end=(app_pc)0x00007f09c6650000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f09c6650000,
.vm_end=(app_pc)0x00007f09c6652000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/security-common.selfmod"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f09c6652000,
.vm_end=(app_pc)0x00007f09c6653000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f09c6653000,
.vm_end=(app_pc)0x00007f09c6654000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f09ca42c000,
.vm_end=(app_pc)0x00007f09ca44f000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f09ca44f000,
.vm_end=(app_pc)0x00007f09ca64f000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f09ca64f000,
.vm_end=(app_pc)0x00007f09ca651000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f09ca651000,
.vm_end=(app_pc)0x00007f09ca652000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f09ca652000,
.vm_end=(app_pc)0x00007f09ca653000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f09ca653000,
.vm_end=(app_pc)0x00007f09ca9ea000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f09ca9ea000,
.vm_end=(app_pc)0x00007f09cabea000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f09cabea000,
.vm_end=(app_pc)0x00007f09cac2f000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f09cac2f000,
.vm_end=(app_pc)0x00007f09cac74000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffea5273000,
.vm_end=(app_pc)0x00007ffea5295000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffea5344000,
.vm_end=(app_pc)0x00007ffea5347000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffea5347000,
.vm_end=(app_pc)0x00007ffea5349000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_2368920B[]={
{
.iter_result={.vm_start=(app_pc)0x00007f04fa4cf000,
.vm_end=(app_pc)0x00007f04fa866000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04faa66000,
.vm_end=(app_pc)0x00007f04faaab000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04faaab000,
.vm_end=(app_pc)0x00007f04faaf0000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc7b935000,
.vm_end=(app_pc)0x00007ffc7b957000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc7b99f000,
.vm_end=(app_pc)0x00007ffc7b9a2000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc7b9a2000,
.vm_end=(app_pc)0x00007ffc7b9a4000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_23689C50[]={
{
.iter_result={.vm_start=(app_pc)0x000002ffa04f3000,
.vm_end=(app_pc)0x000002ffa04f4000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/libclient.dr_options.dll.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000072000000,
.mod_end=(app_pc)0x0000000072203000,
},
{
.iter_result={.vm_start=(app_pc)0x000002ffa04f4000,
.vm_end=(app_pc)0x000002ffa06f4000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000002ffa06f4000,
.vm_end=(app_pc)0x000002ffa06f6000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/libclient.dr_options.dll.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000002ffa06f6000,
.vm_end=(app_pc)0x000002ffa06f7000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000300004f3000,
.vm_end=(app_pc)0x00000300004f4000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000300004f4000,
.vm_end=(app_pc)0x00000300004fa000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000300004fa000,
.vm_end=(app_pc)0x00000300004fc000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00000300004fc000,
.vm_end=(app_pc)0x000003000050e000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000003000050e000,
.vm_end=(app_pc)0x000003000051c000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000003000051c000,
.vm_end=(app_pc)0x000003000051d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000003000051d000,
.vm_end=(app_pc)0x0000030000524000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000030000524000,
.vm_end=(app_pc)0x0000030000525000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000030000525000,
.vm_end=(app_pc)0x00000300204f3000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04f62c5000,
.vm_end=(app_pc)0x00007f04f62cd000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/security-common.selfmod"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000209000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04f62cd000,
.vm_end=(app_pc)0x00007f04f64cc000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04f64cc000,
.vm_end=(app_pc)0x00007f04f64ce000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/security-common.selfmod"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04f64ce000,
.vm_end=(app_pc)0x00007f04f64cf000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04f64cf000,
.vm_end=(app_pc)0x00007f04f64d0000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04fa2a8000,
.vm_end=(app_pc)0x00007f04fa2cb000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04fa2cb000,
.vm_end=(app_pc)0x00007f04fa4cb000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04fa4cb000,
.vm_end=(app_pc)0x00007f04fa4cd000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04fa4cd000,
.vm_end=(app_pc)0x00007f04fa4ce000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04fa4ce000,
.vm_end=(app_pc)0x00007f04fa4cf000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04fa4cf000,
.vm_end=(app_pc)0x00007f04fa866000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04fa866000,
.vm_end=(app_pc)0x00007f04faa66000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04faa66000,
.vm_end=(app_pc)0x00007f04faaab000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f04faaab000,
.vm_end=(app_pc)0x00007f04faaf0000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc7b935000,
.vm_end=(app_pc)0x00007ffc7b957000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc7b99f000,
.vm_end=(app_pc)0x00007ffc7b9a2000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffc7b9a2000,
.vm_end=(app_pc)0x00007ffc7b9a4000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_236FA2D9[]={
{
.iter_result={.vm_start=(app_pc)0x00007f3c91ace000,
.vm_end=(app_pc)0x00007f3c91e65000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f3c92065000,
.vm_end=(app_pc)0x00007f3c920aa000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f3c920aa000,
.vm_end=(app_pc)0x00007f3c920ef000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe37160000,
.vm_end=(app_pc)0x00007ffe37182000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe37191000,
.vm_end=(app_pc)0x00007ffe37194000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe37194000,
.vm_end=(app_pc)0x00007ffe37196000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_2379DC7C[]={
{
.iter_result={.vm_start=(app_pc)0x000055e9492b6000,
.vm_end=(app_pc)0x000055e9492bb000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.startstop"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000206000,
},
{
.iter_result={.vm_start=(app_pc)0x000055e9494ba000,
.vm_end=(app_pc)0x000055e9494bb000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.startstop"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055e9494bb000,
.vm_end=(app_pc)0x000055e9494bc000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.startstop"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055e949c26000,
.vm_end=(app_pc)0x000055e949c47000,
.prot=3,
.comment="[heap]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14a69a000,
.vm_end=(app_pc)0x00007fe14a69b000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14a69b000,
.vm_end=(app_pc)0x00007fe14ae9b000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14ae9b000,
.vm_end=(app_pc)0x00007fe14ae9c000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14ae9c000,
.vm_end=(app_pc)0x00007fe14b69c000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14b69c000,
.vm_end=(app_pc)0x00007fe14b69d000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14b69d000,
.vm_end=(app_pc)0x00007fe14be9d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14be9d000,
.vm_end=(app_pc)0x00007fe14be9e000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14be9e000,
.vm_end=(app_pc)0x00007fe14c69e000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14c69e000,
.vm_end=(app_pc)0x00007fe14c69f000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14c69f000,
.vm_end=(app_pc)0x00007fe14ce9f000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14ce9f000,
.vm_end=(app_pc)0x00007fe14cea0000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14cea0000,
.vm_end=(app_pc)0x00007fe14d6a0000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14d6a0000,
.vm_end=(app_pc)0x00007fe14d6a1000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14d6a1000,
.vm_end=(app_pc)0x00007fe14dea1000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14dea1000,
.vm_end=(app_pc)0x00007fe14dea2000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14dea2000,
.vm_end=(app_pc)0x00007fe14e6a2000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14e6a2000,
.vm_end=(app_pc)0x00007fe14e6a3000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14e6a3000,
.vm_end=(app_pc)0x00007fe14eea3000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14eea3000,
.vm_end=(app_pc)0x00007fe14eea4000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14eea4000,
.vm_end=(app_pc)0x00007fe14f6a4000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14f6a4000,
.vm_end=(app_pc)0x00007fe14f839000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14f839000,
.vm_end=(app_pc)0x00007fe14fa39000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14fa39000,
.vm_end=(app_pc)0x00007fe14fa3d000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14fa3d000,
.vm_end=(app_pc)0x00007fe14fa3f000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14fa3f000,
.vm_end=(app_pc)0x00007fe14fa43000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14fa43000,
.vm_end=(app_pc)0x00007fe14fa5b000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000021d000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14fa5b000,
.vm_end=(app_pc)0x00007fe14fc5a000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14fc5a000,
.vm_end=(app_pc)0x00007fe14fc5b000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14fc5b000,
.vm_end=(app_pc)0x00007fe14fc5c000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14fc5c000,
.vm_end=(app_pc)0x00007fe14fc60000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14fc60000,
.vm_end=(app_pc)0x00007fe14fff7000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe14fff7000,
.vm_end=(app_pc)0x00007fe1501f7000,
.prot=0,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe1501f7000,
.vm_end=(app_pc)0x00007fe15021e000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe15021e000,
.vm_end=(app_pc)0x00007fe15023c000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe15023c000,
.vm_end=(app_pc)0x00007fe150281000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe150281000,
.vm_end=(app_pc)0x00007fe150284000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe150284000,
.vm_end=(app_pc)0x00007fe150483000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe150483000,
.vm_end=(app_pc)0x00007fe150484000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe150484000,
.vm_end=(app_pc)0x00007fe150485000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe150485000,
.vm_end=(app_pc)0x00007fe150588000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000304000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe150588000,
.vm_end=(app_pc)0x00007fe150787000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe150787000,
.vm_end=(app_pc)0x00007fe150788000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe150788000,
.vm_end=(app_pc)0x00007fe150789000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe150789000,
.vm_end=(app_pc)0x00007fe1507ac000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe15097d000,
.vm_end=(app_pc)0x00007fe15097f000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe1509a9000,
.vm_end=(app_pc)0x00007fe1509ac000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe1509ac000,
.vm_end=(app_pc)0x00007fe1509ad000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe1509ad000,
.vm_end=(app_pc)0x00007fe1509ae000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe1509ae000,
.vm_end=(app_pc)0x00007fe1509af000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffb3cd3000,
.vm_end=(app_pc)0x00007fffb3cf5000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffb3d4a000,
.vm_end=(app_pc)0x00007fffb3d4d000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffb3d4d000,
.vm_end=(app_pc)0x00007fffb3d4f000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_23836401[]={
{
.iter_result={.vm_start=(app_pc)0x0000563fd1451000,
.vm_end=(app_pc)0x0000563fd1452000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000563fd1452000,
.vm_end=(app_pc)0x0000563fd1458000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000563fd1458000,
.vm_end=(app_pc)0x0000563fd145a000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000563fd145a000,
.vm_end=(app_pc)0x0000563fd146c000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000563fd146c000,
.vm_end=(app_pc)0x0000563fd147a000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000563fd147a000,
.vm_end=(app_pc)0x0000563fd147b000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000563fd147b000,
.vm_end=(app_pc)0x0000563fd1482000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000563fd1482000,
.vm_end=(app_pc)0x0000563fd1483000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000563fd1483000,
.vm_end=(app_pc)0x0000563ff1452000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000563ff1452000,
.vm_end=(app_pc)0x0000563ff1457000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.detach"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000206000,
},
{
.iter_result={.vm_start=(app_pc)0x0000563ff1656000,
.vm_end=(app_pc)0x0000563ff1657000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.detach"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000563ff1657000,
.vm_end=(app_pc)0x0000563ff1658000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.detach"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000563ff2f42000,
.vm_end=(app_pc)0x0000563ff2f63000,
.prot=3,
.comment="[heap]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f50fd9000,
.vm_end=(app_pc)0x00007f4f50fda000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f50fda000,
.vm_end=(app_pc)0x00007f4f517da000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f517da000,
.vm_end=(app_pc)0x00007f4f517db000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f517db000,
.vm_end=(app_pc)0x00007f4f51fdb000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f51fdb000,
.vm_end=(app_pc)0x00007f4f51fdc000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f51fdc000,
.vm_end=(app_pc)0x00007f4f527dc000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f527dc000,
.vm_end=(app_pc)0x00007f4f527dd000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f527dd000,
.vm_end=(app_pc)0x00007f4f52fdd000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f52fdd000,
.vm_end=(app_pc)0x00007f4f52fde000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f52fde000,
.vm_end=(app_pc)0x00007f4f537de000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f537de000,
.vm_end=(app_pc)0x00007f4f537df000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f537df000,
.vm_end=(app_pc)0x00007f4f53fdf000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f53fdf000,
.vm_end=(app_pc)0x00007f4f53fe0000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f53fe0000,
.vm_end=(app_pc)0x00007f4f547e0000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f547e0000,
.vm_end=(app_pc)0x00007f4f547e1000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f547e1000,
.vm_end=(app_pc)0x00007f4f54fe1000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f54fe1000,
.vm_end=(app_pc)0x00007f4f54fe2000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f54fe2000,
.vm_end=(app_pc)0x00007f4f557e2000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f557e2000,
.vm_end=(app_pc)0x00007f4f557e3000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f557e3000,
.vm_end=(app_pc)0x00007f4f55fe3000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f55fe3000,
.vm_end=(app_pc)0x00007f4f56178000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f56178000,
.vm_end=(app_pc)0x00007f4f56378000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f56378000,
.vm_end=(app_pc)0x00007f4f5637c000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f5637c000,
.vm_end=(app_pc)0x00007f4f5637e000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f5637e000,
.vm_end=(app_pc)0x00007f4f56382000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f56382000,
.vm_end=(app_pc)0x00007f4f5639a000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000021d000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f5639a000,
.vm_end=(app_pc)0x00007f4f56599000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f56599000,
.vm_end=(app_pc)0x00007f4f5659a000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f5659a000,
.vm_end=(app_pc)0x00007f4f5659b000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libpthread-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f5659b000,
.vm_end=(app_pc)0x00007f4f5659f000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f5659f000,
.vm_end=(app_pc)0x00007f4f56936000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f56936000,
.vm_end=(app_pc)0x00007f4f56b36000,
.prot=0,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f56b36000,
.vm_end=(app_pc)0x00007f4f56b5d000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f56b5d000,
.vm_end=(app_pc)0x00007f4f56b7b000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f56b7b000,
.vm_end=(app_pc)0x00007f4f56bc0000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f56bc0000,
.vm_end=(app_pc)0x00007f4f56bc3000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f56bc3000,
.vm_end=(app_pc)0x00007f4f56dc2000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f56dc2000,
.vm_end=(app_pc)0x00007f4f56dc3000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f56dc3000,
.vm_end=(app_pc)0x00007f4f56dc4000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f56dc4000,
.vm_end=(app_pc)0x00007f4f56ec7000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000304000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f56ec7000,
.vm_end=(app_pc)0x00007f4f570c6000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f570c6000,
.vm_end=(app_pc)0x00007f4f570c7000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f570c7000,
.vm_end=(app_pc)0x00007f4f570c8000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f570c8000,
.vm_end=(app_pc)0x00007f4f570eb000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f572bc000,
.vm_end=(app_pc)0x00007f4f572be000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f572e8000,
.vm_end=(app_pc)0x00007f4f572eb000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f572eb000,
.vm_end=(app_pc)0x00007f4f572ec000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f572ec000,
.vm_end=(app_pc)0x00007f4f572ed000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f4f572ed000,
.vm_end=(app_pc)0x00007f4f572ee000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffe80ab000,
.vm_end=(app_pc)0x00007fffe80cd000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffe8113000,
.vm_end=(app_pc)0x00007fffe8116000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffe8116000,
.vm_end=(app_pc)0x00007fffe8118000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_23A7F302[]={
{
.iter_result={.vm_start=(app_pc)0x000055c2fca53000,
.vm_end=(app_pc)0x000055c31ca55000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055c31ca55000,
.vm_end=(app_pc)0x000055c31cdec000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_noclient"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000062f000,
},
{
.iter_result={.vm_start=(app_pc)0x000055c31cfeb000,
.vm_end=(app_pc)0x000055c31d013000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_noclient"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055c31d013000,
.vm_end=(app_pc)0x000055c31d032000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_noclient"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055c31d032000,
.vm_end=(app_pc)0x000055c31d084000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x000055c31d4e8000,
.vm_end=(app_pc)0x000055c31d509000,
.prot=3,
.comment="[heap]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996d24a000,
.vm_end=(app_pc)0x00007f996d3df000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996d3df000,
.vm_end=(app_pc)0x00007f996d5df000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996d5df000,
.vm_end=(app_pc)0x00007f996d5e3000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996d5e3000,
.vm_end=(app_pc)0x00007f996d5e5000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996d5e5000,
.vm_end=(app_pc)0x00007f996d5e9000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996d5e9000,
.vm_end=(app_pc)0x00007f996d5ec000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996d5ec000,
.vm_end=(app_pc)0x00007f996d7eb000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996d7eb000,
.vm_end=(app_pc)0x00007f996d7ec000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996d7ec000,
.vm_end=(app_pc)0x00007f996d7ed000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996d7ed000,
.vm_end=(app_pc)0x00007f996d8f0000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000304000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996d8f0000,
.vm_end=(app_pc)0x00007f996daef000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996daef000,
.vm_end=(app_pc)0x00007f996daf0000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996daf0000,
.vm_end=(app_pc)0x00007f996daf1000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996daf1000,
.vm_end=(app_pc)0x00007f996db14000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996dce5000,
.vm_end=(app_pc)0x00007f996dce7000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996dd11000,
.vm_end=(app_pc)0x00007f996dd14000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996dd14000,
.vm_end=(app_pc)0x00007f996dd15000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996dd15000,
.vm_end=(app_pc)0x00007f996dd16000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f996dd16000,
.vm_end=(app_pc)0x00007f996dd17000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffcb58c2000,
.vm_end=(app_pc)0x00007ffcb58e4000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffcb5971000,
.vm_end=(app_pc)0x00007ffcb5974000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffcb5974000,
.vm_end=(app_pc)0x00007ffcb5976000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_23ACF861[]={
{
.iter_result={.vm_start=(app_pc)0x00005643d230b000,
.vm_end=(app_pc)0x00005643f230d000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00005643f230d000,
.vm_end=(app_pc)0x00005643f26a5000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_detach"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000630000,
},
{
.iter_result={.vm_start=(app_pc)0x00005643f28a4000,
.vm_end=(app_pc)0x00005643f28cc000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_detach"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00005643f28cc000,
.vm_end=(app_pc)0x00005643f28eb000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_detach"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00005643f28eb000,
.vm_end=(app_pc)0x00005643f293d000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00005643f3dd0000,
.vm_end=(app_pc)0x00005643f3df1000,
.prot=3,
.comment="[heap]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f9417000,
.vm_end=(app_pc)0x00007fe4f95ac000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f95ac000,
.vm_end=(app_pc)0x00007fe4f97ac000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f97ac000,
.vm_end=(app_pc)0x00007fe4f97b0000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f97b0000,
.vm_end=(app_pc)0x00007fe4f97b2000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f97b2000,
.vm_end=(app_pc)0x00007fe4f97b6000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f97b6000,
.vm_end=(app_pc)0x00007fe4f97b9000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f97b9000,
.vm_end=(app_pc)0x00007fe4f99b8000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f99b8000,
.vm_end=(app_pc)0x00007fe4f99b9000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f99b9000,
.vm_end=(app_pc)0x00007fe4f99ba000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f99ba000,
.vm_end=(app_pc)0x00007fe4f9abd000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000304000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f9abd000,
.vm_end=(app_pc)0x00007fe4f9cbc000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f9cbc000,
.vm_end=(app_pc)0x00007fe4f9cbd000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f9cbd000,
.vm_end=(app_pc)0x00007fe4f9cbe000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f9cbe000,
.vm_end=(app_pc)0x00007fe4f9ce1000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f9eb2000,
.vm_end=(app_pc)0x00007fe4f9eb4000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f9ede000,
.vm_end=(app_pc)0x00007fe4f9ee1000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f9ee1000,
.vm_end=(app_pc)0x00007fe4f9ee2000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f9ee2000,
.vm_end=(app_pc)0x00007fe4f9ee3000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fe4f9ee3000,
.vm_end=(app_pc)0x00007fe4f9ee4000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff31e77000,
.vm_end=(app_pc)0x00007fff31e99000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff31f7e000,
.vm_end=(app_pc)0x00007fff31f81000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fff31f81000,
.vm_end=(app_pc)0x00007fff31f83000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_23ADE9EC[]={
{
.iter_result={.vm_start=(app_pc)0x00005579b86a7000,
.vm_end=(app_pc)0x00005579d86a8000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00005579d86a8000,
.vm_end=(app_pc)0x00005579d8a40000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_prepop"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000630000,
},
{
.iter_result={.vm_start=(app_pc)0x00005579d8c3f000,
.vm_end=(app_pc)0x00005579d8c67000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_prepop"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00005579d8c67000,
.vm_end=(app_pc)0x00005579d8c86000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_prepop"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00005579d8c86000,
.vm_end=(app_pc)0x00005579d8cd8000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00005579d9931000,
.vm_end=(app_pc)0x00005579d9952000,
.prot=3,
.comment="[heap]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27ec4b000,
.vm_end=(app_pc)0x00007ff27ede0000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27ede0000,
.vm_end=(app_pc)0x00007ff27efe0000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27efe0000,
.vm_end=(app_pc)0x00007ff27efe4000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27efe4000,
.vm_end=(app_pc)0x00007ff27efe6000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27efe6000,
.vm_end=(app_pc)0x00007ff27efea000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27efea000,
.vm_end=(app_pc)0x00007ff27efed000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27efed000,
.vm_end=(app_pc)0x00007ff27f1ec000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f1ec000,
.vm_end=(app_pc)0x00007ff27f1ed000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f1ed000,
.vm_end=(app_pc)0x00007ff27f1ee000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f1ee000,
.vm_end=(app_pc)0x00007ff27f2f1000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000304000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f2f1000,
.vm_end=(app_pc)0x00007ff27f4f0000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f4f0000,
.vm_end=(app_pc)0x00007ff27f4f1000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f4f1000,
.vm_end=(app_pc)0x00007ff27f4f2000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f4f2000,
.vm_end=(app_pc)0x00007ff27f515000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f6e6000,
.vm_end=(app_pc)0x00007ff27f6e8000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f712000,
.vm_end=(app_pc)0x00007ff27f715000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f715000,
.vm_end=(app_pc)0x00007ff27f716000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f716000,
.vm_end=(app_pc)0x00007ff27f717000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f717000,
.vm_end=(app_pc)0x00007ff27f718000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe6fc14000,
.vm_end=(app_pc)0x00007ffe6fc36000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe6fd7f000,
.vm_end=(app_pc)0x00007ffe6fd82000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe6fd82000,
.vm_end=(app_pc)0x00007ffe6fd84000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_23AF1D11[]={
{
.iter_result={.vm_start=(app_pc)0x00005579b86a6000,
.vm_end=(app_pc)0x00005579d86a8000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00005579d86a8000,
.vm_end=(app_pc)0x00005579d8a40000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_prepop"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000630000,
},
{
.iter_result={.vm_start=(app_pc)0x00005579d8c3f000,
.vm_end=(app_pc)0x00005579d8c67000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_prepop"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00005579d8c67000,
.vm_end=(app_pc)0x00005579d8c86000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_prepop"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00005579d8c86000,
.vm_end=(app_pc)0x00005579d8cd8000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00005579d9931000,
.vm_end=(app_pc)0x00005579d9952000,
.prot=3,
.comment="[heap]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27ec4b000,
.vm_end=(app_pc)0x00007ff27ede0000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27ede0000,
.vm_end=(app_pc)0x00007ff27efe0000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27efe0000,
.vm_end=(app_pc)0x00007ff27efe4000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27efe4000,
.vm_end=(app_pc)0x00007ff27efe6000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27efe6000,
.vm_end=(app_pc)0x00007ff27efea000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27efea000,
.vm_end=(app_pc)0x00007ff27efed000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27efed000,
.vm_end=(app_pc)0x00007ff27f1ec000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f1ec000,
.vm_end=(app_pc)0x00007ff27f1ed000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f1ed000,
.vm_end=(app_pc)0x00007ff27f1ee000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f1ee000,
.vm_end=(app_pc)0x00007ff27f2f1000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000304000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f2f1000,
.vm_end=(app_pc)0x00007ff27f4f0000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f4f0000,
.vm_end=(app_pc)0x00007ff27f4f1000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f4f1000,
.vm_end=(app_pc)0x00007ff27f4f2000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libm-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f4f2000,
.vm_end=(app_pc)0x00007ff27f515000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f6e6000,
.vm_end=(app_pc)0x00007ff27f6e8000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f712000,
.vm_end=(app_pc)0x00007ff27f715000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f715000,
.vm_end=(app_pc)0x00007ff27f716000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f716000,
.vm_end=(app_pc)0x00007ff27f717000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ff27f717000,
.vm_end=(app_pc)0x00007ff27f718000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe6fc14000,
.vm_end=(app_pc)0x00007ffe6fc36000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe6fd7f000,
.vm_end=(app_pc)0x00007ffe6fd82000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffe6fd82000,
.vm_end=(app_pc)0x00007ffe6fd84000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_291BBD5D[]={
{
.iter_result={.vm_start=(app_pc)0x0000560ef60e0000,
.vm_end=(app_pc)0x0000560ef6477000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_symbols"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000622000,
},
{
.iter_result={.vm_start=(app_pc)0x0000560ef6676000,
.vm_end=(app_pc)0x0000560ef669e000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_symbols"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000560ef669e000,
.vm_end=(app_pc)0x0000560ef66bd000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_symbols"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000560ef66bd000,
.vm_end=(app_pc)0x0000560ef6702000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d30d5000,
.vm_end=(app_pc)0x00007fd4d326a000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d326a000,
.vm_end=(app_pc)0x00007fd4d346a000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d346a000,
.vm_end=(app_pc)0x00007fd4d346e000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d346e000,
.vm_end=(app_pc)0x00007fd4d3470000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d3470000,
.vm_end=(app_pc)0x00007fd4d3474000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d3474000,
.vm_end=(app_pc)0x00007fd4d3477000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d3477000,
.vm_end=(app_pc)0x00007fd4d3676000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d3676000,
.vm_end=(app_pc)0x00007fd4d3677000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d3677000,
.vm_end=(app_pc)0x00007fd4d3678000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d3678000,
.vm_end=(app_pc)0x00007fd4d369b000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d386c000,
.vm_end=(app_pc)0x00007fd4d386e000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d3898000,
.vm_end=(app_pc)0x00007fd4d389b000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d389b000,
.vm_end=(app_pc)0x00007fd4d389c000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d389c000,
.vm_end=(app_pc)0x00007fd4d389d000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d389d000,
.vm_end=(app_pc)0x00007fd4d389e000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffead1d000,
.vm_end=(app_pc)0x00007fffead3f000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffead99000,
.vm_end=(app_pc)0x00007fffead9c000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffead9c000,
.vm_end=(app_pc)0x00007fffead9e000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_291BC11E[]={
{
.iter_result={.vm_start=(app_pc)0x0000560ed60df000,
.vm_end=(app_pc)0x0000560ef60e0000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000560ef60e0000,
.vm_end=(app_pc)0x0000560ef6477000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_symbols"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000622000,
},
{
.iter_result={.vm_start=(app_pc)0x0000560ef6676000,
.vm_end=(app_pc)0x0000560ef669e000,
.prot=1,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_symbols"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000560ef669e000,
.vm_end=(app_pc)0x0000560ef66bd000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/api.static_symbols"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x0000560ef66bd000,
.vm_end=(app_pc)0x0000560ef6702000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d30d5000,
.vm_end=(app_pc)0x00007fd4d326a000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x000000000039f000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d326a000,
.vm_end=(app_pc)0x00007fd4d346a000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d346a000,
.vm_end=(app_pc)0x00007fd4d346e000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d346e000,
.vm_end=(app_pc)0x00007fd4d3470000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libc-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d3470000,
.vm_end=(app_pc)0x00007fd4d3474000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d3474000,
.vm_end=(app_pc)0x00007fd4d3477000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000204000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d3477000,
.vm_end=(app_pc)0x00007fd4d3676000,
.prot=0,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d3676000,
.vm_end=(app_pc)0x00007fd4d3677000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d3677000,
.vm_end=(app_pc)0x00007fd4d3678000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/libdl-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d3678000,
.vm_end=(app_pc)0x00007fd4d369b000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d386c000,
.vm_end=(app_pc)0x00007fd4d386e000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d3898000,
.vm_end=(app_pc)0x00007fd4d389b000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d389b000,
.vm_end=(app_pc)0x00007fd4d389c000,
.prot=1,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d389c000,
.vm_end=(app_pc)0x00007fd4d389d000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fd4d389d000,
.vm_end=(app_pc)0x00007fd4d389e000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffead1d000,
.vm_end=(app_pc)0x00007fffead3f000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffead99000,
.vm_end=(app_pc)0x00007fffead9c000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffead9c000,
.vm_end=(app_pc)0x00007fffead9e000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_291DAC7A[]={
{
.iter_result={.vm_start=(app_pc)0x00007f2d44468000,
.vm_end=(app_pc)0x00007f2d447ff000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2d449ff000,
.vm_end=(app_pc)0x00007f2d44a44000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2d44a44000,
.vm_end=(app_pc)0x00007f2d44a89000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffef718000,
.vm_end=(app_pc)0x00007fffef73a000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffef7d0000,
.vm_end=(app_pc)0x00007fffef7d3000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffef7d3000,
.vm_end=(app_pc)0x00007fffef7d5000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_2926E988[]={
{
.iter_result={.vm_start=(app_pc)0x00007f2b4a8fa000,
.vm_end=(app_pc)0x00007f2b4ac91000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2b4ae91000,
.vm_end=(app_pc)0x00007f2b4aed6000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2b4aed6000,
.vm_end=(app_pc)0x00007f2b4af1b000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffc7d31000,
.vm_end=(app_pc)0x00007fffc7d53000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffc7d8d000,
.vm_end=(app_pc)0x00007fffc7d90000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffc7d90000,
.vm_end=(app_pc)0x00007fffc7d92000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_2926EFD3[]={
{
.iter_result={.vm_start=(app_pc)0x00007f2b466f4000,
.vm_end=(app_pc)0x00007f2b466f8000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/client.events"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000205000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2b466f8000,
.vm_end=(app_pc)0x00007f2b468f7000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2b468f7000,
.vm_end=(app_pc)0x00007f2b468f9000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"suite/tests/bin/client.events"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2b468f9000,
.vm_end=(app_pc)0x00007f2b468fa000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2b468fa000,
.vm_end=(app_pc)0x00007f2b468fb000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2b4a6d3000,
.vm_end=(app_pc)0x00007f2b4a6f6000,
.prot=5,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000226000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2b4a6f6000,
.vm_end=(app_pc)0x00007f2b4a8f6000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2b4a8f6000,
.vm_end=(app_pc)0x00007f2b4a8f8000,
.prot=3,
.comment="/lib/x86_64-linux-gnu/ld-2.24.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2b4a8f8000,
.vm_end=(app_pc)0x00007f2b4a8f9000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2b4a8f9000,
.vm_end=(app_pc)0x00007f2b4a8fa000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2b4a8fa000,
.vm_end=(app_pc)0x00007f2b4ac91000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2b4ac91000,
.vm_end=(app_pc)0x00007f2b4ae91000,
.prot=0,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2b4ae91000,
.vm_end=(app_pc)0x00007f2b4aed6000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f2b4aed6000,
.vm_end=(app_pc)0x00007f2b4af1b000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffc7d31000,
.vm_end=(app_pc)0x00007fffc7d53000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffc7d8d000,
.vm_end=(app_pc)0x00007fffc7d90000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fffc7d90000,
.vm_end=(app_pc)0x00007fffc7d92000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_29305E53[]={
{
.iter_result={.vm_start=(app_pc)0x00007f38ca720000,
.vm_end=(app_pc)0x00007f38caab7000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f38cacb7000,
.vm_end=(app_pc)0x00007f38cacfc000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f38cacfc000,
.vm_end=(app_pc)0x00007f38cad41000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffebfd1e000,
.vm_end=(app_pc)0x00007ffebfd40000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffebfd6c000,
.vm_end=(app_pc)0x00007ffebfd6f000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffebfd6f000,
.vm_end=(app_pc)0x00007ffebfd71000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_2937620A[]={
{
.iter_result={.vm_start=(app_pc)0x00007fb486d7e000,
.vm_end=(app_pc)0x00007fb487115000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb487315000,
.vm_end=(app_pc)0x00007fb48735a000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007fb48735a000,
.vm_end=(app_pc)0x00007fb48739f000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffea69db000,
.vm_end=(app_pc)0x00007ffea69fd000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffea6b7e000,
.vm_end=(app_pc)0x00007ffea6b81000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffea6b81000,
.vm_end=(app_pc)0x00007ffea6b83000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};

fake_memquery_result results_293DDC88[]={
{
.iter_result={.vm_start=(app_pc)0x00007f34b2510000,
.vm_end=(app_pc)0x00007f34b28a7000,
.prot=5,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=true,
.mod_base=(app_pc)0x0000000071000000,
.mod_end=(app_pc)0x0000000071621000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f34b2aa7000,
.vm_end=(app_pc)0x00007f34b2aec000,
.prot=3,
.comment="/usr/local/google/home/chowski/dynamorio/build/"
"lib64/debug/libdynamorio.so"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007f34b2aec000,
.vm_end=(app_pc)0x00007f34b2b31000,
.prot=3,
.comment=""},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffdd550a000,
.vm_end=(app_pc)0x00007ffdd552c000,
.prot=3,
.comment="[stack]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffdd5596000,
.vm_end=(app_pc)0x00007ffdd5599000,
.prot=1,
.comment="[vvar]"},
.is_header=false,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000000000,
},
{
.iter_result={.vm_start=(app_pc)0x00007ffdd5599000,
.vm_end=(app_pc)0x00007ffdd559b000,
.prot=5,
.comment="[vdso]"},
.is_header=true,
.mod_base=(app_pc)0x0000000000000000,
.mod_end=(app_pc)0x0000000000001000,
},
};
/* clang-format off */

memquery_library_bounds_test all_memquery_tests[] = {
    {
        .test_name = "test_EE55A55",
        .iters = results_EE55A55,
        .iters_count = 6,
        .in_start = (app_pc)0xf7c7d000,
        .want_return = 3,
        .want_start = (app_pc)0xf7c7d000,
        .want_end = (app_pc)0xf7ffd000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/"
                        "32bit/lib32/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_EE55E9A",
        .iters = results_EE55E9A,
        .iters_count = 22,
        .in_start = (app_pc)0x00000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/32bit/"
                   "suite/tests/bin/linux.execve32",
        .want_return = 3,
        .want_start = (app_pc)0xf3c6b000,
        .want_end = (app_pc)0xf3c77000,
    },
    {
        .test_name = "test_EED027F",
        .iters = results_EED027F,
        .iters_count = 6,
        .in_start = (app_pc)0x00007fcb3e604000,
        .want_return = 3,
        .want_start = (app_pc)0x00007fcb3e604000,
        .want_end = (app_pc)0x00007fcb3ec25000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_EED055B",
        .iters = results_EED055B,
        .iters_count = 17,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/"
                   "linux.execve-sub64",
        .want_return = 3,
        .want_start = (app_pc)0x00007fcb3a3fe000,
        .want_end = (app_pc)0x00007fcb3a603000,
    },
    {
        .test_name = "test_EF597C9",
        .iters = results_EF597C9,
        .iters_count = 6,
        .in_start = (app_pc)0x00007fc03541b000,
        .want_return = 3,
        .want_start = (app_pc)0x00007fc03541b000,
        .want_end = (app_pc)0x00007fc035a3c000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_EF59D59",
        .iters = results_EF59D59,
        .iters_count = 17,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/"
                   "linux.execve64",
        .want_return = 3,
        .want_start = (app_pc)0x00007fc031215000,
        .want_end = (app_pc)0x00007fc03141a000,
    },
    {
        .test_name = "test_EFCC4D5",
        .iters = results_EFCC4D5,
        .iters_count = 6,
        .in_start = (app_pc)0xf7bbb000,
        .want_return = 3,
        .want_start = (app_pc)0xf7bbb000,
        .want_end = (app_pc)0xf7f3b000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/"
                        "32bit/lib32/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_EFCCB45",
        .iters = results_EFCCB45,
        .iters_count = 22,
        .in_start = (app_pc)0x00000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/32bit/"
                   "suite/tests/bin/linux.execve-sub32",
        .want_return = 3,
        .want_start = (app_pc)0xf3baa000,
        .want_end = (app_pc)0xf3bb5000,
    },
    {
        .test_name = "test_F0531DF",
        .iters = results_F0531DF,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f430c38d000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f430c38d000,
        .want_end = (app_pc)0x00007f430c9ae000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_F1AC967",
        .iters = results_F1AC967,
        .iters_count = 18,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/"
                   "common.decode",
        .want_return = 4,
        .want_start = (app_pc)0x00007fb049480000,
        .want_end = (app_pc)0x00007fb049c3d000,
    },
    {
        .test_name = "test_1236E907",
        .iters = results_1236E907,
        .iters_count = 11,
        .in_start = (app_pc)0x0000000071000000,
        .want_return = 4,
        .want_start = (app_pc)0x0000000071000000,
        .want_end = (app_pc)0x0000000071621000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_12A51D0A",
        .iters = results_12A51D0A,
        .iters_count = 26,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/"
                   "linux.mangle_asynch",
        .want_return = 3,
        .want_start = (app_pc)0x00007f32da671000,
        .want_end = (app_pc)0x00007f32da876000,
    },
    {
        .test_name = "test_12CD8932",
        .iters = results_12CD8932,
        .iters_count = 13,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/"
                   "linux.fib-static",
        .want_return = 4,
        .want_start = (app_pc)0x0000000000400000,
        .want_end = (app_pc)0x00000000006b8000,
    },
    {
        .test_name = "test_136482A6",
        .iters = results_136482A6,
        .iters_count = 26,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/"
                   "security-common.selfmod",
        .want_return = 3,
        .want_start = (app_pc)0x00007fb2d24d2000,
        .want_end = (app_pc)0x00007fb2d26db000,
    },
    {
        .test_name = "test_14442F83",
        .iters = results_14442F83,
        .iters_count = 11,
        .in_start = (app_pc)0x0000000071000000,
        .want_return = 4,
        .want_start = (app_pc)0x0000000071000000,
        .want_end = (app_pc)0x0000000071621000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_16390299",
        .iters = results_16390299,
        .iters_count = 30,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/"
                   "client.mangle_suspend",
        .want_return = 3,
        .want_start = (app_pc)0x00007f2a3167f000,
        .want_end = (app_pc)0x00007f2a31884000,
    },
    {
        .test_name = "test_173012FF",
        .iters = results_173012FF,
        .iters_count = 11,
        .in_start = (app_pc)0x0000000071000000,
        .want_return = 4,
        .want_start = (app_pc)0x0000000071000000,
        .want_end = (app_pc)0x0000000071621000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_1730194B",
        .iters = results_1730194B,
        .iters_count = 18,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/"
                   "client.file_io",
        .want_return = 3,
        .want_start = (app_pc)0x00007fc8a1923000,
        .want_end = (app_pc)0x00007fc8a1b26000,
    },
    {
        .test_name = "test_1DF076EC",
        .iters = results_1DF076EC,
        .iters_count = 18,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/"
                   "tool.multiproc",
        .want_return = 4,
        .want_start = (app_pc)0x00007f296051d000,
        .want_end = (app_pc)0x00007f2962722000,
    },
    {
        .test_name = "test_1F97E2CC",
        .iters = results_1F97E2CC,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f2c96e01000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f2c96e01000,
        .want_end = (app_pc)0x00007f2c97422000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_1FAA5159",
        .iters = results_1FAA5159,
        .iters_count = 6,
        .in_start = (app_pc)0x00007fc0639c6000,
        .want_return = 3,
        .want_start = (app_pc)0x00007fc0639c6000,
        .want_end = (app_pc)0x00007fc063fe7000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_1FBF9080",
        .iters = results_1FBF9080,
        .iters_count = 6,
        .in_start = (app_pc)0x00007fa3e21c6000,
        .want_return = 3,
        .want_start = (app_pc)0x00007fa3e21c6000,
        .want_end = (app_pc)0x00007fa3e27e7000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_1FD9E457",
        .iters = results_1FD9E457,
        .iters_count = 6,
        .in_start = (app_pc)0x00007fd8b97c0000,
        .want_return = 3,
        .want_start = (app_pc)0x00007fd8b97c0000,
        .want_end = (app_pc)0x00007fd8b9de1000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_1FD9E794",
        .iters = results_1FD9E794,
        .iters_count = 17,
        .in_start = (app_pc)0x0000000000000000,
        .in_name =
            "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/simple_app",
        .want_return = 3,
        .want_start = (app_pc)0x00007fd8b55ba000,
        .want_end = (app_pc)0x00007fd8b57bf000,
    },
    {
        .test_name = "test_1FEE3BD0",
        .iters = results_1FEE3BD0,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f6f020b1000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f6f020b1000,
        .want_end = (app_pc)0x00007f6f026d2000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_1FEE3F24",
        .iters = results_1FEE3F24,
        .iters_count = 18,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/"
                   "tool.multiproc",
        .want_return = 4,
        .want_start = (app_pc)0x00007f6efbeab000,
        .want_end = (app_pc)0x00007f6efe0b0000,
    },
    {
        .test_name = "test_2037B1C3",
        .iters = results_2037B1C3,
        .iters_count = 6,
        .in_start = (app_pc)0x00007fdf76752000,
        .want_return = 3,
        .want_start = (app_pc)0x00007fdf76752000,
        .want_end = (app_pc)0x00007fdf76d73000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_204FBB37",
        .iters = results_204FBB37,
        .iters_count = 6,
        .in_start = (app_pc)0x00007fa8296b4000,
        .want_return = 3,
        .want_start = (app_pc)0x00007fa8296b4000,
        .want_end = (app_pc)0x00007fa829cd5000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_20651BA2",
        .iters = results_20651BA2,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f856c0ff000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f856c0ff000,
        .want_end = (app_pc)0x00007f856c720000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_207A0F64",
        .iters = results_207A0F64,
        .iters_count = 6,
        .in_start = (app_pc)0x00007ff5ad5e9000,
        .want_return = 3,
        .want_start = (app_pc)0x00007ff5ad5e9000,
        .want_end = (app_pc)0x00007ff5adc0a000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_20DA5497",
        .iters = results_20DA5497,
        .iters_count = 54,
        .in_start = (app_pc)0x0000562d8c208aae,
        .want_return = 4,
        .want_start = (app_pc)0x0000562d8bf3e000,
        .want_end = (app_pc)0x0000562d8c63c000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/clients/bin64/",
        .want_filename = "tool.drcacheoff.burst_replace",
    },
    {
        .test_name = "test_2173E505",
        .iters = results_2173E505,
        .iters_count = 50,
        .in_start = (app_pc)0x0000562435d1fe63,
        .want_return = 4,
        .want_start = (app_pc)0x0000562435a63000,
        .want_end = (app_pc)0x0000562436132000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/clients/bin64/",
        .want_filename = "tool.drcacheoff.burst_maps",
    },
    {
        .test_name = "test_21B5A396",
        .iters = results_21B5A396,
        .iters_count = 73,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/clients/bin64/"
                   "tool.drcacheoff.burst_threads",
        .want_return = 4,
        .want_start = (app_pc)0x000055ae3bba8000,
        .want_end = (app_pc)0x000055ae3c277000,
    },
    {
        .test_name = "test_21B5B600",
        .iters = results_21B5B600,
        .iters_count = 82,
        .in_start = (app_pc)0x000055ae3be6508b,
        .want_return = 4,
        .want_start = (app_pc)0x000055ae3bba8000,
        .want_end = (app_pc)0x000055ae3c277000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/clients/bin64/",
        .want_filename = "tool.drcacheoff.burst_threads",
    },
    {
        .test_name = "test_21DEA8CE",
        .iters = results_21DEA8CE,
        .iters_count = 74,
        .in_start = (app_pc)0x000055ae3c202010,
        .want_return = 2,
        .want_start = (app_pc)0x000055ae3bba8000,
        .want_end = (app_pc)0x000055ae3c277000,
    },
    {
        .test_name = "test_221F0148",
        .iters = results_221F0148,
        .iters_count = 60,
        .in_start = (app_pc)0x000055b40ae67010,
        .want_return = 2,
        .want_start = (app_pc)0x000055b40a80d000,
        .want_end = (app_pc)0x000055b40aedc000,
    },
    {
        .test_name = "test_221F0C7F",
        .iters = results_221F0C7F,
        .iters_count = 68,
        .in_start = (app_pc)0x000055b40aaca331,
        .want_return = 4,
        .want_start = (app_pc)0x000055b40a80d000,
        .want_end = (app_pc)0x000055b40aedc000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/clients/bin64/",
        .want_filename = "tool.drcacheoff.burst_threadfilter",
    },
    {
        .test_name = "test_225A9FE2",
        .iters = results_225A9FE2,
        .iters_count = 59,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/clients/bin64/"
                   "tool.drcacheoff.burst_threadfilter",
        .want_return = 4,
        .want_start = (app_pc)0x000056212c2fd000,
        .want_end = (app_pc)0x000056212c9cc000,
    },
    {
        .test_name = "test_2296AA3C",
        .iters = results_2296AA3C,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f3e1821e000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f3e1821e000,
        .want_end = (app_pc)0x00007f3e1883f000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_22EA265E",
        .iters = results_22EA265E,
        .iters_count = 6,
        .in_start = (app_pc)0x00007fb15be16000,
        .want_return = 3,
        .want_start = (app_pc)0x00007fb15be16000,
        .want_end = (app_pc)0x00007fb15c437000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_230B4285",
        .iters = results_230B4285,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f38aff65000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f38aff65000,
        .want_end = (app_pc)0x00007f38b0586000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_232C34F3",
        .iters = results_232C34F3,
        .iters_count = 6,
        .in_start = (app_pc)0x00007fed691f0000,
        .want_return = 3,
        .want_start = (app_pc)0x00007fed691f0000,
        .want_end = (app_pc)0x00007fed69811000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_23336114",
        .iters = results_23336114,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f7211abf000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f7211abf000,
        .want_end = (app_pc)0x00007f72120e0000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_2333654B",
        .iters = results_2333654B,
        .iters_count = 10,
        .in_start = (app_pc)0x0000000000000000,
        .in_name =
            "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/tool.ssse3",
        .want_return = 1,
        .want_start = (app_pc)0x0000000000400000,
        .want_end = (app_pc)0x0000000000401000,
    },
    {
        .test_name = "test_2333F1BA",
        .iters = results_2333F1BA,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f29f6eee000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f29f6eee000,
        .want_end = (app_pc)0x00007f29f750f000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_2333F48B",
        .iters = results_2333F48B,
        .iters_count = 10,
        .in_start = (app_pc)0x0000000000000000,
        .in_name =
            "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/tool.sse41",
        .want_return = 1,
        .want_start = (app_pc)0x0000000000400000,
        .want_end = (app_pc)0x0000000000401000,
    },
    {
        .test_name = "test_233470D7",
        .iters = results_233470D7,
        .iters_count = 6,
        .in_start = (app_pc)0x00007fd486f96000,
        .want_return = 3,
        .want_start = (app_pc)0x00007fd486f96000,
        .want_end = (app_pc)0x00007fd4875b7000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_233473A1",
        .iters = results_233473A1,
        .iters_count = 10,
        .in_start = (app_pc)0x0000000000000000,
        .in_name =
            "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/tool.sse42",
        .want_return = 1,
        .want_start = (app_pc)0x0000000000400000,
        .want_end = (app_pc)0x0000000000401000,
    },
    {
        .test_name = "test_2334EC1F",
        .iters = results_2334EC1F,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f3825f29000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f3825f29000,
        .want_end = (app_pc)0x00007f382654a000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_233C50CE",
        .iters = results_233C50CE,
        .iters_count = 6,
        .in_start = (app_pc)0x00007fd081727000,
        .want_return = 3,
        .want_start = (app_pc)0x00007fd081727000,
        .want_end = (app_pc)0x00007fd081d48000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_2343C616",
        .iters = results_2343C616,
        .iters_count = 6,
        .in_start = (app_pc)0x00007fe743f8d000,
        .want_return = 3,
        .want_start = (app_pc)0x00007fe743f8d000,
        .want_end = (app_pc)0x00007fe7445ae000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_234B4E5A",
        .iters = results_234B4E5A,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f3c2d613000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f3c2d613000,
        .want_end = (app_pc)0x00007f3c2dc34000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_2352C9E6",
        .iters = results_2352C9E6,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f39b4d3e000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f39b4d3e000,
        .want_end = (app_pc)0x00007f39b535f000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_2352CEFF",
        .iters = results_2352CEFF,
        .iters_count = 17,
        .in_start = (app_pc)0x0000000000000000,
        .in_name =
            "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/tool.cpuid",
        .want_return = 3,
        .want_start = (app_pc)0x00007f39b0b38000,
        .want_end = (app_pc)0x00007f39b0d3d000,
    },
    {
        .test_name = "test_235A1B13",
        .iters = results_235A1B13,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f62c8c4b000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f62c8c4b000,
        .want_end = (app_pc)0x00007f62c926c000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_236195DE",
        .iters = results_236195DE,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f09ca653000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f09ca653000,
        .want_end = (app_pc)0x00007f09cac74000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_23619B0A",
        .iters = results_23619B0A,
        .iters_count = 17,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/"
                   "security-common.selfmod",
        .want_return = 3,
        .want_start = (app_pc)0x00007f09c6449000,
        .want_end = (app_pc)0x00007f09c6652000,
    },
    {
        .test_name = "test_2368920B",
        .iters = results_2368920B,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f04fa4cf000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f04fa4cf000,
        .want_end = (app_pc)0x00007f04faaf0000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_23689C50",
        .iters = results_23689C50,
        .iters_count = 30,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/"
                   "security-common.selfmod",
        .want_return = 3,
        .want_start = (app_pc)0x00007f04f62c5000,
        .want_end = (app_pc)0x00007f04f64ce000,
    },
    {
        .test_name = "test_236FA2D9",
        .iters = results_236FA2D9,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f3c91ace000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f3c91ace000,
        .want_end = (app_pc)0x00007f3c920ef000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_2379DC7C",
        .iters = results_2379DC7C,
        .iters_count = 56,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/"
                   "api.startstop",
        .want_return = 3,
        .want_start = (app_pc)0x000055e9492b6000,
        .want_end = (app_pc)0x000055e9494bc000,
    },
    {
        .test_name = "test_23836401",
        .iters = results_23836401,
        .iters_count = 65,
        .in_start = (app_pc)0x00007f4f5659f000,
        .want_return = 5,
        .want_start = (app_pc)0x00007f4f5659f000,
        .want_end = (app_pc)0x00007f4f56bc0000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_23A7F302",
        .iters = results_23A7F302,
        .iters_count = 28,
        .in_start = (app_pc)0x000055c31d014010,
        .want_return = 2,
        .want_start = (app_pc)0x000055c31ca55000,
        .want_end = (app_pc)0x000055c31d084000,
    },
    {
        .test_name = "test_23ACF861",
        .iters = results_23ACF861,
        .iters_count = 28,
        .in_start = (app_pc)0x00005643f28cd010,
        .want_return = 2,
        .want_start = (app_pc)0x00005643f230d000,
        .want_end = (app_pc)0x00005643f293d000,
    },
    {
        .test_name = "test_23ADE9EC",
        .iters = results_23ADE9EC,
        .iters_count = 28,
        .in_start = (app_pc)0x00005579d8c68010,
        .want_return = 2,
        .want_start = (app_pc)0x00005579d86a8000,
        .want_end = (app_pc)0x00005579d8cd8000,
    },
    {
        .test_name = "test_23AF1D11",
        .iters = results_23AF1D11,
        .iters_count = 28,
        .in_start = (app_pc)0x00005579d8c68010,
        .want_return = 2,
        .want_start = (app_pc)0x00005579d86a8000,
        .want_end = (app_pc)0x00005579d8cd8000,
    },
    {
        .test_name = "test_291BBD5D",
        .iters = results_291BBD5D,
        .iters_count = 22,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/"
                   "api.static_symbols",
        .want_return = 4,
        .want_start = (app_pc)0x0000560ef60e0000,
        .want_end = (app_pc)0x0000560ef6702000,
    },
    {
        .test_name = "test_291BC11E",
        .iters = results_291BC11E,
        .iters_count = 23,
        .in_start = (app_pc)0x0000560ef669f010,
        .want_return = 2,
        .want_start = (app_pc)0x0000560ef60e0000,
        .want_end = (app_pc)0x0000560ef6702000,
    },
    {
        .test_name = "test_291DAC7A",
        .iters = results_291DAC7A,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f2d44468000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f2d44468000,
        .want_end = (app_pc)0x00007f2d44a89000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_2926E988",
        .iters = results_2926E988,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f2b4a8fa000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f2b4a8fa000,
        .want_end = (app_pc)0x00007f2b4af1b000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_2926EFD3",
        .iters = results_2926EFD3,
        .iters_count = 17,
        .in_start = (app_pc)0x0000000000000000,
        .in_name = "/usr/local/google/home/chowski/dynamorio/build/suite/tests/bin/"
                   "client.events",
        .want_return = 3,
        .want_start = (app_pc)0x00007f2b466f4000,
        .want_end = (app_pc)0x00007f2b468f9000,
    },
    {
        .test_name = "test_29305E53",
        .iters = results_29305E53,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f38ca720000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f38ca720000,
        .want_end = (app_pc)0x00007f38cad41000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_2937620A",
        .iters = results_2937620A,
        .iters_count = 6,
        .in_start = (app_pc)0x00007fb486d7e000,
        .want_return = 3,
        .want_start = (app_pc)0x00007fb486d7e000,
        .want_end = (app_pc)0x00007fb48739f000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
    {
        .test_name = "test_293DDC88",
        .iters = results_293DDC88,
        .iters_count = 6,
        .in_start = (app_pc)0x00007f34b2510000,
        .want_return = 3,
        .want_start = (app_pc)0x00007f34b2510000,
        .want_end = (app_pc)0x00007f34b2b31000,
        .want_fulldir = "/usr/local/google/home/chowski/dynamorio/build/lib64/debug/",
        .want_filename = "libdynamorio.so",
    },
};
#define NUM_MEMQUERY_TESTS (sizeof(all_memquery_tests) / sizeof(all_memquery_tests[0]))
