/* **********************************************************
 * Copyright (c) 2014-2021 Google, Inc.  All rights reserved.
 * **********************************************************/

/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of Google, Inc. nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL VMWARE, INC. OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#include "../globals.h" /* need this to include decode.h (uint, etc.) */
#include "arch.h"       /* need this to include decode.h (byte, etc. */
#include "decode.h"
#include "decode_private.h"

// We skip auto-formatting for the entire file to keep our single-line entries:
/* clang-format off */

/* When adding new opcodes here, run tools/x86opnums.pl (with the -arm option) on
 * this file and update opcode_api.h using the resulting output.
 * Also run tools/arm_table_chain.pl to update the
 * encoding chains in the tables.
 * See the list of other places to edit when adding new opcodes in opcode_api.h.
 *
 * DO NOT MANUALLY EDIT THE ENCODING CHAINS, INCLUDING THE STARTING POINTS
 * STORED IN THIS ARRAY!  Use tools/arm_table_chain.pl instead.
 */
const op_to_instr_info_t op_instr[] = {
    /* Format is:           {A32, T32, T32.it} */

    /* OP_INVALID */        {NULL, NULL, NULL},
    /* OP_UNDECODED */      {NULL, NULL, NULL},
    /* OP_CONTD   */        {NULL, NULL, NULL},
    /* OP_LABEL   */        {NULL, NULL, NULL},

    /* OP_adc            */ {&A32_pred_opc8[0x2a],       &T32_ext_fopc8[0][0x14],          &T32_16_it_ext_bits_9_6[0][0x05]},
    /* OP_adcs           */ {&A32_pred_opc8[0x2b],       &T32_16_ext_bits_9_6[0][0x05],    &T32_ext_fopc8[0][0x15]},
    /* OP_add            */ {&A32_pred_opc8[0x28],       &T32_16_ext_bit_7[0][0x00],       &T32_16_it_ext_bit_7[0][0x00]},
    /* OP_adds           */ {&A32_pred_opc8[0x29],       &T32_16_ext_bits_10_9[0][0x02],   &T32_ext_RCPC[6][0x00]},
    /* OP_addw           */ {NULL,                       &T32_ext_fopc8[0][0x20],          &T32_ext_fopc8[0][0x20]},
    /* OP_aesd_8         */ {&A32_ext_simd6b[9][0x0d],   &T32_ext_simd6b[9][0x0d],         &T32_ext_simd6b[9][0x0d]},
    /* OP_aese_8         */ {&A32_ext_simd6b[9][0x0c],   &T32_ext_simd6b[9][0x0c],         &T32_ext_simd6b[9][0x0c]},
    /* OP_aesimc_8       */ {&A32_ext_simd6b[9][0x0f],   &T32_ext_simd6b[9][0x0f],         &T32_ext_simd6b[9][0x0f]},
    /* OP_aesmc_8        */ {&A32_ext_simd6b[9][0x0e],   &T32_ext_simd6b[9][0x0e],         &T32_ext_simd6b[9][0x0e]},
    /* OP_and            */ {&A32_pred_opc8[0x20],       &T32_ext_fopc8[0][0x00],          &T32_16_it_ext_bits_9_6[0][0x00]},
    /* OP_ands           */ {&A32_pred_opc8[0x21],       &T32_16_ext_bits_9_6[0][0x00],    &T32_ext_RCPC[4][0x00]},
    /* OP_asr            */ {&A32_ext_opc4[4][0x04],     &T32_ext_bit_B7[4][0x00],         &T32_16_it_ext_bits_9_6[0][0x04]},
    /* OP_asrs           */ {&A32_ext_opc4[5][0x04],     &T32_16_ext_bits_9_6[0][0x04],    &T32_ext_bit_B7[5][0x00]},
    /* OP_b              */ {&A32_pred_opc8[0xa0],       &T32_base_f[0x05],                &T32_base_f[0x05]},
    /* OP_b_short        */ {NULL,                       &T32_16_opc4[0x0e],               &T32_16_it_opc4[0x0e]},
    /* OP_bfc            */ {&A32_ext_RDPC[0][0x01],     &T32_ext_RAPC[8][0x01],           &T32_ext_RAPC[8][0x01]},
    /* OP_bfi            */ {&A32_ext_RDPC[0][0x00],     &T32_ext_RAPC[8][0x00],           &T32_ext_RAPC[8][0x00]},
    /* OP_bic            */ {&A32_pred_opc8[0x3c],       &T32_ext_fopc8[0][0x02],          &T32_16_it_ext_bits_9_6[0][0x0e]},
    /* OP_bics           */ {&A32_pred_opc8[0x3d],       &T32_16_ext_bits_9_6[0][0x0e],    &T32_ext_fopc8[0][0x03]},
    /* OP_bkpt           */ {&A32_ext_opc4[1][0x07],     &T32_16_ext_bits_11_8[0][0x0e],   &T32_16_it_ext_bits_11_8[0][0x0e]},
    /* OP_bl             */ {&A32_pred_opc8[0xb0],       &T32_base_f[0x07],                &T32_base_f[0x07]},
    /* OP_blx            */ {&A32_unpred_opc7[0x50],     &T32_base_f[0x06],                &T32_base_f[0x06]},
    /* OP_blx_ind        */ {&A32_ext_opc4[1][0x03],     &T32_16_ext_bits_9_6[1][0x0e],    &T32_16_it_ext_bits_9_6[1][0x0e]},
    /* OP_bx             */ {&A32_ext_opc4[1][0x01],     &T32_16_ext_bits_9_6[1][0x0c],    &T32_16_it_ext_bits_9_6[1][0x0c]},
    /* OP_bxj            */ {&A32_ext_opc4[1][0x02],     &T32_ext_bits_A10_6_4[0][0x04],   &T32_ext_bits_A10_6_4[0][0x04]},
    /* OP_cbnz           */ {NULL,                       &T32_16_ext_bits_11_8[0][0x09],   NULL},
    /* OP_cbz            */ {NULL,                       &T32_16_ext_bits_11_8[0][0x01],   NULL},
    /* OP_cdp            */ {&A32_ext_bit4[9][0x00],     &T32_ext_bit_B4[11][0x00],        &T32_ext_bit_B4[11][0x00]},
    /* OP_cdp2           */ {&A32_ext_bit4[11][0x00],    &T32_ext_bit_B4[13][0x00],        &T32_ext_bit_B4[13][0x00]},
    /* OP_clrex          */ {&A32_ext_opc4fpB[14][0x01], &T32_ext_bits_B6_4[0][0x02],      &T32_ext_bits_B6_4[0][0x02]},
    /* OP_clz            */ {&A32_ext_opc4[3][0x01],     &T32_ext_fopc8[0][0xab],          &T32_ext_fopc8[0][0xab]},
    /* OP_cmn            */ {&A32_pred_opc8[0x37],       &T32_16_ext_bits_9_6[0][0x0b],    &T32_16_it_ext_bits_9_6[0][0x0b]},
    /* OP_cmp            */ {&A32_pred_opc8[0x35],       &T32_16_ext_bits_9_6[1][0x04],    &T32_16_it_ext_bits_9_6[1][0x04]},
    /* OP_cps            */ {&A32_ext_bits16[8][0x02],   &T32_ext_bits_B10_8[0][0x01],     NULL},
    /* OP_cpsid          */ {&A32_ext_bits16[8][0x0e],   &T32_16_ext_bits_5_4[0][0x03],    NULL},
    /* OP_cpsie          */ {&A32_ext_bits16[8][0x0a],   &T32_16_ext_bits_5_4[0][0x02],    NULL},
    /* OP_crc32b         */ {&A32_ext_bit9[1][0x00],     &T32_ext_bits_B7_4[5][0x08],      &T32_ext_bits_B7_4[5][0x08]},
    /* OP_crc32cb        */ {&A32_ext_bit9[1][0x01],     &T32_ext_bits_B7_4[6][0x08],      &T32_ext_bits_B7_4[6][0x08]},
    /* OP_crc32h         */ {&A32_ext_bit9[3][0x00],     &T32_ext_bits_B7_4[5][0x09],      &T32_ext_bits_B7_4[5][0x09]},
    /* OP_crc32ch        */ {&A32_ext_bit9[3][0x01],     &T32_ext_bits_B7_4[6][0x09],      &T32_ext_bits_B7_4[6][0x09]},
    /* OP_crc32w         */ {&A32_ext_bit9[7][0x00],     &T32_ext_bits_B7_4[5][0x0b],      &T32_ext_bits_B7_4[5][0x0b]},
    /* OP_crc32cw        */ {&A32_ext_bit9[7][0x01],     &T32_ext_bits_B7_4[6][0x0b],      &T32_ext_bits_B7_4[6][0x0b]},
    /* OP_dbg            */ {&A32_ext_opc4[6][0x0f],     &T32_ext_B7_4_eq1[0][0x00],       &T32_ext_B7_4_eq1[0][0x00]},
    /* OP_dcps1          */ {NULL,                       &T32_ext_bits_B2_0[1][0x01],      &T32_ext_bits_B2_0[1][0x01]},
    /* OP_dcps2          */ {NULL,                       &T32_ext_bits_B2_0[1][0x02],      &T32_ext_bits_B2_0[1][0x02]},
    /* OP_dcps3          */ {NULL,                       &T32_ext_bits_B2_0[1][0x03],      &T32_ext_bits_B2_0[1][0x03]},
    /* OP_dmb            */ {&A32_ext_opc4fpB[14][0x05], &T32_ext_bits_B6_4[0][0x05],      &T32_ext_bits_B6_4[0][0x05]},
    /* OP_dsb            */ {&A32_ext_opc4fpB[14][0x04], &T32_ext_bits_B6_4[0][0x04],      &T32_ext_bits_B6_4[0][0x04]},
    /* OP_enterx         */ {NULL,                       &T32_ext_bits_B6_4[0][0x01],      &T32_ext_bits_B6_4[0][0x01]},
    /* OP_eor            */ {&A32_pred_opc8[0x22],       &T32_ext_fopc8[0][0x08],          &T32_16_it_ext_bits_9_6[0][0x01]},
    /* OP_eors           */ {&A32_pred_opc8[0x23],       &T32_16_ext_bits_9_6[0][0x01],    &T32_ext_RCPC[5][0x00]},
    /* OP_eret           */ {&A32_ext_opc4[3][0x06],     &T32_ext_bits_A10_6_4[0][0x05],   &T32_ext_bits_A10_6_4[0][0x05]},
    /* OP_hlt            */ {&A32_ext_opc4[0][0x07],     &T32_16_ext_bits_7_6[1][0x02],    &T32_16_it_ext_bits_7_6[1][0x02]},
    /* OP_hvc            */ {&A32_ext_opc4[2][0x07],     &T32_ext_bits_A10_6_4[0][0x0e],   &T32_ext_bits_A10_6_4[0][0x0e]},
    /* OP_isb            */ {&A32_ext_opc4fpB[14][0x06], &T32_ext_bits_B6_4[0][0x06],      &T32_ext_bits_B6_4[0][0x06]},
    /* OP_it             */ {NULL,                       &T32_16_ext_imm_3_0[0][0x01],     NULL},
    /* OP_lda            */ {&A32_ext_bits8[1][0x00],    &T32_ext_bits_B7_4[1][0x0a],      &T32_ext_bits_B7_4[1][0x0a]},
    /* OP_ldab           */ {&A32_ext_bits8[5][0x00],    &T32_ext_bits_B7_4[1][0x08],      &T32_ext_bits_B7_4[1][0x08]},
    /* OP_ldaex          */ {&A32_ext_bits8[1][0x02],    &T32_ext_bits_B7_4[1][0x0e],      &T32_ext_bits_B7_4[1][0x0e]},
    /* OP_ldaexb         */ {&A32_ext_bits8[5][0x02],    &T32_ext_bits_B7_4[1][0x0c],      &T32_ext_bits_B7_4[1][0x0c]},
    /* OP_ldaexd         */ {&A32_ext_bits8[3][0x02],    &T32_ext_bits_B7_4[1][0x0f],      &T32_ext_bits_B7_4[1][0x0f]},
    /* OP_ldaexh         */ {&A32_ext_bits8[7][0x02],    &T32_ext_bits_B7_4[1][0x0d],      &T32_ext_bits_B7_4[1][0x0d]},
    /* OP_ldah           */ {&A32_ext_bits8[7][0x00],    &T32_ext_bits_B7_4[1][0x09],      &T32_ext_bits_B7_4[1][0x09]},
    /* OP_ldc            */ {&A32_ext_fp[23][0x02],      &T32_ext_fp[23][0x02],            &T32_ext_fp[23][0x02]},
    /* OP_ldc2           */ {&A32_ext_bits20[1][0x09],   &T32_ext_bits20[1][0x09],         &T32_ext_bits20[1][0x09]},
    /* OP_ldc2l          */ {&A32_ext_bits20[1][0x0d],   &T32_ext_bits20[1][0x0d],         &T32_ext_bits20[1][0x0d]},
    /* OP_ldcl           */ {&A32_ext_fp[27][0x02],      &T32_ext_fp[27][0x02],            &T32_ext_fp[27][0x02]},
    /* OP_ldm            */ {&A32_pred_opc8[0x8b],       &T32_16_ext_bits_11_8[0][0x0c],   &T32_16_it_ext_bits_11_8[0][0x0c]},
    /* OP_ldm_priv       */ {&A32_pred_opc8[0x8f],       NULL,                             NULL},
    /* OP_ldmda          */ {&A32_pred_opc8[0x83],       NULL,                             NULL},
    /* OP_ldmda_priv     */ {&A32_pred_opc8[0x87],       NULL,                             NULL},
    /* OP_ldmdb          */ {&A32_pred_opc8[0x91],       &T32_base_e[0x11],                &T32_base_e[0x11]},
    /* OP_ldmdb_priv     */ {&A32_pred_opc8[0x95],       NULL,                             NULL},
    /* OP_ldmib          */ {&A32_pred_opc8[0x99],       NULL,                             NULL},
    /* OP_ldmib_priv     */ {&A32_pred_opc8[0x9d],       NULL,                             NULL},
    /* OP_ldr            */ {&A32_pred_opc8[0x59],       &T32_16_ext_bits_11_10[0][0x02],  &T32_16_it_ext_bits_11_10[0][0x02]},
    /* OP_ldrb           */ {&A32_pred_opc8[0x5d],       &T32_16_ext_bits_11_9[0][0x06],   &T32_16_it_ext_bits_11_9[0][0x06]},
    /* OP_ldrbt          */ {&A32_pred_opc8[0x4f],       &T32_ext_opcBX[1][0x07],          &T32_ext_opcBX[1][0x07]},
    /* OP_ldrd           */ {&A32_ext_opc4x[22][0x04],   &T32_base_e[0x1d],                &T32_base_e[0x1d]},
    /* OP_ldrex          */ {&A32_ext_bits8[1][0x03],    &T32_base_e[0x05],                &T32_base_e[0x05]},
    /* OP_ldrexb         */ {&A32_ext_bits8[5][0x03],    &T32_ext_bits_B7_4[1][0x04],      &T32_ext_bits_B7_4[1][0x04]},
    /* OP_ldrexd         */ {&A32_ext_bits8[3][0x03],    &T32_ext_bits_B7_4[1][0x07],      &T32_ext_bits_B7_4[1][0x07]},
    /* OP_ldrexh         */ {&A32_ext_bits8[7][0x03],    &T32_ext_bits_B7_4[1][0x05],      &T32_ext_bits_B7_4[1][0x05]},
    /* OP_ldrh           */ {&A32_ext_opc4x[23][0x03],   &T32_16_ext_bits_11_9[0][0x05],   &T32_16_it_ext_bits_11_9[0][0x05]},
    /* OP_ldrht          */ {&A32_ext_opc4x[15][0x03],   &T32_ext_opcBX[3][0x07],          &T32_ext_opcBX[3][0x07]},
    /* OP_ldrsb          */ {&A32_ext_opc4x[23][0x04],   &T32_16_ext_bits_11_9[0][0x03],   &T32_16_it_ext_bits_11_9[0][0x03]},
    /* OP_ldrsbt         */ {&A32_ext_opc4x[15][0x04],   &T32_ext_opcBX[6][0x07],          &T32_ext_opcBX[6][0x07]},
    /* OP_ldrsh          */ {&A32_ext_opc4x[23][0x05],   &T32_16_ext_bits_11_9[0][0x07],   &T32_16_it_ext_bits_11_9[0][0x07]},
    /* OP_ldrsht         */ {&A32_ext_opc4x[15][0x05],   &T32_ext_opcBX[7][0x07],          &T32_ext_opcBX[7][0x07]},
    /* OP_ldrt           */ {&A32_pred_opc8[0x4b],       &T32_ext_opcBX[5][0x07],          &T32_ext_opcBX[5][0x07]},
    /* OP_leavex         */ {NULL,                       &T32_ext_bits_B6_4[0][0x00],      &T32_ext_bits_B6_4[0][0x00]},
    /* OP_lsl            */ {&A32_ext_opc4[4][0x08],     &T32_ext_imm126[0][0x01],         &T32_16_it_ext_imm_10_6[0][0x01]},
    /* OP_lsls           */ {&A32_ext_opc4[5][0x08],     &T32_16_ext_imm_10_6[0][0x01],    &T32_ext_imm126[2][0x01]},
    /* OP_lsr            */ {&A32_ext_opc4[4][0x02],     &T32_ext_bit_B7[2][0x00],         &T32_16_it_ext_bits_9_6[0][0x03]},
    /* OP_lsrs           */ {&A32_ext_opc4[5][0x02],     &T32_16_ext_bits_9_6[0][0x03],    &T32_ext_bit_B7[3][0x00]},
    /* OP_mcr            */ {&A32_ext_bit4[9][0x01],     &T32_ext_bit_B4[11][0x01],        &T32_ext_bit_B4[11][0x01]},
    /* OP_mcr2           */ {&A32_ext_bit4[11][0x01],    &T32_ext_bit_B4[13][0x01],        &T32_ext_bit_B4[13][0x01]},
    /* OP_mcrr           */ {&A32_ext_fp[2][0x02],       &T32_ext_fp[2][0x02],             &T32_ext_fp[2][0x02]},
    /* OP_mcrr2          */ {&A32_ext_bits20[0][0x04],   &T32_ext_bits20[0][0x04],         &T32_ext_bits20[0][0x04]},
    /* OP_mla            */ {&A32_ext_opc4x[2][0x02],    &T32_ext_bit_B4[0][0x00],         &T32_ext_bit_B4[0][0x00]},
    /* OP_mlas           */ {&A32_ext_opc4x[3][0x02],    NULL,                             NULL},
    /* OP_mls            */ {&A32_ext_opc4x[6][0x02],    &T32_ext_bit_B4[0][0x01],         &T32_ext_bit_B4[0][0x01]},
    /* OP_mov            */ {&A32_pred_opc8[0x3a],       &T32_16_ext_bits_9_6[1][0x08],    &T32_16_it_ext_imm_10_6[0][0x00]},
    /* OP_movs           */ {&A32_pred_opc8[0x3b],       &T32_16_ext_imm_10_6[0][0x00],    &T32_ext_RAPC[5][0x01]},
    /* OP_movt           */ {&A32_pred_opc8[0x34],       &T32_ext_fopc8[0][0x2c],          &T32_ext_fopc8[0][0x2c]},
    /* OP_movw           */ {&A32_pred_opc8[0x30],       &T32_ext_fopc8[0][0x24],          &T32_ext_fopc8[0][0x24]},
    /* OP_mrc            */ {&A32_ext_bit4[10][0x01],    &T32_ext_bit_B4[12][0x01],        &T32_ext_bit_B4[12][0x01]},
    /* OP_mrc2           */ {&A32_ext_bit4[12][0x01],      &T32_ext_bit_B4[14][0x01],      &T32_ext_bit_B4[14][0x01]},
    /* OP_mrrc           */ {&A32_ext_fp[3][0x02],       &T32_ext_fp[3][0x02],             &T32_ext_fp[3][0x02]},
    /* OP_mrrc2          */ {&A32_ext_bits20[0][0x05],   &T32_ext_bits20[0][0x05],         &T32_ext_bits20[0][0x05]},
    /* OP_mrs            */ {&A32_ext_bit9[4][0x00],     &T32_ext_bit_B5[3][0x00],         &T32_ext_bit_B5[3][0x00]},
    /* OP_mrs_priv       */ {&A32_ext_bit9[4][0x01],     &T32_ext_bit_B5[3][0x01],         &T32_ext_bit_B5[3][0x01]},
    /* OP_msr            */ {&A32_ext_bit9[6][0x00],     &T32_ext_bit_B5[1][0x00],         &T32_ext_bit_B5[1][0x00]},
    /* OP_msr_priv       */ {&A32_ext_bit9[6][0x01],     &T32_ext_bit_B5[1][0x01],         &T32_ext_bit_B5[1][0x01]},
    /* OP_mul            */ {&A32_ext_opc4x[0][0x02],    &T32_ext_RBPC[10][0x01],          &T32_16_it_ext_bits_9_6[0][0x0d]},
    /* OP_muls           */ {&A32_ext_opc4x[1][0x02],    &T32_16_ext_bits_9_6[0][0x0d],    NULL},
    /* OP_mvn            */ {&A32_pred_opc8[0x3e],       &T32_ext_RAPC[6][0x01],           &T32_16_it_ext_bits_9_6[0][0x0f]},
    /* OP_mvns           */ {&A32_pred_opc8[0x3f],       &T32_16_ext_bits_9_6[0][0x0f],    &T32_ext_RAPC[7][0x01]},
    /* OP_nop            */ {&A32_ext_bits0[0][0x00],    &T32_16_ext_bits_6_4[0][0x00],    &T32_16_it_ext_bits_6_4[0][0x00]},
    /* OP_orn            */ {NULL,                       &T32_ext_RAPC[6][0x00],           &T32_ext_RAPC[6][0x00]},
    /* OP_orns           */ {NULL,                       &T32_ext_RAPC[7][0x00],           &T32_ext_RAPC[7][0x00]},
    /* OP_orr            */ {&A32_pred_opc8[0x38],       &T32_ext_RAPC[4][0x00],           &T32_16_it_ext_bits_9_6[0][0x0c]},
    /* OP_orrs           */ {&A32_pred_opc8[0x39],       &T32_16_ext_bits_9_6[0][0x0c],    &T32_ext_RAPC[5][0x00]},
    /* OP_pkhbt          */ {&A32_ext_opc4y[6][0x01],    &T32_ext_bits_B5_4[2][0x00],      &T32_ext_bits_B5_4[2][0x00]},
    /* OP_pkhtb          */ {&A32_ext_opc4y[6][0x03],    &T32_ext_bits_B5_4[2][0x02],      &T32_ext_bits_B5_4[2][0x02]},
    /* OP_pld            */ {&A32_ext_bit22[1][0x01],    &T32_ext_RBPC[3][0x01],           &T32_ext_RBPC[3][0x01]},
    /* OP_pldw           */ {&A32_ext_bit22[1][0x00],    &T32_ext_RBPC[5][0x01],           &T32_ext_RBPC[5][0x01]},
    /* OP_pli            */ {&A32_unpred_opc7[0x25],     &T32_ext_RBPC[9][0x01],           &T32_ext_RBPC[9][0x01]},
    /* OP_qadd           */ {&A32_ext_opc4[0][0x05],     &T32_ext_bits_B7_4[2][0x08],      &T32_ext_bits_B7_4[2][0x08]},
    /* OP_qadd16         */ {&A32_ext_opc4y[1][0x01],    &T32_ext_bits_B7_4[3][0x01],      &T32_ext_bits_B7_4[3][0x01]},
    /* OP_qadd8          */ {&A32_ext_opc4y[1][0x05],    &T32_ext_bits_B7_4[2][0x01],      &T32_ext_bits_B7_4[2][0x01]},
    /* OP_qasx           */ {&A32_ext_opc4y[1][0x02],    &T32_ext_bits_B7_4[4][0x01],      &T32_ext_bits_B7_4[4][0x01]},
    /* OP_qdadd          */ {&A32_ext_opc4[2][0x05],     &T32_ext_bits_B7_4[2][0x09],      &T32_ext_bits_B7_4[2][0x09]},
    /* OP_qdsub          */ {&A32_ext_opc4[3][0x05],     &T32_ext_bits_B7_4[2][0x0b],      &T32_ext_bits_B7_4[2][0x0b]},
    /* OP_qsax           */ {&A32_ext_opc4y[1][0x03],    &T32_ext_bits_B6_4[1][0x01],      &T32_ext_bits_B6_4[1][0x01]},
    /* OP_qsub           */ {&A32_ext_opc4[1][0x05],     &T32_ext_bits_B7_4[2][0x0a],      &T32_ext_bits_B7_4[2][0x0a]},
    /* OP_qsub16         */ {&A32_ext_opc4y[1][0x04],    &T32_ext_bits_B7_4[6][0x01],      &T32_ext_bits_B7_4[6][0x01]},
    /* OP_qsub8          */ {&A32_ext_opc4y[1][0x08],    &T32_ext_bits_B7_4[5][0x01],      &T32_ext_bits_B7_4[5][0x01]},
    /* OP_rbit           */ {&A32_ext_opc4y[11][0x02],   &T32_ext_bits_B7_4[3][0x0a],      &T32_ext_bits_B7_4[3][0x0a]},
    /* OP_rev            */ {&A32_ext_opc4y[8][0x02],    &T32_16_ext_bits_7_6[1][0x00],    &T32_16_it_ext_bits_7_6[1][0x00]},
    /* OP_rev16          */ {&A32_ext_opc4y[8][0x06],    &T32_16_ext_bits_7_6[1][0x01],    &T32_16_it_ext_bits_7_6[1][0x01]},
    /* OP_revsh          */ {&A32_ext_opc4y[11][0x06],   &T32_16_ext_bits_7_6[1][0x03],    &T32_16_it_ext_bits_7_6[1][0x03]},
    /* OP_rfe            */ {&A32_unpred_opc7[0x47],     &T32_base_e[0x19],                &T32_base_e[0x19]},
    /* OP_rfeda          */ {&A32_unpred_opc7[0x43],     NULL,                             NULL},
    /* OP_rfedb          */ {&A32_unpred_opc7[0x49],     &T32_base_e[0x03],                &T32_base_e[0x03]},
    /* OP_rfeib          */ {&A32_unpred_opc7[0x4d],     NULL,                             NULL},
    /* OP_ror            */ {&A32_ext_opc4[4][0x0e],     &T32_ext_imm126[1][0x01],         &T32_16_it_ext_bits_9_6[0][0x07]},
    /* OP_rors           */ {&A32_ext_opc4[5][0x0e],     &T32_16_ext_bits_9_6[0][0x07],    &T32_ext_imm126[3][0x01]},
    /* OP_rrx            */ {&A32_ext_imm5[1][0x00],     &T32_ext_imm126[1][0x00],         &T32_ext_imm126[1][0x00]},
    /* OP_rrxs           */ {&A32_ext_imm5[3][0x00],     &T32_ext_imm126[3][0x00],         &T32_ext_imm126[3][0x00]},
    /* OP_rsb            */ {&A32_pred_opc8[0x26],       &T32_ext_fopc8[0][0x1c],          &T32_16_it_ext_bits_9_6[0][0x09]},
    /* OP_rsbs           */ {&A32_pred_opc8[0x27],       &T32_16_ext_bits_9_6[0][0x09],    &T32_ext_fopc8[0][0x1d]},
    /* OP_rsc            */ {&A32_pred_opc8[0x2e],       NULL,                             NULL},
    /* OP_rscs           */ {&A32_pred_opc8[0x2f],       NULL,                             NULL},
    /* OP_sadd16         */ {&A32_ext_opc4y[0][0x01],    &T32_ext_bits_B7_4[3][0x00],      &T32_ext_bits_B7_4[3][0x00]},
    /* OP_sadd8          */ {&A32_ext_opc4y[0][0x05],    &T32_ext_bits_B7_4[2][0x00],      &T32_ext_bits_B7_4[2][0x00]},
    /* OP_sasx           */ {&A32_ext_opc4y[0][0x02],    &T32_ext_bits_B7_4[4][0x00],      &T32_ext_bits_B7_4[4][0x00]},
    /* OP_sbc            */ {&A32_pred_opc8[0x2c],       &T32_ext_fopc8[0][0x16],          &T32_16_it_ext_bits_9_6[0][0x06]},
    /* OP_sbcs           */ {&A32_pred_opc8[0x2d],       &T32_16_ext_bits_9_6[0][0x06],    &T32_ext_fopc8[0][0x17]},
    /* OP_sbfx           */ {&A32_ext_bit4[3][0x01],     &T32_ext_fopc8[0][0x34],          &T32_ext_fopc8[0][0x34]},
    /* OP_sdiv           */ {&A32_ext_bit4[0][0x01],     &T32_ext_fopc8[0][0xb9],          &T32_ext_fopc8[0][0xb9]},
    /* OP_sel            */ {&A32_ext_opc4y[6][0x06],    &T32_ext_bits_B7_4[4][0x08],      &T32_ext_bits_B7_4[4][0x08]},
    /* OP_setend         */ {&A32_ext_bits16[8][0x01],   &T32_16_ext_bits_5_4[0][0x00],    NULL},
    /* OP_sev            */ {&A32_ext_bits0[0][0x04],    &T32_16_ext_bits_6_4[0][0x04],    &T32_16_it_ext_bits_6_4[0][0x04]},
    /* OP_sevl           */ {&A32_ext_bits0[0][0x05],    &T32_16_ext_bits_6_4[0][0x05],    &T32_16_it_ext_bits_6_4[0][0x05]},
    /* OP_sha1c_32       */ {&A32_ext_simd6[0][0x32],    &T32_ext_simd6[0][0x32],          &T32_ext_simd6[0][0x32]},
    /* OP_sha1h_32       */ {&A32_ext_simd6b[6][0x0b],   &T32_ext_simd6b[6][0x0b],         &T32_ext_simd6b[6][0x0b]},
    /* OP_sha1m_32       */ {&A32_ext_simd6[2][0x32],    &T32_ext_simd6[2][0x32],          &T32_ext_simd6[2][0x32]},
    /* OP_sha1p_32       */ {&A32_ext_simd6[1][0x32],    &T32_ext_simd6[1][0x32],          &T32_ext_simd6[1][0x32]},
    /* OP_sha1su0_32     */ {&A32_ext_simd6[3][0x32],    &T32_ext_simd6[3][0x32],          &T32_ext_simd6[3][0x32]},
    /* OP_sha1su1_32     */ {&A32_ext_simd6b[7][0x0e],   &T32_ext_simd6b[7][0x0e],         &T32_ext_simd6b[7][0x0e]},
    /* OP_sha256h2_32    */ {&A32_ext_simd6[7][0x32],    &T32_ext_simd6[7][0x32],          &T32_ext_simd6[7][0x32]},
    /* OP_sha256h_32     */ {&A32_ext_simd6[6][0x32],    &T32_ext_simd6[6][0x32],          &T32_ext_simd6[6][0x32]},
    /* OP_sha256su0_32   */ {&A32_ext_simd6b[7][0x0f],   &T32_ext_simd6b[7][0x0f],         &T32_ext_simd6b[7][0x0f]},
    /* OP_sha256su1_32   */ {&A32_ext_simd6[8][0x32],    &T32_ext_simd6[8][0x32],          &T32_ext_simd6[8][0x32]},
    /* OP_shadd16        */ {&A32_ext_opc4y[2][0x01],    &T32_ext_bits_B7_4[3][0x02],      &T32_ext_bits_B7_4[3][0x02]},
    /* OP_shadd8         */ {&A32_ext_opc4y[2][0x05],    &T32_ext_bits_B7_4[2][0x02],      &T32_ext_bits_B7_4[2][0x02]},
    /* OP_shasx          */ {&A32_ext_opc4y[2][0x02],    &T32_ext_bits_B7_4[4][0x02],      &T32_ext_bits_B7_4[4][0x02]},
    /* OP_shsax          */ {&A32_ext_opc4y[2][0x03],    &T32_ext_bits_B6_4[1][0x02],      &T32_ext_bits_B6_4[1][0x02]},
    /* OP_shsub16        */ {&A32_ext_opc4y[2][0x04],    &T32_ext_bits_B7_4[6][0x02],      &T32_ext_bits_B7_4[6][0x02]},
    /* OP_shsub8         */ {&A32_ext_opc4y[2][0x08],    &T32_ext_bits_B7_4[5][0x02],      &T32_ext_bits_B7_4[5][0x02]},
    /* OP_smc            */ {&A32_ext_opc4[3][0x07],     &T32_ext_bit_B13[0][0x00],        &T32_ext_bit_B13[0][0x00]},
    /* OP_smlabb         */ {&A32_ext_opc4[0][0x08],     &T32_ext_bits_B5_4[3][0x00],      &T32_ext_bits_B5_4[3][0x00]},
    /* OP_smlabt         */ {&A32_ext_opc4[0][0x0c],     &T32_ext_bits_B5_4[3][0x01],      &T32_ext_bits_B5_4[3][0x01]},
    /* OP_smlad          */ {&A32_ext_RBPC[1][0x00],     &T32_ext_bit_B4[1][0x00],         &T32_ext_bit_B4[1][0x00]},
    /* OP_smladx         */ {&A32_ext_RBPC[2][0x00],     &T32_ext_bit_B4[1][0x01],         &T32_ext_bit_B4[1][0x01]},
    /* OP_smlal          */ {&A32_ext_opc4x[14][0x02],   &T32_ext_bits_B7_4[7][0x00],      &T32_ext_bits_B7_4[7][0x00]},
    /* OP_smlalbb        */ {&A32_ext_opc4[2][0x08],     &T32_ext_bits_B7_4[7][0x08],      &T32_ext_bits_B7_4[7][0x08]},
    /* OP_smlalbt        */ {&A32_ext_opc4[2][0x0c],     &T32_ext_bits_B7_4[7][0x09],      &T32_ext_bits_B7_4[7][0x09]},
    /* OP_smlald         */ {&A32_ext_opc4y[13][0x01],   &T32_ext_bits_B7_4[7][0x0c],      &T32_ext_bits_B7_4[7][0x0c]},
    /* OP_smlaldx        */ {&A32_ext_opc4y[13][0x02],   &T32_ext_bits_B7_4[7][0x0d],      &T32_ext_bits_B7_4[7][0x0d]},
    /* OP_smlals         */ {&A32_ext_opc4x[15][0x02],   NULL,                             NULL},
    /* OP_smlaltb        */ {&A32_ext_opc4[2][0x0a],     &T32_ext_bits_B7_4[7][0x0a],      &T32_ext_bits_B7_4[7][0x0a]},
    /* OP_smlaltt        */ {&A32_ext_opc4[2][0x0e],     &T32_ext_bits_B7_4[7][0x0b],      &T32_ext_bits_B7_4[7][0x0b]},
    /* OP_smlatb         */ {&A32_ext_opc4[0][0x0a],     &T32_ext_bits_B5_4[3][0x02],      &T32_ext_bits_B5_4[3][0x02]},
    /* OP_smlatt         */ {&A32_ext_opc4[0][0x0e],     &T32_ext_bits_B5_4[3][0x03],      &T32_ext_bits_B5_4[3][0x03]},
    /* OP_smlawb         */ {&A32_ext_opc4[1][0x08],     &T32_ext_bit_B4[3][0x00],         &T32_ext_bit_B4[3][0x00]},
    /* OP_smlawt         */ {&A32_ext_opc4[1][0x0c],     &T32_ext_bit_B4[3][0x01],         &T32_ext_bit_B4[3][0x01]},
    /* OP_smlsd          */ {&A32_ext_RBPC[3][0x00],     &T32_ext_bit_B4[5][0x00],         &T32_ext_bit_B4[5][0x00]},
    /* OP_smlsdx         */ {&A32_ext_RBPC[4][0x00],     &T32_ext_bit_B4[5][0x01],         &T32_ext_bit_B4[5][0x01]},
    /* OP_smlsld         */ {&A32_ext_opc4y[13][0x03],   &T32_ext_bit_B4[10][0x00],        &T32_ext_bit_B4[10][0x00]},
    /* OP_smlsldx        */ {&A32_ext_opc4y[13][0x04],   &T32_ext_bit_B4[10][0x01],        &T32_ext_bit_B4[10][0x01]},
    /* OP_smmla          */ {&A32_ext_RBPC[5][0x00],     &T32_ext_bit_B4[7][0x00],         &T32_ext_bit_B4[7][0x00]},
    /* OP_smmlar         */ {&A32_ext_RBPC[6][0x00],     &T32_ext_bit_B4[7][0x01],         &T32_ext_bit_B4[7][0x01]},
    /* OP_smmls          */ {&A32_ext_opc4y[14][0x07],   &T32_ext_bit_B4[9][0x00],         &T32_ext_bit_B4[9][0x00]},
    /* OP_smmlsr         */ {&A32_ext_opc4y[14][0x08],   &T32_ext_bit_B4[9][0x01],         &T32_ext_bit_B4[9][0x01]},
    /* OP_smmul          */ {&A32_ext_RBPC[5][0x01],     &T32_ext_bit_B4[8][0x00],         &T32_ext_bit_B4[8][0x00]},
    /* OP_smmulr         */ {&A32_ext_RBPC[6][0x01],     &T32_ext_bit_B4[8][0x01],         &T32_ext_bit_B4[8][0x01]},
    /* OP_smuad          */ {&A32_ext_RBPC[1][0x01],     &T32_ext_bit_B4[2][0x00],         &T32_ext_bit_B4[2][0x00]},
    /* OP_smuadx         */ {&A32_ext_RBPC[2][0x01],     &T32_ext_bit_B4[2][0x01],         &T32_ext_bit_B4[2][0x01]},
    /* OP_smulbb         */ {&A32_ext_opc4[3][0x08],     &T32_ext_bits_B5_4[4][0x00],      &T32_ext_bits_B5_4[4][0x00]},
    /* OP_smulbt         */ {&A32_ext_opc4[3][0x0c],     &T32_ext_bits_B5_4[4][0x01],      &T32_ext_bits_B5_4[4][0x01]},
    /* OP_smull          */ {&A32_ext_opc4x[12][0x02],   &T32_ext_fopc8[0][0xb8],          &T32_ext_fopc8[0][0xb8]},
    /* OP_smulls         */ {&A32_ext_opc4x[13][0x02],   NULL,                             NULL},
    /* OP_smultb         */ {&A32_ext_opc4[3][0x0a],     &T32_ext_bits_B5_4[4][0x02],      &T32_ext_bits_B5_4[4][0x02]},
    /* OP_smultt         */ {&A32_ext_opc4[3][0x0e],     &T32_ext_bits_B5_4[4][0x03],      &T32_ext_bits_B5_4[4][0x03]},
    /* OP_smulwb         */ {&A32_ext_opc4[1][0x0a],     &T32_ext_bit_B4[4][0x00],         &T32_ext_bit_B4[4][0x00]},
    /* OP_smulwt         */ {&A32_ext_opc4[1][0x0e],     &T32_ext_bit_B4[4][0x01],         &T32_ext_bit_B4[4][0x01]},
    /* OP_smusd          */ {&A32_ext_RBPC[3][0x01],     &T32_ext_bit_B4[6][0x00],         &T32_ext_bit_B4[6][0x00]},
    /* OP_smusdx         */ {&A32_ext_RBPC[4][0x01],     &T32_ext_bit_B4[6][0x01],         &T32_ext_bit_B4[6][0x01]},
    /* OP_srs            */ {&A32_unpred_opc7[0x44],     &T32_base_e[0x18],                &T32_base_e[0x18]},
    /* OP_srsda          */ {&A32_unpred_opc7[0x40],     NULL,                             NULL},
    /* OP_srsdb          */ {&A32_unpred_opc7[0x48],     &T32_base_e[0x00],                &T32_base_e[0x00]},
    /* OP_srsib          */ {&A32_unpred_opc7[0x4c],     NULL,                             NULL},
    /* OP_ssat           */ {&A32_ext_opc4y[7][0x01],    &T32_ext_fopc8[0][0x30],          &T32_ext_fopc8[0][0x30]},
    /* OP_ssat16         */ {&A32_ext_opc4y[7][0x02],    &T32_ext_fopc8[0][0x32],          &T32_ext_fopc8[0][0x32]},
    /* OP_ssax           */ {&A32_ext_opc4y[0][0x03],    &T32_ext_bits_B6_4[1][0x00],      &T32_ext_bits_B6_4[1][0x00]},
    /* OP_ssub16         */ {&A32_ext_opc4y[0][0x04],    &T32_ext_bits_B7_4[6][0x00],      &T32_ext_bits_B7_4[6][0x00]},
    /* OP_ssub8          */ {&A32_ext_opc4y[0][0x08],    &T32_ext_bits_B7_4[5][0x00],      &T32_ext_bits_B7_4[5][0x00]},
    /* OP_stc            */ {&A32_ext_fp[22][0x02],      &T32_ext_fp[22][0x02],            &T32_ext_fp[22][0x02]},
    /* OP_stc2           */ {&A32_ext_bits20[1][0x08],   &T32_ext_bits20[1][0x08],         &T32_ext_bits20[1][0x08]},
    /* OP_stc2l          */ {&A32_ext_bits20[1][0x0c],   &T32_ext_bits20[1][0x0c],         &T32_ext_bits20[1][0x0c]},
    /* OP_stcl           */ {&A32_ext_fp[26][0x02],      &T32_ext_fp[26][0x02],            &T32_ext_fp[26][0x02]},
    /* OP_stl            */ {&A32_ext_bits8[0][0x00],    &T32_ext_bits_B7_4[0][0x0a],      &T32_ext_bits_B7_4[0][0x0a]},
    /* OP_stlb           */ {&A32_ext_bits8[4][0x00],    &T32_ext_bits_B7_4[0][0x08],      &T32_ext_bits_B7_4[0][0x08]},
    /* OP_stlex          */ {&A32_ext_bits8[0][0x02],    &T32_ext_bits_B7_4[0][0x0e],      &T32_ext_bits_B7_4[0][0x0e]},
    /* OP_stlexb         */ {&A32_ext_bits8[4][0x02],    &T32_ext_bits_B7_4[0][0x0c],      &T32_ext_bits_B7_4[0][0x0c]},
    /* OP_stlexd         */ {&A32_ext_bits8[2][0x02],    &T32_ext_bits_B7_4[0][0x0f],      &T32_ext_bits_B7_4[0][0x0f]},
    /* OP_stlexh         */ {&A32_ext_bits8[6][0x02],    &T32_ext_bits_B7_4[0][0x0d],      &T32_ext_bits_B7_4[0][0x0d]},
    /* OP_stlh           */ {&A32_ext_bits8[6][0x00],    &T32_ext_bits_B7_4[0][0x09],      &T32_ext_bits_B7_4[0][0x09]},
    /* OP_stm            */ {&A32_pred_opc8[0x8a],       &T32_16_ext_bit_11[9][0x00],      &T32_16_it_ext_bit_11[9][0x00]},
    /* OP_stm_priv       */ {&A32_pred_opc8[0x8c],       NULL,                             NULL},
    /* OP_stmda          */ {&A32_pred_opc8[0x82],       NULL,                             NULL},
    /* OP_stmda_priv     */ {&A32_pred_opc8[0x84],       NULL,                             NULL},
    /* OP_stmdb          */ {&A32_pred_opc8[0x90],       &T32_16_ext_bits_11_8[0][0x04],   &T32_16_it_ext_bits_11_8[0][0x04]},
    /* OP_stmdb_priv     */ {&A32_pred_opc8[0x94],       NULL,                             NULL},
    /* OP_stmib          */ {&A32_pred_opc8[0x98],       NULL,                             NULL},
    /* OP_stmib_priv     */ {&A32_pred_opc8[0x9c],       NULL,                             NULL},
    /* OP_str            */ {&A32_ext_bit4[2][0x00],     &T32_16_ext_bit_11[7][0x00],      &T32_16_it_ext_bit_11[7][0x00]},
    /* OP_strb           */ {&A32_ext_bit4[5][0x00],     &T32_16_ext_bits_11_9[0][0x02],   &T32_16_it_ext_bits_11_9[0][0x02]},
    /* OP_strbt          */ {&A32_pred_opc8[0x4e],       &T32_ext_opcBX[0][0x07],          &T32_ext_opcBX[0][0x07]},
    /* OP_strd           */ {&A32_ext_opc4x[22][0x05],   &T32_base_e[0x1c],                &T32_base_e[0x1c]},
    /* OP_strex          */ {&A32_ext_bits8[0][0x03],    &T32_base_e[0x04],                &T32_base_e[0x04]},
    /* OP_strexb         */ {&A32_ext_bits8[4][0x03],    &T32_ext_bits_B7_4[0][0x04],      &T32_ext_bits_B7_4[0][0x04]},
    /* OP_strexd         */ {&A32_ext_bits8[2][0x03],    &T32_ext_bits_B7_4[0][0x07],      &T32_ext_bits_B7_4[0][0x07]},
    /* OP_strexh         */ {&A32_ext_bits8[6][0x03],    &T32_ext_bits_B7_4[0][0x05],      &T32_ext_bits_B7_4[0][0x05]},
    /* OP_strh           */ {&A32_ext_opc4x[22][0x03],   &T32_16_ext_bits_11_9[0][0x01],   &T32_16_it_ext_bits_11_9[0][0x01]},
    /* OP_strht          */ {&A32_ext_opc4x[14][0x03],   &T32_ext_opcBX[2][0x07],          &T32_ext_opcBX[2][0x07]},
    /* OP_strt           */ {&A32_pred_opc8[0x4a],       &T32_ext_opcBX[4][0x07],          &T32_ext_opcBX[4][0x07]},
    /* OP_sub            */ {&A32_pred_opc8[0x24],       &T32_16_ext_bit_7[0][0x01],       &T32_16_it_ext_bit_7[0][0x01]},
    /* OP_subs           */ {&A32_pred_opc8[0x25],       &T32_16_ext_bits_10_9[0][0x03],   &T32_ext_RCPC[7][0x00]},
    /* OP_subw           */ {NULL,                       &T32_ext_fopc8[0][0x2a],          &T32_ext_fopc8[0][0x2a]},
    /* OP_svc            */ {&A32_pred_opc8[0xf0],       &T32_16_ext_bits_11_8[1][0x0f],   &T32_16_it_ext_bits_11_8[1][0x0f]},
    /* OP_swp            */ {&A32_ext_opc4[0][0x09],     NULL,                             NULL},
    /* OP_swpb           */ {&A32_ext_opc4[2][0x09],     NULL,                             NULL},
    /* OP_sxtab          */ {&A32_ext_RAPC[1][0x00],     &T32_ext_bit_B7[4][0x01],         &T32_ext_bit_B7[4][0x01]},
    /* OP_sxtab16        */ {&A32_ext_RAPC[0][0x00],     &T32_ext_bit_B7[2][0x01],         &T32_ext_bit_B7[2][0x01]},
    /* OP_sxtah          */ {&A32_ext_RAPC[2][0x00],     &T32_ext_bit_B7[0][0x01],         &T32_ext_bit_B7[0][0x01]},
    /* OP_sxtb           */ {&A32_ext_RAPC[1][0x01],     &T32_16_ext_bits_7_6[0][0x01],    &T32_16_it_ext_bits_7_6[0][0x01]},
    /* OP_sxtb16         */ {&A32_ext_RAPC[0][0x01],     &T32_ext_RAPC[24][0x01],          &T32_ext_RAPC[24][0x01]},
    /* OP_sxth           */ {&A32_ext_RAPC[2][0x01],     &T32_16_ext_bits_7_6[0][0x00],    &T32_16_it_ext_bits_7_6[0][0x00]},
    /* OP_tbb            */ {NULL,                       &T32_ext_bits_B7_4[1][0x00],      &T32_ext_bits_B7_4[1][0x00]},
    /* OP_tbh            */ {NULL,                       &T32_ext_bits_B7_4[1][0x01],      &T32_ext_bits_B7_4[1][0x01]},
    /* OP_teq            */ {&A32_pred_opc8[0x33],       &T32_ext_RCPC[5][0x01],           &T32_ext_RCPC[5][0x01]},
    /* OP_tst            */ {&A32_pred_opc8[0x31],       &T32_16_ext_bits_9_6[0][0x08],    &T32_16_it_ext_bits_9_6[0][0x08]},
    /* OP_uadd16         */ {&A32_ext_opc4y[3][0x01],    &T32_ext_bits_B7_4[3][0x04],      &T32_ext_bits_B7_4[3][0x04]},
    /* OP_uadd8          */ {&A32_ext_opc4y[3][0x05],    &T32_ext_bits_B7_4[2][0x04],      &T32_ext_bits_B7_4[2][0x04]},
    /* OP_uasx           */ {&A32_ext_opc4y[3][0x02],    &T32_ext_bits_B7_4[4][0x04],      &T32_ext_bits_B7_4[4][0x04]},
    /* OP_ubfx           */ {&A32_ext_bit4[7][0x01],     &T32_ext_fopc8[0][0x3c],          &T32_ext_fopc8[0][0x3c]},
    /* OP_udf            */ {&A32_ext_bit5[0][0x01],     &T32_16_ext_bits_11_8[1][0x0e],   &T32_16_it_ext_bits_11_8[1][0x0e]},
    /* OP_udiv           */ {&A32_ext_bit4[1][0x01],     &T32_ext_fopc8[0][0xbb],          &T32_ext_fopc8[0][0xbb]},
    /* OP_uhadd16        */ {&A32_ext_opc4y[5][0x01],    &T32_ext_bits_B7_4[3][0x06],      &T32_ext_bits_B7_4[3][0x06]},
    /* OP_uhadd8         */ {&A32_ext_opc4y[5][0x05],    &T32_ext_bits_B7_4[2][0x06],      &T32_ext_bits_B7_4[2][0x06]},
    /* OP_uhasx          */ {&A32_ext_opc4y[5][0x02],    &T32_ext_bits_B7_4[4][0x06],      &T32_ext_bits_B7_4[4][0x06]},
    /* OP_uhsax          */ {&A32_ext_opc4y[5][0x03],    &T32_ext_bits_B6_4[1][0x06],      &T32_ext_bits_B6_4[1][0x06]},
    /* OP_uhsub16        */ {&A32_ext_opc4y[5][0x04],    &T32_ext_bits_B7_4[6][0x06],      &T32_ext_bits_B7_4[6][0x06]},
    /* OP_uhsub8         */ {&A32_ext_opc4y[5][0x08],    &T32_ext_bits_B7_4[5][0x06],      &T32_ext_bits_B7_4[5][0x06]},
    /* OP_umaal          */ {&A32_ext_opc4x[4][0x02],    &T32_ext_bit_B5[4][0x01],         &T32_ext_bit_B5[4][0x01]},
    /* OP_umlal          */ {&A32_ext_opc4x[10][0x02],   &T32_ext_bit_B5[4][0x00],         &T32_ext_bit_B5[4][0x00]},
    /* OP_umlals         */ {&A32_ext_opc4x[11][0x02],   NULL,                             NULL},
    /* OP_umull          */ {&A32_ext_opc4x[8][0x02],    &T32_ext_bits_B7_4[8][0x00],          &T32_ext_bits_B7_4[8][0x00]},
    /* OP_umulls         */ {&A32_ext_opc4x[9][0x02],    NULL,                             NULL},
    /* OP_uqadd16        */ {&A32_ext_opc4y[4][0x01],    &T32_ext_bits_B7_4[3][0x05],      &T32_ext_bits_B7_4[3][0x05]},
    /* OP_uqadd8         */ {&A32_ext_opc4y[4][0x05],    &T32_ext_bits_B7_4[2][0x05],      &T32_ext_bits_B7_4[2][0x05]},
    /* OP_uqasx          */ {&A32_ext_opc4y[4][0x02],    &T32_ext_bits_B7_4[4][0x05],      &T32_ext_bits_B7_4[4][0x05]},
    /* OP_uqsax          */ {&A32_ext_opc4y[4][0x03],    &T32_ext_bits_B6_4[1][0x05],      &T32_ext_bits_B6_4[1][0x05]},
    /* OP_uqsub16        */ {&A32_ext_opc4y[4][0x04],    &T32_ext_bits_B7_4[6][0x05],      &T32_ext_bits_B7_4[6][0x05]},
    /* OP_uqsub8         */ {&A32_ext_opc4y[4][0x08],    &T32_ext_bits_B7_4[5][0x05],      &T32_ext_bits_B7_4[5][0x05]},
    /* OP_usad8          */ {&A32_ext_RBPC[7][0x01],     &T32_ext_RBPC[16][0x01],          &T32_ext_RBPC[16][0x01]},
    /* OP_usada8         */ {&A32_ext_RBPC[7][0x00],     &T32_ext_RBPC[16][0x00],          &T32_ext_RBPC[16][0x00]},
    /* OP_usat           */ {&A32_ext_opc4y[10][0x01],   &T32_ext_fopc8[0][0x38],          &T32_ext_fopc8[0][0x38]},
    /* OP_usat16         */ {&A32_ext_opc4y[10][0x02],   &T32_ext_fopc8[0][0x3a],          &T32_ext_fopc8[0][0x3a]},
    /* OP_usax           */ {&A32_ext_opc4y[3][0x03],    &T32_ext_bits_B6_4[1][0x04],      &T32_ext_bits_B6_4[1][0x04]},
    /* OP_usub16         */ {&A32_ext_opc4y[3][0x04],    &T32_ext_bits_B7_4[6][0x04],      &T32_ext_bits_B7_4[6][0x04]},
    /* OP_usub8          */ {&A32_ext_opc4y[3][0x08],    &T32_ext_bits_B7_4[5][0x04],      &T32_ext_bits_B7_4[5][0x04]},
    /* OP_uxtab          */ {&A32_ext_RAPC[4][0x00],     &T32_ext_bit_B7[5][0x01],         &T32_ext_bit_B7[5][0x01]},
    /* OP_uxtab16        */ {&A32_ext_RAPC[3][0x00],     &T32_ext_bit_B7[3][0x01],         &T32_ext_bit_B7[3][0x01]},
    /* OP_uxtah          */ {&A32_ext_RAPC[5][0x00],     &T32_ext_bit_B7[1][0x01],         &T32_ext_bit_B7[1][0x01]},
    /* OP_uxtb           */ {&A32_ext_RAPC[4][0x01],     &T32_16_ext_bits_7_6[0][0x03],    &T32_16_it_ext_bits_7_6[0][0x03]},
    /* OP_uxtb16         */ {&A32_ext_RAPC[3][0x01],     &T32_ext_RAPC[25][0x01],          &T32_ext_RAPC[25][0x01]},
    /* OP_uxth           */ {&A32_ext_RAPC[5][0x01],     &T32_16_ext_bits_7_6[0][0x02],    &T32_16_it_ext_bits_7_6[0][0x02]},
    /* OP_vaba_s16       */ {&A32_ext_simd6[1][0x1d],    &T32_ext_simd6[1][0x1d],          &T32_ext_simd6[1][0x1d]},
    /* OP_vaba_s32       */ {&A32_ext_simd6[2][0x1d],    &T32_ext_simd6[2][0x1d],          &T32_ext_simd6[2][0x1d]},
    /* OP_vaba_s8        */ {&A32_ext_simd6[0][0x1d],    &T32_ext_simd6[0][0x1d],          &T32_ext_simd6[0][0x1d]},
    /* OP_vaba_u16       */ {&A32_ext_simd6[7][0x1d],    &T32_ext_simd6[7][0x1d],          &T32_ext_simd6[7][0x1d]},
    /* OP_vaba_u32       */ {&A32_ext_simd6[8][0x1d],    &T32_ext_simd6[8][0x1d],          &T32_ext_simd6[8][0x1d]},
    /* OP_vaba_u8        */ {&A32_ext_simd6[6][0x1d],    &T32_ext_simd6[6][0x1d],          &T32_ext_simd6[6][0x1d]},
    /* OP_vabal_s16      */ {&A32_ext_simd6[4][0x14],    &T32_ext_simd6[4][0x14],          &T32_ext_simd6[4][0x14]},
    /* OP_vabal_s32      */ {&A32_ext_simd6[5][0x14],    &T32_ext_simd6[5][0x14],          &T32_ext_simd6[5][0x14]},
    /* OP_vabal_s8       */ {&A32_ext_simd8[0][0x19],    &T32_ext_simd8[0][0x19],          &T32_ext_simd8[0][0x19]},
    /* OP_vabal_u16      */ {&A32_ext_simd6[10][0x14],   &T32_ext_simd6[10][0x14],         &T32_ext_simd6[10][0x14]},
    /* OP_vabal_u32      */ {&A32_ext_simd6[11][0x14],   &T32_ext_simd6[11][0x14],         &T32_ext_simd6[11][0x14]},
    /* OP_vabal_u8       */ {&A32_ext_simd8[1][0x19],    &T32_ext_simd8[1][0x19],          &T32_ext_simd8[1][0x19]},
    /* OP_vabd_s16       */ {&A32_ext_simd6[1][0x1c],    &T32_ext_simd6[1][0x1c],          &T32_ext_simd6[1][0x1c]},
    /* OP_vabd_s32       */ {&A32_ext_simd6[2][0x1c],    &T32_ext_simd6[2][0x1c],          &T32_ext_simd6[2][0x1c]},
    /* OP_vabd_s8        */ {&A32_ext_simd6[0][0x1c],    &T32_ext_simd6[0][0x1c],          &T32_ext_simd6[0][0x1c]},
    /* OP_vabd_u16       */ {&A32_ext_simd6[7][0x1c],    &T32_ext_simd6[7][0x1c],          &T32_ext_simd6[7][0x1c]},
    /* OP_vabd_u32       */ {&A32_ext_simd6[8][0x1c],    &T32_ext_simd6[8][0x1c],          &T32_ext_simd6[8][0x1c]},
    /* OP_vabd_u8        */ {&A32_ext_simd6[6][0x1c],    &T32_ext_simd6[6][0x1c],          &T32_ext_simd6[6][0x1c]},
    /* OP_vabdl_s16      */ {&A32_ext_simd6[4][0x1c],    &T32_ext_simd6[4][0x1c],          &T32_ext_simd6[4][0x1c]},
    /* OP_vabdl_s32      */ {&A32_ext_simd6[5][0x1c],    &T32_ext_simd6[5][0x1c],          &T32_ext_simd6[5][0x1c]},
    /* OP_vabdl_s8       */ {&A32_ext_simd8[0][0x23],    &T32_ext_simd8[0][0x23],          &T32_ext_simd8[0][0x23]},
    /* OP_vabdl_u16      */ {&A32_ext_simd6[10][0x1c],   &T32_ext_simd6[10][0x1c],         &T32_ext_simd6[10][0x1c]},
    /* OP_vabdl_u32      */ {&A32_ext_simd6[11][0x1c],   &T32_ext_simd6[11][0x1c],         &T32_ext_simd6[11][0x1c]},
    /* OP_vabdl_u8       */ {&A32_ext_simd8[1][0x23],    &T32_ext_simd8[1][0x23],          &T32_ext_simd8[1][0x23]},
    /* OP_vabs_f32       */ {&A32_ext_simd6b[6][0x1c],   &T32_ext_simd6b[6][0x1c],         &T32_ext_simd6b[6][0x1c]},
    /* OP_vabs_f64       */ {&A32_ext_bits16[3][0x00],   &T32_ext_bits16[3][0x00],         &T32_ext_bits16[3][0x00]},
    /* OP_vabs_s16       */ {&A32_ext_simd6b[3][0x0c],   &T32_ext_simd6b[3][0x0c],         &T32_ext_simd6b[3][0x0c]},
    /* OP_vabs_s32       */ {&A32_ext_simd6b[6][0x0c],   &T32_ext_simd6b[6][0x0c],         &T32_ext_simd6b[6][0x0c]},
    /* OP_vabs_s8        */ {&A32_ext_simd6b[0][0x0c],   &T32_ext_simd6b[0][0x0c],         &T32_ext_simd6b[0][0x0c]},
    /* OP_vacge_f32      */ {&A32_ext_simd6[6][0x39],    &T32_ext_simd6[6][0x39],          &T32_ext_simd6[6][0x39]},
    /* OP_vacgt_f32      */ {&A32_ext_simd6[8][0x39],    &T32_ext_simd6[8][0x39],          &T32_ext_simd6[8][0x39]},
    /* OP_vadd_f32       */ {&A32_ext_simd6[0][0x34],    &T32_ext_simd6[0][0x34],          &T32_ext_simd6[0][0x34]},
    /* OP_vadd_f64       */ {&A32_ext_opc4fpB[3][0x00],  &T32_ext_opc4fpB[3][0x00],        &T32_ext_opc4fpB[3][0x00]},
    /* OP_vadd_i16       */ {&A32_ext_simd6[1][0x20],    &T32_ext_simd6[1][0x20],          &T32_ext_simd6[1][0x20]},
    /* OP_vadd_i32       */ {&A32_ext_simd6[2][0x20],    &T32_ext_simd6[2][0x20],          &T32_ext_simd6[2][0x20]},
    /* OP_vadd_i64       */ {&A32_ext_simd6[3][0x20],    &T32_ext_simd6[3][0x20],          &T32_ext_simd6[3][0x20]},
    /* OP_vadd_i8        */ {&A32_ext_simd6[0][0x20],    &T32_ext_simd6[0][0x20],          &T32_ext_simd6[0][0x20]},
    /* OP_vaddhn_i16     */ {&A32_ext_simd8[0][0x14],    &T32_ext_simd8[0][0x14],          &T32_ext_simd8[0][0x14]},
    /* OP_vaddhn_i32     */ {&A32_ext_simd6[4][0x10],    &T32_ext_simd6[4][0x10],          &T32_ext_simd6[4][0x10]},
    /* OP_vaddhn_i64     */ {&A32_ext_simd6[5][0x10],    &T32_ext_simd6[5][0x10],          &T32_ext_simd6[5][0x10]},
    /* OP_vaddl_s16      */ {&A32_ext_simd6[4][0x00],    &T32_ext_simd6[4][0x00],          &T32_ext_simd6[4][0x00]},
    /* OP_vaddl_s32      */ {&A32_ext_simd6[5][0x00],    &T32_ext_simd6[5][0x00],          &T32_ext_simd6[5][0x00]},
    /* OP_vaddl_s8       */ {&A32_ext_simd8[0][0x00],    &T32_ext_simd8[0][0x00],          &T32_ext_simd8[0][0x00]},
    /* OP_vaddl_u16      */ {&A32_ext_simd6[10][0x00],   &T32_ext_simd6[10][0x00],         &T32_ext_simd6[10][0x00]},
    /* OP_vaddl_u32      */ {&A32_ext_simd6[11][0x00],   &T32_ext_simd6[11][0x00],         &T32_ext_simd6[11][0x00]},
    /* OP_vaddl_u8       */ {&A32_ext_simd8[1][0x00],    &T32_ext_simd8[1][0x00],          &T32_ext_simd8[1][0x00]},
    /* OP_vaddw_s16      */ {&A32_ext_simd6[4][0x04],    &T32_ext_simd6[4][0x04],          &T32_ext_simd6[4][0x04]},
    /* OP_vaddw_s32      */ {&A32_ext_simd6[5][0x04],    &T32_ext_simd6[5][0x04],          &T32_ext_simd6[5][0x04]},
    /* OP_vaddw_s8       */ {&A32_ext_simd8[0][0x05],    &T32_ext_simd8[0][0x05],          &T32_ext_simd8[0][0x05]},
    /* OP_vaddw_u16      */ {&A32_ext_simd6[10][0x04],   &T32_ext_simd6[10][0x04],         &T32_ext_simd6[10][0x04]},
    /* OP_vaddw_u32      */ {&A32_ext_simd6[11][0x04],   &T32_ext_simd6[11][0x04],         &T32_ext_simd6[11][0x04]},
    /* OP_vaddw_u8       */ {&A32_ext_simd8[1][0x05],    &T32_ext_simd8[1][0x05],          &T32_ext_simd8[1][0x05]},
    /* OP_vand           */ {&A32_ext_simd6[0][0x05],     &T32_ext_simd6[0][0x05],         &T32_ext_simd6[0][0x05]},
    /* OP_vbic           */ {&A32_ext_simd6[1][0x05],    &T32_ext_simd6[1][0x05],          &T32_ext_simd6[1][0x05]},
    /* OP_vbic_i16       */ {&A32_ext_simd8[0][0x2f],    &T32_ext_simd8[0][0x2f],          &T32_ext_simd8[0][0x2f]},
    /* OP_vbic_i32       */ {&A32_ext_simd8[0][0x07],    &T32_ext_simd8[0][0x07],          &T32_ext_simd8[0][0x07]},
    /* OP_vbif           */ {&A32_ext_simd6[9][0x05],    &T32_ext_simd6[9][0x05],          &T32_ext_simd6[9][0x05]},
    /* OP_vbit           */ {&A32_ext_simd6[8][0x05],    &T32_ext_simd6[8][0x05],          &T32_ext_simd6[8][0x05]},
    /* OP_vbsl           */ {&A32_ext_simd6[7][0x05],    &T32_ext_simd6[7][0x05],          &T32_ext_simd6[7][0x05]},
    /* OP_vceq_f32       */ {&A32_ext_simd6b[6][0x14],   &T32_ext_simd6b[6][0x14],         &T32_ext_simd6b[6][0x14]},
    /* OP_vceq_i16       */ {&A32_ext_simd6b[3][0x04],   &T32_ext_simd6b[3][0x04],         &T32_ext_simd6b[3][0x04]},
    /* OP_vceq_i32       */ {&A32_ext_simd6b[6][0x04],   &T32_ext_simd6b[6][0x04],         &T32_ext_simd6b[6][0x04]},
    /* OP_vceq_i8        */ {&A32_ext_simd6b[0][0x04],   &T32_ext_simd6b[0][0x04],         &T32_ext_simd6b[0][0x04]},
    /* OP_vcge_f32       */ {&A32_ext_simd6b[6][0x12],   &T32_ext_simd6b[6][0x12],         &T32_ext_simd6b[6][0x12]},
    /* OP_vcge_s16       */ {&A32_ext_simd6b[3][0x02],   &T32_ext_simd6b[3][0x02],         &T32_ext_simd6b[3][0x02]},
    /* OP_vcge_s32       */ {&A32_ext_simd6b[6][0x02],   &T32_ext_simd6b[6][0x02],         &T32_ext_simd6b[6][0x02]},
    /* OP_vcge_s8        */ {&A32_ext_simd6b[0][0x02],   &T32_ext_simd6b[0][0x02],         &T32_ext_simd6b[0][0x02]},
    /* OP_vcge_u16       */ {&A32_ext_simd6[7][0x0d],    &T32_ext_simd6[7][0x0d],          &T32_ext_simd6[7][0x0d]},
    /* OP_vcge_u32       */ {&A32_ext_simd6[8][0x0d],    &T32_ext_simd6[8][0x0d],          &T32_ext_simd6[8][0x0d]},
    /* OP_vcge_u8        */ {&A32_ext_simd6[6][0x0d],    &T32_ext_simd6[6][0x0d],          &T32_ext_simd6[6][0x0d]},
    /* OP_vcgt_f32       */ {&A32_ext_simd6b[6][0x10],   &T32_ext_simd6b[6][0x10],         &T32_ext_simd6b[6][0x10]},
    /* OP_vcgt_s16       */ {&A32_ext_simd6b[3][0x00],   &T32_ext_simd6b[3][0x00],         &T32_ext_simd6b[3][0x00]},
    /* OP_vcgt_s32       */ {&A32_ext_simd6b[6][0x00],   &T32_ext_simd6b[6][0x00],         &T32_ext_simd6b[6][0x00]},
    /* OP_vcgt_s8        */ {&A32_ext_simd6b[0][0x00],   &T32_ext_simd6b[0][0x00],         &T32_ext_simd6b[0][0x00]},
    /* OP_vcgt_u16       */ {&A32_ext_simd6[7][0x0c],    &T32_ext_simd6[7][0x0c],          &T32_ext_simd6[7][0x0c]},
    /* OP_vcgt_u32       */ {&A32_ext_simd6[8][0x0c],    &T32_ext_simd6[8][0x0c],          &T32_ext_simd6[8][0x0c]},
    /* OP_vcgt_u8        */ {&A32_ext_simd6[6][0x0c],    &T32_ext_simd6[6][0x0c],          &T32_ext_simd6[6][0x0c]},
    /* OP_vcle_f32       */ {&A32_ext_simd6b[6][0x16],   &T32_ext_simd6b[6][0x16],         &T32_ext_simd6b[6][0x16]},
    /* OP_vcle_s16       */ {&A32_ext_simd6b[3][0x06],   &T32_ext_simd6b[3][0x06],         &T32_ext_simd6b[3][0x06]},
    /* OP_vcle_s32       */ {&A32_ext_simd6b[6][0x06],   &T32_ext_simd6b[6][0x06],         &T32_ext_simd6b[6][0x06]},
    /* OP_vcle_s8        */ {&A32_ext_simd6b[0][0x06],   &T32_ext_simd6b[0][0x06],         &T32_ext_simd6b[0][0x06]},
    /* OP_vcls_s16       */ {&A32_ext_simd6b[2][0x10],   &T32_ext_simd6b[2][0x10],         &T32_ext_simd6b[2][0x10]},
    /* OP_vcls_s32       */ {&A32_ext_simd6b[5][0x10],   &T32_ext_simd6b[5][0x10],         &T32_ext_simd6b[5][0x10]},
    /* OP_vcls_s8        */ {&A32_ext_simd6b[9][0x10],   &T32_ext_simd6b[9][0x10],         &T32_ext_simd6b[9][0x10]},
    /* OP_vclt_f32       */ {&A32_ext_simd6b[6][0x18],   &T32_ext_simd6b[6][0x18],         &T32_ext_simd6b[6][0x18]},
    /* OP_vclt_s16       */ {&A32_ext_simd6b[3][0x08],   &T32_ext_simd6b[3][0x08],         &T32_ext_simd6b[3][0x08]},
    /* OP_vclt_s32       */ {&A32_ext_simd6b[6][0x08],   &T32_ext_simd6b[6][0x08],         &T32_ext_simd6b[6][0x08]},
    /* OP_vclt_s8        */ {&A32_ext_simd6b[0][0x08],   &T32_ext_simd6b[0][0x08],         &T32_ext_simd6b[0][0x08]},
    /* OP_vclz_i16       */ {&A32_ext_simd6b[2][0x12],   &T32_ext_simd6b[2][0x12],         &T32_ext_simd6b[2][0x12]},
    /* OP_vclz_i32       */ {&A32_ext_simd6b[5][0x12],   &T32_ext_simd6b[5][0x12],         &T32_ext_simd6b[5][0x12]},
    /* OP_vclz_i8        */ {&A32_ext_simd6b[9][0x12],   &T32_ext_simd6b[9][0x12],         &T32_ext_simd6b[9][0x12]},
    /* OP_vcmp_f32       */ {&A32_ext_bits16[0][0x05],   &T32_ext_bits16[0][0x05],         &T32_ext_bits16[0][0x05]},
    /* OP_vcmp_f64       */ {&A32_ext_bits16[2][0x05],   &T32_ext_bits16[2][0x05],         &T32_ext_bits16[2][0x05]},
    /* OP_vcmpe_f32      */ {&A32_ext_bits16[1][0x05],   &T32_ext_bits16[1][0x05],         &T32_ext_bits16[1][0x05]},
    /* OP_vcmpe_f64      */ {&A32_ext_bits16[3][0x05],   &T32_ext_bits16[3][0x05],         &T32_ext_bits16[3][0x05]},
    /* OP_vcnt_8         */ {&A32_ext_simd6b[9][0x14],   &T32_ext_simd6b[9][0x14],         &T32_ext_simd6b[9][0x14]},
    /* OP_vcvt_f16_f32   */ {&A32_ext_simd6b[4][0x18],   &T32_ext_simd6b[4][0x18],         &T32_ext_simd6b[4][0x18]},
    /* OP_vcvt_f32_f16   */ {&A32_ext_simd6b[4][0x1c],   &T32_ext_simd6b[4][0x1c],         &T32_ext_simd6b[4][0x1c]},
    /* OP_vcvt_f32_f64   */ {&A32_ext_bits16[3][0x07],   &T32_ext_bits16[3][0x07],         &T32_ext_bits16[3][0x07]},
    /* OP_vcvt_f32_s16   */ {&A32_ext_bits16[0][0x0a],   &T32_ext_bits16[0][0x0a],         &T32_ext_bits16[0][0x0a]},
    /* OP_vcvt_f32_s32   */ {&A32_ext_simd6b[8][0x18],    &T32_ext_simd6b[8][0x18],          &T32_ext_simd6b[8][0x18]},
    /* OP_vcvt_f32_u16   */ {&A32_ext_bits16[0][0x0b],   &T32_ext_bits16[0][0x0b],         &T32_ext_bits16[0][0x0b]},
    /* OP_vcvt_f32_u32   */ {&A32_ext_simd6b[8][0x1a],    &T32_ext_simd6b[8][0x1a],          &T32_ext_simd6b[8][0x1a]},
    /* OP_vcvt_f64_f32   */ {&A32_ext_bits16[1][0x07],   &T32_ext_bits16[1][0x07],         &T32_ext_bits16[1][0x07]},
    /* OP_vcvt_f64_s16   */ {&A32_ext_bits16[2][0x0a],   &T32_ext_bits16[2][0x0a],         &T32_ext_bits16[2][0x0a]},
    /* OP_vcvt_f64_s32   */ {&A32_ext_bits16[3][0x0a],   &T32_ext_bits16[3][0x0a],         &T32_ext_bits16[3][0x0a]},
    /* OP_vcvt_f64_u16   */ {&A32_ext_bits16[2][0x0b],   &T32_ext_bits16[2][0x0b],         &T32_ext_bits16[2][0x0b]},
    /* OP_vcvt_f64_u32   */ {&A32_ext_bits16[3][0x0b],   &T32_ext_bits16[3][0x0b],         &T32_ext_bits16[3][0x0b]},
    /* OP_vcvt_s16_f32   */ {&A32_ext_bits16[0][0x0e],   &T32_ext_bits16[0][0x0e],         &T32_ext_bits16[0][0x0e]},
    /* OP_vcvt_s16_f64   */ {&A32_ext_bits16[2][0x0e],   &T32_ext_bits16[2][0x0e],         &T32_ext_bits16[2][0x0e]},
    /* OP_vcvt_s32_f32   */ {&A32_ext_simd6b[8][0x1c],   &T32_ext_simd6b[8][0x1c],         &T32_ext_simd6b[8][0x1c]},
    /* OP_vcvt_s32_f64   */ {&A32_ext_bits16[3][0x0e],   &T32_ext_bits16[3][0x0e],         &T32_ext_bits16[3][0x0e]},
    /* OP_vcvt_u16_f32   */ {&A32_ext_bits16[0][0x0f],   &T32_ext_bits16[0][0x0f],         &T32_ext_bits16[0][0x0f]},
    /* OP_vcvt_u16_f64   */ {&A32_ext_bits16[2][0x0f],   &T32_ext_bits16[2][0x0f],         &T32_ext_bits16[2][0x0f]},
    /* OP_vcvt_u32_f32   */ {&A32_ext_simd6b[8][0x1e],    &T32_ext_simd6b[8][0x1e],          &T32_ext_simd6b[8][0x1e]},
    /* OP_vcvt_u32_f64   */ {&A32_ext_bits16[3][0x0f],   &T32_ext_bits16[3][0x0f],         &T32_ext_bits16[3][0x0f]},
    /* OP_vcvta_s32_f32  */ {&A32_ext_simd6b[8][0x00],   &T32_ext_simd6b[8][0x00],         &T32_ext_simd6b[8][0x00]},
    /* OP_vcvta_s32_f64  */ {&A32_ext_simd5b[0][0x13],   &T32_ext_simd5b[0][0x13],         &T32_ext_simd5b[0][0x13]},
    /* OP_vcvta_u32_f32  */ {&A32_ext_simd6b[8][0x02],   &T32_ext_simd6b[8][0x02],         &T32_ext_simd6b[8][0x02]},
    /* OP_vcvta_u32_f64  */ {&A32_ext_simd5b[0][0x12],   &T32_ext_simd5b[0][0x12],         &T32_ext_simd5b[0][0x12]},
    /* OP_vcvtb_f16_f32  */ {&A32_ext_bits16[0][0x03],   &T32_ext_bits16[0][0x03],         &T32_ext_bits16[0][0x03]},
    /* OP_vcvtb_f16_f64  */ {&A32_ext_bits16[2][0x03],   &T32_ext_bits16[2][0x03],         &T32_ext_bits16[2][0x03]},
    /* OP_vcvtb_f32_f16  */ {&A32_ext_bits16[0][0x02],   &T32_ext_bits16[0][0x02],         &T32_ext_bits16[0][0x02]},
    /* OP_vcvtb_f64_f16  */ {&A32_ext_bits16[2][0x02],   &T32_ext_bits16[2][0x02],         &T32_ext_bits16[2][0x02]},
    /* OP_vcvtm_s32_f32  */ {&A32_ext_simd6b[8][0x0c],   &T32_ext_simd6b[8][0x0c],         &T32_ext_simd6b[8][0x0c]},
    /* OP_vcvtm_s32_f64  */ {&A32_ext_simd5b[0][0x1f],   &T32_ext_simd5b[0][0x1f],         &T32_ext_simd5b[0][0x1f]},
    /* OP_vcvtm_u32_f32  */ {&A32_ext_simd6b[8][0x0e],   &T32_ext_simd6b[8][0x0e],         &T32_ext_simd6b[8][0x0e]},
    /* OP_vcvtm_u32_f64  */ {&A32_ext_simd5b[0][0x1e],   &T32_ext_simd5b[0][0x1e],         &T32_ext_simd5b[0][0x1e]},
    /* OP_vcvtn_s32_f32  */ {&A32_ext_simd6b[8][0x04],   &T32_ext_simd6b[8][0x04],         &T32_ext_simd6b[8][0x04]},
    /* OP_vcvtn_s32_f64  */ {&A32_ext_simd5b[0][0x17],   &T32_ext_simd5b[0][0x17],         &T32_ext_simd5b[0][0x17]},
    /* OP_vcvtn_u32_f32  */ {&A32_ext_simd6b[8][0x06],   &T32_ext_simd6b[8][0x06],         &T32_ext_simd6b[8][0x06]},
    /* OP_vcvtn_u32_f64  */ {&A32_ext_simd5b[0][0x16],   &T32_ext_simd5b[0][0x16],         &T32_ext_simd5b[0][0x16]},
    /* OP_vcvtp_s32_f32  */ {&A32_ext_simd6b[8][0x08],   &T32_ext_simd6b[8][0x08],         &T32_ext_simd6b[8][0x08]},
    /* OP_vcvtp_s32_f64  */ {&A32_ext_simd5b[0][0x1b],   &T32_ext_simd5b[0][0x1b],         &T32_ext_simd5b[0][0x1b]},
    /* OP_vcvtp_u32_f32  */ {&A32_ext_simd6b[8][0x0a],   &T32_ext_simd6b[8][0x0a],         &T32_ext_simd6b[8][0x0a]},
    /* OP_vcvtp_u32_f64  */ {&A32_ext_simd5b[0][0x1a],   &T32_ext_simd5b[0][0x1a],         &T32_ext_simd5b[0][0x1a]},
    /* OP_vcvtr_s32_f32  */ {&A32_ext_bits16[0][0x0d],   &T32_ext_bits16[0][0x0d],         &T32_ext_bits16[0][0x0d]},
    /* OP_vcvtr_s32_f64  */ {&A32_ext_bits16[2][0x0d],   &T32_ext_bits16[2][0x0d],         &T32_ext_bits16[2][0x0d]},
    /* OP_vcvtr_u32_f32  */ {&A32_ext_bits16[0][0x0c],   &T32_ext_bits16[0][0x0c],         &T32_ext_bits16[0][0x0c]},
    /* OP_vcvtr_u32_f64  */ {&A32_ext_bits16[2][0x0c],   &T32_ext_bits16[2][0x0c],         &T32_ext_bits16[2][0x0c]},
    /* OP_vcvtt_f16_f32  */ {&A32_ext_bits16[1][0x03],   &T32_ext_bits16[1][0x03],         &T32_ext_bits16[1][0x03]},
    /* OP_vcvtt_f16_f64  */ {&A32_ext_bits16[3][0x03],   &T32_ext_bits16[3][0x03],         &T32_ext_bits16[3][0x03]},
    /* OP_vcvtt_f32_f16  */ {&A32_ext_bits16[1][0x02],   &T32_ext_bits16[1][0x02],         &T32_ext_bits16[1][0x02]},
    /* OP_vcvtt_f64_f16  */ {&A32_ext_bits16[3][0x02],   &T32_ext_bits16[3][0x02],         &T32_ext_bits16[3][0x02]},
    /* OP_vdiv_f32       */ {&A32_ext_opc4fpA[8][0x00],  &T32_ext_opc4fpA[8][0x00],        &T32_ext_opc4fpA[8][0x00]},
    /* OP_vdiv_f64       */ {&A32_ext_opc4fpB[8][0x00],  &T32_ext_opc4fpB[8][0x00],        &T32_ext_opc4fpB[8][0x00]},
    /* OP_vdup_16        */ {&A32_ext_simd6b[1][0x20],   &T32_ext_simd6b[1][0x20],         &T32_ext_simd6b[1][0x20]},
    /* OP_vdup_32        */ {&A32_ext_simd6b[2][0x20],   &T32_ext_simd6b[2][0x20],         &T32_ext_simd6b[2][0x20]},
    /* OP_vdup_8         */ {&A32_ext_simd6b[0][0x20],   &T32_ext_simd6b[0][0x20],         &T32_ext_simd6b[0][0x20]},
    /* OP_veor           */ {&A32_ext_simd6[6][0x05],     &T32_ext_simd6[6][0x05],         &T32_ext_simd6[6][0x05]},
    /* OP_vext           */ {&A32_ext_bit6[0][0x00],     &T32_ext_bit6[0][0x00],           &T32_ext_bit6[0][0x00]},
    /* OP_vfma_f32       */ {&A32_ext_simd6[0][0x31],    &T32_ext_simd6[0][0x31],          &T32_ext_simd6[0][0x31]},
    /* OP_vfma_f64       */ {&A32_ext_opc4fpB[10][0x00], &T32_ext_opc4fpB[10][0x00],       &T32_ext_opc4fpB[10][0x00]},
    /* OP_vfms_f32       */ {&A32_ext_simd6[2][0x31],    &T32_ext_simd6[2][0x31],          &T32_ext_simd6[2][0x31]},
    /* OP_vfms_f64       */ {&A32_ext_opc4fpB[10][0x04], &T32_ext_opc4fpB[10][0x04],       &T32_ext_opc4fpB[10][0x04]},
    /* OP_vfnma_f32      */ {&A32_ext_opc4fpA[9][0x02],  &T32_ext_opc4fpA[9][0x02],        &T32_ext_opc4fpA[9][0x02]},
    /* OP_vfnma_f64      */ {&A32_ext_opc4fpB[9][0x04],  &T32_ext_opc4fpB[9][0x04],        &T32_ext_opc4fpB[9][0x04]},
    /* OP_vfnms_f32      */ {&A32_ext_opc4fpA[9][0x00],  &T32_ext_opc4fpA[9][0x00],        &T32_ext_opc4fpA[9][0x00]},
    /* OP_vfnms_f64      */ {&A32_ext_opc4fpB[9][0x00],  &T32_ext_opc4fpB[9][0x00],        &T32_ext_opc4fpB[9][0x00]},
    /* OP_vhadd_s16      */ {&A32_ext_simd6[1][0x00],    &T32_ext_simd6[1][0x00],          &T32_ext_simd6[1][0x00]},
    /* OP_vhadd_s32      */ {&A32_ext_simd6[2][0x00],    &T32_ext_simd6[2][0x00],          &T32_ext_simd6[2][0x00]},
    /* OP_vhadd_s8       */ {&A32_ext_simd6[0][0x00],    &T32_ext_simd6[0][0x00],          &T32_ext_simd6[0][0x00]},
    /* OP_vhadd_u16      */ {&A32_ext_simd6[7][0x00],    &T32_ext_simd6[7][0x00],          &T32_ext_simd6[7][0x00]},
    /* OP_vhadd_u32      */ {&A32_ext_simd6[8][0x00],    &T32_ext_simd6[8][0x00],          &T32_ext_simd6[8][0x00]},
    /* OP_vhadd_u8       */ {&A32_ext_simd6[6][0x00],    &T32_ext_simd6[6][0x00],          &T32_ext_simd6[6][0x00]},
    /* OP_vhsub_s16      */ {&A32_ext_simd6[1][0x08],    &T32_ext_simd6[1][0x08],          &T32_ext_simd6[1][0x08]},
    /* OP_vhsub_s32      */ {&A32_ext_simd6[2][0x08],    &T32_ext_simd6[2][0x08],          &T32_ext_simd6[2][0x08]},
    /* OP_vhsub_s8       */ {&A32_ext_simd6[0][0x08],    &T32_ext_simd6[0][0x08],          &T32_ext_simd6[0][0x08]},
    /* OP_vhsub_u16      */ {&A32_ext_simd6[7][0x08],    &T32_ext_simd6[7][0x08],          &T32_ext_simd6[7][0x08]},
    /* OP_vhsub_u32      */ {&A32_ext_simd6[8][0x08],    &T32_ext_simd6[8][0x08],          &T32_ext_simd6[8][0x08]},
    /* OP_vhsub_u8       */ {&A32_ext_simd6[6][0x08],    &T32_ext_simd6[6][0x08],          &T32_ext_simd6[6][0x08]},
    /* OP_vld1_16        */ {&A32_ext_vldA[1][0x59],     &T32_ext_vldA[1][0x59],           &T32_ext_vldA[1][0x59]},
    /* OP_vld1_32        */ {&A32_ext_vldA[1][0x5c],     &T32_ext_vldA[1][0x5c],           &T32_ext_vldA[1][0x5c]},
    /* OP_vld1_64        */ {&A32_ext_vldA[1][0x5f],     &T32_ext_vldA[1][0x5f],           &T32_ext_vldA[1][0x5f]},
    /* OP_vld1_8         */ {&A32_ext_vldA[1][0x56],     &T32_ext_vldA[1][0x56],           &T32_ext_vldA[1][0x56]},
    /* OP_vld1_dup_16    */ {&A32_ext_vldD[0][0x0e],     &T32_ext_vldD[0][0x0e],           &T32_ext_vldD[0][0x0e]},
    /* OP_vld1_dup_32    */ {&A32_ext_vldD[0][0x1a],     &T32_ext_vldD[0][0x1a],           &T32_ext_vldD[0][0x1a]},
    /* OP_vld1_dup_8     */ {&A32_ext_vldD[0][0x02],     &T32_ext_vldD[0][0x02],           &T32_ext_vldD[0][0x02]},
    /* OP_vld1_lane_16   */ {&A32_ext_vldB[1][0x1a],     &T32_ext_vldB[1][0x1a],           &T32_ext_vldB[1][0x1a]},
    /* OP_vld1_lane_32   */ {&A32_ext_vldB[1][0x32],     &T32_ext_vldB[1][0x32],           &T32_ext_vldB[1][0x32]},
    /* OP_vld1_lane_8    */ {&A32_ext_vldB[1][0x02],     &T32_ext_vldB[1][0x02],           &T32_ext_vldB[1][0x02]},
    /* OP_vld2_16        */ {&A32_ext_vldA[1][0x71],     &T32_ext_vldA[1][0x71],           &T32_ext_vldA[1][0x71]},
    /* OP_vld2_32        */ {&A32_ext_vldA[1][0x74],     &T32_ext_vldA[1][0x74],           &T32_ext_vldA[1][0x74]},
    /* OP_vld2_8         */ {&A32_ext_vldA[1][0x6e],     &T32_ext_vldA[1][0x6e],           &T32_ext_vldA[1][0x6e]},
    /* OP_vld2_dup_16    */ {&A32_ext_vldC[0][0x0b],     &T32_ext_vldC[0][0x0b],           &T32_ext_vldC[0][0x0b]},
    /* OP_vld2_dup_32    */ {&A32_ext_vldC[0][0x11],     &T32_ext_vldC[0][0x11],           &T32_ext_vldC[0][0x11]},
    /* OP_vld2_dup_8     */ {&A32_ext_vldC[0][0x05],     &T32_ext_vldC[0][0x05],           &T32_ext_vldC[0][0x05]},
    /* OP_vld2_lane_16   */ {&A32_ext_vldB[1][0x23],     &T32_ext_vldB[1][0x23],           &T32_ext_vldB[1][0x23]},
    /* OP_vld2_lane_32   */ {&A32_ext_vldB[1][0x3b],     &T32_ext_vldB[1][0x3b],           &T32_ext_vldB[1][0x3b]},
    /* OP_vld2_lane_8    */ {&A32_ext_vldB[1][0x08],     &T32_ext_vldB[1][0x08],           &T32_ext_vldB[1][0x08]},
    /* OP_vld3_16        */ {&A32_ext_vldA[1][0x41],     &T32_ext_vldA[1][0x41],           &T32_ext_vldA[1][0x41]},
    /* OP_vld3_32        */ {&A32_ext_vldA[1][0x44],     &T32_ext_vldA[1][0x44],           &T32_ext_vldA[1][0x44]},
    /* OP_vld3_8         */ {&A32_ext_vldA[1][0x3e],     &T32_ext_vldA[1][0x3e],           &T32_ext_vldA[1][0x3e]},
    /* OP_vld3_dup_16    */ {&A32_ext_vldC[1][0x0b],     &T32_ext_vldC[1][0x0b],           &T32_ext_vldC[1][0x0b]},
    /* OP_vld3_dup_32    */ {&A32_ext_vldC[1][0x11],     &T32_ext_vldC[1][0x11],           &T32_ext_vldC[1][0x11]},
    /* OP_vld3_dup_8     */ {&A32_ext_vldC[1][0x05],     &T32_ext_vldC[1][0x05],           &T32_ext_vldC[1][0x05]},
    /* OP_vld3_lane_16   */ {&A32_ext_vldB[1][0x29],     &T32_ext_vldB[1][0x29],           &T32_ext_vldB[1][0x29]},
    /* OP_vld3_lane_32   */ {&A32_ext_vldB[1][0x41],     &T32_ext_vldB[1][0x41],           &T32_ext_vldB[1][0x41]},
    /* OP_vld3_lane_8    */ {&A32_ext_vldB[1][0x0e],     &T32_ext_vldB[1][0x0e],           &T32_ext_vldB[1][0x0e]},
    /* OP_vld4_16        */ {&A32_ext_vldA[1][0x11],     &T32_ext_vldA[1][0x11],           &T32_ext_vldA[1][0x11]},
    /* OP_vld4_32        */ {&A32_ext_vldA[1][0x14],     &T32_ext_vldA[1][0x14],           &T32_ext_vldA[1][0x14]},
    /* OP_vld4_8         */ {&A32_ext_vldA[1][0x0e],     &T32_ext_vldA[1][0x0e],           &T32_ext_vldA[1][0x0e]},
    /* OP_vld4_dup_16    */ {&A32_ext_vldD[1][0x14],     &T32_ext_vldD[1][0x14],           &T32_ext_vldD[1][0x14]},
    /* OP_vld4_dup_32    */ {&A32_ext_vldD[1][0x20],     &T32_ext_vldD[1][0x20],           &T32_ext_vldD[1][0x20]},
    /* OP_vld4_dup_8     */ {&A32_ext_vldD[1][0x08],     &T32_ext_vldD[1][0x08],           &T32_ext_vldD[1][0x08]},
    /* OP_vld4_lane_16   */ {&A32_ext_vldB[1][0x2f],     &T32_ext_vldB[1][0x2f],           &T32_ext_vldB[1][0x2f]},
    /* OP_vld4_lane_32   */ {&A32_ext_vldB[1][0x47],     &T32_ext_vldB[1][0x47],           &T32_ext_vldB[1][0x47]},
    /* OP_vld4_lane_8    */ {&A32_ext_vldB[1][0x14],     &T32_ext_vldB[1][0x14],           &T32_ext_vldB[1][0x14]},
    /* OP_vldm           */ {&A32_ext_fp[9][0x01],       &T32_ext_fp[9][0x01],             &T32_ext_fp[9][0x01]},
    /* OP_vldmdb         */ {&A32_ext_fp[17][0x01],      &T32_ext_fp[17][0x01],            &T32_ext_fp[17][0x01]},
    /* OP_vldr           */ {&A32_ext_fp[23][0x01],      &T32_ext_fp[23][0x01],            &T32_ext_fp[23][0x01]},
    /* OP_vmax_f32       */ {&A32_ext_simd6[0][0x3c],    &T32_ext_simd6[0][0x3c],          &T32_ext_simd6[0][0x3c]},
    /* OP_vmax_s16       */ {&A32_ext_simd6[1][0x18],    &T32_ext_simd6[1][0x18],          &T32_ext_simd6[1][0x18]},
    /* OP_vmax_s32       */ {&A32_ext_simd6[2][0x18],    &T32_ext_simd6[2][0x18],          &T32_ext_simd6[2][0x18]},
    /* OP_vmax_s8        */ {&A32_ext_simd6[0][0x18],    &T32_ext_simd6[0][0x18],          &T32_ext_simd6[0][0x18]},
    /* OP_vmax_u16       */ {&A32_ext_simd6[7][0x18],    &T32_ext_simd6[7][0x18],          &T32_ext_simd6[7][0x18]},
    /* OP_vmax_u32       */ {&A32_ext_simd6[8][0x18],    &T32_ext_simd6[8][0x18],          &T32_ext_simd6[8][0x18]},
    /* OP_vmax_u8        */ {&A32_ext_simd6[6][0x18],    &T32_ext_simd6[6][0x18],          &T32_ext_simd6[6][0x18]},
    /* OP_vmaxnm_f32     */ {&A32_ext_simd6[6][0x3d],    &T32_ext_simd6[6][0x3d],          &T32_ext_simd6[6][0x3d]},
    /* OP_vmaxnm_f64     */ {&A32_ext_bit6[2][0x00],     &T32_ext_bit6[2][0x00],           &T32_ext_bit6[2][0x00]},
    /* OP_vmin_f32       */ {&A32_ext_simd6[2][0x3c],    &T32_ext_simd6[2][0x3c],          &T32_ext_simd6[2][0x3c]},
    /* OP_vmin_s16       */ {&A32_ext_simd6[1][0x19],    &T32_ext_simd6[1][0x19],          &T32_ext_simd6[1][0x19]},
    /* OP_vmin_s32       */ {&A32_ext_simd6[2][0x19],    &T32_ext_simd6[2][0x19],          &T32_ext_simd6[2][0x19]},
    /* OP_vmin_s8        */ {&A32_ext_simd6[0][0x19],    &T32_ext_simd6[0][0x19],          &T32_ext_simd6[0][0x19]},
    /* OP_vmin_u16       */ {&A32_ext_simd6[7][0x19],    &T32_ext_simd6[7][0x19],          &T32_ext_simd6[7][0x19]},
    /* OP_vmin_u32       */ {&A32_ext_simd6[8][0x19],    &T32_ext_simd6[8][0x19],          &T32_ext_simd6[8][0x19]},
    /* OP_vmin_u8        */ {&A32_ext_simd6[6][0x19],    &T32_ext_simd6[6][0x19],          &T32_ext_simd6[6][0x19]},
    /* OP_vminnm_f32     */ {&A32_ext_simd6[8][0x3d],    &T32_ext_simd6[8][0x3d],          &T32_ext_simd6[8][0x3d]},
    /* OP_vminnm_f64     */ {&A32_ext_bit6[2][0x01],     &T32_ext_bit6[2][0x01],           &T32_ext_bit6[2][0x01]},
    /* OP_vmla_f32       */ {&A32_ext_simd6[5][0x06],    &T32_ext_simd6[5][0x06],          &T32_ext_simd6[5][0x06]},
    /* OP_vmla_f64       */ {&A32_ext_opc4fpB[0][0x00],  &T32_ext_opc4fpB[0][0x00],        &T32_ext_opc4fpB[0][0x00]},
    /* OP_vmla_i16       */ {&A32_ext_simd6[4][0x02],    &T32_ext_simd6[4][0x02],          &T32_ext_simd6[4][0x02]},
    /* OP_vmla_i32       */ {&A32_ext_simd6[5][0x02],    &T32_ext_simd6[5][0x02],          &T32_ext_simd6[5][0x02]},
    /* OP_vmla_i8        */ {&A32_ext_simd6[0][0x24],    &T32_ext_simd6[0][0x24],          &T32_ext_simd6[0][0x24]},
    /* OP_vmlal_s16      */ {&A32_ext_simd6[4][0x20],    &T32_ext_simd6[4][0x20],          &T32_ext_simd6[4][0x20]},
    /* OP_vmlal_s32      */ {&A32_ext_simd6[5][0x20],    &T32_ext_simd6[5][0x20],          &T32_ext_simd6[5][0x20]},
    /* OP_vmlal_s8       */ {&A32_ext_simd8[0][0x28],    &T32_ext_simd8[0][0x28],          &T32_ext_simd8[0][0x28]},
    /* OP_vmlal_u16      */ {&A32_ext_simd6[10][0x20],   &T32_ext_simd6[10][0x20],         &T32_ext_simd6[10][0x20]},
    /* OP_vmlal_u32      */ {&A32_ext_simd6[11][0x20],   &T32_ext_simd6[11][0x20],         &T32_ext_simd6[11][0x20]},
    /* OP_vmlal_u8       */ {&A32_ext_simd8[1][0x28],    &T32_ext_simd8[1][0x28],          &T32_ext_simd8[1][0x28]},
    /* OP_vmls_f32       */ {&A32_ext_simd6[5][0x16],    &T32_ext_simd6[5][0x16],          &T32_ext_simd6[5][0x16]},
    /* OP_vmls_f64       */ {&A32_ext_opc4fpB[0][0x04],  &T32_ext_opc4fpB[0][0x04],        &T32_ext_opc4fpB[0][0x04]},
    /* OP_vmls_i16       */ {&A32_ext_simd6[7][0x24],    &T32_ext_simd6[7][0x24],          &T32_ext_simd6[7][0x24]},
    /* OP_vmls_i32       */ {&A32_ext_simd6[8][0x24],    &T32_ext_simd6[8][0x24],          &T32_ext_simd6[8][0x24]},
    /* OP_vmls_i8        */ {&A32_ext_simd6[6][0x24],    &T32_ext_simd6[6][0x24],          &T32_ext_simd6[6][0x24]},
    /* OP_vmlsl_s16      */ {&A32_ext_simd6[4][0x28],    &T32_ext_simd6[4][0x28],          &T32_ext_simd6[4][0x28]},
    /* OP_vmlsl_s32      */ {&A32_ext_simd6[5][0x28],    &T32_ext_simd6[5][0x28],          &T32_ext_simd6[5][0x28]},
    /* OP_vmlsl_s8       */ {&A32_ext_simd8[0][0x32],    &T32_ext_simd8[0][0x32],          &T32_ext_simd8[0][0x32]},
    /* OP_vmlsl_u16      */ {&A32_ext_simd6[10][0x28],   &T32_ext_simd6[10][0x28],         &T32_ext_simd6[10][0x28]},
    /* OP_vmlsl_u32      */ {&A32_ext_simd6[11][0x28],   &T32_ext_simd6[11][0x28],         &T32_ext_simd6[11][0x28]},
    /* OP_vmlsl_u8       */ {&A32_ext_simd8[1][0x32],    &T32_ext_simd8[1][0x32],          &T32_ext_simd8[1][0x32]},
    /* OP_vmov           */ {&A32_ext_fp[3][0x01],       &T32_ext_fp[3][0x01],             &T32_ext_fp[3][0x01]},
    /* OP_vmov_16        */ {&A32_ext_opc4fpB[0][0x03],  &T32_ext_opc4fpB[0][0x03],        &T32_ext_opc4fpB[0][0x03]},
    /* OP_vmov_32        */ {&A32_ext_opc4fpB[1][0x01],  &T32_ext_opc4fpB[1][0x01],        &T32_ext_opc4fpB[1][0x01]},
    /* OP_vmov_8         */ {&A32_ext_opc4fpB[4][0x01],  &T32_ext_opc4fpB[4][0x01],        &T32_ext_opc4fpB[4][0x01]},
    /* OP_vmov_f32       */ {&A32_ext_simd8[0][0x4c],    &T32_ext_simd8[0][0x4c],          &T32_ext_simd8[0][0x4c]},
    /* OP_vmov_f64       */ {&A32_ext_opc4[8][0x00],     &T32_ext_opc4[1][0x00],           &T32_ext_opc4[1][0x00]},
    /* OP_vmov_i16       */ {&A32_ext_simd8[0][0x29],    &T32_ext_simd8[0][0x29],          &T32_ext_simd8[0][0x29]},
    /* OP_vmov_i32       */ {&A32_ext_simd8[0][0x01],    &T32_ext_simd8[0][0x01],          &T32_ext_simd8[0][0x01]},
    /* OP_vmov_i64       */ {&A32_ext_simd8[0][0x48],    &T32_ext_simd8[0][0x48],          &T32_ext_simd8[0][0x48]},
    /* OP_vmov_i8        */ {&A32_ext_simd8[0][0x47],    &T32_ext_simd8[0][0x47],          &T32_ext_simd8[0][0x47]},
    /* OP_vmov_s16       */ {&A32_ext_opc4fpB[1][0x03],  &T32_ext_opc4fpB[1][0x03],        &T32_ext_opc4fpB[1][0x03]},
    /* OP_vmov_s8        */ {&A32_ext_opc4fpB[5][0x01],  &T32_ext_opc4fpB[5][0x01],        &T32_ext_opc4fpB[5][0x01]},
    /* OP_vmov_u16       */ {&A32_ext_opc4fpB[9][0x03],  &T32_ext_opc4fpB[9][0x03],        &T32_ext_opc4fpB[9][0x03]},
    /* OP_vmov_u8        */ {&A32_ext_opc4fpB[12][0x01], &T32_ext_opc4fpB[12][0x01],       &T32_ext_opc4fpB[12][0x01]},
    /* OP_vmovl_s16      */ {&A32_ext_imm1916[1][0x00],  &T32_ext_imm1916[0][0x00],        &T32_ext_imm1916[0][0x00]},
    /* OP_vmovl_s32      */ {&A32_ext_imm2016[0][0x00],  &T32_ext_imm2016[0][0x00],        &T32_ext_imm2016[0][0x00]},
    /* OP_vmovl_s8       */ {&A32_ext_imm1816[0][0x00],  &T32_ext_imm1816[0][0x00],        &T32_ext_imm1816[0][0x00]},
    /* OP_vmovl_u16      */ {&A32_ext_imm1916[2][0x00],  &T32_ext_imm1916[1][0x00],        &T32_ext_imm1916[1][0x00]},
    /* OP_vmovl_u32      */ {&A32_ext_imm2016[1][0x00],  &T32_ext_imm2016[1][0x00],        &T32_ext_imm2016[1][0x00]},
    /* OP_vmovl_u8       */ {&A32_ext_imm1816[1][0x00],  &T32_ext_imm1816[1][0x00],        &T32_ext_imm1816[1][0x00]},
    /* OP_vmovn_i16      */ {&A32_ext_simd6b[1][0x08],   &T32_ext_simd6b[1][0x08],         &T32_ext_simd6b[1][0x08]},
    /* OP_vmovn_i32      */ {&A32_ext_simd6b[4][0x08],   &T32_ext_simd6b[4][0x08],         &T32_ext_simd6b[4][0x08]},
    /* OP_vmovn_i64      */ {&A32_ext_simd6b[7][0x08],   &T32_ext_simd6b[7][0x08],         &T32_ext_simd6b[7][0x08]},
    /* OP_vmrs           */ {&A32_ext_RBPC[0][0x01],     &T32_ext_RBPC[17][0x01],          &T32_ext_RBPC[17][0x01]},
    /* OP_vmsr           */ {&A32_ext_imm1916[3][0x00],  &T32_ext_imm1916[2][0x00],        &T32_ext_imm1916[2][0x00]},
    /* OP_vmul_f32       */ {&A32_ext_simd6[6][0x35],    &T32_ext_simd6[6][0x35],          &T32_ext_simd6[6][0x35]},
    /* OP_vmul_f64       */ {&A32_ext_opc4fpB[2][0x00],  &T32_ext_opc4fpB[2][0x00],        &T32_ext_opc4fpB[2][0x00]},
    /* OP_vmul_i16       */ {&A32_ext_simd6[4][0x22],    &T32_ext_simd6[4][0x22],          &T32_ext_simd6[4][0x22]},
    /* OP_vmul_i32       */ {&A32_ext_simd6[5][0x22],    &T32_ext_simd6[5][0x22],          &T32_ext_simd6[5][0x22]},
    /* OP_vmul_i8        */ {&A32_ext_simd6[0][0x25],    &T32_ext_simd6[0][0x25],          &T32_ext_simd6[0][0x25]},
    /* OP_vmul_p32       */ {&A32_ext_simd6[8][0x25],    &T32_ext_simd6[8][0x25],          &T32_ext_simd6[8][0x25]},
    /* OP_vmul_p8        */ {&A32_ext_simd6[6][0x25],    &T32_ext_simd6[6][0x25],          &T32_ext_simd6[6][0x25]},
    /* OP_vmull_p32      */ {&A32_ext_simd6[5][0x38],    &T32_ext_simd6[5][0x38],          &T32_ext_simd6[5][0x38]},
    /* OP_vmull_p8       */ {&A32_ext_simd8[0][0x46],    &T32_ext_simd8[0][0x46],          &T32_ext_simd8[0][0x46]},
    /* OP_vmull_s16      */ {&A32_ext_simd6[4][0x30],    &T32_ext_simd6[4][0x30],          &T32_ext_simd6[4][0x30]},
    /* OP_vmull_s32      */ {&A32_ext_simd6[5][0x30],    &T32_ext_simd6[5][0x30],          &T32_ext_simd6[5][0x30]},
    /* OP_vmull_s8       */ {&A32_ext_simd8[0][0x3c],    &T32_ext_simd8[0][0x3c],          &T32_ext_simd8[0][0x3c]},
    /* OP_vmull_u16      */ {&A32_ext_simd6[10][0x30],   &T32_ext_simd6[10][0x30],         &T32_ext_simd6[10][0x30]},
    /* OP_vmull_u32      */ {&A32_ext_simd6[11][0x30],   &T32_ext_simd6[11][0x30],         &T32_ext_simd6[11][0x30]},
    /* OP_vmull_u8       */ {&A32_ext_simd8[1][0x3c],    &T32_ext_simd8[1][0x3c],          &T32_ext_simd8[1][0x3c]},
    /* OP_vmvn           */ {&A32_ext_simd6b[9][0x16],   &T32_ext_simd6b[9][0x16],         &T32_ext_simd6b[9][0x16]},
    /* OP_vmvn_i16       */ {&A32_ext_simd8[0][0x2a],    &T32_ext_simd8[0][0x2a],          &T32_ext_simd8[0][0x2a]},
    /* OP_vmvn_i32       */ {&A32_ext_simd8[0][0x02],    &T32_ext_simd8[0][0x02],          &T32_ext_simd8[0][0x02]},
    /* OP_vneg_f32       */ {&A32_ext_simd6b[6][0x1e],   &T32_ext_simd6b[6][0x1e],         &T32_ext_simd6b[6][0x1e]},
    /* OP_vneg_f64       */ {&A32_ext_bits16[2][0x01],   &T32_ext_bits16[2][0x01],         &T32_ext_bits16[2][0x01]},
    /* OP_vneg_s16       */ {&A32_ext_simd6b[3][0x0e],   &T32_ext_simd6b[3][0x0e],         &T32_ext_simd6b[3][0x0e]},
    /* OP_vneg_s32       */ {&A32_ext_simd6b[6][0x0e],   &T32_ext_simd6b[6][0x0e],         &T32_ext_simd6b[6][0x0e]},
    /* OP_vneg_s8        */ {&A32_ext_simd6b[0][0x0e],   &T32_ext_simd6b[0][0x0e],         &T32_ext_simd6b[0][0x0e]},
    /* OP_vnmla_f32      */ {&A32_ext_opc4fpA[1][0x02],  &T32_ext_opc4fpA[1][0x02],        &T32_ext_opc4fpA[1][0x02]},
    /* OP_vnmla_f64      */ {&A32_ext_opc4fpB[1][0x04],  &T32_ext_opc4fpB[1][0x04],        &T32_ext_opc4fpB[1][0x04]},
    /* OP_vnmls_f32      */ {&A32_ext_opc4fpA[1][0x00],  &T32_ext_opc4fpA[1][0x00],        &T32_ext_opc4fpA[1][0x00]},
    /* OP_vnmls_f64      */ {&A32_ext_opc4fpB[1][0x00],  &T32_ext_opc4fpB[1][0x00],        &T32_ext_opc4fpB[1][0x00]},
    /* OP_vnmul_f32      */ {&A32_ext_opc4fpA[2][0x02],  &T32_ext_opc4fpA[2][0x02],        &T32_ext_opc4fpA[2][0x02]},
    /* OP_vnmul_f64      */ {&A32_ext_opc4fpB[2][0x04],  &T32_ext_opc4fpB[2][0x04],        &T32_ext_opc4fpB[2][0x04]},
    /* OP_vorn           */ {&A32_ext_simd6[3][0x05],    &T32_ext_simd6[3][0x05],          &T32_ext_simd6[3][0x05]},
    /* OP_vorr           */ {&A32_ext_simd6[2][0x05],    &T32_ext_simd6[2][0x05],          &T32_ext_simd6[2][0x05]},
    /* OP_vorr_i16       */ {&A32_ext_simd8[0][0x2e],    &T32_ext_simd8[0][0x2e],          &T32_ext_simd8[0][0x2e]},
    /* OP_vorr_i32       */ {&A32_ext_simd8[0][0x06],    &T32_ext_simd8[0][0x06],          &T32_ext_simd8[0][0x06]},
    /* OP_vpadal_s16     */ {&A32_ext_simd6b[2][0x18],   &T32_ext_simd6b[2][0x18],         &T32_ext_simd6b[2][0x18]},
    /* OP_vpadal_s32     */ {&A32_ext_simd6b[5][0x18],   &T32_ext_simd6b[5][0x18],         &T32_ext_simd6b[5][0x18]},
    /* OP_vpadal_s8      */ {&A32_ext_simd6b[9][0x18],   &T32_ext_simd6b[9][0x18],         &T32_ext_simd6b[9][0x18]},
    /* OP_vpadal_u16     */ {&A32_ext_simd6b[2][0x1a],   &T32_ext_simd6b[2][0x1a],         &T32_ext_simd6b[2][0x1a]},
    /* OP_vpadal_u32     */ {&A32_ext_simd6b[5][0x1a],   &T32_ext_simd6b[5][0x1a],         &T32_ext_simd6b[5][0x1a]},
    /* OP_vpadal_u8      */ {&A32_ext_simd6b[9][0x1a],   &T32_ext_simd6b[9][0x1a],         &T32_ext_simd6b[9][0x1a]},
    /* OP_vpadd_f32      */ {&A32_ext_simd6[6][0x34],    &T32_ext_simd6[6][0x34],          &T32_ext_simd6[6][0x34]},
    /* OP_vpadd_i16      */ {&A32_ext_simd6[1][0x2d],    &T32_ext_simd6[1][0x2d],          &T32_ext_simd6[1][0x2d]},
    /* OP_vpadd_i32      */ {&A32_ext_simd6[2][0x2d],    &T32_ext_simd6[2][0x2d],          &T32_ext_simd6[2][0x2d]},
    /* OP_vpadd_i8       */ {&A32_ext_simd6[0][0x2d],    &T32_ext_simd6[0][0x2d],          &T32_ext_simd6[0][0x2d]},
    /* OP_vpaddl_s16     */ {&A32_ext_simd6b[2][0x08],   &T32_ext_simd6b[2][0x08],         &T32_ext_simd6b[2][0x08]},
    /* OP_vpaddl_s32     */ {&A32_ext_simd6b[5][0x08],   &T32_ext_simd6b[5][0x08],         &T32_ext_simd6b[5][0x08]},
    /* OP_vpaddl_s8      */ {&A32_ext_simd6b[9][0x08],   &T32_ext_simd6b[9][0x08],         &T32_ext_simd6b[9][0x08]},
    /* OP_vpaddl_u16     */ {&A32_ext_simd6b[2][0x0a],   &T32_ext_simd6b[2][0x0a],         &T32_ext_simd6b[2][0x0a]},
    /* OP_vpaddl_u32     */ {&A32_ext_simd6b[5][0x0a],   &T32_ext_simd6b[5][0x0a],         &T32_ext_simd6b[5][0x0a]},
    /* OP_vpaddl_u8      */ {&A32_ext_simd6b[9][0x0a],   &T32_ext_simd6b[9][0x0a],         &T32_ext_simd6b[9][0x0a]},
    /* OP_vpmax_f32      */ {&A32_ext_simd6[6][0x3c],    &T32_ext_simd6[6][0x3c],          &T32_ext_simd6[6][0x3c]},
    /* OP_vpmax_s16      */ {&A32_ext_simd6[1][0x28],    &T32_ext_simd6[1][0x28],          &T32_ext_simd6[1][0x28]},
    /* OP_vpmax_s32      */ {&A32_ext_simd6[2][0x28],    &T32_ext_simd6[2][0x28],          &T32_ext_simd6[2][0x28]},
    /* OP_vpmax_s8       */ {&A32_ext_simd6[0][0x28],    &T32_ext_simd6[0][0x28],          &T32_ext_simd6[0][0x28]},
    /* OP_vpmax_u16      */ {&A32_ext_simd6[7][0x28],    &T32_ext_simd6[7][0x28],          &T32_ext_simd6[7][0x28]},
    /* OP_vpmax_u32      */ {&A32_ext_simd6[8][0x28],    &T32_ext_simd6[8][0x28],          &T32_ext_simd6[8][0x28]},
    /* OP_vpmax_u8       */ {&A32_ext_simd6[6][0x28],    &T32_ext_simd6[6][0x28],          &T32_ext_simd6[6][0x28]},
    /* OP_vpmin_f32      */ {&A32_ext_simd6[8][0x3c],    &T32_ext_simd6[8][0x3c],          &T32_ext_simd6[8][0x3c]},
    /* OP_vpmin_s16      */ {&A32_ext_simd6[1][0x29],    &T32_ext_simd6[1][0x29],          &T32_ext_simd6[1][0x29]},
    /* OP_vpmin_s32      */ {&A32_ext_simd6[2][0x29],    &T32_ext_simd6[2][0x29],          &T32_ext_simd6[2][0x29]},
    /* OP_vpmin_s8       */ {&A32_ext_simd6[0][0x29],    &T32_ext_simd6[0][0x29],          &T32_ext_simd6[0][0x29]},
    /* OP_vpmin_u16      */ {&A32_ext_simd6[7][0x29],    &T32_ext_simd6[7][0x29],          &T32_ext_simd6[7][0x29]},
    /* OP_vpmin_u32      */ {&A32_ext_simd6[8][0x29],    &T32_ext_simd6[8][0x29],          &T32_ext_simd6[8][0x29]},
    /* OP_vpmin_u8       */ {&A32_ext_simd6[6][0x29],    &T32_ext_simd6[6][0x29],          &T32_ext_simd6[6][0x29]},
    /* OP_vqabs_s16      */ {&A32_ext_simd6b[2][0x1c],   &T32_ext_simd6b[2][0x1c],         &T32_ext_simd6b[2][0x1c]},
    /* OP_vqabs_s32      */ {&A32_ext_simd6b[5][0x1c],   &T32_ext_simd6b[5][0x1c],         &T32_ext_simd6b[5][0x1c]},
    /* OP_vqabs_s8       */ {&A32_ext_simd6b[9][0x1c],   &T32_ext_simd6b[9][0x1c],         &T32_ext_simd6b[9][0x1c]},
    /* OP_vqadd_s16      */ {&A32_ext_simd6[1][0x01],    &T32_ext_simd6[1][0x01],          &T32_ext_simd6[1][0x01]},
    /* OP_vqadd_s32      */ {&A32_ext_simd6[2][0x01],    &T32_ext_simd6[2][0x01],          &T32_ext_simd6[2][0x01]},
    /* OP_vqadd_s64      */ {&A32_ext_simd6[3][0x01],    &T32_ext_simd6[3][0x01],          &T32_ext_simd6[3][0x01]},
    /* OP_vqadd_s8       */ {&A32_ext_simd6[0][0x01],    &T32_ext_simd6[0][0x01],          &T32_ext_simd6[0][0x01]},
    /* OP_vqadd_u16      */ {&A32_ext_simd6[7][0x01],    &T32_ext_simd6[7][0x01],          &T32_ext_simd6[7][0x01]},
    /* OP_vqadd_u32      */ {&A32_ext_simd6[8][0x01],    &T32_ext_simd6[8][0x01],          &T32_ext_simd6[8][0x01]},
    /* OP_vqadd_u64      */ {&A32_ext_simd6[9][0x01],    &T32_ext_simd6[9][0x01],          &T32_ext_simd6[9][0x01]},
    /* OP_vqadd_u8       */ {&A32_ext_simd6[6][0x01],    &T32_ext_simd6[6][0x01],          &T32_ext_simd6[6][0x01]},
    /* OP_vqdmlal_s16    */ {&A32_ext_simd6[4][0x24],    &T32_ext_simd6[4][0x24],          &T32_ext_simd6[4][0x24]},
    /* OP_vqdmlal_s32    */ {&A32_ext_simd6[5][0x24],    &T32_ext_simd6[5][0x24],          &T32_ext_simd6[5][0x24]},
    /* OP_vqdmlsl_s16    */ {&A32_ext_simd6[4][0x2c],    &T32_ext_simd6[4][0x2c],          &T32_ext_simd6[4][0x2c]},
    /* OP_vqdmlsl_s32    */ {&A32_ext_simd6[5][0x2c],    &T32_ext_simd6[5][0x2c],          &T32_ext_simd6[5][0x2c]},
    /* OP_vqdmulh_s16    */ {&A32_ext_simd6[4][0x32],    &T32_ext_simd6[4][0x32],          &T32_ext_simd6[4][0x32]},
    /* OP_vqdmulh_s32    */ {&A32_ext_simd6[5][0x32],    &T32_ext_simd6[5][0x32],          &T32_ext_simd6[5][0x32]},
    /* OP_vqdmull_s16    */ {&A32_ext_simd6[4][0x34],    &T32_ext_simd6[4][0x34],          &T32_ext_simd6[4][0x34]},
    /* OP_vqdmull_s32    */ {&A32_ext_simd6[5][0x34],    &T32_ext_simd6[5][0x34],          &T32_ext_simd6[5][0x34]},
    /* OP_vqmovn_s16     */ {&A32_ext_simd6b[1][0x0a],   &T32_ext_simd6b[1][0x0a],         &T32_ext_simd6b[1][0x0a]},
    /* OP_vqmovn_s32     */ {&A32_ext_simd6b[4][0x0a],   &T32_ext_simd6b[4][0x0a],         &T32_ext_simd6b[4][0x0a]},
    /* OP_vqmovn_s64     */ {&A32_ext_simd6b[7][0x0a],   &T32_ext_simd6b[7][0x0a],         &T32_ext_simd6b[7][0x0a]},
    /* OP_vqmovn_u16     */ {&A32_ext_simd6b[1][0x0b],   &T32_ext_simd6b[1][0x0b],         &T32_ext_simd6b[1][0x0b]},
    /* OP_vqmovn_u32     */ {&A32_ext_simd6b[4][0x0b],   &T32_ext_simd6b[4][0x0b],         &T32_ext_simd6b[4][0x0b]},
    /* OP_vqmovn_u64     */ {&A32_ext_simd6b[7][0x0b],   &T32_ext_simd6b[7][0x0b],         &T32_ext_simd6b[7][0x0b]},
    /* OP_vqmovun_s16    */ {&A32_ext_simd6b[1][0x09],   &T32_ext_simd6b[1][0x09],         &T32_ext_simd6b[1][0x09]},
    /* OP_vqmovun_s32    */ {&A32_ext_simd6b[4][0x09],   &T32_ext_simd6b[4][0x09],         &T32_ext_simd6b[4][0x09]},
    /* OP_vqmovun_s64    */ {&A32_ext_simd6b[7][0x09],   &T32_ext_simd6b[7][0x09],         &T32_ext_simd6b[7][0x09]},
    /* OP_vqneg_s16      */ {&A32_ext_simd6b[2][0x1e],   &T32_ext_simd6b[2][0x1e],         &T32_ext_simd6b[2][0x1e]},
    /* OP_vqneg_s32      */ {&A32_ext_simd6b[5][0x1e],   &T32_ext_simd6b[5][0x1e],         &T32_ext_simd6b[5][0x1e]},
    /* OP_vqneg_s8       */ {&A32_ext_simd6b[9][0x1e],   &T32_ext_simd6b[9][0x1e],         &T32_ext_simd6b[9][0x1e]},
    /* OP_vqrdmulh_s16   */ {&A32_ext_simd6[7][0x2c],    &T32_ext_simd6[7][0x2c],          &T32_ext_simd6[7][0x2c]},
    /* OP_vqrdmulh_s32   */ {&A32_ext_simd6[8][0x2c],    &T32_ext_simd6[8][0x2c],          &T32_ext_simd6[8][0x2c]},
    /* OP_vqrshl_s16     */ {&A32_ext_simd6[1][0x15],    &T32_ext_simd6[1][0x15],          &T32_ext_simd6[1][0x15]},
    /* OP_vqrshl_s32     */ {&A32_ext_simd6[2][0x15],    &T32_ext_simd6[2][0x15],          &T32_ext_simd6[2][0x15]},
    /* OP_vqrshl_s64     */ {&A32_ext_simd6[3][0x15],    &T32_ext_simd6[3][0x15],          &T32_ext_simd6[3][0x15]},
    /* OP_vqrshl_s8      */ {&A32_ext_simd6[0][0x15],    &T32_ext_simd6[0][0x15],          &T32_ext_simd6[0][0x15]},
    /* OP_vqrshl_u16     */ {&A32_ext_simd6[7][0x15],    &T32_ext_simd6[7][0x15],          &T32_ext_simd6[7][0x15]},
    /* OP_vqrshl_u32     */ {&A32_ext_simd6[8][0x15],    &T32_ext_simd6[8][0x15],          &T32_ext_simd6[8][0x15]},
    /* OP_vqrshl_u64     */ {&A32_ext_simd6[9][0x15],    &T32_ext_simd6[9][0x15],          &T32_ext_simd6[9][0x15]},
    /* OP_vqrshl_u8      */ {&A32_ext_simd6[6][0x15],    &T32_ext_simd6[6][0x15],          &T32_ext_simd6[6][0x15]},
    /* OP_vqrshrn_s16    */ {&A32_ext_simd5[0][0x13],    &T32_ext_simd5[0][0x13],          &T32_ext_simd5[0][0x13]},
    /* OP_vqrshrn_s32    */ {&A32_ext_simd6[4][0x27],    &T32_ext_simd6[4][0x27],          &T32_ext_simd6[4][0x27]},
    /* OP_vqrshrn_s64    */ {&A32_ext_simd6[5][0x27],    &T32_ext_simd6[5][0x27],          &T32_ext_simd6[5][0x27]},
    /* OP_vqrshrn_u16    */ {&A32_ext_simd5[1][0x13],    &T32_ext_simd5[1][0x13],          &T32_ext_simd5[1][0x13]},
    /* OP_vqrshrn_u32    */ {&A32_ext_simd6[10][0x27],   &T32_ext_simd6[10][0x27],         &T32_ext_simd6[10][0x27]},
    /* OP_vqrshrn_u64    */ {&A32_ext_simd6[11][0x27],   &T32_ext_simd6[11][0x27],         &T32_ext_simd6[11][0x27]},
    /* OP_vqrshrun_s16   */ {&A32_ext_simd5[1][0x11],    &T32_ext_simd5[1][0x11],          &T32_ext_simd5[1][0x11]},
    /* OP_vqrshrun_s32   */ {&A32_ext_simd6[10][0x23],   &T32_ext_simd6[10][0x23],         &T32_ext_simd6[10][0x23]},
    /* OP_vqrshrun_s64   */ {&A32_ext_simd6[11][0x23],   &T32_ext_simd6[11][0x23],         &T32_ext_simd6[11][0x23]},
    /* OP_vqshl_s16      */ {&A32_ext_simd6[4][0x1d],    &T32_ext_simd6[4][0x1d],          &T32_ext_simd6[4][0x1d]},
    /* OP_vqshl_s32      */ {&A32_ext_simd6[5][0x1d],    &T32_ext_simd6[5][0x1d],          &T32_ext_simd6[5][0x1d]},
    /* OP_vqshl_s64      */ {&A32_ext_imm6L[0][0x0e],    &T32_ext_imm6L[0][0x0e],          &T32_ext_imm6L[0][0x0e]},
    /* OP_vqshl_s8       */ {&A32_ext_simd5[0][0x0e],    &T32_ext_simd5[0][0x0e],          &T32_ext_simd5[0][0x0e]},
    /* OP_vqshl_u16      */ {&A32_ext_simd6[10][0x1d],   &T32_ext_simd6[10][0x1d],         &T32_ext_simd6[10][0x1d]},
    /* OP_vqshl_u32      */ {&A32_ext_simd6[11][0x1d],   &T32_ext_simd6[11][0x1d],         &T32_ext_simd6[11][0x1d]},
    /* OP_vqshl_u64      */ {&A32_ext_imm6L[1][0x0e],    &T32_ext_imm6L[1][0x0e],          &T32_ext_imm6L[1][0x0e]},
    /* OP_vqshl_u8       */ {&A32_ext_simd5[1][0x0e],    &T32_ext_simd5[1][0x0e],          &T32_ext_simd5[1][0x0e]},
    /* OP_vqshlu_s16     */ {&A32_ext_simd6[10][0x19],   &T32_ext_simd6[10][0x19],         &T32_ext_simd6[10][0x19]},
    /* OP_vqshlu_s32     */ {&A32_ext_simd6[11][0x19],   &T32_ext_simd6[11][0x19],         &T32_ext_simd6[11][0x19]},
    /* OP_vqshlu_s64     */ {&A32_ext_imm6L[1][0x0c],    &T32_ext_imm6L[1][0x0c],          &T32_ext_imm6L[1][0x0c]},
    /* OP_vqshlu_s8      */ {&A32_ext_simd5[1][0x0c],    &T32_ext_simd5[1][0x0c],          &T32_ext_simd5[1][0x0c]},
    /* OP_vqshrn_s16     */ {&A32_ext_simd5[0][0x12],    &T32_ext_simd5[0][0x12],          &T32_ext_simd5[0][0x12]},
    /* OP_vqshrn_s32     */ {&A32_ext_simd6[4][0x25],    &T32_ext_simd6[4][0x25],          &T32_ext_simd6[4][0x25]},
    /* OP_vqshrn_s64     */ {&A32_ext_simd6[5][0x25],    &T32_ext_simd6[5][0x25],          &T32_ext_simd6[5][0x25]},
    /* OP_vqshrn_u16     */ {&A32_ext_simd5[1][0x12],    &T32_ext_simd5[1][0x12],          &T32_ext_simd5[1][0x12]},
    /* OP_vqshrn_u32     */ {&A32_ext_simd6[10][0x25],   &T32_ext_simd6[10][0x25],         &T32_ext_simd6[10][0x25]},
    /* OP_vqshrn_u64     */ {&A32_ext_simd6[11][0x25],   &T32_ext_simd6[11][0x25],         &T32_ext_simd6[11][0x25]},
    /* OP_vqshrun_s16    */ {&A32_ext_simd5[1][0x10],    &T32_ext_simd5[1][0x10],          &T32_ext_simd5[1][0x10]},
    /* OP_vqshrun_s32    */ {&A32_ext_simd6[10][0x21],   &T32_ext_simd6[10][0x21],         &T32_ext_simd6[10][0x21]},
    /* OP_vqshrun_s64    */ {&A32_ext_simd6[11][0x21],   &T32_ext_simd6[11][0x21],         &T32_ext_simd6[11][0x21]},
    /* OP_vqsub_s16      */ {&A32_ext_simd6[1][0x09],    &T32_ext_simd6[1][0x09],          &T32_ext_simd6[1][0x09]},
    /* OP_vqsub_s32      */ {&A32_ext_simd6[2][0x09],    &T32_ext_simd6[2][0x09],          &T32_ext_simd6[2][0x09]},
    /* OP_vqsub_s64      */ {&A32_ext_simd6[3][0x09],    &T32_ext_simd6[3][0x09],          &T32_ext_simd6[3][0x09]},
    /* OP_vqsub_s8       */ {&A32_ext_simd6[0][0x09],     &T32_ext_simd6[0][0x09],         &T32_ext_simd6[0][0x09]},
    /* OP_vqsub_u16      */ {&A32_ext_simd6[7][0x09],    &T32_ext_simd6[7][0x09],          &T32_ext_simd6[7][0x09]},
    /* OP_vqsub_u32      */ {&A32_ext_simd6[8][0x09],    &T32_ext_simd6[8][0x09],          &T32_ext_simd6[8][0x09]},
    /* OP_vqsub_u64      */ {&A32_ext_simd6[9][0x09],    &T32_ext_simd6[9][0x09],          &T32_ext_simd6[9][0x09]},
    /* OP_vqsub_u8       */ {&A32_ext_simd6[6][0x09],     &T32_ext_simd6[6][0x09],         &T32_ext_simd6[6][0x09]},
    /* OP_vraddhn_i16    */ {&A32_ext_simd8[1][0x14],    &T32_ext_simd8[1][0x14],          &T32_ext_simd8[1][0x14]},
    /* OP_vraddhn_i32    */ {&A32_ext_simd6[10][0x10],   &T32_ext_simd6[10][0x10],         &T32_ext_simd6[10][0x10]},
    /* OP_vraddhn_i64    */ {&A32_ext_simd6[11][0x10],   &T32_ext_simd6[11][0x10],         &T32_ext_simd6[11][0x10]},
    /* OP_vrecpe_f32     */ {&A32_ext_simd6b[8][0x14],   &T32_ext_simd6b[8][0x14],         &T32_ext_simd6b[8][0x14]},
    /* OP_vrecpe_u32     */ {&A32_ext_simd6b[8][0x10],   &T32_ext_simd6b[8][0x10],         &T32_ext_simd6b[8][0x10]},
    /* OP_vrecps_f32     */ {&A32_ext_simd6[0][0x3d],    &T32_ext_simd6[0][0x3d],          &T32_ext_simd6[0][0x3d]},
    /* OP_vrev16_16      */ {&A32_ext_simd6b[2][0x04],   &T32_ext_simd6b[2][0x04],         &T32_ext_simd6b[2][0x04]},
    /* OP_vrev16_8       */ {&A32_ext_simd6b[9][0x04],   &T32_ext_simd6b[9][0x04],         &T32_ext_simd6b[9][0x04]},
    /* OP_vrev32_16      */ {&A32_ext_simd6b[2][0x02],   &T32_ext_simd6b[2][0x02],         &T32_ext_simd6b[2][0x02]},
    /* OP_vrev32_32      */ {&A32_ext_simd6b[5][0x02],   &T32_ext_simd6b[5][0x02],         &T32_ext_simd6b[5][0x02]},
    /* OP_vrev32_8       */ {&A32_ext_simd6b[9][0x02],   &T32_ext_simd6b[9][0x02],         &T32_ext_simd6b[9][0x02]},
    /* OP_vrev64_16      */ {&A32_ext_simd6b[2][0x00],   &T32_ext_simd6b[2][0x00],         &T32_ext_simd6b[2][0x00]},
    /* OP_vrev64_32      */ {&A32_ext_simd6b[5][0x00],   &T32_ext_simd6b[5][0x00],         &T32_ext_simd6b[5][0x00]},
    /* OP_vrev64_8       */ {&A32_ext_simd6b[9][0x00],   &T32_ext_simd6b[9][0x00],         &T32_ext_simd6b[9][0x00]},
    /* OP_vrhadd_s16     */ {&A32_ext_simd6[1][0x04],    &T32_ext_simd6[1][0x04],          &T32_ext_simd6[1][0x04]},
    /* OP_vrhadd_s32     */ {&A32_ext_simd6[2][0x04],    &T32_ext_simd6[2][0x04],          &T32_ext_simd6[2][0x04]},
    /* OP_vrhadd_s8      */ {&A32_ext_simd6[0][0x04],    &T32_ext_simd6[0][0x04],          &T32_ext_simd6[0][0x04]},
    /* OP_vrhadd_u16     */ {&A32_ext_simd6[7][0x04],    &T32_ext_simd6[7][0x04],          &T32_ext_simd6[7][0x04]},
    /* OP_vrhadd_u32     */ {&A32_ext_simd6[8][0x04],    &T32_ext_simd6[8][0x04],          &T32_ext_simd6[8][0x04]},
    /* OP_vrhadd_u8      */ {&A32_ext_simd6[6][0x04],    &T32_ext_simd6[6][0x04],          &T32_ext_simd6[6][0x04]},
    /* OP_vrinta_f32_f32 */ {&A32_ext_simd6b[7][0x14],   &T32_ext_simd6b[7][0x14],         &T32_ext_simd6b[7][0x14]},
    /* OP_vrinta_f64_f64 */ {&A32_ext_simd5b[0][0x02],   &T32_ext_simd5b[0][0x02],         &T32_ext_simd5b[0][0x02]},
    /* OP_vrintm_f32_f32 */ {&A32_ext_simd6b[7][0x1a],   &T32_ext_simd6b[7][0x1a],         &T32_ext_simd6b[7][0x1a]},
    /* OP_vrintm_f64_f64 */ {&A32_ext_simd5b[0][0x0e],   &T32_ext_simd5b[0][0x0e],         &T32_ext_simd5b[0][0x0e]},
    /* OP_vrintn_f32_f32 */ {&A32_ext_simd6b[7][0x10],   &T32_ext_simd6b[7][0x10],         &T32_ext_simd6b[7][0x10]},
    /* OP_vrintn_f64_f64 */ {&A32_ext_simd5b[0][0x06],   &T32_ext_simd5b[0][0x06],         &T32_ext_simd5b[0][0x06]},
    /* OP_vrintp_f32_f32 */ {&A32_ext_simd6b[7][0x1e],   &T32_ext_simd6b[7][0x1e],         &T32_ext_simd6b[7][0x1e]},
    /* OP_vrintp_f64_f64 */ {&A32_ext_simd5b[0][0x0a],   &T32_ext_simd5b[0][0x0a],         &T32_ext_simd5b[0][0x0a]},
    /* OP_vrintr_f32     */ {&A32_ext_bits16[0][0x06],   &T32_ext_bits16[0][0x06],         &T32_ext_bits16[0][0x06]},
    /* OP_vrintr_f64     */ {&A32_ext_bits16[2][0x06],   &T32_ext_bits16[2][0x06],         &T32_ext_bits16[2][0x06]},
    /* OP_vrintx_f32     */ {&A32_ext_bits16[0][0x07],   &T32_ext_bits16[0][0x07],         &T32_ext_bits16[0][0x07]},
    /* OP_vrintx_f32_f32 */ {&A32_ext_simd6b[7][0x12],   &T32_ext_simd6b[7][0x12],         &T32_ext_simd6b[7][0x12]},
    /* OP_vrintx_f64     */ {&A32_ext_bits16[2][0x07],   &T32_ext_bits16[2][0x07],         &T32_ext_bits16[2][0x07]},
    /* OP_vrintz_f32     */ {&A32_ext_bits16[1][0x06],   &T32_ext_bits16[1][0x06],         &T32_ext_bits16[1][0x06]},
    /* OP_vrintz_f32_f32 */ {&A32_ext_simd6b[7][0x16],   &T32_ext_simd6b[7][0x16],         &T32_ext_simd6b[7][0x16]},
    /* OP_vrintz_f64     */ {&A32_ext_bits16[3][0x06],   &T32_ext_bits16[3][0x06],         &T32_ext_bits16[3][0x06]},
    /* OP_vrshl_s16      */ {&A32_ext_simd6[1][0x14],    &T32_ext_simd6[1][0x14],          &T32_ext_simd6[1][0x14]},
    /* OP_vrshl_s32      */ {&A32_ext_simd6[2][0x14],    &T32_ext_simd6[2][0x14],          &T32_ext_simd6[2][0x14]},
    /* OP_vrshl_s64      */ {&A32_ext_simd6[3][0x14],    &T32_ext_simd6[3][0x14],          &T32_ext_simd6[3][0x14]},
    /* OP_vrshl_s8       */ {&A32_ext_simd6[0][0x14],    &T32_ext_simd6[0][0x14],          &T32_ext_simd6[0][0x14]},
    /* OP_vrshl_u16      */ {&A32_ext_simd6[7][0x14],    &T32_ext_simd6[7][0x14],          &T32_ext_simd6[7][0x14]},
    /* OP_vrshl_u32      */ {&A32_ext_simd6[8][0x14],    &T32_ext_simd6[8][0x14],          &T32_ext_simd6[8][0x14]},
    /* OP_vrshl_u64      */ {&A32_ext_simd6[9][0x14],    &T32_ext_simd6[9][0x14],          &T32_ext_simd6[9][0x14]},
    /* OP_vrshl_u8       */ {&A32_ext_simd6[6][0x14],    &T32_ext_simd6[6][0x14],          &T32_ext_simd6[6][0x14]},
    /* OP_vrshr_s16      */ {&A32_ext_simd6[4][0x09],    &T32_ext_simd6[4][0x09],          &T32_ext_simd6[4][0x09]},
    /* OP_vrshr_s32      */ {&A32_ext_simd6[5][0x09],    &T32_ext_simd6[5][0x09],          &T32_ext_simd6[5][0x09]},
    /* OP_vrshr_s64      */ {&A32_ext_imm6L[0][0x04],     &T32_ext_imm6L[0][0x04],         &T32_ext_imm6L[0][0x04]},
    /* OP_vrshr_s8       */ {&A32_ext_simd5[0][0x04],    &T32_ext_simd5[0][0x04],          &T32_ext_simd5[0][0x04]},
    /* OP_vrshr_u16      */ {&A32_ext_simd6[10][0x09],   &T32_ext_simd6[10][0x09],         &T32_ext_simd6[10][0x09]},
    /* OP_vrshr_u32      */ {&A32_ext_simd6[11][0x09],   &T32_ext_simd6[11][0x09],         &T32_ext_simd6[11][0x09]},
    /* OP_vrshr_u64      */ {&A32_ext_imm6L[1][0x04],     &T32_ext_imm6L[1][0x04],         &T32_ext_imm6L[1][0x04]},
    /* OP_vrshr_u8       */ {&A32_ext_simd5[1][0x04],    &T32_ext_simd5[1][0x04],          &T32_ext_simd5[1][0x04]},
    /* OP_vrshrn_i16     */ {&A32_ext_simd5[0][0x11],    &T32_ext_simd5[0][0x11],          &T32_ext_simd5[0][0x11]},
    /* OP_vrshrn_i32     */ {&A32_ext_simd6[4][0x23],    &T32_ext_simd6[4][0x23],          &T32_ext_simd6[4][0x23]},
    /* OP_vrshrn_i64     */ {&A32_ext_simd6[5][0x23],    &T32_ext_simd6[5][0x23],          &T32_ext_simd6[5][0x23]},
    /* OP_vrsqrte_f32    */ {&A32_ext_simd6b[8][0x16],   &T32_ext_simd6b[8][0x16],         &T32_ext_simd6b[8][0x16]},
    /* OP_vrsqrte_u32    */ {&A32_ext_simd6b[8][0x12],   &T32_ext_simd6b[8][0x12],         &T32_ext_simd6b[8][0x12]},
    /* OP_vrsqrts_f32    */ {&A32_ext_simd6[2][0x3d],    &T32_ext_simd6[2][0x3d],          &T32_ext_simd6[2][0x3d]},
    /* OP_vrsra_s16      */ {&A32_ext_simd6[4][0x0d],    &T32_ext_simd6[4][0x0d],          &T32_ext_simd6[4][0x0d]},
    /* OP_vrsra_s32      */ {&A32_ext_simd6[5][0x0d],    &T32_ext_simd6[5][0x0d],          &T32_ext_simd6[5][0x0d]},
    /* OP_vrsra_s64      */ {&A32_ext_imm6L[0][0x06],    &T32_ext_imm6L[0][0x06],          &T32_ext_imm6L[0][0x06]},
    /* OP_vrsra_s8       */ {&A32_ext_simd5[0][0x06],    &T32_ext_simd5[0][0x06],          &T32_ext_simd5[0][0x06]},
    /* OP_vrsra_u16      */ {&A32_ext_simd6[10][0x0d],   &T32_ext_simd6[10][0x0d],         &T32_ext_simd6[10][0x0d]},
    /* OP_vrsra_u32      */ {&A32_ext_simd6[11][0x0d],   &T32_ext_simd6[11][0x0d],         &T32_ext_simd6[11][0x0d]},
    /* OP_vrsra_u64      */ {&A32_ext_imm6L[1][0x06],    &T32_ext_imm6L[1][0x06],          &T32_ext_imm6L[1][0x06]},
    /* OP_vrsra_u8       */ {&A32_ext_simd5[1][0x06],    &T32_ext_simd5[1][0x06],          &T32_ext_simd5[1][0x06]},
    /* OP_vrsubhn_i16    */ {&A32_ext_simd8[1][0x1e],    &T32_ext_simd8[1][0x1e],          &T32_ext_simd8[1][0x1e]},
    /* OP_vrsubhn_i32    */ {&A32_ext_simd6[10][0x18],   &T32_ext_simd6[10][0x18],         &T32_ext_simd6[10][0x18]},
    /* OP_vrsubhn_i64    */ {&A32_ext_simd6[11][0x18],   &T32_ext_simd6[11][0x18],         &T32_ext_simd6[11][0x18]},
    /* OP_vsel_eq_f32    */ {&A32_ext_fp[46][0x00],      &T32_ext_fp[46][0x00],            &T32_ext_fp[46][0x00]},
    /* OP_vsel_eq_f64    */ {&A32_ext_fp[46][0x01],      &T32_ext_fp[46][0x01],            &T32_ext_fp[46][0x01]},
    /* OP_vsel_ge_f32    */ {&A32_ext_fp[48][0x00],      &T32_ext_fp[48][0x00],            &T32_ext_fp[48][0x00]},
    /* OP_vsel_ge_f64    */ {&A32_ext_fp[48][0x01],      &T32_ext_fp[48][0x01],            &T32_ext_fp[48][0x01]},
    /* OP_vsel_gt_f32    */ {&A32_ext_fp[49][0x00],      &T32_ext_fp[49][0x00],            &T32_ext_fp[49][0x00]},
    /* OP_vsel_gt_f64    */ {&A32_ext_fp[49][0x01],      &T32_ext_fp[49][0x01],            &T32_ext_fp[49][0x01]},
    /* OP_vsel_vs_f32    */ {&A32_ext_fp[47][0x00],      &T32_ext_fp[47][0x00],            &T32_ext_fp[47][0x00]},
    /* OP_vsel_vs_f64    */ {&A32_ext_fp[47][0x01],      &T32_ext_fp[47][0x01],            &T32_ext_fp[47][0x01]},
    /* OP_vshl_i16       */ {&A32_ext_simd6[4][0x15],    &T32_ext_simd6[4][0x15],          &T32_ext_simd6[4][0x15]},
    /* OP_vshl_i32       */ {&A32_ext_simd6[5][0x15],    &T32_ext_simd6[5][0x15],          &T32_ext_simd6[5][0x15]},
    /* OP_vshl_i64       */ {&A32_ext_imm6L[0][0x0a],    &T32_ext_imm6L[0][0x0a],          &T32_ext_imm6L[0][0x0a]},
    /* OP_vshl_i8        */ {&A32_ext_simd5[0][0x0a],    &T32_ext_simd5[0][0x0a],          &T32_ext_simd5[0][0x0a]},
    /* OP_vshl_s16       */ {&A32_ext_simd6[1][0x10],    &T32_ext_simd6[1][0x10],          &T32_ext_simd6[1][0x10]},
    /* OP_vshl_s32       */ {&A32_ext_simd6[2][0x10],    &T32_ext_simd6[2][0x10],          &T32_ext_simd6[2][0x10]},
    /* OP_vshl_s64       */ {&A32_ext_simd6[3][0x10],    &T32_ext_simd6[3][0x10],          &T32_ext_simd6[3][0x10]},
    /* OP_vshl_s8        */ {&A32_ext_simd6[0][0x10],    &T32_ext_simd6[0][0x10],          &T32_ext_simd6[0][0x10]},
    /* OP_vshl_u16       */ {&A32_ext_simd6[7][0x10],    &T32_ext_simd6[7][0x10],          &T32_ext_simd6[7][0x10]},
    /* OP_vshl_u32       */ {&A32_ext_simd6[8][0x10],    &T32_ext_simd6[8][0x10],          &T32_ext_simd6[8][0x10]},
    /* OP_vshl_u64       */ {&A32_ext_simd6[9][0x10],    &T32_ext_simd6[9][0x10],          &T32_ext_simd6[9][0x10]},
    /* OP_vshl_u8        */ {&A32_ext_simd6[6][0x10],    &T32_ext_simd6[6][0x10],          &T32_ext_simd6[6][0x10]},
    /* OP_vshll_i16      */ {&A32_ext_simd6b[4][0x0c],   &T32_ext_simd6b[4][0x0c],         &T32_ext_simd6b[4][0x0c]},
    /* OP_vshll_i32      */ {&A32_ext_simd6b[7][0x0c],   &T32_ext_simd6b[7][0x0c],         &T32_ext_simd6b[7][0x0c]},
    /* OP_vshll_i8       */ {&A32_ext_simd6b[1][0x0c],   &T32_ext_simd6b[1][0x0c],         &T32_ext_simd6b[1][0x0c]},
    /* OP_vshll_s16      */ {&A32_ext_imm1916[1][0x01],  &T32_ext_imm1916[0][0x01],        &T32_ext_imm1916[0][0x01]},
    /* OP_vshll_s32      */ {&A32_ext_imm2016[0][0x01],  &T32_ext_imm2016[0][0x01],        &T32_ext_imm2016[0][0x01]},
    /* OP_vshll_s8       */ {&A32_ext_imm1816[0][0x01],  &T32_ext_imm1816[0][0x01],        &T32_ext_imm1816[0][0x01]},
    /* OP_vshll_u16      */ {&A32_ext_imm1916[2][0x01],  &T32_ext_imm1916[1][0x01],        &T32_ext_imm1916[1][0x01]},
    /* OP_vshll_u32      */ {&A32_ext_imm2016[1][0x01],  &T32_ext_imm2016[1][0x01],        &T32_ext_imm2016[1][0x01]},
    /* OP_vshll_u8       */ {&A32_ext_imm1816[1][0x01],  &T32_ext_imm1816[1][0x01],        &T32_ext_imm1816[1][0x01]},
    /* OP_vshr_s16       */ {&A32_ext_simd6[4][0x01],    &T32_ext_simd6[4][0x01],          &T32_ext_simd6[4][0x01]},
    /* OP_vshr_s32       */ {&A32_ext_simd6[5][0x01],    &T32_ext_simd6[5][0x01],          &T32_ext_simd6[5][0x01]},
    /* OP_vshr_s64       */ {&A32_ext_imm6L[0][0x00],    &T32_ext_imm6L[0][0x00],          &T32_ext_imm6L[0][0x00]},
    /* OP_vshr_s8        */ {&A32_ext_simd5[0][0x00],    &T32_ext_simd5[0][0x00],          &T32_ext_simd5[0][0x00]},
    /* OP_vshr_u16       */ {&A32_ext_simd6[10][0x01],   &T32_ext_simd6[10][0x01],         &T32_ext_simd6[10][0x01]},
    /* OP_vshr_u32       */ {&A32_ext_simd6[11][0x01],   &T32_ext_simd6[11][0x01],         &T32_ext_simd6[11][0x01]},
    /* OP_vshr_u64       */ {&A32_ext_imm6L[1][0x00],    &T32_ext_imm6L[1][0x00],          &T32_ext_imm6L[1][0x00]},
    /* OP_vshr_u8        */ {&A32_ext_simd5[1][0x00],    &T32_ext_simd5[1][0x00],          &T32_ext_simd5[1][0x00]},
    /* OP_vshrn_i16      */ {&A32_ext_simd5[0][0x10],    &T32_ext_simd5[0][0x10],          &T32_ext_simd5[0][0x10]},
    /* OP_vshrn_i32      */ {&A32_ext_simd6[4][0x21],    &T32_ext_simd6[4][0x21],          &T32_ext_simd6[4][0x21]},
    /* OP_vshrn_i64      */ {&A32_ext_simd6[5][0x21],    &T32_ext_simd6[5][0x21],          &T32_ext_simd6[5][0x21]},
    /* OP_vsli_16        */ {&A32_ext_simd6[10][0x15],   &T32_ext_simd6[10][0x15],         &T32_ext_simd6[10][0x15]},
    /* OP_vsli_32        */ {&A32_ext_simd6[11][0x15],   &T32_ext_simd6[11][0x15],         &T32_ext_simd6[11][0x15]},
    /* OP_vsli_64        */ {&A32_ext_imm6L[1][0x0a],    &T32_ext_imm6L[1][0x0a],          &T32_ext_imm6L[1][0x0a]},
    /* OP_vsli_8         */ {&A32_ext_simd5[1][0x0a],    &T32_ext_simd5[1][0x0a],          &T32_ext_simd5[1][0x0a]},
    /* OP_vsqrt_f32      */ {&A32_ext_bits16[1][0x01],   &T32_ext_bits16[1][0x01],         &T32_ext_bits16[1][0x01]},
    /* OP_vsqrt_f64      */ {&A32_ext_bits16[3][0x01],   &T32_ext_bits16[3][0x01],         &T32_ext_bits16[3][0x01]},
    /* OP_vsra_s16       */ {&A32_ext_simd6[4][0x05],    &T32_ext_simd6[4][0x05],          &T32_ext_simd6[4][0x05]},
    /* OP_vsra_s32       */ {&A32_ext_simd6[5][0x05],    &T32_ext_simd6[5][0x05],          &T32_ext_simd6[5][0x05]},
    /* OP_vsra_s64       */ {&A32_ext_imm6L[0][0x02],     &T32_ext_imm6L[0][0x02],         &T32_ext_imm6L[0][0x02]},
    /* OP_vsra_s8        */ {&A32_ext_simd5[0][0x02],    &T32_ext_simd5[0][0x02],          &T32_ext_simd5[0][0x02]},
    /* OP_vsra_u16       */ {&A32_ext_simd6[10][0x05],   &T32_ext_simd6[10][0x05],         &T32_ext_simd6[10][0x05]},
    /* OP_vsra_u32       */ {&A32_ext_simd6[11][0x05],   &T32_ext_simd6[11][0x05],         &T32_ext_simd6[11][0x05]},
    /* OP_vsra_u64       */ {&A32_ext_imm6L[1][0x02],     &T32_ext_imm6L[1][0x02],         &T32_ext_imm6L[1][0x02]},
    /* OP_vsra_u8        */ {&A32_ext_simd5[1][0x02],    &T32_ext_simd5[1][0x02],          &T32_ext_simd5[1][0x02]},
    /* OP_vsri_16        */ {&A32_ext_simd6[10][0x11],   &T32_ext_simd6[10][0x11],         &T32_ext_simd6[10][0x11]},
    /* OP_vsri_32        */ {&A32_ext_simd6[11][0x11],   &T32_ext_simd6[11][0x11],         &T32_ext_simd6[11][0x11]},
    /* OP_vsri_64        */ {&A32_ext_imm6L[1][0x08],    &T32_ext_imm6L[1][0x08],          &T32_ext_imm6L[1][0x08]},
    /* OP_vsri_8         */ {&A32_ext_simd5[1][0x08],    &T32_ext_simd5[1][0x08],          &T32_ext_simd5[1][0x08]},
    /* OP_vst1_16        */ {&A32_ext_vldA[0][0x59],     &T32_ext_vldA[0][0x59],           &T32_ext_vldA[0][0x59]},
    /* OP_vst1_32        */ {&A32_ext_vldA[0][0x5c],     &T32_ext_vldA[0][0x5c],           &T32_ext_vldA[0][0x5c]},
    /* OP_vst1_64        */ {&A32_ext_vldA[0][0x5f],     &T32_ext_vldA[0][0x5f],           &T32_ext_vldA[0][0x5f]},
    /* OP_vst1_8         */ {&A32_ext_vldA[0][0x56],     &T32_ext_vldA[0][0x56],           &T32_ext_vldA[0][0x56]},
    /* OP_vst1_lane_16   */ {&A32_ext_vldB[0][0x1a],     &T32_ext_vldB[0][0x1a],           &T32_ext_vldB[0][0x1a]},
    /* OP_vst1_lane_32   */ {&A32_ext_vldB[0][0x32],     &T32_ext_vldB[0][0x32],           &T32_ext_vldB[0][0x32]},
    /* OP_vst1_lane_8    */ {&A32_ext_vldB[0][0x02],     &T32_ext_vldB[0][0x02],           &T32_ext_vldB[0][0x02]},
    /* OP_vst2_16        */ {&A32_ext_vldA[0][0x71],     &T32_ext_vldA[0][0x71],           &T32_ext_vldA[0][0x71]},
    /* OP_vst2_32        */ {&A32_ext_vldA[0][0x74],     &T32_ext_vldA[0][0x74],           &T32_ext_vldA[0][0x74]},
    /* OP_vst2_8         */ {&A32_ext_vldA[0][0x6e],     &T32_ext_vldA[0][0x6e],           &T32_ext_vldA[0][0x6e]},
    /* OP_vst2_lane_16   */ {&A32_ext_vldB[0][0x23],     &T32_ext_vldB[0][0x23],           &T32_ext_vldB[0][0x23]},
    /* OP_vst2_lane_32   */ {&A32_ext_vldB[0][0x3b],     &T32_ext_vldB[0][0x3b],           &T32_ext_vldB[0][0x3b]},
    /* OP_vst2_lane_8    */ {&A32_ext_vldB[0][0x08],     &T32_ext_vldB[0][0x08],           &T32_ext_vldB[0][0x08]},
    /* OP_vst3_16        */ {&A32_ext_vldA[0][0x41],     &T32_ext_vldA[0][0x41],           &T32_ext_vldA[0][0x41]},
    /* OP_vst3_32        */ {&A32_ext_vldA[0][0x44],     &T32_ext_vldA[0][0x44],           &T32_ext_vldA[0][0x44]},
    /* OP_vst3_8         */ {&A32_ext_vldA[0][0x3e],     &T32_ext_vldA[0][0x3e],           &T32_ext_vldA[0][0x3e]},
    /* OP_vst3_lane_16   */ {&A32_ext_vldB[0][0x29],     &T32_ext_vldB[0][0x29],           &T32_ext_vldB[0][0x29]},
    /* OP_vst3_lane_32   */ {&A32_ext_vldB[0][0x41],     &T32_ext_vldB[0][0x41],           &T32_ext_vldB[0][0x41]},
    /* OP_vst3_lane_8    */ {&A32_ext_vldB[0][0x0e],     &T32_ext_vldB[0][0x0e],           &T32_ext_vldB[0][0x0e]},
    /* OP_vst4_16        */ {&A32_ext_vldA[0][0x11],     &T32_ext_vldA[0][0x11],           &T32_ext_vldA[0][0x11]},
    /* OP_vst4_32        */ {&A32_ext_vldA[0][0x14],     &T32_ext_vldA[0][0x14],           &T32_ext_vldA[0][0x14]},
    /* OP_vst4_8         */ {&A32_ext_vldA[0][0x0e],     &T32_ext_vldA[0][0x0e],           &T32_ext_vldA[0][0x0e]},
    /* OP_vst4_lane_16   */ {&A32_ext_vldB[0][0x2f],     &T32_ext_vldB[0][0x2f],           &T32_ext_vldB[0][0x2f]},
    /* OP_vst4_lane_32   */ {&A32_ext_vldB[0][0x47],     &T32_ext_vldB[0][0x47],           &T32_ext_vldB[0][0x47]},
    /* OP_vst4_lane_8    */ {&A32_ext_vldB[0][0x14],     &T32_ext_vldB[0][0x14],           &T32_ext_vldB[0][0x14]},
    /* OP_vstm           */ {&A32_ext_fp[8][0x01],       &T32_ext_fp[8][0x01],             &T32_ext_fp[8][0x01]},
    /* OP_vstmdb         */ {&A32_ext_fp[16][0x01],      &T32_ext_fp[16][0x01],            &T32_ext_fp[16][0x01]},
    /* OP_vstr           */ {&A32_ext_fp[22][0x01],      &T32_ext_fp[22][0x01],            &T32_ext_fp[22][0x01]},
    /* OP_vsub_f32       */ {&A32_ext_simd6[2][0x34],    &T32_ext_simd6[2][0x34],          &T32_ext_simd6[2][0x34]},
    /* OP_vsub_f64       */ {&A32_ext_opc4fpB[3][0x04],  &T32_ext_opc4fpB[3][0x04],        &T32_ext_opc4fpB[3][0x04]},
    /* OP_vsub_i16       */ {&A32_ext_simd6[7][0x20],    &T32_ext_simd6[7][0x20],          &T32_ext_simd6[7][0x20]},
    /* OP_vsub_i32       */ {&A32_ext_simd6[8][0x20],    &T32_ext_simd6[8][0x20],          &T32_ext_simd6[8][0x20]},
    /* OP_vsub_i64       */ {&A32_ext_simd6[9][0x20],    &T32_ext_simd6[9][0x20],          &T32_ext_simd6[9][0x20]},
    /* OP_vsub_i8        */ {&A32_ext_simd6[6][0x20],    &T32_ext_simd6[6][0x20],          &T32_ext_simd6[6][0x20]},
    /* OP_vsubhn_i16     */ {&A32_ext_simd8[0][0x1e],    &T32_ext_simd8[0][0x1e],          &T32_ext_simd8[0][0x1e]},
    /* OP_vsubhn_i32     */ {&A32_ext_simd6[4][0x18],    &T32_ext_simd6[4][0x18],          &T32_ext_simd6[4][0x18]},
    /* OP_vsubhn_i64     */ {&A32_ext_simd6[5][0x18],    &T32_ext_simd6[5][0x18],          &T32_ext_simd6[5][0x18]},
    /* OP_vsubl_s16      */ {&A32_ext_simd6[4][0x08],    &T32_ext_simd6[4][0x08],          &T32_ext_simd6[4][0x08]},
    /* OP_vsubl_s32      */ {&A32_ext_simd6[5][0x08],    &T32_ext_simd6[5][0x08],          &T32_ext_simd6[5][0x08]},
    /* OP_vsubl_s8       */ {&A32_ext_simd8[0][0x0a],    &T32_ext_simd8[0][0x0a],          &T32_ext_simd8[0][0x0a]},
    /* OP_vsubl_u16      */ {&A32_ext_simd6[10][0x08],   &T32_ext_simd6[10][0x08],         &T32_ext_simd6[10][0x08]},
    /* OP_vsubl_u32      */ {&A32_ext_simd6[11][0x08],   &T32_ext_simd6[11][0x08],         &T32_ext_simd6[11][0x08]},
    /* OP_vsubl_u8       */ {&A32_ext_simd8[1][0x0a],    &T32_ext_simd8[1][0x0a],          &T32_ext_simd8[1][0x0a]},
    /* OP_vsubw_s16      */ {&A32_ext_simd6[4][0x0c],    &T32_ext_simd6[4][0x0c],          &T32_ext_simd6[4][0x0c]},
    /* OP_vsubw_s32      */ {&A32_ext_simd6[5][0x0c],    &T32_ext_simd6[5][0x0c],          &T32_ext_simd6[5][0x0c]},
    /* OP_vsubw_s8       */ {&A32_ext_simd8[0][0x0f],    &T32_ext_simd8[0][0x0f],          &T32_ext_simd8[0][0x0f]},
    /* OP_vsubw_u16      */ {&A32_ext_simd6[10][0x0c],   &T32_ext_simd6[10][0x0c],         &T32_ext_simd6[10][0x0c]},
    /* OP_vsubw_u32      */ {&A32_ext_simd6[11][0x0c],   &T32_ext_simd6[11][0x0c],         &T32_ext_simd6[11][0x0c]},
    /* OP_vsubw_u8       */ {&A32_ext_simd8[1][0x0f],    &T32_ext_simd8[1][0x0f],          &T32_ext_simd8[1][0x0f]},
    /* OP_vswp           */ {&A32_ext_simd6b[1][0x00],   &T32_ext_simd6b[1][0x00],         &T32_ext_simd6b[1][0x00]},
    /* OP_vtbl_8         */ {&A32_ext_vtb[0][0x07],      &T32_ext_vtb[0][0x07],            &T32_ext_vtb[0][0x07]},
    /* OP_vtbx_8         */ {&A32_ext_vtb[0][0x08],      &T32_ext_vtb[0][0x08],            &T32_ext_vtb[0][0x08]},
    /* OP_vtrn_16        */ {&A32_ext_simd6b[4][0x02],   &T32_ext_simd6b[4][0x02],         &T32_ext_simd6b[4][0x02]},
    /* OP_vtrn_32        */ {&A32_ext_simd6b[7][0x02],   &T32_ext_simd6b[7][0x02],         &T32_ext_simd6b[7][0x02]},
    /* OP_vtrn_8         */ {&A32_ext_simd6b[1][0x02],   &T32_ext_simd6b[1][0x02],         &T32_ext_simd6b[1][0x02]},
    /* OP_vtst_16        */ {&A32_ext_simd6[1][0x21],    &T32_ext_simd6[1][0x21],          &T32_ext_simd6[1][0x21]},
    /* OP_vtst_32        */ {&A32_ext_simd6[2][0x21],    &T32_ext_simd6[2][0x21],          &T32_ext_simd6[2][0x21]},
    /* OP_vtst_8         */ {&A32_ext_simd6[0][0x21],    &T32_ext_simd6[0][0x21],          &T32_ext_simd6[0][0x21]},
    /* OP_vuzp_16        */ {&A32_ext_simd6b[4][0x04],   &T32_ext_simd6b[4][0x04],         &T32_ext_simd6b[4][0x04]},
    /* OP_vuzp_32        */ {&A32_ext_simd6b[7][0x04],   &T32_ext_simd6b[7][0x04],         &T32_ext_simd6b[7][0x04]},
    /* OP_vuzp_8         */ {&A32_ext_simd6b[1][0x04],   &T32_ext_simd6b[1][0x04],         &T32_ext_simd6b[1][0x04]},
    /* OP_vzip_16        */ {&A32_ext_simd6b[4][0x06],   &T32_ext_simd6b[4][0x06],         &T32_ext_simd6b[4][0x06]},
    /* OP_vzip_32        */ {&A32_ext_simd6b[7][0x06],   &T32_ext_simd6b[7][0x06],         &T32_ext_simd6b[7][0x06]},
    /* OP_vzip_8         */ {&A32_ext_simd6b[1][0x06],   &T32_ext_simd6b[1][0x06],         &T32_ext_simd6b[1][0x06]},
    /* OP_wfe            */ {&A32_ext_bits0[0][0x02],    &T32_16_ext_bits_6_4[0][0x02],    &T32_16_it_ext_bits_6_4[0][0x02]},
    /* OP_wfi            */ {&A32_ext_bits0[0][0x03],    &T32_16_ext_bits_6_4[0][0x03],    &T32_16_it_ext_bits_6_4[0][0x03]},
    /* OP_yield          */ {&A32_ext_bits0[0][0x01],    &T32_16_ext_bits_6_4[0][0x01],    &T32_16_it_ext_bits_6_4[0][0x01]},
};

/* clang-format on */
