#!/usr/bin/perl

# **********************************************************
# Copyright (c) 2007 VMware, Inc.  All rights reserved.
# **********************************************************

# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
# * Neither the name of VMware, Inc. nor the names of its contributors may be
#   used to endorse or promote products derived from this software without
#   specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL VMWARE, INC. OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.

# Script to post-process the latex auto-generated with doxygen.  It
# looks like doxygen is pretty rigid about where it puts chapters and
# sections; we'll clean up the latex ourselves before generating the
# pdf.  Our approach is to try to replicate the structure of the html
# output.

$html_dir = "$ARGV[0]/html";
$latex_dir = "$ARGV[0]/latex";

$html_file = "$html_dir/tree.html";
$latex_file = "$latex_dir/refman.tex";

$latex_style = "$latex_dir/doxygen.sty";

#
# Read the first part of the current latex file, up until the first
# \chapter declaration.  That portion will remain the same.
#
$latex = "";
open (IN, $latex_file) || die "ERROR: can't open $latex_file\n";
while (<IN>) {
    last if ($_ =~ /^\\chapter/);
    if (/Generated by Doxygen/) {
        # eat the next two lines
        $_ = <IN>; # vspace line
        $_ = <IN>;
        die "ERROR: unexpected line" unless (/^{\\small/);
    } else {
        $latex .= $_;
    }
}
close (IN);

open (OUT, ">$latex_file") || die "ERROR: can't overwrite $latex_file\n";
print OUT $latex;

#
# Now parse the html file and match its layout.
#
open (IN, $html_file) || die "ERROR: can't open $html_file\n";

$level = -1;
while (<IN>) {
    if ($_ =~ /<p>.*href=\"(.+)\.html\".*>(.*)<\/a><\/p>/) {
        if (-e "$latex_dir/$1.tex") {
            if ($level == 1) {
                print OUT "\\chapter{$2}\n";
            }
            print OUT "\\input{$1}\n";
        }
    }
    elsif ($_ =~ /<div/) {
        $level++;
    }
    elsif ($_ =~ /<\/div/) {
        $level--;
    }
}

print OUT "\\printindex\n\\end{document}\n";

close (IN);
close (OUT);

# now process the style file
$latex = "";
open (IN, $latex_style) || die "ERROR: can't open $latex_style\n";
while (<IN>) {
    # put in our logo and statement in the footers
    if (/^\\rfoot/) {
        $latex .= "\\rfoot[\\fancyplain{}{\\bfseries\\scriptsize \\raisebox{1ex}{DynamoRIO API\\ \\ \\ } \\includegraphics[width=4ex]{drlogo} }]{}\n";
    } elsif (/^\\lfoot/) {
        $latex .= "\\lfoot[]{\\fancyplain{}{\\bfseries\\scriptsize \\includegraphics[width=4ex]{drlogo} \\raisebox{1ex}{\\ \\ \\ DynamoRIO API} }}\n";
    } else {
        $latex .= $_;
    }
}
close (IN);
open (OUT, ">$latex_style") || die "ERROR: can't overwrite $latex_style\n";
print OUT $latex;
close (OUT);

