---
layout: set
title: 2022
problems:
  - P1_Counting_DNA
  - P2_Mutations
  - P3_XOR
  - P4_Longest_1_run
  - P5_Stairway
  - P6_Pyramid
  - P7_Golf_Scores
  - P8_Split_on_first
  - P9_Average
  - P10_Separators
---

<div id="P1_Counting_DNA" class="problem" markdown="1">     

# 1: Counting DNA Nucleotides?

<i class="fad fa-dna"></i>

<p>This problem was inspired by <a href="https://rosalind.info/problems/dna/">Counting DNA Nucleotides</a> found on the excellent bioinformatics website <a href="https://rosalind.info">rosalind.info</a>.</p>

<p>Write a function that:</p>
<ul>
    <li>takes a right argument that is a character vector or scalar representing a DNA string (whose alphabet contains the symbols 'A', 'C', 'G', and 'T').</li>
    <li>returns a 4-element numeric vector containing the counts of each symbol 'A', 'C', 'G', and 'T' respectively.
    </li>
</ul>
<p><i class="fas fa-lightbulb-on"></i> <strong>Hint:</strong> The <em>key</em> operator <a href="https://help.dyalog.com/latest/#Language/Primitive%20Operators/Key.htm" class="APL" target="_blank">f⌸</a> or the <em>outer product</em> operator <a href="https://help.dyalog.com/latest/#Language/Primitive%20Operators/Outer%20Product.htm"
        class="APL" target="_blank">∘.g</a> could be helpful.</p>

<h3>Examples</h3>
<pre class="APL">      
      (<i>your_function</i>) 'AGCTTTTCATTCTGACTGCAACGGGCAATATGTCTCTGTGTGGATTAAAAAAAGAGTGTCTGATAGCAGC'
20 12 17 21

      (<i>your_function</i>) ''
0 0 0 0

      (<i>your_function</i>) 'G'
0 0 1 0

</pre>

</div>

<div id="P2_Mutations" class="problem" markdown="1">     

# 2: Attack of the Mutations!

<p>This problem is inspired by the <a href="https://rosalind.info/problems/hamm/">Counting Point Mutations</a> problem found on the excellent Bioinformatics education website <a href="https://rosalind.info">rosalind.info</a>.</p>
<p>Write a function that:</p>
<ul>
    <li>takes right and left arguments that are character vectors or scalars of equal length – these represent DNA strings.</li>
    <li>returns an integer representing the <a href="https://rosalind.info/glossary/hamming-distance/">Hamming distance</a> (the number of differences in corresponding positions) between the arguments.</li>
</ul>

<p><i class="fas fa-lightbulb-on"></i> <strong>Hint:</strong> The <em>plus</em> function <a href="https://help.dyalog.com/latest/Content/Language/Symbols/Plus.htm" class="APL" target="_blank">X+Y</a> could be helpful.
</p>

<h3>Examples</h3>
<pre class="APL">
      'GAGCCTACTAACGGGAT' (<i>your_function</i>) 'CATCGTAATGACGGCCT' 
7

      'A' (<i>your_function</i>) 'T'
1

      '' (<i>your_function</i>) ''
0
 
      (<i>your_function</i>)⍨ 'CATCGTAATGACGGCCT'
0
</pre>


</div>

<div id="P3_XOR" class="problem" markdown="1">     

# 3: Uniquely Qualified

<p>Write a function that:</p>
<p>
    <ul>
        <li>takes right and left arguments that are arrays of arbitrary rank, depth, and value.</li>
        <li>returns a vector of all elements that appear in either of the two argument arrays but not in both. The order of elements in the result is not significant.</li>
    </ul>
</p>

<p><i class="fas fa-lightbulb-on"></i> <strong>Hint:</strong> The <em>without</em> function <a href="http://help.dyalog.com/latest/#Language/Primitive%20Functions/Excluding.htm" class="APL" target="_blank">X~Y</a> could be helpful.</p>

<h3>Examples</h3>
<pre class="APL">
      'DYALOG' (<i>your_function</i>) 'APL'
DYOGP

      'DYALOG'  (<i>your_function</i>) ⊂'APL'
┌─┬─┬─┬─┬─┬─┬───┐
│D│Y│A│L│O│G│APL│
└─┴─┴─┴─┴─┴─┴───┘

      (2 2⍴'Hello'(⊂'World')(2 2⍴⍳4)42) (<i>your_function</i>) 42 'Have a nice day'
┌─────┬───────┬───┬───────────────┐
│Hello│┌─────┐│1 2│Have a nice day│
│     ││World││3 4│               │
│     │└─────┘│   │               │
└─────┴───────┴───┴───────────────┘

      1 1 1 (<i>your_function</i>) 2 2
1 1 1 2 2
</pre>


</div>

<div id="P4_Longest_1_run" class="problem" markdown="1">     

# 4: In the Long One...

<p>Write a function that:</p>
<ul>
    <li>takes a right argument that is a Boolean scalar or vector.</li>
    <li>returns the length of the longest sequence of consecutive 1s.</li>
</ul>
<p><i class="fas fa-lightbulb-on"></i> <strong>Hint:</strong> The <em>partition</em> function <a href="https://help.dyalog.com/latest/#Language/Primitive%20Functions/Partition.htm" class="APL" target="_blank">X⊆fY</a> could be helpful.</p>

<h3>Examples</h3>
<pre class="APL">
      (<i>your_function</i>) 1 1 1 0 1 1 0 0 1 1 1 1 0
4

      (<i>your_function</i>) ⍬
0

      (<i>your_function</i>) 1
1

      (<i>your_function</i>) 0
0

      (<i>your_function</i>) 12/0 1 0 1
12
</pre>


</div>

<div id="P5_Stairway" class="problem" markdown="1">     

# 5: Stairway to Heaven

<span style="display:inline-block">(with apologies to <a href="https://en.wikipedia.org/wiki/Stairway_to_Heaven">Led Zeppelin</a>)</span>
<p>Write a function that:
    <ul>
        <li>takes a scalar integer argument, <span class="APL">n</span>, in the range 0-100.</li>
        <li>returns a character matrix comprised of spaces and <span class="APL">⎕</span> that resembles an <span class="APL">n</span>-level left-to-right ascending stairway.</li>
    </ul>
</p>
<p><i class="fas fa-lightbulb-on"></i> <strong>Hint:</strong> The <em>index generator</em> function <a href="http://help.dyalog.com/latest/#Language/Primitive%20Functions/Index%20Generator.htm" class="APL" target="_blank">⍳Y</a> could help with solving this
    problem.
</p>
<hr/>
<h3>Examples</h3>
<pre class="APL">      
      (<i>your_function</i>) 10
         ⎕
        ⎕⎕
       ⎕⎕⎕
      ⎕⎕⎕⎕
     ⎕⎕⎕⎕⎕
    ⎕⎕⎕⎕⎕⎕
   ⎕⎕⎕⎕⎕⎕⎕
  ⎕⎕⎕⎕⎕⎕⎕⎕
 ⎕⎕⎕⎕⎕⎕⎕⎕⎕
⎕⎕⎕⎕⎕⎕⎕⎕⎕⎕

      (<i>your_function</i>) 0 ⍝ returns a 0×0 matrix

</pre>


</div>

<div id="P6_Pyramid" class="problem" markdown="1">     

# 6: Pyramid Scheme

<p>Write a monadic function that:</p>
<ul>
    <li>takes an argument <em>n</em> that is an integer scalar in the range 0-100.</li>
    <li>returns a square matrix "pyramid" with <span class="APL">0⌈¯1+2×n</span> rows and columns of <span class="APL">n</span> increasing concentric levels.<br/>
        By this we mean that the center element of the matrix will be <span class="APL">n</span>, surrounded on all sides by <span class="APL">n-1</span>.</li>
</ul>
<p><i class="fas fa-lightbulb-on"></i> <strong>Hint:</strong> The functions <em>minimum</em> <a href="https://help.dyalog.com/latest/#Language/Primitive%20Functions/Minimum.htm" class="APL" target="_blank">X⌊Y</a> and <em>reverse</em> <a href="https://help.dyalog.com/latest/#Language/Primitive%20Functions/Reverse.htm"
      class="APL" target="_blank">⌽Y</a>, and the <em>outer product</em> operator <a href="http://help.dyalog.com/latest/#Language/Primitive%20Operators/Outer%20Product.htm"
      class="APL" target="_blank">X∘.gY</a> could be helpful.</p>
<hr/>
<h3>Examples</h3>
<pre class="APL">
      (<i>your_function</i>) 3
1 1 1 1 1
1 2 2 2 1
1 2 3 2 1
1 2 2 2 1
1 1 1 1 1

      (<i>your_function</i>) 5
1 1 1 1 1 1 1 1 1
1 2 2 2 2 2 2 2 1
1 2 3 3 3 3 3 2 1
1 2 3 4 4 4 3 2 1
1 2 3 4 5 4 3 2 1
1 2 3 4 4 4 3 2 1
1 2 3 3 3 3 3 2 1
1 2 2 2 2 2 2 2 1
1 1 1 1 1 1 1 1 1
      
      (<i>your_function</i>) 1 ⍝ should return 1 1⍴1
1      

      (<i>your_function</i>) 0 ⍝ should return 0 0⍴0

</pre>


</div>

<div id="P7_Golf_Scores" class="problem" markdown="1">     

# 7: Just Golfing Around

<p>Apologies to the code golfers out there, but this problem has nothing to do with
    <a href="https://aplwiki.com/wiki/Code_golf" target="_blank">code golf</a>! Instead, it addresses the problem of assigning places in a golf tournament. In regular golf, lower scores place higher – the lowest score places first and the highest score
    places last.</p>
<p>Write a function that:</p>
<ul>
    <li>takes a right argument that is a non-decreasing vector or scalar of strictly positive integers, representing a set of scores.</li>
    <li>returns a numeric vector of the place for each score; for duplicate scores, it returns the average of the places they hold.</li>
</ul>

<p><i class=" fas fa-lightbulb-on "></i> <strong>Hint:</strong> This problem has several viable approaches including using <em>key</em>
    <a href="https://help.dyalog.com/latest/#Language/Primitive%20Operators/Key.htm" class="APL " target="_blank ">f⌸</a>, or <em>partition</em> <a href="https://help.dyalog.com/latest/#Language/Primitive%20Functions/Partition.htm" class="APL " target="_blank ">X⊆Y</a>,
    or <em>interval index</em> <a href="https://help.dyalog.com/latest/#Language/Primitive%20Functions/Interval%20Index.htm" class="APL " target="_blank ">X⍸Y</a>.</p>
<hr/>
<h3>Examples</h3>
<pre class="APL ">
      (<i>your_function</i>) 1 2 3 4 5
1 2 3 4 5
      
      (<i>your_function</i>) 68 71 71 73
1 2.5 2.5 4

      (<i>your_function</i>) 67 68 68 69 70 70 70 71 72
1 2.5 2.5 4 6 6 6 8 9

      (<i>your_function</i>) 6⍴70
3.5 3.5 3.5 3.5 3.5 3.5

      (<i>your_function</i>) ⍬ ⍝ this should return an empty vector


      (<i>your_function</i>) 67 ⍝ should work with a scalar argument
1
</pre>


</div>

<div id="P8_Split_on_first" class="problem" markdown="1">     

# 8: Let's Split!

<p>Write a function that:</p>
<ul>
    <li>takes a right argument that is a non-empty character vector or scalar.</li>
    <li>takes a left argument that is a non-empty character vector or scalar.</li>
    <li>returns a 2-element vector of character vectors in which the right argument is split immediately before the <em>first</em> occurence of <em>any</em> element in the left argument. If no left-argument element occurs in the right argument, then the split
        should happen after the last element of the right argument.</li>
</ul>

<p><i class="fas fa-lightbulb-on"></i> <strong>Hint:</strong> The <em>take</em>
    <a href="https://help.dyalog.com/latest/#Language/Primitive%20Functions/Take.htm" class="APL" target="_blank">X↑Y</a> and <em>drop</em>
    <a href="https://help.dyalog.com/latest/#Language/Primitive%20Functions/Drop.htm" class="APL" target="_blank">X↓Y</a> functions, or the <em>partitioned enclose</em> function
    <a href="https://help.dyalog.com/latest/#Language/Primitive Functions/Partitioned Enclose.htm" class="APL" target="_blank">X⊂Y</a>, could be helpful.</p>

<h3>Examples</h3>
<pre class="APL">
      'do' (<i>your_function</i>) 'Hello World'
┌────┬───────┐
│Hell│o World│
└────┴───────┘

      'KEI' (<i>your_function</i>) ⎕A ⍝ ⎕A is the system constant that contains the characters A-Z 
┌────┬──────────────────────┐
│ABCD│EFGHIJKLMNOPQRSTUVWXYZ│
└────┴──────────────────────┘

      (⌽⎕A) (<i>your_function</i>) ⎕A
┌┬──────────────────────────┐
││ABCDEFGHIJKLMNOPQRSTUVWXYZ│
└┴──────────────────────────┘

      ⎕D (<i>your_function</i>) ⎕A ⍝ ⎕D is the system constant that contains the characters 0-9 
┌──────────────────────────┬┐
│ABCDEFGHIJKLMNOPQRSTUVWXYZ││
└──────────────────────────┴┘

      ⎕D (<i>your_function</i>) 'Q'
┌─┬┐
│Q││
└─┴┘
      ⎕A (<i>your_function</i>) 'Q'
┌┬─┐
││Q│
└┴─┘
</pre>

</div>

<div id="P9_Average" class="problem" markdown="1">     

# 9: An Average Window (or a Windowed Average)

<p>Write a function that:</p>
<ul>
    <li>takes a right argument <span class="APL">Y</span> that is a numeric scalar or non-empty vector.</li>
    <li>takes a left argument <span class="APL">X</span> that represents the number of neighboring elements on either side of each element in <span class="APL">Y</span>.</li>
    <li>returns a numeric vector or scalar where each element is the average (mean) of the corresponding element in <span class="APL">Y</span> and its <span class="APL">X</span> neighbors on either side. If an element has fewer than <span class="APL">X</span> neighbors on either side, replicate the first and last values as necessary to make <span class="APL">X</span> neighbors.</li>
</ul>
<p><i class="fas fa-lightbulb-on"></i> <strong>Hint:</strong> The <em>Reduce N-Wise</em> operator <a href="http://help.dyalog.com/latest/#Language/Primitive%20Operators/Reduce%20N%20Wise.htm" class="APL" target="_blank">Xf/Y</a> could help with solving this
    problem.
</p>

<h3>Examples</h3>
<pre class="APL">

      0 (<i>your_function</i>) 1 2 3 4 5 6 ⍝ 0 neighbors on each side
1 2 3 4 5 6

      1 (<i>your_function</i>) 1 2 3 4 5 6 ⍝ 1 neighbors on each side
1.333333333 2 3 4 5 5.666666667

      2 (<i>your_function</i>) 1 2 3 4 5 6 ⍝ 2 neighbors on each side
1.6 2.2 3 4 4.8 5.4

      6 (<i>your_function</i>) 1 2 3 4 5 6
2.538461538 2.923076923 3.307692308 3.692307692 4.076923077 4.461538462

      10 (<i>your_function</i>) 42
42    
</pre>


</div>

<div id="P10_Separators" class="problem" markdown="1">     

# 10: Separation Anxiety

<p>Write a function that:</p>
<p>
    <ul>
        <li>takes a right argument that is a character vector or scalar representing a valid non-negative integer.</li>
        <li>takes a left argument that is a character scalar "separator" character.</li>
        <li>returns a character vector that is a representation of the right argument formatted such that the separator character is found between trailing groups of 3 digits.</li>
    </ul>
</p>
<p>Note that the number of digits in the character representation might exceed the number of digits that can be represented as a 32-bit integer. </p>
<p><i class="fas fa-lightbulb-on"></i> <strong>Hint:</strong> The <em>at</em> operator <a href="http://help.dyalog.com/latest/#Language/Primitive%20Operators/At.htm" class="APL" target="_blank">@</a> could be helpful.</p>
<hr/>
<h3>Examples</h3>
<pre class="APL">
      ',' (<i>your_function</i>)¨'1' '10' '100' '1000' '10000' '100000' '1000000' '10000000' '100000000' '1000000000' '10000000000'
┌─┬──┬───┬─────┬──────┬───────┬─────────┬──────────┬───────────┬─────────────┬──────────────┐
│1│10│100│1,000│10,000│100,000│1,000,000│10,000,000│100,000,000│1,000,000,000│10,000,000,000│
└─┴──┴───┴─────┴──────┴───────┴─────────┴──────────┴───────────┴─────────────┴──────────────┘
          
      '.' (<i>your_function</i>) 60⍴⌽⎕D
987.654.321.098.765.432.109.876.543.210.987.654.321.098.765.432.109.876.543.210
      
      '/' (<i>your_function</i>) ,'9' ⍝ scalars and 1-element character vectors are equivalent
9
</pre>


</div>
