---
layout: set
title: 2021
problems:
  - P1_Are_You_a_Bacteria
  - P2_Index_Of_Modified
  - P3_Multiplicity
  - P4_Square_Peg_Round_Hole
  - P5_Rect_ify
  - P6_Fischer_Random_Chess
  - P7_Can_You_Feel_the_Magic
  - P8_Time_to_Make_a_Difference
  - P9_In_the_Long_Run
  - P10_On_the_Right_Side
---

<div id="P1_Are_You_a_Bacteria" class="problem" markdown="1">     

# 1: Are You a Bacteria?
A DNA string is composed of the letters 'A','C','G' and 'T'. The GC-content of a DNA string is given by the percentage of the symbols in the string that are either 'C' or 'G'. Very small discrepancies in GC-content can be used to distinguish species; for instance, most bacteria have a GC-content significantly higher than 50%.

Write a function that:

- has a right argument that is a non-empty character vector representing a DNA string.
- returns the percentage of GC-content in the string.

💡 Hint: The <em>membership</em> function <a href="https://help.dyalog.com/latest/#Language/Primitive%20Functions/Membership.htm" class="language-APL" target="_blank">X∊Y</a> could be helpful for this problem.

### Examples
```APL
      (your_function) 'GCGCGCGCCCGGGGCCG'
100

      (your_function) 'ACGTACGTACGTACGT'
50

      (your_function) 10 12 16 10/'ACGT'
58.33333333
```

</div>


<div id="P2_Index_Of_Modified" class="problem" markdown="1">  

# 2: Index-Of Modified
Write a function that behaves like the APL <em>index-of</em> function <a href="https://help.dyalog.com/latest/#Language/Primitive%20Functions/Index%20Of.htm" class="language-APL" target="_blank">R←X⍳Y</a> except that it returns <span class="language-APL">0</span> instead of <span class="language-APL">1+≢X</span> for elements of <span class="language-APL">Y</span> not found in <span class="language-APL">X</span>.

### Examples
```APL
      'DYALOG' (your_function) 'APL'
3 0 4
      
      (5 5⍴⎕A) (your_function) ↑'UVWXY' 'FGHIJ' 'XYZZY'
5 2 0
```

</div>

<div id="P3_Multiplicity" class="problem" markdown="1"> 

# 3: Multiplicity

Write a function that:
- has a right argument <span class="language-APL">Y</span> which is an integer vector or scalar
- has a left argument <span class="language-APL">X</span> which is also an integer vector or scalar
- finds which elements of <span class="language-APL">Y</span> are multiples of each element of <span class="language-APL">X</span> and returns them as a vector (in the order of <span class="language-APL">X</span>) of vectors (in the order of <span class="language-APL">Y</span>).

💡 Hint: The <em>residue</em> function <a href="http://help.dyalog.com/latest/#Language/Primitive%20Functions/Residue.htm" class="language-APL" target="_blank">X|Y</a> and <em>outer product</em> operator <a href="http://help.dyalog.com/latest/#Language/Primitive%20Operators/Outer%20Product.htm" class="language-APL" target="_blank">X∘.fY</a> might be useful for this problem.

### Examples
```APL
      ⎕←Y←20?20 ⍝ your example may be different
5 7 8 1 12 10 20 16 11 4 2 15 3 18 14 19 13 9 17 6
      
      2 4 7 3 9 (your_function) Y ⍝ using ]Box on
┌─────────────────────────┬────────────┬────┬──────────────┬────┐
│8 12 10 20 16 4 2 18 14 6│8 12 20 16 4│7 14│12 15 3 18 9 6│18 9│
└─────────────────────────┴────────────┴────┴──────────────┴────┘
      
      3 (your_function) ⍳10
┌─────┐
│3 6 9│
└─────┘
      
      6 7 (your_function) 42
┌──┬──┐
│42│42│
└──┴──┘
      
      2 3 5 (your_function) ⍬ ⍝ returns a vector of 3 empty vectors
┌┬┬┐
││││
└┴┴┘

      ⍬ (your_function) ⍳10 ⍝ returns an empty vector
```

</div>

<div id="P4_Square_Peg_Round_Hole" class="problem" markdown="1"> 

# 4: Square Peg, Round Hole
Write a function that:

- takes a right argument which is an array of positive numbers representing circle diameters
- returns a numeric array of the same shape as the right argument representing the difference between the areas of the circles and the areas of the largest squares that can be inscribed within each circle

💡 Hint: The <em>pi times</em> function <a href="https://help.dyalog.com/latest/#Language/Primitive%20Functions/Pi%20Times.htm" class="language-APL" target="_blank">○Y</a> could be helpful.

### Examples

```APL
      (your_function) 2×⍳5
1.141592654 4.566370614 10.27433388 18.26548246 28.53981634

      (your_function) (2*.5)×3 3 ⍴⍳9
 0.5707963268  2.283185307  5.137166941
 9.132741229  14.26990817  20.54866776 
27.96902001   36.53096491  46.23450247 
```

</div>

<div id="P5_Rect_ify" class="problem" markdown="1"> 

# 5: Rect-ify

Suppose you have a number of trees that you want to plant in a rectangular pattern with complete rows and columns, meaning all rows have the same number of trees. You also want that rectangular pattern to be as "square" as possible, meaning there is a minimal difference between the number of rows and columns in the pattern.

Write a function that:
- has a right argument <span class="language-APL"><b>N</b></span> which is a positive integer less than or equal to 1,000,000.
- returns a 2-element integer vector <span class="language-APL">R</span> representing the rows and columns of the rectangle such that:
    - <span class="language-APL">N=×/R</span> meaning <span class="language-APL">N</span> equals the number of rows × the number of columns (you planted all the trees!)
    - <span class="language-APL">≤/R</span> meaning the number of rows is less than or equal to the number of columns
    - <span class="language-APL">|-/R</span> is minimal, meaning the difference between the elements of <span class="language-APL">R</span> is as small as possible

### Examples using ]Box on

```APL
      (your_function) 12
3 4

      (your_function) 16
4 4

      (your_function)¨⍳19
┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬────┬───┬────┬───┬───┬───┬────┬───┬────┐
│1 1│1 2│1 3│2 2│1 5│2 3│1 7│2 4│3 3│2 5│1 11│3 4│1 13│2 7│3 5│4 4│1 17│3 6│1 19│
└───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴────┴───┴────┴───┴───┴───┴────┴───┴────┘

      (your_function)¨999999 1000000
┌────────┬─────────┐
│999 1001│1000 1000│
└────────┴─────────┘
```

</div>

<div id="P6_Fischer_Random_Chess" class="problem" markdown="1"> 

# 6: Fischer Random Chess

<div>
<img src="/img/board.png" style="width:250px;float:right;margin-left:20px;filter: invert(.75)hue-rotate(180deg);"/> 
</div>
<div><p>According to <a href="https://en.wikipedia.org/wiki/Fischer_random_chess">Wikipedia</a>, Fischer random chess is a
      variation of the game of chess invented by former world chess champion Bobby Fischer. Fischer random chess employs
      the same board and pieces as standard chess, but the starting position of the non-pawn pieces on the players' home ranks is
      randomized, following certain rules. White's non-pawn pieces are placed on the first rank according to the
      following rules:</p>
<ul>
      <li>The Bishops must be placed on opposite-color squares.</li>
      <li>The King must be placed on a square between the rooks.</li>
</ul>
</div>



<p>The good news is that you don't actually need to know anything about chess to solve this problem! We'll use strings
      whose elements are <span class="language-APL">'KQRRBBNN'</span> for the King (♔), Queen (♕), 2 Rooks (♖), 2 Bishops (♗), and 2
      kNights (♘) respectively.</p>
<p>Write a function that:</p>
<ul>
      <li>has a character vector right argument that is a permutation of <span class="language-APL">'KQRRBBNN'</span></li>
      <li>returns 1 if the following are true:<ul>
                  <li>the K is between the two Rs</li>
                  <li>the Bs occupy one odd and one even position</li>
            </ul>otherwise a 0 is returned.</li>
</ul>

💡 Hint: The <em>where</em> function <a href="https://help.dyalog.com/latest/#Language/Primitive%20Functions/Where.htm" class="language-APL" target="_blank">⍸Y</a> and the <em>residue</em> function <a href="https://help.dyalog.com/latest/#Language/Primitive%20Functions/Residue.htm" class="language-APL" target="_blank">X|Y</a> could help with solving this problem.

### Examples

```APL
      
      (your_function) 'RNBQKBNR' ⍝ standard chess layout
1

      (your_function) 'BBNRKNRQ' ⍝ layout in diagram above
1

      (your_function) 'RBBNQNRK' ⍝ K not between Rs
0

      (your_function) 'BRBKRNQN' ⍝ Bs both in odd positions 
0
```

</div>

<div id="P7_Can_You_Feel_the_Magic" class="problem" markdown="1"> 

# 7: Can You Feel the Magic?

<div>
      <img src="/img/magic-square.png" style="float:right;width:250px;margin-left:20px;" />
</div>
<p><a href="https://en.wikipedia.org/wiki/Magic_square">Wikipedia</a> states that, in recreational mathematics, a square array of numbers, usually positive integers, is called a magic square if the sums of the numbers in each row, each column, and both main diagonals are the same.</p>
<p>Write a function to test whether an array is a magic square. The function must:</p>
<ul>
      <li>have a right argument that is a square matrix of integers (not necessarily all positive integers)</li>
      <li>return 1 if the array represents a magic square, otherwise return 0</li>
</ul>

💡 Hint: The <em>dyadic transpose</em> <a href="https://aplcart.info/?q=%E2%8D%89#" class="language-APL" target="_blank">X⍉Y</a> function could be helpful for solving this problem.

### Examples

```APL
      (your_function) 1 1⍴42
1

      (your_function) 3 3⍴4 9 2 3 5 7 8 1 6
1

      (your_function) 2 2⍴1 2 3 4
0
```

</div>

<div id="P8_Time_to_Make_a_Difference" class="problem" markdown="1"> 

# 8: Time to Make a Difference

Write a function that:

- has a right argument that is a numeric scalar or vector of length up to 3, representing a number of [[[days] hours] minutes] – a single number represents minutes, a 2-element vector represents hours and minutes, and a 3-element vector represents days, hours, and minutes.
- has a similar left argument, although not necessarily the same length as the right argument.
- returns a single number representing the magnitude of the difference in minutes between the arguments.

💡 Hint: The functions <em>decode</em> <a href="https://help.dyalog.com/latest/#Language/Primitive%20Functions/Decode.htm" class="language-APL" target="_blank">X⊥Y</a> and <em>take</em> <a href="https://help.dyalog.com/latest/#Language/Primitive%20Functions/Take.htm" class="language-APL" target="_blank">↑</a>  could be useful for this problem.

### Examples

```APL
      2 30 (your_function) 5 15
165
      5 15 (your_function) 2 30
165
      1 0 0 (your_function) 0 ⍝ number of minutes in a day
1440
      1 0 0 (your_function) ⍬ ⍝ don't forget to handle empty arguments!
1440
      1 0 (your_function)¯1 0
120
      1.5 0 (your_function) 90
0
```

</div>

<div id="P9_In_the_Long_Run" class="problem" markdown="1"> 

# 9: In the Long Run

<p>Write a function that:</p>
<ul>
      <li>has a right argument that is a numeric vector of 2 or more elements representing daily prices of a stock.</li>
      <li>returns an integer singleton that represents the highest number of consecutive days where the price increased, decreased, or remained the same, relative to the previous day.</li>
</ul>

💡 Hint: The <em>N-wise reduction</em> operator <a href="https://help.dyalog.com/latest/#Language/Primitive%20Operators/Reduce%20N%20Wise.htm" class="language-APL" target="_blank">X f/ Y</a> function could be useful when solving this problem.

### Examples (the longest runs are highlighted)

<pre class="language-APL">
      (your_function) 1 <span style="background-color: #5e81ac">2 3 5</span> 5 5 6 4 3
3
      (your_function) 1 2 3 4 <span style="background-color: #5e81ac">4 4 4 4</span> 5 4 3
4
      (your_function) 1 <span style="background-color: #5e81ac">2</span>
1
</pre>

</div>

<div id="P10_On_the_Right_Side" class="problem" markdown="1"> 

# 10: On the Right Side

<p>Write a function that:</p>
- has a right argument <span class="language-APL">T</span> that is a character scalar, vector or a vector of character vectors/scalars.
- has a left argument <span class="language-APL">W</span> that is a positive integer specifying the width of the result.
- returns a right-aligned character array <span class="language-APL">R</span> of shape <span class="language-APL">((2=|≡T)/≢T),W</span> meaning <span class="language-APL">R</span> is one of the following:
    - a <span class="language-APL">W</span>-wide vector if <span class="language-APL">T</span> is a simple vector or scalar.
    - a <span class="language-APL">W</span>-wide matrix with the same number rows as elements of <span class="language-APL">T</span> if <span class="language-APL">T</span> is a vector of vectors/scalars.
- if an element of <span class="language-APL">T</span> has length greater than <span class="language-APL">W</span>, truncate it after <span class="language-APL">W</span> characters.

💡 Hint: Your solution might make use of <em>take</em>
      <a href="https://help.dyalog.com/latest/#Language/Primitive%20Functions/Take.htm" class="language-APL" target="_blank">X ↑ Y</a>.

### Examples

<p>In these examples, <span class="language-APL">⍴⎕←</span> is inserted to display first the result and then its shape.</p>

```APL

      ⍴⎕←6 (your_function) '⍒'
     ⍒
6

      ⍴⎕←8 (your_function) 'K' 'E' 'Iverson'
       K
       E
 Iverson
3 8

      ⍴⎕←10 (your_function) 'Parade' 
    Parade
10

      ⍴⎕←8 (your_function) 'Longer Phrase' 'APL' 'Parade' 
r Phrase
     APL
  Parade
3 8

      starsForSpaces←'*'@(=∘' ')
      starsForSpaces 6 (your_function) '⍒'
*****⍒
  
```
 
</div>
