---
layout: set
title: 2020
problems:
  - P1_Lets_Split
  - P2_Characters
  - P3_Columns
  - P4_Take_a_Leap
  - P5_Integer_Range
  - P6_Move_To_Front
  - P7_Bits
  - P8_Zigzag
  - P9_Rise_and_Fall
  - P10_Stacking_It_Up
---

<div id="P1_Lets_Split" class="problem" markdown="1">     

# 1: Let's Split!
Write a function that, given a right argument `Y` which is a scalar or a non-empty vector and a left argument `X` which is a single non-zero integer so that its absolute value is less or equal to `≢Y`, splits `Y` into a vector of two vectors according to `X`, as follows:
- If `X>0`, the first vector contains the first `X` elements of `Y` and the second vector contains the remaining elements.
- If `X<0`, the second vector contains the last `|X` elements of `Y` and the first vector contains the remaining elements.

💡 Hint: The Take function [`X↑Y`](http://help.dyalog.com/latest/#Language/Primitive%20Functions/Take.htm) might be useful for this problem.

### Examples

```APL
      9 (your_function) 'SplittingHairs'   ⍝ using ]Boxing on
┌─────────┬─────┐
│Splitting│Hairs│
└─────────┴─────┘

      ¯3 (your_function) 'DyalogAPL'
┌──────┬───┐
│Dyalog│APL│
└──────┴───┘

      10 (your_function) ⍳10
┌────────────────────┬┐
│1 2 3 4 5 6 7 8 9 10││
└────────────────────┴┘

      1 (your_function) 'works' 'with' 'words' 'also'
┌───────┬─────────────────┐
│┌─────┐│┌────┬─────┬────┐│
││works│││with│words│also││
│└─────┘│└────┴─────┴────┘│
└───────┴─────────────────┘
```

</div>


<div id="P2_Characters" class="problem" markdown="1">   

# 2: Character Building
UTF-8 encodes Unicode characters using 1-4 integers for each character. Dyalog APL includes a system function, `⎕UCS`, that can convert characters into integers and integers into characters. The expression `'UTF-8'∘⎕UCS` converts between characters and UTF-8.

Consider the following:

```APL
      'UTF-8'∘⎕UCS 'D¥⍺⌊○9'
68 194 165 226 141 186 226 140 138 226 151 139 57
      'UTF-8'∘⎕UCS 68 194 165 226 141 186 226 140 138 226 151 139 57
D¥⍺⌊○9
```

How many integers does each character use?

```APL
      'UTF-8'∘⎕UCS¨ 'D¥⍺⌊○9' ⍝ using ]Boxing on
┌──┬───────┬───────────┬───────────┬───────────┬──┐
│68│194 165│226 141 186│226 140 138│226 151 139│57│
└──┴───────┴───────────┴───────────┴───────────┴──┘ 
```

The rule is that an integer in the range 128 to 191 (inclusive) continues the character of the previous integer (which may itself be a continuation). With that in mind, write a function that, given a right argument which is a simple integer vector representing valid UTF-8 text, encloses each sequence of integers that represent a single character, like the result of `'UTF-8'∘⎕UCS¨'UTF-8'∘⎕UCS` but does not use any system functions (names beginning with `⎕`).

💡 Hint: Use [`⎕UCS`](https://help.dyalog.com/latest/#Language/System%20Functions/ucs.htm) to verify your solution.

### Examples
```APL
      (your_function) 68 194 165 226 141 186 226 140 138 240 159 148 178 57   ⍝ using ]Boxing on
┌──┬───────┬───────────┬───────────┬───────────────┬──┐
│68│194 165│226 141 186│226 140 138│240 159 148 178│57│
└──┴───────┴───────────┴───────────┴───────────────┴──┘

      (your_function) 68 121 97 108 111 103   ⍝ 'Dyalog'
┌──┬───┬──┬───┬───┬───┐
│68│121│97│108│111│103│
└──┴───┴──┴───┴───┴───┘

      (your_function) ⍬   ⍝ '' (any empty vector result is acceptable here)
```

</div>


<div id="P3_Columns" class="problem" markdown="1">   

# 3: Excel-lent Columns
A Microsoft Excel spreadsheet numbers its rows counting up from 1. However Excel's columns are labelled alphabetically — beginning with A–Z, then AA–AZ, BA–BZ, up to ZA–ZZ, then AAA–AAZ and so on.

Write a function that, given a right argument which is a character scalar or non-empty vector representing a valid character Excel column identifier between A and XFD, returns the corresponding column number.

💡 Hint: The Decode function [`X⊥Y`](https://help.dyalog.com/latest/#Language/Primitive%20Functions/Decode.htm).

### Examples

```APL
      (your_function) 'A'
1

      (your_function) 'APL'
1104
```

</div>

<div id="P4_Take_a_Leap" class="problem" markdown="1">   

# 4: Take a Leap
Write a function that, given a right argument which is an integer array of year numbers greater than or equal to 1752 and less than 4000, returns a result of the same shape as the right argument where 1 indicates that the corresponding year is a leap year (0 otherwise).

A leap year algorithm can be found [here](https://en.wikipedia.org/wiki/Leap_year#Algorithm). 

💡 Hint: The Residue function [`X|Y`](https://help.dyalog.com/latest/#Language/Primitive%20Functions/Residue.htm) and the Outer Product operator [`∘.`](https://help.dyalog.com/latest/#Language/Primitive%20Operators/Outer%20Product.htm) could be useful for this problem.

### Examples
```APL
      (your_function) 2020
1

      (your_function) ⍬   ⍝ returns an empty vector

      (your_function) 1900+10 10⍴⍳100
0 0 0 1 0 0 0 1 0 0
0 1 0 0 0 1 0 0 0 1
0 0 0 1 0 0 0 1 0 0
0 1 0 0 0 1 0 0 0 1
0 0 0 1 0 0 0 1 0 0
0 1 0 0 0 1 0 0 0 1
0 0 0 1 0 0 0 1 0 0
0 1 0 0 0 1 0 0 0 1
0 0 0 1 0 0 0 1 0 0
0 1 0 0 0 1 0 0 0 1
```

</div>

<div id="P5_Integer_Range" class="problem" markdown="1">  

# 5: Stepping in the Proper Direction
Write a function that, given a right argument of 2 integers, returns a vector of the integers from the first element of the right argument to the second, inclusively.

💡 Hint: The Index Generator function [`⍳Y`](https://help.dyalog.com/latest/index.htm/#Language/Primitive%20Functions/Index%20Generator.htm) function could be useful when solving this problem.

### Examples
```APL
      (your_function) 3 10
3 4 5 6 7 8 9 10

      (your_function) 4 ¯3
4 3 2 1 0 ¯1 ¯2 ¯3

      ⎕←r←(your_function) 42 42
42

      ⍴r   ⍝ this is also a vector
1
```

</div>

<div id="P6_Move_To_Front" class="problem" markdown="1"> 

# 6: Move to the Front

Write a function that, given a right argument which is an integer vector and a left argument which is an integer scalar, reorders the right argument so any elements equal to the left argument come first while all other elements keep their order. 

💡 Hint: The Grade Up function [`⍋Y`](https://help.dyalog.com/latest/#Language/Primitive%20Functions/Grade%20Up%20Monadic.htm) could be helpful for this problem.

### Examples
```APL
      3 (your_function) 1 2 3 4 1 3 1 4 5
3 3 1 2 4 1 1 4 5

      3 (your_function) ,1   ⍝ the , makes 1 into a vector
1

      42 (your_function) ⍬   ⍝ empty right argument gives empty result
```

</div>

<div id="P7_Bits" class="problem" markdown="1">    

# 7: See You in a Bit
A common technique for encoding a set of on/off states is to use a value of 2<sup><em>n</em></sup> for the state in position <em>n</em> (origin 0), 1 if the state is "on" or 0 for "off" and then add the values. Dyalog APL's [component file permission codes](https://help.dyalog.com/17.1/#Language/APL%20Component%20Files/Component%20Files.htm#File_Access_Control) are an example of this. For example, if you wanted to grant permissions for read (access code 1), append (access code 8) and rename (access code 128) then the resulting code would be 137 because that's 1 + 8 + 128.

Write a function that, given a non-negative right argument which is an integer scalar representing the encoded state and a left argument which is an integer scalar representing the encoded state settings that you want to query, returns 1 if all of the codes in the left argument are found in the right argument (0 otherwise).

💡 Hint: The Decode function [`X⊥Y`](https://help.dyalog.com/latest/#Language/Primitive%20Functions/Decode.htm) and the derived Inverse operator [`⍣¯1`](https://help.dyalog.com/latest/#Language/Primitive%20Operators/Power%20Operator.htm) could be helpful for decoding the states.

### Examples
```APL
      2 (your_function) 7   ⍝ is 2 in 7 (1+2+4)?
1

      4 (your_function) 11   ⍝ is 4 in 11 (1+2+8)?
0

      3 (your_function) 11   ⍝ is 3 (1+2) in 11 (1+2+8)?
1

      4 (your_function) 0   ⍝ is 4 in 0?
0
```

</div>

<div id="P8_Zigzag" class="problem" markdown="1">   

# 8: Zigzag Numbers
A zigzag number is an integer in which the difference in magnitude of each pair of consecutive digits alternates from positive to negative or negative to positive.

Write a function that takes a single integer greater than or equal to 100 and less than 10<sup>15</sup> as its right argument and returns a 1 if the integer is a zigzag number, 0 otherwise. 

💡 Hint: Your solution might make use of <em>N-wise Reduction</em> [`X f/ Y`](https://help.dyalog.com/latest/#Language/Primitive%20Operators/Reduce%20N%20Wise.htm).

### Examples
```APL
      (your_function) 123 
0

      (your_function) 132
1

      (your_function) 31115
0

      (your_function) 3141514131415
1
```

</div>

<div id="P9_Rise_and_Fall" class="problem" markdown="1"> 

# 9: Rise and Fall
Write a function that, given a right argument which is an integer scalar or vector, returns a 1 if the values of the right argument conform to the following pattern (0 otherwise):

- The elements increase or stay the same until the "apex" (highest value) is reached
- After the apex, any remaining values decrease or remain the same


💡 Hint: The *Reverse* function [`⌽Y`](https://help.dyalog.com/latest/#Language/Primitive%20Functions/Reverse.htm) and the *Maximum* function [`X⌈Y`](https://help.dyalog.com/latest/#Language/Primitive%20Functions/Maximum.htm) combined with *N-wise Reduction* [`X f/ Y`](https://help.dyalog.com/latest/#Language/Primitive%20Operators/Reduce%20N%20Wise.htm) or *Scan* [`f\ Y`](https://help.dyalog.com/latest/#Language/Primitive%20Operators/Scan.htm) can help with solving this problem.

### Examples
```APL
      (your_function) 1 3 3 4 5 2 1
1

      (your_function) 42
1

      (your_function) 1 3 2 4
0

      (your_function) 23 23 23 
1

      (your_function) ⍬  ⍝ empty vector
1
```

</div>

<div id="P10_Stacking_It_Up" class="problem" markdown="1">

# 10: Stacking It Up
Write a function that takes as its right argument a vector of simple arrays of rank 2 or less (scalar, vector, or matrix). Each simple array will consist of either non-negative integers or printable ASCII characters. The function must return a simple character array that displays identically to what `{⎕←⍵}¨` displays when applied to the right argument.

💡 Hint: The *Mix* [`↑Y`](https://help.dyalog.com/latest/#Language/Primitive%20Functions/Mix.htm), *Split* [`↓Y`](https://help.dyalog.com/latest/#Language/Primitive%20Functions/Split.htm), and *Format* [`⍕Y`](https://help.dyalog.com/latest/#Language/Primitive%20Functions/Format%20Monadic.htm) functions could be helpful for solving this problem.

### Examples
All results will look identical with `]Boxing on` as they are simple (non-nested) character arrays.

```APL
      (your_function) 'Hi' 'Earth'
Hi   
Earth

      (your_function) (3 3⍴⍳9)(↑'Adam' 'Michael')(⍳10) '*'(5 5⍴⍳25)
1 2 3               
4 5 6               
7 8 9               
Adam                
Michael             
1 2 3 4 5 6 7 8 9 10
*                   
 1  2  3  4  5      
 6  7  8  9 10      
11 12 13 14 15      
16 17 18 19 20      
21 22 23 24 25

      (your_function) 'O' 'my!'
O  
my!

      (your_function) ,⊂⍳4
1 2 3 4

      (your_function) ,'A'
A
```

</div>
