---
layout: set
title: 2019
problems:  
  - P1_Chunky_Monkey    
  - P2_Making_the_Grade
  - P3_Grade_Distribution
  - P4_Knight_Moves
  - P5_Doubling_Up
  - P6_Telephone_Names
  - P7_In_the_Center_of_It_All
  - P8_Going_the_Distance
  - P9_Area_Code_a_la_Gauss
  - P10_Odd_and_Evens

---

<style>
  @media only screen and (max-width: 600px) {
    .mobileFlex {
      display: block!important;
    }
  }
.mobileFlex {display: inline-flex;}
.chess {width: 20em;}
.chess td,
.telephone td {
    text-align: center;
    height: 2em;
    width: 2em;
    border: 1px solid currentColor;
    min-width: 2em;
}

.chess .knight {
    background: #5e81ac;
}

.chess .pos {
    background: #d8dee9;
    color: #2e3440;
}

.telephone {
    font-size: x-large;
    border-collapse: separate;
}

.telephone td {
    border-radius: 1ex;
}

.telephone rt {
    font-weight: bold;
}

#shoelace {
  border-left: 3px solid #fc9732!important;
  border: solid 1px #ccc;
  border-bottom: solid;
}
#shoelace pre {
  font: 13px SAX2, monospace !important;
  -webkit-text-stroke: .05ex;
  text-align: left;
  border: none;  
  margin-bottom: 0;
}
#shoelace > tbody > tr > td {
  text-align: left;
  padding-left: 1ex;
  border-bottom: solid 1px #ccc;
}
#shoelace .nwse, swne {
  width: 0;
  padding: 0;
}
#shoelace .nwse {
  transform: rotate(-55deg) translate(-1.2ex, 0.5ex);
  color: #b48ead;
}
#shoelace .swne {
  transform: rotate(55deg) translate(1.4ex,1.3ex);
  color: #d08770;
}
#shoelace .nwse:nth-child(3) {
  left: -0.7ex;
}
#shoelace .swne.last {
  left: 0.6ex;
}

#shoelace > tbody > tr > td > table { margin-bottom: 1em; }

#shoelace > tbody > tr > td > table > tbody > tr > td {
  padding: 0.2ex 0.3ex 0.5ex 0ex;
  top: 1.3ex;
  position: relative;  
  font-family: SAX2;
  -webkit-text-stroke: .05ex;
  text-align: left;
  line-height: 1em;
  border: none;
}

</style>

<div id="P1_Chunky_Monkey" class="problem" markdown="1">

# 1: Chunky Monkey
Write a function that, given a scalar or vector as the right argument and a positive (>0) integer chunk size `n` as the left argument, breaks the array's items up into chunks of size `n`. If the number of elements in the array is not evenly divisible by `n`, then the last chunk will have fewer than `n` elements.

💡 Hint: The partitioned enclose function [`X⊂Y`](http://help.dyalog.com/latest/Content/Language/Primitive%20Functions/Partitioned%20Enclose.htm) could be helpful for this problem.

### Examples

```APL
      3 (your_function) ⍳9   ⍝ ]Box on is used to display the result
┌─────┬─────┬─────┐
│1 2 3│4 5 6│7 8 9│
└─────┴─────┴─────┘
      3 (your_function) ⍳11
┌─────┬─────┬─────┬─────┐
│1 2 3│4 5 6│7 8 9│10 11│
└─────┴─────┴─────┴─────┘
      10 (your_function) 'Dyalog'
┌──────┐
│Dyalog│
└──────┘
      2 (your_function) 'The' 'cat' 'in' 'the' 'hat' 'sat' 'pat'
┌─────────┬────────┬─────────┬─────┐
│┌───┬───┐│┌──┬───┐│┌───┬───┐│┌───┐│
││The│cat│││in│the│││hat│sat│││pat││
│└───┴───┘│└──┴───┘│└───┴───┘│└───┘│
└─────────┴────────┴─────────┴─────┘
      5 (your_function) ''   ⍝ result is 0-element vector of text vectors
      4 (your_function) 5
┌─┐
│5│
└─┘
```

</div>  

<div id="P2_Making_the_Grade" class="problem" markdown="1">

# 2: Making the Grade
<table>
  <tr><td style="border:none;">
    <table>
      <tr>
        <td>Score Range</td><td>Letter Grade</td>
      </tr><tr>
        <td>0–64</td><td>F</td>
      </tr><tr>
        <td>65–69</td><td>D</td>
      </tr><tr>
        <td>70–79</td><td>C</td>
      </tr><tr>
        <td>80–89</td><td>B</td>
      </tr><tr>
        <td>90–100</td><td>A</td>    
      </tr>
    </table>
  </td>
  <td style="border: none;">
    <p>
Write a function that, given an array of integer test scores in the inclusive range 0–100, returns an identically-shaped array of the corresponding letter grades according to the table to the left.
    </p>
  </td></tr>
</table>

💡 Hint: You may want to investigate the *interval index* function [`X⍸Y`](http://help.dyalog.com/latest/Content/Language/Primitive%20Functions/Interval%20Index.htm).

### Examples

```APL
      (your_function) 0 64 65 69 70 79 80 89 90 100
FFDDCCBBAA

      (your_function) ⍬  ⍝ returns an empty vector


      (your_function) 2 3⍴71 82 81 82 84 59
CBB
BBF
```

</div>   

<div id="P3_Grade_Distribution" class="problem" markdown="1">

# 3: Grade Distribution
The school's administrative department wants to publish some simple statistics. Given a non-empty character vector of single-letter grades, produce a 3-column, 5-row, alphabetically-sorted matrix of each grade, the number of occurrences of that grade, and the percentage (rounded to 1 decimal position) of the total number of occurrences of that grade. The table should have a row for each grade even if there are no occurrences of a grade. 

Note: due to rounding the last column might not total 100%.

💡 Hint: The key operator [`⌸`](http://help.dyalog.com/latest/Content/Language/Primitive%20Operators/Key.htm) could be useful for this problem.

### Examples

```APL
      (your_function) 9 3 8 4 7/'DABFC'
A 3  9.7
B 8 25.8
C 7 22.6
D 9 29  
F 4 12.9

      (your_function) 20⍴'ABC'
A 7 35
B 7 35
C 6 30
D 0  0
F 0  0

      (your_function) ,'B'
A 0   0
B 1 100
C 0   0
D 0   0
F 0   0
```

</div>     
<div id="P4_Knight_Moves" class="problem" markdown="1">

# 4: Knight Moves

<div class="mobileFlex">
  <table class="chess">
    <tbody><tr>
        <td>1 1</td>
        <td>1 2</td>
        <td>1 3</td>
        <td>1 4</td>
        <td>1 5</td>
        <td>1 6</td>
        <td>1 7</td>
        <td>1 8</td>
    </tr>
    <tr>
        <td>2 1</td>
        <td>2 2</td>
        <td>2 3</td>
        <td>2 4</td>
        <td>2 5</td>
        <td>2 6</td>
        <td>2 7</td>
        <td>2 8</td>
    </tr>
    <tr>
        <td>3 1</td>
        <td>3 2</td>
        <td class="pos">3 3</td>
        <td>3 4</td>
        <td class="pos">3 5</td>
        <td>3 6</td>
        <td>3 7</td>
        <td>3 8</td>
    </tr>
    <tr>
        <td>4 1</td>
        <td class="pos">4 2</td>
        <td>4 3</td>
        <td>4 4</td>
        <td>4 5</td>
        <td class="pos">4 6</td>
        <td>4 7</td>
        <td>4 8</td>
    </tr>
    <tr>
        <td>5 1</td>
        <td>5 2</td>
        <td>5 3</td>
        <td class="knight">5 4</td>
        <td>5 5</td>
        <td>5 6</td>
        <td>5 7</td>
        <td>5 8</td>
    </tr>
    <tr>
        <td>6 1</td>
        <td class="pos">6 2</td>
        <td>6 3</td>
        <td>6 4</td>
        <td>6 5</td>
        <td class="pos">6 6</td>
        <td>6 7</td>
        <td>6 8</td>
    </tr>
    <tr>
        <td>7 1</td>
        <td>7 2</td>
        <td class="pos">7 3</td>
        <td>7 4</td>
        <td class="pos">7 5</td>
        <td>7 6</td>
        <td>7 7</td>
        <td>7 8</td>
    </tr>
    <tr>
        <td>8 1</td>
        <td>8 2</td>
        <td>8 3</td>
        <td>8 4</td>
        <td>8 5</td>
        <td>8 6</td>
        <td>8 7</td>
        <td>8 8</td>
    </tr>
</tbody></table>
<p style="padding:1em;">
  Consider a chess board as an 8×8 matrix with square <code class="language-APL">(1 1)</code> in the upper left corner and square <code class="language-APL">(8 8)</code> in the lower right corner. For those not familiar with the game of chess, the knight, generally depicted as a horse (♞), can move 2 spaces right or left and then 1 space up or down, or 2 spaces up or down and then 1 space right or left. This means that a knight on square <code class="language-APL">(5 4)</code> can move to any of the indicated squares. Given a 2-element vector representing the current square for a knight, return a vector of 2-element vectors representing (in any order) all the squares that the knight can move to.
</p>
</div>

💡 Hint: The outer product operator [`∘.`](http://help.dyalog.com/latest/Content/Language/Primitive%20Operators/Outer%20Product.htm) could be useful for generating the coordinates.

### Examples

```APL
      (your_function) 5 4   ⍝ ]Box on is used to display the result
┌───┬───┬───┬───┬───┬───┬───┬───┐
│3 3│3 5│4 2│4 6│6 2│6 6│7 3│7 5│
└───┴───┴───┴───┴───┴───┴───┴───┘
      (your_function) 1 1
┌───┬───┐
│2 3│3 2│
└───┴───┘
```

</div>


<div id="P5_Doubling_Up" class="problem" markdown="1">

# 5: Doubling Up

Given a word or a list of words, return a Boolean vector where `1` indicates a word with one or more consecutive duplicated, case-sensitive, letters. Each word will have at least one letter and will consist entirely of either uppercase (A–Z) or lowercase (a–z) letters. Words consisting of a single letter can be scalars.

💡 Hint: The nest function [`⊆Y`](http://help.dyalog.com/latest/Content/Language/Primitive%20Functions/Nest.htm) could be useful.

### Examples

```APL
      (your_function) 'I' 'feed' 'the' 'bookkeeper'
0 1 0 1
      (your_function) 'I'
0
      (your_function) 'feed'
1
      (your_function) 'MY' 'LLAMAS' 'HAVE' 'BEEN' 'GOOD'
0 1 0 1 1 
```

</div>            
<div id="P6_Telephone_Names" class="problem" markdown="1">

# 6: Telephone Names

<table>
  <tr><td style="border: none;" markdown="1">
<table class="telephone">
    <tbody><tr>
        <td><ruby>1<rt></rt></ruby></td>
        <td><ruby>2<rt>ABC</rt></ruby></td>
        <td><ruby>3<rt>DEF</rt></ruby></td>
    </tr>
    <tr>
        <td><ruby>4<rt>GHI</rt></ruby></td>
        <td><ruby>5<rt>JKL</rt></ruby></td>
        <td><ruby>6<rt>MNO</rt></ruby></td>
    </tr>
    <tr>
        <td><ruby>7<rt>PQRS</rt></ruby></td>
        <td><ruby>8<rt>TUV</rt></ruby></td>
        <td><ruby>9<rt>WXYZ</rt></ruby></td>
    </tr>
    <tr>
        <td><ruby>*<rt></rt></ruby></td>
        <td><ruby>0<rt></rt></ruby></td>
        <td><ruby>#<rt></rt></ruby></td>
    </tr>
</tbody></table> 
  </td><td style="border: none;">
Some telephone keypads have letters of the alphabet embossed on their keytops. Some people like to remember phone numbers by converting them to an alphanumeric form using one of the letters on the corresponding key. For example, in the keypad shown, <code>'ALSMITH'</code> would correspond to the number 257-6484 and <code>'1DYALOGBEST'</code> would correspond to 1-392-564-2378.
  </td></tr>
</table>
Write an APL function that takes a character vector right argument that consists of digits and uppercase letters and returns an integer vector of the corresponding digits on the keypad.

💡 Hint: Your solution might make use of the membership function [`X∊Y`](http://help.dyalog.com/latest/Content/Language/Primitive%20Functions/Membership.htm).

### Examples

```APL
      (your_function) 'IAMYY4U'
4 2 6 9 9 4 8
      (your_function) ''   ⍝ should return an empty vector

      (your_function) 'UR2CUTE'
8 7 2 2 8 8 3
```

</div>        
<div id="P7_In_the_Center_of_It_All" class="problem" markdown="1">

# 7: In the Center of It All

Given a right argument of a list of words (or possibly a single word) and a left argument of a width, return a character matrix that has width columns and one row per word, where each word is centered within the row. If width is smaller than the length of a word, truncate the word from the right. If there are an odd number of spaces to center within, leave the extra space on the right.

💡 Hint: The mix [`↑Y`](http://help.dyalog.com/latest/Content/Language/Primitive%20Functions/Mix.htm) and rotate [`X⌽Y`](http://help.dyalog.com/latest/Content/Language/Primitive%20Functions/Rotate.htm) functions will probably be useful here.

### Examples

```APL
      10 (your_function) 'APL' 'Problem' 'Solving' 'Competition'
   APL   
 Problem   
 Solving  
Competitio
      3 (your_function) 0⍴⊂''   ⍝ result should be 0-row, 3-column matrix      
```

</div>
<div id="P8_Going_the_Distance" class="problem" markdown="1">

# 8: Going the Distance

<div class="mobileFlex" markdown="1">

  <svg id="hike" version="1.1" baseProfile="full" width="auto" height="auto" viewBox="0 0 3000 3950"  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:ev="http://www.w3.org/2001/xml-events" >
  <desc>Created by Causeway SVG engine - SharpPlot v3.61.0</desc>
  <g stroke-miterlimit="100">
  <desc>Border =====</desc>
  <desc>Region =====</desc>
  <desc>X-Axis Ticks =====</desc>
  <desc>X-Axis Grid</desc>
   <path fill="none" stroke-width="1.8" stroke="Silver" d="M400 3430L400 460M995 3430L995 460M2185 3430L2185 460M2780 3430L2780 460"/>
  <desc>X-Axis tickmarks</desc>
   <path fill="none" stroke-width="7.2" stroke="Black" d="M400 2242L400 2286M995 2242L995 2286M2185 2242L2185 2286M2780 2242L2780 2286"/>
   <path fill="none" stroke-width="7.2" stroke="Black" d="M400 2242L400 2198M995 2242L995 2198M1590 2242L1590 2198M2185 2242L2185 2198M2780 2242L2780 2198"/>
  <desc>Y-Axis Ticks =====</desc>
  <desc>Y grid</desc>
   <path fill="none" stroke-width="1.8" stroke="Silver" d="M400 3430L2780 3430M400 2836L2780 2836M400 2242L2780 2242M400 1648L2780 1648M400 1054L2780 1054M400 460L2780 460"/>
  <desc>Y-Axis tickmarks</desc>
   <path fill="none" stroke-width="7.2" stroke="Black" d="M1590 3430L1557 3430M1590 2836L1557 2836M1590 2242L1557 2242M1590 1648L1557 1648M1590 1054L1557 1054M1590 460L1557 460"/>
   <path fill="none" stroke-width="7.2" stroke="Black" d="M1623 3430L1590 3430M1623 2836L1590 2836M1623 2242L1590 2242M1623 1648L1590 1648M1623 1054L1590 1054M1623 460L1590 460"/>
  <desc>Axes =====</desc>
   <path fill="none" stroke-width="12" stroke="Black" d="M1590 3474L1590 372M356 2242L2868 2242"/>
  <desc>Arrowhead(s) for the axes</desc>
   <g stroke-width="12" stroke="Black" fill="Black" >
    <path d="M1590 345.9L1611.9 393 1590 377.3 1568.1 393z"/>
    <path d="M2894.1 2242L2847 2263.9 2862.7 2242 2847 2220.1z"/>
   </g>
  <desc>Y-axis labels</desc>
   <g font-family="APL385" font-size="100" text-anchor="end" >
    <text x="1545" y="3460" >¯2</text>
    <text x="1545" y="2866" >¯1</text>
    <text x="1545" y="1678" >1</text>
    <text x="1545" y="1084" >2</text>
    <text x="1545" y="490" >3</text>
   </g>
  <desc>for X-axis labels</desc>
   <g font-family="APL385" font-size="100" text-anchor="middle" >
    <text x="400" y="2366" >¯2</text>
    <text x="995" y="2366" >¯1</text>
    <text x="2185" y="2366" >1</text>
    <text x="2780" y="2366" >2</text>
   </g>
  <desc>Heading, subheading and footnotes =====</desc>
  <desc>Start of Line Chart ===========</desc>
  <desc>Points follow ...</desc>
  <desc>Line</desc>
   <g stroke-width="20" stroke="#928ABD" stroke-linejoin="round" stroke-linecap="round" fill="none" >
    <path d="M698 3133L2483 3133 2483 757 698 3133" />
   </g>
  <desc>Data value labels ... </desc>
   <g fill="#000000" font-family="APL385" font-size="100" text-anchor="middle" >
    <text x="800" y="3240" >A←(¯1.5 ¯1.5)</text>
    <text x="2455" y="730" >B←(1.5 2.5)</text>
    <text x="2425" y="3240" >C←(1.5 ¯1.5)</text>
   </g>
  <desc>Reset to original origin</desc>
  </g>
  </svg>
  <p markdown="1">
    Given a vector of `(X Y)` points, or a single `X Y` point, determine the total distance covered when travelling in a straight line from the first point to the next one, and so on until the last point, then returning directly back to the start. For example, given the points `(A B C) ← (¯1.5 ¯1.5)(1.5 2.5)(1.5 ¯1.5)`, the distance `A` to `B` is `5`, `B` to `C` is `4` and `C` back to `A` is `3`, for a total of `12`.
  </p>
</div>  

💡 Hint: The rotate [`X⌽Y`](http://help.dyalog.com/latest/Content/Language/Primitive%20Functions/Rotate.htm) and power [`X*Y`](http://help.dyalog.com/latest/Content/Language/Primitive%20Functions/Power.htm) functions might be useful.

### Examples

```APL
      (your_function) (1 ¯1)(1 3)   ⍝ from A to B and back to A
8
      (your_function) (1 1)(1 2)(2 2)(2 1)   ⍝ from A to B to C to D to A
4
      (your_function) 5 5   ⍝ staying where we are
0
      (your_function) (1 1)(3 3)   ⍝ there and back again
5.656854249
```

</div>     
<div id="P9_Area_Code_a_la_Gauss" class="problem" markdown="1">

# 9: Area Code à la Gauss

Gauss's area formula, also known as [the shoelace formula](https://en.wikipedia.org/wiki/Shoelace_formula), is an algorithm to calculate the area of a simple polygon (a polygon that does not intersect itself). It's called the shoelace formula because of a common method using matrices to evaluate it. For example, the area of the triangle described by the vertices `(2 4)(3 ¯8)(1 2)` can be calculated by “walking around” the perimeter back to the first vertex, then drawing diagonals between the columns as shown below. The pattern created by the intersecting diagonals resembles shoelaces, hence the name “shoelace formula”

💡 Hint: You may want to investigate the rotate first [`X⊖Y`](http://help.dyalog.com/latest/Content/Language/Primitive%20Functions/Rotate%20First.htm) function.

<table id="shoelace">
<tbody><tr>
<td>First place the vertices in order above each other:</td>
<td>
<table class="apl">
<tbody><tr>
<td>2</td>
<td></td>
<td>4</td>
</tr>
<tr>
<td>3</td>
<td></td>
<td>¯8</td>
</tr>
<tr>
<td>1</td>
<td></td>
<td>2</td>
</tr>
<tr>
<td>2</td>
<td></td>
<td>4</td>
</tr>
</tbody></table>
</td>
</tr>
<tr>
<td>
      Sum the products of the numbers connected by the diagonal lines going down and to the right:<p></p>
<pre>      (2×¯8)+(3×2)+(1×4)
¯6
      </pre>
</td>
<td>
<table class="apl">
<tbody><tr>
<td>2</td>
<td class="nwse">│</td>
<td>4</td>
</tr>
<tr>
<td>3</td>
<td class="nwse">│</td>
<td>¯8</td>
</tr>
<tr>
<td>1</td>
<td class="nwse">│</td>
<td>2</td>
</tr>
<tr>
<td>2</td>
<td></td>
<td>4</td>
</tr>
</tbody></table>
</td>
</tr>
<tr>
<td>
      Next sum the products of the numbers connected by the diagonal lines going down and to the left: <p></p>
<pre>      (4×3)+(¯8×1)+(2×2)
8
      </pre>
</td>
<td>
<table class="apl">
<tbody><tr>
<td>2</td>
<td class="swne">│</td>
<td>4</td>
</tr>
<tr>
<td>3</td>
<td class="swne">│</td>
<td>¯8</td>
</tr>
<tr>
<td>1</td>
<td class="swne">│</td>
<td>2</td>
</tr>
<tr>
<td>2</td>
<td></td>
<td>4</td>
</tr>
</tbody></table>
</td>
</tr>
<tr>
<td> <!------------------------------------------><br>
      Finally, halve the absolute value of the difference between the two sums:  <p></p>
<pre>      0.5 × | ¯6 - 8
7
      </pre>
</td>
<td>
<table class="apl">
<tbody><tr>
<td>2</td>
<td class="swne last">│</td>
<td class="nwse">│</td>
<td>4</td>
</tr>
<tr>
<td>3</td>
<td class="swne last">│</td>
<td class="nwse">│</td>
<td>¯8</td>
</tr>
<tr>
<td>1</td>
<td class="swne last">│</td>
<td class="nwse">│</td>
<td>2</td>
</tr>
<tr>
<td>2</td>
<td></td>
<td></td>
<td>4</td>
</tr>
</tbody></table>
</td>
</tr>
</tbody></table>

Given a vector of `(X Y)` points, or a single `X Y` point, return a number indicating the area circumscribed by the points.

### Examples

```APL
      (your_function) (2 4)(3 ¯8)(1 2)
7
      (your_function) (1 1)   ⍝ a point has no area
0
      (your_function) (1 1)(2 2)   ⍝ neither does a line
0
```

</div>   
<div id="P10_Odd_and_Evens" class="problem" markdown="1">

# 10: Odds & Evens

Given a vector of words, separate the words into two vectors – one containing all the words that have an odd number of letters and the other containing all the words that have an even number of letters.

💡 Hint: You may want to look into the dyadic form of the key operator [`X f⌸ Y`](http://help.dyalog.com/latest/Content/Language/Primitive%20Operators/Key.htm).

### Examples

```APL
      (your_function) 'the' 'plan' 'is' 'great'   ⍝ ]box on is used to display theresult
┌───────────┬─────────┐
│┌───┬─────┐│┌────┬──┐│
││the│great│││plan│is││
│└───┴─────┘│└────┴──┘│
└───────────┴─────────┘
      (your_function) 'all' 'odd' ⍝ note the empty 2nd element of the result
┌─────────┬┐
│┌───┬───┐││
││all│odd│││
│└───┴───┘││
└─────────┴┘
      (your_function) 'only' 'even' 'here' ⍝ note the empty 1st element of the result
┌┬────────────────┐
││┌────┬────┬────┐│
│││only│even│here││
││└────┴────┴────┘│
└┴────────────────┘
```

</div> 
