---
layout: set
title: 2018
problems:
  - P1_Oh_Say_Can_You_See
  - P2_Number_Splitting
  - P3_Rolling_Along
  - P4_Whats_Your_Sign
  - P5_Whats_Your_Sign_Revisited
  - P6_Whats_Your_Angle
  - P7_Unconditionally_Shifty
  - P8_Making_a_Good_Argument
  - P9_Earlier_Later_or_the_Same
  - P10_Anagrammatically_Correct
---

<style>
#skyline span {
    font-size: 50%;
    height: 0;
    display: inline-block;
}
</style>

<div id="P1_Oh_Say_Can_You_See" class="problem" markdown="1">

# 1: Oh Say Can You See?

Imagine standing in front of a line of skyscrapers of varying heights.  Assume that you can always see a skyscraper that is taller than a closer skyscraper. For example, a person on the left of the diagram below can see 3 skyscrapers – the first, fourth, and sixth from left to right. In contrast, a person on the right can see 2 skyscrapers – the seventh and sixth. 

<pre id="skyline" class="language-APL">
                                        ┌───┐        
                                        │   │
                                        │   │
                                        │   │
                                        │   │
                          ┌───┐         │   │  ┌───┐
                          │   │         │   │  │   │       
                          │   │         │   │  │   │ 
                          │   │         │   │  │   │  
                          │   │         │   │  │   │
     ┌───┐  ┌───┐         │   │         │   │  │   │ 
     │   │  │   │         │   │         │   │  │   │ 
     │   │  │   │         │   │  ┌───┐  │   │  │   │
     │   │  │   │  ┌───┐  │   │  │   │  │   │  │   │
     │   │  │   │  │   │  │   │  │   │  │   │  │   │ 
     │ 5 │  │ 5 │  │ 2 │  │<span> </span>10<span> </span>│  │ 3 │  │<span> </span>15<span> </span>│  │<span> </span>10<span> </span>│ 
    ─┘   └──┘   └──┘   └──┘   └──┘   └──┘   └──┘   └─
</pre>

Write an APL expression that, given a scalar or vector of skyscraper heights from closest to furthest, will return an integer representing the number of skyscrapers that can be seen.

### Examples:

```APL
      your_function 5 5 2 10 3 15 10 ⍝ from the left person's view
3
      your_function ⌽ 5 5 2 10 3 15 10 ⍝ from the right person's view
2
      your_function ⍬   ⍝ no skyscrapers here!
0
      your_function 10  ⍝ single skyscraper
1
```

</div>


<div id="P2_Number_Splitting" class="problem" markdown="1">

# 2: Number Splitting

Write an APL expression that, given a scalar real non-negative number, will return a two-element vector of the integer and fractional parts   of the number.

### Examples:

```APL
      your_function 1.234
1 0.234
      your_function 12
12 0
      your_function .1234
0 0.1234
      your_function 0
0 0
```

</div>


<div id="P3_Rolling_Along" class="problem" markdown="1">

# 3: Rolling Along

Using the key operator [`⌸`](http://help.dyalog.com/latest/#Language/Primitive%20Operators/Key.htm), write an APL expression that, given an integer scalar or vector representing the number of sides on each of a set of dice, will return a histogram showing the distribution curve for the possible totals that can be rolled using those dice. The histogram is a 2-column matrix where the left column contains the possible totals for the dice, and the right column has vectors containing asterisks representing the number of occurrences of the corresponding totals.  Trailing spaces are allowed in the character vectors.

Note: If you have `]boxing on` then the result will look different.

### Examples:

```APL
      your_function 6 6   ⍝ 2 6-sided dice
 2  *     
 3  **      
 4  ***    
 5  ****      
 6  *****   
 7  ****** 
 8  *****   
 9  ****      
10  ***    
11  **
12  *
      your_function 6  ⍝ 1 6-sided die (flat distribution)
1  *  
2  *  
3  *  
4  *  
5  *  
6  * 
      your_function 5 3 4 ⍝ 5, 3, and 4-sided dice
 3  *            
 4  ***          
 5  ******
 6  *********     
 7  ***********  
 8  ***********  
 9  *********    
10  ******
11  ***          
12  *
      your_function ⍬ ⍝ no dice
0  *   
```

</div>


<div id="P4_Whats_Your_Sign" class="problem" markdown="1">

# 4: What's Your Sign?

The Chinese animal zodiac is a repeating cycle of 12 years, with each year being represented by an animal. 2018 is the year of the dog. The signs for the last 12 years are:

<div align="center" markdown="1">

|   |   |   |
|-
|2018|Dog||2012|Dragon
|-
|2017|Rooster||2011|Rabbit
|-
|2016|Monkey||2010|Tiger
|-
|2015|Goat||2009|Ox
|-
|2014|Horse||2008|Rat
|-
|2013|Snake||2007|Pig

</div>

Note that the year 1 AD (represented as `1`) follows the year 1 BC (represented as `¯1`) with no intervening "0" year. 

Write an APL expression that, given a scalar integer year, returns a character vector (string) of the Chinese zodiac sign for that year.  For the purposes of this problem, assume that each year number corresponds to exactly one Chinese zodiac animal.

### Examples:

```APL
      your_function 2018  ⍝ Newborns this year will be Dogs
Dog
      your_function 1564  ⍝ William Shakespeare b. 1564
Rat
      your_function ¯551  ⍝ Confucius b. 551 BC
Dog
```

</div>


<div id="P5_Whats_Your_Sign_Revisited" class="problem" markdown="1">

# 5: What's Your Sign? Revisited

In Western astrology, the Zodiac is based on twelve 30° sectors of the ecliptic. Although the exact dates in a given year may shift by a day, the general dates for each sign are:

<div align="center" markdown="1">

|   |   |   |
|-
|Aries|March 21–April 19|Libra|September 23–October 22|
|-
|Taurus|April 20–May 20|Scorpio|October 23–November 21|
|-
|Gemini|May 21–June 20|Sagittarius|November 22–December 21|
|-
|Cancer|June 21–July 22|Capricorn|December 22–January 19|
|-
|Leo|July 23–August 22|Aquarius|January 20–February 18|
|-
|Virgo|August 23–September 22|Pisces|February 19–March 20|

</div>

Write an APL expression that, given a 2-element integer vector representing month and day, returns a character vector (string) of the corresponding Western zodiac sign.

### Examples:

```APL
      your_function 2 23    ⍝ February 23
Pisces
      your_function 10 31   ⍝ October 31
Scorpio
```

</div>


<div id="P6_Whats_Your_Angle" class="problem" markdown="1">

# 6: What's Your Angle?

XML elements are denoted with content enclosed in beginning and ending tags. The tags themselves are enclosed in left and right angle brackets `<`  and `>`. The only valid occurrences of angle brackets are as a part of beginning or ending tags.

For example, the following is valid  
```XML
<name><first>Drake</first><last>Mallard</last></name>
```

Whereas the following is not valid XML  
```XML
<math><relation>2<3</relation></math>
```

One easy validation is to check that the angle brackets are properly balanced – all left angle brackets `<` must be "closed" with right angle brackets `>` before another occurrence of a left angle bracket. 

Write an APL expression that, given a character scalar or vector representing some XML, returns 1 if the angle brackets are properly balanced and 0 if not.

### Examples:

```APL
      your_function '<name><first>Drake</first><last>Mallard</last></name>' 
1
      your_function '<math><relation>2<3</relation></math>' 
0
      your_function ''   ⍝ an empty vector is balanced
1
      your_function '>stuff<>/stuff<' 
0
      your_function '<' 
0 
```

</div>


<div id="P7_Unconditionally_Shifty" class="problem" markdown="1">

# 7: Unconditionally Shifty

Logical bitwise shifting is a common operation where bits in a fixed width field are moved to the left or right by a specified amount, `N`,  causing `N` bits to be "shifted out" at one end and `N` 0's to be filled in at the other end.

For example, shifting the following vector by `3`  
      `1 0 1 1 1 0 1 1`  
would result in  
      `0 0 0 1 0 1 1 1`  
and shifting by `¯3` would result in  
      `1 1 0 1 1 0 0 0`  

Write an APL expression that given a right argument of a Boolean scalar or vector, and left argument scalar integer of the shift amount, returns an appropriately shifted transformation of the right argument. 

### Examples:

```APL
      3 your_function 1 0 1 1 1 0 1 1
0 0 0 1 0 1 1 1 
      ¯3 your_function 1 0 1 1 1 0 1 1
1 1 0 1 1 0 0 0
      5 your_function ⍬   ⍝ result is an empty vector      

      0 your_function 1 0 1 1 1 0 1 1
1 0 1 1 1 0 1 1
      3 your_function 1
0
```

</div>


<div id="P8_Making_a_Good_Argument" class="problem" markdown="1">

# 8: Making a Good Argument

Part of Dyalog's help text for dyadic transpose [`R←X⍉Y`](http://help.dyalog.com/latest/#Language/Primitive%20Functions/Transpose%20Dyadic.htm) states:
- `Y` may be any array.
- `X` must be a simple scalar or vector whose elements are included in the set `⍳⍴⍴Y`.
- Integer values in `X` may be repeated but all integers in the set `⍳⌈/X` must be included.
- The length of `X` must equal the rank of `Y`. 

Write an APL function that given a right argument `Y` of any array and a numeric scalar or vector left argument `X` returns a Boolean indicating if the left argument is a valid argument for `X⍉Y`, like the result of `{0::0 ⋄ 1⊣⍺⍉⍵}` but does not use `⍉` (to test the arguments).

### Examples:

```APL
      3 1 2 your_function 2 3 4⍴⍳24
1
      2 1 2 your_function 2 3 4⍴⍳24
1
      2 3 2 your_function 2 3 4⍴⍳24
0
      1 1 your_function 3 4⍴⍳12
1
      1 2 your_function 2 3 4⍴⍳24
0
      1.1 2 3 your_function 2 3 4⍴⍳24
0
      1 your_function ⍬
1
      ⍬ your_function 1
1
```

</div>


<div id="P9_Earlier_Later_or_the_Same" class="problem" markdown="1">

# 9: Earlier, Later, or the Same?

The system function [`⎕TS`](http://help.dyalog.com/latest/#Language/System%20Functions/ts.htm?) returns a 7-element integer vector timestamp representing the current year, month, day, hour, minute, second, and millisecond in that order. 

Write an APL expression that given left and right arguments of such timestamps returns a `¯1`, `1`, or `0` if the left argument represents a time that is respectively, earlier than, later than, or simultaneous with the right argument.

### Examples:

```APL
      2018 4 1 12 34 56 789 your_function 2018 4 1 16 45 12 800
¯1
      2018 4 1 12 34 56 789 your_function 2018 4 1 12 34 56 789
0
      2018 4 1 12 34 56 789 your_function 2017 4 1 12 34 56 789 
1
```

</div>


<div id="P10_Anagrammatically_Correct" class="problem" markdown="1">

# 10: Anagrammatically Correct

An anagram is a word or phrase that can be formed by rearranging the letters of another. For instance, 'stained' and 'instead' are anagrams, as are 'emigrants' and 'streaming'. Spaces are not considered significant in the comparison. 

Write an APL expression that takes left and right arguments of character scalars or vectors returns a `1` if the arguments are anagrams of one another, `0` otherwise. You may assume that both arguments are both either upper-case or lower-case.

### Examples:

```APL
      'ALBERT EINSTEIN' your_function 'TEN ELITE BRAINS'
1
      '' your_function '' 
1
      'd' your_function 'd'
1
      'mesas' your_function 'seam'
0
      'apple' your_function 'lapel'
0
```

</div>

  