---
layout: set
title: 2017
problems:
  - P1_What_an_Odd_Bunch
  - P2_Good_Evening
  - P3_Miss_Quoted
  - P4_Slices_of_Pies
  - P5_DNA
  - P6_k_mers
  - P7_Counting_DNA_Nucleotides
  - P8_Be_the_First_1
  - P9_Double_Trouble
  - P10_Squaring_Off
---

<div id="P1_What_an_Odd_Bunch" class="problem" markdown="1">

# 1: What an Odd Bunch
Write a function that will return the first n odd natural numbers.

### Examples:

```APL
      your_function 5
1 3 5 7 9
      your_function 1
1     
      your_function 0 ⍝ should return an empty vector

```

</div>

       
<div id="P2_Good_Evening" class="problem" markdown="1">

# 2: Good Evening
Write a function that takes an integer array and replaces all the odd numbers with the next greater even number.

### Examples:

```APL
      your_function 1 2 3 4 5
2 2 4 4 6       
      your_function ⍬ ⍝ should return an empty vector      

      your_function 4 4⍴⍳16 ⍝ should work with arrays of any rank  
 2  2  4  4
 6  6  8  8
10 10 12 12
14 14 16 16
```

</div>

            
<div id="P3_Miss_Quoted" class="problem" markdown="1">

# 3: Miss Quoted
Write a function that will remove text found between pairs of double quotes (`"`).

💡 Hint: One technique is to use `≠\`, but there are many ways to solve this problem.

### Examples:

```APL
      your_function 'this "is" a test'
this "" a test
      your_function 'this is a test'
this is a test
      your_function 'this "is" a "test"'
this "" a ""
      your_function ''  ⍝ should return an empty vector

```

</div>

             
<div id="P4_Slices_of_Pies" class="problem" markdown="1">

# 4: Slice(s) of Pie(s)
Write a function that calculates and returns the areas of 0 or more pie slices. The left argument is 0 or more angles (in degrees). The right argument is 0 or more pie diameters. If the number of angles and diameters are not equal to each other (and neither is a single number), a `LENGTH ERROR` should be generated. 

<div align="center">
<img src="{{ site.url }}{{ site.baseurl }}/img/pie.png" style="width:60vw;filter:invert(1);">
</div>

💡 Hint: If you use APL properly, you should not have to check for the length of either argument – it will just work.

### Examples:

```APL
      60 your_function 12 
18.84955592 
      0 your_function 12  ⍝ 0 degree slice
0
      60 your_function 0  ⍝ 0 diameter pie
0
      60 your_function 9 12 15  ⍝ 60 degree slices of 3 different pies
10.60287521 18.84955592 29.45243113 
      60 90 120 your_function 12 ⍝ 3 different size slices of the same pie 
18.84955592 28.27433388 37.69911184
      60 90 120 your_function 9 12 15 ⍝ different sizes of different pies
10.60287521 28.27433388 58.90486225 
      60 90 120 your_function 9 12 ⍝ 3 slices, 2 pies? 
LENGTH ERROR
```

</div>

          
<div id="P5_DNA" class="problem" markdown="1">

# 5: DNA?
Write a a function that takes a string representing a nucleotide and returns a `1` if it is a valid DNA string, `0` otherwise. In other words, are all the characters in the string in the set `'ACGT'`?

### Examples:

```APL
      your_function 'ATGCTTCAGAAAGGTCTTACG'
1
      your_function 'Dyalog'
0
      your_function ''       ⍝ an empty string is valid
1
      your_function 'T'      
1  
```

</div>

                     
<div id="P6_k_mers" class="problem" markdown="1">

# 6: k-mers
The term k-mer typically refers to all the possible substrings of length k that are contained in a string. In computational genomics, k-mers refer to all the possible subsequences (of length k) from a read obtained through DNA Sequencing. Write a dfn that takes a character vector as its right argument and k (the substring length) as its left argument and returns a vector of the k-mers of the original string.

### Examples:

```APL
      4 your_function 'ATCGAAGGTCGT'
┌────┬────┬────┬────┬────┬────┬────┬────┬────┐
│ATCG│TCGA│CGAA│GAAG│AAGG│AGGT│GGTC│GTCG│TCGT│
└────┴────┴────┴────┴────┴────┴────┴────┴────┘
      4 your_function 'AC'    ⍝  k>string length? Return an empty vector

```

</div>
                  
<div id="P7_Counting_DNA_Nucleotides" class="problem" markdown="1">

# 7: Counting DNA Nucleotides
Write a function that takes a character vector representing a DNA string and returns 4 integers of the number of occurrences for each of the symbols 'A', 'C', 'G', and 'T' respectively.

### Examples:

```APL
      your_function 'AGCTTTTCATTCTGACTGCTGTCTTTAAAAAAAGAGTGTCTGATAGCAG' 
14 8 10 17
      your_function 'CCAAATGGGG'
3 2 4 1
      your_function ''
0 0 0 0
      your_function ,'G'
0 0 1 0
```

</div>


<div id="P8_Be_the_First_1" class="problem" markdown="1">

# 8: Be the First 1
Write a dfn that takes a Boolean vector or scalar and "turns off" all the 1s after the first 1.

### Examples:

```APL
      your_function 0 1 0 1 0 0 1
0 1 0 0 0 0 0
      your_function ⍬ ⍝ should return an empty vector      

      your_function 0 0 0 0 ⍝ no 1's?  no problem!
0 0 0 0
```

</div>

          
<div id="P9_Double_Trouble" class="problem" markdown="1">

# 9: Double Trouble
Write a function that takes a character vector or scalar and returns a Boolean vector indicating anywhere an element is followed by an element of the same value.

### Examples:

```APL
      your_function 'bookkeeper'
0 1 0 1 0 1 0 0 0 0  
      your_function ''  ⍝ should return an empty vector      

      your_function 'aaaaaa'
1 1 1 1 1 0
      your_function 'd'
0 
```

</div>

          
<div id="P10_Squaring_Off" class="problem" markdown="1">

# 10: Squaring Off
Write a function that will reshape a given array into the smallest square matrix that will contain all the elements of the argument, padding with additional elements if necessary. The pad element should be `0` if the array is numeric and space `' '` if the array is character.

### Examples:

```APL
      your_function 1 2 3 4
1 2 
3 4
      your_function 1 2 3 4 5
1 2 3 
4 5 0 
0 0 0
      your_function 'Dyalog APL'       ⍝ should work with any data
Dyal  
og A  
PL     
      ' '=your_function 'Dyalog APL'   ⍝ show where the spaces are
0 0 0 0
0 0 1 0
0 0 1 1 
1 1 1 1  
      your_function 100  ⍝ should return a 1×1 matrix 
100
      your_function ⍬    ⍝ should return a 0×0 matrix

      ⍴your_function ⍬   ⍝ should return a 0×0 matrix
0 0
```

</div>

           
