---
layout: set
title: 2016
problems:
  - P1_Statistics_Mean
  - P2_Statistics_Median
  - P3_Statistics_Mode
  - P4_Just_Meshing_Around
  - P5_Youre_Unique_Just_Like_Everyone_Else
  - P6_Shorter_Ones_to_the_Front
  - P7_3s_and_5s
  - P8_Separating_Out_the_Negative
  - P9_Delimited_Text
  - P10_Order_Total_Dot_Product
---

<style>.math{font-family:serif}</style>

<div id="P1_Statistics_Mean" class="problem" markdown="1">

# 1: Statistics - Mean
Write a function that takes a numeric array as its right argument and returns the mean (average) of the array.

### Examples:

```APL
      your_function 1 2 3 4 5 6
3.5
      your_function ⍬           ⍝ the average of an empty vector is 0 
0
      your_function 17          ⍝ your solution should work with a scalar argument
17 
      your_function 5 3⍴⍳15     ⍝ and average the columns of a matrix
7 8 9
      your_function 3 3 3⍴⍳15   ⍝ or the matrices of a 3D array etc.
5 6  7
8 9 10
6 7  8
```

</div>


<div id="P2_Statistics_Median" class="problem" markdown="1">

# 2: Statistics - Median
Write a function that takes a numeric vector as its right argument and returns the median of the array. The median is the number separating the higher half of the vector from the lower half. The median can be found by arranging all the observations from lowest value to highest value and picking the middle one. If there is an even number of observations, then there is no single middle value; the median is then defined to be the mean of the two middle values.

### Examples:

```APL
      your_function 1 2 3 4 5 6 7 8 9 
5
      your_function 1 8 2 7 3 6 4 5
4.5
      your_function ⍬
0
      your_function ,7 
7
```

</div>


<div id="P3_Statistics_Mode" class="problem" markdown="1">

# 3: Statistics - Mode
Write a function that takes a numeric vector or scalar as its right argument and returns the mode (that is, the most common value) of the array. If more than one number occurs the greatest number of times, return all such numbers.

### Examples:

```APL
      your_function 2 1 4 3 2 5 1 2
2
      your_function ⍬   ⍝ should return an empty vector       

      your_function 1 2 3 4 1 2
1 2 
```

</div>


<div id="P4_Just_Meshing_Around" class="problem" markdown="1">

# 4: Just Meshing Around
Write a function that takes vectors as its left and right arguments and returns them "meshed" into a single vector formed by alternately taking successive elements from each argument. The arguments do not have to be the same length. 

### Examples:

```APL
      'MENS' your_function 'EKES' 
MEEKNESS
      'Dyalog' your_function 'APL'   
DAyPaLlog
      'APL' your_function 'Dyalog' 
ADPyLalog
       1 3 5 7 your_function 2 4 6 8   ⍝ should work with numeric vectors 
1 2 3 4 5 6 7 8
       '' your_function 'Hello'  ⍝ either or both arguments could be empty
Hello
```

</div>


<div id="P5_Youre_Unique_Just_Like_Everyone_Else" class="problem" markdown="1">

# 5: You're Unique, Just Like Everyone Else
Write a function that takes a vector as its right argument and returns elements that occur only once in the vector.

### Examples:

```APL
      your_function 1 2 3 4 5
1 2 3 4 5
      your_function 1 2 3 4 5 4 3 2 1 
5
      your_function 'hello world' 
he wrd
```

</div>


<div id="P6_Shorter_Ones_to_the_Front" class="problem" markdown="1">

# 6: Shorter Ones to the Front
Write a function that takes a vector of vectors as its right argument and returns it sorted by the length of each element. An element of the vector can be scalar or an empty vector. 

### Examples:

```APL
      your_function 'one' 'two' 'three' 'four' 'five' 'six'
┌───┬───┬───┬────┬────┬─────┐
│one│two│six│four│five│three│
└───┴───┴───┴────┴────┴─────┘
      your_function (2 4 3) (4 5) 1 (7 3)
┌─┬───┬───┬─────┐
│1│4 5│7 3│2 4 3│
└─┴───┴───┴─────┘
      your_function ⍬   ⍝ should return an empty vector      

      your_function 'one' 2 'three' '' 'four' (5 6 7 8)
┌┬─┬───┬────┬───────┬─────┐
││2│one│four│5 6 7 8│three│
└┴─┴───┴────┴───────┴─────┘
```

</div>


<div id="P7_3s_and_5s" class="problem" markdown="1">

# 7: 3s and 5s
Write a function that takes a numeric vector and returns all elements that are divisible by 3 or 5.

### Examples:

```APL
      your_function 1 2 3 4 5 6 7 8 9 10
3 5 6 9 10
      your_function ⍬   ⍝ should return an empty vector

```

</div>


<div id="P8_Separating_Out_the_Negative" class="problem" markdown="1">

# 8: Separating Out the Negative
Write a function that takes a numeric vector and returns a two element vector whose first element contains the values less than 0 (zero) in the vector and the second element contains all values greater than or equal to 0. 

### Examples:

```APL
      your_function 0 1 ¯2 3 ¯4 ¯5 6 7 8 ¯9 10 
┌───────────┬──────────────┐
│¯2 ¯4 ¯5 ¯9│0 1 3 6 7 8 10│
└───────────┴──────────────┘
      your_function 1 2 3 4 5
┌┬─────────┐
││1 2 3 4 5│
└┴─────────┘
      your_function ⍬   ⍝ should return a vector of two empty vectors 
┌┬┐
│││
└┴┘
```

</div>


<div id="P9_Delimited_Text" class="problem" markdown="1">

# 9: Delimited Text
It's common to encounter delimited text – for example, comma- separated values in a file.

Write a function that takes a character vector as its right argument and one or more characters as its left argument, where those characters are delimiters in the right argument. The function should return the delimited text as a vector of vectors.

### Examples:

```APL
      ',' your_function 'comma,delimited,values' 
┌─────┬─────────┬──────┐
│comma│delimited│values│
└─────┴─────────┴──────┘
      ' ' {your_function} 'break up words'
┌─────┬──┬─────┐
│break│up│words│
└─────┴──┴─────┘
      ',' {your_function} ',' 
┌┬┐
│││
└┴┘
```

</div>


<div id="P10_Order_Total_Dot_Product" class="problem" markdown="1">

# 10: Order Total 
Suppose you have a numeric vector that is the list of prices for a set of retail products. You also have a numeric vector that is the number ordered of each product. Write a function that takes as its right argument a vector of prices and as its left argument a numeric vector that indicates the number ordered and returns the total cost for the order. In case you hadn't realized it, this is an application the dot product. The dot product of two vectors <span class="math"><i>A</i> = [<i>A</i><sub>1</sub>, <i>A</i><sub>2</sub>, …,<i>A</i><sub>n</sub>]</span> and <span class="math"><i>B</i> = [<i>B</i><sub>1</sub>, <i>B</i><sub>2</sub>, …,<i>B</i><sub>n</sub>]</span> is defined as

<p style="overflow-x: auto;">
  <img src="{{ site.url }}{{ site.baseurl }}/img/innerprod.svg" style="width: 30em;filter:invert(1);">
</p>

### Examples:

```APL
      5 0 2 your_function 2.99 4.99 1.99
18.93
      0 0 0 your_function 2.99 4.99 1.99
0 
```

</div>

