---
layout: set
title: 2015
problems:
  - P1_Nag_A_Ram
  - P2_Longest_Streak
  - P3_Farey_Tale
  - P4_PDI_Progressive_Dyadic_Iota
  - P5_Hes_so_mean_he_has_no_standard_deviation
  - P6_Hey_This_is_My_Space
  - P7_Just_In_Upper_Case
  - P8_Unlucky_13
  - P9_Id_Like_Mine_Scrambled_Please
  - P10_Blaiseing_a_Trail
---

<style>
      .math{font-family:serif}
</style>

<div id="P1_Nag_A_Ram" class="problem" markdown="1">

# 1: Nag A Ram
Write a function that takes two character vectors as its left and right arguments and returns `1` if they are anagrams of each other. An anagram of a string uses all of the letters of the string ignoring word spacing, capitalisation, and punctuation.

### Examples:

```APL
      'anagram' your_function 'Nag A Ram' 
1
      'Dyalog APL' your_function 'Dog Pay All' 
1
      '' your_function '  !#!' 
1
      'abcde' your_function 'zyxwvu'
0
```

</div>

                               
<div id="P2_Longest_Streak" class="problem" markdown="1">

# 2: Longest Streak
Write a function that takes a numeric vector and returns the length of the longest streak of positive growth. 

### Examples:

```APL
      your_function 1 2 3 4 5 6 7 8 9 
8
      your_function 1 
0
      your_function 9 8 7 6 5 4
0
      your_function 1 5 3 4 2 6 7 8
3
```

</div>

                          
<div id="P3_Farey_Tale" class="problem" markdown="1">

# 3: Farey Tale

### Examples:
In mathematics, the [Farey_sequence](https://en.wikipedia.org/wiki/Farey_sequence) of order n is the sequence of completely reduced fractions between 0 and 1 which, when in lowest terms, have denominators less than or equal to n, arranged in order of increasing size. Each Farey sequence starts with the value 0, denoted by the fraction 0⁄1, and ends with the value 1, denoted by the fraction 1⁄1.

Write a function that takes an integer right argument and returns a vector of the terms in the Farey sequence of that order. Each element in the returned vector is itself a 2-element vector of numerator and denominator for the corresponding term.


```APL
      your_function 0 
┌───┐
│0 1│
└───┘
      your_function 1
┌───┬───┐
│0 1│1 1│
└───┴───┘
      your_function 5
┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
│0 1│1 5│1 4│1 3│2 5│1 2│3 5│2 3│3 4│4 5│1 1│
└───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┘
```

</div>

                              
<div id="P4_PDI_Progressive_Dyadic_Iota" class="problem" markdown="1">

# 4: PDI - Progressive Dyadic Iota
The index-of function `X⍳Y` returns a simple integer vector that identifies where the [major cells](https://aplwiki.com/wiki/Major_cell) of `Y` are first found in `X`. If a major cell of `Y` cannot be found in `X`, then the corresponding item of the returned array will be `1+≢X`.

Example of `X⍳Y`:  
```APL
      'DYALOG APL' ⍳ 'AAALLLB' 
3 3 3 4 4 4 11
```

*Progressive dyadic iota* is similar to `⍳` except that it returns the index of subsequent matches in the left argument until they are exhausted. Write a function that implements progressive dyadic iota.

### Examples:

```APL
      'DYALOG APL' your_function 'AAALLLB' 
3 8 11 4 10 11 11
      '' your_function 'test'  ⍝ should work with empty left argument 
1 1 1 1 
      ⍬≡'test' {your_function} ''  ⍝ should work with empty right argument
1
```

</div>

              
<div id="P5_Hes_so_mean_he_has_no_standard_deviation" class="problem" markdown="1">

# 5: He's so mean, he has no standard deviation
The standard deviation of a population is calculated by taking the square root of the average of the squared differences of the values from their average value. The mathematical formula is:

<div align="center">
<img src="{{ site.url }}{{ site.baseurl }}/img/stdev.svg" style="filter:invert(1);">
</div>

where <span class="math"><i>x̄</i></span> is the mean average value and <span class="math"><i>n</i></span> is the number of values.

Write a function that returns the population standard deviation of its numeric array right argument.

### Examples:

```APL
      your_function 1 2 3 4 5
1.414213562
      your_function 10 10⍴⍳100  ⍝ and higher dimensions as well
28.86607005
```

</div>


<div id="P6_Hey_This_is_My_Space" class="problem" markdown="1">

# 6: Hey! This is My Space
Write a function that takes, as each of its right and left arguments, a pair of co-ordinates representing diagonally opposite corners of two rectangles and returns a `1` if the rectangles overlap. The co-ordinates could be either (upper-left, lower-right) or (upper-right, lower left).

<div align="center">
<img src="{{ site.url }}{{ site.baseurl }}/img/overlaprect.png" style="width: 50vw;filter:grayscale(1)invert(1)">
</div>

### Examples:

```APL
      (1 1)(5 5) your_function (3 3)(7 7)
1
      (1 1)(5 5) your_function (5 5)(1 1)
1
      (1 1)(3 3) your_function (4 4)(7 7)
0
      (1.1 1.1)(5.5 5.5) your_function (3.3 3.3)(4.4 4.4)
1 
```

</div>

                    
<div id="P7_Just_In_Upper_Case" class="problem" markdown="1">

# 7: Just in (Upper) Case
Membership `X∊Y` returns a boolean array of shape `⍴X` with `1`s indicating where elements of `Y` occur in `X`. For a vector `X` this results in a very convenient boolean mask.

In many instances, it is desirable to perform case-insensitive comparisons and operations. Write a function to perform case-insensitive membership between two arrays.

For full marks, consider membership of [cells](https://aplwiki.com/wiki/Cell) in high-rank arrays, your function should still return a vector when comparing cells of the same rank, for example (`3 2⍴⎕A`) and (`1 2⍴'cd'`).

### Examples:

```APL
      'dyalog' your_function 'APL'
0 0 1 1 0 0
      'bramley' your_function 'HAMPSHIRE'
0 1 1 1 0 1 0
```

</div>

                      
<div id="P8_Unlucky_13" class="problem" markdown="1">

# 8: Unlucky 13
You've just been hired by a new company and you've learned that the owner has triskaidekaphobia (fear of the number 13). As such he's issued a corporate mandate that no output from any program shall include the number 13 – 12.99 will be used instead. Your boss wants you to implement a function to process output and change the 13s to 12.99. For now, you need only concern yourself with numeric data and not worry about 13s that are formatted in text.

### Examples:

```APL
      your_function 13
12.99
      your_function ⍳15 
1 2 3 4 5 6 7 8 9 10 11 12 12.99 14 15
      your_function 6+5 6 7 8 9
11 12 12.99 14 15
      your_function 13 130 13.13 1300  ⍝ we only care about the number 13
12.99 130 13.13 1300
```

</div>

                              
<div id="P9_Id_Like_Mine_Scrambled_Please" class="problem" markdown="1">

# 9: I'd Like Mine Scrambled Please
There is [an urban myth](https://en.wikipedia.org/wiki/Typoglycemia) about some research that was supposedly done at Cambridge University that purports changing the order of the interior letters in the words of a sentence does not significantly hamper the readability of the sentence. 

Put another way...  
Teher is an ubran mtyh aobut smoe rseaecrh taht was spuopesldy dnoe at Cmarbdige Uinevsrtiy taht pruoptrs cahgnnig the odrer of the itnreoir lteetrs in the wrods of a sneetcne deos not sgiinifactnly hmaepr the raeadibilty of the sneetcne.  

In the above example, for words that contain more than 3 letters, the first and last letters remain the same while all of the interior letters are transposed in groups of two, ignoring punctuation. If there are an odd number of letters in the interior of the word, then the last letter is left as it is. 

Write a function that takes a character vector word as its argument and returns the word's letters juxtaposed as described above.

### Examples:

```APL
      your_function 'argument'
agrmunet
      ]box on
      your_function¨'this' 'is' 'awesome'
┌────┬──┬───────┐
│tihs│is│aewosme│
└────┴──┴───────┘
      ]box off 
      your_function¨'this' 'is' 'awesome'
 tihs  is  aewosme 
```

</div>

           
<div id="P10_Blaiseing_a_Trail" class="problem" markdown="1">

# 10: Blaise'ing a Trail
The APL expression to compute Pascal's triangle of order `n` is fairly simple.

{% raw %}
```APL
      {{⍉⍵∘.!⍵}0,⍳⍵} 10
1  0  0   0   0   0   0   0  0  0 0
1  1  0   0   0   0   0   0  0  0 0
1  2  1   0   0   0   0   0  0  0 0
1  3  3   1   0   0   0   0  0  0 0
1  4  6   4   1   0   0   0  0  0 0
1  5 10  10   5   1   0   0  0  0 0
1  6 15  20  15   6   1   0  0  0 0
1  7 21  35  35  21   7   1  0  0 0
1  8 28  56  70  56  28   8  1  0 0
1  9 36  84 126 126  84  36  9  1 0
1 10 45 120 210 252 210 120 45 10 1
```
{% endraw %}

However, the output leaves something to be desired. Write a function that takes an integer right argument representing the order of the Pascal's triangle to be created and returns a "nicely" formatted character matrix.  Because we're using a mono-spaced font and can only format whole character positions, lines do not have to be perfectly centered and may vary by a character position.

### Examples:

```APL
      your_function 10 
                 1                     
                1 1           
               1 2 1                   
              1 3 3 1        
             1 4 6 4 1    
           1 5 10 10 5 1        
         1 6 15 20 15 6 1               
        1 7 21 35 35 21 7 1          
      1 8 28 56 70 56 28 8 1        
    1 9 36 84 126 126 84 36 9 1     
1 10 45 120 210 252 210 120 45 10 1
      your_function 1
 1 
1 1
      your_function 0 
1 
```

</div>

