---
layout: set
title: 2014
problems:
  - P1_It_Is_All_Right
  - P2_How_Tweet_It_Is
  - P3_Tell_a_Fib
  - P4_Space_The_Final_Frontier
  - P5_Mirror_Mirror
  - P6_Roll_The_Dice
  - P7_Revolutionary_Thinking
  - P8_Go_The_Distance
  - P9_Going_Ballistic
  - P10_Sales_Are_Up
---

<style>
#skyline span {
    font-size: 50%;
    height: 0;
    display: inline-block;
}
</style>

<div id="P1_It_Is_All_Right" class="problem" markdown="1">

# 1: It Is All Right

Write a dfn that takes the length of the legs of a triangle as its left argument, and the length of the
hypotenuse as its right argument and returns 1 if the triangle is a right triangle, 0 otherwise.

### Test cases:

```APL
      3 4 {your_solution} 5
1
      2 3 {your_solution} 4
0
```

</div>

<div id="P2_How_Tweet_It_Is" class="problem" markdown="1">

# 2: How Tweet It Is

Twitter messages have a 140 character limit; what if the limit was even shorter? One way to shorten the
message yet retain most readability is to remove interior vowels from its words. Write a dfn which takes a
character vector and removes the interior vowels from each word.

### Test cases:

```APL
      {your_solution} 'if you can read this, it worked!'
if yu cn rd ths, it wrkd!
      {your_solution} 'APL is REALLY cool'
APL is RLLY cl
      {your_solution} '' ⍝ an empty vector arg should return an empty vector
 
      {your_solution} 'a' ⍝ should work with a single character message
a
```

</div>

<div id="P3_Tell_a_Fib" class="problem" markdown="1">

# 3: Tell a Fib

Write a dfn that takes an integer right argument and returns that number of terms in the Fibonacci
sequence.

### Test cases:

```APL
      {your_solution} 10
1 1 2 3 5 8 13 21 34 55
      {your_solution} 1
1
      {your_solution} 0 ⍝ should return an empty vector
```

</div>

<div id="P4_Space_The_Final_Frontier" class="problem" markdown="1">

# 4: Space The Final Frontier

Write a dfn that removes extraneous (leading, trailing, and multiple) spaces from a character vector.

### Test cases:

```APL
      {your_solution} '  this  is a   test  '
this is a test
       {your_solution} '' ⍝ should return an empty vector
 
       {your_solution} 'hello world!'
hello world!
       {your_solution} '  ' ⍝ vector of only spaces should return empty vector
```

</div>

<div id="P5_Mirror_Mirror" class="problem" markdown="1">

# 5: Mirror Mirror

A palindrome is a word or phrase whose letters read the same forwards and backwards. Write a dfn which
returns a 1 if its character vector argument is a palindrome, 0 otherwise. For simplicity's sake, you may
assume that the vector is all one case.

### Test cases:

```APL
      {your_solution} 'a man, a plan, a canal, panama!'
1
      {your_solution} '' ⍝ a phrase of 0 length is a palindrome
1
      {your_solution} 'a' ⍝ as is a single letter phrase
1
      {your_solution} 'APL' ⍝ APL may be cool, but it's not a palindrome
0
```

</div>

<div id="P6_Roll_The_Dice" class="problem" markdown="1">

# 6: Roll The Dice

Write a dfn that takes an integer vector representing the sides of a number of dice and returns a 2 column
matrix of the number of ways each possible total of the dice can be rolled.

### Test cases:

```APL
      {your_solution} 6 6 ⍝ 2 six-sided dice
2 1
3 2
4 3
5 4
6 5
7 6
8 5
9 4
10 3
11 2
12 1
      {your_solution} 6 4 ⍝ a six-sided and a four-sided die
2 1
3 2
4 3
5 4
6 4
7 4
8 3
9 2
10 1
      {your_solution} 3 ⍝ a single 3-sided die
1 1
2 1
3 1
      {your_solution} ⍬ ⍝ no dice
0 1
```

</div>

<div id="P7_Revolutionary_Thinking" class="problem" markdown="1">

# 7: Revolutionary Thinking

Imagine there are two circles that are tangent to one another. One circle is stationary, the other can "roll"
around the stationary circle.


<div align="center">
<img src="{{ site.url }}{{ site.baseurl }}/img/2014 circles image.PNG" style="width:30vw;filter:invert(.75);">
</div>


Write a dfn which takes the diameters of the stationary and mobile circles and returns the number of
revolutions the mobile must traverse until the tangent points meet again.

### Test cases

```APL
      10 {your_solution} 10 ⍝ identically sized circles
1
      10 {your_solution} 5 ⍝ a mobile circle that's half the size needs to make 2 revolutions
2
      5 {your_solution} 7 ⍝ a mobile circle of diameter 7 needs to make 5 revolutions around a stationary circle of diameter 5
5
```

</div>

<div id="P8_Go_The_Distance" class="problem" markdown="1">

# 8: Go The Distance

Write a dfn that returns the distance between two points in a space of any number of dimensions.

### Test cases

```APL
      2 {your_solution} 5 ⍝ one-dimensional space
3
      2 2 {your_solution} 5 6 ⍝ two-dimensional space
5
      ⍬ {your_solution} ⍬ ⍝ zero dimension space
0
      2 2 3 4 {your_solution} 3 7 10 9 ⍝ four-dimensions
10
```

</div>

<div id="P9_Going_Ballistic" class="problem" markdown="1">

# 9: Going Ballistic

The following formula gives the horizontal distance a projectile travels:

<div align="center">
<img src="{{ site.url }}{{ site.baseurl }}/img/2014.9 formula.svg" style="width:10vw;filter:invert(1);">
</div>


Where: v is the initial velocity, θ is the trajectory in degrees, d is the horizontal distance and G is the gravitational constant.

Write a dfn which calculates the distance (in meters) a projectile travels given an initial velocity in meters
per second and a trajectory in degrees. Use 9.8 meters per second squared as the gravitational constant.


### Test cases

```APL
      100 {your_solution} 45 ⍝ 100 meters per second and 45 degree trajectory
1020.408163
      0 {your_solution} 45 ⍝ no velocity = no distance
0
      100 {your_solution} 90 ⍝ shooting straight up = no distance
1.249639591E¯13
```

</div>

<div id="P10_Sales_Are_Up" class="problem" markdown="1">

# 10: Sales Are Up

Given a vector representing monthly sales figures, write a dfn that returns the greatest percent month to
month increase.

### Test cases

```APL
      {your_solution} 80 100 120 140
25
      {your_solution} 123 123 123
0
      {your_solution} 101 102 114 117 101 110 102 111 118 115 124 122
11.76470588
      {your_solution} 200 180 160 140 120
¯10
```

</div>
