---
layout: set
title: 2013
problems:
  - P1_Seems_a_Bit_Odd_To_Me
  - P2_Making_The_Grade
  - P3_What_Is_In_a_Word
  - P4_Keeping_Things_In_Balance
  - P5_Identity_Crisis
  - P6_Home_On_The_Range
  - P7_Float_Your_Boat
  - P8_Go_Forth_And_Multiply
  - P9_It_Is_a_Moving_Experience
  - P10_Solution_Salvation
---

<style>
#skyline span {
    font-size: 50%;
    height: 0;
    display: inline-block;
}
</style>

<div id="P1_Seems_a_Bit_Odd_To_Me" class="problem" markdown="1">

# 1: Seems a Bit Odd To Me

Write a dfn to produce a vector of the first n odd numbers.

### Test cases

```APL
      {your_solution} 10
1 3 5 7 9 11 13 15 17 19
      {your_solution} 1
1
      {your_solution} 0 ⍝ this should return an empty vector
```

</div>

<div id="P2_Making_The_Grade" class="problem" markdown="1">

# 2: Making The Grade

Write a dfn which returns the percent (from 0 to 100) of passing (65 or higher) grades in a vector of
grades.

### Test cases

```APL
      {your_solution} 25 90 100 64 65
60
      {your_solution} 50
0
      {your_solution} 80 90 100
100
      {your_solution} ⍳0 ⍝ all grades in an empty vector are passing
100
```

</div>

<div id="P3_What_Is_In_a_Word" class="problem" markdown="1">

# 3: What Is In a Word

Write a dfn which returns the number of words in the given character scalar or vector.

For simplicity's sake, you can consider the space character `' '` to be the only word separator.

### Test cases

```APL
      {your_solution} 'Testing one, two, three'
4
      {your_solution} '' ⍝ empty vector has no words
0
      {your_solution} ' this vector has extra blanks ' ⍝ just counting the blanks won't work
5
```

</div>

<div id="P4_Keeping_Things_In_Balance" class="problem" markdown="1">

# 4: Keeping Things In Balance

Write an APL dfn which returns a 1 if the opening and closing parentheses in a character vector are
balanced, or a zero otherwise.

### Test cases

```APL
      {your_solution} '((2×3)+4)'
1
      {your_solution} ''
1
      {your_solution} 'hello world!'
1
      {your_solution} ')(2×3)+4('
0
      {your_solution} '(()'
0
      {your_solution} ')'
0
```

</div>

<div id="P5_Identity_Crisis" class="problem" markdown="1">

# 5: Identity Crisis

An identity matrix is a square matrix (table) of 0 with 1's in the main diagonal.

Write an APL dfn which produces an n×n identity matrix.

### Test cases

```APL
      {your_solution} 5
1 0 0 0 0
0 1 0 0 0
0 0 1 0 0
0 0 0 1 0
0 0 0 0 1
      {your_solution} 1 ⍝ should return a 1×1 matrix
1
      {your_solution} 0 ⍝ should return a 0×0 matrix
```

</div>

<div id="P6_Home_On_The_Range" class="problem" markdown="1">

# 6: Home On The Range

Write a dfn which returns the magnitude of the range (i.e. the difference between the lowest and
highest values) of a numeric array.

### Test cases

```APL
      {your_solution} 19 ¯3 7.6 22
25
      {your_solution} 101 ⍝ should work with a scalar argument
0
      {your_solution} 2 3⍴10 20 30 40 50 60 ⍝ should work with arrays of any number of dimensions
50
      {your_solution} ⍳0 ⍝ including empty arrays
0
```

</div>

<div id="P7_Float_Your_Boat" class="problem" markdown="1">

# 7: Float Your Boat

Write a dfn which selects the floating point (non-integer) numbers from a numeric vector.

### Test cases

```APL
      {your_solution} 14.2 9 ¯3 3.1 0 ¯1.1
14.2 3.1 ¯1.1
      {your_solution} 1 3 5 ⍝ should return an empty vector
      
      {your_solution} 3.1415
3.1415
```

</div>

<div id="P8_Go_Forth_And_Multiply" class="problem" markdown="1">

# 8: Go Forth And Multiply

Write a dfn which produces a multiplication table.

### Test cases

```APL
      {your_solution} 5
1 2  3  4  5
2 4  6  8  10
3 6  9  12 15
4 8  12 16 20
5 10 15 20 25
      {your_solution} 1 ⍝ should return a 1×1 matrix
1
      {your_solution} 0 ⍝ should return a 0×0 matrix
```

</div>

<div id="P9_It_Is_a_Moving_Experience" class="problem" markdown="1">

# 9: It Is a Moving Experience

Write a dfn which produces n month moving averages for a year's worth of data.

### Test cases

```APL
      sales←200 300 2700 3400 100 2000 400 2100 3500 3000 4700 4300
	  
      2 {your_solution} sales ⍝ produces 2 month moving averages
250 1500 3050 1750 1050 1200 1250 2800 3250 3850 4500
      10 {your_solution} sales ⍝ 10 month moving average
1770 2220 2620
      1 {your_solution} sales ⍝ 1 month moving average is the same as sales
200 300 2700 3400 100 2000 400 2100 3500 3000 4700 4300
```

</div>

<div id="P10_Solution_Salvation" class="problem" markdown="1">

# 10: Solution Salvation

Many people have taken some sort of algebra class where you are presented with a set of linear
equations like:

3x + 2y = 13<br>
x - y = 1

The answer in this case is x=3 and y=2

Write a dfn which solves this type of problem. Hint: this is the easiest of all of the problems
presented here.

The left argument is a vector of the values for the equations and the right argument is a matrix of
the coefficients.

### Test cases

```APL
      13 1 {your_solution} 2 2⍴3 2 1 ¯1
3 2
      2 6 4 {your_solution} 3 3⍴4 1 3 2 2 2 6 3 1
¯1 3 1
```

</div>
