# vbPixelGameEngine

The official distribution of *vbPixelGameEngine*.

Provides a fast, richly featured, cross platform pixel drawing and user interface framework for:

- The development of games.
- Visualization of algorithms.
- Prototyping and experimentation.
- Education.
- Following along with [javidx9](https://www.youtube.com/@javidx9)'s videos, using VB!

*vbPixelGameEngine* road map (in no particular order):

- Continue adding / implementing (to reach parity with v1.24).
- Publish as a nuget package?
- Add documentation.
- Continue adding samples.
- Improve performance.
- Test on Raspberry Pi OS.

*vbPixelGameEngine* is heavily inspired by [olcPixelGameEngine](https://github.com/OneLoneCoder/olcPixelGameEngine); specifically the v1.24 version. Even more specifically, I've developed this project while following along with [javidx9](https://www.youtube.com/@javidx9) videos; so very likely that not all features in v1.24 have been implemented at parity. Once parity has been reached with the v1.24 version, will evaluate if making the jump to v2.x (or greater) makes sense.

*vbPixelGameEngine* is used by 1s of programmers at *some* level of ability! ;-)

## History

I stumbled across [OneLoneCoder](https://github.com/OneLoneCoder) and I couldn't resist the idea of abusing the Command Prompt to act as graphics output device; however, all of his code is written in C++. So the only way that I could jump in an play with this is to either do it in C++ or, well, rewrite it all in VB. As you can probably guess, I chose the later.

Now that I've completed the *olcConsoleGameEngine*-related videos and having had a tremendous amount of fun abusing the Command Prompt (as well as essentially completing the process of porting *olcConsoleGameEngine* [for use with VB](https://github.com/DualBrain/vbConsoleGameEngine)), I've found that the API design by of the [OneLoneCoder](https://github.com/OneLoneCoder) to be very straight forward and, well, BASIC *(although in C/C++)*.

Right now the main focus is on the [olcPixelGameEngine](https://github.com/OneLoneCoder/olcPixelGameEngine) v1.x ("PGE1") which has since been retired and replaced with [olcPixelGameEngine](https://github.com/OneLoneCoder/olcPixelGameEngine) v2.x ("PGE2"). As I continue to work through his videos (in chronological order), I'll continue to update this project as I progress.

## Discord

Please reach out to me on Discord:

- [Discord Invite](https://discord.gg/Y8EH5fF6WG)

## Documentation

Please see [wiki](https://github.com/DualBrain/vbPixelGameEngine/wiki).
