Требуется переработать текст. От помощи не откажусь :)

# CrossInteger
Библиотека реализует простой интерфейс изменения значения переменных.
Позволяет работать с любым типом числа, который указывается в шаблоне конструктора. Библиотека позволяет контролировать:
* Минимальное значение, за которое число уйти не может.
* Максимальное значение, за которое число уйти не может.
* Размер одного шага изменения числа.
* Интервал обновления числа в мс.

### Шаблон
Класс является шаблонным и применяет 2 параметра: `typename T, uint8_t _id = 0`.
 Первый параметр указывает тип переменной, с которой работаем. Например `uint16_t`.
 Второй не обязательный параметр прозрачно передаёт `uint8_t` значение в вызываемый колбек, что позволяет идентифицировать число при использовании нескольких экземпляров класса на один колбек. Например передача номера пина:
```c
CrossInteger<uint8_t, 3> ColorR;
CrossInteger<uint8_t, 5> ColorG;
CrossInteger<uint8_t, 6> ColorB;
//...
ColorR.SetCallback(OnFading);
ColorG.SetCallback(OnFading);
ColorB.SetCallback(OnFading);
//...
void OnFading(uint8_t id, uint8_t value, bool complete)
{
	analogWrite(id, value);
}
```


### Конструктор
Для удобства, класс имеет два конструктора.

```c
CrossInteger();
```
Конструктор класса без параметров. При использовании требуется передать настройки через `Set` методы.


```c
CrossInteger(callback_t callback, T val, T min, T max, T step, uint32_t interval);
```
Конструктор класса с указанием всех настроек.
Параметры: Колбек, Текущее значение числа, Минимальное значение числа, Максимальное значение числа, Шаг изменения числа, Интервал обновления числа.


### Колбеки
```c
void onFading(uint8_t id, T value, bool complete)
```
При любом изменение числа вызывается колбек, в котором Вы должны определять нужные Вам действия.
Параметры: Переданный ID, Текущее значение, Флаг окончания изменения числа.


```c
T onConversion(uint8_t id, T min, T max, T from, T to, T current)
```
Если требуется более сложная функция изменения числа, то её можно определить методом `SetConversion()`, а обработать в этом колбеке.
Параметры: Переданный ID, Минимальное значение, Максимальное значение, Начальное значение, Конечное значение, Текущее значение.
Возврат: Функция должна вернуть новое значение для числа.


### Методы класса
```c
void SetCallback(callback_t callback)
```
Метод указывает на колек, который будет вызываться при любом изменении числа. Важно отметить, что если число будет меняться само на себя, то вызова функции не произойдёт.


```c
void SetConversion(conversion_t conversion)
```
Метод указывает на колбек, которым можно переопределить линейное изменение числа. 


```c
void SetVal(T val)
```
Метод устанавливает значение числа.
Параметры: Значение числа.


```c
void SetMin(T min)
```
Метод устанавливает минимальное значение числа.
Параметры: Значение числа.


```c
void SetMax(T max)
```
Метод устанавливает максимальное значение числа.
Параметры: Значение числа.


```c
void SetStep(T step)
```
Метод устанавливает размер шага изменения числа.
Параметры: Значение числа.


```c
void SetInterval(uint32_t interval)
```
Метод устанавливает интервал шага изменения числа.
Параметры: Значение числа.


```c
void GoMin()
```
Метод мгновенно изменяет число до минимального.


```c
void GoMax()
```
Метод мгновенно изменяет число до максимального.


```c
void GoCenter()
```
Метод мгновенно изменяет число до среднеарифметического, с округлением в меньшую сторону.


```c
void FadeTo(T val_to)
```
Метод плавно изменяет число до указанного.
Параметры: Значение числа.


```c
void FadeMin()
```
Метод плавно изменяет число до минимального.


```c
void FadeMax()
```
Метод плавно изменяет число до максимального.


```c
void FadeCenter()
```
Метод плавно изменяет число до среднеарифметического, с округлением в меньшую сторону.


```c
T GetVal()
```
Метод возвращает моментальное текущее значение числа.


```c
void GetCallback()
```
Метод принудительно вызывает колбек.


```c
void Processing(uint32_t currentTime = millis())
```
Метод обработки числа. В случае, если в Вашей `loop` функции есть определение текущего времени, то целесообразнее передать это время в качестве параметра.
Параметры: Текущая отметка времени.

### Заключение
