package com.doublejony.programmers.practice.hash;

import com.google.common.base.Stopwatch;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.Arrays;
import java.util.HashMap;

import static com.doublejony.common.AssertResolve.resolve;

/**
 * 위장
 * <p>
 * 문제 설명
 * <p>
 * 스파이들은 매일 다른 옷을 조합하여 입어 자신을 위장합니다.
 * 예를 들어 스파이가 가진 옷이 아래와 같고 오늘 스파이가 동그란 안경, 긴 코트, 파란색 티셔츠를 입었다면 다음날은 청바지를 추가로 입거나 동그란 안경 대신 검정 선글라스를 착용하거나 해야 합니다.
 * 종류	이름
 * 얼굴	동그란 안경, 검정 선글라스
 * 상의	파란색 티셔츠
 * 하의	청바지
 * 겉옷	긴 코트
 * 스파이가 가진 의상들이 담긴 2차원 배열 clothes가 주어질 때 서로 다른 옷의 조합의 수를 return 하도록 solution 함수를 작성해주세요.
 * <p>
 * 제한사항
 * clothes의 각 행은 [의상의 이름, 의상의 종류]로 이루어져 있습니다.
 * 스파이가 가진 의상의 수는 1개 이상 30개 이하입니다.
 * 같은 이름을 가진 의상은 존재하지 않습니다.
 * clothes의 모든 원소는 문자열로 이루어져 있습니다.
 * 모든 문자열의 길이는 1 이상 20 이하인 자연수이고 알파벳 소문자 또는 '_' 로만 이루어져 있습니다.
 * 스파이는 하루에 최소 한 개의 의상은 입습니다.
 * <p>
 * 입출력 예
 * clothes	return
 * [["yellowhat", "headgear"], ["bluesunglasses", "eyewear"], ["green_turban", "headgear"]]	5
 * [["crowmask", "face"], ["bluesunglasses", "face"], ["smoky_makeup", "face"]]	3
 * <p>
 * 입출력 예 설명
 * 예제 #1
 * headgear에 해당하는 의상이 yellow_hat, green_turban이고 eyewear에 해당하는 의상이 blue_sunglasses이므로 아래와 같이 5개의 조합이 가능합니다.
 * 1. yellow_hat
 * 2. blue_sunglasses
 * 3. green_turban
 * 4. yellow_hat + blue_sunglasses
 * 5. green_turban + blue_sunglasses
 * 예제 #2
 * face에 해당하는 의상이 crow_mask, blue_sunglasses, smoky_makeup이므로 아래와 같이 3개의 조합이 가능합니다.
 * 1. crow_mask
 * 2. blue_sunglasses
 * 3. smoky_makeup
 */
@RunWith(DataProviderRunner.class)
public class Hash3 {

    @DataProvider
    public static Object[][] dataProviderAdd() {
        // @formatter:off
        return new Object[][] {
                {
                        new String[][] {
                                { "yellowhat", "headgear" },
                                { "bluesunglasses", "eyewear" },
                                { "green_turban", "headgear" }
                        },
                        5
                },
                {
                        new String[][] {
                                { "crowmask", "face" },
                                { "bluesunglasses", "face" },
                                { "smoky_makeup", "face" }
                        },
                        3
                }
        };
        // @formatter:on
    }

    /**
     * 의상 종류별로 1씩 count를 올리고 모든 종류의 의상 개수의 제곱을 서로 곱하면 된다
     * Hash를 쓰면 종류별로 객체를 만들지 않고 빠르게 저장할 수 있다.
     */
    @Test
    @UseDataProvider("dataProviderAdd")
    public void loopApi(String[][] clothes, int expected) {

        Stopwatch timer = Stopwatch.createStarted();

        HashMap<String, Integer> hashMap = new HashMap<>();

        for (String[] clothe : clothes) {
            hashMap.put(clothe[1], hashMap.getOrDefault(clothe[1], 0) + 1);
        }

        int cache = 1;
        for (Integer count : hashMap.values()) {
            cache *= count + 1;
        }

        int answer = cache - 1;

        resolve(Thread.currentThread().getStackTrace()[1].getMethodName(), expected, answer, timer.stop());
    }

    @Test
    @UseDataProvider("dataProviderAdd")
    public void lambda(String[][] clothes, int expected) {

        Stopwatch timer = Stopwatch.createStarted();

        HashMap<String, Integer> hashMap = new HashMap<>();

        Arrays.stream(clothes).forEach(clothe -> hashMap.put(clothe[1], hashMap.getOrDefault(clothe[1], 0) + 1));

        int answer = hashMap.values().stream().mapToInt(count -> count + 1).reduce(1, (a, b) -> a * b) - 1;

        resolve(Thread.currentThread().getStackTrace()[1].getMethodName(), expected, answer, timer.stop());
    }

}
