from collections import Counter

속성 = property


class 해결법:
    def 은_문제를_푼다(이_해결법):
        이_해결법.은_입력을_받고_초기화한다()

        while 이_해결법.의_물고기_수_차이 > 이_해결법.의_K:
            이_해결법.은_어항을_정리한다()

        print(이_해결법.의_어항정리_횟수)

    def 은_입력을_받고_초기화한다(이_해결법):
        이_해결법.의_N, 이_해결법.의_K = map(int, input().split())
        이_해결법.의_어항_속_물고기_수 = {(0, 열번호): 물고기_수 for 열번호, 물고기_수 in enumerate(map(int, input().split()))}
        이_해결법.의_어항_개수 = 이_해결법.의_N
        이_해결법.의_가장_많은_물고기_수 = max(이_해결법.의_어항_속_물고기_수.values())
        이_해결법.의_가장_적은_물고기_수 = min(이_해결법.의_어항_속_물고기_수.values())
        이_해결법.의_물고기_수_차이 = 이_해결법.의_가장_많은_물고기_수 - 이_해결법.의_가장_적은_물고기_수
        이_해결법.의_어항정리_횟수 = 0

    def 은_어항을_정리한다(이_해결법):
        이_해결법.의_어항정리_횟수 += 1
        이_해결법.은_물고기의_수가_가장_적은_어항에_물고기를_한_마리_넣는다()
        이_해결법.은_어항을_90도씩_연속으로_회전한다()
        이_해결법.은_물고기의_수를_조절한다()
        이_해결법.은_어항을_일렬로_놓는다()
        이_해결법.은_어항을_180도씩_연속으로_회전한다()
        이_해결법.은_물고기의_수를_조절한다()
        이_해결법.은_어항을_일렬로_놓는다()

    def 은_물고기의_수가_가장_적은_어항에_물고기를_한_마리_넣는다(이_해결법):
        for 행, 열 in 이_해결법.의_물고기의_수가_가장_적은_어항_위치들:
            이_해결법.의_어항_속_물고기_수[행, 열] += 1

    @속성
    def 의_물고기의_수가_가장_적은_어항_위치들(이_해결법):
        해당_어항_위치들 = []
        for 각_어항의_위치, 각_어항의_물고기_수 in 이_해결법.의_어항_속_물고기_수.items():
            if 각_어항의_물고기_수 == 이_해결법.의_가장_적은_물고기_수:
                해당_어항_위치들.append(각_어항의_위치)
        return 해당_어항_위치들

    def 은_어항을_90도씩_연속으로_회전한다(이_해결법):
        이_해결법.의_회전부_높이 = 1
        이_해결법.의_회전부_너비 = 1
        이_해결법.의_바닥_너비 = 이_해결법.의_어항_개수

        while 이_해결법.이_어항을_90도_회전할_수_있다면():
            이_해결법.은_어항을_90도_회전한다()

    def 이_어항을_90도_회전할_수_있다면(이_해결법):
        회전_후_회전부_높이 = 이_해결법.의_회전부_너비 + 1
        회전_후_회전부_너비 = 이_해결법.의_회전부_높이
        회전_후_바닥_너비 = 이_해결법.의_바닥_너비 - 이_해결법.의_회전부_너비
        return 회전_후_회전부_너비 <= 회전_후_바닥_너비

    def 은_어항을_90도_회전한다(이_해결법):
        회전_후_회전부_높이 = 이_해결법.의_회전부_너비 + 1
        회전_후_회전부_너비 = 이_해결법.의_회전부_높이
        회전_후_바닥_너비 = 이_해결법.의_바닥_너비 - 이_해결법.의_회전부_너비
        회전_후_어항_속_물고기_수 = {}

        for 열_번호 in range(회전_후_바닥_너비):
            이전_열_번호 = 이_해결법.의_회전부_너비 + 열_번호
            회전_후_어항_속_물고기_수[0, 열_번호] = 이_해결법.의_어항_속_물고기_수[0, 이전_열_번호]

        for 행_번호 in range(1, 회전_후_회전부_높이):
            for 열_번호 in range(회전_후_회전부_너비):
                이전_행_번호 = 열_번호
                이전_열_번호 = (이_해결법.의_회전부_너비) - 행_번호
                회전_후_어항_속_물고기_수[행_번호, 열_번호] = 이_해결법.의_어항_속_물고기_수[이전_행_번호, 이전_열_번호]

        이_해결법.의_어항_속_물고기_수 = 회전_후_어항_속_물고기_수
        이_해결법.의_회전부_너비 = 회전_후_회전부_너비
        이_해결법.의_회전부_높이 = 회전_후_회전부_높이
        이_해결법.의_바닥_너비 = 회전_후_바닥_너비

    def 은_물고기의_수를_조절한다(이_해결법):
        # 변화량 계산
        어항_속_물고기_수_변화량 = Counter()
        for 어항_위치 in 이_해결법.의_어항_위치들:
            행_번호, 열_번호 = 어항_위치
            for 이웃_어항_위치 in 이_해결법.의_이웃_어항_위치들(행_번호, 열_번호):
                if 이_해결법.의_어항_속_물고기_수[어항_위치] <= 이_해결법.의_어항_속_물고기_수[이웃_어항_위치]:
                    continue
                물고기_수의_차이 = 이_해결법.의_어항_속_물고기_수[어항_위치] - 이_해결법.의_어항_속_물고기_수[이웃_어항_위치]
                d = 물고기_수의_차이 // 5
                if d > 0:
                    어항_속_물고기_수_변화량[어항_위치] -= d
                    어항_속_물고기_수_변화량[이웃_어항_위치] += d

        # 변화량 적용
        for 어항_위치, 변화량 in 어항_속_물고기_수_변화량.items():
            이_해결법.의_어항_속_물고기_수[어항_위치] += 변화량

        # 물고기 수 갱신
        이_해결법.의_가장_많은_물고기_수 = max(이_해결법.의_어항_속_물고기_수.values())
        이_해결법.의_가장_적은_물고기_수 = min(이_해결법.의_어항_속_물고기_수.values())
        이_해결법.의_물고기_수_차이 = 이_해결법.의_가장_많은_물고기_수 - 이_해결법.의_가장_적은_물고기_수

    def 의_이웃_어항_위치들(이_해결법, 행_번호, 열_번호):
        존재하는_어항_위치들 = set(이_해결법.의_어항_위치들)
        for 행_차이, 열_차이 in [(-1, 0), (0, 1), (1, 0), (0, -1)]:
            이웃_행_번호 = 행_번호 + 행_차이
            이웃_열_번호 = 열_번호 + 열_차이
            if (이웃_행_번호, 이웃_열_번호) in 존재하는_어항_위치들:
                yield 이웃_행_번호, 이웃_열_번호

    @속성
    def 의_어항_위치들(이_해결법):
        return 이_해결법.의_어항_속_물고기_수.keys()

    def 은_어항을_일렬로_놓는다(이_해결법):
        정렬_후_어항_속_물고기_수 = {}
        행_번호 = 0
        열_번호 = 0
        for 어항_위치 in sorted(이_해결법.의_어항_위치들, key=lambda 어항_위치: 어항_위치[::-1]):
            정렬_후_어항_속_물고기_수[행_번호, 열_번호] = 이_해결법.의_어항_속_물고기_수[어항_위치]
            열_번호 += 1
        이_해결법.의_어항_속_물고기_수 = 정렬_후_어항_속_물고기_수

    def 은_어항을_180도씩_연속으로_회전한다(이_해결법):
        이_해결법.의_바닥_너비 = 이_해결법.의_어항_개수
        이_해결법.의_회전부_높이 = 1
        이_해결법.의_회전부_너비 = 이_해결법.의_바닥_너비 // 2

        for _ in range(2):
            이_해결법.은_어항을_180도_회전한다()

    def 은_어항을_180도_회전한다(이_해결법):
        회전_후_어항_속_물고기_수 = {}
        회전_후_회전부_높이 = 이_해결법.의_회전부_높이 * 2 
        회전_후_회전부_너비 = 이_해결법.의_회전부_너비 // 2
        회전_후_바닥_너비 = 이_해결법.의_바닥_너비 - 이_해결법.의_회전부_너비

        for 행_번호 in range(이_해결법.의_회전부_높이):
            for 열_번호 in range(이_해결법.의_회전부_너비):
                회전_후_어항_속_물고기_수[행_번호, 열_번호] = 이_해결법.의_어항_속_물고기_수[행_번호, 이_해결법.의_회전부_너비 + 열_번호]

        for 행_번호 in range(이_해결법.의_회전부_높이):
            for 열_번호 in range(이_해결법.의_회전부_너비):
                회전_후_어항_속_물고기_수[이_해결법.의_회전부_높이 + 행_번호, 열_번호] = 이_해결법.의_어항_속_물고기_수[이_해결법.의_회전부_높이 - 행_번호 - 1, 이_해결법.의_회전부_너비 - 열_번호 - 1]

        이_해결법.의_어항_속_물고기_수 = 회전_후_어항_속_물고기_수
        이_해결법.의_회전부_너비 = 회전_후_회전부_너비
        이_해결법.의_회전부_높이 = 회전_후_회전부_높이
        이_해결법.의_바닥_너비 = 회전_후_바닥_너비


if __name__ == '__main__':
    해결법().은_문제를_푼다()
