import {
	type DomainSchema,
	type Schema,
	type Template,
	generateRandomDomain,
} from "../utils";

export function generate(schema: Schema): Template {
	const domains: DomainSchema[] = [
		{
			host: generateRandomDomain(schema),
			port: 8080,
			serviceName: "backend",
		},
	];

	const envs = [
		"# THIS IS A SAMPLE ENCRYPTION KEY AND SHOULD NEVER BE USED FOR PRODUCTION",
		"ENCRYPTION_KEY=6c1fe4e407b8911c104518103505b218",
		"",
		"# THIS IS A SAMPLE AUTH_SECRET KEY AND SHOULD NEVER BE USED FOR PRODUCTION",
		"AUTH_SECRET=5lrMXKKWCVocS/uerPsl7V+TX/aaUaI7iDkgl3tSmLE=",
		"# Postgres creds",
		"POSTGRES_PASSWORD=infisical",
		"POSTGRES_USER=infisical",
		"POSTGRES_DB=infisical",
		"",
		"# Website URL",
		"# Required",
		"SITE_URL=http://localhost:8080",
		"",
		"# Mail/SMTP",
		"SMTP_HOST=",
		"SMTP_PORT=",
		"SMTP_NAME=",
		"SMTP_USERNAME=",
		"SMTP_PASSWORD=",
		"",
		"# Integration",
		"# Optional only if integration is used",
		"CLIENT_ID_HEROKU=",
		"CLIENT_ID_VERCEL=",
		"CLIENT_ID_NETLIFY=",
		"CLIENT_ID_GITHUB=",
		"CLIENT_ID_GITHUB_APP=",
		"CLIENT_SLUG_GITHUB_APP=",
		"CLIENT_ID_GITLAB=",
		"CLIENT_ID_BITBUCKET=",
		"CLIENT_SECRET_HEROKU=",
		"CLIENT_SECRET_VERCEL=",
		"CLIENT_SECRET_NETLIFY=",
		"CLIENT_SECRET_GITHUB=",
		"CLIENT_SECRET_GITHUB_APP=",
		"CLIENT_SECRET_GITLAB=",
		"CLIENT_SECRET_BITBUCKET=",
		"CLIENT_SLUG_VERCEL=",
		"",
		"CLIENT_PRIVATE_KEY_GITHUB_APP=",
		"CLIENT_APP_ID_GITHUB_APP=",
		"",
		"# Sentry (optional) for monitoring errors",
		"SENTRY_DSN=",
		"",
		"# Infisical Cloud-specific configs",
		"# Ignore - Not applicable for self-hosted version",
		"POSTHOG_HOST=",
		"POSTHOG_PROJECT_API_KEY=",
		"",
		"# SSO-specific variables",
		"CLIENT_ID_GOOGLE_LOGIN=",
		"CLIENT_SECRET_GOOGLE_LOGIN=",
		"",
		"CLIENT_ID_GITHUB_LOGIN=",
		"CLIENT_SECRET_GITHUB_LOGIN=",
		"",
		"CLIENT_ID_GITLAB_LOGIN=",
		"CLIENT_SECRET_GITLAB_LOGIN=",
		"",
		"CAPTCHA_SECRET=",
		"",
		"NEXT_PUBLIC_CAPTCHA_SITE_KEY=",
		"",
		"PLAIN_API_KEY=",
		"PLAIN_WISH_LABEL_IDS=",
		"",
		"SSL_CLIENT_CERTIFICATE_HEADER_KEY=",
	];

	return {
		domains,
		envs,
	};
}
