import { cn } from "@/lib/utils";
import React from "react";

// https://worldvectorlogo.com/downloaded/redis Ref

interface Props {
	className?: string;
}

export const PostgresqlIcon = ({ className }: Props) => {
	return (
		<svg
			width="40"
			height="40"
			viewBox="0 0 40 40"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
			className={className}
		>
			<path
				d="M35.5795 23.2987C35.3852 22.7102 34.8762 22.3002 34.2178 22.2018C33.9073 22.1555 33.5518 22.1753 33.1312 22.262C32.398 22.4133 31.854 22.4708 31.4568 22.482C32.9555 19.952 34.174 17.0668 34.8755 14.3508C36.0098 9.9592 35.4037 7.95855 34.6953 7.05362C32.8208 4.65839 30.0858 3.37162 26.7863 3.33225C25.0263 3.31073 23.4812 3.65825 22.6752 3.90818C21.9247 3.77577 21.1177 3.70177 20.271 3.68813C18.6838 3.6628 17.2815 4.00878 16.0832 4.71994C15.4199 4.49555 14.3552 4.1793 13.1256 3.9775C10.2338 3.50277 7.90314 3.87269 6.19836 5.07702C4.13406 6.53524 3.17706 9.0687 3.35406 12.6072C3.41028 13.7306 4.03874 17.1488 5.02824 20.3905C5.59689 22.2537 6.2033 23.801 6.83063 24.9898C7.7202 26.6755 8.67213 27.6682 9.74076 28.0247C10.3397 28.2242 11.4279 28.3638 12.5725 27.4107C12.7176 27.5863 12.9112 27.7608 13.168 27.9232C13.4943 28.1288 13.8932 28.297 14.2916 28.3967C15.7273 28.7555 17.0723 28.6657 18.2195 28.1627C18.2267 28.3667 18.2322 28.5617 18.2367 28.73C18.2443 29.0032 18.2518 29.2708 18.2618 29.5213C18.3298 31.2143 18.445 32.5308 18.7863 33.4522C18.8052 33.5027 18.8303 33.5798 18.8568 33.6618C19.0272 34.1832 19.3118 35.056 20.0363 35.7395C20.7863 36.4475 21.6937 36.6647 22.5247 36.6647C22.9415 36.6647 23.3392 36.61 23.6878 36.5353C24.9312 36.2688 26.3432 35.8628 27.3645 34.4085C28.3302 33.0337 28.7997 30.9628 28.8845 27.7C28.8955 27.6078 28.9057 27.5197 28.9155 27.4357L28.9357 27.2632L29.1632 27.2833L29.2218 27.2872C30.488 27.345 32.0363 27.0765 32.9872 26.6347C33.7387 26.286 36.1463 25.0148 35.5795 23.2987Z"
				fill="black"
			/>
			<path
				d="M33.4143 23.6325C29.6493 24.4092 29.3905 23.1343 29.3905 23.1343C33.3657 17.2358 35.0275 9.74828 33.5935 7.91574C29.681 2.91699 22.9087 5.28114 22.7957 5.34238L22.7593 5.34899C22.0153 5.19451 21.183 5.10259 20.2473 5.08729C18.5438 5.05943 17.2515 5.53394 16.2708 6.27759C16.2708 6.27759 4.18945 1.3005 4.75149 12.5372C4.87094 14.9276 8.17772 30.6247 12.1218 25.8835C13.5634 24.1497 14.9563 22.6838 14.9563 22.6838C15.6481 23.1433 16.4763 23.3778 17.3445 23.2937L17.412 23.2363C17.391 23.4517 17.4007 23.6622 17.439 23.9115C16.4229 25.0467 16.7215 25.246 14.6904 25.6642C12.635 26.0877 13.8424 26.8417 14.6307 27.039C15.5864 27.2778 17.7973 27.6163 19.2913 25.525L19.2318 25.7637C19.6298 26.0827 19.9093 27.8377 19.8625 29.429C19.8155 31.02 19.7843 32.1125 20.098 32.9658C20.4118 33.8192 20.7243 35.739 23.3945 35.1668C25.6257 34.6887 26.7818 33.4497 26.9427 31.3828C27.0568 29.9135 27.3152 30.1308 27.3315 28.817L27.5387 28.1952C27.7775 26.2033 27.5767 25.5608 28.9512 25.8597L29.2853 25.889C30.2968 25.935 31.6212 25.7262 32.3983 25.365C34.0717 24.5885 35.0642 23.2917 33.4142 23.6325H33.4143Z"
				fill="#336791"
			/>
			<path
				d="M16.978 13.606C16.6387 13.5588 16.3314 13.6025 16.1759 13.7203C16.0886 13.7865 16.0615 13.8632 16.0541 13.916C16.0347 14.0559 16.1327 14.2106 16.1929 14.2903C16.3633 14.5162 16.6122 14.6714 16.8587 14.7055C16.8943 14.7106 16.9298 14.7129 16.9652 14.7129C17.376 14.7129 17.7497 14.393 17.7825 14.1569C17.8237 13.8612 17.3943 13.6641 16.978 13.6062"
				fill="white"
			/>
			<path
				d="M28.218 13.6156C28.1855 13.3838 27.7732 13.3177 27.3817 13.3721C26.9907 13.4265 26.6117 13.6031 26.6433 13.8354C26.6687 14.016 26.9948 14.3244 27.381 14.3244C27.4137 14.3244 27.4465 14.3223 27.4797 14.3176C27.7375 14.2819 27.9267 14.1182 28.0165 14.0239C28.1532 13.88 28.2325 13.7198 28.218 13.6156Z"
				fill="white"
			/>
			<path
				d="M34.6672 23.544C34.5237 23.11 34.0615 22.9703 33.2938 23.1288C31.0145 23.5993 30.1982 23.2733 29.9302 23.076C31.7018 20.377 33.1595 17.1142 33.9457 14.0701C34.3182 12.6282 34.524 11.289 34.5408 10.1975C34.5593 8.99946 34.3553 8.11912 33.9345 7.58136C32.2378 5.41332 29.7475 4.25037 26.7332 4.21849C24.661 4.19516 22.91 4.72551 22.5707 4.87462C21.856 4.69689 21.0767 4.58774 20.2283 4.57382C18.6727 4.54862 17.328 4.92109 16.2147 5.68031C15.731 5.50029 14.4813 5.07122 12.9528 4.82502C10.3104 4.39964 8.21066 4.72196 6.71221 5.78351C4.92426 7.05021 4.09888 9.31456 4.25876 12.5135C4.31258 13.5897 4.92581 16.9005 5.89351 20.0712C7.16736 24.2445 8.55211 26.6068 10.009 27.0928C10.1796 27.1498 10.3762 27.1895 10.593 27.1895C11.1245 27.1895 11.7761 26.95 12.454 26.135C13.2809 25.143 14.1363 24.1752 15.019 23.2325C15.5917 23.5398 16.221 23.7115 16.8645 23.7288C16.8657 23.7457 16.8673 23.7625 16.869 23.7792C16.7582 23.9113 16.6497 24.0452 16.5435 24.1812C16.0977 24.7472 16.0048 24.865 14.5696 25.1605C14.1613 25.2448 13.077 25.4682 13.0611 26.2283C13.0438 27.0588 14.3429 27.4077 14.4909 27.4447C15.0067 27.5737 15.5035 27.6373 15.9774 27.6373C17.1298 27.6373 18.144 27.2587 18.9545 26.5258C18.9295 29.4863 19.053 32.4037 19.4085 33.2927C19.6997 34.0203 20.4108 35.7987 22.6575 35.7985C22.9872 35.7985 23.35 35.7602 23.7492 35.6745C26.094 35.172 27.1122 34.1357 27.506 31.8508C27.7168 30.6298 28.0785 27.7142 28.2487 26.1502C28.6077 26.2622 29.0698 26.3133 29.5695 26.3133C30.6117 26.3133 31.8143 26.0918 32.5685 25.7418C33.4157 25.3483 34.9445 24.383 34.6672 23.544ZM29.0835 12.9756C29.0757 13.4373 29.0122 13.8564 28.9448 14.294C28.8722 14.7646 28.7973 15.2511 28.7785 15.8416C28.7598 16.4164 28.8317 17.014 28.901 17.5918C29.0413 18.7592 29.1852 19.9608 28.628 21.1465C28.5355 20.9825 28.453 20.813 28.3812 20.639C28.312 20.4712 28.1615 20.2015 27.9533 19.8282C27.1432 18.3755 25.246 14.9732 26.2173 13.5849C26.5065 13.1717 27.2407 12.7468 29.0835 12.9756ZM26.8497 5.15344C29.5505 5.21306 31.687 6.22341 33.1997 8.15636C34.3598 9.63896 33.0823 16.385 29.384 22.2048C29.3468 22.1577 29.3093 22.1105 29.2718 22.0635L29.225 22.005C30.1807 20.4267 29.9938 18.865 29.8275 17.4807C29.7592 16.9123 29.6945 16.3758 29.711 15.8717C29.728 15.3374 29.7985 14.8792 29.867 14.436C29.9508 13.89 30.0363 13.325 30.0128 12.659C30.0303 12.5891 30.0375 12.5065 30.0283 12.4085C29.9682 11.7699 29.2388 9.85834 27.7527 8.12821C26.9397 7.18189 25.754 6.12287 24.1352 5.40866C24.8315 5.26434 25.7837 5.12971 26.8497 5.15344ZM11.7366 25.5383C10.9896 26.4365 10.4739 26.2643 10.3042 26.2078C9.19903 25.8392 7.91661 23.5032 6.78594 19.7988C5.80754 16.5936 5.23583 13.3705 5.19051 12.4668C5.04773 9.60841 5.74058 7.61639 7.25004 6.54587C9.70658 4.80384 13.7453 5.84654 15.3682 6.37536C15.3449 6.39841 15.3206 6.41994 15.2976 6.44332C12.6344 9.13281 12.6976 13.7278 12.7042 14.0088C12.7039 14.1171 12.713 14.2706 12.7255 14.4816C12.7713 15.2545 12.8566 16.6928 12.6287 18.3218C12.417 19.8357 12.8837 21.3172 13.9087 22.3868C14.014 22.4963 14.1245 22.6007 14.2401 22.6993C13.7838 23.188 12.7922 24.2687 11.7366 25.5383ZM14.5824 21.7413C13.7562 20.8792 13.381 19.68 13.5528 18.451C13.7933 16.7303 13.7046 15.2316 13.6568 14.4264C13.6501 14.3137 13.6442 14.215 13.6408 14.1371C14.0298 13.7921 15.8327 12.8262 17.1183 13.1208C17.7052 13.2551 18.0627 13.6546 18.2112 14.3419C18.9805 17.8997 18.313 19.3825 17.7768 20.5742C17.6663 20.8197 17.5618 21.0517 17.4727 21.2917L17.4035 21.4773C17.2285 21.9465 17.0658 22.3828 16.9648 22.797C16.0865 22.7945 15.2321 22.4192 14.5824 21.7412V21.7413ZM14.7172 26.5393C14.4607 26.4753 14.2301 26.364 14.0948 26.2718C14.2078 26.2187 14.4089 26.1462 14.7579 26.0743C16.4464 25.7268 16.7072 25.4813 17.2765 24.7583C17.4072 24.5925 17.5552 24.4047 17.76 24.1758L17.7603 24.1755C18.0655 23.8337 18.2052 23.8917 18.4583 23.9968C18.6637 24.0817 18.8635 24.3388 18.9445 24.6218C18.9828 24.7557 19.0258 25.0093 18.885 25.2068C17.6955 26.8723 15.9621 26.851 14.7172 26.5393ZM23.5537 34.7623C21.4882 35.2048 20.7567 34.1508 20.2748 32.9462C19.9638 32.1682 19.8108 28.6607 19.9193 24.7872C19.9207 24.7357 19.9133 24.6858 19.8992 24.639C19.8865 24.5465 19.8672 24.455 19.8415 24.3653C19.6802 23.8017 19.2872 23.3303 18.8155 23.1347C18.6282 23.0572 18.2843 22.9148 17.871 23.0205C17.9592 22.6573 18.112 22.2473 18.2777 21.8033L18.3472 21.6165C18.4255 21.4062 18.5237 21.1878 18.6275 20.957C19.1887 19.7102 19.9573 18.0025 19.1232 14.1447C18.8107 12.6998 17.7673 11.9941 16.1855 12.158C15.2373 12.2561 14.3697 12.6387 13.937 12.8581C13.844 12.9052 13.7589 12.9508 13.6794 12.9951C13.8001 11.5392 14.2564 8.81831 15.9632 7.09681C17.038 6.01312 18.4692 5.47791 20.2128 5.50677C23.6488 5.56292 25.8522 7.32621 27.0957 8.79566C28.1672 10.0618 28.7473 11.3373 28.9788 12.0252C27.2375 11.8481 26.0532 12.1918 25.4528 13.0502C24.1467 14.9173 26.1673 18.541 27.1385 20.2827C27.3167 20.6018 27.4703 20.8777 27.5187 20.9948C27.835 21.7613 28.2443 22.273 28.5432 22.6465C28.6348 22.761 28.7238 22.872 28.7913 22.9688C28.264 23.121 27.3167 23.4723 27.403 25.2283C27.3333 26.1095 26.8382 30.2348 26.5867 31.6923C26.2545 33.618 25.546 34.3352 23.5537 34.7623ZM32.1757 24.8957C31.6363 25.146 30.7338 25.3337 29.8765 25.374C28.9295 25.4183 28.4473 25.268 28.334 25.1755C28.2808 24.0812 28.6882 23.9668 29.1192 23.8458C29.1868 23.8268 29.253 23.8082 29.3168 23.7858C29.3563 23.8182 29.3998 23.8502 29.4475 23.8817C30.2085 24.384 31.566 24.438 33.4827 24.0425L33.5037 24.0383C33.2452 24.28 32.8028 24.6043 32.1757 24.8957Z"
				fill="white"
			/>
		</svg>
	);
};
export const MysqlIcon = ({ className }: Props) => {
	return (
		<svg
			width="40"
			height="40"
			viewBox="0 0 40 40"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
			className={className}
		>
			<path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M12.4844 10.4823C12.2084 10.4814 11.9336 10.5164 11.6667 10.5865V10.6229H11.7062C11.8974 10.9115 12.1105 11.1848 12.3437 11.4406C12.5042 11.7594 12.6437 12.0771 12.8031 12.3958C12.8229 12.376 12.8427 12.3552 12.8427 12.3552C12.9907 12.2377 13.1065 12.0847 13.1794 11.9104C13.2522 11.7361 13.2797 11.5462 13.2594 11.3583C13.1721 11.2238 13.0922 11.0847 13.0198 10.9417C12.9 10.7427 12.6406 10.6427 12.4812 10.4833"
				fill="#5D87A1"
			/>
			<path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M32.2708 27.8657C30.9568 27.7733 29.6383 27.9638 28.4042 28.424C28.1052 28.5438 27.6282 28.5438 27.5865 28.922C27.7468 29.0813 27.7657 29.3387 27.9063 29.5605C28.1792 30.0223 28.5298 30.4337 28.9427 30.7762C29.3593 31.0948 29.776 31.4125 30.2188 31.6917C30.9948 32.172 31.873 32.45 32.6292 32.9282C33.0688 33.2073 33.5063 33.5657 33.9458 33.8657C34.1647 34.025 34.3032 34.2823 34.5823 34.3865V34.3262C34.5003 34.1047 34.3988 33.891 34.2792 33.6875C34.0802 33.4897 33.8802 33.3095 33.6802 33.1105C33.096 32.3378 32.3968 31.6592 31.6073 31.098C30.9688 30.6583 29.573 30.0563 29.3157 29.3272L29.275 29.2865C29.7423 29.2203 30.2027 29.113 30.651 28.9657C31.3282 28.7865 31.9458 28.8272 32.6427 28.6532C32.9625 28.573 33.5407 28.374 33.5407 28.374V28.0615C33.1843 27.7073 32.9292 27.2333 32.5542 26.899C31.534 26.0085 30.4467 25.1977 29.3022 24.474C28.6907 24.0792 27.9022 23.825 27.251 23.4887C27.0157 23.3698 26.626 23.3115 26.4833 23.1137C26.1595 22.6385 25.8885 22.1297 25.675 21.5958C25.1042 20.5125 24.551 19.3115 24.0593 18.1657C23.7683 17.3978 23.4327 16.6475 23.0542 15.9188C21.2275 12.813 18.5907 10.2624 15.4261 8.53964C14.6276 8.15314 13.7786 7.88102 12.9042 7.73131C12.4104 7.71047 11.9188 7.67194 11.4261 7.65319C11.108 7.44481 10.8055 7.21366 10.5209 6.96152C9.39378 6.24797 6.49795 4.71464 5.66878 6.74486C5.13753 8.02714 6.45837 9.28756 6.91148 9.93861C7.29357 10.3976 7.6302 10.8927 7.9167 11.4167C8.05523 11.7521 8.09481 12.1074 8.2292 12.4584C8.51835 13.3595 8.86168 14.2424 9.25731 15.1021C9.46891 15.5271 9.71268 15.9352 9.98648 16.323C10.1459 16.5407 10.4209 16.6355 10.4802 16.9948C10.2618 17.4643 10.109 17.9618 10.0261 18.473C9.68173 19.5603 9.55502 20.705 9.65313 21.8413C9.75127 22.9777 10.0723 24.0837 10.5979 25.0958C10.9104 25.5887 11.6625 26.673 12.6677 26.2583C13.5542 25.9042 13.3573 24.7803 13.6136 23.7958C13.6719 23.5573 13.6334 23.4012 13.7511 23.2438V23.4355C13.7511 23.4355 14.2542 24.5407 14.5042 25.1022C15.1841 26.1323 16.0287 27.0438 17.0042 27.8C17.39 28.137 17.701 28.5512 17.9167 29.0157V29.373H18.3615C18.3522 29.2118 18.3075 29.0548 18.2307 28.913C18.1538 28.771 18.0467 28.6478 17.9167 28.5522C17.552 28.1767 17.2178 27.7727 16.9177 27.3438C16.1024 26.1825 15.3833 24.9567 14.7677 23.6782C14.4552 23.0532 14.1917 22.3678 13.9417 21.7438C13.8271 21.5032 13.8271 21.1397 13.6344 21.0147C13.2786 21.4357 12.9698 21.8943 12.7136 22.3823C12.4025 23.3688 12.2215 24.3917 12.175 25.425C12.099 25.4458 12.1365 25.425 12.099 25.4647C11.4854 25.3032 11.274 24.6397 11.0427 24.0772C10.4453 22.3423 10.3851 20.4677 10.8698 18.698C11.0031 18.2762 11.5813 16.947 11.35 16.5438C11.2344 16.1594 10.85 15.9396 10.6396 15.6365C10.371 15.2287 10.1398 14.7975 9.94898 14.348C9.4917 13.2271 9.26045 11.9771 8.76253 10.848C8.4869 10.3049 8.16596 9.78606 7.80315 9.29694C7.40181 8.80832 7.0478 8.28271 6.74587 7.72714C6.65003 7.50527 6.51565 7.14277 6.66878 6.90111C6.67911 6.83397 6.71103 6.77204 6.75972 6.72467C6.8084 6.67731 6.87118 6.64709 6.93856 6.63861C7.18648 6.41777 7.89795 6.69902 8.1469 6.81986C8.81602 7.08327 9.45337 7.42116 10.0469 7.82714C10.3156 8.02922 10.949 8.54069 10.949 8.54069H11.1365C11.774 8.67922 12.4906 8.57922 13.0906 8.75944C14.1009 9.09619 15.065 9.55812 15.9604 10.1344C18.5997 11.8169 20.7453 14.1695 22.1782 16.9522C22.4177 17.4095 22.5188 17.8292 22.7375 18.3063C23.1542 19.2855 23.675 20.2855 24.0917 21.2375C24.4593 22.1795 24.9347 23.0758 25.5083 23.9083C25.8063 24.325 27.0032 24.5458 27.5417 24.7647C28.0093 24.9265 28.4683 25.1125 28.9167 25.322C29.5948 25.7387 30.2708 26.2188 30.9093 26.6762C31.2272 26.9157 32.224 27.4137 32.2843 27.8125"
				fill="#00758F"
			/>
		</svg>
	);
};
export const MariadbIcon = ({ className }: Props) => {
	return (
		<svg
			width="40"
			height="40"
			viewBox="0 0 40 40"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
			className={className}
		>
			<path
				d="M38.1637 8.19202C38.0639 8.10928 37.9372 8.0659 37.8075 8.07003C37.4539 8.07003 36.9964 8.314 36.7512 8.43598L36.6524 8.486C36.2404 8.68747 35.7917 8.80285 35.3337 8.8251C34.8629 8.83973 34.4567 8.8678 33.9309 8.92147C30.8009 9.2435 29.4115 11.6392 28.0685 13.9557C27.3365 15.2157 26.5827 16.5173 25.5472 17.5273C25.333 17.735 25.1052 17.9282 24.8652 18.1055C23.7942 18.9045 22.4487 19.468 21.3974 19.8705C20.3897 20.256 19.2894 20.6025 18.2257 20.9367C17.2499 21.2442 16.3338 21.5332 15.4885 21.8467C15.1067 21.9893 14.7822 22.0907 14.4968 22.1918C13.7271 22.4493 13.1708 22.6335 12.3609 23.1885C12.0449 23.4043 11.7278 23.6398 11.507 23.8155C10.8638 24.3293 10.2945 24.9295 9.81509 25.5988C9.40495 26.2163 8.93065 26.7888 8.4001 27.3067C8.22932 27.475 7.92559 27.5505 7.47059 27.5505C6.93754 27.5505 6.29102 27.4408 5.6067 27.3248C4.90287 27.2028 4.17342 27.081 3.54887 27.081C3.0402 27.081 2.6523 27.1627 2.36077 27.3322C2.36077 27.3322 1.87284 27.6177 1.66669 27.986L1.86917 28.0775C2.18275 28.2468 2.47374 28.455 2.73525 28.6972C3.00602 28.9482 3.3082 29.1632 3.63425 29.3363C3.7385 29.3782 3.83284 29.4413 3.91115 29.5218C3.82577 29.6438 3.70012 29.8072 3.5696 29.9792C2.84747 30.9233 2.42664 31.521 2.66815 31.8455C2.78092 31.9047 2.90685 31.934 3.0341 31.931C4.60767 31.931 5.45179 31.5223 6.52157 31.0038C6.83507 30.8623 7.15587 30.7075 7.52182 30.5488C8.14637 30.278 8.81972 29.845 9.53209 29.3877C10.4762 28.7777 11.4521 28.1532 12.3975 27.8507C13.1762 27.6123 13.9875 27.4978 14.8017 27.5115C15.8056 27.5115 16.8547 27.647 17.8695 27.7762C18.627 27.8738 19.4102 27.9738 20.1787 28.0202C20.4775 28.0373 20.7544 28.0458 21.0229 28.0458C21.3825 28.047 21.7422 28.0283 22.0999 27.9897L22.1854 27.9592C22.7245 27.6287 22.977 26.9175 23.2222 26.2295C23.3795 25.7867 23.5112 25.3903 23.7162 25.1317C23.729 25.1195 23.743 25.1085 23.7577 25.0987C23.7674 25.0933 23.7787 25.0913 23.7899 25.093C23.8009 25.0948 23.811 25.1003 23.8187 25.1085C23.8187 25.1085 23.8187 25.1085 23.8187 25.128C23.6894 27.8177 22.611 29.5193 21.5157 31.0417L20.7837 31.826C20.7837 31.826 21.8072 31.826 22.389 31.6015C24.5139 30.966 26.1192 29.5657 27.2865 27.3322C27.5745 26.7592 27.8319 26.1712 28.0575 25.5708C28.077 25.5208 28.2624 25.428 28.2442 25.6928C28.2442 25.7697 28.2332 25.855 28.227 25.9367C28.227 25.9892 28.2197 26.0428 28.2174 26.0965C28.1869 26.4685 28.0954 27.2652 28.0954 27.2652L28.7515 26.9127C30.3374 25.9098 31.5572 23.896 32.4794 20.7562C32.8649 19.4485 33.1465 18.1507 33.3954 17.004C33.693 15.6341 33.9505 14.4509 34.2494 13.9935C34.7104 13.2762 35.4142 12.7895 36.0949 12.3199L36.373 12.1259C37.2269 11.5258 38.0807 10.8305 38.2687 9.53748V9.50942C38.4102 8.55065 38.2942 8.30423 38.1637 8.19202Z"
				fill="#231F20"
			/>
		</svg>
	);
};
export const MongodbIcon = ({ className }: Props) => {
	return (
		<svg
			width="40"
			height="40"
			viewBox="8.738 -5.03622834 17.45992422 39.40619484"
			xmlns="http://www.w3.org/2000/svg"
			className={className}
		>
			<path
				d="m15.9.087.854 1.604c.192.296.4.558.645.802a22.406 22.406 0 0 1 2.004 2.266c1.447 1.9 2.423 4.01 3.12 6.292.418 1.394.645 2.824.662 4.27.07 4.323-1.412 8.035-4.4 11.12a12.7 12.7 0 0 1 -1.57 1.342c-.296 0-.436-.227-.558-.436a3.589 3.589 0 0 1 -.436-1.255c-.105-.523-.174-1.046-.14-1.586v-.244c-.024-.052-.285-24.052-.181-24.175z"
				fill="#599636"
			/>
			<path
				d="m15.9.034c-.035-.07-.07-.017-.105.017.017.35-.105.662-.296.96-.21.296-.488.523-.767.767-1.55 1.342-2.77 2.963-3.747 4.776-1.3 2.44-1.97 5.055-2.16 7.808-.087.993.314 4.497.627 5.508.854 2.684 2.388 4.933 4.375 6.885.488.47 1.01.906 1.55 1.325.157 0 .174-.14.21-.244a4.78 4.78 0 0 0 .157-.68l.35-2.614z"
				fill="#6cac48"
			/>
			<path
				d="m16.754 28.845c.035-.4.227-.732.436-1.063-.21-.087-.366-.26-.488-.453a3.235 3.235 0 0 1 -.26-.575c-.244-.732-.296-1.5-.366-2.248v-.453c-.087.07-.105.662-.105.75a17.37 17.37 0 0 1 -.314 2.353c-.052.314-.087.627-.28.906 0 .035 0 .07.017.122.314.924.4 1.865.453 2.824v.35c0 .418-.017.33.33.47.14.052.296.07.436.174.105 0 .122-.087.122-.157l-.052-.575v-1.604c-.017-.28.035-.558.07-.82z"
				fill="#c2bfbf"
			/>
		</svg>
	);
};

export const RedisIcon = ({ className }: Props) => {
	return (
		<svg
			width="40"
			height="40"
			viewBox="0 0 256 220"
			xmlns="http://www.w3.org/2000/svg"
			preserveAspectRatio="xMinYMin meet"
			className={className}
		>
			<path
				d="M245.97 168.943c-13.662 7.121-84.434 36.22-99.501 44.075-15.067 7.856-23.437 7.78-35.34 2.09-11.902-5.69-87.216-36.112-100.783-42.597C3.566 169.271 0 166.535 0 163.951v-25.876s98.05-21.345 113.879-27.024c15.828-5.679 21.32-5.884 34.79-.95 13.472 4.936 94.018 19.468 107.331 24.344l-.006 25.51c.002 2.558-3.07 5.364-10.024 8.988"
				fill="#912626"
			/>
			<path
				d="M245.965 143.22c-13.661 7.118-84.431 36.218-99.498 44.072-15.066 7.857-23.436 7.78-35.338 2.09-11.903-5.686-87.214-36.113-100.78-42.594-13.566-6.485-13.85-10.948-.524-16.166 13.326-5.22 88.224-34.605 104.055-40.284 15.828-5.677 21.319-5.884 34.789-.948 13.471 4.934 83.819 32.935 97.13 37.81 13.316 4.881 13.827 8.9.166 16.02"
				fill="#C6302B"
			/>
			<path
				d="M245.97 127.074c-13.662 7.122-84.434 36.22-99.501 44.078-15.067 7.853-23.437 7.777-35.34 2.087-11.903-5.687-87.216-36.112-100.783-42.597C3.566 127.402 0 124.67 0 122.085V96.206s98.05-21.344 113.879-27.023c15.828-5.679 21.32-5.885 34.79-.95C162.142 73.168 242.688 87.697 256 92.574l-.006 25.513c.002 2.557-3.07 5.363-10.024 8.987"
				fill="#912626"
			/>
			<path
				d="M245.965 101.351c-13.661 7.12-84.431 36.218-99.498 44.075-15.066 7.854-23.436 7.777-35.338 2.087-11.903-5.686-87.214-36.112-100.78-42.594-13.566-6.483-13.85-10.947-.524-16.167C23.151 83.535 98.05 54.148 113.88 48.47c15.828-5.678 21.319-5.884 34.789-.949 13.471 4.934 83.819 32.933 97.13 37.81 13.316 4.88 13.827 8.9.166 16.02"
				fill="#C6302B"
			/>
			<path
				d="M245.97 83.653c-13.662 7.12-84.434 36.22-99.501 44.078-15.067 7.854-23.437 7.777-35.34 2.087-11.903-5.687-87.216-36.113-100.783-42.595C3.566 83.98 0 81.247 0 78.665v-25.88s98.05-21.343 113.879-27.021c15.828-5.68 21.32-5.884 34.79-.95C162.142 29.749 242.688 44.278 256 49.155l-.006 25.512c.002 2.555-3.07 5.361-10.024 8.986"
				fill="#912626"
			/>
			<path
				d="M245.965 57.93c-13.661 7.12-84.431 36.22-99.498 44.074-15.066 7.854-23.436 7.777-35.338 2.09C99.227 98.404 23.915 67.98 10.35 61.497-3.217 55.015-3.5 50.55 9.825 45.331 23.151 40.113 98.05 10.73 113.88 5.05c15.828-5.679 21.319-5.883 34.789-.948 13.471 4.935 83.819 32.934 97.13 37.811 13.316 4.876 13.827 8.897.166 16.017"
				fill="#C6302B"
			/>
			<path
				d="M159.283 32.757l-22.01 2.285-4.927 11.856-7.958-13.23-25.415-2.284 18.964-6.839-5.69-10.498 17.755 6.944 16.738-5.48-4.524 10.855 17.067 6.391M131.032 90.275L89.955 73.238l58.86-9.035-17.783 26.072M74.082 39.347c17.375 0 31.46 5.46 31.46 12.194 0 6.736-14.085 12.195-31.46 12.195s-31.46-5.46-31.46-12.195c0-6.734 14.085-12.194 31.46-12.194"
				fill="#FFF"
			/>
			<path
				d="M185.295 35.998l34.836 13.766-34.806 13.753-.03-27.52"
				fill="#621B1C"
			/>
			<path
				d="M146.755 51.243l38.54-15.245.03 27.519-3.779 1.478-34.791-13.752"
				fill="#9A2928"
			/>
		</svg>
	);
};

export const GitlabIcon = ({ className }: Props) => {
	return (
		<svg
			aria-label="gitlab"
			width="14"
			height="14"
			viewBox="0 0 14 14"
			xmlns="http://www.w3.org/2000/svg"
			className={cn("text-white", className)}
		>
			<path
				d="m13.767 5.854-.02-.05L11.842.83a.5.5 0 0 0-.493-.312.5.5 0 0 0-.287.107.5.5 0 0 0-.169.257L9.607 4.819h-5.21L3.11.883A.5.5 0 0 0 2.162.83L.252 5.801l-.018.05a3.54 3.54 0 0 0 1.173 4.09l.007.005.017.012 2.903 2.174L5.77 13.22l.875.66a.59.59 0 0 0 .711 0l.875-.66 1.436-1.087 2.92-2.187.008-.006a3.54 3.54 0 0 0 1.172-4.085"
				fill="#E24329"
			/>
			<path
				d="m13.767 5.854-.02-.05a6.4 6.4 0 0 0-2.562 1.152L7 10.12l2.666 2.015 2.92-2.187.007-.006a3.54 3.54 0 0 0 1.174-4.088"
				fill="#FC6D26"
			/>
			<path
				d="m4.334 12.135 1.436 1.087.875.66a.59.59 0 0 0 .711 0l.875-.66 1.436-1.087S8.425 11.195 7 10.12c-1.425 1.075-2.666 2.015-2.666 2.015"
				fill="#FCA326"
			/>
			<path
				d="M2.814 6.956A6.4 6.4 0 0 0 .253 5.8l-.02.05a3.54 3.54 0 0 0 1.174 4.09l.007.005.017.012 2.903 2.174L7 10.117z"
				fill="#FC6D26"
			/>
		</svg>
	);
};

export const GithubIcon = ({ className }: Props) => {
	return (
		<svg
			aria-label="github"
			height="18"
			viewBox="0 0 14 14"
			width="18"
			className={className}
		>
			<path
				d="M7 .175c-3.872 0-7 3.128-7 7 0 3.084 2.013 5.71 4.79 6.65.35.066.482-.153.482-.328v-1.181c-1.947.415-2.363-.941-2.363-.941-.328-.81-.787-1.028-.787-1.028-.634-.438.044-.416.044-.416.7.044 1.071.722 1.071.722.635 1.072 1.641.766 2.035.59.066-.459.24-.765.437-.94-1.553-.175-3.193-.787-3.193-3.456 0-.766.262-1.378.721-1.881-.065-.175-.306-.897.066-1.86 0 0 .59-.197 1.925.722a6.754 6.754 0 0 1 1.75-.24c.59 0 1.203.087 1.75.24 1.335-.897 1.925-.722 1.925-.722.372.963.131 1.685.066 1.86.46.48.722 1.115.722 1.88 0 2.691-1.641 3.282-3.194 3.457.24.219.481.634.481 1.29v1.926c0 .197.131.415.481.328C11.988 12.884 14 10.259 14 7.175c0-3.872-3.128-7-7-7z"
				fill="currentColor"
				fillRule="nonzero"
			/>
		</svg>
	);
};

export const BitbucketIcon = ({ className }: Props) => {
	return (
		<svg
			width="14"
			height="13"
			viewBox="0 0 14 13"
			xmlns="http://www.w3.org/2000/svg"
			className={className}
		>
			<path
				d="M.454 0a.448.448 0 0 0-.448.52l1.903 11.556a.61.61 0 0 0 .597.509h9.132a.45.45 0 0 0 .448-.377L13.994.525a.448.448 0 0 0-.448-.52zM8.47 8.352H5.555l-.79-4.121h4.411z"
				fill="#2684FF"
			/>
			<path
				d="M13.384 4.23H9.176L8.47 8.353H5.555L2.113 12.44c.11.095.248.147.393.148h9.134a.45.45 0 0 0 .448-.377z"
				fill="url(#a)"
			/>
			<defs>
				<linearGradient
					id="a"
					x1="14.357"
					y1="5.383"
					x2="7.402"
					y2="10.814"
					gradientUnits="userSpaceOnUse"
				>
					<stop offset=".18" stopColor="#0052CC" />
					<stop offset="1" stopColor="#2684FF" />
				</linearGradient>
			</defs>
		</svg>
	);
};

export const DockerIcon = ({ className }: Props) => {
	return (
		<svg
			height="24"
			viewBox="-.557 117.607 598.543 423.631"
			width="24"
			xmlns="http://www.w3.org/2000/svg"
			className={className}
		>
			<g fill="#0091e2">
				<path d="m592.162 277.804c-1.664-1.37-16.642-12.597-48.815-12.597-8.321 0-16.92.822-25.24 2.191-6.102-41.898-41.327-62.162-42.714-63.257l-8.598-4.93-5.547 7.942c-6.934 10.68-12.204 22.729-15.255 35.052-5.824 23.824-2.219 46.279 9.985 65.447-14.7 8.216-38.553 10.133-43.545 10.406h-393.853c-10.262 0-18.583 8.216-18.583 18.348-.554 33.956 5.27 67.912 17.197 99.951 13.59 35.052 33.838 61.067 59.91 76.95 29.4 17.799 77.383 27.931 131.468 27.931 24.408 0 48.815-2.19 72.946-6.572 33.56-6.025 65.734-17.526 95.412-34.23a260.485 260.485 0 0 0 64.902-52.577c31.342-34.778 49.925-73.663 63.515-108.167h5.547c34.116 0 55.195-13.418 66.844-24.92 7.766-7.12 13.59-15.882 17.751-25.74l2.497-7.12z" />
				<path d="m55.193 306.83h52.698c2.497 0 4.716-1.916 4.716-4.654v-46.553c0-2.465-1.942-4.655-4.716-4.655h-52.698c-2.496 0-4.715 1.916-4.715 4.655v46.553c.277 2.738 2.219 4.655 4.715 4.655zm72.668 0h52.699c2.496 0 4.715-1.916 4.715-4.654v-46.553c0-2.465-1.942-4.655-4.715-4.655h-52.7c-2.496 0-4.715 1.916-4.715 4.655v46.553c.278 2.738 2.22 4.655 4.715 4.655m74.055 0h52.699c2.496 0 4.715-1.917 4.715-4.655v-46.553c0-2.465-1.942-4.655-4.715-4.655h-52.699c-2.496 0-4.715 1.916-4.715 4.655v46.553c0 2.738 1.942 4.655 4.715 4.655zm72.946 0h52.699c2.496 0 4.715-1.917 4.715-4.655v-46.553c0-2.465-1.942-4.655-4.715-4.655h-52.699c-2.496 0-4.715 1.916-4.715 4.655v46.553c0 2.738 2.219 4.655 4.715 4.655zm-147-66.543h52.698c2.496 0 4.715-2.19 4.715-4.655v-46.553c0-2.465-1.942-4.656-4.715-4.656h-52.699c-2.496 0-4.715 1.917-4.715 4.656v46.553c.278 2.464 2.22 4.655 4.715 4.655m74.055 0h52.699c2.496 0 4.715-2.19 4.715-4.655v-46.553c0-2.465-1.942-4.656-4.715-4.656h-52.699c-2.496 0-4.715 1.917-4.715 4.656v46.553c0 2.464 1.942 4.655 4.715 4.655m72.946 0h52.699c2.496 0 4.715-2.19 4.715-4.655v-46.553c0-2.465-2.22-4.656-4.715-4.656h-52.699c-2.496 0-4.715 1.917-4.715 4.656v46.553c0 2.464 2.219 4.655 4.715 4.655m0-66.817h52.699c2.496 0 4.715-1.917 4.715-4.655v-46.553c0-2.465-2.22-4.656-4.715-4.656h-52.699c-2.496 0-4.715 1.917-4.715 4.656v46.553c0 2.464 2.219 4.655 4.715 4.655m73.5 133.36h52.699c2.496 0 4.715-1.917 4.715-4.655v-46.553c0-2.465-1.941-4.655-4.715-4.655h-52.698c-2.497 0-4.716 1.916-4.716 4.655v46.553c.278 2.738 2.22 4.655 4.716 4.655" />
			</g>
		</svg>
	);
};

export const GitIcon = ({ className }: Props) => {
	return (
		<svg
			width="20"
			height="20"
			viewBox="0 0 256 256"
			xmlns="http://www.w3.org/2000/svg"
			preserveAspectRatio="xMinYMin meet"
			className={className}
		>
			<path
				d="M251.172 116.594L139.4 4.828c-6.433-6.437-16.873-6.437-23.314 0l-23.21 23.21 29.443 29.443c6.842-2.312 14.688-.761 20.142 4.693 5.48 5.489 7.02 13.402 4.652 20.266l28.375 28.376c6.865-2.365 14.786-.835 20.269 4.657 7.663 7.66 7.663 20.075 0 27.74-7.665 7.666-20.08 7.666-27.749 0-5.764-5.77-7.188-14.235-4.27-21.336l-26.462-26.462-.003 69.637a19.82 19.82 0 0 1 5.188 3.71c7.663 7.66 7.663 20.076 0 27.747-7.665 7.662-20.086 7.662-27.74 0-7.663-7.671-7.663-20.086 0-27.746a19.654 19.654 0 0 1 6.421-4.281V94.196a19.378 19.378 0 0 1-6.421-4.281c-5.806-5.798-7.202-14.317-4.227-21.446L81.47 39.442l-76.64 76.635c-6.44 6.443-6.44 16.884 0 23.322l111.774 111.768c6.435 6.438 16.873 6.438 23.316 0l111.251-111.249c6.438-6.44 6.438-16.887 0-23.324"
				fill="#DE4C36"
			/>
		</svg>
	);
};
