/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ExecutionStatisticsCollector {
    static final String RND_ID_STR = "RANDOM_IDENTIFIER";
    static final String NO_ESC_STR = "NO_STATISTICS";
    private static final String PATH = System.getProperty("user.home", "") + File.separator + ".tlaplus" + File.separator + "esc.txt";
    public static final String PROP = ExecutionStatisticsCollector.class.getName() + ".id";
    private final boolean isOptOut;
    private final String pathname;

    public ExecutionStatisticsCollector() {
        this(ExecutionStatisticsCollector.isOptOut(), PATH);
    }

    ExecutionStatisticsCollector(String path) {
        this(false, path);
    }

    ExecutionStatisticsCollector(boolean optOut, String path) {
        this.isOptOut = optOut;
        this.pathname = path;
    }

    public void collect(Map<String, String> parameters) {
        this.collect(parameters, true);
    }

    private void collect(final Map<String, String> parameters, final boolean dontWaitForCompletion) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (ExecutionStatisticsCollector.this.isEnabled()) {
                    parameters.put("id", ExecutionStatisticsCollector.this.getIdentifier());
                    ExecutionStatisticsCollector.submit(parameters, dontWaitForCompletion);
                }
            }
        }, "TLC Execution Statistics Collector");
        thread.setDaemon(dontWaitForCompletion);
        thread.start();
    }

    public String getIdentifier() {
        String identifier;
        Closeable br;
        if (System.getProperty(PROP) != null) {
            return System.getProperty(PROP);
        }
        File udcFile = new File(this.pathname);
        if (!udcFile.exists() && this.isOptOut) {
            try {
                br = new BufferedWriter(new FileWriter(udcFile));
                try {
                    ((Writer)br).write(ExecutionStatisticsCollector.getRandomIdentifier());
                }
                finally {
                    ((BufferedWriter)br).close();
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        if (!udcFile.exists()) {
            return null;
        }
        try {
            br = new BufferedReader(new FileReader(udcFile));
            try {
                identifier = ((BufferedReader)br).readLine();
            }
            finally {
                ((BufferedReader)br).close();
            }
        }
        catch (Exception e) {
            return null;
        }
        if (identifier == null || NO_ESC_STR.equals(identifier.trim())) {
            return null;
        }
        if (identifier == null || RND_ID_STR.equals(identifier.trim())) {
            identifier = ExecutionStatisticsCollector.getRandomIdentifier();
        }
        String trimmed = identifier.trim();
        return trimmed.substring(0, Math.min(trimmed.length(), 32));
    }

    private boolean escFileExists() {
        return new File(this.pathname).exists();
    }

    public boolean isEnabled() {
        return this.getIdentifier() != null;
    }

    public void set(Selection c) throws IOException {
        File udcFile = new File(PATH);
        udcFile.createNewFile();
        try (BufferedWriter br = new BufferedWriter(new FileWriter(udcFile));){
            br.write(c.toString() + "\n");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Selection get() {
        if (!this.isEnabled()) return Selection.NO_ESC;
        try (BufferedReader br = new BufferedReader(new FileReader(new File(this.pathname)));){
            String line = br.readLine();
            if (RND_ID_STR.equals(line)) {
                Selection selection = Selection.RANDOM_IDENTIFIER;
                return selection;
            }
            Selection selection = Selection.ON;
            return selection;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Selection.NO_ESC;
    }

    public static boolean promptUser() {
        return !new ExecutionStatisticsCollector().escFileExists();
    }

    private static String getRandomIdentifier() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private static boolean isOptOut() {
        return false;
    }

    private static void submit(Map<String, String> parameters, boolean dontWaitForCompletion) {
        parameters.put("ts", Long.toString(System.currentTimeMillis()));
        parameters.put("optout", Boolean.toString(ExecutionStatisticsCollector.isOptOut()));
        try {
            URL url = new URL("https://" + (ExecutionStatisticsCollector.isOptOut() ? "esc02" : "esc01") + ".tlapl.us/?" + ExecutionStatisticsCollector.encode(parameters));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("HEAD");
            con.getResponseMessage();
            con.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String encode(Map<String, String> parameters) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer();
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            buf.append(URLEncoder.encode(key, "UTF-8"));
            buf.append("=");
            buf.append(URLEncoder.encode(value, "UTF-8"));
            buf.append(",");
        }
        return buf.toString().replaceFirst(",$", "");
    }

    public static void main(String[] args) {
        new ExecutionStatisticsCollector().collect(new HashMap<String, String>(), false);
    }

    public static enum Selection {
        ON,
        RANDOM_IDENTIFIER,
        NO_ESC;


        public String toString() {
            if (this == ON) {
                return ExecutionStatisticsCollector.getRandomIdentifier();
            }
            if (this == RANDOM_IDENTIFIER) {
                return ExecutionStatisticsCollector.RND_ID_STR;
            }
            return ExecutionStatisticsCollector.NO_ESC_STR;
        }
    }
}

