/*
 * Decompiled with CFR 0.152.
 */
package util;

import tlc2.output.MP;

public class Assert {
    public static void fail(String reason) throws RuntimeException {
        throw new TLCRuntimeException(reason);
    }

    public static void fail(int errorCode, String[] parameters) {
        throw new TLCRuntimeException(errorCode, parameters, MP.getMessage(errorCode, parameters));
    }

    public static void fail(int errorCode, String parameter) {
        throw new TLCRuntimeException(errorCode, new String[]{parameter}, MP.getMessage(errorCode, parameter));
    }

    public static void fail(int errorCode, Throwable cause) {
        throw new TLCRuntimeException(errorCode, MP.getMessage(errorCode, cause.getMessage()), cause);
    }

    public static void fail(int errorCode) {
        throw new TLCRuntimeException(errorCode, MP.getMessage(errorCode));
    }

    public static void check(boolean condition, int errorCode, String[] parameters) throws RuntimeException {
        if (!condition) {
            throw new TLCRuntimeException(errorCode, parameters, MP.getMessage(errorCode, parameters));
        }
    }

    public static void check(boolean condition, int errorCode, String parameter) throws RuntimeException {
        if (!condition) {
            throw new TLCRuntimeException(errorCode, new String[]{parameter}, MP.getMessage(errorCode, parameter));
        }
    }

    public static void check(boolean condition, int errorCode) throws RuntimeException {
        if (!condition) {
            throw new TLCRuntimeException(errorCode, MP.getMessage(errorCode));
        }
    }

    public static void check(boolean condition, String errorMsg) throws RuntimeException {
        if (!condition) {
            throw new TLCRuntimeException(errorMsg);
        }
    }

    public static class TLCRuntimeException
    extends RuntimeException {
        public final int errorCode;
        public String[] parameters = null;

        public TLCRuntimeException(String errorMsg) {
            super(errorMsg);
            this.errorCode = 1000;
        }

        public TLCRuntimeException(int errorCode, String message) {
            super(message);
            this.errorCode = errorCode;
        }

        public TLCRuntimeException(int errorCode, String message, Throwable cause) {
            super(message, cause);
            this.errorCode = errorCode;
        }

        public TLCRuntimeException(int errorCode, String[] parameters, String message) {
            this(errorCode, message);
            this.parameters = parameters;
        }
    }
}

