/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import tlc2.TLCGlobals;
import tlc2.tool.FingerprintException;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.EnumerableValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;

public class SetDiffValue
extends EnumerableValue
implements Enumerable {
    public final Value set1;
    public final Value set2;
    protected SetEnumValue diffSet;

    public SetDiffValue(Value set1, Value set2) {
        this.set1 = set1;
        this.set2 = set2;
        this.diffSet = null;
    }

    @Override
    public final byte getKind() {
        return 17;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            this.convertAndCache();
            return this.diffSet.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            this.convertAndCache();
            return this.diffSet.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            return this.set1.member(elem) && !this.set2.member(elem);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            if (this.set1.isFinite()) {
                return true;
            }
            if (!this.set2.isFinite()) {
                Assert.fail("Attempted to check if the set " + Values.ppr(this.toString()) + "is finite.");
            }
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT to the set " + Values.ppr(this.toString()) + ".");
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT to the set " + Values.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            this.convertAndCache();
            return this.diffSet.size();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        try {
            if (this.diffSet == null || this.diffSet == SetEnumValue.DummyEnum) {
                return this.set1.isNormalized();
            }
            return this.diffSet.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            if (this.diffSet == null || this.diffSet == SetEnumValue.DummyEnum) {
                this.set1.normalize();
                this.set2.normalize();
            } else {
                this.diffSet.normalize();
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            this.set1.deepNormalize();
            this.set2.deepNormalize();
            if (this.diffSet == null) {
                this.diffSet = SetEnumValue.DummyEnum;
            } else if (this.diffSet != SetEnumValue.DummyEnum) {
                this.diffSet.deepNormalize();
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            return this.set1.isDefined() && this.set2.isDefined();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return this.equals(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        this.diffSet.write(vos);
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.convertAndCache();
            return this.diffSet.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            this.convertAndCache();
            return this.diffSet.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void convertAndCache() {
        if (this.diffSet == null) {
            this.diffSet = (SetEnumValue)this.toSetEnum();
        } else if (this.diffSet == SetEnumValue.DummyEnum) {
            SetEnumValue val = null;
            SetDiffValue setDiffValue = this;
            synchronized (setDiffValue) {
                if (this.diffSet == SetEnumValue.DummyEnum) {
                    val = (SetEnumValue)this.toSetEnum();
                    val.deepNormalize();
                }
            }
            setDiffValue = this;
            synchronized (setDiffValue) {
                if (this.diffSet == SetEnumValue.DummyEnum) {
                    this.diffSet = val;
                }
            }
        }
    }

    @Override
    public final Value toSetEnum() {
        Value elem;
        if (this.diffSet != null && this.diffSet != SetEnumValue.DummyEnum) {
            return this.diffSet;
        }
        ValueVec vals = new ValueVec();
        ValueEnumeration Enum2 = this.elements();
        while ((elem = Enum2.nextElement()) != null) {
            vals.addElement(elem);
        }
        if (coverage) {
            this.cm.incSecondary(vals.size());
        }
        return new SetEnumValue(vals, this.set1.isNormalized(), this.cm);
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            block6: {
                try {
                    if (TLCGlobals.expand) {
                        Value val = this.toSetEnum();
                        return val.toString(sb, offset, swallow);
                    }
                }
                catch (Throwable e) {
                    if (swallow) break block6;
                    throw e;
                }
            }
            sb = this.set1.toString(sb, offset, swallow);
            sb = sb.append(" \\ ");
            sb = this.set2.toString(sb, offset, swallow);
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            if (this.diffSet == null || this.diffSet == SetEnumValue.DummyEnum) {
                return new Enumerator();
            }
            return this.diffSet.elements();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        ValueEnumeration enum1;

        public Enumerator() {
            if (SetDiffValue.this.set1 instanceof Enumerable) {
                this.enum1 = ((Enumerable)((Object)SetDiffValue.this.set1)).elements();
            } else {
                Assert.fail("Attempted to enumerate S \\ T when S:\n" + Values.ppr(SetDiffValue.this.set1.toString()) + "\nis not enumerable.");
            }
        }

        @Override
        public final void reset() {
            this.enum1.reset();
        }

        @Override
        public final Value nextElement() {
            Value elem = this.enum1.nextElement();
            while (elem != null) {
                if (Value.coverage) {
                    SetDiffValue.this.cm.incSecondary();
                }
                if (!SetDiffValue.this.set2.member(elem)) {
                    return elem;
                }
                elem = this.enum1.nextElement();
            }
            return null;
        }
    }
}

