/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import tla2sany.semantic.ExprOrOpArgNode;
import tlc2.output.MP;
import tlc2.tool.FingerprintException;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.IValue;
import tlc2.value.Values;
import tlc2.value.impl.Applicable;
import tlc2.value.impl.OpValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import util.Assert;
import util.WrongInvocationException;

public class EvaluatingValue
extends OpValue
implements Applicable {
    protected final MethodHandle mh;
    protected final Method md;
    protected final int minLevel;

    protected EvaluatingValue(MethodHandle mh, Method md, int minLevel) {
        this.mh = mh;
        this.md = md;
        this.minLevel = minLevel;
    }

    public EvaluatingValue(Method md, int minLevel) {
        this.md = md;
        this.minLevel = minLevel;
        try {
            this.mh = MethodHandles.publicLookup().unreflect(md).asFixedArity();
        }
        catch (IllegalAccessException e) {
            throw new Assert.TLCRuntimeException(2154, MP.getMessage(2154, new String[]{md.toString(), e.getMessage()}));
        }
    }

    @Override
    public Value eval(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        try {
            return this.mh.invoke(tool, args, c, s0, s1, control, cm);
        }
        catch (Throwable e) {
            Assert.fail(2154, new String[]{this.md.toString(), e.getMessage()});
            return null;
        }
    }

    @Override
    public final byte getKind() {
        return 12;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            Assert.fail("Attempted to compare operator " + this.toString() + " with value:\n" + obj == null ? "null" : Values.ppr(obj.toString()));
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            Assert.fail("Attempted to check equality of operator " + this.toString() + " with value:\n" + obj == null ? "null" : Values.ppr(obj.toString()));
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if the value:\n" + elem == null ? "null" : Values.ppr(elem.toString()) + "\nis an element of operator " + this.toString());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            Assert.fail("Attempted to check if the operator " + this.toString() + " is a finite set.");
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value apply(Value arg, int control) {
        try {
            throw new WrongInvocationException("It is a TLC bug: Should use the other apply method.");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value apply(Value[] args, int control) {
        try {
            throw new WrongInvocationException("It is a TLC bug: Should use the other apply method.");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value select(Value arg) {
        try {
            throw new WrongInvocationException("It is a TLC bug: Attempted to call MethodValue.select().");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            Assert.fail("Attempted to appy EXCEPT construct to the operator " + this.toString() + ".");
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            Assert.fail("Attempted to apply EXCEPT construct to the operator " + this.toString() + ".");
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value getDomain() {
        try {
            Assert.fail("Attempted to compute the domain of the operator " + this.toString() + ".");
            return SetEnumValue.EmptySet;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            Assert.fail("Attempted to compute the number of elements in the operator " + this.toString() + ".");
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        try {
            throw new WrongInvocationException("It is a TLC bug: Attempted to normalize an operator.");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            throw new WrongInvocationException("It is a TLC bug: Attempted to normalize an operator.");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            throw new WrongInvocationException("It is a TLC bug: Attempted to initialize an operator.");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean ignored) {
        try {
            return sb.append("<Java Method: " + this.md + ">");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public int getMinLevel() {
        return this.minLevel;
    }
}

