/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.util.List;
import tlc2.tool.FingerprintException;
import tlc2.value.RandomEnumerableValues;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;

public abstract class EnumerableValue
extends Value
implements Enumerable {
    @Override
    public Value isSubsetEq(Value other) {
        try {
            Value elem;
            ValueEnumeration Enum2 = this.elements();
            while ((elem = Enum2.nextElement()) != null) {
                if (other.member(elem)) continue;
                return BoolValue.ValFalse;
            }
            return BoolValue.ValTrue;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public EnumerableValue getRandomSubset(int kOutOfN) {
        return ((SetEnumValue)this.toSetEnum()).getRandomSubset(kOutOfN);
    }

    @Override
    public ValueEnumeration elements(Enumerable.Ordering ordering) {
        Value enumerated;
        if (ordering == Enumerable.Ordering.NORMALIZED && (enumerated = this.toSetEnum()) != null) {
            return ((Enumerable)((Object)enumerated.normalize())).elements();
        }
        return this.elements();
    }

    @Override
    public ValueEnumeration elements(int k) {
        final List<Value> values = this.elements().all();
        return new SubsetEnumerator(k){

            @Override
            public Value nextElement() {
                if (!this.hasNext()) {
                    return null;
                }
                return (Value)values.get(this.nextIndex());
            }
        };
    }

    abstract class SubsetEnumerator
    implements ValueEnumeration {
        protected final long x;
        protected final int a;
        protected final int n;
        protected final int k;
        protected int i;

        public SubsetEnumerator(int k) {
            this(k, this$0.size());
        }

        public SubsetEnumerator(int k, int n) {
            this.n = n;
            assert (n < Integer.MAX_VALUE);
            long l = this.x = n < 191 ? 191L : Integer.MAX_VALUE;
            if (n > 0) {
                this.k = k;
                this.a = RandomEnumerableValues.get().nextInt(n);
            } else {
                this.k = 0;
                this.a = 0;
            }
        }

        @Override
        public void reset() {
            this.i = 0;
        }

        public boolean hasNext() {
            return this.i < this.k;
        }

        public int nextIndex() {
            if (this.n <= 0) {
                ++this.i;
                return 0;
            }
            int index = (int)((this.x * (long)this.i++ + (long)this.a) % (long)this.n);
            assert (0 <= index && index < this.n);
            return index;
        }

        @Override
        public abstract Value nextElement();
    }
}

