/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.impl;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.APSubstInNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LabelNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.OpDefOrDeclNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.BuiltInOPs;
import tlc2.tool.EvalControl;
import tlc2.tool.EvalException;
import tlc2.tool.IActionItemList;
import tlc2.tool.IContextEnumerator;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.IStateFunctor;
import tlc2.tool.ITool;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateFun;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.TLCStateMut;
import tlc2.tool.ToolGlobals;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.ActionItemList;
import tlc2.tool.impl.ContextEnumerator;
import tlc2.tool.impl.Spec;
import tlc2.tool.impl.WorkerValue;
import tlc2.util.Context;
import tlc2.util.ExpectInlined;
import tlc2.util.IdThread;
import tlc2.util.Vect;
import tlc2.value.IFcnLambdaValue;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.ValueConstants;
import tlc2.value.Values;
import tlc2.value.impl.Applicable;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.EvaluatingValue;
import tlc2.value.impl.FcnLambdaValue;
import tlc2.value.impl.FcnParams;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.LazyValue;
import tlc2.value.impl.MVPerm;
import tlc2.value.impl.MVPerms;
import tlc2.value.impl.MethodValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.OpLambdaValue;
import tlc2.value.impl.OpValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.Reducible;
import tlc2.value.impl.SetCapValue;
import tlc2.value.impl.SetCupValue;
import tlc2.value.impl.SetDiffValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.SetOfFcnsValue;
import tlc2.value.impl.SetOfRcdsValue;
import tlc2.value.impl.SetOfTuplesValue;
import tlc2.value.impl.SetPredValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.SubsetValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.UnionValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;
import util.FilenameToStream;
import util.UniqueString;

public abstract class Tool
extends Spec
implements ValueConstants,
ToolGlobals,
ITool {
    public static final Value[] EmptyArgs = new Value[0];
    protected final Action[] actions;
    private Vect<Action> actionVec = new Vect(10);

    public Tool(String specFile, String configFile) {
        this(new File(specFile), specFile, configFile, null);
    }

    public Tool(String specFile, String configFile, FilenameToStream resolver) {
        this(new File(specFile), specFile, configFile, resolver);
    }

    private Tool(File specDir, String specFile, String configFile, FilenameToStream resolver) {
        this(specDir.isAbsolute() ? specDir.getParent() : "", specFile, configFile, resolver);
    }

    public Tool(String specDir, String specFile, String configFile, FilenameToStream resolver) {
        super(specDir, specFile, configFile, resolver);
        TLCStateMut.setTool(this);
        Action next = this.getNextStateSpec();
        if (next == null) {
            this.actions = new Action[0];
        } else {
            this.getActions(next);
            int sz = this.actionVec.size();
            this.actions = new Action[sz];
            for (int i = 0; i < sz; ++i) {
                this.actions[i] = this.actionVec.elementAt(i);
            }
        }
    }

    Tool(Tool other) {
        super(other);
        this.actions = other.actions;
        this.actionVec = other.actionVec;
    }

    @Override
    public final Action[] getActions() {
        return this.actions;
    }

    private final void getActions(Action next) {
        this.getActions(next.pred, next.con, next.getOpDef(), next.cm);
    }

    private final void getActions(SemanticNode next, Context con, OpDefNode opDefNode, CostModel cm) {
        switch (next.getKind()) {
            case 9: {
                OpApplNode next1 = (OpApplNode)next;
                this.getActionsAppl(next1, con, opDefNode, cm);
                return;
            }
            case 10: {
                LetInNode next1 = (LetInNode)next;
                this.getActions(next1.getBody(), con, opDefNode, cm);
                return;
            }
            case 13: {
                SubstInNode next1 = (SubstInNode)next;
                Subst[] substs = next1.getSubsts();
                if (substs.length == 0) {
                    this.getActions(next1.getBody(), con, opDefNode, cm);
                } else {
                    Action action = new Action((SemanticNode)next1, con, opDefNode);
                    this.actionVec.addElement(action);
                }
                return;
            }
            case 30: {
                APSubstInNode next1 = (APSubstInNode)next;
                Subst[] substs = next1.getSubsts();
                if (substs.length == 0) {
                    this.getActions(next1.getBody(), con, opDefNode, cm);
                } else {
                    Action action = new Action((SemanticNode)next1, con, opDefNode);
                    this.actionVec.addElement(action);
                }
                return;
            }
            case 29: {
                LabelNode next1 = (LabelNode)next;
                this.getActions(next1.getBody(), con, opDefNode, cm);
                return;
            }
        }
        Assert.fail("The next state relation is not a boolean expression.\n" + next);
    }

    private final void getActionsAppl(OpApplNode next, Context con, OpDefNode actionName, CostModel cm) {
        ExprOrOpArgNode[] args = next.getArgs();
        SymbolNode opNode = next.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            OpDefNode opDef;
            Object val = this.lookup(opNode, con, false);
            if (val instanceof OpDefNode && (opcode = BuiltInOPs.getOpCode((opDef = (OpDefNode)val).getName())) == 0) {
                try {
                    FormalParamNode[] formals = opDef.getParams();
                    int alen = args.length;
                    int argLevel = 0;
                    for (int i = 0; i < alen && (argLevel = args[i].getLevel()) == 0; ++i) {
                    }
                    if (argLevel == 0) {
                        Context con1 = con;
                        for (int i = 0; i < alen; ++i) {
                            IValue aval = this.eval(args[i], con, TLCState.Empty, cm);
                            con1 = con1.cons(formals[i], aval);
                        }
                        this.getActions(opDef.getBody(), con1, opDef, cm);
                        return;
                    }
                }
                catch (Throwable formals) {
                    // empty catch block
                }
            }
            if (opcode == 0) {
                Action action = new Action((SemanticNode)next, con, (OpDefNode)opNode);
                this.actionVec.addElement(action);
                return;
            }
        }
        switch (opcode) {
            case 2: {
                int cnt = this.actionVec.size();
                try {
                    Context econ;
                    ContextEnumerator Enum2 = this.contexts(next, con, TLCState.Empty, TLCState.Empty, 0, cm);
                    while ((econ = Enum2.nextElement()) != null) {
                        this.getActions(args[0], econ, actionName, cm);
                    }
                }
                catch (Throwable e) {
                    Action action = new Action((SemanticNode)next, con, actionName);
                    this.actionVec.removeAll(cnt);
                    this.actionVec.addElement(action);
                }
                return;
            }
            case 7: 
            case 37: {
                for (int i = 0; i < args.length; ++i) {
                    this.getActions(args[i], con, actionName, cm);
                }
                return;
            }
        }
        Action action = new Action((SemanticNode)next, con, actionName);
        this.actionVec.addElement(action);
    }

    @Override
    public final StateVec getInitStates() {
        StateVec initStates = new StateVec(0);
        this.getInitStates(initStates);
        return initStates;
    }

    @Override
    public final void getInitStates(IStateFunctor functor) {
        Vect<Action> init = this.getInitStateSpec();
        ActionItemList acts = ActionItemList.Empty;
        for (int i = init.size() - 1; i > 0; --i) {
            Action elem = init.elementAt(i);
            acts = acts.cons(elem, -1);
        }
        if (init.size() != 0) {
            Action elem = init.elementAt(0);
            TLCState ps = TLCState.Empty.createEmpty();
            this.getInitStates(elem.pred, acts, elem.con, ps, functor, elem.cm);
        }
    }

    @Override
    public final TLCState makeState(SemanticNode pred) {
        TLCState state;
        ActionItemList acts = ActionItemList.Empty;
        TLCState ps = TLCState.Empty.createEmpty();
        StateVec states = new StateVec(0);
        this.getInitStates(pred, acts, Context.Empty, ps, states, acts.cm);
        if (states.size() != 1) {
            Assert.fail("The predicate does not specify a unique state." + pred);
        }
        if (!this.isGoodState(state = states.elementAt(0))) {
            Assert.fail("The state specified by the predicate is not complete." + pred);
        }
        return state;
    }

    protected void getInitStates(SemanticNode init, ActionItemList acts, Context c, TLCState ps, IStateFunctor states, CostModel cm) {
        switch (init.getKind()) {
            case 9: {
                OpApplNode init1 = (OpApplNode)init;
                this.getInitStatesAppl(init1, acts, c, ps, states, cm);
                return;
            }
            case 10: {
                LetInNode init1 = (LetInNode)init;
                this.getInitStates(init1.getBody(), acts, c, ps, states, cm);
                return;
            }
            case 13: {
                SubstInNode init1 = (SubstInNode)init;
                Subst[] subs = init1.getSubsts();
                Context c1 = c;
                for (int i = 0; i < subs.length; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false, coverage ? sub.getCM() : cm, toolId));
                }
                this.getInitStates(init1.getBody(), acts, c1, ps, states, cm);
                return;
            }
            case 30: {
                APSubstInNode init1 = (APSubstInNode)init;
                Subst[] subs = init1.getSubsts();
                Context c1 = c;
                for (int i = 0; i < subs.length; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false, cm, toolId));
                }
                this.getInitStates(init1.getBody(), acts, c1, ps, states, cm);
                return;
            }
            case 29: {
                LabelNode init1 = (LabelNode)init;
                this.getInitStates(init1.getBody(), acts, c, ps, states, cm);
                return;
            }
        }
        Assert.fail("The init state relation is not a boolean expression.\n" + init);
    }

    private final void getInitStates(ActionItemList acts, TLCState ps, IStateFunctor states, CostModel cm) {
        if (acts.isEmpty()) {
            if (coverage) {
                cm.incInvocations();
                cm.getRoot().incInvocations();
            }
            states.addElement(ps.copy());
            return;
        }
        if (ps.allAssigned()) {
            while (!acts.isEmpty()) {
                Value bval = this.eval(acts.carPred(), acts.carContext(), ps, TLCState.Empty, 8, acts.cm);
                if (!(bval instanceof BoolValue)) {
                    Assert.fail(2247, new String[]{"initial states", "boolean", bval.toString(), acts.pred.toString()});
                }
                if (!((BoolValue)bval).val) {
                    if (coverage) {
                        cm.getRoot().incSecondary();
                    }
                    return;
                }
                acts = acts.cdr();
            }
            if (coverage) {
                cm.incInvocations();
                cm.getRoot().incInvocations();
            }
            states.addElement(ps.copy());
            return;
        }
        ActionItemList acts1 = acts.cdr();
        this.getInitStates(acts.carPred(), acts1, acts.carContext(), ps, states, acts.cm);
    }

    protected void getInitStatesAppl(OpApplNode init, ActionItemList acts, Context c, TLCState ps, IStateFunctor states, CostModel cm) {
        Object bval;
        if (coverage) {
            cm = cm.get(init);
        }
        ExprOrOpArgNode[] args = init.getArgs();
        int alen = args.length;
        SymbolNode opNode = init.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            SymbolNode opDef;
            Object val = this.lookup(opNode, c, ps, false);
            if (val instanceof OpDefNode && (opcode = BuiltInOPs.getOpCode((opDef = (OpDefNode)val).getName())) == 0) {
                Context c1 = this.getOpContext((OpDefNode)opDef, args, c, true, cm, toolId);
                this.getInitStates(((OpDefNode)opDef).getBody(), acts, c1, ps, states, cm);
                return;
            }
            if (val instanceof ThmOrAssumpDefNode) {
                opDef = (ThmOrAssumpDefNode)val;
                opcode = BuiltInOPs.getOpCode(opDef.getName());
                Context c1 = this.getOpContext((ThmOrAssumpDefNode)opDef, args, c, true);
                this.getInitStates(((ThmOrAssumpDefNode)opDef).getBody(), acts, c1, ps, states, cm);
                return;
            }
            if (val instanceof LazyValue) {
                LazyValue lv = (LazyValue)val;
                if (lv.getValue() == null || lv.isUncachable()) {
                    this.getInitStates(lv.expr, acts, lv.con, ps, states, cm);
                    return;
                }
                val = lv.getValue();
            }
            bval = val;
            if (alen == 0) {
                if (val instanceof MethodValue) {
                    bval = ((MethodValue)val).apply(EmptyArgs, 8);
                } else if (val instanceof EvaluatingValue) {
                    bval = ((EvaluatingValue)val).eval(this, args, c, ps, TLCState.Empty, 8, cm);
                }
            } else if (val instanceof OpValue) {
                bval = ((OpValue)val).eval(this, args, c, ps, TLCState.Empty, 8, cm);
            }
            if (opcode == 0) {
                if (!(bval instanceof BoolValue)) {
                    Assert.fail(2247, new String[]{"initial states", "boolean", bval.toString(), init.toString()});
                }
                if (((BoolValue)bval).val) {
                    this.getInitStates(acts, ps, states, cm);
                }
                return;
            }
        }
        switch (opcode) {
            case 7: 
            case 37: {
                for (int i = 0; i < alen; ++i) {
                    this.getInitStates(args[i], acts, c, ps, states, cm);
                }
                return;
            }
            case 6: 
            case 36: {
                for (int i = alen - 1; i > 0; --i) {
                    acts = (ActionItemList)acts.cons(args[i], c, cm, i);
                }
                this.getInitStates(args[0], acts, c, ps, states, cm);
                return;
            }
            case 2: {
                Context c1;
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum2 = this.contexts(init, c, ps, TLCState.Empty, 8, cm);
                while ((c1 = Enum2.nextElement()) != null) {
                    this.getInitStates(body, acts, c1, ps, states, cm);
                }
                return;
            }
            case 3: {
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum2 = this.contexts(init, c, ps, TLCState.Empty, 8, cm);
                Context c1 = Enum2.nextElement();
                if (c1 == null) {
                    this.getInitStates(acts, ps, states, cm);
                } else {
                    Context c2;
                    ActionItemList acts1 = acts;
                    while ((c2 = Enum2.nextElement()) != null) {
                        acts1 = (ActionItemList)acts1.cons(body, c2, cm, -1);
                    }
                    this.getInitStates(body, acts1, c1, ps, states, cm);
                }
                return;
            }
            case 11: {
                Value guard = this.eval(args[0], c, ps, TLCState.Empty, 8, cm);
                if (!(guard instanceof BoolValue)) {
                    Assert.fail("In computing initial states, a non-boolean expression (" + guard.getKindString() + ") was used as the condition of an IF.\n" + init);
                }
                int idx = ((BoolValue)guard).val ? 1 : 2;
                this.getInitStates(args[idx], acts, c, ps, states, cm);
                return;
            }
            case 4: {
                ExprOrOpArgNode other = null;
                for (int i = 0; i < alen; ++i) {
                    OpApplNode pair2 = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pairArgs = pair2.getArgs();
                    if (pairArgs[0] == null) {
                        other = pairArgs[1];
                        continue;
                    }
                    Value bval2 = this.eval(pairArgs[0], c, ps, TLCState.Empty, 8, cm);
                    if (!(bval2 instanceof BoolValue)) {
                        Assert.fail("In computing initial states, a non-boolean expression (" + bval2.getKindString() + ") was used as a guard condition of a CASE.\n" + pairArgs[1]);
                    }
                    if (!((BoolValue)bval2).val) continue;
                    this.getInitStates(pairArgs[1], acts, c, ps, states, cm);
                    return;
                }
                if (other == null) {
                    Assert.fail("In computing initial states, TLC encountered a CASE with no conditions true.\n" + init);
                }
                this.getInitStates(other, acts, c, ps, states, cm);
                return;
            }
            case 9: {
                Applicable fcn;
                Value fval = this.eval(args[0], c, ps, TLCState.Empty, 8, cm);
                if (fval instanceof FcnLambdaValue) {
                    fcn = (FcnLambdaValue)fval;
                    if (((FcnLambdaValue)fcn).fcnRcd == null) {
                        Context c1 = this.getFcnContext((IFcnLambdaValue)((Object)fcn), args, c, ps, TLCState.Empty, 8, cm);
                        this.getInitStates(((FcnLambdaValue)fcn).body, acts, c1, ps, states, cm);
                        return;
                    }
                    fval = ((FcnLambdaValue)fcn).fcnRcd;
                } else if (!(fval instanceof Applicable)) {
                    Assert.fail("In computing initial states, a non-function (" + fval.getKindString() + ") was applied as a function.\n" + init);
                }
                fcn = (Applicable)((Object)fval);
                Value argVal = this.eval(args[1], c, ps, TLCState.Empty, 8, cm);
                Value bval3 = fcn.apply(argVal, 8);
                if (!(bval3 instanceof BoolValue)) {
                    Assert.fail(2248, new String[]{"initial states", "boolean", init.toString()});
                }
                if (((BoolValue)bval3).val) {
                    this.getInitStates(acts, ps, states, cm);
                }
                return;
            }
            case 35: {
                UniqueString varName;
                SymbolNode var = this.getVar(args[0], c, false, toolId);
                if (var == null || var.getName().getVarLoc() < 0) {
                    bval = this.eval(init, c, ps, TLCState.Empty, 8, cm);
                    if (!((BoolValue)bval).val) {
                        return;
                    }
                } else {
                    varName = var.getName();
                    IValue lval = ps.lookup(varName);
                    Value rval = this.eval(args[1], c, ps, TLCState.Empty, 8, cm);
                    if (lval == null) {
                        ps = ps.bind(varName, (IValue)rval);
                        this.getInitStates(acts, ps, states, cm);
                        ps.unbind(varName);
                        return;
                    }
                    if (!lval.equals(rval)) {
                        return;
                    }
                }
                this.getInitStates(acts, ps, states, cm);
                return;
            }
            case 42: {
                UniqueString varName;
                SymbolNode var = this.getVar(args[0], c, false, toolId);
                if (var == null || var.getName().getVarLoc() < 0) {
                    bval = this.eval(init, c, ps, TLCState.Empty, 8, cm);
                    if (!((BoolValue)bval).val) {
                        return;
                    }
                } else {
                    varName = var.getName();
                    Value lval = (Value)ps.lookup(varName);
                    Value rval = this.eval(args[1], c, ps, TLCState.Empty, 8, cm);
                    if (lval == null) {
                        Value elem;
                        if (!(rval instanceof Enumerable)) {
                            Assert.fail("In computing initial states, the right side of \\IN is not enumerable.\n" + init);
                        }
                        ValueEnumeration Enum3 = ((Enumerable)((Object)rval)).elements();
                        while ((elem = Enum3.nextElement()) != null) {
                            ps.bind(varName, (IValue)elem);
                            this.getInitStates(acts, ps, states, cm);
                            ps.unbind(varName);
                        }
                        return;
                    }
                    if (!rval.member(lval)) {
                        return;
                    }
                }
                this.getInitStates(acts, ps, states, cm);
                return;
            }
            case 38: {
                Value lval = this.eval(args[0], c, ps, TLCState.Empty, 8, cm);
                if (!(lval instanceof BoolValue)) {
                    Assert.fail("In computing initial states of a predicate of form P => Q, P was " + lval.getKindString() + "\n." + init);
                }
                if (((BoolValue)lval).val) {
                    this.getInitStates(args[1], acts, c, ps, states, cm);
                } else {
                    this.getInitStates(acts, ps, states, cm);
                }
                return;
            }
            case 46: {
                this.getInitStates(args[0], acts, c, ps, states, cm);
                return;
            }
        }
        Value bval4 = this.eval(init, c, ps, TLCState.Empty, 8, cm);
        if (!(bval4 instanceof BoolValue)) {
            Assert.fail("In computing initial states, TLC expected a boolean expression,\nbut instead found " + bval4 + ".\n" + init);
        }
        if (((BoolValue)bval4).val) {
            this.getInitStates(acts, ps, states, cm);
        }
    }

    @Override
    public final StateVec getNextStates(Action action, TLCState state) {
        return this.getNextStates(action, action.con, state);
    }

    public final StateVec getNextStates(Action action, Context ctx, TLCState state) {
        ActionItemList acts = ActionItemList.Empty;
        TLCState s1 = TLCState.Empty.createEmpty();
        StateVec nss = new StateVec(0);
        this.getNextStates(action, action.pred, acts, ctx, state, s1, nss, action.cm);
        if (coverage) {
            action.cm.incInvocations(nss.size());
        }
        return nss;
    }

    @Override
    public final boolean getNextStates(INextStateFunctor functor, TLCState state) {
        for (int i = 0; i < this.actions.length; ++i) {
            Action action = this.actions[i];
            this.getNextStates(action, action.pred, ActionItemList.Empty, action.con, state, TLCState.Empty.createEmpty(), functor, action.cm);
        }
        return false;
    }

    protected abstract TLCState getNextStates(Action var1, SemanticNode var2, ActionItemList var3, Context var4, TLCState var5, TLCState var6, INextStateFunctor var7, CostModel var8);

    protected final TLCState getNextStatesImpl(Action action, SemanticNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        switch (pred.getKind()) {
            case 9: {
                OpApplNode pred1 = (OpApplNode)pred;
                if (coverage) {
                    cm = cm.get(pred);
                }
                return this.getNextStatesAppl(action, pred1, acts, c, s0, s1, nss, cm);
            }
            case 10: {
                LetInNode pred1 = (LetInNode)pred;
                return this.getNextStates(action, pred1.getBody(), acts, c, s0, s1, nss, cm);
            }
            case 13: {
                return this.getNextStatesImplSubstInKind(action, (SubstInNode)pred, acts, c, s0, s1, nss, cm);
            }
            case 30: {
                return this.getNextStatesImplApSubstInKind(action, (APSubstInNode)pred, acts, c, s0, s1, nss, cm);
            }
            case 29: {
                LabelNode pred1 = (LabelNode)pred;
                return this.getNextStates(action, pred1.getBody(), acts, c, s0, s1, nss, cm);
            }
        }
        Assert.fail("The next state relation is not a boolean expression.\n" + pred);
        return s1;
    }

    @ExpectInlined
    private final TLCState getNextStatesImplSubstInKind(Action action, SubstInNode pred1, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        Subst[] subs = pred1.getSubsts();
        int slen = subs.length;
        Context c1 = c;
        for (int i = 0; i < slen; ++i) {
            Subst sub = subs[i];
            c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false, coverage ? sub.getCM() : cm, toolId));
        }
        return this.getNextStates(action, pred1.getBody(), acts, c1, s0, s1, nss, cm);
    }

    @ExpectInlined
    private final TLCState getNextStatesImplApSubstInKind(Action action, APSubstInNode pred1, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        Subst[] subs = pred1.getSubsts();
        int slen = subs.length;
        Context c1 = c;
        for (int i = 0; i < slen; ++i) {
            Subst sub = subs[i];
            c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false, cm, toolId));
        }
        return this.getNextStates(action, pred1.getBody(), acts, c1, s0, s1, nss, cm);
    }

    @ExpectInlined
    private final TLCState getNextStates(Action action, ActionItemList acts, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        TLCState copy = this.getNextStates0(action, acts, s0, s1, nss, cm);
        if (coverage && copy != s1) {
            cm.incInvocations();
        }
        return copy;
    }

    @ExpectInlined
    private final TLCState getNextStates0(Action action, ActionItemList acts, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        IValue v2;
        if (acts.isEmpty()) {
            nss.addElement(s0, action, s1);
            return s1.copy();
        }
        if (s1.allAssigned()) {
            return this.getNextStatesAllAssigned(action, acts, s0, s1, nss, cm);
        }
        int kind = acts.carKind();
        SemanticNode pred = acts.carPred();
        Context c = acts.carContext();
        ActionItemList acts1 = acts.cdr();
        cm = acts.cm;
        if (kind > 0) {
            return this.getNextStates(action, pred, acts1, c, s0, s1, nss, cm);
        }
        if (kind == -1) {
            return this.getNextStates(action, pred, acts1, c, s0, s1, nss, cm);
        }
        if (kind == -2) {
            return this.processUnchanged(action, pred, acts1, c, s0, s1, nss, cm);
        }
        IValue v1 = this.eval(pred, c, s0, cm);
        if (!v1.equals(v2 = this.eval(pred, c, s1, cm))) {
            if (coverage) {
                return this.getNextStates(action, acts1, s0, s1, nss, cm);
            }
            return this.getNextStates0(action, acts1, s0, s1, nss, cm);
        }
        return s1;
    }

    private final TLCState getNextStatesAllAssigned(Action action, ActionItemList acts, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        int kind = acts.carKind();
        SemanticNode pred = acts.carPred();
        Context c = acts.carContext();
        CostModel cm2 = acts.cm;
        while (!acts.isEmpty()) {
            if (kind > 0 || kind == -1) {
                Value bval = this.eval(pred, c, s0, s1, 0, cm2);
                if (!(bval instanceof BoolValue)) {
                    Assert.fail(2247, new String[]{"next states", "boolean", bval.toString(), acts.pred.toString()});
                }
                if (!((BoolValue)bval).val) {
                    return s1;
                }
            } else {
                IValue v2;
                if (kind == -2) {
                    return this.processUnchanged(action, pred, acts.cdr(), c, s0, s1, nss, cm2);
                }
                IValue v1 = this.eval(pred, c, s0, cm2);
                if (v1.equals(v2 = this.eval(pred, c, s1, cm2))) {
                    return s1;
                }
            }
            acts = acts.cdr();
            pred = acts.carPred();
            c = acts.carContext();
            kind = acts.carKind();
            cm2 = acts.cm;
        }
        nss.addElement(s0, action, s1);
        return s1.copy();
    }

    @ExpectInlined
    protected abstract TLCState getNextStatesAppl(Action var1, OpApplNode var2, ActionItemList var3, Context var4, TLCState var5, TLCState var6, INextStateFunctor var7, CostModel var8);

    protected final TLCState getNextStatesApplImpl(Action action, OpApplNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        ExprOrOpArgNode[] args = pred.getArgs();
        int alen = args.length;
        SymbolNode opNode = pred.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            SymbolNode opDef;
            Object val = this.lookup(opNode, c, s0, false);
            if (val instanceof OpDefNode && (opcode = BuiltInOPs.getOpCode((opDef = (OpDefNode)val).getName())) == 0) {
                return this.getNextStates(action, ((OpDefNode)opDef).getBody(), acts, this.getOpContext((OpDefNode)opDef, args, c, true, cm, toolId), s0, s1, nss, cm);
            }
            if (val instanceof ThmOrAssumpDefNode) {
                opDef = (ThmOrAssumpDefNode)val;
                return this.getNextStates(action, ((ThmOrAssumpDefNode)opDef).getBody(), acts, this.getOpContext((ThmOrAssumpDefNode)opDef, args, c, true), s0, s1, nss, cm);
            }
            if (val instanceof LazyValue) {
                LazyValue lv = (LazyValue)val;
                if (lv.getValue() == null || lv.isUncachable()) {
                    return this.getNextStates(action, lv.expr, acts, lv.con, s0, s1, nss, lv.cm);
                }
                val = lv.getValue();
            }
            Object bval = this.getNextStatesApplEvalAppl(alen, args, c, s0, s1, cm, val);
            if (opcode == 0) {
                return this.getNextStatesApplUsrDefOp(action, pred, acts, s0, s1, nss, cm, bval);
            }
        }
        return this.getNextStatesApplSwitch(action, pred, acts, c, s0, s1, nss, cm, args, alen, opcode);
    }

    private final Object getNextStatesApplEvalAppl(int alen, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, CostModel cm, Object val) {
        if (alen == 0) {
            if (val instanceof MethodValue) {
                return ((MethodValue)val).apply(EmptyArgs, 0);
            }
            if (val instanceof EvaluatingValue) {
                return ((EvaluatingValue)val).eval(this, args, c, s0, s1, 0, cm);
            }
        } else if (val instanceof OpValue) {
            return ((OpValue)val).eval(this, args, c, s0, s1, 0, cm);
        }
        return val;
    }

    private final TLCState getNextStatesApplUsrDefOp(Action action, OpApplNode pred, ActionItemList acts, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm, Object bval) {
        if (!(bval instanceof BoolValue)) {
            Assert.fail(2247, new String[]{"next states", "boolean", bval.toString(), pred.toString()});
        }
        if (((BoolValue)bval).val) {
            if (coverage) {
                return this.getNextStates(action, acts, s0, s1, nss, cm);
            }
            return this.getNextStates0(action, acts, s0, s1, nss, cm);
        }
        return s1;
    }

    private final TLCState getNextStatesApplSwitch(Action action, OpApplNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm, ExprOrOpArgNode[] args, int alen, int opcode) {
        TLCState resState = s1;
        switch (opcode) {
            case 6: 
            case 36: {
                ActionItemList acts1 = acts;
                for (int i = alen - 1; i > 0; --i) {
                    acts1 = (ActionItemList)acts1.cons(args[i], c, cm, i);
                }
                return this.getNextStates(action, args[0], acts1, c, s0, s1, nss, cm);
            }
            case 7: 
            case 37: {
                for (int i = 0; i < alen; ++i) {
                    resState = this.getNextStates(action, args[i], acts, c, s0, resState, nss, cm);
                }
                return resState;
            }
            case 2: {
                Context c1;
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum2 = this.contexts(pred, c, s0, s1, 0, cm);
                while ((c1 = Enum2.nextElement()) != null) {
                    resState = this.getNextStates(action, body, acts, c1, s0, resState, nss, cm);
                }
                return resState;
            }
            case 3: {
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum3 = this.contexts(pred, c, s0, s1, 0, cm);
                Context c1 = Enum3.nextElement();
                if (c1 == null) {
                    resState = this.getNextStates(action, acts, s0, s1, nss, cm);
                } else {
                    Context c2;
                    ActionItemList acts1 = acts;
                    while ((c2 = Enum3.nextElement()) != null) {
                        acts1 = (ActionItemList)acts1.cons(body, c2, cm, -1);
                    }
                    resState = this.getNextStates(action, body, acts1, c1, s0, s1, nss, cm);
                }
                return resState;
            }
            case 9: {
                Value argVal;
                Value bval;
                Applicable fcn;
                Value fval = this.eval(args[0], c, s0, s1, 1, cm);
                if (fval instanceof FcnLambdaValue) {
                    fcn = (FcnLambdaValue)fval;
                    if (((FcnLambdaValue)fcn).fcnRcd == null) {
                        Context c1 = this.getFcnContext((IFcnLambdaValue)((Object)fcn), args, c, s0, s1, 0, cm);
                        return this.getNextStates(action, ((FcnLambdaValue)fcn).body, acts, c1, s0, s1, nss, ((FcnLambdaValue)fcn).cm);
                    }
                    fval = ((FcnLambdaValue)fcn).fcnRcd;
                }
                if (!(fval instanceof Applicable)) {
                    Assert.fail("In computing next states, a non-function (" + fval.getKindString() + ") was applied as a function.\n" + pred);
                }
                if (!((bval = (fcn = (Applicable)((Object)fval)).apply(argVal = this.eval(args[1], c, s0, s1, 0, cm), 0)) instanceof BoolValue)) {
                    Assert.fail(2248, new String[]{"next states", "boolean", pred.toString()});
                }
                if (((BoolValue)bval).val) {
                    return this.getNextStates(action, acts, s0, s1, nss, cm);
                }
                return resState;
            }
            case 50: {
                ActionItemList acts1 = (ActionItemList)acts.cons(args[1], c, cm, -3);
                return this.getNextStates(action, args[0], acts1, c, s0, s1, nss, cm);
            }
            case 51: {
                resState = this.getNextStates(action, args[0], acts, c, s0, resState, nss, cm);
                return this.processUnchanged(action, args[1], acts, c, s0, resState, nss, cm);
            }
            case 11: {
                Value guard = this.eval(args[0], c, s0, s1, 0, cm);
                if (!(guard instanceof BoolValue)) {
                    Assert.fail("In computing next states, a non-boolean expression (" + guard.getKindString() + ") was used as the condition of an IF." + pred);
                }
                if (((BoolValue)guard).val) {
                    return this.getNextStates(action, args[1], acts, c, s0, s1, nss, cm);
                }
                return this.getNextStates(action, args[2], acts, c, s0, s1, nss, cm);
            }
            case 4: {
                ExprOrOpArgNode other = null;
                for (int i = 0; i < alen; ++i) {
                    OpApplNode pair2 = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pairArgs = pair2.getArgs();
                    if (pairArgs[0] == null) {
                        other = pairArgs[1];
                        continue;
                    }
                    Value bval = this.eval(pairArgs[0], c, s0, s1, 0, coverage ? cm.get(args[i]) : cm);
                    if (!(bval instanceof BoolValue)) {
                        Assert.fail("In computing next states, a non-boolean expression (" + bval.getKindString() + ") was used as a guard condition of a CASE.\n" + pairArgs[1]);
                    }
                    if (!((BoolValue)bval).val) continue;
                    return this.getNextStates(action, pairArgs[1], acts, c, s0, s1, nss, coverage ? cm.get(args[i]) : cm);
                }
                if (other == null) {
                    Assert.fail("In computing next states, TLC encountered a CASE with no conditions true.\n" + pred);
                }
                return this.getNextStates(action, other, acts, c, s0, s1, nss, coverage ? cm.get(args[alen - 1]) : cm);
            }
            case 35: {
                SymbolNode var = this.getPrimedVar(args[0], c, false);
                if (var == null) {
                    Value bval = this.eval(pred, c, s0, s1, 0, cm);
                    if (!((BoolValue)bval).val) {
                        return resState;
                    }
                } else {
                    UniqueString varName = var.getName();
                    IValue lval = s1.lookup(varName);
                    Value rval = this.eval(args[1], c, s0, s1, 0, cm);
                    if (lval == null) {
                        resState.bind(varName, (IValue)rval);
                        resState = this.getNextStates(action, acts, s0, resState, nss, cm);
                        resState.unbind(varName);
                        return resState;
                    }
                    if (!lval.equals(rval)) {
                        return resState;
                    }
                }
                return this.getNextStates(action, acts, s0, s1, nss, cm);
            }
            case 42: {
                SymbolNode var = this.getPrimedVar(args[0], c, false);
                if (var == null) {
                    Value bval = this.eval(pred, c, s0, s1, 0, cm);
                    if (!((BoolValue)bval).val) {
                        return resState;
                    }
                } else {
                    UniqueString varName = var.getName();
                    Value lval = (Value)s1.lookup(varName);
                    Value rval = this.eval(args[1], c, s0, s1, 0, cm);
                    if (lval == null) {
                        Value elem;
                        if (!(rval instanceof Enumerable)) {
                            Assert.fail("In computing next states, the right side of \\IN is not enumerable.\n" + pred);
                        }
                        ValueEnumeration Enum4 = ((Enumerable)((Object)rval)).elements();
                        while ((elem = Enum4.nextElement()) != null) {
                            resState.bind(varName, (IValue)elem);
                            resState = this.getNextStates(action, acts, s0, resState, nss, cm);
                            resState.unbind(varName);
                        }
                        return resState;
                    }
                    if (!rval.member(lval)) {
                        return resState;
                    }
                }
                return this.getNextStates(action, acts, s0, s1, nss, cm);
            }
            case 38: {
                Value bval = this.eval(args[0], c, s0, s1, 0, cm);
                if (!(bval instanceof BoolValue)) {
                    Assert.fail("In computing next states of a predicate of the form P => Q, P was\n" + bval.getKindString() + ".\n" + pred);
                }
                if (((BoolValue)bval).val) {
                    return this.getNextStates(action, args[1], acts, c, s0, s1, nss, cm);
                }
                return this.getNextStates(action, acts, s0, s1, nss, cm);
            }
            case 49: {
                return this.processUnchanged(action, args[0], acts, c, s0, s1, nss, cm);
            }
            case 52: {
                Assert.fail("The current version of TLC does not support action composition.");
                return s1;
            }
            case 46: {
                return this.getNextStates(action, args[0], acts, c, s0, s1, nss, cm);
            }
        }
        Value bval = this.eval(pred, c, s0, s1, 0, cm);
        if (!(bval instanceof BoolValue)) {
            Assert.fail(2247, new String[]{"next states", "boolean", bval.toString(), pred.toString()});
        }
        if (((BoolValue)bval).val) {
            resState = this.getNextStates(action, acts, s0, s1, nss, cm);
        }
        return resState;
    }

    @ExpectInlined
    protected abstract TLCState processUnchanged(Action var1, SemanticNode var2, ActionItemList var3, Context var4, TLCState var5, TLCState var6, INextStateFunctor var7, CostModel var8);

    protected final TLCState processUnchangedImpl(Action action, SemanticNode expr, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        Value v1;
        IValue v0;
        if (coverage) {
            cm = cm.get(expr);
        }
        SymbolNode var = this.getVar(expr, c, false, toolId);
        TLCState resState = s1;
        if (var != null) {
            return this.processUnchangedImplVar(action, expr, acts, s0, s1, nss, var, cm);
        }
        if (expr instanceof OpApplNode) {
            OpApplNode expr1 = (OpApplNode)expr;
            ExprOrOpArgNode[] args = expr1.getArgs();
            int alen = args.length;
            SymbolNode opNode = expr1.getOperator();
            UniqueString opName = opNode.getName();
            int opcode = BuiltInOPs.getOpCode(opName);
            if (opcode == 23) {
                return this.processUnchangedImplTuple(action, acts, c, s0, s1, nss, args, alen, cm, coverage ? cm.get(expr1) : cm);
            }
            if (opcode == 0 && alen == 0) {
                return this.processUnchangedImpl0Arity(action, expr, acts, c, s0, s1, nss, cm, opNode, opName);
            }
        }
        if ((v0 = this.eval(expr, c, s0, cm)).equals(v1 = this.eval(expr, c, s1, null, 0, cm))) {
            resState = this.getNextStates(action, acts, s0, s1, nss, cm);
        }
        return resState;
    }

    @ExpectInlined
    private final TLCState processUnchangedImpl0Arity(Action action, SemanticNode expr, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm, SymbolNode opNode, UniqueString opName) {
        Object val = this.lookup(opNode, c, false);
        if (val instanceof OpDefNode) {
            return this.processUnchanged(action, ((OpDefNode)val).getBody(), acts, c, s0, s1, nss, cm);
        }
        if (val instanceof LazyValue) {
            LazyValue lv = (LazyValue)val;
            return this.processUnchanged(action, lv.expr, acts, lv.con, s0, s1, nss, cm);
        }
        Assert.fail("In computing next states, TLC found the identifier\n" + opName + " undefined in an UNCHANGED expression at\n" + expr);
        return this.getNextStates(action, acts, s0, s1, nss, cm);
    }

    @Override
    public final IValue eval(SemanticNode expr, Context c, TLCState s0) {
        return this.eval(expr, c, s0, TLCState.Empty, 0, CostModel.DO_NOT_RECORD);
    }

    @ExpectInlined
    private final TLCState processUnchangedImplTuple(Action action, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, ExprOrOpArgNode[] args, int alen, CostModel cm, CostModel cmNested) {
        if (alen != 0) {
            ActionItemList acts1 = acts;
            for (int i = alen - 1; i > 0; --i) {
                acts1 = (ActionItemList)acts1.cons(args[i], c, cmNested, -2);
            }
            return this.processUnchanged(action, args[0], acts1, c, s0, s1, nss, cmNested);
        }
        return this.getNextStates(action, acts, s0, s1, nss, cm);
    }

    @ExpectInlined
    private final TLCState processUnchangedImplVar(Action action, SemanticNode expr, ActionItemList acts, TLCState s0, TLCState s1, INextStateFunctor nss, SymbolNode var, CostModel cm) {
        TLCState resState = s1;
        UniqueString varName = var.getName();
        IValue val0 = s0.lookup(varName);
        IValue val1 = s1.lookup(varName);
        if (val1 == null) {
            resState.bind(varName, val0);
            resState = coverage ? this.getNextStates(action, acts, s0, resState, nss, cm) : this.getNextStates0(action, acts, s0, resState, nss, cm);
            resState.unbind(varName);
        } else if (val0.equals(val1)) {
            resState = coverage ? this.getNextStates(action, acts, s0, s1, nss, cm) : this.getNextStates0(action, acts, s0, s1, nss, cm);
        } else {
            MP.printWarning(2143, varName.toString(), expr.toString());
        }
        return resState;
    }

    @Override
    public final IValue eval(SemanticNode expr, Context c, TLCState s0, CostModel cm) {
        return this.eval(expr, c, s0, TLCState.Empty, 0, cm);
    }

    @Override
    public final IValue eval(SemanticNode expr, Context c, TLCState s0, TLCState s1, int control) {
        return this.eval(expr, c, s0, s1, control, CostModel.DO_NOT_RECORD);
    }

    @Override
    public abstract Value eval(SemanticNode var1, Context var2, TLCState var3, TLCState var4, int var5, CostModel var6);

    @ExpectInlined
    protected final Value evalImpl(SemanticNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        switch (expr.getKind()) {
            case 29: {
                LabelNode expr1 = (LabelNode)expr;
                return this.eval(expr1.getBody(), c, s0, s1, control, cm);
            }
            case 9: {
                OpApplNode expr1 = (OpApplNode)expr;
                if (coverage) {
                    cm = cm.get(expr);
                }
                return this.evalAppl(expr1, c, s0, s1, control, cm);
            }
            case 10: {
                return this.evalImplLetInKind((LetInNode)expr, c, s0, s1, control, cm);
            }
            case 13: {
                return this.evalImplSubstInKind((SubstInNode)expr, c, s0, s1, control, cm);
            }
            case 30: {
                return this.evalImplApSubstInKind((APSubstInNode)expr, c, s0, s1, control, cm);
            }
            case 16: 
            case 17: 
            case 18: {
                return (Value)WorkerValue.mux(expr.getToolObject(toolId));
            }
            case 19: {
                return (Value)c.lookup(EXCEPT_AT);
            }
            case 8: {
                return this.evalImplOpArgKind((OpArgNode)expr, c, s0, s1, cm);
            }
        }
        Assert.fail("Attempted to evaluate an expression that cannot be evaluated.\n" + expr);
        return null;
    }

    @ExpectInlined
    private final Value evalImplLetInKind(LetInNode expr1, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        OpDefNode[] letDefs = expr1.getLets();
        int letLen = letDefs.length;
        Context c1 = c;
        for (int i = 0; i < letLen; ++i) {
            OpDefNode opDef = letDefs[i];
            if (opDef.getArity() != 0) continue;
            LazyValue rhs = new LazyValue(opDef.getBody(), c1, cm);
            c1 = c1.cons(opDef, rhs);
        }
        return this.eval(expr1.getBody(), c1, s0, s1, control, cm);
    }

    @ExpectInlined
    private final Value evalImplSubstInKind(SubstInNode expr1, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        Subst[] subs = expr1.getSubsts();
        int slen = subs.length;
        Context c1 = c;
        for (int i = 0; i < slen; ++i) {
            Subst sub = subs[i];
            c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, true, coverage ? sub.getCM() : cm, toolId));
        }
        return this.eval(expr1.getBody(), c1, s0, s1, control, cm);
    }

    @ExpectInlined
    private final Value evalImplApSubstInKind(APSubstInNode expr1, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        Subst[] subs = expr1.getSubsts();
        int slen = subs.length;
        Context c1 = c;
        for (int i = 0; i < slen; ++i) {
            Subst sub = subs[i];
            c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, true, cm, toolId));
        }
        return this.eval(expr1.getBody(), c1, s0, s1, control, cm);
    }

    @ExpectInlined
    private final Value evalImplOpArgKind(OpArgNode expr1, Context c, TLCState s0, TLCState s1, CostModel cm) {
        SymbolNode opNode = expr1.getOp();
        Object val = this.lookup(opNode, c, false);
        if (val instanceof OpDefNode) {
            return this.setSource(expr1, new OpLambdaValue((OpDefNode)val, this, c, s0, s1, cm));
        }
        return (Value)val;
    }

    @ExpectInlined
    protected abstract Value evalAppl(OpApplNode var1, Context var2, TLCState var3, TLCState var4, int var5, CostModel var6);

    protected final Value evalApplImpl(OpApplNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        if (coverage) {
            cm = cm.getAndIncrement(expr);
        }
        ExprOrOpArgNode[] args = expr.getArgs();
        SymbolNode opNode = expr.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            SymbolNode opDef;
            Object val = this.lookup(opNode, c, s0, EvalControl.isPrimed(control));
            if (val instanceof LazyValue) {
                LazyValue lv = (LazyValue)val;
                if (s1 == null) {
                    val = this.eval(lv.expr, lv.con, s0, null, control, lv.getCostModel());
                } else if (lv.isUncachable() || EvalControl.isEnabled(control)) {
                    val = this.eval(lv.expr, lv.con, s0, s1, control, lv.getCostModel());
                } else {
                    val = lv.getValue();
                    if (val == null) {
                        Value res = this.eval(lv.expr, lv.con, s0, s1, control, lv.getCostModel());
                        int level = ((LevelNode)lv.expr).getLevel();
                        if (EvalControl.isInit(control) && level <= 0 || !EvalControl.isInit(control) && level <= 1) {
                            lv.setValue(res);
                        }
                        val = res;
                    }
                }
            }
            Value res = null;
            if (val instanceof OpDefNode) {
                opDef = (OpDefNode)val;
                opcode = BuiltInOPs.getOpCode(opDef.getName());
                if (opcode == 0) {
                    Context c1 = this.getOpContext((OpDefNode)opDef, args, c, true, cm, toolId);
                    res = this.eval(((OpDefNode)opDef).getBody(), c1, s0, s1, control, cm);
                }
            } else if (val instanceof Value) {
                res = (Value)val;
                int alen = args.length;
                if (alen == 0) {
                    if (val instanceof MethodValue) {
                        res = ((MethodValue)val).apply(EmptyArgs, 0);
                    } else if (val instanceof EvaluatingValue) {
                        res = ((EvaluatingValue)val).eval(this, args, c, s0, s1, control, cm);
                    }
                } else if (val instanceof OpValue) {
                    res = ((OpValue)val).eval(this, args, c, s0, s1, control, cm);
                }
            } else {
                if (val instanceof ThmOrAssumpDefNode) {
                    opDef = (ThmOrAssumpDefNode)val;
                    Context c1 = this.getOpContext((ThmOrAssumpDefNode)opDef, args, c, true);
                    return this.eval(((ThmOrAssumpDefNode)opDef).getBody(), c1, s0, s1, control, cm);
                }
                Assert.fail(2280, new String[]{opNode.getName().toString(), expr.toString()});
            }
            if (opcode == 0) {
                return res;
            }
        }
        switch (opcode) {
            case 1: {
                ExprOrOpArgNode pred = args[0];
                ExprNode inExpr = expr.getBdedQuantBounds()[0];
                Value inVal = this.eval(inExpr, c, s0, s1, control, cm);
                if (!(inVal instanceof Enumerable)) {
                    Assert.fail("Attempted to compute the value of an expression of\nform CHOOSE x \\in S: P, but S was not enumerable.\n" + expr);
                }
                inVal.normalize();
                ValueEnumeration enumSet = ((Enumerable)((Object)inVal)).elements(Enumerable.Ordering.NORMALIZED);
                FormalParamNode[] bvars = expr.getBdedQuantSymbolLists()[0];
                boolean isTuple = expr.isBdedQuantATuple()[0];
                if (isTuple) {
                    Value val;
                    int cnt = bvars.length;
                    while ((val = enumSet.nextElement()) != null) {
                        TupleValue tv = (TupleValue)val.toTuple();
                        if (tv == null || tv.size() != cnt) {
                            Assert.fail("Attempted to compute the value of an expression of form\nCHOOSE <<x1, ... , xN>> \\in S: P, but S was not a set\nof N-tuples.\n" + expr);
                        }
                        Context c1 = c;
                        for (int i = 0; i < cnt; ++i) {
                            c1 = c1.cons(bvars[i], tv.elems[i]);
                        }
                        Value bval = this.eval(pred, c1, s0, s1, control, cm);
                        if (!(bval instanceof BoolValue)) {
                            Assert.fail(2215, new String[]{"boolean", expr.toString()});
                        }
                        if (!((BoolValue)bval).val) continue;
                        return val;
                    }
                } else {
                    Value val;
                    FormalParamNode name = bvars[0];
                    while ((val = enumSet.nextElement()) != null) {
                        Context c1 = c.cons(name, val);
                        Value bval = this.eval(pred, c1, s0, s1, control, cm);
                        if (!(bval instanceof BoolValue)) {
                            Assert.fail(2215, new String[]{"boolean", expr.toString()});
                        }
                        if (!((BoolValue)bval).val) continue;
                        return val;
                    }
                }
                Assert.fail("Attempted to compute the value of an expression of form\nCHOOSE x \\in S: P, but no element of S satisfied P.\n" + expr);
                return null;
            }
            case 2: {
                Context c1;
                ContextEnumerator Enum2 = this.contexts(expr, c, s0, s1, control, cm);
                ExprOrOpArgNode body = args[0];
                while ((c1 = Enum2.nextElement()) != null) {
                    Value bval = this.eval(body, c1, s0, s1, control, cm);
                    if (!(bval instanceof BoolValue)) {
                        Assert.fail(2215, new String[]{"boolean", expr.toString()});
                    }
                    if (!((BoolValue)bval).val) continue;
                    return BoolValue.ValTrue;
                }
                return BoolValue.ValFalse;
            }
            case 3: {
                Context c1;
                ContextEnumerator Enum2 = this.contexts(expr, c, s0, s1, control, cm);
                ExprOrOpArgNode body = args[0];
                while ((c1 = Enum2.nextElement()) != null) {
                    Value bval = this.eval(body, c1, s0, s1, control, cm);
                    if (!(bval instanceof BoolValue)) {
                        Assert.fail(2215, new String[]{"boolean", expr.toString()});
                    }
                    if (((BoolValue)bval).val) continue;
                    return BoolValue.ValFalse;
                }
                return BoolValue.ValTrue;
            }
            case 4: {
                int alen = args.length;
                ExprOrOpArgNode other = null;
                for (int i = 0; i < alen; ++i) {
                    OpApplNode pairNode = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pairArgs = pairNode.getArgs();
                    if (pairArgs[0] == null) {
                        other = pairArgs[1];
                        if (!coverage) continue;
                        cm = cm.get(pairNode);
                        continue;
                    }
                    Value bval = this.eval(pairArgs[0], c, s0, s1, control, coverage ? cm.get(pairNode) : cm);
                    if (!(bval instanceof BoolValue)) {
                        Assert.fail("A non-boolean expression (" + bval.getKindString() + ") was used as a condition of a CASE. " + pairArgs[0]);
                    }
                    if (!((BoolValue)bval).val) continue;
                    return this.eval(pairArgs[1], c, s0, s1, control, coverage ? cm.get(pairNode) : cm);
                }
                if (other == null) {
                    Assert.fail("Attempted to evaluate a CASE with no conditions true.\n" + expr);
                }
                return this.eval(other, c, s0, s1, control, cm);
            }
            case 5: {
                int alen = args.length;
                Value[] sets = new Value[alen];
                for (int i = 0; i < alen; ++i) {
                    sets[i] = this.eval(args[i], c, s0, s1, control, cm);
                }
                return this.setSource(expr, new SetOfTuplesValue(sets, cm));
            }
            case 6: {
                int alen = args.length;
                for (int i = 0; i < alen; ++i) {
                    Value bval = this.eval(args[i], c, s0, s1, control, cm);
                    if (!(bval instanceof BoolValue)) {
                        Assert.fail("A non-boolean expression (" + bval.getKindString() + ") was used as a formula in a conjunction.\n" + args[i]);
                    }
                    if (((BoolValue)bval).val) continue;
                    return BoolValue.ValFalse;
                }
                return BoolValue.ValTrue;
            }
            case 7: {
                int alen = args.length;
                for (int i = 0; i < alen; ++i) {
                    Value bval = this.eval(args[i], c, s0, s1, control, cm);
                    if (!(bval instanceof BoolValue)) {
                        Assert.fail("A non-boolean expression (" + bval.getKindString() + ") was used as a formula in a disjunction.\n" + args[i]);
                    }
                    if (!((BoolValue)bval).val) continue;
                    return BoolValue.ValTrue;
                }
                return BoolValue.ValFalse;
            }
            case 8: {
                int alen = args.length;
                Value result = this.eval(args[0], c, s0, s1, control, cm);
                for (int i = 1; i < alen; ++i) {
                    OpApplNode pairNode = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pairArgs = pairNode.getArgs();
                    ExprOrOpArgNode[] cmpts = ((OpApplNode)pairArgs[0]).getArgs();
                    Value[] lhs = new Value[cmpts.length];
                    for (int j = 0; j < lhs.length; ++j) {
                        lhs[j] = this.eval(cmpts[j], c, s0, s1, control, coverage ? cm.get(pairNode).get(pairArgs[0]) : cm);
                    }
                    Value atVal = result.select(lhs);
                    if (atVal == null) {
                        MP.printWarning(2144, new String[]{args[0].toString()});
                        continue;
                    }
                    Context c1 = c.cons(EXCEPT_AT, atVal);
                    Value rhs = this.eval(pairArgs[1], c1, s0, s1, control, coverage ? cm.get(pairNode) : cm);
                    ValueExcept vex = new ValueExcept(lhs, rhs);
                    result = result.takeExcept(vex);
                }
                return result;
            }
            case 9: {
                Value result = null;
                Value fval = this.eval(args[0], c, s0, s1, EvalControl.setKeepLazy(control), cm);
                if (fval instanceof FcnRcdValue || fval instanceof FcnLambdaValue) {
                    Applicable fcn = (Applicable)((Object)fval);
                    Value argVal = this.eval(args[1], c, s0, s1, control, cm);
                    result = fcn.apply(argVal, control);
                } else if (fval instanceof TupleValue || fval instanceof RecordValue) {
                    Applicable fcn = (Applicable)((Object)fval);
                    if (args.length != 2) {
                        Assert.fail("Attempted to evaluate an expression of form f[e1, ... , eN]\nwith f a tuple or record and N > 1.\n" + expr);
                    }
                    Value aval = this.eval(args[1], c, s0, s1, control, cm);
                    result = fcn.apply(aval, control);
                } else {
                    Assert.fail("A non-function (" + fval.getKindString() + ") was applied as a function.\n" + expr);
                }
                return result;
            }
            case 10: 
            case 12: 
            case 16: {
                FormalParamNode[][] formals = expr.getBdedQuantSymbolLists();
                boolean[] isTuples = expr.isBdedQuantATuple();
                ExprNode[] domains = expr.getBdedQuantBounds();
                Value[] dvals = new Value[domains.length];
                boolean isFcnRcd = true;
                for (int i = 0; i < dvals.length; ++i) {
                    dvals[i] = this.eval(domains[i], c, s0, s1, control, cm);
                    isFcnRcd = isFcnRcd && dvals[i] instanceof Reducible;
                }
                FcnParams params = new FcnParams(formals, isTuples, dvals);
                ExprOrOpArgNode fbody = args[0];
                FcnLambdaValue fval = (FcnLambdaValue)this.setSource(expr, new FcnLambdaValue(params, fbody, this, c, s0, s1, control, cm));
                if (opcode == 16) {
                    FormalParamNode fname = expr.getUnbdedQuantSymbols()[0];
                    fval.makeRecursive(fname);
                    isFcnRcd = false;
                }
                if (isFcnRcd && !EvalControl.isKeepLazy(control)) {
                    return fval.toFcnRcd();
                }
                return fval;
            }
            case 11: {
                Value bval = this.eval(args[0], c, s0, s1, control, cm);
                if (!(bval instanceof BoolValue)) {
                    Assert.fail("A non-boolean expression (" + bval.getKindString() + ") was used as the condition of an IF.\n" + expr);
                }
                if (((BoolValue)bval).val) {
                    return this.eval(args[1], c, s0, s1, control, cm);
                }
                return this.eval(args[2], c, s0, s1, control, cm);
            }
            case 14: {
                int i;
                int alen = args.length;
                UniqueString[] names = new UniqueString[alen];
                Value[] vals = new Value[alen];
                for (i = 0; i < alen; ++i) {
                    OpApplNode pairNode = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pair2 = pairNode.getArgs();
                    names[i] = ((StringValue)pair2[0].getToolObject(toolId)).getVal();
                    vals[i] = this.eval(pair2[1], c, s0, s1, control, coverage ? cm.get(pairNode) : cm);
                }
                return this.setSource(expr, new RecordValue(names, vals, false, cm));
            }
            case 15: {
                Value rval = this.eval(args[0], c, s0, s1, control, cm);
                Value sval = (Value)WorkerValue.mux(args[1].getToolObject(toolId));
                if (rval instanceof RecordValue) {
                    Value result = ((RecordValue)rval).select(sval);
                    if (result == null) {
                        Assert.fail("Attempted to select nonexistent field " + sval + " from the record\n" + Values.ppr(rval.toString()) + "\n" + expr);
                    }
                    return result;
                }
                FcnRcdValue fcn = (FcnRcdValue)rval.toFcnRcd();
                if (fcn == null) {
                    Assert.fail("Attempted to select field " + sval + " from a non-record value " + Values.ppr(rval.toString()) + "\n" + expr);
                }
                return fcn.apply(sval, control);
            }
            case 18: {
                int alen = args.length;
                Value[] vals = new ValueVec(alen);
                for (int i = 0; i < alen; ++i) {
                    vals.addElement(this.eval(args[i], c, s0, s1, control, cm));
                }
                return this.setSource(expr, new SetEnumValue((ValueVec)vals, false, cm));
            }
            case 19: {
                Context c1;
                ValueVec vals = new ValueVec();
                ContextEnumerator Enum3 = this.contexts(expr, c, s0, s1, control, cm);
                ExprOrOpArgNode body = args[0];
                while ((c1 = Enum3.nextElement()) != null) {
                    Value val = this.eval(body, c1, s0, s1, control, cm);
                    vals.addElement(val);
                }
                return this.setSource(expr, new SetEnumValue(vals, false, cm));
            }
            case 20: {
                int i;
                int alen = args.length;
                UniqueString[] names = new UniqueString[alen];
                Value[] vals = new Value[alen];
                for (i = 0; i < alen; ++i) {
                    OpApplNode pairNode = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pair3 = pairNode.getArgs();
                    names[i] = ((StringValue)pair3[0].getToolObject(toolId)).getVal();
                    vals[i] = this.eval(pair3[1], c, s0, s1, control, coverage ? cm.get(pairNode) : cm);
                }
                return this.setSource(expr, new SetOfRcdsValue(names, vals, false, cm));
            }
            case 21: {
                Value lhs = this.eval(args[0], c, s0, s1, control, cm);
                Value rhs = this.eval(args[1], c, s0, s1, control, cm);
                return this.setSource(expr, new SetOfFcnsValue(lhs, rhs, cm));
            }
            case 22: {
                ExprOrOpArgNode pred = args[0];
                ExprNode inExpr = expr.getBdedQuantBounds()[0];
                Value inVal = this.eval(inExpr, c, s0, s1, control, cm);
                boolean isTuple = expr.isBdedQuantATuple()[0];
                FormalParamNode[] bvars = expr.getBdedQuantSymbolLists()[0];
                if (inVal instanceof Reducible) {
                    ValueVec vals = new ValueVec();
                    ValueEnumeration enumSet = ((Enumerable)((Object)inVal)).elements();
                    if (isTuple) {
                        Value elem;
                        while ((elem = enumSet.nextElement()) != null) {
                            Context c1 = c;
                            Value[] tuple = ((TupleValue)elem).elems;
                            for (int i = 0; i < bvars.length; ++i) {
                                c1 = c1.cons(bvars[i], tuple[i]);
                            }
                            Value bval = this.eval(pred, c1, s0, s1, control, cm);
                            if (!(bval instanceof BoolValue)) {
                                Assert.fail("Attempted to evaluate an expression of form {x \\in S : P(x)} when P was " + bval.getKindString() + ".\n" + pred);
                            }
                            if (!((BoolValue)bval).val) continue;
                            vals.addElement(elem);
                        }
                    } else {
                        Value elem;
                        FormalParamNode idName = bvars[0];
                        while ((elem = enumSet.nextElement()) != null) {
                            Context c1 = c.cons(idName, elem);
                            Value bval = this.eval(pred, c1, s0, s1, control, cm);
                            if (!(bval instanceof BoolValue)) {
                                Assert.fail("Attempted to evaluate an expression of form {x \\in S : P(x)} when P was " + bval.getKindString() + ".\n" + pred);
                            }
                            if (!((BoolValue)bval).val) continue;
                            vals.addElement(elem);
                        }
                    }
                    return this.setSource(expr, new SetEnumValue(vals, inVal.isNormalized(), cm));
                }
                if (isTuple) {
                    return this.setSource(expr, new SetPredValue(bvars, inVal, pred, this, c, s0, s1, control, cm));
                }
                return this.setSource(expr, new SetPredValue(bvars[0], inVal, pred, this, c, s0, s1, control, cm));
            }
            case 23: {
                int alen = args.length;
                Value[] vals = new Value[alen];
                for (int i = 0; i < alen; ++i) {
                    vals[i] = this.eval(args[i], c, s0, s1, control, cm);
                }
                return this.setSource(expr, new TupleValue(vals, cm));
            }
            case 24: {
                Assert.fail("TLC attempted to evaluate an unbounded CHOOSE.\nMake sure that the expression is of form CHOOSE x \\in S: P(x).\n" + expr);
                return null;
            }
            case 25: {
                Assert.fail("TLC attempted to evaluate an unbounded \\E.\nMake sure that the expression is of form \\E x \\in S: P(x).\n" + expr);
                return null;
            }
            case 26: {
                Assert.fail("TLC attempted to evaluate an unbounded \\A.\nMake sure that the expression is of form \\A x \\in S: P(x).\n" + expr);
                return null;
            }
            case 27: {
                Value arg = this.eval(args[0], c, s0, s1, control, cm);
                if (!(arg instanceof BoolValue)) {
                    Assert.fail("Attempted to apply the operator ~ to a non-boolean\n(" + arg.getKindString() + ")\n" + expr);
                }
                return ((BoolValue)arg).val ? BoolValue.ValFalse : BoolValue.ValTrue;
            }
            case 29: {
                Value arg = this.eval(args[0], c, s0, s1, control, cm);
                return this.setSource(expr, new SubsetValue(arg, cm));
            }
            case 30: {
                Value arg = this.eval(args[0], c, s0, s1, control, cm);
                return this.setSource(expr, UnionValue.union(arg));
            }
            case 31: {
                Value arg = this.eval(args[0], c, s0, s1, control, cm);
                if (!(arg instanceof Applicable)) {
                    Assert.fail("Attempted to apply the operator DOMAIN to a non-function\n(" + arg.getKindString() + ")\n" + expr);
                }
                return this.setSource(expr, ((Applicable)((Object)arg)).getDomain());
            }
            case 34: {
                TLCState sfun = TLCStateFun.Empty;
                Context c1 = Context.branch(c);
                sfun = this.enabled((SemanticNode)args[0], ActionItemList.Empty, c1, s0, sfun, cm);
                return sfun != null ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 35: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                return arg1.equals(arg2) ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 36: {
                Value arg2;
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                if (!(arg1 instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form P /\\ Q when P was\n" + arg1.getKindString() + ".\n" + expr);
                }
                if (((BoolValue)arg1).val) {
                    arg2 = this.eval(args[1], c, s0, s1, control, cm);
                    if (!(arg2 instanceof BoolValue)) {
                        Assert.fail("Attempted to evaluate an expression of form P /\\ Q when Q was\n" + arg2.getKindString() + ".\n" + expr);
                    }
                    return arg2;
                }
                return BoolValue.ValFalse;
            }
            case 37: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                if (!(arg1 instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form P \\/ Q when P was\n" + arg1.getKindString() + ".\n" + expr);
                }
                if (((BoolValue)arg1).val) {
                    return BoolValue.ValTrue;
                }
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                if (!(arg2 instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form P \\/ Q when Q was\n" + arg2.getKindString() + ".\n" + expr);
                }
                return arg2;
            }
            case 38: {
                Value arg2;
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                if (!(arg1 instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form P => Q when P was\n" + arg1.getKindString() + ".\n" + expr);
                }
                if (((BoolValue)arg1).val) {
                    arg2 = this.eval(args[1], c, s0, s1, control, cm);
                    if (!(arg2 instanceof BoolValue)) {
                        Assert.fail("Attempted to evaluate an expression of form P => Q when Q was\n" + arg2.getKindString() + ".\n" + expr);
                    }
                    return arg2;
                }
                return BoolValue.ValTrue;
            }
            case 39: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                if (!(arg1 instanceof BoolValue) || !(arg2 instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form P <=> Q when P or Q was not a boolean.\n" + expr);
                }
                BoolValue bval1 = (BoolValue)arg1;
                BoolValue bval2 = (BoolValue)arg2;
                return bval1.val == bval2.val ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 40: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                return arg1.equals(arg2) ? BoolValue.ValFalse : BoolValue.ValTrue;
            }
            case 41: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                if (!(arg1 instanceof Enumerable)) {
                    Assert.fail("Attempted to evaluate an expression of form S \\subseteq T, but S was not enumerable.\n" + expr);
                }
                return ((Enumerable)((Object)arg1)).isSubsetEq(arg2);
            }
            case 42: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                return arg2.member(arg1) ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 43: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                return arg2.member(arg1) ? BoolValue.ValFalse : BoolValue.ValTrue;
            }
            case 44: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                if (arg1 instanceof Reducible) {
                    return this.setSource(expr, ((Reducible)((Object)arg1)).diff(arg2));
                }
                return this.setSource(expr, new SetDiffValue(arg1, arg2));
            }
            case 45: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                if (arg1 instanceof Reducible) {
                    return this.setSource(expr, ((Reducible)((Object)arg1)).cap(arg2));
                }
                if (arg2 instanceof Reducible) {
                    return this.setSource(expr, ((Reducible)((Object)arg2)).cap(arg1));
                }
                return this.setSource(expr, new SetCapValue(arg1, arg2));
            }
            case 46: {
                return this.eval(args[0], c, s0, s1, control, cm);
            }
            case 47: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                if (arg1 instanceof Reducible) {
                    return this.setSource(expr, ((Reducible)((Object)arg1)).cup(arg2));
                }
                if (arg2 instanceof Reducible) {
                    return this.setSource(expr, ((Reducible)((Object)arg2)).cup(arg1));
                }
                return this.setSource(expr, new SetCupValue(arg1, arg2, cm));
            }
            case 48: {
                return this.eval(args[0], c, s1, null, EvalControl.setPrimedIfEnabled(control), cm);
            }
            case 49: {
                Value v0 = this.eval(args[0], c, s0, TLCState.Empty, control, cm);
                Value v1 = this.eval(args[0], c, s1, null, EvalControl.setPrimedIfEnabled(control), cm);
                return v0.equals(v1) ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 50: {
                Value v1;
                Value res = this.eval(args[0], c, s0, s1, control, cm);
                if (!(res instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form <A>_e, but A was not a boolean.\n" + expr);
                }
                if (!((BoolValue)res).val) {
                    return BoolValue.ValFalse;
                }
                Value v0 = this.eval(args[1], c, s0, TLCState.Empty, control, cm);
                return v0.equals(v1 = this.eval(args[1], c, s1, null, EvalControl.setPrimedIfEnabled(control), cm)) ? BoolValue.ValFalse : BoolValue.ValTrue;
            }
            case 51: {
                Value v1;
                Value res = this.eval(args[0], c, s0, s1, control, cm);
                if (!(res instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form [A]_e, but A was not a boolean.\n" + expr);
                }
                if (((BoolValue)res).val) {
                    return BoolValue.ValTrue;
                }
                Value v0 = this.eval(args[1], c, s0, TLCState.Empty, control, cm);
                return v0.equals(v1 = this.eval(args[1], c, s1, null, EvalControl.setPrimedIfEnabled(control), cm)) ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 52: {
                Assert.fail("The current version of TLC does not support action composition.");
                return null;
            }
            case 53: {
                Assert.fail(2261, new String[]{"SF", expr.toString()});
                return null;
            }
            case 54: {
                Assert.fail(2261, new String[]{"WF", expr.toString()});
                return null;
            }
            case 55: {
                Assert.fail(2261, new String[]{"\\EE", expr.toString()});
                return null;
            }
            case 56: {
                Assert.fail(2261, new String[]{"\\AA", expr.toString()});
                return null;
            }
            case 57: {
                Assert.fail(2261, new String[]{"a ~> b", expr.toString()});
                return null;
            }
            case 58: {
                Assert.fail(2261, new String[]{"a -+-> formula", expr.toString()});
                return null;
            }
            case 59: {
                Assert.fail(2261, new String[]{"[]A", expr.toString()});
                return null;
            }
            case 60: {
                Assert.fail(2261, new String[]{"<>A", expr.toString()});
                return null;
            }
        }
        Assert.fail("TLC BUG: could not evaluate this expression.\n" + expr);
        return null;
    }

    protected abstract Value setSource(SemanticNode var1, Value var2);

    @Override
    public final boolean isGoodState(TLCState state) {
        return state.allAssigned();
    }

    @Override
    public final boolean isInModel(TLCState state) throws EvalException {
        ExprNode[] constrs = this.getModelConstraints();
        for (int i = 0; i < constrs.length; ++i) {
            IValue bval = this.eval(constrs[i], Context.Empty, state, CostModel.DO_NOT_RECORD);
            if (!(bval instanceof BoolValue)) {
                Assert.fail(2215, new String[]{"boolean", constrs[i].toString()});
            }
            if (((BoolValue)bval).val) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isInActions(TLCState s1, TLCState s2) throws EvalException {
        ExprNode[] constrs = this.getActionConstraints();
        for (int i = 0; i < constrs.length; ++i) {
            Value bval = this.eval(constrs[i], Context.Empty, s1, s2, 0, CostModel.DO_NOT_RECORD);
            if (!(bval instanceof BoolValue)) {
                Assert.fail(2215, new String[]{"boolean", constrs[i].toString()});
            }
            if (((BoolValue)bval).val) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean hasStateOrActionConstraints() {
        return this.getModelConstraints().length > 0 || this.getActionConstraints().length > 0;
    }

    @Override
    public final TLCState enabled(SemanticNode pred, Context c, TLCState s0, TLCState s1) {
        return this.enabled(pred, ActionItemList.Empty, c, s0, s1, CostModel.DO_NOT_RECORD);
    }

    @Override
    public final TLCState enabled(SemanticNode pred, Context c, TLCState s0, TLCState s1, ExprNode subscript, int ail) {
        ActionItemList acts = (ActionItemList)ActionItemList.Empty.cons(subscript, c, CostModel.DO_NOT_RECORD, ail);
        return this.enabled(pred, acts, c, s0, s1, CostModel.DO_NOT_RECORD);
    }

    @Override
    public final TLCState enabled(SemanticNode pred, IActionItemList acts, Context c, TLCState s0, TLCState s1) {
        return this.enabled(pred, acts, c, s0, s1, CostModel.DO_NOT_RECORD);
    }

    @Override
    public abstract TLCState enabled(SemanticNode var1, IActionItemList var2, Context var3, TLCState var4, TLCState var5, CostModel var6);

    protected final TLCState enabledImpl(SemanticNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1, CostModel cm) {
        switch (pred.getKind()) {
            case 9: {
                OpApplNode pred1 = (OpApplNode)pred;
                return this.enabledAppl(pred1, acts, c, s0, s1, cm);
            }
            case 10: {
                LetInNode pred1 = (LetInNode)pred;
                OpDefNode[] letDefs = pred1.getLets();
                Context c1 = c;
                for (int i = 0; i < letDefs.length; ++i) {
                    OpDefNode opDef = letDefs[i];
                    if (opDef.getArity() != 0) continue;
                    LazyValue rhs = new LazyValue(opDef.getBody(), c1, cm);
                    c1 = c1.cons(opDef, rhs);
                }
                return this.enabled((SemanticNode)pred1.getBody(), acts, c1, s0, s1, cm);
            }
            case 13: {
                SubstInNode pred1 = (SubstInNode)pred;
                Subst[] subs = pred1.getSubsts();
                int slen = subs.length;
                Context c1 = c;
                for (int i = 0; i < slen; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false, coverage ? sub.getCM() : cm, toolId));
                }
                return this.enabled((SemanticNode)pred1.getBody(), acts, c1, s0, s1, cm);
            }
            case 30: {
                APSubstInNode pred1 = (APSubstInNode)pred;
                Subst[] subs = pred1.getSubsts();
                int slen = subs.length;
                Context c1 = c;
                for (int i = 0; i < slen; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false, cm, toolId));
                }
                return this.enabled((SemanticNode)pred1.getBody(), acts, c1, s0, s1, cm);
            }
            case 29: {
                LabelNode pred1 = (LabelNode)pred;
                return this.enabled((SemanticNode)pred1.getBody(), acts, c, s0, s1, cm);
            }
        }
        Assert.fail("Attempted to compute ENABLED on a non-boolean expression.\n" + pred);
        return null;
    }

    private final TLCState enabled(ActionItemList acts, TLCState s0, TLCState s1, CostModel cm) {
        Value v2;
        if (acts.isEmpty()) {
            return s1;
        }
        int kind = acts.carKind();
        SemanticNode pred = acts.carPred();
        Context c = acts.carContext();
        cm = acts.cm;
        ActionItemList acts1 = acts.cdr();
        if (kind > 0) {
            TLCState res = this.enabled(pred, acts1, c, s0, s1, cm);
            return res;
        }
        if (kind == -1) {
            TLCState res = this.enabled(pred, acts1, c, s0, s1, cm);
            return res;
        }
        if (kind == -2) {
            TLCState res = this.enabledUnchanged(pred, acts1, c, s0, s1, cm);
            return res;
        }
        Value v1 = this.eval(pred, c, s0, TLCState.Empty, 4, cm);
        if (v1.equals(v2 = this.eval(pred, c, s1, null, 2, cm))) {
            return null;
        }
        TLCState res = this.enabled(acts1, s0, s1, cm);
        return res;
    }

    protected abstract TLCState enabledAppl(OpApplNode var1, ActionItemList var2, Context var3, TLCState var4, TLCState var5, CostModel var6);

    protected final TLCState enabledApplImpl(OpApplNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1, CostModel cm) {
        Value bval;
        Object bval2;
        if (coverage) {
            cm = cm.get(pred);
        }
        ExprOrOpArgNode[] args = pred.getArgs();
        int alen = args.length;
        SymbolNode opNode = pred.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            SymbolNode opDef;
            Object val = this.lookup(opNode, c, s0, false);
            if (val instanceof OpDefNode && (opcode = BuiltInOPs.getOpCode((opDef = (OpDefNode)val).getName())) == 0) {
                Context c1 = this.getOpContext((OpDefNode)opDef, args, c, true, cm, toolId);
                return this.enabled((SemanticNode)((OpDefNode)opDef).getBody(), acts, c1, s0, s1, cm);
            }
            if (val instanceof ThmOrAssumpDefNode) {
                opDef = (ThmOrAssumpDefNode)val;
                Context c1 = this.getOpContext((ThmOrAssumpDefNode)opDef, args, c, true);
                return this.enabled((SemanticNode)((ThmOrAssumpDefNode)opDef).getBody(), acts, c1, s0, s1, cm);
            }
            if (val instanceof LazyValue) {
                LazyValue lv = (LazyValue)val;
                return this.enabled(lv.expr, acts, lv.con, s0, s1, lv.cm);
            }
            bval2 = val;
            if (alen == 0) {
                if (val instanceof MethodValue) {
                    bval2 = ((MethodValue)val).apply(EmptyArgs, 0);
                } else if (val instanceof EvaluatingValue) {
                    bval2 = ((EvaluatingValue)val).eval(this, args, c, s0, s1, 4, cm);
                }
            } else if (val instanceof OpValue) {
                bval2 = ((OpValue)val).eval(this, args, c, s0, s1, 4, cm);
            }
            if (opcode == 0) {
                if (!(bval2 instanceof BoolValue)) {
                    Assert.fail(2247, new String[]{"ENABLED", "boolean", bval2.toString(), pred.toString()});
                }
                if (((BoolValue)bval2).val) {
                    return this.enabled(acts, s0, s1, cm);
                }
                return null;
            }
        }
        switch (opcode) {
            case 50: {
                ActionItemList acts1 = (ActionItemList)acts.cons(args[1], c, cm, -3);
                return this.enabled((SemanticNode)args[0], acts1, c, s0, s1, cm);
            }
            case 2: {
                Context c1;
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum2 = this.contexts(pred, c, s0, s1, 4, cm);
                while ((c1 = Enum2.nextElement()) != null) {
                    TLCState s2 = this.enabled((SemanticNode)body, acts, c1, s0, s1, cm);
                    if (s2 == null) continue;
                    return s2;
                }
                return null;
            }
            case 3: {
                Context c2;
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum2 = this.contexts(pred, c, s0, s1, 4, cm);
                Context c1 = Enum2.nextElement();
                if (c1 == null) {
                    return this.enabled(acts, s0, s1, cm);
                }
                ActionItemList acts1 = acts;
                while ((c2 = Enum2.nextElement()) != null) {
                    acts1 = (ActionItemList)acts1.cons(body, c2, cm, -1);
                }
                return this.enabled((SemanticNode)body, acts1, c1, s0, s1, cm);
            }
            case 4: {
                ExprOrOpArgNode other = null;
                for (int i = 0; i < alen; ++i) {
                    OpApplNode pair2 = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pairArgs = pair2.getArgs();
                    if (pairArgs[0] == null) {
                        other = pairArgs[1];
                        continue;
                    }
                    Value bval3 = this.eval(pairArgs[0], c, s0, s1, 4, cm);
                    if (!(bval3 instanceof BoolValue)) {
                        Assert.fail("In computing ENABLED, a non-boolean expression(" + bval3.getKindString() + ") was used as a guard condition of a CASE.\n" + pairArgs[1]);
                    }
                    if (!((BoolValue)bval3).val) continue;
                    return this.enabled((SemanticNode)pairArgs[1], acts, c, s0, s1, cm);
                }
                if (other == null) {
                    Assert.fail("In computing ENABLED, TLC encountered a CASE with no conditions true.\n" + pred);
                }
                return this.enabled(other, acts, c, s0, s1, cm);
            }
            case 6: 
            case 36: {
                ActionItemList acts1 = acts;
                for (int i = alen - 1; i > 0; --i) {
                    acts1 = (ActionItemList)acts1.cons(args[i], c, cm, i);
                }
                return this.enabled((SemanticNode)args[0], acts1, c, s0, s1, cm);
            }
            case 7: 
            case 37: {
                for (int i = 0; i < alen; ++i) {
                    TLCState s2 = this.enabled((SemanticNode)args[i], acts, c, s0, s1, cm);
                    if (s2 == null) continue;
                    return s2;
                }
                return null;
            }
            case 9: {
                Applicable fcn;
                Value fval = this.eval(args[0], c, s0, s1, EvalControl.setKeepLazy(4), cm);
                if (fval instanceof FcnLambdaValue) {
                    fcn = (FcnLambdaValue)fval;
                    if (((FcnLambdaValue)fcn).fcnRcd == null) {
                        Context c1 = this.getFcnContext((IFcnLambdaValue)((Object)fcn), args, c, s0, s1, 4, cm);
                        return this.enabled(((FcnLambdaValue)fcn).body, acts, c1, s0, s1, cm);
                    }
                    fval = ((FcnLambdaValue)fcn).fcnRcd;
                }
                if (fval instanceof Applicable) {
                    fcn = (Applicable)((Object)fval);
                    Value argVal = this.eval(args[1], c, s0, s1, 4, cm);
                    Value bval4 = fcn.apply(argVal, 4);
                    if (!(bval4 instanceof BoolValue)) {
                        Assert.fail(2248, new String[]{"ENABLED", "boolean", pred.toString()});
                    }
                    if (!((BoolValue)bval4).val) {
                        return null;
                    }
                } else {
                    Assert.fail("In computing ENABLED, a non-function (" + fval.getKindString() + ") was applied as a function.\n" + pred);
                }
                return this.enabled(acts, s0, s1, cm);
            }
            case 11: {
                Value guard = this.eval(args[0], c, s0, s1, 4, cm);
                if (!(guard instanceof BoolValue)) {
                    Assert.fail("In computing ENABLED, a non-boolean expression(" + guard.getKindString() + ") was used as the guard condition of an IF.\n" + pred);
                }
                int idx = ((BoolValue)guard).val ? 1 : 2;
                return this.enabled((SemanticNode)args[idx], acts, c, s0, s1, cm);
            }
            case 51: {
                TLCState s2 = this.enabled((SemanticNode)args[0], acts, c, s0, s1, cm);
                if (s2 != null) {
                    return s2;
                }
                return this.enabledUnchanged(args[1], acts, c, s0, s1, cm);
            }
            case 55: 
            case 56: {
                Assert.fail("In computing ENABLED, TLC encountered temporal quantifier.\n" + pred);
                return null;
            }
            case 24: {
                Assert.fail("In computing ENABLED, TLC encountered unbounded CHOOSE. Make sure that the expression is of form CHOOSE x \\in S: P(x).\n" + pred);
                return null;
            }
            case 25: {
                Assert.fail("In computing ENABLED, TLC encountered unbounded quantifier. Make sure that the expression is of form \\E x \\in S: P(x).\n" + pred);
                return null;
            }
            case 26: {
                Assert.fail("In computing ENABLED, TLC encountered unbounded quantifier. Make sure that the expression is of form \\A x \\in S: P(x).\n" + pred);
                return null;
            }
            case 53: {
                Assert.fail(2260, new String[]{"SF", pred.toString()});
                return null;
            }
            case 54: {
                Assert.fail(2260, new String[]{"WF", pred.toString()});
                return null;
            }
            case 59: {
                Assert.fail(2260, new String[]{"[]", pred.toString()});
                return null;
            }
            case 60: {
                Assert.fail(2260, new String[]{"<>", pred.toString()});
                return null;
            }
            case 49: {
                return this.enabledUnchanged(args[0], acts, c, s0, s1, cm);
            }
            case 35: {
                UniqueString varName;
                SymbolNode var = this.getPrimedVar(args[0], c, true);
                if (var == null) {
                    bval2 = this.eval(pred, c, s0, s1, 4, cm);
                    if (!((BoolValue)bval2).val) {
                        return null;
                    }
                } else {
                    varName = var.getName();
                    IValue lval = s1.lookup(varName);
                    Value rval = this.eval(args[1], c, s0, s1, 4, cm);
                    if (lval == null) {
                        TLCState s2 = s1.bind(var, (IValue)rval);
                        return this.enabled(acts, s0, s2, cm);
                    }
                    if (!lval.equals(rval)) {
                        return null;
                    }
                }
                return this.enabled(acts, s0, s1, cm);
            }
            case 38: {
                bval = this.eval(args[0], c, s0, s1, 4, cm);
                if (!(bval instanceof BoolValue)) {
                    Assert.fail("While computing ENABLED of an expression of the form P => Q, P was " + bval.getKindString() + ".\n" + pred);
                }
                if (((BoolValue)bval).val) {
                    return this.enabled((SemanticNode)args[1], acts, c, s0, s1, cm);
                }
                return this.enabled(acts, s0, s1, cm);
            }
            case 52: {
                Assert.fail("The current version of TLC does not support action composition.");
                return null;
            }
            case 57: {
                Assert.fail("In computing ENABLED, TLC encountered a temporal formula (a ~> b).\n" + pred);
                return null;
            }
            case 58: {
                Assert.fail("In computing ENABLED, TLC encountered a temporal formula (a -+-> formula).\n" + pred);
                return null;
            }
            case 42: {
                UniqueString varName;
                SymbolNode var = this.getPrimedVar(args[0], c, true);
                if (var == null) {
                    bval2 = this.eval(pred, c, s0, s1, 4, cm);
                    if (!((BoolValue)bval2).val) {
                        return null;
                    }
                } else {
                    varName = var.getName();
                    Value lval = (Value)s1.lookup(varName);
                    Value rval = this.eval(args[1], c, s0, s1, 4, cm);
                    if (lval == null) {
                        Value val;
                        if (!(rval instanceof Enumerable)) {
                            Assert.fail("The right side of \\IN is not enumerable.\n" + pred);
                        }
                        ValueEnumeration Enum3 = ((Enumerable)((Object)rval)).elements();
                        while ((val = Enum3.nextElement()) != null) {
                            TLCState s2 = s1.bind(var, (IValue)val);
                            if ((s2 = this.enabled(acts, s0, s2, cm)) == null) continue;
                            return s2;
                        }
                        return null;
                    }
                    if (!rval.member(lval)) {
                        return null;
                    }
                }
                return this.enabled(acts, s0, s1, cm);
            }
            case 46: {
                return this.enabled((SemanticNode)args[0], acts, c, s0, s1, cm);
            }
        }
        bval = this.eval(pred, c, s0, s1, 4, cm);
        if (!(bval instanceof BoolValue)) {
            Assert.fail(2247, new String[]{"ENABLED", "boolean", bval.toString(), pred.toString()});
        }
        if (((BoolValue)bval).val) {
            return this.enabled(acts, s0, s1, cm);
        }
        return null;
    }

    protected abstract TLCState enabledUnchanged(SemanticNode var1, ActionItemList var2, Context var3, TLCState var4, TLCState var5, CostModel var6);

    protected final TLCState enabledUnchangedImpl(SemanticNode expr, ActionItemList acts, Context c, TLCState s0, TLCState s1, CostModel cm) {
        Value v1;
        Value v0;
        SymbolNode var;
        if (coverage) {
            cm = cm.get(expr);
        }
        if ((var = this.getVar(expr, c, true, toolId)) != null) {
            UniqueString varName = var.getName();
            Value v02 = this.eval(expr, c, s0, s1, 4, cm);
            IValue v12 = s1.lookup(varName);
            if (v12 == null) {
                s1 = s1.bind(var, (IValue)v02);
                return this.enabled(acts, s0, s1, cm);
            }
            if (v12.equals(v02)) {
                return this.enabled(acts, s0, s1, cm);
            }
            MP.printWarning(2143, varName.toString(), expr.toString());
            return null;
        }
        if (expr instanceof OpApplNode) {
            OpApplNode expr1 = (OpApplNode)expr;
            ExprOrOpArgNode[] args = expr1.getArgs();
            int alen = args.length;
            SymbolNode opNode = expr1.getOperator();
            UniqueString opName = opNode.getName();
            int opcode = BuiltInOPs.getOpCode(opName);
            if (opcode == 23) {
                if (alen != 0) {
                    ActionItemList acts1 = acts;
                    for (int i = 1; i < alen; ++i) {
                        acts1 = (ActionItemList)acts1.cons(args[i], c, cm, -2);
                    }
                    return this.enabledUnchanged(args[0], acts1, c, s0, s1, cm);
                }
                return this.enabled(acts, s0, s1, cm);
            }
            if (opcode == 0 && alen == 0) {
                Object val = this.lookup(opNode, c, false);
                if (val instanceof LazyValue) {
                    LazyValue lv = (LazyValue)val;
                    return this.enabledUnchanged(lv.expr, acts, lv.con, s0, s1, cm);
                }
                if (val instanceof OpDefNode) {
                    return this.enabledUnchanged(((OpDefNode)val).getBody(), acts, c, s0, s1, cm);
                }
                if (val == null) {
                    Assert.fail("In computing ENABLED, TLC found the undefined identifier\n" + opName + " in an UNCHANGED expression at\n" + expr);
                }
                return this.enabled(acts, s0, s1, cm);
            }
        }
        if (!(v0 = this.eval(expr, c, s0, TLCState.Empty, 4, cm)).equals(v1 = this.eval(expr, c, s1, TLCState.Empty, 2, cm))) {
            return null;
        }
        return this.enabled(acts, s0, s1, cm);
    }

    @Override
    public final boolean isValid(Action act, TLCState s0, TLCState s1) {
        Value val = this.eval(act.pred, act.con, s0, s1, 0, act.cm);
        if (!(val instanceof BoolValue)) {
            Assert.fail(2215, new String[]{"boolean", act.pred.toString()});
        }
        return ((BoolValue)val).val;
    }

    @Override
    public final boolean isValid(Action act, TLCState state) {
        return this.isValid(act, state, TLCState.Empty);
    }

    @Override
    public final boolean isValid(Action act) {
        return this.isValid(act, TLCState.Empty, TLCState.Empty);
    }

    @Override
    public final boolean isValid(ExprNode expr) {
        IValue val = this.eval(expr, Context.Empty, TLCState.Empty, CostModel.DO_NOT_RECORD);
        if (!(val instanceof BoolValue)) {
            Assert.fail(2215, new String[]{"boolean", expr.toString()});
        }
        return ((BoolValue)val).val;
    }

    @Override
    public final int checkAssumptions() {
        ExprNode[] assumps = this.getAssumptions();
        boolean[] isAxiom = this.getAssumptionIsAxiom();
        for (int i = 0; i < assumps.length; ++i) {
            try {
                if (isAxiom[i] || this.isValid(assumps[i])) continue;
                return MP.printError(2104, assumps[i].toString());
            }
            catch (Exception e) {
                return MP.printError(2105, new String[]{assumps[i].toString(), e.getMessage()});
            }
        }
        return 0;
    }

    @Override
    public final TLCStateInfo getState(long fp) {
        class InitStateSelectorFunctor
        implements IStateFunctor {
            private final long fp;
            public TLCState state;

            public InitStateSelectorFunctor(long fp) {
                this.fp = fp;
            }

            @Override
            public Object addElement(TLCState state) {
                if (state == null) {
                    return null;
                }
                if (this.state != null) {
                    return null;
                }
                if (this.fp == state.fingerPrint()) {
                    this.state = state;
                }
                return null;
            }
        }
        InitStateSelectorFunctor functor = new InitStateSelectorFunctor(fp);
        this.getInitStates(functor);
        if (functor.state != null) {
            String info = "<Initial predicate>";
            TLCStateInfo tlcStateInfo = new TLCStateInfo(functor.state, "<Initial predicate>", 1, fp);
            return tlcStateInfo;
        }
        return null;
    }

    @Override
    public final TLCStateInfo getState(long fp, TLCStateInfo sinfo) {
        TLCStateInfo tlcStateInfo = this.getState(fp, sinfo.state);
        if (tlcStateInfo == null) {
            throw new EvalException(2117);
        }
        tlcStateInfo.stateNumber = sinfo.stateNumber + 1L;
        tlcStateInfo.predecessorState = sinfo;
        tlcStateInfo.fp = fp;
        return tlcStateInfo;
    }

    @Override
    public final TLCStateInfo getState(long fp, TLCState s) {
        IdThread.setCurrentState(s);
        for (int i = 0; i < this.actions.length; ++i) {
            Action curAction = this.actions[i];
            StateVec nextStates = this.getNextStates(curAction, s);
            for (int j = 0; j < nextStates.size(); ++j) {
                TLCState state = nextStates.elementAt(j);
                long nfp = state.fingerPrint();
                if (fp != nfp) continue;
                state.setPredecessor(s);
                return new TLCStateInfo(state, curAction.getLocation());
            }
        }
        return null;
    }

    @Override
    public final TLCStateInfo getState(TLCState s1, TLCState s) {
        IdThread.setCurrentState(s);
        for (int i = 0; i < this.actions.length; ++i) {
            Action curAction = this.actions[i];
            StateVec nextStates = this.getNextStates(curAction, s);
            for (int j = 0; j < nextStates.size(); ++j) {
                TLCState state = nextStates.elementAt(j);
                if (!s1.equals(state)) continue;
                state.setPredecessor(s);
                return new TLCStateInfo(state, curAction.getLocation());
            }
        }
        return null;
    }

    @Override
    public final IMVPerm[] getSymmetryPerms() {
        IMVPerm[] subgroup;
        OpDefNode opDef;
        IValue fcns;
        String name = this.config.getSymmetry();
        if (name.length() == 0) {
            return null;
        }
        Object symm = this.unprocessedDefns.get(name);
        if (symm == null) {
            Assert.fail(2229, new String[]{"symmetry function", name});
        }
        if (!(symm instanceof OpDefNode)) {
            Assert.fail("The symmetry function " + name + " must specify a set of permutations.");
        }
        if (!((fcns = this.eval((opDef = (OpDefNode)symm).getBody(), Context.Empty, TLCState.Empty, CostModel.DO_NOT_RECORD)) instanceof Enumerable) || !(fcns instanceof SetEnumValue)) {
            Assert.fail("The symmetry operator must specify a set of functions.");
        }
        List<Value> values = ((SetEnumValue)fcns).elements().all();
        for (Value v : values) {
            if (v instanceof FcnRcdValue) continue;
            Assert.fail("The symmetry values must be function records.");
        }
        ExprOrOpArgNode[] argNodes = ((OpApplNode)opDef.getBody()).getArgs();
        StringBuilder cardinalityOneSetList = new StringBuilder();
        int offenderCount = 0;
        if (argNodes.length >= values.size()) {
            for (ExprOrOpArgNode node : argNodes) {
                this.addToSubTwoSizedSymmetrySetList(node, cardinalityOneSetList);
                ++offenderCount;
            }
        }
        if (offenderCount == 0) {
            subgroup = MVPerms.permutationSubgroup((Enumerable)fcns);
            HashSet<ModelValue> subgroupMembers = new HashSet<ModelValue>();
            for (IMVPerm imvp : subgroup) {
                if (!(imvp instanceof MVPerm)) continue;
                subgroupMembers.addAll(((MVPerm)imvp).getAllModelValues());
            }
            for (ExprOrOpArgNode node : argNodes) {
                Value v;
                SetEnumValue enumValue = this.getSetEnumValueFromArgumentNode(node);
                if (enumValue == null) continue;
                ValueEnumeration ve = enumValue.elements();
                boolean found = false;
                while ((v = ve.nextElement()) != null) {
                    if (!(v instanceof ModelValue) || !subgroupMembers.contains(v)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.addToSubTwoSizedSymmetrySetList(node, cardinalityOneSetList);
                ++offenderCount;
            }
        } else {
            subgroup = null;
        }
        if (offenderCount > 0) {
            String plurality = offenderCount > 1 ? "s" : "";
            String antiPlurality = offenderCount > 1 ? "" : "s";
            String toHaveConjugation = offenderCount > 1 ? "have" : "has";
            MP.printWarning(2300, plurality, cardinalityOneSetList.toString(), toHaveConjugation, antiPlurality);
        }
        return subgroup;
    }

    private void addToSubTwoSizedSymmetrySetList(ExprOrOpArgNode node, StringBuilder cardinalityOneSetList) {
        String displayDefinition;
        String alias;
        SyntaxTreeNode tn = (SyntaxTreeNode)node.getTreeNode();
        String image = tn.getHumanReadableImage();
        if (image.startsWith("Permutations")) {
            int imageLength = image.length();
            alias = image.substring("Permutations".length() + 1, imageLength - 1);
        } else {
            alias = image;
        }
        String specDefinitionName = this.config.getOverridenSpecNameForConfigName(alias);
        String string = displayDefinition = specDefinitionName != null ? specDefinitionName : alias;
        if (cardinalityOneSetList.length() > 0) {
            cardinalityOneSetList.append(", and ");
        }
        cardinalityOneSetList.append(displayDefinition);
    }

    private SetEnumValue getSetEnumValueFromArgumentNode(ExprOrOpArgNode node) {
        ExprOrOpArgNode[] operands;
        OpDefNode operator;
        OpApplNode permutationNode;
        if (node instanceof OpApplNode && (permutationNode = (OpApplNode)node).getOperator() instanceof OpDefNode && "Permutations".equals((operator = (OpDefNode)permutationNode.getOperator()).getName().toString()) && (operands = permutationNode.getArgs()).length == 1 && operands[0] instanceof OpApplNode && ((OpApplNode)operands[0]).getOperator() instanceof OpDefOrDeclNode) {
            WorkerValue wv;
            Object unwrapped;
            Object o = ((OpDefOrDeclNode)((OpApplNode)operands[0]).getOperator()).getToolObject(toolId);
            if (o instanceof SetEnumValue) {
                return (SetEnumValue)o;
            }
            if (o instanceof WorkerValue && (unwrapped = WorkerValue.mux(wv = (WorkerValue)o)) instanceof SetEnumValue) {
                return (SetEnumValue)unwrapped;
            }
        }
        return null;
    }

    @Override
    public final boolean hasSymmetry() {
        if (this.config == null) {
            return false;
        }
        String name = this.config.getSymmetry();
        return name.length() > 0;
    }

    @Override
    public final Context getFcnContext(IFcnLambdaValue fcn, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control) {
        return this.getFcnContext(fcn, args, c, s0, s1, control, CostModel.DO_NOT_RECORD);
    }

    @Override
    public final Context getFcnContext(IFcnLambdaValue fcn, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        Context fcon = fcn.getCon();
        int plen = fcn.getParams().length();
        FormalParamNode[][] formals = fcn.getParams().getFormals();
        Value[] domains = (Value[])fcn.getParams().getDomains();
        boolean[] isTuples = fcn.getParams().isTuples();
        Value argVal = this.eval(args[1], c, s0, s1, control, cm);
        if (plen == 1) {
            if (!domains[0].member(argVal)) {
                Assert.fail("In applying the function\n" + Values.ppr(fcn.toString()) + ",\nthe first argument is:\n" + Values.ppr(argVal.toString()) + "which is not in its domain.\n" + args[0]);
            }
            if (isTuples[0]) {
                FormalParamNode[] ids = formals[0];
                TupleValue tv = (TupleValue)argVal.toTuple();
                if (tv == null || argVal.size() != ids.length) {
                    Assert.fail("In applying the function\n" + Values.ppr(this.toString()) + ",\nthe argument is:\n" + Values.ppr(argVal.toString()) + "which does not match its formal parameter.\n" + args[0]);
                }
                Value[] elems = tv.elems;
                for (int i = 0; i < ids.length; ++i) {
                    fcon = fcon.cons(ids[i], elems[i]);
                }
            } else {
                fcon = fcon.cons(formals[0][0], argVal);
            }
        } else {
            TupleValue tv = (TupleValue)argVal.toTuple();
            if (tv == null) {
                Assert.fail("Attempted to apply a function to an argument not in its domain.\n" + args[0]);
            }
            int argn = 0;
            Value[] elems = tv.elems;
            for (int i = 0; i < formals.length; ++i) {
                FormalParamNode[] ids = formals[i];
                Value domain = domains[i];
                if (isTuples[i]) {
                    TupleValue tv1;
                    if (!domain.member(elems[argn])) {
                        Assert.fail("In applying the function\n" + Values.ppr(fcn.toString()) + ",\nthe argument number " + (argn + 1) + " is:\n" + Values.ppr(elems[argn].toString()) + "\nwhich is not in its domain.\n" + args[0]);
                    }
                    if ((tv1 = (TupleValue)elems[argn++].toTuple()) == null || tv1.size() != ids.length) {
                        Assert.fail("In applying the function\n" + Values.ppr(fcn.toString()) + ",\nthe argument number " + argn + " is:\n" + Values.ppr(elems[argn - 1].toString()) + "which does not match its formal parameter.\n" + args[0]);
                    }
                    Value[] avals = tv1.elems;
                    for (int j = 0; j < ids.length; ++j) {
                        fcon = fcon.cons(ids[j], avals[j]);
                    }
                    continue;
                }
                for (int j = 0; j < ids.length; ++j) {
                    if (!domain.member(elems[argn])) {
                        Assert.fail("In applying the function\n" + Values.ppr(fcn.toString()) + ",\nthe argument number " + (argn + 1) + " is:\n" + Values.ppr(elems[argn].toString()) + "which is not in its domain.\n" + args[0]);
                    }
                    fcon = fcon.cons(ids[j], elems[argn++]);
                }
            }
        }
        return fcon;
    }

    @Override
    public final IContextEnumerator contexts(OpApplNode appl, Context c, TLCState s0, TLCState s1, int control) {
        return this.contexts(appl, c, s0, s1, control, CostModel.DO_NOT_RECORD);
    }

    public final ContextEnumerator contexts(OpApplNode appl, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        FormalParamNode[][] formals = appl.getBdedQuantSymbolLists();
        boolean[] isTuples = appl.isBdedQuantATuple();
        ExprNode[] domains = appl.getBdedQuantBounds();
        int flen = formals.length;
        int alen = 0;
        for (int i = 0; i < flen; ++i) {
            alen += isTuples[i] ? 1 : formals[i].length;
        }
        Object[] vars = new Object[alen];
        ValueEnumeration[] enums = new ValueEnumeration[alen];
        int idx = 0;
        for (int i = 0; i < flen; ++i) {
            Value boundSet = this.eval(domains[i], c, s0, s1, control, cm);
            if (!(boundSet instanceof Enumerable)) {
                Assert.fail("TLC encountered a non-enumerable quantifier bound\n" + Values.ppr(boundSet.toString()) + ".\n" + domains[i]);
            }
            FormalParamNode[] farg = formals[i];
            if (isTuples[i]) {
                vars[idx] = farg;
                enums[idx++] = ((Enumerable)((Object)boundSet)).elements();
                continue;
            }
            for (int j = 0; j < farg.length; ++j) {
                vars[idx] = farg[j];
                enums[idx++] = ((Enumerable)((Object)boundSet)).elements();
            }
        }
        return new ContextEnumerator(vars, enums, c);
    }

    @Override
    public Context getOpContext(OpDefNode odn, ExprOrOpArgNode[] args, Context ctx, boolean b) {
        return this.getOpContext(odn, args, ctx, b, toolId);
    }

    @Override
    public Object lookup(SymbolNode opNode, Context con, boolean b) {
        return this.lookup(opNode, con, b, toolId);
    }

    @Override
    public Object getVal(ExprOrOpArgNode expr, Context con, boolean b) {
        return this.getVal(expr, con, b, toolId);
    }
}

