/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import tla2sany.semantic.SemanticNode;
import tla2sany.st.Location;

public class CallStack {
    private SemanticNode[] stack = new SemanticNode[64];
    private int index = 0;
    private boolean frozen;

    public final void push(SemanticNode expr) {
        if (this.index == this.stack.length) {
            this.resize();
        }
        this.stack[this.index++] = expr;
    }

    public final void pop() {
        if (!this.frozen) {
            --this.index;
        }
    }

    public void freeze() {
        this.frozen = true;
    }

    public final int size() {
        return this.index;
    }

    private final void resize() {
        int len = 2 * this.stack.length;
        SemanticNode[] stack1 = new SemanticNode[len];
        System.arraycopy(this.stack, 0, stack1, 0, this.stack.length);
        this.stack = stack1;
    }

    public final String toString() {
        if (this.index > 0) {
            StringBuffer sb = new StringBuffer();
            SemanticNode expr = null;
            int stackDepth = 0;
            for (int i = 0; i < this.index; ++i) {
                if (expr == this.stack[i]) continue;
                expr = this.stack[i];
                Location loc = expr.getTreeNode().getLocation();
                sb.append(stackDepth + ". ");
                sb.append("Line ");
                sb.append(loc.beginLine());
                sb.append(", column ");
                sb.append(loc.beginColumn());
                sb.append(" to line ");
                sb.append(loc.endLine());
                sb.append(", column ");
                sb.append(loc.endColumn());
                sb.append(" in ");
                sb.append(loc.source() + "\n");
                ++stackDepth;
            }
            sb.append("\n");
            return sb.toString();
        }
        return "    The error call stack is empty.\n";
    }
}

