/*
 * Decompiled with CFR 0.152.
 */
package tlc2.output;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import tlc2.model.Assignment;
import tlc2.model.Formula;
import tlc2.model.MCState;
import tlc2.model.MCVariable;
import tlc2.model.TraceExpressionInformationHolder;
import tlc2.output.AbstractSpecWriter;
import tlc2.output.SpecWriterUtilities;

public class SpecTraceExpressionWriter
extends AbstractSpecWriter {
    private static final String TRACE_EXPRESSION_VARIABLE = "TraceExp";
    private static final String TRI_INDENT = "            ";

    public static String[] addInitNextToBuffers(StringBuilder tlaBuffer, StringBuilder cfgBuffer, List<MCState> trace, TraceExpressionInformationHolder[] expressionData) {
        String initId = SpecWriterUtilities.getValidIdentifier("init");
        String nextId = SpecWriterUtilities.getValidIdentifier("next");
        String actionConstraintId = SpecWriterUtilities.getValidIdentifier("action_constr");
        SpecTraceExpressionWriter.addInitNextToBuffers(tlaBuffer, cfgBuffer, trace, expressionData, initId, nextId, actionConstraintId);
        return new String[]{initId, nextId, actionConstraintId};
    }

    public static void addInitNextToBuffers(StringBuilder tlaBuffer, StringBuilder cfgBuffer, List<MCState> trace, TraceExpressionInformationHolder[] expressionData, String initId, String nextId, String actionConstraintId) {
        SpecTraceExpressionWriter.addInitNextToBuffers(tlaBuffer, cfgBuffer, trace, expressionData, initId, nextId, actionConstraintId, "next", false);
    }

    public static void addInitNextToBuffers(StringBuilder tlaBuffer, StringBuilder cfgBuffer, List<MCState> trace, TraceExpressionInformationHolder[] expressionData, String initId, String nextId, String actionConstraintId, String nextSubActionBasename, boolean leaveStubsForTraceExpression) {
        StringBuilder[] tlaBuffers = SpecTraceExpressionWriter.addInitNextToBuffers(cfgBuffer, trace, expressionData, initId, nextId, actionConstraintId, nextSubActionBasename, leaveStubsForTraceExpression);
        tlaBuffer.append(tlaBuffers[0].toString());
        tlaBuffer.append(tlaBuffers[1].toString());
    }

    public static StringBuilder[] addInitNextToBuffers(StringBuilder cfgBuffer, List<MCState> trace, TraceExpressionInformationHolder[] expressionData, String initId, String nextId, String actionConstraintId, String nextSubActionBasename, boolean leaveStubsForTraceExpression) {
        if (trace.size() > 0) {
            String firstIndent;
            boolean isSingleState;
            MCState nextState;
            int i;
            Iterator<MCState> it = trace.iterator();
            MCState currentState = it.next();
            StringBuilder subActionsAndConstraint = new StringBuilder();
            StringBuilder initAndNext = new StringBuilder();
            if (cfgBuffer != null) {
                cfgBuffer.append("\\* ").append("INIT").append(" definition");
                cfgBuffer.append("\n").append("INIT").append("\n");
                cfgBuffer.append(initId).append("\n");
            }
            if (leaveStubsForTraceExpression) {
                initAndNext.append("\\* ").append("VARIABLE").append(' ');
                initAndNext.append(TRACE_EXPRESSION_VARIABLE).append("\n").append("\n");
            }
            initAndNext.append("\\* ").append("TRACE INIT definition ");
            initAndNext.append("traceExploreInit").append("\n");
            initAndNext.append(initId).append(" ==\n");
            MCVariable[] vars = currentState.getVariables();
            for (i = 0; i < vars.length; ++i) {
                MCVariable var = vars[i];
                initAndNext.append("    /\\ ");
                initAndNext.append(var.getName()).append(" = ").append("(");
                initAndNext.append("\n");
                initAndNext.append(var.getValueAsStringReIndentedAs(TRI_INDENT)).append("\n");
                initAndNext.append("    ").append("    ");
                initAndNext.append(")").append("\n");
            }
            if (expressionData != null) {
                for (i = 0; i < expressionData.length; ++i) {
                    TraceExpressionInformationHolder expressionInfo = expressionData[i];
                    initAndNext.append("    /\\ ");
                    initAndNext.append(expressionInfo.getVariableName()).append(" = ");
                    initAndNext.append("(").append("\n");
                    initAndNext.append(TRI_INDENT);
                    if (expressionInfo.getLevel() == 2) {
                        initAndNext.append("\"--\"");
                    } else {
                        initAndNext.append(expressionInfo.getIdentifier());
                    }
                    initAndNext.append("\n").append("    ").append("    ");
                    initAndNext.append(")").append("\n");
                }
            }
            if (leaveStubsForTraceExpression) {
                initAndNext.append("\\* ").append("    /\\ ");
                initAndNext.append(TRACE_EXPRESSION_VARIABLE).append(" = ");
                initAndNext.append("TRUE").append("\n");
            }
            initAndNext.append("\n----\n").append("\n");
            if (cfgBuffer != null) {
                cfgBuffer.append("\\* ").append("NEXT").append(" definition");
                cfgBuffer.append("\n").append("NEXT").append("\n");
                cfgBuffer.append(nextId).append("\n");
            }
            if (it.hasNext()) {
                nextState = it.next();
                isSingleState = false;
            } else {
                nextState = currentState;
                isSingleState = true;
            }
            StringBuilder nextDisjunctBuffer = new StringBuilder();
            nextDisjunctBuffer.append(nextId).append(" ==\n");
            if (leaveStubsForTraceExpression) {
                nextDisjunctBuffer.append("/\\").append(' ');
                firstIndent = " ";
            } else {
                firstIndent = "    ";
            }
            StringBuilder actionConstraintBuffer = new StringBuilder();
            actionConstraintBuffer.append(actionConstraintId).append(" ==\n");
            actionConstraintBuffer.append("<<").append("\n");
            if (cfgBuffer != null) {
                cfgBuffer.append("\\* ").append("Action Constraint definition").append("\n");
                cfgBuffer.append("\\* ").append("ACTION_CONSTRAINT").append("\n");
                cfgBuffer.append("\\* ").append(actionConstraintId).append("\n");
            }
            int subActionIndex = 0;
            while (nextState != null) {
                int i2;
                String nextDisjunct = String.format("%s_sa_%d", nextSubActionBasename, subActionIndex);
                nextDisjunctBuffer.append(subActionIndex == 0 ? firstIndent : "    ");
                nextDisjunctBuffer.append("\\/").append(' ').append(nextDisjunct).append("\n");
                actionConstraintBuffer.append(nextDisjunct);
                subActionsAndConstraint.append("\\* ").append("TRACE Sub-Action definition ");
                subActionsAndConstraint.append(subActionIndex++).append("\n");
                subActionsAndConstraint.append(nextDisjunct).append(" ==\n");
                if (nextState.isBackToState()) {
                    nextState = trace.get(nextState.getStateNumber() - 1);
                } else if (nextState.isStuttering()) {
                    nextState = currentState;
                }
                subActionsAndConstraint.append("    ").append("(").append("\n");
                MCVariable[] currentStateVars = currentState.getVariables();
                MCVariable[] nextStateVars = nextState.getVariables();
                for (i2 = 0; i2 < currentStateVars.length; ++i2) {
                    MCVariable currentStateVar = currentStateVars[i2];
                    subActionsAndConstraint.append("    ").append("    /\\ ");
                    subActionsAndConstraint.append(currentStateVar.getName()).append(" = ");
                    subActionsAndConstraint.append("(").append("\n");
                    subActionsAndConstraint.append(currentStateVar.getValueAsStringReIndentedAs("                "));
                    subActionsAndConstraint.append("\n");
                    subActionsAndConstraint.append(TRI_INDENT).append(")").append("\n");
                }
                if (isSingleState) {
                    subActionsAndConstraint.append("    ").append("    /\\ ");
                    subActionsAndConstraint.append("FALSE").append("\n");
                }
                for (i2 = 0; i2 < currentStateVars.length; ++i2) {
                    MCVariable nextStateVar = nextStateVars[i2];
                    subActionsAndConstraint.append("    ").append("    /\\ ");
                    subActionsAndConstraint.append(nextStateVar.getName()).append("'");
                    subActionsAndConstraint.append(" = ").append("(").append("\n");
                    subActionsAndConstraint.append(nextStateVar.getValueAsStringReIndentedAs("                "));
                    subActionsAndConstraint.append("\n");
                    subActionsAndConstraint.append(TRI_INDENT).append(")").append("\n");
                }
                if (expressionData != null) {
                    for (i2 = 0; i2 < expressionData.length; ++i2) {
                        TraceExpressionInformationHolder expressionInfo = expressionData[i2];
                        subActionsAndConstraint.append("    ").append("    /\\ ");
                        subActionsAndConstraint.append(expressionInfo.getVariableName()).append("'");
                        subActionsAndConstraint.append(" = ").append("(").append("\n");
                        subActionsAndConstraint.append(TRI_INDENT);
                        subActionsAndConstraint.append(expressionInfo.getIdentifier()).append("\n");
                        subActionsAndConstraint.append(TRI_INDENT).append(")");
                        if (expressionInfo.getLevel() < 2) {
                            subActionsAndConstraint.append("'");
                        }
                        subActionsAndConstraint.append("\n");
                    }
                }
                subActionsAndConstraint.append("    ").append(")");
                subActionsAndConstraint.append("\n").append("\n");
                if (it.hasNext()) {
                    actionConstraintBuffer.append(",");
                }
                actionConstraintBuffer.append("\n");
                currentState = nextState;
                if (it.hasNext()) {
                    nextState = it.next();
                    continue;
                }
                nextState = null;
            }
            initAndNext.append("\\* ").append("TRACE NEXT definition ");
            initAndNext.append("traceExploreNext").append("\n");
            initAndNext.append(nextDisjunctBuffer.toString());
            if (leaveStubsForTraceExpression) {
                initAndNext.append("\\* ").append("/\\").append(' ');
                initAndNext.append(TRACE_EXPRESSION_VARIABLE).append("'").append(" = ");
                initAndNext.append(TRACE_EXPRESSION_VARIABLE).append("\n");
            }
            initAndNext.append("\n").append("\n");
            subActionsAndConstraint.append("\\* ").append("TRACE Action Constraint definition ");
            subActionsAndConstraint.append("traceExploreActionConstraint");
            subActionsAndConstraint.append("\n").append(actionConstraintBuffer.toString());
            subActionsAndConstraint.append(">>").append("[TLCGet(\"level\")]");
            subActionsAndConstraint.append("\n----\n").append("\n");
            return new StringBuilder[]{subActionsAndConstraint, initAndNext};
        }
        return null;
    }

    public static void addTraceFunctionToBuffers(StringBuilder tlaBuffer, StringBuilder cfgBuffer, List<MCState> input) {
        List trace = input.stream().filter(state -> !state.isBackToState() && !state.isStuttering()).collect(Collectors.toList());
        if (trace.isEmpty()) {
            return;
        }
        StringBuilder traceFunctionDef = new StringBuilder();
        traceFunctionDef.append("<<").append("\n");
        for (int j = 0; j < trace.size(); ++j) {
            MCState state2 = (MCState)trace.get(j);
            traceFunctionDef.append("(").append(state2.asSimpleRecord()).append(")");
            if (j >= trace.size() - 1) continue;
            traceFunctionDef.append(",").append("\n");
        }
        traceFunctionDef.append("\n").append(">>");
        traceFunctionDef.append("\n----\n").append("\n");
        SpecTraceExpressionWriter.addArrowAssignmentToBuffers(tlaBuffer, cfgBuffer, new Assignment("_TETrace", new String[0], traceFunctionDef.toString()), "def_ov");
    }

    public SpecTraceExpressionWriter() {
        super(true);
    }

    public TraceExpressionInformationHolder[] createAndAddVariablesAndDefinitions(List<Formula> expressions, String attributeName) {
        TraceExpressionInformationHolder[] expressionData = TraceExpressionInformationHolder.createHolders(expressions, attributeName);
        this.addVariablesAndDefinitions(expressionData, attributeName, true);
        return expressionData;
    }

    @Override
    public void addPrimer(String moduleFilename, String extendedModuleName) {
        this.addPrimer(moduleFilename, extendedModuleName, new HashSet<String>());
    }

    public void addPrimer(String moduleFilename, String extendedModuleName, Set<String> extraExtendedModules) {
        if (extendedModuleName != null) {
            extraExtendedModules.add(extendedModuleName);
        }
        extraExtendedModules.add("TLC");
        extraExtendedModules.add("Toolbox");
        this.tlaBuffer.append((CharSequence)SpecWriterUtilities.getExtendingModuleContent(moduleFilename, extraExtendedModules.toArray(new String[extraExtendedModules.size()])));
    }

    public void addVariablesAndDefinitions(TraceExpressionInformationHolder[] traceExpressionData, String attributeName, boolean addDefinitions) {
        if (traceExpressionData.length == 0) {
            return;
        }
        StringBuilder variableDecls = new StringBuilder();
        StringBuilder definitions = new StringBuilder();
        for (int i = 0; i < traceExpressionData.length; ++i) {
            TraceExpressionInformationHolder expressionInfo = traceExpressionData[i];
            variableDecls.append(expressionInfo.getVariableName());
            if (i != traceExpressionData.length - 1) {
                variableDecls.append(",");
            }
            if (!addDefinitions) continue;
            definitions.append("\\* ").append("TRACE EXPLORER identifier definition ");
            definitions.append("@").append(attributeName).append(":");
            definitions.append(i).append("\n");
            definitions.append(expressionInfo.getIdentifier()).append(" ==\n");
            definitions.append(expressionInfo.getExpression()).append("\n----\n").append("\n");
        }
        this.tlaBuffer.append("\\* ").append("TRACE EXPLORER variable declaration ");
        this.tlaBuffer.append("@").append(attributeName).append("\n");
        this.tlaBuffer.append("VARIABLES ").append(variableDecls.toString()).append("\n----\n").append("\n");
        if (addDefinitions) {
            this.tlaBuffer.append(definitions.toString());
        }
    }

    public void addInvariant(MCState finalState) {
        String id = SpecWriterUtilities.getValidIdentifier("inv");
        this.cfgBuffer.append("\\* ").append("INVARIANT").append(" definition");
        this.cfgBuffer.append("\n").append("INVARIANT").append("\n");
        this.cfgBuffer.append(id).append("\n");
        this.tlaBuffer.append("\\* ").append("INVARIANT").append(" definition");
        this.tlaBuffer.append("\n").append(id).append(" ==\n");
        this.tlaBuffer.append("~").append("(").append("\n");
        this.tlaBuffer.append(SpecTraceExpressionWriter.getStateConjunction(finalState)).append("\n").append(")");
        this.tlaBuffer.append("\n----\n").append("\n");
    }

    public void addStutteringProperty(MCState finalState) {
        String id = SpecWriterUtilities.getValidIdentifier("prop");
        this.cfgBuffer.append("\\* ").append("PROPERTY").append(" definition");
        this.cfgBuffer.append("\n").append("PROPERTY").append("\n");
        this.cfgBuffer.append(id).append("\n");
        this.tlaBuffer.append("\\* ").append("PROPERTY").append(" definition");
        this.tlaBuffer.append("\n").append(id).append(" ==\n");
        this.tlaBuffer.append("~").append("<>[]");
        this.tlaBuffer.append("(").append("\n").append(SpecTraceExpressionWriter.getStateConjunction(finalState));
        this.tlaBuffer.append("\n").append(")").append("\n----\n").append("\n");
    }

    public void addBackToStateProperty(MCState finalState, MCState backToState) {
        String id = SpecWriterUtilities.getValidIdentifier("prop");
        this.cfgBuffer.append("\\* ").append("PROPERTY").append(" definition");
        this.cfgBuffer.append("\n").append("PROPERTY").append("\n");
        this.cfgBuffer.append(id).append("\n");
        this.tlaBuffer.append("\\* ").append("PROPERTY").append(" definition");
        this.tlaBuffer.append("\n").append(id).append(" ==\n");
        this.tlaBuffer.append("~").append("(").append("(");
        this.tlaBuffer.append("[]<>").append("(").append("\n");
        this.tlaBuffer.append(SpecTraceExpressionWriter.getStateConjunction(finalState)).append("\n").append(")");
        this.tlaBuffer.append(")").append("/\\").append("(");
        this.tlaBuffer.append("[]<>").append("(").append("\n");
        this.tlaBuffer.append(SpecTraceExpressionWriter.getStateConjunction(backToState)).append("\n").append(")");
        this.tlaBuffer.append(")").append(")").append("\n----\n").append("\n");
    }

    public void addInfoComments(TraceExpressionInformationHolder[] traceExpressionData) {
        for (TraceExpressionInformationHolder expressionData : traceExpressionData) {
            this.tlaBuffer.append("\\* ").append(":").append(expressionData.getLevel());
            this.tlaBuffer.append(":").append(expressionData.getVariableName()).append(":");
            this.tlaBuffer.append(expressionData.getExpression()).append("\"$!@$!@$!@$!@$!\"");
            this.tlaBuffer.append("\n");
        }
    }

    public String[] addInitNext(List<MCState> trace, TraceExpressionInformationHolder[] expressionData) {
        return SpecTraceExpressionWriter.addInitNextToBuffers(this.tlaBuffer, this.cfgBuffer, trace, expressionData);
    }

    public void addInitNext(List<MCState> trace, TraceExpressionInformationHolder[] expressionData, String initId, String nextId, String actionConstraintId) {
        SpecTraceExpressionWriter.addInitNextToBuffers(this.tlaBuffer, this.cfgBuffer, trace, expressionData, initId, nextId, actionConstraintId);
    }

    public void addInitNext(List<MCState> trace, TraceExpressionInformationHolder[] expressionData, String initId, String nextId, String actionConstraintId, String nextSubActionBasename) {
        SpecTraceExpressionWriter.addInitNextToBuffers(this.tlaBuffer, this.cfgBuffer, trace, expressionData, initId, nextId, actionConstraintId, nextSubActionBasename, true);
    }

    public void addTraceFunction(List<MCState> input) {
        SpecTraceExpressionWriter.addTraceFunctionToBuffers(this.tlaBuffer, this.cfgBuffer, input);
    }

    private static String getStateConjunction(MCState state) {
        if (state.isBackToState()) {
            return null;
        }
        if (state.isStuttering()) {
            return null;
        }
        StringBuilder formula = new StringBuilder();
        MCVariable[] vars = state.getVariables();
        for (int i = 0; i < vars.length; ++i) {
            MCVariable var = vars[i];
            formula.append(var.getName()).append(" = ").append("(").append("\n");
            formula.append(var.getValueAsString()).append("\n").append(")");
            if (i == vars.length - 1) continue;
            formula.append("/\\").append("\n");
        }
        return formula.toString();
    }
}

