/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import tlc2.tool.AbstractChecker;
import tlc2.tool.Simulator;

public class TLCGlobals {
    public static final int DEFAULT_CHECKPOINT_DURATION = 1800042;
    public static String versionOfTLC = "Version 2.17 of 02 February 2022";
    public static int enumBound = 2000;
    public static int setBound = 1000000;
    private static int numWorkers = 1;
    public static double livenessThreshold = 0.1;
    public static double livenessGraphSizeThreshold = 0.1;
    public static double livenessRatio = 0.2;
    public static String lnCheck = "default";
    public static AbstractChecker mainChecker = null;
    public static Simulator simulator = null;
    public static final char coverageIndent = '|';
    public static int coverageInterval = -1;
    public static int DFIDMax = -1;
    public static boolean continuation = false;
    public static boolean printDiffsOnly = false;
    public static boolean warn = true;
    public static final int progressInterval = 60000;
    public static long chkptDuration = Integer.getInteger(TLCGlobals.class.getName() + ".chkpt", 1800042).intValue();
    private static boolean forceChkpt = false;
    private static long lastChkpt = System.currentTimeMillis();
    public static final String metaRoot = "states";
    public static String metaDir = null;
    public static boolean useView = false;
    public static boolean useGZIP = false;
    public static boolean debug = false;
    public static boolean tool = false;
    public static boolean expand = true;

    public static boolean doLiveness() {
        return !lnCheck.equals("final") && !lnCheck.equals("seqfinal");
    }

    public static boolean doSequentialLiveness() {
        return lnCheck.startsWith("seq");
    }

    public static synchronized void setNumWorkers(int n) {
        numWorkers = n;
    }

    public static synchronized int getNumWorkers() {
        return numWorkers;
    }

    public static synchronized void incNumWorkers(int n) {
        numWorkers += n;
    }

    public static void incNumWorkers() {
        TLCGlobals.incNumWorkers(1);
    }

    public static void decNumWorkers() {
        TLCGlobals.incNumWorkers(-1);
    }

    public static final boolean isCoverageEnabled() {
        return coverageInterval >= 0;
    }

    public static void forceChkpt() {
        forceChkpt = true;
    }

    public static boolean chkptExplicitlyEnabled() {
        return chkptDuration > 0L && chkptDuration != 1800042L;
    }

    public static boolean doCheckPoint() {
        if (forceChkpt) {
            forceChkpt = false;
            return true;
        }
        if (chkptDuration == 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - lastChkpt >= chkptDuration) {
            lastChkpt = now;
            return true;
        }
        return false;
    }

    public static boolean isValidSetSize(int bound) {
        return bound >= 1;
    }

    public static String getRevision() {
        try {
            Enumeration<URL> resources = TLCGlobals.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                Attributes attributes = manifest.getMainAttributes();
                if (!"TLA+ Tools".equals(attributes.getValue("Implementation-Title"))) continue;
                if (attributes.getValue("X-Git-ShortRevision") != null) {
                    return attributes.getValue("X-Git-ShortRevision");
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getRevisionOrDev() {
        return TLCGlobals.getRevision() == null ? "development" : TLCGlobals.getRevision();
    }
}

