/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import tla2tex.CommentToken;
import tla2tex.Debug;
import tla2tex.Misc;
import tla2tex.OutputFileWriter;
import tla2tex.Position;
import tla2tex.Token;

public class WriteTLAFile {
    public static void Write(Token[][] spec, String fileName) {
        OutputFileWriter writer = new OutputFileWriter(fileName);
        boolean deleting = false;
        int multiBelow = 0;
        for (int line = 0; line < spec.length; ++line) {
            String outLine = "";
            boolean nullComment = false;
            block13: for (int item = 0; item < spec[line].length; ++item) {
                Token tok = spec[line][item];
                outLine = item > 0 ? outLine + WriteTLAFile.SpacesString(tok.column - spec[line][item - 1].column - spec[line][item - 1].getWidth()) : outLine + WriteTLAFile.SpacesString(tok.column);
                switch (tok.type) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 12: 
                    case 13: {
                        outLine = outLine + tok.string;
                        continue block13;
                    }
                    case 3: {
                        outLine = outLine + "\"" + tok.string + "\"";
                        continue block13;
                    }
                    case 5: {
                        CommentToken ctok = (CommentToken)tok;
                        if (ctok.subtype == 7) {
                            deleting = false;
                            multiBelow = 0;
                        }
                        String commentString = "";
                        if (ctok.subtype == 8 || ctok.subtype == 9) {
                            CommentToken bctok;
                            Token btok;
                            Position bpos;
                            for (int i = 0; ctok != null && i < multiBelow; ++i) {
                                bpos = ctok.belowAlign;
                                ctok = null;
                                if (bpos.line == -1) continue;
                                btok = bpos.toToken(spec);
                                if (btok.type != 5) continue;
                                bctok = (CommentToken)btok;
                                if (bctok.subtype != 8 && bctok.subtype != 9) continue;
                                ctok = bctok;
                            }
                            if (ctok != null) {
                                commentString = ctok.string;
                                if (deleting) {
                                    commentString = "`^" + commentString;
                                }
                                deleting = WriteTLAFile.UnmatchedDelete(commentString);
                                commentString = WriteTLAFile.RemoveDeletions(commentString);
                                while (deleting && ctok != null && Misc.isBlank(commentString)) {
                                    bpos = ctok.belowAlign;
                                    ctok = null;
                                    if (bpos.line == -1) continue;
                                    btok = bpos.toToken(spec);
                                    if (btok.type != 5) continue;
                                    bctok = (CommentToken)btok;
                                    if (bctok.subtype != 8 && bctok.subtype != 9) continue;
                                    ctok = bctok;
                                    ++multiBelow;
                                    commentString = ctok.string;
                                    deleting = WriteTLAFile.UnmatchedDelete("`^" + commentString);
                                    commentString = WriteTLAFile.RemoveDeletions("`^" + commentString);
                                }
                            }
                            if (ctok != null && Misc.isBlank(commentString)) {
                                commentString = WriteTLAFile.SpacesString(ctok.string.length());
                            }
                        } else {
                            commentString = WriteTLAFile.RemoveDeletions(ctok.string);
                            commentString = commentString + WriteTLAFile.SpacesString(ctok.string.length() - commentString.length());
                        }
                        if (ctok != null) {
                            commentString = WriteTLAFile.ReplaceQuoteTildes(commentString);
                            switch (ctok.rsubtype) {
                                case 1: {
                                    outLine = outLine + "(*" + commentString + "*)";
                                    continue block13;
                                }
                                case 2: {
                                    outLine = outLine + "\\*" + commentString;
                                    continue block13;
                                }
                                case 3: {
                                    outLine = outLine + "(*" + commentString;
                                    continue block13;
                                }
                                case 4: {
                                    outLine = outLine + commentString + "*)";
                                    continue block13;
                                }
                                case 5: {
                                    outLine = outLine + commentString;
                                    continue block13;
                                }
                            }
                            Debug.ReportBug("Bad CommentToken subtype found.");
                            continue block13;
                        }
                        nullComment = true;
                        continue block13;
                    }
                    default: {
                        Debug.ReportBug("Bad token type found.");
                    }
                }
            }
            if (nullComment && spec[line].length == 1) continue;
            writer.putLine(outLine);
        }
        writer.close();
    }

    private static String SpacesString(int n) {
        String result = "";
        for (int i = 0; i < n; ++i) {
            result = result + " ";
        }
        return result;
    }

    private static boolean UnmatchedDelete(String str) {
        return str.lastIndexOf("^'") < str.lastIndexOf("`^");
    }

    private static String RemoveDeletions(String str) {
        String rest = str;
        String start = "";
        int nextDel = rest.indexOf("`^");
        while (nextDel != -1) {
            start = start + rest.substring(0, nextDel);
            int nextEnd = (rest = rest.substring(nextDel)).indexOf("^'");
            if (nextEnd == -1) {
                nextDel = -1;
                rest = "";
                continue;
            }
            rest = rest.substring(nextEnd + 2);
            nextDel = rest.indexOf("`^");
        }
        return start + rest;
    }

    private static String ReplaceQuoteTildes(String str) {
        String result = str;
        int nextRepl = result.indexOf("`~");
        while (nextRepl != -1) {
            result = result.substring(0, nextRepl) + "  " + result.substring(nextRepl + 2);
            nextRepl = result.indexOf("`~");
        }
        nextRepl = result.indexOf("~'");
        while (nextRepl != -1) {
            result = result.substring(0, nextRepl) + "  " + result.substring(nextRepl + 2);
            nextRepl = result.indexOf("~'");
        }
        nextRepl = result.indexOf("`.");
        while (nextRepl != -1) {
            result = result.substring(0, nextRepl) + "  " + result.substring(nextRepl + 2);
            nextRepl = result.indexOf("`.");
        }
        nextRepl = result.indexOf(".'");
        while (nextRepl != -1) {
            result = result.substring(0, nextRepl) + "  " + result.substring(nextRepl + 2);
            nextRepl = result.indexOf(".'");
        }
        return result;
    }
}

